#include <config.h>

#include "gtklp.h"

#include <stdio.h>
#include <cups/cups.h>
#include <cups/language.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#include <libgtklp.h>

#include <defaults.h>
#include <gettext.h>

#include "file.h"
#include "general.h"
#include "gtklp_functions.h"
#include "gtklptab.h"
#include "hpgl2.h"
#include "image.h"
#include "output.h"
#include "ppd.h"
#include "special.h"
#include "text.h"

GtkWidget *tabs;
unsigned char Range[MAXRANGEENTRY+1];
unsigned char JobName[MAX_JOB_NAME_LENGTH+1];
unsigned char ExtraOpt[MAX_EXTRAOPT+1];
int ignore_stdin;
int clearfilelist,exitonprint;
int saveonexit,rememberprinter,remembertab,tabtoopen;
int viewable[6];
int hpgl2black,hpgl2fit;
unsigned hpgl2pen;
int wantraw;
int needFileSelection;
int ImagePos[2];
int imageScalingType;
double imageScalingScalingValue;
double imageScalingNaturalValue;
double imageScalingPPIValue;
int sheetsType;
int builtin;
int wantRange;
int rangeType;
int wantLandscape;
int ReallyPrint;
int NumberOfCopies;
int prettyprint;
int imagescaling;
int wantimagescaling;
int imageppi;
int wantimageppi;
int imagenatural;
int wantimagenatural;
double hue;
double sat;
int cmdNumCopies;
int jobidonexit;
int wantconst;
double brightness;
double gamma;
unsigned int cppvalue,lpivalue,cpivalue;
unsigned int topmargin, bottommargin, leftmargin, rightmargin;
int MediaSizeSelected, MediaTypeSelected, MediaSourceSelected;
unsigned char filesToPrint[MAXPRINTFILES][MAXPATH+1];
unsigned char filesToPrintAnz;
unsigned char fileOpenPath[MAXPATH+1];
unsigned char confdir[MAXPATH+1];
unsigned char GTKLPRC[MAXPATH+1],HELP_HOME[MAXPATH+1];
unsigned char BROWSER[MAXPATH+1];
unsigned char HELPURL[MAXPATH+1];
char PortString[MAX_PORT+11];
int hasAskedPWD;
ppd_file_t *printerPPD;
int PPDopen;
char *PPDfilename;
int conflict_active;

int num_commandline_opts;
cups_option_t *commandline_opts;


int main(int argc,char *argv[])
{
	GtkWidget *mainVBox = NULL,*waitLabel = NULL;
        GtkWidget *buttonBox,*buttonPrint,*buttonAbbruch,*buttonReset,*buttonSave;
	int i1;
	unsigned char Path[MAXPATH+1];
	char *z1;
	char tmpenv[MAX_SERVER_NAME+13];

	ignore_stdin=0;
	printerPPD=NULL;
	PPDopen=0;
	PPDfilename=NULL;

	conflict_active=0;

	BROWSER[0]=(char)NULL;
	HELPURL[0]=(char)NULL;

	nox=noX();

	num_commandline_opts=0;
	commandline_opts=NULL;

	/*--- Get Programm Options ---*/
	DEF_PRN[0]=(unsigned char)NULL;
	confdir[0]=(unsigned char)NULL;
	ServerName[0]=(char)NULL;
	UserName[0]=(char)NULL;
	Path[0]=(unsigned char)NULL;
	ReallyPrint=1;
	needFileSelection = 1;
	cmdNumCopies=-1;
	builtin=0;
	tabtoopen=1;

	setlocale (LC_ALL, "");
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);
	
	i1=getopt(argc,argv,ProgOpts);
	while(i1 != -1)
	{
		switch(i1)
		{
			case '?':
				printf(_("Usage: gtklp [-P|-d printer] [-c configdir] [-S server] [-U user] [-p port] [-l] [-D] [-V] [-b] [-i] [-# n] [-o option=value ...] [file(s)]\n"));
				return(0);
			break;
			case 'i':
				if(DEBUG)
					printf("Ignoring Data on stdin !\n");
				ignore_stdin=1;
			break;
			case 'b':
				if(DEBUG)
					printf("Using builtin defaults !\n");
				builtin=1;
			break;
			case 'p':
				if(strlen(optarg) > MAX_PORT)
				{
					if(DEBUG)
						printf("Port too long !\n");
					g_error(_("Invalid Portnumber !"));
					exit(-1);
					//emergency();
				}
				else
				{
					if(DEBUG)
						printf("Using port: %s\n",optarg);
					snprintf(PortString,(size_t)MAX_PORT+10,"IPP_PORT=%s",optarg);
					putenv(PortString);
				}
			break;	
			case 'P':
			case 'd':
				if(strlen(optarg) < DEF_PRN_LEN)
				{
					strncpy(DEF_PRN,optarg,(size_t)DEF_PRN_LEN);
				}
				else
				{
					if(DEBUG)
						printf("PROG-ERROR: Printername too long !\n ");
					g_error(_("Invalid Printername !"));
					exit(-1);
	        //emergency();
				}
			break;
			case 'S':
				if(strlen(optarg) < MAX_SERVER_NAME)
				{
					strncpy(ServerName,optarg,(size_t)MAX_SERVER_NAME);
				}
				else
				{
					if(DEBUG)
						printf("PROG-ERROR: Servername too long !\n ");
					g_error(_("Invalid Servername !"));
					exit(-1);
					//emergency();
				}
			break;
			case 'U':
				if(strlen(optarg) < MAX_USERNAME)
				{	
					strncpy(UserName,optarg,(size_t)MAX_USERNAME);
				}
				else
				{
					if(DEBUG)
						printf("PROG-ERROR: Username too long !\n ");
					g_error(_("Invalid Username !"));
					exit(-1);
					//emergency();
				}
			break;
			case 'l':
				ReallyPrint=0;
				needFileSelection = 0;
			break;
			case 'D':
				DEBUG=1;
				printf("DEBUG-MODE on !\n");
			break;
			case 'c':
				strncpy(confdir,optarg,(size_t)MAXPATH);
			break;
			case '#':
				cmdNumCopies=atoi(optarg);
			break;
			case 'V':
				printf("\n%s %s %s\n",PROGNAME,_("version"),VERSION);
				printf("%s\n\n",MY_HOME);
				return(0);
			break;
			case 'o':
				num_commandline_opts=cupsParseOptions(optarg,num_commandline_opts,&commandline_opts);
			break;
			default:
				if(DEBUG)
					printf("PROG-ERROR: Unknown, but allowed switch: %c\n",i1);
				emergency();
			break;
		}
		i1=getopt(argc,argv,ProgOpts);
	}
	filesToPrintAnz=0;
       	if (optind < argc)
        {
                while (optind < argc)
		{
			if(filesToPrintAnz<MAXPRINTFILES)
				strncpy(filesToPrint[filesToPrintAnz++],argv[optind++],(size_t)MAXPATH);
			else
			{
				if(DEBUG)
					printf("Prog-Error: MAXPRINTFILES to short !\n");
				g_error(_("Too many files to print !"));
				exit(-1);
				//emergency();
			}
		}
        }
	if(filesToPrintAnz > 0)
		ignore_stdin=1;

	if(DEBUG)
	{
		printf("Files to print: \n");
                for(i1=0;i1<filesToPrintAnz;i1++)
        	        printf("  %s\n",filesToPrint[i1]);
	
	}
	if(DEBUG)
	{
		if (optind < argc)
           	{
             		printf ("non-option ARGV-elements: ");
             		while (optind < argc)
             			printf ("%s ", argv[optind++]);
             		printf ("\n");
           	}
	}

	
	

  /*--- GUI creation ---*/
	if(nox == 0) {
	  gtk_set_locale();
  	gtk_init(&argc, &argv);

	  /* HauptFenster */
  	mainWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	  gtk_window_set_title(GTK_WINDOW(mainWindow),PROGNAME);
  	gtk_window_set_policy(GTK_WINDOW(mainWindow),FALSE, FALSE, TRUE);
	  gtk_window_set_position(GTK_WINDOW(mainWindow),GTK_WIN_POS_CENTER);
  	gtk_widget_set_usize(mainWindow,WAIT_WIN_SIZE,-1);
	  gtk_signal_connect (GTK_OBJECT (mainWindow), "delete_event",GTK_SIGNAL_FUNC (destroy), NULL);
  	gtk_signal_connect (GTK_OBJECT (mainWindow), "destroy",GTK_SIGNAL_FUNC (destroy), NULL);
  	gtk_container_set_border_width (GTK_CONTAINER (mainWindow), 10);
  	gtk_widget_show(mainWindow);
		gtk_widget_realize(mainWindow);

  	/* Vertikaler Container im HauptFenster */
  	mainVBox=gtk_vbox_new(FALSE,BUTTON_SPACING_H);
  	gtk_container_add(GTK_CONTAINER(mainWindow), mainVBox);
  	gtk_widget_show(mainVBox);

  	waitLabel=gtk_label_new(_("Please wait!"));
  	gtk_box_pack_start(GTK_BOX(mainVBox),waitLabel,TRUE,TRUE,0);
  	gtk_widget_show(waitLabel);
  	while (gtk_events_pending())
    	gtk_main_iteration();
	}

  hasAskedPWD=0;  /* cups has not asked for pwd */
	
	if(nox == 0)
  	cupsSetPasswordCB(getPass);
  /*-- GUI Init ende ---*/


	/* Try to get connected to Server */
	if(ServerName[0]==(char)NULL)
	{
		if(DEBUG)
			printf("No Servername given, searching...\n");
		z1=(char *)cupsServer();
		if(z1 == (char *)NULL)
		{
			if(DEBUG)
				printf("PROG-ERROR: No Cups-Server found !\n");
			g_error(_("No Cups-Server found !"));
			exit(-1);
			//emergency();
		}
		strncpy(ServerName,z1,(size_t)MAX_SERVER_NAME);
	}
	if(DEBUG)
		printf("ServerName: %s\nTry to connect...\n",ServerName);
	cupsHttp=httpConnect(ServerName, ippPort());
	if(cupsHttp==NULL)
	{
		if(DEBUG)
			printf("PROG-ERROR: Cannot connect to Server %s!\n",ServerName);
		g_error(_("Unable to connect to Server %s !"),ServerName);
		exit(-1);
		//emergency();
	}
	else
	{
		if(DEBUG)
			printf("connected\n");
		snprintf(tmpenv,(size_t)MAX_SERVER_NAME,"CUPS_SERVER=%s",ServerName);
		cupsSetServer(ServerName);
		putenv(tmpenv);
	}
	cupsLanguage=cupsLangDefault();

	/* Setting Username */
	cupsSetUser((const char *)UserName);
	if(DEBUG)
		printf("Username is set to: %s\n",cupsUser());
	

	/* Create non command-line options */

	/* confdir */
	if(DEBUG)
		printf("Search for Confdir.\n");
	getPaths();
	if(DEBUG)
	{
		printf("Using:GTKLPRC=%s\nconfdir=%s\n",GTKLPRC,confdir);
	}

	/* CWD */
        fileOpenPath[0]=(unsigned char)NULL;
        getcwd(fileOpenPath,MAXPATH);
	strncat(fileOpenPath,"/",(size_t)MAXPATH);
	if(DEBUG)
        	printf("PWD=%s\n",fileOpenPath);

        /*--- get Global Prog-Options ---*/
	getOptions(DEF_PRN,2);

	/* Printer */
        if(DEBUG)
                printf("Default-Printer(1): %s\n",DEF_PRN);

	getPrinters(0);
	
	if(DEBUG)
		printf("Default-Printer(2): %s\n",DEF_PRN);

	if(DEF_PRN[0] == (unsigned char)NULL)
	{
		if(DEBUG)
			printf("PROG-ERROR: No Printer found to use for default !\n");
		g_error(_("No Printer found to use as default !"));
		exit(-1);
		//emergency();
	}
	/*--- get Options for this Printer ---*/
	getOptions(DEF_PRN,-1);		/* Get only important options -> Passwort !!!!! */
	if(getPPDOpts(DEF_PRN) < 0)	/* exit if password wrong */
	{
		cupsLangFree(cupsLanguage);
		httpClose(cupsHttp);
		exit(-1);
	}
	/*--- Den Rest der GUI bauen ---*/

	if(nox == 0) {
		/* Tab Environment basteln */
		tabs = gtk_notebook_new();
		gtk_box_pack_start(GTK_BOX(mainVBox), tabs, FALSE, FALSE, 0);
		gtk_notebook_set_tab_pos(GTK_NOTEBOOK(tabs), GTK_POS_TOP );
		gtk_widget_show(tabs);

		/* Buttons basteln */
		buttonBox=gtk_hbox_new(FALSE,0);
		gtk_box_pack_end(GTK_BOX(mainVBox), buttonBox, TRUE, TRUE, 0);
	
		buttonPrint = gtk_button_new_with_label (_("Print"));
		gtk_signal_connect (GTK_OBJECT (buttonPrint), "clicked",GTK_SIGNAL_FUNC (PrintFunc), NULL);
		gtk_box_pack_start(GTK_BOX(buttonBox), buttonPrint, TRUE, TRUE, BUTTON_SPACING_V);
		gtk_widget_show (buttonPrint);

		buttonReset = gtk_button_new_with_label (_("Reset All"));
		gtk_signal_connect (GTK_OBJECT (buttonReset), "clicked",GTK_SIGNAL_FUNC (ResetFunc), NULL);
		gtk_box_pack_start(GTK_BOX(buttonBox), buttonReset, TRUE, TRUE, BUTTON_SPACING_V);
		gtk_widget_show (buttonReset);

		buttonSave = gtk_button_new_with_label (_("Templates"));
		gtk_signal_connect (GTK_OBJECT (buttonSave), "clicked",GTK_SIGNAL_FUNC (instWin), NULL);
		gtk_box_pack_start(GTK_BOX(buttonBox), buttonSave, TRUE, TRUE, BUTTON_SPACING_V);
		gtk_widget_show (buttonSave);

		buttonAbbruch = gtk_button_new_with_label (_("Cancel"));
		gtk_signal_connect (GTK_OBJECT (buttonAbbruch), "clicked",GTK_SIGNAL_FUNC (AbbruchFunc), NULL);
		gtk_box_pack_start(GTK_BOX(buttonBox), buttonAbbruch, TRUE, TRUE, BUTTON_SPACING_V);
		gtk_widget_show (buttonAbbruch);

		/* Tabs basteln */
		CreateWidgets();
		/* Fenster anzeigen */
		gtk_widget_hide(waitLabel);
		ShowWidgets();
		if(DEBUG)
			printf("Switching to Tab %i\n",tabtoopen);
		gtk_notebook_set_page(GTK_NOTEBOOK(tabs),tabtoopen);
		gtk_widget_show(buttonBox);
	}

	conflict_active=1;
	if(nox == 0) {
		if(printerPPD != NULL)
			constraints(ppdConflicts(printerPPD));
  	gtk_main ();
	}
	else {
		PrintFunc(NULL, NULL);
	}
  return(0);
}
