/* some Drag and Drop support functions */

#ifndef DNDSETUP_H
#define DNDSETUP_H

#include <gtk/gtk.h>

#include "main.h"
#include "dndsetup.h"

#define DNDSETUP_LINK 1
#define DNDSETUP_COPY 2
/* use this to determine selected drag action 
 * 0 == external drag event */
extern int dndsetup_dragtype;

/* prototype for a dropcallback handler,taking the dropped string
 * and the position within the widget as argument plus a int defining
 * the desired drop action 
 * if 0 is returned data will be rejected */
typedef int (*dndsetup_dropcallback) (const char*s,int x,int y,int dragtype,
				       gpointer data);
/* the callback has to return a pointer to 
 * the string to be set as drag data.
 * the drop action is determined by the mouse button used to drag the object.
 * Mapping for this is hardcoded into dndsetup.c */
typedef char*(*dndsetup_dragcallback) (gpointer data);
/* called when a dnd process is done. dragtype is 0 if action was aborted
 * and resembles the type of action performed in case of success */
typedef void (*dndsetup_dragdonecallback) (int dragtype,gpointer data);

typedef struct
{
   gpointer userdata;
   dndsetup_dropcallback dropcb;
   dndsetup_dragcallback dragcb;
   dndsetup_dragdonecallback donecb;
} dndsetup_info;

/* Widget to use,function sending data,function receiving completion status,
 * user data */
void dndsetup_drag(GtkWidget *,
		   dndsetup_dragcallback,
		   dndsetup_dragdonecallback,
		   void*);
/* setup a raw dnd drop destination */
void dndsetup_drop_raw(GtkWidget *w,
		       GtkSignalFunc drophandler,
		       gpointer data);  
/* Widget to use,function catching data,user data */
void dndsetup_drop(GtkWidget *,
		   dndsetup_dropcallback,
		   void*);

#endif // DNDSETUP_H
