/* these are the handling functions for the linkcount database.
 * it takes care that no symbolic link is called twice within a recursive loop */

#ifndef LINKCOUNT_H
#define LINKCOUNT_H

#include <glib.h>

/* this function scans for the link with the name filename within linklist.
 * possible return values are:
 *    1: the link is already registered within the database
 *    0: the link was not found within the database and is valid
 *   -1: what was given as filename is *not* a symbolic link 
 * With those return values,the caller can simply determine wether to
 * call a recursive instance of his function by checking if the return
 * value of this function is <1. */
int linkcount_use(GList **linklist,char *filename);
/* free all of a linkcountlists memory and set its memory location 
 * back to NULL. */
void linkcount_free(GList **linklist);

#endif // LINKCOUNT_H
