<?xml version="1.0"?> <!-- -*- xml -*- -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- A dialog box -->
  <xsl:template match="dialog">

    <xsl:text>ALERT ID </xsl:text>
    <xsl:value-of select="@id"/>
    <xsl:text>
</xsl:text>

    <xsl:choose>
      <xsl:when test="string(type/@value)='information'">
	<xsl:text>INFORMATION</xsl:text>
      </xsl:when>
      <xsl:when test="string(type/@value)='confirmation'">
	<xsl:text>CONFIRMATION</xsl:text>
      </xsl:when>
      <xsl:when test="string(type/@value)='warning'">
	<xsl:text>WARNING</xsl:text>
      </xsl:when>
      <xsl:when test="string(type/@value)='error'">
	<xsl:text>ERROR</xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:text>
</xsl:text>

    <xsl:if test="help/@id">
      <xsl:text>HELPID </xsl:text>
      <xsl:value-of select="help/@id"/>
      <xsl:text>
</xsl:text>	
    </xsl:if>

    <xsl:text>BEGIN
</xsl:text>

    <xsl:if test="title/text()">
      <xsl:text>TITLE "</xsl:text>
      <xsl:value-of select="title"/>
      <xsl:text>"
</xsl:text>
    </xsl:if>

    <xsl:if test="text/text()">
      <xsl:text>MESSAGE "</xsl:text>
      <xsl:value-of select="text"/>
      <xsl:text>"
</xsl:text>
    </xsl:if>

    <xsl:if test="buttons">
      <xsl:text>BUTTONS </xsl:text>
      <xsl:for-each select="buttons/button">
	<xsl:text>"</xsl:text>
	<xsl:value-of select="@label"/>
	<xsl:text>" </xsl:text>
      </xsl:for-each>
      
      <xsl:text>
</xsl:text>
    </xsl:if>

    <xsl:text>END
</xsl:text>
      
    <xsl:text>

</xsl:text>
    
  </xsl:template>
  
</xsl:stylesheet>
