//$Id: session.h,v 1.10 2004/03/20 23:46:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_SESSION_H
#define GUIKACHU_SESSION_H

#include <string>
#include <vector>
#include <gnome--/main.h>

namespace Guikachu
{
    // Forward declarations
    class ResourceManager;
    
    namespace GUI
    {
	class MainWin;
    }
    
    class Main: public Gnome::Main
    {
	static Main *instance_;
	
	poptContext               ctx;
	std::string               cmd_self;
	std::vector<std::string>  cmd_arguments;
	std::string               last_filename;

	ResourceManager          *doc;
	GUI::MainWin             *mainwin;
	
    public:
	Main (int argc, char **argv);
	static inline Main *instance ()    { return instance_; };
	static inline bool  initialized () { return instance_ != 0; };
	~Main ();
	
	void load_doc (const std::string &filename, const std::string &mime_type);
	void save_doc (const std::string &filename);
	void new_doc  ();

    protected:
	void run_impl ();
	
    private:
	void set_doc      (ResourceManager   *doc);
	void set_filename (const std::string &filename, const std::string &mime_type);
	
	int  session_save_cb (int                phase,
			      GnomeSaveStyle     save_style,
			      gint               is_shutdown,
			      GnomeInteractStyle interact_style,
			      int                is_fast);
	void session_die_cb  ();
	
	void save_open_file ();
    };
}

#endif /* !GUIKACHU_SESSION_H */
