/****************************************************************************
** Filename: zip.h
** Last updated [dd/mm/yyyy]: 23/10/2006
**
** pkzip 2.0 file compression.
**
** Some of the code has been inspired by other open source projects,
** (mainly Info-Zip).
** Compression and decompression actually uses the zlib library.
**
** Copyright (C) 2006 Angius Fabrizio. All rights reserved.
**
** This file is part of the OSDaB project (http://osdab.sourceforge.net/).
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See the file LICENSE.GPL that came with this software distribution or
** visit http://www.gnu.org/copyleft/gpl.html for GPL licensing information.
**
**********************************************************************/

#ifndef OSDAB_ZIP__H
#define OSDAB_ZIP__H

#include "zipentry.h"

#include <QtGlobal>
#include <QObject>
#include <QMap>

#include <zlib/zlib.h>

class ZipPrivate;

class QIODevice;
class QFile;
class QDir;
class QStringList;
class QString;


class Zip : public QObject
{
	Q_OBJECT

public:
	enum ErrorCode
	{
		Ok,
		ZlibInit,
		ZlibError,
		FileExists,
		OpenFailed,
		NoOpenArchive,
		FileNotFound,
		ReadFailed,
		WriteFailed,
		SeekFailed
	};

	enum CompressionLevel
	{
		Store,
		Deflate1 = 1, Deflate2, Deflate3, Deflate4,
		Deflate5, Deflate6, Deflate7, Deflate8, Deflate9,
		AutoCPU, AutoMIME, AutoFull
	};

	Zip(QWidget* parent = 0);
	virtual ~Zip();

	bool isOpen() const;

	ErrorCode createArchive(const QString& file, bool overwrite = true);
	ErrorCode createArchive(QIODevice* device);

	ErrorCode addDirectory(const QString& dir, const QString& root, const QString* pasword = 0, CompressionLevel level = AutoFull);

	ErrorCode closeArchive();

	static QString formatError(ErrorCode c);

private:
	ZipPrivate* d;
};

#endif // OSDAB_ZIP__H
