/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef FILETHUMBNAILVIEW_H
#define FILETHUMBNAILVIEW_H

// Qt includes
#include <qguardedptr.h>
#include <qiconview.h>

// KDE includes
#include <kfileview.h>

// Our includes
#include "browsablefileview.h"
#include "thumbnailsize.h"


class QPopupMenu;

class KConfig;
class KFileViewItem;

class ThumbnailLoadJob;


class FileThumbnailView : public QIconView, public KFileView, public BrowsableFileView {
Q_OBJECT
public:
	FileThumbnailView(QWidget* parent);
	~FileThumbnailView();
	
	QWidget* widget() { return this; }
	void clearView();
	void clearSelection() { QIconView::clearSelection(); }

	void insertItem(KFileViewItem* item);
	void ensureItemVisible(const KFileViewItem* item);
	void setSelected(const KFileViewItem* item,bool enable);
	bool isSelected(const KFileViewItem* item) const;
	void removeItem(const KFileViewItem* item);
	void startThumbnailUpdate();
	void stopThumbnailUpdate();

// Browsable methods
	void selectFirst();
	void selectLast();
	void selectPrevious();
	void selectNext();
	
	QString previousItemText() const;
	QString currentItemText() const;
	QString nextItemText() const;
	bool currentIsFirst() const;
	bool currentIsLast() const;

	/**
	 * Don't forget to call arrangeItemsInGrid to apply the changes
	 */
	void setThumbnailSize(ThumbnailSize value);
	ThumbnailSize thumbnailSize() const { return mThumbnailSize; }

	/**
	 * Don't forget to call arrangeItemsInGrid to apply the changes
	 */
	void setMarginSize(int value);
	int marginSize() const { return mMarginSize; }

	void readConfig(KConfig*,const QString&);
	void writeConfig(KConfig*,const QString&) const;


public slots:
	void setThumbnailPixmap(const KFileViewItem*,const QPixmap&);

signals:
	void updateStarted(int);
	void updateEnded();
	void updatedOneThumbnail();

protected:
	void startDrag();

private:
	ThumbnailSize mThumbnailSize;
	int mMarginSize;
	QPopupMenu* mPopupMenu;

	QGuardedPtr<ThumbnailLoadJob> mThumbnailLoadJob;
	
};


#endif
