/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef FILEVIEW_H
#define FILEVIEW_H

#include <qobject.h>
#include <qwidgetstack.h>

#include <kfileview.h>

class QIconViewItem;
class QListViewItem;
class QPopupMenu;

class KAccel;
class KAction;
class KConfig;
class KRadioAction;

class BrowsableFileView;
class FileDnDDetailView;
class FileThumbnailView;
class ImageFileReader;


class FileView : public QWidgetStack {
Q_OBJECT

public:
	enum Mode { FileList, Thumbnail};

	FileView(QWidget* parent);
	~FileView();

	void plugActionsToAccel(KAccel*);
	void installRBPopup(QPopupMenu*);

// Config
	void readConfig(KConfig*,const QString&);
	void writeConfig(KConfig*,const QString&) const;

// Properties
	void setMode(Mode);
	bool currentIsFirst() const;
	bool currentIsLast() const;
	uint fileCount() const;
	QString filename() const;
	FileThumbnailView* fileThumbnailView() const { return mFileThumbnailView; }
	
	KAction* selectFirst() const { return mSelectFirst; }
	KAction* selectLast() const { return mSelectLast; }
	KAction* selectPrevious() const { return mSelectPrevious; }
	KAction* selectNext() const { return mSelectNext; }
	KRadioAction* noThumbnails() const { return mNoThumbnails; }
	KRadioAction* smallThumbnails() const { return mSmallThumbnails; }
	KRadioAction* medThumbnails() const { return mMedThumbnails; }
	KRadioAction* largeThumbnails() const { return mLargeThumbnails; }

public slots:
	void setFolderAndFile(QString folder,QString filename);

	void selectFilename(QString filename);

	void slotSelectFirst();
	void slotSelectLast();
	void slotSelectPrevious();
	void slotSelectNext();

// Stop thumbnail generation
	void cancel();

	void deleteFile();
	void renameFile();
	void copyFile();
	void moveFile();


signals:
	void filenameChanged(QString filename);
	void completed();
	void canceled();

// Thumbnail view signals
	void updateStarted(int);
	void updateEnded();
	void updatedOneThumbnail();


private slots:
// Detail view signals
	void detailChanged(QListViewItem* item);
	void detailRightButtonClicked(QListViewItem*,const QPoint&,int);

// Thumbnail view signals
	void thumbnailChanged(QIconViewItem* item);
	void thumbnailRightButtonClicked(QIconViewItem*,const QPoint&);

// Connected to the job handling the rename
//	void slotRenamed(KIO::Job*);
	void slotSelectNewFilename();
	void slotRenamed(const QString&);

// Get called by the thumbnail size radio actions
	void updateThumbnailSize();

// Image file reader slots
	void removeItem(KFileItem* item);
	void newItems(const KFileItemList& items);
	void fileReaderStarted();
	void fileReaderCanceled();
	void fileReaderCompleted();
	void clear();
	void stopFileReader();

private:
	Mode mMode;
	FileDnDDetailView* mFileDetailView;
	FileThumbnailView* mFileThumbnailView;
	ImageFileReader* mFileReader;
	QString mFolder;
	QPopupMenu* mPopupMenu;

// Our actions
	KAction* mSelectFirst;
	KAction* mSelectLast;
	KAction* mSelectPrevious;
	KAction* mSelectNext;
	
	KRadioAction* mNoThumbnails;
	KRadioAction* mSmallThumbnails;
	KRadioAction* mMedThumbnails;
	KRadioAction* mLargeThumbnails;

// configurable settings
	bool mConfirmMove;
	QString mMoveToFolder;

	bool mConfirmCopy;
	QString mCopyToFolder;

	bool mConfirmDelete;

// Temp data used by the file reader
	bool mThumbnailsNeedUpdate;
	QString mFilenameToSelect; // The file which will be selected at the end of the file reader work
	QString mNewFilenameToSelect; // The file which will be selected after a file operation like move, delete or rename

	KFileView* currentFileView() const;
	BrowsableFileView* currentBrowsableFileView() const;
	void emitFilenameChanged();
	void updateActions();
};


#endif
