 /*
 *  SmallIconsViewer.h: Interface and declarations for the SmallIconsViewer 
 *  Class of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2002 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: February 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SMALLICONSVIEWER_H
#define SMALLICONSVIEWER_H

#import <AppKit/NSView.h>
#include "ViewersProtocol.h"

@class NSString;
@class NSArray;
@class NSDictionary;
@class NSNotification;
@class NSFileManager;
@class NSScrollView;
@class PathsPopUp;
@class NSTextField;
@class Banner;
@class SmallIconsPanel;

@interface SmallIconsViewer : NSView <ViewersProtocol>
{
	Banner *banner;
	PathsPopUp *pathsPopUp;
	
	SmallIconsPanel *panel;
	NSScrollView *panelScroll;
  BOOL viewsapps;
  BOOL autoSynchronize;
  int resizeIncrement;
  int columns;
  float columnsWidth;
  NSString *currentPath;
	NSArray *selectedPaths;
  NSArray *watchedPaths;
	id delegate;
  NSFileManager *fm;
}

- (void)makePopUp:(NSArray *)pathComps;

- (void)popUpAction:(id)sender;

- (void)fileSystemWillChange:(NSNotification *)notification;

- (void)fileSystemDidChange:(NSNotification *)notification;

- (void)sortTypeDidChange:(NSNotification *)notification;

- (void)validateCurrentPathAfterOperation:(NSDictionary *)opdict;

- (void)watcherNotification:(NSNotification *)notification;

- (void)setWatchers;

- (void)setWatcherForPath:(NSString *)path;

- (void)unsetWatcherForPath:(NSString *)path;

- (void)updateDiskInfo;

- (void)setSelectedIconsPaths:(NSArray *)paths;

- (void)openCurrentSelection:(NSArray *)paths newViewer:(BOOL)newv;

- (void)closeNicely;

- (void)close:(id)sender;

@end

//
// Methods Implemented by the Delegate 
//

@interface NSObject (ViewerDelegateMethods)

- (void)setTheSelectedPaths:(id)paths;

- (void)setTitleAndPath:(id)apath selectedPaths:(id)paths;

- (void)addWatcherForPath:(id)path;

- (void)removeWatcherForPath:(id)path;

- (void)addPathToHistory:(NSArray *)paths;

- (int)sortTypeForDirectoryAtPath:(id)path;

- (void)openTheSelectedPaths:(id)paths newViewer:(BOOL)newv;

- (void)newViewerAtPath:(id)path canViewApps:(BOOL)viewapps;

- (BOOL)openFile:(id)fullPath;

- (void)performFileOperationWithDictionary:(id)opdict;

- (NSImage *)smallIconForFile:(NSString*)aPath;

- (NSImage *)smallIconForFiles:(NSArray*)pathArray;

- (NSString *)getTrashPath;

- (void)updateTheInfoString;

- (int)getBrowserColumnsWidth;

- (int)getIconViewCellsWidth;

- (int)getWindowFrameWidth;

- (int)getWindowFrameHeight;

@end

//
// SmallIconsPanel Delegate Methods
//

@interface SmallIconsViewer (SmallIconsPanelDelegateMethods)

- (NSImage *)smallIconForFile:(NSString*)aPath;

- (NSImage *)smallIconForFiles:(NSArray*)pathArray;

- (void)setTheSelectedPaths:(id)paths;

- (void)openTheCurrentSelection:(id)paths newViewer:(BOOL)newv;

- (void)performFileOperationWithDictionary:(id)opdict;

- (int)sortTypeForDirectoryAtPath:(id)path;

- (NSString *)getTrashPath;

- (int)getIconViewCellsWidth;

@end

#endif // SMALLICONSVIEWER_H

