/* GXedit
 * Copyright 1998 Patrick Lambert <drow@wildstar.net>
 *
 * This program is free software. You can use, copy and modify it under
 * the terms of the GPL. See the file COPYING for the full GPL license.
*/

#include "gxedit.h"

char ndcode(char trans)
{
 /* from rot13 v1.3 */
 if ((trans >= 65 && trans <= 90) || (trans >= 97 && trans <= 122))
 {
  if (trans >= 78 && trans <= 90) trans -= 26;
  if (trans >= 110 && trans <= 122) trans -= 26;
  trans += 13;
 }
 return (trans);
}

char *lindex(char *input_string, int word_number)
{
 char *tokens[1024];
 static char tmpstring[1024];
 int i;
 strncpy(tmpstring,input_string,1024);
 (char *)tokens[i=0] = (char *)strtok(tmpstring, " ");
 while (((char *)tokens[++i] = (char *)strtok(NULL, " ")));
 tokens[i] = NULL;
 return(tokens[word_number]);
}

char *lrange(char *input_string, int starting_at)
{
 char *tokens[1024];
 static char tmpstring[1024]="";
 int i;
 char out_string[1024]="";
 strcpy(out_string,"");
 if(input_string==NULL) {
  strcpy(out_string," ");
  strcat(out_string,NULL);
  strcpy(global_var,out_string);
  return (char *)global_var; }
 strncpy(tmpstring,input_string,1024);
 (char *)tokens[i=0] = (char *)strtok(tmpstring, " ");
 while(((char *)tokens[++i] = (char *)strtok(NULL, " ")));
 tokens[i] = NULL;
 i++;
 if(i<starting_at)
 {
  return (char *)"";
 }
 while(tokens[starting_at] != NULL)
 {
  strncat(out_string,tokens[starting_at],1024);
  strcat(out_string, " ");
  starting_at++;
 }
 strncpy(global_var,out_string,511);
 return (char *)global_var;
}

void print_debug(char *string)
{
 if(debug)
 gtk_text_insert (GTK_TEXT (text_debug), NULL, &color, NULL, string, -1);
}

char *html_to_text(char buf[])
{
 int i, j, k;
 char keyword[12];
 bzero(temp, 1024);
 j=0;
 for(i=0;buf[i]!='\0';i++)
 {
  if(buf[i]=='<' || hs == 1)
  {
   k = 0;
   hs = 1;
   for(i=i;buf[i]!='\0';i++)
   {
    if(k<12) keyword[k]=buf[i];
    k++;
    if(buf[i]=='>')
    {
     hs = 0;
     break;
    }
   }
   if((keyword[1]=='B' && keyword[2]=='R') ||
      (keyword[1]=='b' && keyword[2]=='r'))
      {temp[j]='\n'; j++;}
   if((keyword[1]=='L' && keyword[2]=='I') ||
      (keyword[1]=='l' && keyword[2]=='i'))
      {temp[j]='*'; j++;}
   if((keyword[0]=='<' && keyword[1]=='P') ||
      (keyword[0]=='<' && keyword[1]=='p'))
      {temp[j]='\n'; j++; temp[j]='\n'; j++; }
  }
  if(buf[i]!='>')
  {
   temp[j]=buf[i];
   j++;
  }
 }
 return temp;
}

gushort convert_color(unsigned c)
{
 if (c==0) return(0);
 c *= 257;
 return(c > 0xffff)? 0xffff : c;
}

void extract_color(GdkColor *color, unsigned red, unsigned green, unsigned blue)
{
 color->red = convert_color(red);
 color->green = convert_color(green);
 color->blue = convert_color(blue);
}

void msgbox_c(GtkWidget *w, GtkWidget *e)
{
 gtk_widget_destroy(window5);
}

void msgbox(char *string)
{
 if(window5!=NULL)
 {
  if(GTK_IS_WIDGET(window5)) gtk_widget_destroy(window5);
 }
 window5 = gtk_dialog_new();
 gtk_widget_set_usize (GTK_WIDGET (window5), strlen(string)+400, 120);
 gtk_signal_connect (GTK_OBJECT (window5), "destroy",
  GTK_SIGNAL_FUNC(msgbox_c), &window5);
 gtk_signal_connect (GTK_OBJECT (window5), "delete_event",
  GTK_SIGNAL_FUNC(msgbox_c), &window5);
 gtk_window_set_title (GTK_WINDOW (window5), "GXedit");
 gtk_container_border_width (GTK_CONTAINER (window5), 0);
 gtk_widget_set_uposition (window5, (x_pos+50), (y_pos+50));

 label = gtk_label_new (string);
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window5)->vbox),
  label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(msgbox_c), GTK_OBJECT (window5));
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window5)->action_area),
  button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window5);
}

void delete_note(GtkWidget *widget, GtkWidget *event)
{
 gtk_widget_destroy(noteWin);
}

void create_note(FILE *nd)
{
 fgets(temp, 1000, nd);
 if(noteWin!=NULL) gtk_widget_destroy(noteWin);
 noteWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (noteWin), 150, 70);
 gtk_signal_connect (GTK_OBJECT (noteWin), "destroy", 
  GTK_SIGNAL_FUNC(delete_note), &noteWin);
 gtk_signal_connect (GTK_OBJECT (noteWin), "delete_event",
  GTK_SIGNAL_FUNC(delete_note), &noteWin);
 gtk_window_set_title (GTK_WINDOW (noteWin), "File note");
 gtk_container_border_width (GTK_CONTAINER (noteWin), 0);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (noteWin), vbox);
 gtk_widget_show (vbox);

 text2 = gtk_text_new(NULL, NULL);
 gtk_text_set_editable (GTK_TEXT (text2), FALSE);
 gtk_text_set_word_wrap(GTK_TEXT (text2), TRUE);
 gtk_box_pack_start (GTK_BOX (vbox), text2, TRUE, TRUE, 0);
 gtk_widget_show (text2);
 gtk_widget_show(noteWin);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, temp, -1);
}

void open_file(char *file, char *errmsg)
{
 int i;
 fd = fopen(file,"r");
 if(fd==NULL)
 {
  msgbox(errmsg);
  return;
 }
 gtk_text_freeze(GTK_TEXT(text));
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text),gtk_text_get_length(GTK_TEXT(text)));
 i=0;
 while(fgets(line,512,fd)!=NULL)
 {
  i++;
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
 }
 gtk_text_thaw (GTK_TEXT (text));
 sprintf(temp, "File loaded (%d lines)\n", i+1);
 print_debug(temp);
 fclose(fd);
#ifdef GTKEDITOR_PATCH
 gtk_text_set_point(GTK_TEXT(text), 0);
 if(syntax_h)
  gtk_editor_hilite_screen(GTK_EDITOR(text));
#endif
 if(show_line)
 {
  sprintf(line_tmp, "Pos: %d/%d Col: %d", gtk_text_get_point(GTK_TEXT(text)),  
  gtk_text_get_length(GTK_TEXT(text)), GTK_TEXT(text)->cursor_virtual_x/7);
  gtk_label_set(GTK_LABEL(line_label), (gchar*)line_tmp);
 }
 if(urlbar) update_last_files(file);
 if(sticky_dir)
 {
  if(filename[0]=='/')
  {
   strcpy(temp, filename);
   i = strlen(temp)-1;
   while(temp[i]!='/')
   {
    temp[i]=' ';
    i--;
   }
   chdir(lindex(temp,0));
  }
 }
}

void update_last_files(char *file)
{
 last_files = NULL;
 sprintf(temp, "%s/.gxedit.last", home);
 fd = fopen(temp, "r");
 if(fd!=NULL)
 {
  bzero(line, 512);
  while(fgets(line, 500, fd)!=NULL)
  {
   if(lindex(line,0)!=NULL)
   {
    if(line[strlen(line)-1]=='\n') line[strlen(line)-1]=' ';
    last_files = g_list_append(last_files, g_strdup(line));
   }
/*
   bzero(line, 512);
*/
  }
  fclose(fd);
 }
 else last_files = g_list_append(last_files, "No previous file");
 if(last_files!=NULL) gtk_combo_set_popdown_strings (GTK_COMBO (url_list), last_files);
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(url_list)->entry), file);
}

void set_defaults()
{
 /* set defaults */
 use_xrn = 1;
 sticky_dir = 1;
 urlbar = 1;
 sticky_dir = 1;
 binded = 0;
 original = 0;
 scroll_loc = 0;
 use_socks = 0;
 indent = 0;
 mirr_serv = 0;
 debug = 0;
 icons = 0;
 autosave = 0;
 toolbar = 1;
 tooltips = 1;
 x_size = 700;
 y_size = 400;
 full_tb = 1;
 show_line = 0;
 show_project = 1;
 netbar = 1;
 htmlbar = 0;
 syntax_h = 0;
 h_style = 0;
 fortune = 0;
 old_open = 0;
 cvs_z3 = 1;
 auto_indent = 0;
 mail_cmd = 0;
 access_opt = 0;
 audio = 0;
 x_pos = 20;
 y_pos = 20;
 reply = 0;
 page_width = 0;
 tab_width = 8;
 line_wrap = 1;
 strcpy(col_name,"black");
 strcpy(xfm,"xfm");
 strcpy(compile,"gcc -Wall -o ./a.out -g $f");
 strcpy(gzip,"gzip -d");
 strcpy(doc_dir,"");
 strcpy(dict,"english");
 strcpy(cvs_root,":pserver:anonymous@anoncvs.gnome.org:/cvs/gnome");
 strcpy(cvs_dir,"/usr/src/cvs");
 strcpy(images,"xv");
 strcpy(mail_server, "localhost");
 strcpy(mail_from, "root@localhost");
 strcpy(default_news, "");
 strcpy(default_web, "");
 strcpy(mirror_remote, "localhost");
 strcpy(news_server, "localhost");
 strcpy(font, "-adobe-helvetica-*-r-*-*-12-*-*-*-*-*-*-*");
 strcpy(bg, "white");
 strcpy(bg_pixmap, "none");
 strncpy(login, getenv("LOGNAME"), 100);
 modified = 0;
 sprintf(temp, "%s/.gxedit.applications", home);
 fd = fopen(temp, "r");
 if(fd==NULL)
 {
  fd = fopen(temp, "w");
  fputs("# This is the applications and scripts file for GXedit\n", fd);
  fputs("# From here, you can add applications to the toolbar or scripts to GXedit\n", fd);
  fputs("# Be careful not to let any empty line in this file\n", fd);
  fputs("# The syntax of the file is:\n", fd);
  fputs("#   aplication: <number> <1 word name> <icon file name> <command line>\n", fd);
  fputs("#   script: <number> <file name> <description>\n", fd);
  fputs("# Example:\n", fd);
  fputs("#   application: 1 Netscape /usr/X11R6/include/X11/pixmaps/mini-nscape.xpm /usr/local/bin/netscape\n", fd);
  fputs("script: 1 /usr/share/GXedit/userinfo.scr Get user info\n", fd);
  fputs("script: 2 /usr/share/GXedit/popmail.scr Fetch POP3 mail\n", fd);
  fputs("script: 3 /usr/share/GXedit/www.scr Browse the web\n", fd);
  fputs("script: 4 /usr/share/GXedit/traceroute.scr Traceroute\n", fd);
 }
 fclose(fd);
}

void parse_rc()
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd = fopen(tmp_name, "w");
 if(fd==NULL)
 {
  fprintf(stderr, "GXedit: Fatal error: Can't open temporary file in /tmp\n");
  exit(1);
 }
 fputs("pixmap_path \".:/usr/X11R6/include/X11/pixmaps\"\n", fd);
 fputs("style \"text\"\n", fd);
 fputs("{\n", fd);
 sprintf(temp, "font = \"%s\"\n", font);
 fputs(temp, fd);
 if(strcasecmp(bg_pixmap,"none"))
 {
  sprintf(temp, "  bg_pixmap[NORMAL] = \"%s\"\n", bg_pixmap);
  fputs(temp, fd);
 }
 if(!strcasecmp(bg,"white"))
 fputs("  base[NORMAL] = { 1.0, 1.0, 1.0 }\n", fd);
 if(!strcasecmp(bg,"black"))
 fputs("  base[NORMAL] = { 0.0, 0.0, 0.0 }\n", fd);
 if(!strcasecmp(bg,"red"))
 fputs("  base[NORMAL] = { 1.0, 0.0, 0.0 }\n", fd);
 if(!strcasecmp(bg,"blue"))
 fputs("  base[NORMAL] = { 0.0, 0.0, 1.0 }\n", fd);
 if(!strcasecmp(bg,"green"))
 fputs("  base[NORMAL] = { 0.0, 1.0, 0.0 }\n", fd);
 if(!strcasecmp(col_name,"white"))
 fputs("  text[NORMAL] = { 1.0, 1.0, 1.0 }\n", fd);
 if(!strcasecmp(col_name,"black"))   
 fputs("  text[NORMAL] = { 0.0, 0.0, 0.0 }\n", fd);
 if(!strcasecmp(col_name,"red"))
 fputs("  text[NORMAL] = { 1.0, 0.0, 0.0 }\n", fd);
 if(!strcasecmp(col_name,"blue"))
 fputs("  text[NORMAL] = { 0.0, 0.0, 1.0 }\n", fd);
 if(!strcasecmp(col_name,"green"))
 fputs("  text[NORMAL] = { 0.0, 1.0, 0.0 }\n", fd);
 fputs("}\n\n", fd);
 if(access_opt)
 {
  fputs("style \"access\"\n", fd);
  fputs("{\n", fd);
  fputs("font = \"-misc-fixed-bold-r-*-*-14-*-*-*-*-*-*-*\"\n", fd);
  fputs("}\n\n", fd);
  fputs("widget_class \"*GtkMenu*\" style \"access\"\n", fd);
  fputs("widget_class \"*GtkToolbar*\" style \"access\"\n", fd);
 }
 fputs("widget_class \"*GtkText\" style \"text\"\n", fd);
#ifdef GTKEDITOR_PATCH
 fputs("widget_class \"*GtkEditor\" style \"text\"\n", fd);
#endif
 fclose(fd);
 gtk_rc_parse(tmp_name);
 sprintf(temp, "%s/.gxeditrc", home);
 fd = fopen(temp, "r");
 if(fd!=NULL)
 {
  fclose(fd);
  gtk_rc_parse(temp);
 }
}


void read_cfg(int s_debug, int nonet)
{
 while(fgets(line,512,fd)!=NULL)
 {
  if(lindex(line,0) == NULL || lindex(line,1) == NULL || !strcmp(lindex(line,0),"\n"))
   strcpy(line, "corrupted: cfg ");
  line[strlen(line)-1]=' ';
  if(!strcasecmp(lindex(line,0),"toolbar:"))
  {
   if(lindex(line,1)!=NULL)
   toolbar = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"tooltips:"))
  {
   if(lindex(line,1)!=NULL)
   tooltips = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"x_size:"))
  {
   if(lindex(line,1)!=NULL)
   x_size = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"y_size:"))
  {
   if(lindex(line,1)!=NULL)
   y_size = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"line_wrap:"))
  {
   if(lindex(line,1)!=NULL)
   line_wrap = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"page_width:"))
  {
   if(lindex(line,1)!=NULL)
   page_width = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"tab_width:"))
  {
   if(lindex(line,1)!=NULL)
   tab_width = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"full_toolbar:"))
  {
   if(lindex(line,1)!=NULL)
   full_tb = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"show_line:"))
  {
   if(lindex(line,1)!=NULL)
   show_line = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"show_project:"))
  {
   if(lindex(line,1)!=NULL)
   show_project = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"last_files:"))
  {
   if(lindex(line,1)!=NULL)
   urlbar = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"sticky_dir:"))
  {
   if(lindex(line,1)!=NULL)
   sticky_dir = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"netbar:"))
  {
   if(lindex(line,1)!=NULL)
   netbar = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"htmlbar:"))
  {
   if(lindex(line,1)!=NULL)
   htmlbar = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"syntax_h:"))
  {
   if(lindex(line,1)!=NULL)
   syntax_h = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"h_style:"))
  {
   if(lindex(line,1)!=NULL)
   h_style = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"fortune:"))
  {
   if(lindex(line,1)!=NULL)
   fortune = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"old_open:"))
  {
   if(lindex(line,1)!=NULL)
   old_open = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"cvs_z3:"))
  {
   if(lindex(line,1)!=NULL)
   cvs_z3 = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"scrollbar_location:"))
  {
   if(lindex(line,1)!=NULL)
   scroll_loc = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"use_socks:"))
  {
   if(lindex(line,1)!=NULL)
   use_socks = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"auto_indent:"))
  {
   if(lindex(line,1)!=NULL)
   auto_indent = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"mail_cmd:"))
  {
   if(lindex(line,1)!=NULL)
   mail_cmd = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"use_xrn:"))
  {
   if(lindex(line,1)!=NULL)
   use_xrn = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"access:"))
  {
   if(lindex(line,1)!=NULL)
   access_opt = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"audio:"))
  {
   if(lindex(line,1)!=NULL)
   audio = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"x_position:"))
  {
   if(lindex(line,1)!=NULL)
   x_pos = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"y_position:"))
  {
   if(lindex(line,1)!=NULL)
   y_pos = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"debug:"))
  {
   if(lindex(line,1)!=NULL)
   debug = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"autosave:"))
  {
   if(lindex(line,1)!=NULL)
   autosave = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"toolbar_icons:"))
  {
   if(lindex(line,1)!=NULL)
   icons = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"images:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(images, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"xfm:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(xfm, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"compile:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(compile, lrange(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"gzip:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(gzip, lrange(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"document_dir:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(doc_dir, lrange(line,1), 100);
   else strcpy(doc_dir,"");
  }
  else if(!strcasecmp(lindex(line,0),"dictionary:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(dict, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"cvs_root:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(cvs_root, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"cvs_dir:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(cvs_dir, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"login_name:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(login, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"news_server:"))
  {
#ifdef USE_NET
   if(!nonet)
   {
    if(lindex(line,1)!=NULL)
    {
     strncpy(news_server, lindex(line,1), 100);
    }
   }
#endif
  }
  else if(!strcasecmp(lindex(line,0),"mail_server:"))
  {
#ifdef USE_NET
   if(!nonet)
   {
    if(lindex(line,1)!=NULL)
    {
     strncpy(mail_server, lindex(line,1), 100);
    }
   }
#endif
  }
  else if(!strcasecmp(lindex(line,0),"mail_address:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(mail_from, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"default_news:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(default_news, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"default_web:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(default_web, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"mirror_server:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(mirror_remote, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"font:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(font, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"background:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(bg, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"pixmap:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(bg_pixmap, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"mail_reply:"))
  {
   if(lindex(line,1)!=NULL)
   reply = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"color:"))
  {
   strncpy(col_name, lindex(line,1), 10);
   if(!strcasecmp(lindex(line,1),"black"))
   {
    extract_color(&color, 0, 0, 0);
    gdk_color_alloc(cmap, &color);
   }
   else if(!strcasecmp(lindex(line,1),"green"))
   {
    extract_color(&color, 0, 255, 0);
    gdk_color_alloc(cmap, &color);
   }
   else if(!strcasecmp(lindex(line,1),"white"))
   {
    extract_color(&color, 255, 255, 255);
    gdk_color_alloc(cmap, &color);
   }
   else if(!strcasecmp(lindex(line,1),"red"))
   {
    extract_color(&color, 255, 0, 0);
    gdk_color_alloc(cmap, &color); 
   }
   else if(!strcasecmp(lindex(line,1),"blue"))
   {
    extract_color(&color, 0, 0, 255);
    gdk_color_alloc(cmap, &color); 
   }
   else fprintf(stderr, "GXedit: Invalid color in config file\n");
  }
  else if(!strcasecmp(lindex(line,0),"corrupted:")) { }
  else if(!strcasecmp(lindex(line,0),"filter:")) { }
  else if(!strcasecmp(lindex(line,0),"filter_title:")) { }
  else if(!strcasecmp(lindex(line,0),"filter_comment:")) { }
  else if(!strcasecmp(lindex(line,0),"macro:")) { }
  else if(!strcasecmp(lindex(line,0),"macro_title:")) { }
  else if(!strcasecmp(lindex(line,0),"macro_comment:")) { }
  else if(!strcasecmp(lindex(line,0),"awk_macro:")) { }
  else if(!strcasecmp(lindex(line,0),"awk_macro_title:")) { }
  else if(!strcasecmp(lindex(line,0),"awk_macro_comment:")) { }
  else if(!strcasecmp(lindex(line,0),"sed_macro:")) { }
  else if(!strcasecmp(lindex(line,0),"sed_macro_title:")) { }
  else if(!strcasecmp(lindex(line,0),"sed_macro_comment:")) { }
  else if(!strcasecmp(lindex(line,0),"#")) { }
  else fprintf(stderr, "GXedit: Unknown config option: %s\n", lindex(line,0));
 }
 fclose(fd);
}

void make_cfg()
{
 fd = fopen(line, "w");
 fputs("# This is the configuration file for GXedit\n", fd);
 fputs("toolbar: 1\n", fd);
 fputs("full_toolbar: 1\n", fd);
 fputs("netbar: 1\n", fd);
 fputs("htmlbar: 0\n", fd);
 fputs("show_line: 0\n", fd);
 fputs("show_project: 1\n", fd);
 fputs("last_files: 1\n", fd);
 fputs("syntax_h: 0\n", fd);
 fputs("h_style: 0\n", fd);
 fputs("fortune: 0\n", fd);
 fputs("old_open: 0\n", fd);
 fputs("cvs_z3: 1\n", fd);
 fputs("scrollbar_location: 0\n", fd);
 fputs("use_socks: 0\n", fd);
 fputs("auto_indent: 0\n", fd);
 fputs("mail_cmd: 0\n", fd);
 fputs("use_xrn: 1\n", fd);
 fputs("access: 0\n", fd);
 fputs("tooltips: 1\n", fd);
 fputs("x_size: 700\n", fd);
 fputs("y_size: 400\n", fd);
 fputs("x_position: 20\n", fd);
 fputs("y_position: 20\n", fd);
 fputs("color: black\n", fd);
 extract_color(&color, 0, 0, 0);
 gdk_color_alloc(cmap, &color);
 fputs("debug: 0\n", fd);
 fputs("images: xv\n", fd);
 fputs("line_wrap: 1\n", fd);
 fputs("page_width: 0\n", fd);
 fputs("tab_width: 8\n", fd);
 fputs("xfm: xfm\n", fd);
 fputs("compile: gcc -Wall -o ./a.out -g $f\n", fd);
 fputs("gzip: gzip -d\n", fd);
 fputs("document_dir: \n", fd);
 fputs("dictionary: english\n", fd);
 fputs("cvs_root: :pserver:anonymous@anoncvs.gnome.org:/cvs/gnome", fd);
 fputs("cvs_dir: /usr/src/cvs", fd);
 fputs("mail_server: localhost\n", fd);
 fputs("mail_address: root@localhost\n", fd);
 fputs("default_news: \n", fd); 
 fputs("default_web: \n", fd); 
 fputs("mail_reply: 0\n", fd);
 fputs("mirror_server: localhost\n", fd);
 fputs("news_server: localhost\n", fd);
 fputs("font: -adobe-helvetica-*-r-*-*-12-*-*-*-*-*-*-*\n", fd);
 fputs("background: white\n", fd);
 fputs("pixmap: none\n", fd);
 fputs("login_name: ", fd);
 fputs(getenv("LOGNAME"), fd);
 fputs("\n", fd);
 fputs("awk_macro_title: 1 To upper chars\n", fd);
 fputs("awk_macro: 1 { print toupper($0) }\n", fd);
 fputs("awk_macro_title: 2 Remove empty lines\n", fd);
 fputs("awk_macro: 2 length > 0\n", fd);
 fputs("sed_macro_title: 3 Remove all spaces\n", fd);
 fputs("sed_macro: 3 s/ //g\n", fd);
 fputs("filter_title: 1 Import a .dvi file\n", fd);
 fputs("filter_comment: 1 Filter available from www.mesa.nl/pub/dvi2tty/dvi2tty-5.3.tar.gz\n", fd);
 fputs("filter: 1 /usr/local/bin/dvi2tty $i > $o\n", fd);
 fputs("filter_title: 2 Query an RPM package\n", fd);
 fputs("filter_comment: 2 RPM available from ftp.redhat.com\n", fd);
 fputs("filter: 2 rpm -qp $i > $o\n", fd);
 fputs("filter: 2 rpm -qip $i >> $o\n", fd);
 fputs("filter: 2 rpm -qlp $i >> $o\n", fd);
 fputs("filter_title: 3 Import a WP5 file\n", fd);
 fputs("filter_comment: 3 Filter available from sunsite.unc.edu/pub/Linux/utils/text/wp2x.zip\n", fd);
 fputs("filter: 3 wp2x /usr/local/lib/wp2x/ascii.cfg $i > $o\n", fd);
 fputs("filter_title: 4 Import a Word 6 file\n", fd);
 fputs("filter_comment: 4 Filter available from ftp.tex.ac.uk/tex-archive/tools/word2x\n", fd);
 fputs("filter: 4 word2x -f text $i $o\n", fd);
 fclose(fd);
}

void convert_to_hex(char *str)
{
 int i;
 for(i = 0; i < strlen(str); i++)
 {
  sprintf(temp, "0x%s ", base_change(16, (int)*(str + i)));
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, temp, -1);
 }
 gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
}

void run_script(char *file)
{
 int i;
 FILE *ffd;
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 ffd = fopen(file, "r");
 if(ffd==NULL)
 {
  msgbox("Can't open script file");
  return;
 }
 while(fgets(line, 500, ffd)!=NULL)
 {
  if(line[strlen(line)-1]=='\n' || line[strlen(line)-1]=='\r')
  line[strlen(line)-1]=' ';
  if(!strcasecmp(lindex(line,0),"command:"))
  {
   strcpy(temp,"");
   for(i=1;lindex(line,i)!=NULL;i++)
   {
    if(!strcasecmp(lindex(line,i),"!tmpname")) strcat(temp, tmp_name);
    else if(!strcasecmp(lindex(line,i),"!login")) strcat(temp, login);
    else if(!strcasecmp(lindex(line,i),"!xterm")) strcat(temp, XTERM);
    else if(!strcasecmp(lindex(line,i),"!images")) strcat(temp, images);
    else if(!strcasecmp(lindex(line,i),"!program")) strcat(temp, progname);
    else if(!strcasecmp(lindex(line,i),"!mail-server")) strcat(temp, mail_server);
    else if(!strcasecmp(lindex(line,i),"!news-server")) strcat(temp, news_server);
    else if(!strcasecmp(lindex(line,i),"!file-manager")) strcat(temp, xfm);
    else if(!strcasecmp(lindex(line,i),"!documents-dir")) strcat(temp, doc_dir);
    else if(!strcasecmp(lindex(line,i),"!gzip")) strcat(temp, gzip);
    else if(!strcasecmp(lindex(line,i),"!compile")) strcat(temp, compile);
    else strcat(temp,lindex(line,i));
    strcat(temp," ");
   }
   system(temp);
  }
  else if(!strcasecmp(lindex(line,0),"command-bg:"))
  {
   strcpy(temp,"");
   for(i=1;lindex(line,i)!=NULL;i++)
   {
    if(!strcasecmp(lindex(line,i),"!tmpname")) strcat(temp, tmp_name);
    else if(!strcasecmp(lindex(line,i),"!login")) strcat(temp, login);
    else if(!strcasecmp(lindex(line,i),"!images")) strcat(temp, images);
    else if(!strcasecmp(lindex(line,i),"!program")) strcat(temp, progname);
    else if(!strcasecmp(lindex(line,i),"!mail-server")) strcat(temp, mail_server);
    else if(!strcasecmp(lindex(line,i),"!xterm")) strcat(temp, XTERM);
    else if(!strcasecmp(lindex(line,i),"!news-server")) strcat(temp, news_server);
    else if(!strcasecmp(lindex(line,i),"!file-manager")) strcat(temp, xfm);
    else if(!strcasecmp(lindex(line,i),"!documents-dir")) strcat(temp, doc_dir);
    else if(!strcasecmp(lindex(line,i),"!gzip")) strcat(temp, gzip);
    else if(!strcasecmp(lindex(line,i),"!compile")) strcat(temp, compile);
    else strcat(temp,lindex(line,i));
    strcat(temp," ");
   }
   strcat(temp,"&");
   system(temp);
  }
  else if(!strcasecmp(lindex(line,0),"load-file:"))
  {
   if(!strcasecmp("!tmpname",lindex(line,1))) strcpy(filename,tmp_name);
   else strcpy(filename,lindex(line,1));
   sprintf(line, "GXedit %s [%s]\n", VERSION, filename);
   gtk_window_set_title (GTK_WINDOW (window), line);
   open_file(filename, "Can't open file for reading\n");
   sprintf(temp, "%s.gxnote", filename);
   fd = fopen(temp, "r");
   if(fd!=NULL)
   {
    create_note(fd);
    fclose(fd);
   }
  }
  else if(!strcasecmp(lindex(line,0),"chdir:"))
  {
   if(lindex(line,1)!=NULL) chdir(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"load-file-new:"))
  {
   if(!strcasecmp("!tmpname",lindex(line,1))) sprintf(temp,"%s %s &",progname,tmp_name);
   else sprintf(temp,"%s %s &",progname,lindex(line,1));
   system(temp);
  }
 }
 if(ffd!=NULL) fclose(ffd);
 if(strcasecmp(doc_dir,""))
 {
  strcpy(temp, lindex(doc_dir,0));
  chdir(temp);
 }
}

char *base_change(int base, int i)
{
 int k;
 char result[50];
 strcpy(result,"");
 while(i > 0)
 {
  k = i % base;
  i = i / base;
  if(k > 9)
  {
   if(k==10) strcat(result, "A");
   if(k==11) strcat(result, "B");
   if(k==12) strcat(result, "C");
   if(k==13) strcat(result, "D");
   if(k==14) strcat(result, "E");
   if(k==15) strcat(result, "F");
  }
  else sprintf(result, "%s%d", result, k);
 }
 return g_strdup(result);
}
