/*
 * Data, and supporting functions, for PostScript-based output
 * formats.
 */

#include "halibut.h"
#include "paper.h"

/* ----------------------------------------------------------------------
 * Mapping between PS character names (/aacute, /zcaron etc) and
 * Unicode code points.
 * 
 * Generated from the Adobe Glyph List at
 * 
 *   http://partners.adobe.com/asn/tech/type/glyphlist.txt
 * 
 * by a succession of Perl/sh fragments, quoted alongside each
 * array.
 */

/*

grep '^[^#;][^;]*;[^ ][^ ][^ ][^ ]$' glyphlist.txt | sort -t\; +0 -1 | \
    cut -f1 -d\; | perl -ne 'chomp; print "\"$_\", "' | \
    fold -s -w68 | sed 's/^/    /'; echo

 */
static const char *const ps_glyphs_alphabetic[] = {
    "A", "AE", "AEacute", "AEmacron", "AEsmall", "Aacute", 
    "Aacutesmall", "Abreve", "Abreveacute", "Abrevecyrillic", 
    "Abrevedotbelow", "Abrevegrave", "Abrevehookabove", "Abrevetilde", 
    "Acaron", "Acircle", "Acircumflex", "Acircumflexacute", 
    "Acircumflexdotbelow", "Acircumflexgrave", "Acircumflexhookabove", 
    "Acircumflexsmall", "Acircumflextilde", "Acute", "Acutesmall", 
    "Acyrillic", "Adblgrave", "Adieresis", "Adieresiscyrillic", 
    "Adieresismacron", "Adieresissmall", "Adotbelow", "Adotmacron", 
    "Agrave", "Agravesmall", "Ahookabove", "Aiecyrillic", 
    "Ainvertedbreve", "Alpha", "Alphatonos", "Amacron", "Amonospace", 
    "Aogonek", "Aring", "Aringacute", "Aringbelow", "Aringsmall", 
    "Asmall", "Atilde", "Atildesmall", "Aybarmenian", "B", "Bcircle", 
    "Bdotaccent", "Bdotbelow", "Becyrillic", "Benarmenian", "Beta", 
    "Bhook", "Blinebelow", "Bmonospace", "Brevesmall", "Bsmall", 
    "Btopbar", "C", "Caarmenian", "Cacute", "Caron", "Caronsmall", 
    "Ccaron", "Ccedilla", "Ccedillaacute", "Ccedillasmall", "Ccircle", 
    "Ccircumflex", "Cdot", "Cdotaccent", "Cedillasmall", "Chaarmenian", 
    "Cheabkhasiancyrillic", "Checyrillic", 
    "Chedescenderabkhasiancyrillic", "Chedescendercyrillic", 
    "Chedieresiscyrillic", "Cheharmenian", "Chekhakassiancyrillic", 
    "Cheverticalstrokecyrillic", "Chi", "Chook", "Circumflexsmall", 
    "Cmonospace", "Coarmenian", "Csmall", "D", "DZ", "DZcaron", 
    "Daarmenian", "Dafrican", "Dcaron", "Dcedilla", "Dcircle", 
    "Dcircumflexbelow", "Dcroat", "Ddotaccent", "Ddotbelow", 
    "Decyrillic", "Deicoptic", "Delta", "Deltagreek", "Dhook", 
    "Dieresis", "DieresisAcute", "DieresisGrave", "Dieresissmall", 
    "Digammagreek", "Djecyrillic", "Dlinebelow", "Dmonospace", 
    "Dotaccentsmall", "Dslash", "Dsmall", "Dtopbar", "Dz", "Dzcaron", 
    "Dzeabkhasiancyrillic", "Dzecyrillic", "Dzhecyrillic", "E", 
    "Eacute", "Eacutesmall", "Ebreve", "Ecaron", "Ecedillabreve", 
    "Echarmenian", "Ecircle", "Ecircumflex", "Ecircumflexacute", 
    "Ecircumflexbelow", "Ecircumflexdotbelow", "Ecircumflexgrave", 
    "Ecircumflexhookabove", "Ecircumflexsmall", "Ecircumflextilde", 
    "Ecyrillic", "Edblgrave", "Edieresis", "Edieresissmall", "Edot", 
    "Edotaccent", "Edotbelow", "Efcyrillic", "Egrave", "Egravesmall", 
    "Eharmenian", "Ehookabove", "Eightroman", "Einvertedbreve", 
    "Eiotifiedcyrillic", "Elcyrillic", "Elevenroman", "Emacron", 
    "Emacronacute", "Emacrongrave", "Emcyrillic", "Emonospace", 
    "Encyrillic", "Endescendercyrillic", "Eng", "Enghecyrillic", 
    "Enhookcyrillic", "Eogonek", "Eopen", "Epsilon", "Epsilontonos", 
    "Ercyrillic", "Ereversed", "Ereversedcyrillic", "Escyrillic", 
    "Esdescendercyrillic", "Esh", "Esmall", "Eta", "Etarmenian", 
    "Etatonos", "Eth", "Ethsmall", "Etilde", "Etildebelow", "Euro", 
    "Ezh", "Ezhcaron", "Ezhreversed", "F", "Fcircle", "Fdotaccent", 
    "Feharmenian", "Feicoptic", "Fhook", "Fitacyrillic", "Fiveroman", 
    "Fmonospace", "Fourroman", "Fsmall", "G", "GBsquare", "Gacute", 
    "Gamma", "Gammaafrican", "Gangiacoptic", "Gbreve", "Gcaron", 
    "Gcedilla", "Gcircle", "Gcircumflex", "Gcommaaccent", "Gdot", 
    "Gdotaccent", "Gecyrillic", "Ghadarmenian", 
    "Ghemiddlehookcyrillic", "Ghestrokecyrillic", "Gheupturncyrillic", 
    "Ghook", "Gimarmenian", "Gjecyrillic", "Gmacron", "Gmonospace", 
    "Grave", "Gravesmall", "Gsmall", "Gsmallhook", "Gstroke", "H", 
    "H18533", "H18543", "H18551", "H22073", "HPsquare", 
    "Haabkhasiancyrillic", "Hadescendercyrillic", "Hardsigncyrillic", 
    "Hbar", "Hbrevebelow", "Hcedilla", "Hcircle", "Hcircumflex", 
    "Hdieresis", "Hdotaccent", "Hdotbelow", "Hmonospace", "Hoarmenian", 
    "Horicoptic", "Hsmall", "Hungarumlaut", "Hungarumlautsmall", 
    "Hzsquare", "I", "IAcyrillic", "IJ", "IUcyrillic", "Iacute", 
    "Iacutesmall", "Ibreve", "Icaron", "Icircle", "Icircumflex", 
    "Icircumflexsmall", "Icyrillic", "Idblgrave", "Idieresis", 
    "Idieresisacute", "Idieresiscyrillic", "Idieresissmall", "Idot", 
    "Idotaccent", "Idotbelow", "Iebrevecyrillic", "Iecyrillic", 
    "Ifraktur", "Igrave", "Igravesmall", "Ihookabove", "Iicyrillic", 
    "Iinvertedbreve", "Iishortcyrillic", "Imacron", "Imacroncyrillic", 
    "Imonospace", "Iniarmenian", "Iocyrillic", "Iogonek", "Iota", 
    "Iotaafrican", "Iotadieresis", "Iotatonos", "Ismall", "Istroke", 
    "Itilde", "Itildebelow", "Izhitsacyrillic", 
    "Izhitsadblgravecyrillic", "J", "Jaarmenian", "Jcircle", 
    "Jcircumflex", "Jecyrillic", "Jheharmenian", "Jmonospace", 
    "Jsmall", "K", "KBsquare", "KKsquare", "Kabashkircyrillic", 
    "Kacute", "Kacyrillic", "Kadescendercyrillic", "Kahookcyrillic", 
    "Kappa", "Kastrokecyrillic", "Kaverticalstrokecyrillic", "Kcaron", 
    "Kcedilla", "Kcircle", "Kcommaaccent", "Kdotbelow", "Keharmenian", 
    "Kenarmenian", "Khacyrillic", "Kheicoptic", "Khook", "Kjecyrillic", 
    "Klinebelow", "Kmonospace", "Koppacyrillic", "Koppagreek", 
    "Ksicyrillic", "Ksmall", "L", "LJ", "LL", "Lacute", "Lambda", 
    "Lcaron", "Lcedilla", "Lcircle", "Lcircumflexbelow", 
    "Lcommaaccent", "Ldot", "Ldotaccent", "Ldotbelow", 
    "Ldotbelowmacron", "Liwnarmenian", "Lj", "Ljecyrillic", 
    "Llinebelow", "Lmonospace", "Lslash", "Lslashsmall", "Lsmall", "M", 
    "MBsquare", "Macron", "Macronsmall", "Macute", "Mcircle", 
    "Mdotaccent", "Mdotbelow", "Menarmenian", "Mmonospace", "Msmall", 
    "Mturned", "Mu", "N", "NJ", "Nacute", "Ncaron", "Ncedilla", 
    "Ncircle", "Ncircumflexbelow", "Ncommaaccent", "Ndotaccent", 
    "Ndotbelow", "Nhookleft", "Nineroman", "Nj", "Njecyrillic", 
    "Nlinebelow", "Nmonospace", "Nowarmenian", "Nsmall", "Ntilde", 
    "Ntildesmall", "Nu", "O", "OE", "OEsmall", "Oacute", "Oacutesmall", 
    "Obarredcyrillic", "Obarreddieresiscyrillic", "Obreve", "Ocaron", 
    "Ocenteredtilde", "Ocircle", "Ocircumflex", "Ocircumflexacute", 
    "Ocircumflexdotbelow", "Ocircumflexgrave", "Ocircumflexhookabove", 
    "Ocircumflexsmall", "Ocircumflextilde", "Ocyrillic", "Odblacute", 
    "Odblgrave", "Odieresis", "Odieresiscyrillic", "Odieresissmall", 
    "Odotbelow", "Ogoneksmall", "Ograve", "Ogravesmall", "Oharmenian", 
    "Ohm", "Ohookabove", "Ohorn", "Ohornacute", "Ohorndotbelow", 
    "Ohorngrave", "Ohornhookabove", "Ohorntilde", "Ohungarumlaut", 
    "Oi", "Oinvertedbreve", "Omacron", "Omacronacute", "Omacrongrave", 
    "Omega", "Omegacyrillic", "Omegagreek", "Omegaroundcyrillic", 
    "Omegatitlocyrillic", "Omegatonos", "Omicron", "Omicrontonos", 
    "Omonospace", "Oneroman", "Oogonek", "Oogonekmacron", "Oopen", 
    "Oslash", "Oslashacute", "Oslashsmall", "Osmall", "Ostrokeacute", 
    "Otcyrillic", "Otilde", "Otildeacute", "Otildedieresis", 
    "Otildesmall", "P", "Pacute", "Pcircle", "Pdotaccent", 
    "Pecyrillic", "Peharmenian", "Pemiddlehookcyrillic", "Phi", 
    "Phook", "Pi", "Piwrarmenian", "Pmonospace", "Psi", "Psicyrillic", 
    "Psmall", "Q", "Qcircle", "Qmonospace", "Qsmall", "R", 
    "Raarmenian", "Racute", "Rcaron", "Rcedilla", "Rcircle", 
    "Rcommaaccent", "Rdblgrave", "Rdotaccent", "Rdotbelow", 
    "Rdotbelowmacron", "Reharmenian", "Rfraktur", "Rho", "Ringsmall", 
    "Rinvertedbreve", "Rlinebelow", "Rmonospace", "Rsmall", 
    "Rsmallinverted", "Rsmallinvertedsuperior", "S", "SF010000", 
    "SF020000", "SF030000", "SF040000", "SF050000", "SF060000", 
    "SF070000", "SF080000", "SF090000", "SF100000", "SF110000", 
    "SF190000", "SF200000", "SF210000", "SF220000", "SF230000", 
    "SF240000", "SF250000", "SF260000", "SF270000", "SF280000", 
    "SF360000", "SF370000", "SF380000", "SF390000", "SF400000", 
    "SF410000", "SF420000", "SF430000", "SF440000", "SF450000", 
    "SF460000", "SF470000", "SF480000", "SF490000", "SF500000", 
    "SF510000", "SF520000", "SF530000", "SF540000", "Sacute", 
    "Sacutedotaccent", "Sampigreek", "Scaron", "Scarondotaccent", 
    "Scaronsmall", "Scedilla", "Schwa", "Schwacyrillic", 
    "Schwadieresiscyrillic", "Scircle", "Scircumflex", "Scommaaccent", 
    "Sdotaccent", "Sdotbelow", "Sdotbelowdotaccent", "Seharmenian", 
    "Sevenroman", "Shaarmenian", "Shacyrillic", "Shchacyrillic", 
    "Sheicoptic", "Shhacyrillic", "Shimacoptic", "Sigma", "Sixroman", 
    "Smonospace", "Softsigncyrillic", "Ssmall", "Stigmagreek", "T", 
    "Tau", "Tbar", "Tcaron", "Tcedilla", "Tcircle", "Tcircumflexbelow", 
    "Tcommaaccent", "Tdotaccent", "Tdotbelow", "Tecyrillic", 
    "Tedescendercyrillic", "Tenroman", "Tetsecyrillic", "Theta", 
    "Thook", "Thorn", "Thornsmall", "Threeroman", "Tildesmall", 
    "Tiwnarmenian", "Tlinebelow", "Tmonospace", "Toarmenian", 
    "Tonefive", "Tonesix", "Tonetwo", "Tretroflexhook", "Tsecyrillic", 
    "Tshecyrillic", "Tsmall", "Twelveroman", "Tworoman", "U", "Uacute", 
    "Uacutesmall", "Ubreve", "Ucaron", "Ucircle", "Ucircumflex", 
    "Ucircumflexbelow", "Ucircumflexsmall", "Ucyrillic", "Udblacute", 
    "Udblgrave", "Udieresis", "Udieresisacute", "Udieresisbelow", 
    "Udieresiscaron", "Udieresiscyrillic", "Udieresisgrave", 
    "Udieresismacron", "Udieresissmall", "Udotbelow", "Ugrave", 
    "Ugravesmall", "Uhookabove", "Uhorn", "Uhornacute", 
    "Uhorndotbelow", "Uhorngrave", "Uhornhookabove", "Uhorntilde", 
    "Uhungarumlaut", "Uhungarumlautcyrillic", "Uinvertedbreve", 
    "Ukcyrillic", "Umacron", "Umacroncyrillic", "Umacrondieresis", 
    "Umonospace", "Uogonek", "Upsilon", "Upsilon1", 
    "Upsilonacutehooksymbolgreek", "Upsilonafrican", "Upsilondieresis", 
    "Upsilondieresishooksymbolgreek", "Upsilonhooksymbol", 
    "Upsilontonos", "Uring", "Ushortcyrillic", "Usmall", 
    "Ustraightcyrillic", "Ustraightstrokecyrillic", "Utilde", 
    "Utildeacute", "Utildebelow", "V", "Vcircle", "Vdotbelow", 
    "Vecyrillic", "Vewarmenian", "Vhook", "Vmonospace", "Voarmenian", 
    "Vsmall", "Vtilde", "W", "Wacute", "Wcircle", "Wcircumflex", 
    "Wdieresis", "Wdotaccent", "Wdotbelow", "Wgrave", "Wmonospace", 
    "Wsmall", "X", "Xcircle", "Xdieresis", "Xdotaccent", "Xeharmenian", 
    "Xi", "Xmonospace", "Xsmall", "Y", "Yacute", "Yacutesmall", 
    "Yatcyrillic", "Ycircle", "Ycircumflex", "Ydieresis", 
    "Ydieresissmall", "Ydotaccent", "Ydotbelow", "Yericyrillic", 
    "Yerudieresiscyrillic", "Ygrave", "Yhook", "Yhookabove", 
    "Yiarmenian", "Yicyrillic", "Yiwnarmenian", "Ymonospace", "Ysmall", 
    "Ytilde", "Yusbigcyrillic", "Yusbigiotifiedcyrillic", 
    "Yuslittlecyrillic", "Yuslittleiotifiedcyrillic", "Z", 
    "Zaarmenian", "Zacute", "Zcaron", "Zcaronsmall", "Zcircle", 
    "Zcircumflex", "Zdot", "Zdotaccent", "Zdotbelow", "Zecyrillic", 
    "Zedescendercyrillic", "Zedieresiscyrillic", "Zeta", "Zhearmenian", 
    "Zhebrevecyrillic", "Zhecyrillic", "Zhedescendercyrillic", 
    "Zhedieresiscyrillic", "Zlinebelow", "Zmonospace", "Zsmall", 
    "Zstroke", "a", "aabengali", "aacute", "aadeva", "aagujarati", 
    "aagurmukhi", "aamatragurmukhi", "aarusquare", 
    "aavowelsignbengali", "aavowelsigndeva", "aavowelsigngujarati", 
    "abbreviationmarkarmenian", "abbreviationsigndeva", "abengali", 
    "abopomofo", "abreve", "abreveacute", "abrevecyrillic", 
    "abrevedotbelow", "abrevegrave", "abrevehookabove", "abrevetilde", 
    "acaron", "acircle", "acircumflex", "acircumflexacute", 
    "acircumflexdotbelow", "acircumflexgrave", "acircumflexhookabove", 
    "acircumflextilde", "acute", "acutebelowcmb", "acutecmb", 
    "acutecomb", "acutedeva", "acutelowmod", "acutetonecmb", 
    "acyrillic", "adblgrave", "addakgurmukhi", "adeva", "adieresis", 
    "adieresiscyrillic", "adieresismacron", "adotbelow", "adotmacron", 
    "ae", "aeacute", "aekorean", "aemacron", "afii00208", "afii08941", 
    "afii10017", "afii10018", "afii10019", "afii10020", "afii10021", 
    "afii10022", "afii10023", "afii10024", "afii10025", "afii10026", 
    "afii10027", "afii10028", "afii10029", "afii10030", "afii10031", 
    "afii10032", "afii10033", "afii10034", "afii10035", "afii10036", 
    "afii10037", "afii10038", "afii10039", "afii10040", "afii10041", 
    "afii10042", "afii10043", "afii10044", "afii10045", "afii10046", 
    "afii10047", "afii10048", "afii10049", "afii10050", "afii10051", 
    "afii10052", "afii10053", "afii10054", "afii10055", "afii10056", 
    "afii10057", "afii10058", "afii10059", "afii10060", "afii10061", 
    "afii10062", "afii10063", "afii10064", "afii10065", "afii10066", 
    "afii10067", "afii10068", "afii10069", "afii10070", "afii10071", 
    "afii10072", "afii10073", "afii10074", "afii10075", "afii10076", 
    "afii10077", "afii10078", "afii10079", "afii10080", "afii10081", 
    "afii10082", "afii10083", "afii10084", "afii10085", "afii10086", 
    "afii10087", "afii10088", "afii10089", "afii10090", "afii10091", 
    "afii10092", "afii10093", "afii10094", "afii10095", "afii10096", 
    "afii10097", "afii10098", "afii10099", "afii10100", "afii10101", 
    "afii10102", "afii10103", "afii10104", "afii10105", "afii10106", 
    "afii10107", "afii10108", "afii10109", "afii10110", "afii10145", 
    "afii10146", "afii10147", "afii10148", "afii10192", "afii10193", 
    "afii10194", "afii10195", "afii10196", "afii10831", "afii10832", 
    "afii10846", "afii299", "afii300", "afii301", "afii57381", 
    "afii57388", "afii57392", "afii57393", "afii57394", "afii57395", 
    "afii57396", "afii57397", "afii57398", "afii57399", "afii57400", 
    "afii57401", "afii57403", "afii57407", "afii57409", "afii57410", 
    "afii57411", "afii57412", "afii57413", "afii57414", "afii57415", 
    "afii57416", "afii57417", "afii57418", "afii57419", "afii57420", 
    "afii57421", "afii57422", "afii57423", "afii57424", "afii57425", 
    "afii57426", "afii57427", "afii57428", "afii57429", "afii57430", 
    "afii57431", "afii57432", "afii57433", "afii57434", "afii57440", 
    "afii57441", "afii57442", "afii57443", "afii57444", "afii57445", 
    "afii57446", "afii57448", "afii57449", "afii57450", "afii57451", 
    "afii57452", "afii57453", "afii57454", "afii57455", "afii57456", 
    "afii57457", "afii57458", "afii57470", "afii57505", "afii57506", 
    "afii57507", "afii57508", "afii57509", "afii57511", "afii57512", 
    "afii57513", "afii57514", "afii57519", "afii57534", "afii57636", 
    "afii57645", "afii57658", "afii57664", "afii57665", "afii57666", 
    "afii57667", "afii57668", "afii57669", "afii57670", "afii57671", 
    "afii57672", "afii57673", "afii57674", "afii57675", "afii57676", 
    "afii57677", "afii57678", "afii57679", "afii57680", "afii57681", 
    "afii57682", "afii57683", "afii57684", "afii57685", "afii57686", 
    "afii57687", "afii57688", "afii57689", "afii57690", "afii57694", 
    "afii57695", "afii57700", "afii57705", "afii57716", "afii57717", 
    "afii57718", "afii57723", "afii57793", "afii57794", "afii57795", 
    "afii57796", "afii57797", "afii57798", "afii57799", "afii57800", 
    "afii57801", "afii57802", "afii57803", "afii57804", "afii57806", 
    "afii57807", "afii57839", "afii57841", "afii57842", "afii57929", 
    "afii61248", "afii61289", "afii61352", "afii61573", "afii61574", 
    "afii61575", "afii61664", "afii63167", "afii64937", "agrave", 
    "agujarati", "agurmukhi", "ahiragana", "ahookabove", "aibengali", 
    "aibopomofo", "aideva", "aiecyrillic", "aigujarati", "aigurmukhi", 
    "aimatragurmukhi", "ainarabic", "ainfinalarabic", 
    "aininitialarabic", "ainmedialarabic", "ainvertedbreve", 
    "aivowelsignbengali", "aivowelsigndeva", "aivowelsigngujarati", 
    "akatakana", "akatakanahalfwidth", "akorean", "alef", "alefarabic", 
    "alefdageshhebrew", "aleffinalarabic", "alefhamzaabovearabic", 
    "alefhamzaabovefinalarabic", "alefhamzabelowarabic", 
    "alefhamzabelowfinalarabic", "alefhebrew", "aleflamedhebrew", 
    "alefmaddaabovearabic", "alefmaddaabovefinalarabic", 
    "alefmaksuraarabic", "alefmaksurafinalarabic", 
    "alefmaksurainitialarabic", "alefmaksuramedialarabic", 
    "alefpatahhebrew", "alefqamatshebrew", "aleph", "allequal", 
    "alpha", "alphatonos", "amacron", "amonospace", "ampersand", 
    "ampersandmonospace", "ampersandsmall", "amsquare", "anbopomofo", 
    "angbopomofo", "angkhankhuthai", "angle", "anglebracketleft", 
    "anglebracketleftvertical", "anglebracketright", 
    "anglebracketrightvertical", "angleleft", "angleright", "angstrom", 
    "anoteleia", "anudattadeva", "anusvarabengali", "anusvaradeva", 
    "anusvaragujarati", "aogonek", "apaatosquare", "aparen", 
    "apostrophearmenian", "apostrophemod", "apple", "approaches", 
    "approxequal", "approxequalorimage", "approximatelyequal", 
    "araeaekorean", "araeakorean", "arc", "arighthalfring", "aring", 
    "aringacute", "aringbelow", "arrowboth", "arrowdashdown", 
    "arrowdashleft", "arrowdashright", "arrowdashup", "arrowdblboth", 
    "arrowdbldown", "arrowdblleft", "arrowdblright", "arrowdblup", 
    "arrowdown", "arrowdownleft", "arrowdownright", "arrowdownwhite", 
    "arrowheaddownmod", "arrowheadleftmod", "arrowheadrightmod", 
    "arrowheadupmod", "arrowhorizex", "arrowleft", "arrowleftdbl", 
    "arrowleftdblstroke", "arrowleftoverright", "arrowleftwhite", 
    "arrowright", "arrowrightdblstroke", "arrowrightheavy", 
    "arrowrightoverleft", "arrowrightwhite", "arrowtableft", 
    "arrowtabright", "arrowup", "arrowupdn", "arrowupdnbse", 
    "arrowupdownbase", "arrowupleft", "arrowupleftofdown", 
    "arrowupright", "arrowupwhite", "arrowvertex", "asciicircum", 
    "asciicircummonospace", "asciitilde", "asciitildemonospace", 
    "ascript", "ascriptturned", "asmallhiragana", "asmallkatakana", 
    "asmallkatakanahalfwidth", "asterisk", "asteriskaltonearabic", 
    "asteriskarabic", "asteriskmath", "asteriskmonospace", 
    "asterisksmall", "asterism", "asuperior", "asymptoticallyequal", 
    "at", "atilde", "atmonospace", "atsmall", "aturned", "aubengali", 
    "aubopomofo", "audeva", "augujarati", "augurmukhi", 
    "aulengthmarkbengali", "aumatragurmukhi", "auvowelsignbengali", 
    "auvowelsigndeva", "auvowelsigngujarati", "avagrahadeva", 
    "aybarmenian", "ayin", "ayinaltonehebrew", "ayinhebrew", "b", 
    "babengali", "backslash", "backslashmonospace", "badeva", 
    "bagujarati", "bagurmukhi", "bahiragana", "bahtthai", "bakatakana", 
    "bar", "barmonospace", "bbopomofo", "bcircle", "bdotaccent", 
    "bdotbelow", "beamedsixteenthnotes", "because", "becyrillic", 
    "beharabic", "behfinalarabic", "behinitialarabic", "behiragana", 
    "behmedialarabic", "behmeeminitialarabic", "behmeemisolatedarabic", 
    "behnoonfinalarabic", "bekatakana", "benarmenian", "bet", "beta", 
    "betasymbolgreek", "betdagesh", "betdageshhebrew", "bethebrew", 
    "betrafehebrew", "bhabengali", "bhadeva", "bhagujarati", 
    "bhagurmukhi", "bhook", "bihiragana", "bikatakana", 
    "bilabialclick", "bindigurmukhi", "birusquare", "blackcircle", 
    "blackdiamond", "blackdownpointingtriangle", 
    "blackleftpointingpointer", "blackleftpointingtriangle", 
    "blacklenticularbracketleft", "blacklenticularbracketleftvertical", 
    "blacklenticularbracketright", 
    "blacklenticularbracketrightvertical", "blacklowerlefttriangle", 
    "blacklowerrighttriangle", "blackrectangle", 
    "blackrightpointingpointer", "blackrightpointingtriangle", 
    "blacksmallsquare", "blacksmilingface", "blacksquare", "blackstar", 
    "blackupperlefttriangle", "blackupperrighttriangle", 
    "blackuppointingsmalltriangle", "blackuppointingtriangle", "blank", 
    "blinebelow", "block", "bmonospace", "bobaimaithai", "bohiragana", 
    "bokatakana", "bparen", "bqsquare", "braceex", "braceleft", 
    "braceleftbt", "braceleftmid", "braceleftmonospace", 
    "braceleftsmall", "bracelefttp", "braceleftvertical", "braceright", 
    "bracerightbt", "bracerightmid", "bracerightmonospace", 
    "bracerightsmall", "bracerighttp", "bracerightvertical", 
    "bracketleft", "bracketleftbt", "bracketleftex", 
    "bracketleftmonospace", "bracketlefttp", "bracketright", 
    "bracketrightbt", "bracketrightex", "bracketrightmonospace", 
    "bracketrighttp", "breve", "brevebelowcmb", "brevecmb", 
    "breveinvertedbelowcmb", "breveinvertedcmb", 
    "breveinverteddoublecmb", "bridgebelowcmb", 
    "bridgeinvertedbelowcmb", "brokenbar", "bstroke", "bsuperior", 
    "btopbar", "buhiragana", "bukatakana", "bullet", "bulletinverse", 
    "bulletoperator", "bullseye", "c", "caarmenian", "cabengali", 
    "cacute", "cadeva", "cagujarati", "cagurmukhi", "calsquare", 
    "candrabindubengali", "candrabinducmb", "candrabindudeva", 
    "candrabindugujarati", "capslock", "careof", "caron", 
    "caronbelowcmb", "caroncmb", "carriagereturn", "cbopomofo", 
    "ccaron", "ccedilla", "ccedillaacute", "ccircle", "ccircumflex", 
    "ccurl", "cdot", "cdotaccent", "cdsquare", "cedilla", "cedillacmb", 
    "cent", "centigrade", "centinferior", "centmonospace", 
    "centoldstyle", "centsuperior", "chaarmenian", "chabengali", 
    "chadeva", "chagujarati", "chagurmukhi", "chbopomofo", 
    "cheabkhasiancyrillic", "checkmark", "checyrillic", 
    "chedescenderabkhasiancyrillic", "chedescendercyrillic", 
    "chedieresiscyrillic", "cheharmenian", "chekhakassiancyrillic", 
    "cheverticalstrokecyrillic", "chi", "chieuchacirclekorean", 
    "chieuchaparenkorean", "chieuchcirclekorean", "chieuchkorean", 
    "chieuchparenkorean", "chochangthai", "chochanthai", 
    "chochingthai", "chochoethai", "chook", "cieucacirclekorean", 
    "cieucaparenkorean", "cieuccirclekorean", "cieuckorean", 
    "cieucparenkorean", "cieucuparenkorean", "circle", 
    "circlemultiply", "circleot", "circleplus", "circlepostalmark", 
    "circlewithlefthalfblack", "circlewithrighthalfblack", 
    "circumflex", "circumflexbelowcmb", "circumflexcmb", "clear", 
    "clickalveolar", "clickdental", "clicklateral", "clickretroflex", 
    "club", "clubsuitblack", "clubsuitwhite", "cmcubedsquare", 
    "cmonospace", "cmsquaredsquare", "coarmenian", "colon", 
    "colonmonetary", "colonmonospace", "colonsign", "colonsmall", 
    "colontriangularhalfmod", "colontriangularmod", "comma", 
    "commaabovecmb", "commaaboverightcmb", "commaaccent", 
    "commaarabic", "commaarmenian", "commainferior", "commamonospace", 
    "commareversedabovecmb", "commareversedmod", "commasmall", 
    "commasuperior", "commaturnedabovecmb", "commaturnedmod", 
    "compass", "congruent", "contourintegral", "control", "controlACK", 
    "controlBEL", "controlBS", "controlCAN", "controlCR", "controlDC1", 
    "controlDC2", "controlDC3", "controlDC4", "controlDEL", 
    "controlDLE", "controlEM", "controlENQ", "controlEOT", 
    "controlESC", "controlETB", "controlETX", "controlFF", "controlFS", 
    "controlGS", "controlHT", "controlLF", "controlNAK", "controlRS", 
    "controlSI", "controlSO", "controlSOT", "controlSTX", "controlSUB", 
    "controlSYN", "controlUS", "controlVT", "copyright", 
    "copyrightsans", "copyrightserif", "cornerbracketleft", 
    "cornerbracketlefthalfwidth", "cornerbracketleftvertical", 
    "cornerbracketright", "cornerbracketrighthalfwidth", 
    "cornerbracketrightvertical", "corporationsquare", "cosquare", 
    "coverkgsquare", "cparen", "cruzeiro", "cstretched", "curlyand", 
    "curlyor", "currency", "cyrBreve", "cyrFlex", "cyrbreve", 
    "cyrflex", "d", "daarmenian", "dabengali", "dadarabic", "dadeva", 
    "dadfinalarabic", "dadinitialarabic", "dadmedialarabic", "dagesh", 
    "dageshhebrew", "dagger", "daggerdbl", "dagujarati", "dagurmukhi", 
    "dahiragana", "dakatakana", "dalarabic", "dalet", "daletdagesh", 
    "daletdageshhebrew", "dalethebrew", "dalfinalarabic", 
    "dammaarabic", "dammalowarabic", "dammatanaltonearabic", 
    "dammatanarabic", "danda", "dargahebrew", "dargalefthebrew", 
    "dasiapneumatacyrilliccmb", "dblGrave", "dblanglebracketleft", 
    "dblanglebracketleftvertical", "dblanglebracketright", 
    "dblanglebracketrightvertical", "dblarchinvertedbelowcmb", 
    "dblarrowleft", "dblarrowright", "dbldanda", "dblgrave", 
    "dblgravecmb", "dblintegral", "dbllowline", "dbllowlinecmb", 
    "dbloverlinecmb", "dblprimemod", "dblverticalbar", 
    "dblverticallineabovecmb", "dbopomofo", "dbsquare", "dcaron", 
    "dcedilla", "dcircle", "dcircumflexbelow", "dcroat", "ddabengali", 
    "ddadeva", "ddagujarati", "ddagurmukhi", "ddalarabic", 
    "ddalfinalarabic", "dddhadeva", "ddhabengali", "ddhadeva", 
    "ddhagujarati", "ddhagurmukhi", "ddotaccent", "ddotbelow", 
    "decimalseparatorarabic", "decimalseparatorpersian", "decyrillic", 
    "degree", "dehihebrew", "dehiragana", "deicoptic", "dekatakana", 
    "deleteleft", "deleteright", "delta", "deltaturned", 
    "denominatorminusonenumeratorbengali", "dezh", "dhabengali", 
    "dhadeva", "dhagujarati", "dhagurmukhi", "dhook", "dialytikatonos", 
    "dialytikatonoscmb", "diamond", "diamondsuitwhite", "dieresis", 
    "dieresisacute", "dieresisbelowcmb", "dieresiscmb", 
    "dieresisgrave", "dieresistonos", "dihiragana", "dikatakana", 
    "dittomark", "divide", "divides", "divisionslash", "djecyrillic", 
    "dkshade", "dlinebelow", "dlsquare", "dmacron", "dmonospace", 
    "dnblock", "dochadathai", "dodekthai", "dohiragana", "dokatakana", 
    "dollar", "dollarinferior", "dollarmonospace", "dollaroldstyle", 
    "dollarsmall", "dollarsuperior", "dong", "dorusquare", "dotaccent", 
    "dotaccentcmb", "dotbelowcmb", "dotbelowcomb", "dotkatakana", 
    "dotlessi", "dotlessj", "dotlessjstrokehook", "dotmath", 
    "dottedcircle", "doubleyodpatah", "doubleyodpatahhebrew", 
    "downtackbelowcmb", "downtackmod", "dparen", "dsuperior", "dtail", 
    "dtopbar", "duhiragana", "dukatakana", "dz", "dzaltone", "dzcaron", 
    "dzcurl", "dzeabkhasiancyrillic", "dzecyrillic", "dzhecyrillic", 
    "e", "eacute", "earth", "ebengali", "ebopomofo", "ebreve", 
    "ecandradeva", "ecandragujarati", "ecandravowelsigndeva", 
    "ecandravowelsigngujarati", "ecaron", "ecedillabreve", 
    "echarmenian", "echyiwnarmenian", "ecircle", "ecircumflex", 
    "ecircumflexacute", "ecircumflexbelow", "ecircumflexdotbelow", 
    "ecircumflexgrave", "ecircumflexhookabove", "ecircumflextilde", 
    "ecyrillic", "edblgrave", "edeva", "edieresis", "edot", 
    "edotaccent", "edotbelow", "eegurmukhi", "eematragurmukhi", 
    "efcyrillic", "egrave", "egujarati", "eharmenian", "ehbopomofo", 
    "ehiragana", "ehookabove", "eibopomofo", "eight", "eightarabic", 
    "eightbengali", "eightcircle", "eightcircleinversesansserif", 
    "eightdeva", "eighteencircle", "eighteenparen", "eighteenperiod", 
    "eightgujarati", "eightgurmukhi", "eighthackarabic", 
    "eighthangzhou", "eighthnotebeamed", "eightideographicparen", 
    "eightinferior", "eightmonospace", "eightoldstyle", "eightparen", 
    "eightperiod", "eightpersian", "eightroman", "eightsuperior", 
    "eightthai", "einvertedbreve", "eiotifiedcyrillic", "ekatakana", 
    "ekatakanahalfwidth", "ekonkargurmukhi", "ekorean", "elcyrillic", 
    "element", "elevencircle", "elevenparen", "elevenperiod", 
    "elevenroman", "ellipsis", "ellipsisvertical", "emacron", 
    "emacronacute", "emacrongrave", "emcyrillic", "emdash", 
    "emdashvertical", "emonospace", "emphasismarkarmenian", "emptyset", 
    "enbopomofo", "encyrillic", "endash", "endashvertical", 
    "endescendercyrillic", "eng", "engbopomofo", "enghecyrillic", 
    "enhookcyrillic", "enspace", "eogonek", "eokorean", "eopen", 
    "eopenclosed", "eopenreversed", "eopenreversedclosed", 
    "eopenreversedhook", "eparen", "epsilon", "epsilontonos", "equal", 
    "equalmonospace", "equalsmall", "equalsuperior", "equivalence", 
    "erbopomofo", "ercyrillic", "ereversed", "ereversedcyrillic", 
    "escyrillic", "esdescendercyrillic", "esh", "eshcurl", 
    "eshortdeva", "eshortvowelsigndeva", "eshreversedloop", 
    "eshsquatreversed", "esmallhiragana", "esmallkatakana", 
    "esmallkatakanahalfwidth", "estimated", "esuperior", "eta", 
    "etarmenian", "etatonos", "eth", "etilde", "etildebelow", 
    "etnahtafoukhhebrew", "etnahtafoukhlefthebrew", "etnahtahebrew", 
    "etnahtalefthebrew", "eturned", "eukorean", "euro", 
    "evowelsignbengali", "evowelsigndeva", "evowelsigngujarati", 
    "exclam", "exclamarmenian", "exclamdbl", "exclamdown", 
    "exclamdownsmall", "exclammonospace", "exclamsmall", "existential", 
    "ezh", "ezhcaron", "ezhcurl", "ezhreversed", "ezhtail", "f", 
    "fadeva", "fagurmukhi", "fahrenheit", "fathaarabic", 
    "fathalowarabic", "fathatanarabic", "fbopomofo", "fcircle", 
    "fdotaccent", "feharabic", "feharmenian", "fehfinalarabic", 
    "fehinitialarabic", "fehmedialarabic", "feicoptic", "female", "ff", 
    "ffi", "ffl", "fi", "fifteencircle", "fifteenparen", 
    "fifteenperiod", "figuredash", "filledbox", "filledrect", 
    "finalkaf", "finalkafdagesh", "finalkafdageshhebrew", 
    "finalkafhebrew", "finalmem", "finalmemhebrew", "finalnun", 
    "finalnunhebrew", "finalpe", "finalpehebrew", "finaltsadi", 
    "finaltsadihebrew", "firsttonechinese", "fisheye", "fitacyrillic", 
    "five", "fivearabic", "fivebengali", "fivecircle", 
    "fivecircleinversesansserif", "fivedeva", "fiveeighths", 
    "fivegujarati", "fivegurmukhi", "fivehackarabic", "fivehangzhou", 
    "fiveideographicparen", "fiveinferior", "fivemonospace", 
    "fiveoldstyle", "fiveparen", "fiveperiod", "fivepersian", 
    "fiveroman", "fivesuperior", "fivethai", "fl", "florin", 
    "fmonospace", "fmsquare", "fofanthai", "fofathai", "fongmanthai", 
    "forall", "four", "fourarabic", "fourbengali", "fourcircle", 
    "fourcircleinversesansserif", "fourdeva", "fourgujarati", 
    "fourgurmukhi", "fourhackarabic", "fourhangzhou", 
    "fourideographicparen", "fourinferior", "fourmonospace", 
    "fournumeratorbengali", "fouroldstyle", "fourparen", "fourperiod", 
    "fourpersian", "fourroman", "foursuperior", "fourteencircle", 
    "fourteenparen", "fourteenperiod", "fourthai", "fourthtonechinese", 
    "fparen", "fraction", "franc", "g", "gabengali", "gacute", 
    "gadeva", "gafarabic", "gaffinalarabic", "gafinitialarabic", 
    "gafmedialarabic", "gagujarati", "gagurmukhi", "gahiragana", 
    "gakatakana", "gamma", "gammalatinsmall", "gammasuperior", 
    "gangiacoptic", "gbopomofo", "gbreve", "gcaron", "gcedilla", 
    "gcircle", "gcircumflex", "gcommaaccent", "gdot", "gdotaccent", 
    "gecyrillic", "gehiragana", "gekatakana", "geometricallyequal", 
    "gereshaccenthebrew", "gereshhebrew", "gereshmuqdamhebrew", 
    "germandbls", "gershayimaccenthebrew", "gershayimhebrew", 
    "getamark", "ghabengali", "ghadarmenian", "ghadeva", "ghagujarati", 
    "ghagurmukhi", "ghainarabic", "ghainfinalarabic", 
    "ghaininitialarabic", "ghainmedialarabic", "ghemiddlehookcyrillic", 
    "ghestrokecyrillic", "gheupturncyrillic", "ghhadeva", 
    "ghhagurmukhi", "ghook", "ghzsquare", "gihiragana", "gikatakana", 
    "gimarmenian", "gimel", "gimeldagesh", "gimeldageshhebrew", 
    "gimelhebrew", "gjecyrillic", "glottalinvertedstroke", 
    "glottalstop", "glottalstopinverted", "glottalstopmod", 
    "glottalstopreversed", "glottalstopreversedmod", 
    "glottalstopreversedsuperior", "glottalstopstroke", 
    "glottalstopstrokereversed", "gmacron", "gmonospace", "gohiragana", 
    "gokatakana", "gparen", "gpasquare", "gradient", "grave", 
    "gravebelowcmb", "gravecmb", "gravecomb", "gravedeva", 
    "gravelowmod", "gravemonospace", "gravetonecmb", "greater", 
    "greaterequal", "greaterequalorless", "greatermonospace", 
    "greaterorequivalent", "greaterorless", "greateroverequal", 
    "greatersmall", "gscript", "gstroke", "guhiragana", 
    "guillemotleft", "guillemotright", "guilsinglleft", 
    "guilsinglright", "gukatakana", "guramusquare", "gysquare", "h", 
    "haabkhasiancyrillic", "haaltonearabic", "habengali", 
    "hadescendercyrillic", "hadeva", "hagujarati", "hagurmukhi", 
    "haharabic", "hahfinalarabic", "hahinitialarabic", "hahiragana", 
    "hahmedialarabic", "haitusquare", "hakatakana", 
    "hakatakanahalfwidth", "halantgurmukhi", "hamzaarabic", 
    "hamzalowarabic", "hangulfiller", "hardsigncyrillic", 
    "harpoonleftbarbup", "harpoonrightbarbup", "hasquare", 
    "hatafpatah", "hatafpatah16", "hatafpatah23", "hatafpatah2f", 
    "hatafpatahhebrew", "hatafpatahnarrowhebrew", 
    "hatafpatahquarterhebrew", "hatafpatahwidehebrew", "hatafqamats", 
    "hatafqamats1b", "hatafqamats28", "hatafqamats34", 
    "hatafqamatshebrew", "hatafqamatsnarrowhebrew", 
    "hatafqamatsquarterhebrew", "hatafqamatswidehebrew", "hatafsegol", 
    "hatafsegol17", "hatafsegol24", "hatafsegol30", "hatafsegolhebrew", 
    "hatafsegolnarrowhebrew", "hatafsegolquarterhebrew", 
    "hatafsegolwidehebrew", "hbar", "hbopomofo", "hbrevebelow", 
    "hcedilla", "hcircle", "hcircumflex", "hdieresis", "hdotaccent", 
    "hdotbelow", "he", "heart", "heartsuitblack", "heartsuitwhite", 
    "hedagesh", "hedageshhebrew", "hehaltonearabic", "heharabic", 
    "hehebrew", "hehfinalaltonearabic", "hehfinalalttwoarabic", 
    "hehfinalarabic", "hehhamzaabovefinalarabic", 
    "hehhamzaaboveisolatedarabic", "hehinitialaltonearabic", 
    "hehinitialarabic", "hehiragana", "hehmedialaltonearabic", 
    "hehmedialarabic", "heiseierasquare", "hekatakana", 
    "hekatakanahalfwidth", "hekutaarusquare", "henghook", 
    "herutusquare", "het", "hethebrew", "hhook", "hhooksuperior", 
    "hieuhacirclekorean", "hieuhaparenkorean", "hieuhcirclekorean", 
    "hieuhkorean", "hieuhparenkorean", "hihiragana", "hikatakana", 
    "hikatakanahalfwidth", "hiriq", "hiriq14", "hiriq21", "hiriq2d", 
    "hiriqhebrew", "hiriqnarrowhebrew", "hiriqquarterhebrew", 
    "hiriqwidehebrew", "hlinebelow", "hmonospace", "hoarmenian", 
    "hohipthai", "hohiragana", "hokatakana", "hokatakanahalfwidth", 
    "holam", "holam19", "holam26", "holam32", "holamhebrew", 
    "holamnarrowhebrew", "holamquarterhebrew", "holamwidehebrew", 
    "honokhukthai", "hookabovecomb", "hookcmb", 
    "hookpalatalizedbelowcmb", "hookretroflexbelowcmb", "hoonsquare", 
    "horicoptic", "horizontalbar", "horncmb", "hotsprings", "house", 
    "hparen", "hsuperior", "hturned", "huhiragana", "huiitosquare", 
    "hukatakana", "hukatakanahalfwidth", "hungarumlaut", 
    "hungarumlautcmb", "hv", "hyphen", "hypheninferior", 
    "hyphenmonospace", "hyphensmall", "hyphensuperior", "hyphentwo", 
    "i", "iacute", "iacyrillic", "ibengali", "ibopomofo", "ibreve", 
    "icaron", "icircle", "icircumflex", "icyrillic", "idblgrave", 
    "ideographearthcircle", "ideographfirecircle", 
    "ideographicallianceparen", "ideographiccallparen", 
    "ideographiccentrecircle", "ideographicclose", "ideographiccomma", 
    "ideographiccommaleft", "ideographiccongratulationparen", 
    "ideographiccorrectcircle", "ideographicearthparen", 
    "ideographicenterpriseparen", "ideographicexcellentcircle", 
    "ideographicfestivalparen", "ideographicfinancialcircle", 
    "ideographicfinancialparen", "ideographicfireparen", 
    "ideographichaveparen", "ideographichighcircle", 
    "ideographiciterationmark", "ideographiclaborcircle", 
    "ideographiclaborparen", "ideographicleftcircle", 
    "ideographiclowcircle", "ideographicmedicinecircle", 
    "ideographicmetalparen", "ideographicmoonparen", 
    "ideographicnameparen", "ideographicperiod", 
    "ideographicprintcircle", "ideographicreachparen", 
    "ideographicrepresentparen", "ideographicresourceparen", 
    "ideographicrightcircle", "ideographicsecretcircle", 
    "ideographicselfparen", "ideographicsocietyparen", 
    "ideographicspace", "ideographicspecialparen", 
    "ideographicstockparen", "ideographicstudyparen", 
    "ideographicsunparen", "ideographicsuperviseparen", 
    "ideographicwaterparen", "ideographicwoodparen", "ideographiczero", 
    "ideographmetalcircle", "ideographmooncircle", 
    "ideographnamecircle", "ideographsuncircle", 
    "ideographwatercircle", "ideographwoodcircle", "ideva", 
    "idieresis", "idieresisacute", "idieresiscyrillic", "idotbelow", 
    "iebrevecyrillic", "iecyrillic", "ieungacirclekorean", 
    "ieungaparenkorean", "ieungcirclekorean", "ieungkorean", 
    "ieungparenkorean", "igrave", "igujarati", "igurmukhi", 
    "ihiragana", "ihookabove", "iibengali", "iicyrillic", "iideva", 
    "iigujarati", "iigurmukhi", "iimatragurmukhi", "iinvertedbreve", 
    "iishortcyrillic", "iivowelsignbengali", "iivowelsigndeva", 
    "iivowelsigngujarati", "ij", "ikatakana", "ikatakanahalfwidth", 
    "ikorean", "ilde", "iluyhebrew", "imacron", "imacroncyrillic", 
    "imageorapproximatelyequal", "imatragurmukhi", "imonospace", 
    "increment", "infinity", "iniarmenian", "integral", 
    "integralbottom", "integralbt", "integralex", "integraltop", 
    "integraltp", "intersection", "intisquare", "invbullet", 
    "invcircle", "invsmileface", "iocyrillic", "iogonek", "iota", 
    "iotadieresis", "iotadieresistonos", "iotalatin", "iotatonos", 
    "iparen", "irigurmukhi", "ismallhiragana", "ismallkatakana", 
    "ismallkatakanahalfwidth", "issharbengali", "istroke", "isuperior", 
    "iterationhiragana", "iterationkatakana", "itilde", "itildebelow", 
    "iubopomofo", "iucyrillic", "ivowelsignbengali", "ivowelsigndeva", 
    "ivowelsigngujarati", "izhitsacyrillic", "izhitsadblgravecyrillic", 
    "j", "jaarmenian", "jabengali", "jadeva", "jagujarati", 
    "jagurmukhi", "jbopomofo", "jcaron", "jcircle", "jcircumflex", 
    "jcrossedtail", "jdotlessstroke", "jecyrillic", "jeemarabic", 
    "jeemfinalarabic", "jeeminitialarabic", "jeemmedialarabic", 
    "jeharabic", "jehfinalarabic", "jhabengali", "jhadeva", 
    "jhagujarati", "jhagurmukhi", "jheharmenian", "jis", "jmonospace", 
    "jparen", "jsuperior", "k", "kabashkircyrillic", "kabengali", 
    "kacute", "kacyrillic", "kadescendercyrillic", "kadeva", "kaf", 
    "kafarabic", "kafdagesh", "kafdageshhebrew", "kaffinalarabic", 
    "kafhebrew", "kafinitialarabic", "kafmedialarabic", 
    "kafrafehebrew", "kagujarati", "kagurmukhi", "kahiragana", 
    "kahookcyrillic", "kakatakana", "kakatakanahalfwidth", "kappa", 
    "kappasymbolgreek", "kapyeounmieumkorean", "kapyeounphieuphkorean", 
    "kapyeounpieupkorean", "kapyeounssangpieupkorean", "karoriisquare", 
    "kashidaautoarabic", "kashidaautonosidebearingarabic", 
    "kasmallkatakana", "kasquare", "kasraarabic", "kasratanarabic", 
    "kastrokecyrillic", "katahiraprolongmarkhalfwidth", 
    "kaverticalstrokecyrillic", "kbopomofo", "kcalsquare", "kcaron", 
    "kcedilla", "kcircle", "kcommaaccent", "kdotbelow", "keharmenian", 
    "kehiragana", "kekatakana", "kekatakanahalfwidth", "kenarmenian", 
    "kesmallkatakana", "kgreenlandic", "khabengali", "khacyrillic", 
    "khadeva", "khagujarati", "khagurmukhi", "khaharabic", 
    "khahfinalarabic", "khahinitialarabic", "khahmedialarabic", 
    "kheicoptic", "khhadeva", "khhagurmukhi", "khieukhacirclekorean", 
    "khieukhaparenkorean", "khieukhcirclekorean", "khieukhkorean", 
    "khieukhparenkorean", "khokhaithai", "khokhonthai", "khokhuatthai", 
    "khokhwaithai", "khomutthai", "khook", "khorakhangthai", 
    "khzsquare", "kihiragana", "kikatakana", "kikatakanahalfwidth", 
    "kiroguramusquare", "kiromeetorusquare", "kirosquare", 
    "kiyeokacirclekorean", "kiyeokaparenkorean", "kiyeokcirclekorean", 
    "kiyeokkorean", "kiyeokparenkorean", "kiyeoksioskorean", 
    "kjecyrillic", "klinebelow", "klsquare", "kmcubedsquare", 
    "kmonospace", "kmsquaredsquare", "kohiragana", "kohmsquare", 
    "kokaithai", "kokatakana", "kokatakanahalfwidth", "kooposquare", 
    "koppacyrillic", "koreanstandardsymbol", "koroniscmb", "kparen", 
    "kpasquare", "ksicyrillic", "ktsquare", "kturned", "kuhiragana", 
    "kukatakana", "kukatakanahalfwidth", "kvsquare", "kwsquare", "l", 
    "labengali", "lacute", "ladeva", "lagujarati", "lagurmukhi", 
    "lakkhangyaothai", "lamaleffinalarabic", 
    "lamalefhamzaabovefinalarabic", "lamalefhamzaaboveisolatedarabic", 
    "lamalefhamzabelowfinalarabic", "lamalefhamzabelowisolatedarabic", 
    "lamalefisolatedarabic", "lamalefmaddaabovefinalarabic", 
    "lamalefmaddaaboveisolatedarabic", "lamarabic", "lambda", 
    "lambdastroke", "lamed", "lameddagesh", "lameddageshhebrew", 
    "lamedhebrew", "lamfinalarabic", "lamhahinitialarabic", 
    "laminitialarabic", "lamjeeminitialarabic", "lamkhahinitialarabic", 
    "lamlamhehisolatedarabic", "lammedialarabic", 
    "lammeemhahinitialarabic", "lammeeminitialarabic", "largecircle", 
    "lbar", "lbelt", "lbopomofo", "lcaron", "lcedilla", "lcircle", 
    "lcircumflexbelow", "lcommaaccent", "ldot", "ldotaccent", 
    "ldotbelow", "ldotbelowmacron", "leftangleabovecmb", 
    "lefttackbelowcmb", "less", "lessequal", "lessequalorgreater", 
    "lessmonospace", "lessorequivalent", "lessorgreater", 
    "lessoverequal", "lesssmall", "lezh", "lfblock", "lhookretroflex", 
    "lira", "liwnarmenian", "lj", "ljecyrillic", "ll", "lladeva", 
    "llagujarati", "llinebelow", "llladeva", "llvocalicbengali", 
    "llvocalicdeva", "llvocalicvowelsignbengali", 
    "llvocalicvowelsigndeva", "lmiddletilde", "lmonospace", "lmsquare", 
    "lochulathai", "logicaland", "logicalnot", "logicalnotreversed", 
    "logicalor", "lolingthai", "longs", "lowlinecenterline", 
    "lowlinecmb", "lowlinedashed", "lozenge", "lparen", "lslash", 
    "lsquare", "lsuperior", "ltshade", "luthai", "lvocalicbengali", 
    "lvocalicdeva", "lvocalicvowelsignbengali", 
    "lvocalicvowelsigndeva", "lxsquare", "m", "mabengali", "macron", 
    "macronbelowcmb", "macroncmb", "macronlowmod", "macronmonospace", 
    "macute", "madeva", "magujarati", "magurmukhi", "mahapakhhebrew", 
    "mahapakhlefthebrew", "mahiragana", "maichattawalowleftthai", 
    "maichattawalowrightthai", "maichattawathai", 
    "maichattawaupperleftthai", "maieklowleftthai", 
    "maieklowrightthai", "maiekthai", "maiekupperleftthai", 
    "maihanakatleftthai", "maihanakatthai", "maitaikhuleftthai", 
    "maitaikhuthai", "maitholowleftthai", "maitholowrightthai", 
    "maithothai", "maithoupperleftthai", "maitrilowleftthai", 
    "maitrilowrightthai", "maitrithai", "maitriupperleftthai", 
    "maiyamokthai", "makatakana", "makatakanahalfwidth", "male", 
    "mansyonsquare", "maqafhebrew", "mars", "masoracirclehebrew", 
    "masquare", "mbopomofo", "mbsquare", "mcircle", "mcubedsquare", 
    "mdotaccent", "mdotbelow", "meemarabic", "meemfinalarabic", 
    "meeminitialarabic", "meemmedialarabic", "meemmeeminitialarabic", 
    "meemmeemisolatedarabic", "meetorusquare", "mehiragana", 
    "meizierasquare", "mekatakana", "mekatakanahalfwidth", "mem", 
    "memdagesh", "memdageshhebrew", "memhebrew", "menarmenian", 
    "merkhahebrew", "merkhakefulahebrew", "merkhakefulalefthebrew", 
    "merkhalefthebrew", "mhook", "mhzsquare", 
    "middledotkatakanahalfwidth", "middot", "mieumacirclekorean", 
    "mieumaparenkorean", "mieumcirclekorean", "mieumkorean", 
    "mieumpansioskorean", "mieumparenkorean", "mieumpieupkorean", 
    "mieumsioskorean", "mihiragana", "mikatakana", 
    "mikatakanahalfwidth", "minus", "minusbelowcmb", "minuscircle", 
    "minusmod", "minusplus", "minute", "miribaarusquare", "mirisquare", 
    "mlonglegturned", "mlsquare", "mmcubedsquare", "mmonospace", 
    "mmsquaredsquare", "mohiragana", "mohmsquare", "mokatakana", 
    "mokatakanahalfwidth", "molsquare", "momathai", "moverssquare", 
    "moverssquaredsquare", "mparen", "mpasquare", "mssquare", 
    "msuperior", "mturned", "mu", "mu1", "muasquare", "muchgreater",
    "muchless", "mufsquare", "mugreek", "mugsquare", "muhiragana", 
    "mukatakana", "mukatakanahalfwidth", "mulsquare", "multiply", 
    "mumsquare", "munahhebrew", "munahlefthebrew", "musicalnote", 
    "musicalnotedbl", "musicflatsign", "musicsharpsign", "mussquare", 
    "muvsquare", "muwsquare", "mvmegasquare", "mvsquare", 
    "mwmegasquare", "mwsquare", "n", "nabengali", "nabla", "nacute", 
    "nadeva", "nagujarati", "nagurmukhi", "nahiragana", "nakatakana", 
    "nakatakanahalfwidth", "napostrophe", "nasquare", "nbopomofo", 
    "nbspace", "ncaron", "ncedilla", "ncircle", "ncircumflexbelow", 
    "ncommaaccent", "ndotaccent", "ndotbelow", "nehiragana", 
    "nekatakana", "nekatakanahalfwidth", "newsheqelsign", "nfsquare", 
    "ngabengali", "ngadeva", "ngagujarati", "ngagurmukhi", 
    "ngonguthai", "nhiragana", "nhookleft", "nhookretroflex", 
    "nieunacirclekorean", "nieunaparenkorean", "nieuncieuckorean", 
    "nieuncirclekorean", "nieunhieuhkorean", "nieunkorean", 
    "nieunpansioskorean", "nieunparenkorean", "nieunsioskorean", 
    "nieuntikeutkorean", "nihiragana", "nikatakana", 
    "nikatakanahalfwidth", "nikhahitleftthai", "nikhahitthai", "nine", 
    "ninearabic", "ninebengali", "ninecircle", 
    "ninecircleinversesansserif", "ninedeva", "ninegujarati", 
    "ninegurmukhi", "ninehackarabic", "ninehangzhou", 
    "nineideographicparen", "nineinferior", "ninemonospace", 
    "nineoldstyle", "nineparen", "nineperiod", "ninepersian", 
    "nineroman", "ninesuperior", "nineteencircle", "nineteenparen", 
    "nineteenperiod", "ninethai", "nj", "njecyrillic", "nkatakana", 
    "nkatakanahalfwidth", "nlegrightlong", "nlinebelow", "nmonospace", 
    "nmsquare", "nnabengali", "nnadeva", "nnagujarati", "nnagurmukhi", 
    "nnnadeva", "nohiragana", "nokatakana", "nokatakanahalfwidth", 
    "nonbreakingspace", "nonenthai", "nonuthai", "noonarabic", 
    "noonfinalarabic", "noonghunnaarabic", "noonghunnafinalarabic", 
    "nooninitialarabic", "noonjeeminitialarabic", 
    "noonjeemisolatedarabic", "noonmedialarabic", 
    "noonmeeminitialarabic", "noonmeemisolatedarabic", 
    "noonnoonfinalarabic", "notcontains", "notelement", "notelementof", 
    "notequal", "notgreater", "notgreaternorequal", 
    "notgreaternorless", "notidentical", "notless", "notlessnorequal", 
    "notparallel", "notprecedes", "notsubset", "notsucceeds", 
    "notsuperset", "nowarmenian", "nparen", "nssquare", "nsuperior", 
    "ntilde", "nu", "nuhiragana", "nukatakana", "nukatakanahalfwidth", 
    "nuktabengali", "nuktadeva", "nuktagujarati", "nuktagurmukhi", 
    "numbersign", "numbersignmonospace", "numbersignsmall", 
    "numeralsigngreek", "numeralsignlowergreek", "numero", "nun", 
    "nundagesh", "nundageshhebrew", "nunhebrew", "nvsquare", 
    "nwsquare", "nyabengali", "nyadeva", "nyagujarati", "nyagurmukhi", 
    "o", "oacute", "oangthai", "obarred", "obarredcyrillic", 
    "obarreddieresiscyrillic", "obengali", "obopomofo", "obreve", 
    "ocandradeva", "ocandragujarati", "ocandravowelsigndeva", 
    "ocandravowelsigngujarati", "ocaron", "ocircle", "ocircumflex", 
    "ocircumflexacute", "ocircumflexdotbelow", "ocircumflexgrave", 
    "ocircumflexhookabove", "ocircumflextilde", "ocyrillic", 
    "odblacute", "odblgrave", "odeva", "odieresis", 
    "odieresiscyrillic", "odotbelow", "oe", "oekorean", "ogonek", 
    "ogonekcmb", "ograve", "ogujarati", "oharmenian", "ohiragana", 
    "ohookabove", "ohorn", "ohornacute", "ohorndotbelow", "ohorngrave", 
    "ohornhookabove", "ohorntilde", "ohungarumlaut", "oi", 
    "oinvertedbreve", "okatakana", "okatakanahalfwidth", "okorean", 
    "olehebrew", "omacron", "omacronacute", "omacrongrave", "omdeva", 
    "omega", "omega1", "omegacyrillic", "omegalatinclosed", 
    "omegaroundcyrillic", "omegatitlocyrillic", "omegatonos", 
    "omgujarati", "omicron", "omicrontonos", "omonospace", "one", 
    "onearabic", "onebengali", "onecircle", 
    "onecircleinversesansserif", "onedeva", "onedotenleader", 
    "oneeighth", "onefitted", "onegujarati", "onegurmukhi", 
    "onehackarabic", "onehalf", "onehangzhou", "oneideographicparen", 
    "oneinferior", "onemonospace", "onenumeratorbengali", 
    "oneoldstyle", "oneparen", "oneperiod", "onepersian", "onequarter", 
    "oneroman", "onesuperior", "onethai", "onethird", "oogonek", 
    "oogonekmacron", "oogurmukhi", "oomatragurmukhi", "oopen", 
    "oparen", "openbullet", "option", "ordfeminine", "ordmasculine", 
    "orthogonal", "oshortdeva", "oshortvowelsigndeva", "oslash", 
    "oslashacute", "osmallhiragana", "osmallkatakana", 
    "osmallkatakanahalfwidth", "ostrokeacute", "osuperior", 
    "otcyrillic", "otilde", "otildeacute", "otildedieresis", 
    "oubopomofo", "overline", "overlinecenterline", "overlinecmb", 
    "overlinedashed", "overlinedblwavy", "overlinewavy", "overscore", 
    "ovowelsignbengali", "ovowelsigndeva", "ovowelsigngujarati", "p", 
    "paampssquare", "paasentosquare", "pabengali", "pacute", "padeva", 
    "pagedown", "pageup", "pagujarati", "pagurmukhi", "pahiragana", 
    "paiyannoithai", "pakatakana", "palatalizationcyrilliccmb", 
    "palochkacyrillic", "pansioskorean", "paragraph", "parallel", 
    "parenleft", "parenleftaltonearabic", "parenleftbt", "parenleftex", 
    "parenleftinferior", "parenleftmonospace", "parenleftsmall", 
    "parenleftsuperior", "parenlefttp", "parenleftvertical", 
    "parenright", "parenrightaltonearabic", "parenrightbt", 
    "parenrightex", "parenrightinferior", "parenrightmonospace", 
    "parenrightsmall", "parenrightsuperior", "parenrighttp", 
    "parenrightvertical", "partialdiff", "paseqhebrew", "pashtahebrew", 
    "pasquare", "patah", "patah11", "patah1d", "patah2a", 
    "patahhebrew", "patahnarrowhebrew", "patahquarterhebrew", 
    "patahwidehebrew", "pazerhebrew", "pbopomofo", "pcircle", 
    "pdotaccent", "pe", "pecyrillic", "pedagesh", "pedageshhebrew", 
    "peezisquare", "pefinaldageshhebrew", "peharabic", "peharmenian", 
    "pehebrew", "pehfinalarabic", "pehinitialarabic", "pehiragana", 
    "pehmedialarabic", "pekatakana", "pemiddlehookcyrillic", 
    "perafehebrew", "percent", "percentarabic", "percentmonospace", 
    "percentsmall", "period", "periodarmenian", "periodcentered", 
    "periodhalfwidth", "periodinferior", "periodmonospace", 
    "periodsmall", "periodsuperior", "perispomenigreekcmb", 
    "perpendicular", "perthousand", "peseta", "pfsquare", "phabengali", 
    "phadeva", "phagujarati", "phagurmukhi", "phi", "phi1", 
    "phieuphacirclekorean", "phieuphaparenkorean", 
    "phieuphcirclekorean", "phieuphkorean", "phieuphparenkorean", 
    "philatin", "phinthuthai", "phisymbolgreek", "phook", 
    "phophanthai", "phophungthai", "phosamphaothai", "pi", 
    "pieupacirclekorean", "pieupaparenkorean", "pieupcieuckorean", 
    "pieupcirclekorean", "pieupkiyeokkorean", "pieupkorean", 
    "pieupparenkorean", "pieupsioskiyeokkorean", "pieupsioskorean", 
    "pieupsiostikeutkorean", "pieupthieuthkorean", "pieuptikeutkorean", 
    "pihiragana", "pikatakana", "pisymbolgreek", "piwrarmenian", 
    "plus", "plusbelowcmb", "pluscircle", "plusminus", "plusmod", 
    "plusmonospace", "plussmall", "plussuperior", "pmonospace", 
    "pmsquare", "pohiragana", "pointingindexdownwhite", 
    "pointingindexleftwhite", "pointingindexrightwhite", 
    "pointingindexupwhite", "pokatakana", "poplathai", "postalmark", 
    "postalmarkface", "pparen", "precedes", "prescription", "primemod", 
    "primereversed", "product", "projective", "prolongedkana", 
    "propellor", "propersubset", "propersuperset", "proportion", 
    "proportional", "psi", "psicyrillic", "psilipneumatacyrilliccmb", 
    "pssquare", "puhiragana", "pukatakana", "pvsquare", "pwsquare", 
    "q", "qadeva", "qadmahebrew", "qafarabic", "qaffinalarabic", 
    "qafinitialarabic", "qafmedialarabic", "qamats", "qamats10", 
    "qamats1a", "qamats1c", "qamats27", "qamats29", "qamats33", 
    "qamatsde", "qamatshebrew", "qamatsnarrowhebrew", 
    "qamatsqatanhebrew", "qamatsqatannarrowhebrew", 
    "qamatsqatanquarterhebrew", "qamatsqatanwidehebrew", 
    "qamatsquarterhebrew", "qamatswidehebrew", "qarneyparahebrew", 
    "qbopomofo", "qcircle", "qhook", "qmonospace", "qof", "qofdagesh", 
    "qofdageshhebrew", "qofhebrew", "qparen", "quarternote", "qubuts", 
    "qubuts18", "qubuts25", "qubuts31", "qubutshebrew", 
    "qubutsnarrowhebrew", "qubutsquarterhebrew", "qubutswidehebrew", 
    "question", "questionarabic", "questionarmenian", "questiondown", 
    "questiondownsmall", "questiongreek", "questionmonospace", 
    "questionsmall", "quotedbl", "quotedblbase", "quotedblleft", 
    "quotedblmonospace", "quotedblprime", "quotedblprimereversed", 
    "quotedblright", "quoteleft", "quoteleftreversed", "quotereversed", 
    "quoteright", "quoterightn", "quotesinglbase", "quotesingle", 
    "quotesinglemonospace", "r", "raarmenian", "rabengali", "racute", 
    "radeva", "radical", "radicalex", "radoverssquare", 
    "radoverssquaredsquare", "radsquare", "rafe", "rafehebrew", 
    "ragujarati", "ragurmukhi", "rahiragana", "rakatakana", 
    "rakatakanahalfwidth", "ralowerdiagonalbengali", 
    "ramiddlediagonalbengali", "ramshorn", "ratio", "rbopomofo", 
    "rcaron", "rcedilla", "rcircle", "rcommaaccent", "rdblgrave", 
    "rdotaccent", "rdotbelow", "rdotbelowmacron", "referencemark", 
    "reflexsubset", "reflexsuperset", "registered", "registersans", 
    "registerserif", "reharabic", "reharmenian", "rehfinalarabic", 
    "rehiragana", "rekatakana", "rekatakanahalfwidth", "resh", 
    "reshdageshhebrew", "reshhebrew", "reversedtilde", "reviahebrew", 
    "reviamugrashhebrew", "revlogicalnot", "rfishhook", 
    "rfishhookreversed", "rhabengali", "rhadeva", "rho", "rhook", 
    "rhookturned", "rhookturnedsuperior", "rhosymbolgreek", 
    "rhotichookmod", "rieulacirclekorean", "rieulaparenkorean", 
    "rieulcirclekorean", "rieulhieuhkorean", "rieulkiyeokkorean", 
    "rieulkiyeoksioskorean", "rieulkorean", "rieulmieumkorean", 
    "rieulpansioskorean", "rieulparenkorean", "rieulphieuphkorean", 
    "rieulpieupkorean", "rieulpieupsioskorean", "rieulsioskorean", 
    "rieulthieuthkorean", "rieultikeutkorean", 
    "rieulyeorinhieuhkorean", "rightangle", "righttackbelowcmb", 
    "righttriangle", "rihiragana", "rikatakana", "rikatakanahalfwidth", 
    "ring", "ringbelowcmb", "ringcmb", "ringhalfleft", 
    "ringhalfleftarmenian", "ringhalfleftbelowcmb", 
    "ringhalfleftcentered", "ringhalfright", "ringhalfrightbelowcmb", 
    "ringhalfrightcentered", "rinvertedbreve", "rittorusquare", 
    "rlinebelow", "rlongleg", "rlonglegturned", "rmonospace", 
    "rohiragana", "rokatakana", "rokatakanahalfwidth", "roruathai", 
    "rparen", "rrabengali", "rradeva", "rragurmukhi", "rreharabic", 
    "rrehfinalarabic", "rrvocalicbengali", "rrvocalicdeva", 
    "rrvocalicgujarati", "rrvocalicvowelsignbengali", 
    "rrvocalicvowelsigndeva", "rrvocalicvowelsigngujarati", 
    "rsuperior", "rtblock", "rturned", "rturnedsuperior", "ruhiragana", 
    "rukatakana", "rukatakanahalfwidth", "rupeemarkbengali", 
    "rupeesignbengali", "rupiah", "ruthai", "rvocalicbengali", 
    "rvocalicdeva", "rvocalicgujarati", "rvocalicvowelsignbengali", 
    "rvocalicvowelsigndeva", "rvocalicvowelsigngujarati", "s", 
    "sabengali", "sacute", "sacutedotaccent", "sadarabic", "sadeva", 
    "sadfinalarabic", "sadinitialarabic", "sadmedialarabic", 
    "sagujarati", "sagurmukhi", "sahiragana", "sakatakana", 
    "sakatakanahalfwidth", "sallallahoualayhewasallamarabic", "samekh", 
    "samekhdagesh", "samekhdageshhebrew", "samekhhebrew", "saraaathai", 
    "saraaethai", "saraaimaimalaithai", "saraaimaimuanthai", 
    "saraamthai", "saraathai", "saraethai", "saraiileftthai", 
    "saraiithai", "saraileftthai", "saraithai", "saraothai", 
    "saraueeleftthai", "saraueethai", "saraueleftthai", "sarauethai", 
    "sarauthai", "sarauuthai", "sbopomofo", "scaron", 
    "scarondotaccent", "scedilla", "schwa", "schwacyrillic", 
    "schwadieresiscyrillic", "schwahook", "scircle", "scircumflex", 
    "scommaaccent", "sdotaccent", "sdotbelow", "sdotbelowdotaccent", 
    "seagullbelowcmb", "second", "secondtonechinese", "section", 
    "seenarabic", "seenfinalarabic", "seeninitialarabic", 
    "seenmedialarabic", "segol", "segol13", "segol1f", "segol2c", 
    "segolhebrew", "segolnarrowhebrew", "segolquarterhebrew", 
    "segoltahebrew", "segolwidehebrew", "seharmenian", "sehiragana", 
    "sekatakana", "sekatakanahalfwidth", "semicolon", 
    "semicolonarabic", "semicolonmonospace", "semicolonsmall", 
    "semivoicedmarkkana", "semivoicedmarkkanahalfwidth", "sentisquare", 
    "sentosquare", "seven", "sevenarabic", "sevenbengali", 
    "sevencircle", "sevencircleinversesansserif", "sevendeva", 
    "seveneighths", "sevengujarati", "sevengurmukhi", 
    "sevenhackarabic", "sevenhangzhou", "sevenideographicparen", 
    "seveninferior", "sevenmonospace", "sevenoldstyle", "sevenparen", 
    "sevenperiod", "sevenpersian", "sevenroman", "sevensuperior", 
    "seventeencircle", "seventeenparen", "seventeenperiod", 
    "seventhai", "sfthyphen", "shaarmenian", "shabengali", 
    "shacyrillic", "shaddaarabic", "shaddadammaarabic", 
    "shaddadammatanarabic", "shaddafathaarabic", "shaddakasraarabic", 
    "shaddakasratanarabic", "shade", "shadedark", "shadelight", 
    "shademedium", "shadeva", "shagujarati", "shagurmukhi", 
    "shalshelethebrew", "shbopomofo", "shchacyrillic", "sheenarabic", 
    "sheenfinalarabic", "sheeninitialarabic", "sheenmedialarabic", 
    "sheicoptic", "sheqel", "sheqelhebrew", "sheva", "sheva115", 
    "sheva15", "sheva22", "sheva2e", "shevahebrew", 
    "shevanarrowhebrew", "shevaquarterhebrew", "shevawidehebrew", 
    "shhacyrillic", "shimacoptic", "shin", "shindagesh", 
    "shindageshhebrew", "shindageshshindot", "shindageshshindothebrew", 
    "shindageshsindot", "shindageshsindothebrew", "shindothebrew", 
    "shinhebrew", "shinshindot", "shinshindothebrew", "shinsindot", 
    "shinsindothebrew", "shook", "sigma", "sigma1", "sigmafinal", 
    "sigmalunatesymbolgreek", "sihiragana", "sikatakana", 
    "sikatakanahalfwidth", "siluqhebrew", "siluqlefthebrew", "similar", 
    "sindothebrew", "siosacirclekorean", "siosaparenkorean", 
    "sioscieuckorean", "sioscirclekorean", "sioskiyeokkorean", 
    "sioskorean", "siosnieunkorean", "siosparenkorean", 
    "siospieupkorean", "siostikeutkorean", "six", "sixarabic", 
    "sixbengali", "sixcircle", "sixcircleinversesansserif", "sixdeva", 
    "sixgujarati", "sixgurmukhi", "sixhackarabic", "sixhangzhou", 
    "sixideographicparen", "sixinferior", "sixmonospace", 
    "sixoldstyle", "sixparen", "sixperiod", "sixpersian", "sixroman", 
    "sixsuperior", "sixteencircle", 
    "sixteencurrencydenominatorbengali", "sixteenparen", 
    "sixteenperiod", "sixthai", "slash", "slashmonospace", "slong", 
    "slongdotaccent", "smileface", "smonospace", "sofpasuqhebrew", 
    "softhyphen", "softsigncyrillic", "sohiragana", "sokatakana", 
    "sokatakanahalfwidth", "soliduslongoverlaycmb", 
    "solidusshortoverlaycmb", "sorusithai", "sosalathai", "sosothai", 
    "sosuathai", "space", "spacehackarabic", "spade", "spadesuitblack", 
    "spadesuitwhite", "sparen", "squarebelowcmb", "squarecc", 
    "squarecm", "squarediagonalcrosshatchfill", "squarehorizontalfill", 
    "squarekg", "squarekm", "squarekmcapital", "squareln", "squarelog", 
    "squaremg", "squaremil", "squaremm", "squaremsquared", 
    "squareorthogonalcrosshatchfill", 
    "squareupperlefttolowerrightfill", 
    "squareupperrighttolowerleftfill", "squareverticalfill", 
    "squarewhitewithsmallblack", "srsquare", "ssabengali", "ssadeva", 
    "ssagujarati", "ssangcieuckorean", "ssanghieuhkorean", 
    "ssangieungkorean", "ssangkiyeokkorean", "ssangnieunkorean", 
    "ssangpieupkorean", "ssangsioskorean", "ssangtikeutkorean", 
    "ssuperior", "sterling", "sterlingmonospace", 
    "strokelongoverlaycmb", "strokeshortoverlaycmb", "subset", 
    "subsetnotequal", "subsetorequal", "succeeds", "suchthat", 
    "suhiragana", "sukatakana", "sukatakanahalfwidth", "sukunarabic", 
    "summation", "sun", "superset", "supersetnotequal", 
    "supersetorequal", "svsquare", "syouwaerasquare", "t", "tabengali", 
    "tackdown", "tackleft", "tadeva", "tagujarati", "tagurmukhi", 
    "taharabic", "tahfinalarabic", "tahinitialarabic", "tahiragana", 
    "tahmedialarabic", "taisyouerasquare", "takatakana", 
    "takatakanahalfwidth", "tatweelarabic", "tau", "tav", "tavdages", 
    "tavdagesh", "tavdageshhebrew", "tavhebrew", "tbar", "tbopomofo", 
    "tcaron", "tccurl", "tcedilla", "tcheharabic", "tchehfinalarabic", 
    "tchehinitialarabic", "tchehmedialarabic", "tcircle", 
    "tcircumflexbelow", "tcommaaccent", "tdieresis", "tdotaccent", 
    "tdotbelow", "tecyrillic", "tedescendercyrillic", "teharabic", 
    "tehfinalarabic", "tehhahinitialarabic", "tehhahisolatedarabic", 
    "tehinitialarabic", "tehiragana", "tehjeeminitialarabic", 
    "tehjeemisolatedarabic", "tehmarbutaarabic", 
    "tehmarbutafinalarabic", "tehmedialarabic", "tehmeeminitialarabic", 
    "tehmeemisolatedarabic", "tehnoonfinalarabic", "tekatakana", 
    "tekatakanahalfwidth", "telephone", "telephoneblack", 
    "telishagedolahebrew", "telishaqetanahebrew", "tencircle", 
    "tenideographicparen", "tenparen", "tenperiod", "tenroman", "tesh", 
    "tet", "tetdagesh", "tetdageshhebrew", "tethebrew", 
    "tetsecyrillic", "tevirhebrew", "tevirlefthebrew", "thabengali", 
    "thadeva", "thagujarati", "thagurmukhi", "thalarabic", 
    "thalfinalarabic", "thanthakhatlowleftthai", 
    "thanthakhatlowrightthai", "thanthakhatthai", 
    "thanthakhatupperleftthai", "theharabic", "thehfinalarabic", 
    "thehinitialarabic", "thehmedialarabic", "thereexists", 
    "therefore", "theta", "theta1", "thetasymbolgreek", 
    "thieuthacirclekorean", "thieuthaparenkorean", 
    "thieuthcirclekorean", "thieuthkorean", "thieuthparenkorean", 
    "thirteencircle", "thirteenparen", "thirteenperiod", 
    "thonangmonthothai", "thook", "thophuthaothai", "thorn", 
    "thothahanthai", "thothanthai", "thothongthai", "thothungthai", 
    "thousandcyrillic", "thousandsseparatorarabic", 
    "thousandsseparatorpersian", "three", "threearabic", 
    "threebengali", "threecircle", "threecircleinversesansserif", 
    "threedeva", "threeeighths", "threegujarati", "threegurmukhi", 
    "threehackarabic", "threehangzhou", "threeideographicparen", 
    "threeinferior", "threemonospace", "threenumeratorbengali", 
    "threeoldstyle", "threeparen", "threeperiod", "threepersian", 
    "threequarters", "threequartersemdash", "threeroman", 
    "threesuperior", "threethai", "thzsquare", "tihiragana", 
    "tikatakana", "tikatakanahalfwidth", "tikeutacirclekorean", 
    "tikeutaparenkorean", "tikeutcirclekorean", "tikeutkorean", 
    "tikeutparenkorean", "tilde", "tildebelowcmb", "tildecmb", 
    "tildecomb", "tildedoublecmb", "tildeoperator", "tildeoverlaycmb", 
    "tildeverticalcmb", "timescircle", "tipehahebrew", 
    "tipehalefthebrew", "tippigurmukhi", "titlocyrilliccmb", 
    "tiwnarmenian", "tlinebelow", "tmonospace", "toarmenian", 
    "tohiragana", "tokatakana", "tokatakanahalfwidth", 
    "tonebarextrahighmod", "tonebarextralowmod", "tonebarhighmod", 
    "tonebarlowmod", "tonebarmidmod", "tonefive", "tonesix", "tonetwo", 
    "tonos", "tonsquare", "topatakthai", "tortoiseshellbracketleft", 
    "tortoiseshellbracketleftsmall", 
    "tortoiseshellbracketleftvertical", "tortoiseshellbracketright", 
    "tortoiseshellbracketrightsmall", 
    "tortoiseshellbracketrightvertical", "totaothai", "tpalatalhook", 
    "tparen", "trademark", "trademarksans", "trademarkserif", 
    "tretroflexhook", "triagdn", "triaglf", "triagrt", "triagup", "ts", 
    "tsadi", "tsadidagesh", "tsadidageshhebrew", "tsadihebrew", 
    "tsecyrillic", "tsere", "tsere12", "tsere1e", "tsere2b", 
    "tserehebrew", "tserenarrowhebrew", "tserequarterhebrew", 
    "tserewidehebrew", "tshecyrillic", "tsuperior", "ttabengali", 
    "ttadeva", "ttagujarati", "ttagurmukhi", "tteharabic", 
    "ttehfinalarabic", "ttehinitialarabic", "ttehmedialarabic", 
    "tthabengali", "tthadeva", "tthagujarati", "tthagurmukhi", 
    "tturned", "tuhiragana", "tukatakana", "tukatakanahalfwidth", 
    "tusmallhiragana", "tusmallkatakana", "tusmallkatakanahalfwidth", 
    "twelvecircle", "twelveparen", "twelveperiod", "twelveroman", 
    "twentycircle", "twentyhangzhou", "twentyparen", "twentyperiod", 
    "two", "twoarabic", "twobengali", "twocircle", 
    "twocircleinversesansserif", "twodeva", "twodotenleader", 
    "twodotleader", "twodotleadervertical", "twogujarati", 
    "twogurmukhi", "twohackarabic", "twohangzhou", 
    "twoideographicparen", "twoinferior", "twomonospace", 
    "twonumeratorbengali", "twooldstyle", "twoparen", "twoperiod", 
    "twopersian", "tworoman", "twostroke", "twosuperior", "twothai", 
    "twothirds", "u", "uacute", "ubar", "ubengali", "ubopomofo", 
    "ubreve", "ucaron", "ucircle", "ucircumflex", "ucircumflexbelow", 
    "ucyrillic", "udattadeva", "udblacute", "udblgrave", "udeva", 
    "udieresis", "udieresisacute", "udieresisbelow", "udieresiscaron", 
    "udieresiscyrillic", "udieresisgrave", "udieresismacron", 
    "udotbelow", "ugrave", "ugujarati", "ugurmukhi", "uhiragana", 
    "uhookabove", "uhorn", "uhornacute", "uhorndotbelow", "uhorngrave", 
    "uhornhookabove", "uhorntilde", "uhungarumlaut", 
    "uhungarumlautcyrillic", "uinvertedbreve", "ukatakana", 
    "ukatakanahalfwidth", "ukcyrillic", "ukorean", "umacron", 
    "umacroncyrillic", "umacrondieresis", "umatragurmukhi", 
    "umonospace", "underscore", "underscoredbl", "underscoremonospace", 
    "underscorevertical", "underscorewavy", "union", "universal", 
    "uogonek", "uparen", "upblock", "upperdothebrew", "upsilon", 
    "upsilondieresis", "upsilondieresistonos", "upsilonlatin", 
    "upsilontonos", "uptackbelowcmb", "uptackmod", "uragurmukhi", 
    "uring", "ushortcyrillic", "usmallhiragana", "usmallkatakana", 
    "usmallkatakanahalfwidth", "ustraightcyrillic", 
    "ustraightstrokecyrillic", "utilde", "utildeacute", "utildebelow", 
    "uubengali", "uudeva", "uugujarati", "uugurmukhi", 
    "uumatragurmukhi", "uuvowelsignbengali", "uuvowelsigndeva", 
    "uuvowelsigngujarati", "uvowelsignbengali", "uvowelsigndeva", 
    "uvowelsigngujarati", "v", "vadeva", "vagujarati", "vagurmukhi", 
    "vakatakana", "vav", "vavdagesh", "vavdagesh65", "vavdageshhebrew", 
    "vavhebrew", "vavholam", "vavholamhebrew", "vavvavhebrew", 
    "vavyodhebrew", "vcircle", "vdotbelow", "vecyrillic", "veharabic", 
    "vehfinalarabic", "vehinitialarabic", "vehmedialarabic", 
    "vekatakana", "venus", "verticalbar", "verticallineabovecmb", 
    "verticallinebelowcmb", "verticallinelowmod", "verticallinemod", 
    "vewarmenian", "vhook", "vikatakana", "viramabengali", 
    "viramadeva", "viramagujarati", "visargabengali", "visargadeva", 
    "visargagujarati", "vmonospace", "voarmenian", 
    "voicediterationhiragana", "voicediterationkatakana", 
    "voicedmarkkana", "voicedmarkkanahalfwidth", "vokatakana", 
    "vparen", "vtilde", "vturned", "vuhiragana", "vukatakana", "w", 
    "wacute", "waekorean", "wahiragana", "wakatakana", 
    "wakatakanahalfwidth", "wakorean", "wasmallhiragana", 
    "wasmallkatakana", "wattosquare", "wavedash", 
    "wavyunderscorevertical", "wawarabic", "wawfinalarabic", 
    "wawhamzaabovearabic", "wawhamzaabovefinalarabic", "wbsquare", 
    "wcircle", "wcircumflex", "wdieresis", "wdotaccent", "wdotbelow", 
    "wehiragana", "weierstrass", "wekatakana", "wekorean", "weokorean", 
    "wgrave", "whitebullet", "whitecircle", "whitecircleinverse", 
    "whitecornerbracketleft", "whitecornerbracketleftvertical", 
    "whitecornerbracketright", "whitecornerbracketrightvertical", 
    "whitediamond", "whitediamondcontainingblacksmalldiamond", 
    "whitedownpointingsmalltriangle", "whitedownpointingtriangle", 
    "whiteleftpointingsmalltriangle", "whiteleftpointingtriangle", 
    "whitelenticularbracketleft", "whitelenticularbracketright", 
    "whiterightpointingsmalltriangle", "whiterightpointingtriangle", 
    "whitesmallsquare", "whitesmilingface", "whitesquare", "whitestar", 
    "whitetelephone", "whitetortoiseshellbracketleft", 
    "whitetortoiseshellbracketright", "whiteuppointingsmalltriangle", 
    "whiteuppointingtriangle", "wihiragana", "wikatakana", "wikorean", 
    "wmonospace", "wohiragana", "wokatakana", "wokatakanahalfwidth", 
    "won", "wonmonospace", "wowaenthai", "wparen", "wring", 
    "wsuperior", "wturned", "wynn", "x", "xabovecmb", "xbopomofo", 
    "xcircle", "xdieresis", "xdotaccent", "xeharmenian", "xi", 
    "xmonospace", "xparen", "xsuperior", "y", "yaadosquare", 
    "yabengali", "yacute", "yadeva", "yaekorean", "yagujarati", 
    "yagurmukhi", "yahiragana", "yakatakana", "yakatakanahalfwidth", 
    "yakorean", "yamakkanthai", "yasmallhiragana", "yasmallkatakana", 
    "yasmallkatakanahalfwidth", "yatcyrillic", "ycircle", 
    "ycircumflex", "ydieresis", "ydotaccent", "ydotbelow", "yeharabic", 
    "yehbarreearabic", "yehbarreefinalarabic", "yehfinalarabic", 
    "yehhamzaabovearabic", "yehhamzaabovefinalarabic", 
    "yehhamzaaboveinitialarabic", "yehhamzaabovemedialarabic", 
    "yehinitialarabic", "yehmedialarabic", "yehmeeminitialarabic", 
    "yehmeemisolatedarabic", "yehnoonfinalarabic", 
    "yehthreedotsbelowarabic", "yekorean", "yen", "yenmonospace", 
    "yeokorean", "yeorinhieuhkorean", "yerahbenyomohebrew", 
    "yerahbenyomolefthebrew", "yericyrillic", "yerudieresiscyrillic", 
    "yesieungkorean", "yesieungpansioskorean", "yesieungsioskorean", 
    "yetivhebrew", "ygrave", "yhook", "yhookabove", "yiarmenian", 
    "yicyrillic", "yikorean", "yinyang", "yiwnarmenian", "ymonospace", 
    "yod", "yoddagesh", "yoddageshhebrew", "yodhebrew", "yodyodhebrew", 
    "yodyodpatahhebrew", "yohiragana", "yoikorean", "yokatakana", 
    "yokatakanahalfwidth", "yokorean", "yosmallhiragana", 
    "yosmallkatakana", "yosmallkatakanahalfwidth", "yotgreek", 
    "yoyaekorean", "yoyakorean", "yoyakthai", "yoyingthai", "yparen", 
    "ypogegrammeni", "ypogegrammenigreekcmb", "yr", "yring", 
    "ysuperior", "ytilde", "yturned", "yuhiragana", "yuikorean", 
    "yukatakana", "yukatakanahalfwidth", "yukorean", "yusbigcyrillic", 
    "yusbigiotifiedcyrillic", "yuslittlecyrillic", 
    "yuslittleiotifiedcyrillic", "yusmallhiragana", "yusmallkatakana", 
    "yusmallkatakanahalfwidth", "yuyekorean", "yuyeokorean", 
    "yyabengali", "yyadeva", "z", "zaarmenian", "zacute", "zadeva", 
    "zagurmukhi", "zaharabic", "zahfinalarabic", "zahinitialarabic", 
    "zahiragana", "zahmedialarabic", "zainarabic", "zainfinalarabic", 
    "zakatakana", "zaqefgadolhebrew", "zaqefqatanhebrew", 
    "zarqahebrew", "zayin", "zayindagesh", "zayindageshhebrew", 
    "zayinhebrew", "zbopomofo", "zcaron", "zcircle", "zcircumflex", 
    "zcurl", "zdot", "zdotaccent", "zdotbelow", "zecyrillic", 
    "zedescendercyrillic", "zedieresiscyrillic", "zehiragana", 
    "zekatakana", "zero", "zeroarabic", "zerobengali", "zerodeva", 
    "zerogujarati", "zerogurmukhi", "zerohackarabic", "zeroinferior", 
    "zeromonospace", "zerooldstyle", "zeropersian", "zerosuperior", 
    "zerothai", "zerowidthjoiner", "zerowidthnonjoiner", 
    "zerowidthspace", "zeta", "zhbopomofo", "zhearmenian", 
    "zhebrevecyrillic", "zhecyrillic", "zhedescendercyrillic", 
    "zhedieresiscyrillic", "zihiragana", "zikatakana", "zinorhebrew", 
    "zlinebelow", "zmonospace", "zohiragana", "zokatakana", "zparen", 
    "zretroflexhook", "zstroke", "zuhiragana", "zukatakana", 
};

/*

grep '^[^#;][^;]*;[^ ][^ ][^ ][^ ]$' glyphlist.txt | sort -t\; +0 -1 | \
    cut -f2 -d\; | perl -ne 'chomp; print "0x$_, "' | \
    fold -s -w68 | sed 's/^/    /'; echo

 */
static const unsigned short ps_codes_alphabetic[] = {
    0x0041, 0x00C6, 0x01FC, 0x01E2, 0xF7E6, 0x00C1, 0xF7E1, 0x0102, 
    0x1EAE, 0x04D0, 0x1EB6, 0x1EB0, 0x1EB2, 0x1EB4, 0x01CD, 0x24B6, 
    0x00C2, 0x1EA4, 0x1EAC, 0x1EA6, 0x1EA8, 0xF7E2, 0x1EAA, 0xF6C9, 
    0xF7B4, 0x0410, 0x0200, 0x00C4, 0x04D2, 0x01DE, 0xF7E4, 0x1EA0, 
    0x01E0, 0x00C0, 0xF7E0, 0x1EA2, 0x04D4, 0x0202, 0x0391, 0x0386, 
    0x0100, 0xFF21, 0x0104, 0x00C5, 0x01FA, 0x1E00, 0xF7E5, 0xF761, 
    0x00C3, 0xF7E3, 0x0531, 0x0042, 0x24B7, 0x1E02, 0x1E04, 0x0411, 
    0x0532, 0x0392, 0x0181, 0x1E06, 0xFF22, 0xF6F4, 0xF762, 0x0182, 
    0x0043, 0x053E, 0x0106, 0xF6CA, 0xF6F5, 0x010C, 0x00C7, 0x1E08, 
    0xF7E7, 0x24B8, 0x0108, 0x010A, 0x010A, 0xF7B8, 0x0549, 0x04BC, 
    0x0427, 0x04BE, 0x04B6, 0x04F4, 0x0543, 0x04CB, 0x04B8, 0x03A7, 
    0x0187, 0xF6F6, 0xFF23, 0x0551, 0xF763, 0x0044, 0x01F1, 0x01C4, 
    0x0534, 0x0189, 0x010E, 0x1E10, 0x24B9, 0x1E12, 0x0110, 0x1E0A, 
    0x1E0C, 0x0414, 0x03EE, 0x2206, 0x0394, 0x018A, 0xF6CB, 0xF6CC, 
    0xF6CD, 0xF7A8, 0x03DC, 0x0402, 0x1E0E, 0xFF24, 0xF6F7, 0x0110, 
    0xF764, 0x018B, 0x01F2, 0x01C5, 0x04E0, 0x0405, 0x040F, 0x0045, 
    0x00C9, 0xF7E9, 0x0114, 0x011A, 0x1E1C, 0x0535, 0x24BA, 0x00CA, 
    0x1EBE, 0x1E18, 0x1EC6, 0x1EC0, 0x1EC2, 0xF7EA, 0x1EC4, 0x0404, 
    0x0204, 0x00CB, 0xF7EB, 0x0116, 0x0116, 0x1EB8, 0x0424, 0x00C8, 
    0xF7E8, 0x0537, 0x1EBA, 0x2167, 0x0206, 0x0464, 0x041B, 0x216A, 
    0x0112, 0x1E16, 0x1E14, 0x041C, 0xFF25, 0x041D, 0x04A2, 0x014A, 
    0x04A4, 0x04C7, 0x0118, 0x0190, 0x0395, 0x0388, 0x0420, 0x018E, 
    0x042D, 0x0421, 0x04AA, 0x01A9, 0xF765, 0x0397, 0x0538, 0x0389, 
    0x00D0, 0xF7F0, 0x1EBC, 0x1E1A, 0x20AC, 0x01B7, 0x01EE, 0x01B8, 
    0x0046, 0x24BB, 0x1E1E, 0x0556, 0x03E4, 0x0191, 0x0472, 0x2164, 
    0xFF26, 0x2163, 0xF766, 0x0047, 0x3387, 0x01F4, 0x0393, 0x0194, 
    0x03EA, 0x011E, 0x01E6, 0x0122, 0x24BC, 0x011C, 0x0122, 0x0120, 
    0x0120, 0x0413, 0x0542, 0x0494, 0x0492, 0x0490, 0x0193, 0x0533, 
    0x0403, 0x1E20, 0xFF27, 0xF6CE, 0xF760, 0xF767, 0x029B, 0x01E4, 
    0x0048, 0x25CF, 0x25AA, 0x25AB, 0x25A1, 0x33CB, 0x04A8, 0x04B2, 
    0x042A, 0x0126, 0x1E2A, 0x1E28, 0x24BD, 0x0124, 0x1E26, 0x1E22, 
    0x1E24, 0xFF28, 0x0540, 0x03E8, 0xF768, 0xF6CF, 0xF6F8, 0x3390, 
    0x0049, 0x042F, 0x0132, 0x042E, 0x00CD, 0xF7ED, 0x012C, 0x01CF, 
    0x24BE, 0x00CE, 0xF7EE, 0x0406, 0x0208, 0x00CF, 0x1E2E, 0x04E4, 
    0xF7EF, 0x0130, 0x0130, 0x1ECA, 0x04D6, 0x0415, 0x2111, 0x00CC, 
    0xF7EC, 0x1EC8, 0x0418, 0x020A, 0x0419, 0x012A, 0x04E2, 0xFF29, 
    0x053B, 0x0401, 0x012E, 0x0399, 0x0196, 0x03AA, 0x038A, 0xF769, 
    0x0197, 0x0128, 0x1E2C, 0x0474, 0x0476, 0x004A, 0x0541, 0x24BF, 
    0x0134, 0x0408, 0x054B, 0xFF2A, 0xF76A, 0x004B, 0x3385, 0x33CD, 
    0x04A0, 0x1E30, 0x041A, 0x049A, 0x04C3, 0x039A, 0x049E, 0x049C, 
    0x01E8, 0x0136, 0x24C0, 0x0136, 0x1E32, 0x0554, 0x053F, 0x0425, 
    0x03E6, 0x0198, 0x040C, 0x1E34, 0xFF2B, 0x0480, 0x03DE, 0x046E, 
    0xF76B, 0x004C, 0x01C7, 0xF6BF, 0x0139, 0x039B, 0x013D, 0x013B, 
    0x24C1, 0x1E3C, 0x013B, 0x013F, 0x013F, 0x1E36, 0x1E38, 0x053C, 
    0x01C8, 0x0409, 0x1E3A, 0xFF2C, 0x0141, 0xF6F9, 0xF76C, 0x004D, 
    0x3386, 0xF6D0, 0xF7AF, 0x1E3E, 0x24C2, 0x1E40, 0x1E42, 0x0544, 
    0xFF2D, 0xF76D, 0x019C, 0x039C, 0x004E, 0x01CA, 0x0143, 0x0147, 
    0x0145, 0x24C3, 0x1E4A, 0x0145, 0x1E44, 0x1E46, 0x019D, 0x2168, 
    0x01CB, 0x040A, 0x1E48, 0xFF2E, 0x0546, 0xF76E, 0x00D1, 0xF7F1, 
    0x039D, 0x004F, 0x0152, 0xF6FA, 0x00D3, 0xF7F3, 0x04E8, 0x04EA, 
    0x014E, 0x01D1, 0x019F, 0x24C4, 0x00D4, 0x1ED0, 0x1ED8, 0x1ED2, 
    0x1ED4, 0xF7F4, 0x1ED6, 0x041E, 0x0150, 0x020C, 0x00D6, 0x04E6, 
    0xF7F6, 0x1ECC, 0xF6FB, 0x00D2, 0xF7F2, 0x0555, 0x2126, 0x1ECE, 
    0x01A0, 0x1EDA, 0x1EE2, 0x1EDC, 0x1EDE, 0x1EE0, 0x0150, 0x01A2, 
    0x020E, 0x014C, 0x1E52, 0x1E50, 0x2126, 0x0460, 0x03A9, 0x047A, 
    0x047C, 0x038F, 0x039F, 0x038C, 0xFF2F, 0x2160, 0x01EA, 0x01EC, 
    0x0186, 0x00D8, 0x01FE, 0xF7F8, 0xF76F, 0x01FE, 0x047E, 0x00D5, 
    0x1E4C, 0x1E4E, 0xF7F5, 0x0050, 0x1E54, 0x24C5, 0x1E56, 0x041F, 
    0x054A, 0x04A6, 0x03A6, 0x01A4, 0x03A0, 0x0553, 0xFF30, 0x03A8, 
    0x0470, 0xF770, 0x0051, 0x24C6, 0xFF31, 0xF771, 0x0052, 0x054C, 
    0x0154, 0x0158, 0x0156, 0x24C7, 0x0156, 0x0210, 0x1E58, 0x1E5A, 
    0x1E5C, 0x0550, 0x211C, 0x03A1, 0xF6FC, 0x0212, 0x1E5E, 0xFF32, 
    0xF772, 0x0281, 0x02B6, 0x0053, 0x250C, 0x2514, 0x2510, 0x2518, 
    0x253C, 0x252C, 0x2534, 0x251C, 0x2524, 0x2500, 0x2502, 0x2561, 
    0x2562, 0x2556, 0x2555, 0x2563, 0x2551, 0x2557, 0x255D, 0x255C, 
    0x255B, 0x255E, 0x255F, 0x255A, 0x2554, 0x2569, 0x2566, 0x2560, 
    0x2550, 0x256C, 0x2567, 0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 
    0x2552, 0x2553, 0x256B, 0x256A, 0x015A, 0x1E64, 0x03E0, 0x0160, 
    0x1E66, 0xF6FD, 0x015E, 0x018F, 0x04D8, 0x04DA, 0x24C8, 0x015C, 
    0x0218, 0x1E60, 0x1E62, 0x1E68, 0x054D, 0x2166, 0x0547, 0x0428, 
    0x0429, 0x03E2, 0x04BA, 0x03EC, 0x03A3, 0x2165, 0xFF33, 0x042C, 
    0xF773, 0x03DA, 0x0054, 0x03A4, 0x0166, 0x0164, 0x0162, 0x24C9, 
    0x1E70, 0x0162, 0x1E6A, 0x1E6C, 0x0422, 0x04AC, 0x2169, 0x04B4, 
    0x0398, 0x01AC, 0x00DE, 0xF7FE, 0x2162, 0xF6FE, 0x054F, 0x1E6E, 
    0xFF34, 0x0539, 0x01BC, 0x0184, 0x01A7, 0x01AE, 0x0426, 0x040B, 
    0xF774, 0x216B, 0x2161, 0x0055, 0x00DA, 0xF7FA, 0x016C, 0x01D3, 
    0x24CA, 0x00DB, 0x1E76, 0xF7FB, 0x0423, 0x0170, 0x0214, 0x00DC, 
    0x01D7, 0x1E72, 0x01D9, 0x04F0, 0x01DB, 0x01D5, 0xF7FC, 0x1EE4, 
    0x00D9, 0xF7F9, 0x1EE6, 0x01AF, 0x1EE8, 0x1EF0, 0x1EEA, 0x1EEC, 
    0x1EEE, 0x0170, 0x04F2, 0x0216, 0x0478, 0x016A, 0x04EE, 0x1E7A, 
    0xFF35, 0x0172, 0x03A5, 0x03D2, 0x03D3, 0x01B1, 0x03AB, 0x03D4, 
    0x03D2, 0x038E, 0x016E, 0x040E, 0xF775, 0x04AE, 0x04B0, 0x0168, 
    0x1E78, 0x1E74, 0x0056, 0x24CB, 0x1E7E, 0x0412, 0x054E, 0x01B2, 
    0xFF36, 0x0548, 0xF776, 0x1E7C, 0x0057, 0x1E82, 0x24CC, 0x0174, 
    0x1E84, 0x1E86, 0x1E88, 0x1E80, 0xFF37, 0xF777, 0x0058, 0x24CD, 
    0x1E8C, 0x1E8A, 0x053D, 0x039E, 0xFF38, 0xF778, 0x0059, 0x00DD, 
    0xF7FD, 0x0462, 0x24CE, 0x0176, 0x0178, 0xF7FF, 0x1E8E, 0x1EF4, 
    0x042B, 0x04F8, 0x1EF2, 0x01B3, 0x1EF6, 0x0545, 0x0407, 0x0552, 
    0xFF39, 0xF779, 0x1EF8, 0x046A, 0x046C, 0x0466, 0x0468, 0x005A, 
    0x0536, 0x0179, 0x017D, 0xF6FF, 0x24CF, 0x1E90, 0x017B, 0x017B, 
    0x1E92, 0x0417, 0x0498, 0x04DE, 0x0396, 0x053A, 0x04C1, 0x0416, 
    0x0496, 0x04DC, 0x1E94, 0xFF3A, 0xF77A, 0x01B5, 0x0061, 0x0986, 
    0x00E1, 0x0906, 0x0A86, 0x0A06, 0x0A3E, 0x3303, 0x09BE, 0x093E, 
    0x0ABE, 0x055F, 0x0970, 0x0985, 0x311A, 0x0103, 0x1EAF, 0x04D1, 
    0x1EB7, 0x1EB1, 0x1EB3, 0x1EB5, 0x01CE, 0x24D0, 0x00E2, 0x1EA5, 
    0x1EAD, 0x1EA7, 0x1EA9, 0x1EAB, 0x00B4, 0x0317, 0x0301, 0x0301, 
    0x0954, 0x02CF, 0x0341, 0x0430, 0x0201, 0x0A71, 0x0905, 0x00E4, 
    0x04D3, 0x01DF, 0x1EA1, 0x01E1, 0x00E6, 0x01FD, 0x3150, 0x01E3, 
    0x2015, 0x20A4, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 
    0x0401, 0x0416, 0x0417, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 
    0x041D, 0x041E, 0x041F, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 
    0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 
    0x042D, 0x042E, 0x042F, 0x0490, 0x0402, 0x0403, 0x0404, 0x0405, 
    0x0406, 0x0407, 0x0408, 0x0409, 0x040A, 0x040B, 0x040C, 0x040E, 
    0xF6C4, 0xF6C5, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 
    0x0451, 0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 
    0x043D, 0x043E, 0x043F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 
    0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 
    0x044D, 0x044E, 0x044F, 0x0491, 0x0452, 0x0453, 0x0454, 0x0455, 
    0x0456, 0x0457, 0x0458, 0x0459, 0x045A, 0x045B, 0x045C, 0x045E, 
    0x040F, 0x0462, 0x0472, 0x0474, 0xF6C6, 0x045F, 0x0463, 0x0473, 
    0x0475, 0xF6C7, 0xF6C8, 0x04D9, 0x200E, 0x200F, 0x200D, 0x066A, 
    0x060C, 0x0660, 0x0661, 0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 
    0x0667, 0x0668, 0x0669, 0x061B, 0x061F, 0x0621, 0x0622, 0x0623, 
    0x0624, 0x0625, 0x0626, 0x0627, 0x0628, 0x0629, 0x062A, 0x062B, 
    0x062C, 0x062D, 0x062E, 0x062F, 0x0630, 0x0631, 0x0632, 0x0633, 
    0x0634, 0x0635, 0x0636, 0x0637, 0x0638, 0x0639, 0x063A, 0x0640, 
    0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0648, 0x0649, 
    0x064A, 0x064B, 0x064C, 0x064D, 0x064E, 0x064F, 0x0650, 0x0651, 
    0x0652, 0x0647, 0x06A4, 0x067E, 0x0686, 0x0698, 0x06AF, 0x0679, 
    0x0688, 0x0691, 0x06BA, 0x06D2, 0x06D5, 0x20AA, 0x05BE, 0x05C3, 
    0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x05D4, 0x05D5, 0x05D6, 0x05D7, 
    0x05D8, 0x05D9, 0x05DA, 0x05DB, 0x05DC, 0x05DD, 0x05DE, 0x05DF, 
    0x05E0, 0x05E1, 0x05E2, 0x05E3, 0x05E4, 0x05E5, 0x05E6, 0x05E7, 
    0x05E8, 0x05E9, 0x05EA, 0xFB2A, 0xFB2B, 0xFB4B, 0xFB1F, 0x05F0, 
    0x05F1, 0x05F2, 0xFB35, 0x05B4, 0x05B5, 0x05B6, 0x05BB, 0x05B8, 
    0x05B7, 0x05B0, 0x05B2, 0x05B1, 0x05B3, 0x05C2, 0x05C1, 0x05B9, 
    0x05BC, 0x05BD, 0x05BF, 0x05C0, 0x02BC, 0x2105, 0x2113, 0x2116, 
    0x202C, 0x202D, 0x202E, 0x200C, 0x066D, 0x02BD, 0x00E0, 0x0A85, 
    0x0A05, 0x3042, 0x1EA3, 0x0990, 0x311E, 0x0910, 0x04D5, 0x0A90, 
    0x0A10, 0x0A48, 0x0639, 0xFECA, 0xFECB, 0xFECC, 0x0203, 0x09C8, 
    0x0948, 0x0AC8, 0x30A2, 0xFF71, 0x314F, 0x05D0, 0x0627, 0xFB30, 
    0xFE8E, 0x0623, 0xFE84, 0x0625, 0xFE88, 0x05D0, 0xFB4F, 0x0622, 
    0xFE82, 0x0649, 0xFEF0, 0xFEF3, 0xFEF4, 0xFB2E, 0xFB2F, 0x2135, 
    0x224C, 0x03B1, 0x03AC, 0x0101, 0xFF41, 0x0026, 0xFF06, 0xF726, 
    0x33C2, 0x3122, 0x3124, 0x0E5A, 0x2220, 0x3008, 0xFE3F, 0x3009, 
    0xFE40, 0x2329, 0x232A, 0x212B, 0x0387, 0x0952, 0x0982, 0x0902, 
    0x0A82, 0x0105, 0x3300, 0x249C, 0x055A, 0x02BC, 0xF8FF, 0x2250, 
    0x2248, 0x2252, 0x2245, 0x318E, 0x318D, 0x2312, 0x1E9A, 0x00E5, 
    0x01FB, 0x1E01, 0x2194, 0x21E3, 0x21E0, 0x21E2, 0x21E1, 0x21D4, 
    0x21D3, 0x21D0, 0x21D2, 0x21D1, 0x2193, 0x2199, 0x2198, 0x21E9, 
    0x02C5, 0x02C2, 0x02C3, 0x02C4, 0xF8E7, 0x2190, 0x21D0, 0x21CD, 
    0x21C6, 0x21E6, 0x2192, 0x21CF, 0x279E, 0x21C4, 0x21E8, 0x21E4, 
    0x21E5, 0x2191, 0x2195, 0x21A8, 0x21A8, 0x2196, 0x21C5, 0x2197, 
    0x21E7, 0xF8E6, 0x005E, 0xFF3E, 0x007E, 0xFF5E, 0x0251, 0x0252, 
    0x3041, 0x30A1, 0xFF67, 0x002A, 0x066D, 0x066D, 0x2217, 0xFF0A, 
    0xFE61, 0x2042, 0xF6E9, 0x2243, 0x0040, 0x00E3, 0xFF20, 0xFE6B, 
    0x0250, 0x0994, 0x3120, 0x0914, 0x0A94, 0x0A14, 0x09D7, 0x0A4C, 
    0x09CC, 0x094C, 0x0ACC, 0x093D, 0x0561, 0x05E2, 0xFB20, 0x05E2, 
    0x0062, 0x09AC, 0x005C, 0xFF3C, 0x092C, 0x0AAC, 0x0A2C, 0x3070, 
    0x0E3F, 0x30D0, 0x007C, 0xFF5C, 0x3105, 0x24D1, 0x1E03, 0x1E05, 
    0x266C, 0x2235, 0x0431, 0x0628, 0xFE90, 0xFE91, 0x3079, 0xFE92, 
    0xFC9F, 0xFC08, 0xFC6D, 0x30D9, 0x0562, 0x05D1, 0x03B2, 0x03D0, 
    0xFB31, 0xFB31, 0x05D1, 0xFB4C, 0x09AD, 0x092D, 0x0AAD, 0x0A2D, 
    0x0253, 0x3073, 0x30D3, 0x0298, 0x0A02, 0x3331, 0x25CF, 0x25C6, 
    0x25BC, 0x25C4, 0x25C0, 0x3010, 0xFE3B, 0x3011, 0xFE3C, 0x25E3, 
    0x25E2, 0x25AC, 0x25BA, 0x25B6, 0x25AA, 0x263B, 0x25A0, 0x2605, 
    0x25E4, 0x25E5, 0x25B4, 0x25B2, 0x2423, 0x1E07, 0x2588, 0xFF42, 
    0x0E1A, 0x307C, 0x30DC, 0x249D, 0x33C3, 0xF8F4, 0x007B, 0xF8F3, 
    0xF8F2, 0xFF5B, 0xFE5B, 0xF8F1, 0xFE37, 0x007D, 0xF8FE, 0xF8FD, 
    0xFF5D, 0xFE5C, 0xF8FC, 0xFE38, 0x005B, 0xF8F0, 0xF8EF, 0xFF3B, 
    0xF8EE, 0x005D, 0xF8FB, 0xF8FA, 0xFF3D, 0xF8F9, 0x02D8, 0x032E, 
    0x0306, 0x032F, 0x0311, 0x0361, 0x032A, 0x033A, 0x00A6, 0x0180, 
    0xF6EA, 0x0183, 0x3076, 0x30D6, 0x2022, 0x25D8, 0x2219, 0x25CE, 
    0x0063, 0x056E, 0x099A, 0x0107, 0x091A, 0x0A9A, 0x0A1A, 0x3388, 
    0x0981, 0x0310, 0x0901, 0x0A81, 0x21EA, 0x2105, 0x02C7, 0x032C, 
    0x030C, 0x21B5, 0x3118, 0x010D, 0x00E7, 0x1E09, 0x24D2, 0x0109, 
    0x0255, 0x010B, 0x010B, 0x33C5, 0x00B8, 0x0327, 0x00A2, 0x2103, 
    0xF6DF, 0xFFE0, 0xF7A2, 0xF6E0, 0x0579, 0x099B, 0x091B, 0x0A9B, 
    0x0A1B, 0x3114, 0x04BD, 0x2713, 0x0447, 0x04BF, 0x04B7, 0x04F5, 
    0x0573, 0x04CC, 0x04B9, 0x03C7, 0x3277, 0x3217, 0x3269, 0x314A, 
    0x3209, 0x0E0A, 0x0E08, 0x0E09, 0x0E0C, 0x0188, 0x3276, 0x3216, 
    0x3268, 0x3148, 0x3208, 0x321C, 0x25CB, 0x2297, 0x2299, 0x2295, 
    0x3036, 0x25D0, 0x25D1, 0x02C6, 0x032D, 0x0302, 0x2327, 0x01C2, 
    0x01C0, 0x01C1, 0x01C3, 0x2663, 0x2663, 0x2667, 0x33A4, 0xFF43, 
    0x33A0, 0x0581, 0x003A, 0x20A1, 0xFF1A, 0x20A1, 0xFE55, 0x02D1, 
    0x02D0, 0x002C, 0x0313, 0x0315, 0xF6C3, 0x060C, 0x055D, 0xF6E1, 
    0xFF0C, 0x0314, 0x02BD, 0xFE50, 0xF6E2, 0x0312, 0x02BB, 0x263C, 
    0x2245, 0x222E, 0x2303, 0x0006, 0x0007, 0x0008, 0x0018, 0x000D, 
    0x0011, 0x0012, 0x0013, 0x0014, 0x007F, 0x0010, 0x0019, 0x0005, 
    0x0004, 0x001B, 0x0017, 0x0003, 0x000C, 0x001C, 0x001D, 0x0009, 
    0x000A, 0x0015, 0x001E, 0x000F, 0x000E, 0x0002, 0x0001, 0x001A, 
    0x0016, 0x001F, 0x000B, 0x00A9, 0xF8E9, 0xF6D9, 0x300C, 0xFF62, 
    0xFE41, 0x300D, 0xFF63, 0xFE42, 0x337F, 0x33C7, 0x33C6, 0x249E, 
    0x20A2, 0x0297, 0x22CF, 0x22CE, 0x00A4, 0xF6D1, 0xF6D2, 0xF6D4, 
    0xF6D5, 0x0064, 0x0564, 0x09A6, 0x0636, 0x0926, 0xFEBE, 0xFEBF, 
    0xFEC0, 0x05BC, 0x05BC, 0x2020, 0x2021, 0x0AA6, 0x0A26, 0x3060, 
    0x30C0, 0x062F, 0x05D3, 0xFB33, 0xFB33, 0x05D3, 0xFEAA, 0x064F, 
    0x064F, 0x064C, 0x064C, 0x0964, 0x05A7, 0x05A7, 0x0485, 0xF6D3, 
    0x300A, 0xFE3D, 0x300B, 0xFE3E, 0x032B, 0x21D4, 0x21D2, 0x0965, 
    0xF6D6, 0x030F, 0x222C, 0x2017, 0x0333, 0x033F, 0x02BA, 0x2016, 
    0x030E, 0x3109, 0x33C8, 0x010F, 0x1E11, 0x24D3, 0x1E13, 0x0111, 
    0x09A1, 0x0921, 0x0AA1, 0x0A21, 0x0688, 0xFB89, 0x095C, 0x09A2, 
    0x0922, 0x0AA2, 0x0A22, 0x1E0B, 0x1E0D, 0x066B, 0x066B, 0x0434, 
    0x00B0, 0x05AD, 0x3067, 0x03EF, 0x30C7, 0x232B, 0x2326, 0x03B4, 
    0x018D, 0x09F8, 0x02A4, 0x09A7, 0x0927, 0x0AA7, 0x0A27, 0x0257, 
    0x0385, 0x0344, 0x2666, 0x2662, 0x00A8, 0xF6D7, 0x0324, 0x0308, 
    0xF6D8, 0x0385, 0x3062, 0x30C2, 0x3003, 0x00F7, 0x2223, 0x2215, 
    0x0452, 0x2593, 0x1E0F, 0x3397, 0x0111, 0xFF44, 0x2584, 0x0E0E, 
    0x0E14, 0x3069, 0x30C9, 0x0024, 0xF6E3, 0xFF04, 0xF724, 0xFE69, 
    0xF6E4, 0x20AB, 0x3326, 0x02D9, 0x0307, 0x0323, 0x0323, 0x30FB, 
    0x0131, 0xF6BE, 0x0284, 0x22C5, 0x25CC, 0xFB1F, 0xFB1F, 0x031E, 
    0x02D5, 0x249F, 0xF6EB, 0x0256, 0x018C, 0x3065, 0x30C5, 0x01F3, 
    0x02A3, 0x01C6, 0x02A5, 0x04E1, 0x0455, 0x045F, 0x0065, 0x00E9, 
    0x2641, 0x098F, 0x311C, 0x0115, 0x090D, 0x0A8D, 0x0945, 0x0AC5, 
    0x011B, 0x1E1D, 0x0565, 0x0587, 0x24D4, 0x00EA, 0x1EBF, 0x1E19, 
    0x1EC7, 0x1EC1, 0x1EC3, 0x1EC5, 0x0454, 0x0205, 0x090F, 0x00EB, 
    0x0117, 0x0117, 0x1EB9, 0x0A0F, 0x0A47, 0x0444, 0x00E8, 0x0A8F, 
    0x0567, 0x311D, 0x3048, 0x1EBB, 0x311F, 0x0038, 0x0668, 0x09EE, 
    0x2467, 0x2791, 0x096E, 0x2471, 0x2485, 0x2499, 0x0AEE, 0x0A6E, 
    0x0668, 0x3028, 0x266B, 0x3227, 0x2088, 0xFF18, 0xF738, 0x247B, 
    0x248F, 0x06F8, 0x2177, 0x2078, 0x0E58, 0x0207, 0x0465, 0x30A8, 
    0xFF74, 0x0A74, 0x3154, 0x043B, 0x2208, 0x246A, 0x247E, 0x2492, 
    0x217A, 0x2026, 0x22EE, 0x0113, 0x1E17, 0x1E15, 0x043C, 0x2014, 
    0xFE31, 0xFF45, 0x055B, 0x2205, 0x3123, 0x043D, 0x2013, 0xFE32, 
    0x04A3, 0x014B, 0x3125, 0x04A5, 0x04C8, 0x2002, 0x0119, 0x3153, 
    0x025B, 0x029A, 0x025C, 0x025E, 0x025D, 0x24A0, 0x03B5, 0x03AD, 
    0x003D, 0xFF1D, 0xFE66, 0x207C, 0x2261, 0x3126, 0x0440, 0x0258, 
    0x044D, 0x0441, 0x04AB, 0x0283, 0x0286, 0x090E, 0x0946, 0x01AA, 
    0x0285, 0x3047, 0x30A7, 0xFF6A, 0x212E, 0xF6EC, 0x03B7, 0x0568, 
    0x03AE, 0x00F0, 0x1EBD, 0x1E1B, 0x0591, 0x0591, 0x0591, 0x0591, 
    0x01DD, 0x3161, 0x20AC, 0x09C7, 0x0947, 0x0AC7, 0x0021, 0x055C, 
    0x203C, 0x00A1, 0xF7A1, 0xFF01, 0xF721, 0x2203, 0x0292, 0x01EF, 
    0x0293, 0x01B9, 0x01BA, 0x0066, 0x095E, 0x0A5E, 0x2109, 0x064E, 
    0x064E, 0x064B, 0x3108, 0x24D5, 0x1E1F, 0x0641, 0x0586, 0xFED2, 
    0xFED3, 0xFED4, 0x03E5, 0x2640, 0xFB00, 0xFB03, 0xFB04, 0xFB01, 
    0x246E, 0x2482, 0x2496, 0x2012, 0x25A0, 0x25AC, 0x05DA, 0xFB3A, 
    0xFB3A, 0x05DA, 0x05DD, 0x05DD, 0x05DF, 0x05DF, 0x05E3, 0x05E3, 
    0x05E5, 0x05E5, 0x02C9, 0x25C9, 0x0473, 0x0035, 0x0665, 0x09EB, 
    0x2464, 0x278E, 0x096B, 0x215D, 0x0AEB, 0x0A6B, 0x0665, 0x3025, 
    0x3224, 0x2085, 0xFF15, 0xF735, 0x2478, 0x248C, 0x06F5, 0x2174, 
    0x2075, 0x0E55, 0xFB02, 0x0192, 0xFF46, 0x3399, 0x0E1F, 0x0E1D, 
    0x0E4F, 0x2200, 0x0034, 0x0664, 0x09EA, 0x2463, 0x278D, 0x096A, 
    0x0AEA, 0x0A6A, 0x0664, 0x3024, 0x3223, 0x2084, 0xFF14, 0x09F7, 
    0xF734, 0x2477, 0x248B, 0x06F4, 0x2173, 0x2074, 0x246D, 0x2481, 
    0x2495, 0x0E54, 0x02CB, 0x24A1, 0x2044, 0x20A3, 0x0067, 0x0997, 
    0x01F5, 0x0917, 0x06AF, 0xFB93, 0xFB94, 0xFB95, 0x0A97, 0x0A17, 
    0x304C, 0x30AC, 0x03B3, 0x0263, 0x02E0, 0x03EB, 0x310D, 0x011F, 
    0x01E7, 0x0123, 0x24D6, 0x011D, 0x0123, 0x0121, 0x0121, 0x0433, 
    0x3052, 0x30B2, 0x2251, 0x059C, 0x05F3, 0x059D, 0x00DF, 0x059E, 
    0x05F4, 0x3013, 0x0998, 0x0572, 0x0918, 0x0A98, 0x0A18, 0x063A, 
    0xFECE, 0xFECF, 0xFED0, 0x0495, 0x0493, 0x0491, 0x095A, 0x0A5A, 
    0x0260, 0x3393, 0x304E, 0x30AE, 0x0563, 0x05D2, 0xFB32, 0xFB32, 
    0x05D2, 0x0453, 0x01BE, 0x0294, 0x0296, 0x02C0, 0x0295, 0x02C1, 
    0x02E4, 0x02A1, 0x02A2, 0x1E21, 0xFF47, 0x3054, 0x30B4, 0x24A2, 
    0x33AC, 0x2207, 0x0060, 0x0316, 0x0300, 0x0300, 0x0953, 0x02CE, 
    0xFF40, 0x0340, 0x003E, 0x2265, 0x22DB, 0xFF1E, 0x2273, 0x2277, 
    0x2267, 0xFE65, 0x0261, 0x01E5, 0x3050, 0x00AB, 0x00BB, 0x2039, 
    0x203A, 0x30B0, 0x3318, 0x33C9, 0x0068, 0x04A9, 0x06C1, 0x09B9, 
    0x04B3, 0x0939, 0x0AB9, 0x0A39, 0x062D, 0xFEA2, 0xFEA3, 0x306F, 
    0xFEA4, 0x332A, 0x30CF, 0xFF8A, 0x0A4D, 0x0621, 0x0621, 0x3164, 
    0x044A, 0x21BC, 0x21C0, 0x33CA, 0x05B2, 0x05B2, 0x05B2, 0x05B2, 
    0x05B2, 0x05B2, 0x05B2, 0x05B2, 0x05B3, 0x05B3, 0x05B3, 0x05B3, 
    0x05B3, 0x05B3, 0x05B3, 0x05B3, 0x05B1, 0x05B1, 0x05B1, 0x05B1, 
    0x05B1, 0x05B1, 0x05B1, 0x05B1, 0x0127, 0x310F, 0x1E2B, 0x1E29, 
    0x24D7, 0x0125, 0x1E27, 0x1E23, 0x1E25, 0x05D4, 0x2665, 0x2665, 
    0x2661, 0xFB34, 0xFB34, 0x06C1, 0x0647, 0x05D4, 0xFBA7, 0xFEEA, 
    0xFEEA, 0xFBA5, 0xFBA4, 0xFBA8, 0xFEEB, 0x3078, 0xFBA9, 0xFEEC, 
    0x337B, 0x30D8, 0xFF8D, 0x3336, 0x0267, 0x3339, 0x05D7, 0x05D7, 
    0x0266, 0x02B1, 0x327B, 0x321B, 0x326D, 0x314E, 0x320D, 0x3072, 
    0x30D2, 0xFF8B, 0x05B4, 0x05B4, 0x05B4, 0x05B4, 0x05B4, 0x05B4, 
    0x05B4, 0x05B4, 0x1E96, 0xFF48, 0x0570, 0x0E2B, 0x307B, 0x30DB, 
    0xFF8E, 0x05B9, 0x05B9, 0x05B9, 0x05B9, 0x05B9, 0x05B9, 0x05B9, 
    0x05B9, 0x0E2E, 0x0309, 0x0309, 0x0321, 0x0322, 0x3342, 0x03E9, 
    0x2015, 0x031B, 0x2668, 0x2302, 0x24A3, 0x02B0, 0x0265, 0x3075, 
    0x3333, 0x30D5, 0xFF8C, 0x02DD, 0x030B, 0x0195, 0x002D, 0xF6E5, 
    0xFF0D, 0xFE63, 0xF6E6, 0x2010, 0x0069, 0x00ED, 0x044F, 0x0987, 
    0x3127, 0x012D, 0x01D0, 0x24D8, 0x00EE, 0x0456, 0x0209, 0x328F, 
    0x328B, 0x323F, 0x323A, 0x32A5, 0x3006, 0x3001, 0xFF64, 0x3237, 
    0x32A3, 0x322F, 0x323D, 0x329D, 0x3240, 0x3296, 0x3236, 0x322B, 
    0x3232, 0x32A4, 0x3005, 0x3298, 0x3238, 0x32A7, 0x32A6, 0x32A9, 
    0x322E, 0x322A, 0x3234, 0x3002, 0x329E, 0x3243, 0x3239, 0x323E, 
    0x32A8, 0x3299, 0x3242, 0x3233, 0x3000, 0x3235, 0x3231, 0x323B, 
    0x3230, 0x323C, 0x322C, 0x322D, 0x3007, 0x328E, 0x328A, 0x3294, 
    0x3290, 0x328C, 0x328D, 0x0907, 0x00EF, 0x1E2F, 0x04E5, 0x1ECB, 
    0x04D7, 0x0435, 0x3275, 0x3215, 0x3267, 0x3147, 0x3207, 0x00EC, 
    0x0A87, 0x0A07, 0x3044, 0x1EC9, 0x0988, 0x0438, 0x0908, 0x0A88, 
    0x0A08, 0x0A40, 0x020B, 0x0439, 0x09C0, 0x0940, 0x0AC0, 0x0133, 
    0x30A4, 0xFF72, 0x3163, 0x02DC, 0x05AC, 0x012B, 0x04E3, 0x2253, 
    0x0A3F, 0xFF49, 0x2206, 0x221E, 0x056B, 0x222B, 0x2321, 0x2321, 
    0xF8F5, 0x2320, 0x2320, 0x2229, 0x3305, 0x25D8, 0x25D9, 0x263B, 
    0x0451, 0x012F, 0x03B9, 0x03CA, 0x0390, 0x0269, 0x03AF, 0x24A4, 
    0x0A72, 0x3043, 0x30A3, 0xFF68, 0x09FA, 0x0268, 0xF6ED, 0x309D, 
    0x30FD, 0x0129, 0x1E2D, 0x3129, 0x044E, 0x09BF, 0x093F, 0x0ABF, 
    0x0475, 0x0477, 0x006A, 0x0571, 0x099C, 0x091C, 0x0A9C, 0x0A1C, 
    0x3110, 0x01F0, 0x24D9, 0x0135, 0x029D, 0x025F, 0x0458, 0x062C, 
    0xFE9E, 0xFE9F, 0xFEA0, 0x0698, 0xFB8B, 0x099D, 0x091D, 0x0A9D, 
    0x0A1D, 0x057B, 0x3004, 0xFF4A, 0x24A5, 0x02B2, 0x006B, 0x04A1, 
    0x0995, 0x1E31, 0x043A, 0x049B, 0x0915, 0x05DB, 0x0643, 0xFB3B, 
    0xFB3B, 0xFEDA, 0x05DB, 0xFEDB, 0xFEDC, 0xFB4D, 0x0A95, 0x0A15, 
    0x304B, 0x04C4, 0x30AB, 0xFF76, 0x03BA, 0x03F0, 0x3171, 0x3184, 
    0x3178, 0x3179, 0x330D, 0x0640, 0x0640, 0x30F5, 0x3384, 0x0650, 
    0x064D, 0x049F, 0xFF70, 0x049D, 0x310E, 0x3389, 0x01E9, 0x0137, 
    0x24DA, 0x0137, 0x1E33, 0x0584, 0x3051, 0x30B1, 0xFF79, 0x056F, 
    0x30F6, 0x0138, 0x0996, 0x0445, 0x0916, 0x0A96, 0x0A16, 0x062E, 
    0xFEA6, 0xFEA7, 0xFEA8, 0x03E7, 0x0959, 0x0A59, 0x3278, 0x3218, 
    0x326A, 0x314B, 0x320A, 0x0E02, 0x0E05, 0x0E03, 0x0E04, 0x0E5B, 
    0x0199, 0x0E06, 0x3391, 0x304D, 0x30AD, 0xFF77, 0x3315, 0x3316, 
    0x3314, 0x326E, 0x320E, 0x3260, 0x3131, 0x3200, 0x3133, 0x045C, 
    0x1E35, 0x3398, 0x33A6, 0xFF4B, 0x33A2, 0x3053, 0x33C0, 0x0E01, 
    0x30B3, 0xFF7A, 0x331E, 0x0481, 0x327F, 0x0343, 0x24A6, 0x33AA, 
    0x046F, 0x33CF, 0x029E, 0x304F, 0x30AF, 0xFF78, 0x33B8, 0x33BE, 
    0x006C, 0x09B2, 0x013A, 0x0932, 0x0AB2, 0x0A32, 0x0E45, 0xFEFC, 
    0xFEF8, 0xFEF7, 0xFEFA, 0xFEF9, 0xFEFB, 0xFEF6, 0xFEF5, 0x0644, 
    0x03BB, 0x019B, 0x05DC, 0xFB3C, 0xFB3C, 0x05DC, 0xFEDE, 0xFCCA, 
    0xFEDF, 0xFCC9, 0xFCCB, 0xFDF2, 0xFEE0, 0xFD88, 0xFCCC, 0x25EF, 
    0x019A, 0x026C, 0x310C, 0x013E, 0x013C, 0x24DB, 0x1E3D, 0x013C, 
    0x0140, 0x0140, 0x1E37, 0x1E39, 0x031A, 0x0318, 0x003C, 0x2264, 
    0x22DA, 0xFF1C, 0x2272, 0x2276, 0x2266, 0xFE64, 0x026E, 0x258C, 
    0x026D, 0x20A4, 0x056C, 0x01C9, 0x0459, 0xF6C0, 0x0933, 0x0AB3, 
    0x1E3B, 0x0934, 0x09E1, 0x0961, 0x09E3, 0x0963, 0x026B, 0xFF4C, 
    0x33D0, 0x0E2C, 0x2227, 0x00AC, 0x2310, 0x2228, 0x0E25, 0x017F, 
    0xFE4E, 0x0332, 0xFE4D, 0x25CA, 0x24A7, 0x0142, 0x2113, 0xF6EE, 
    0x2591, 0x0E26, 0x098C, 0x090C, 0x09E2, 0x0962, 0x33D3, 0x006D, 
    0x09AE, 0x00AF, 0x0331, 0x0304, 0x02CD, 0xFFE3, 0x1E3F, 0x092E, 
    0x0AAE, 0x0A2E, 0x05A4, 0x05A4, 0x307E, 0xF895, 0xF894, 0x0E4B, 
    0xF893, 0xF88C, 0xF88B, 0x0E48, 0xF88A, 0xF884, 0x0E31, 0xF889, 
    0x0E47, 0xF88F, 0xF88E, 0x0E49, 0xF88D, 0xF892, 0xF891, 0x0E4A, 
    0xF890, 0x0E46, 0x30DE, 0xFF8F, 0x2642, 0x3347, 0x05BE, 0x2642, 
    0x05AF, 0x3383, 0x3107, 0x33D4, 0x24DC, 0x33A5, 0x1E41, 0x1E43, 
    0x0645, 0xFEE2, 0xFEE3, 0xFEE4, 0xFCD1, 0xFC48, 0x334D, 0x3081, 
    0x337E, 0x30E1, 0xFF92, 0x05DE, 0xFB3E, 0xFB3E, 0x05DE, 0x0574, 
    0x05A5, 0x05A6, 0x05A6, 0x05A5, 0x0271, 0x3392, 0xFF65, 0x00B7, 
    0x3272, 0x3212, 0x3264, 0x3141, 0x3170, 0x3204, 0x316E, 0x316F, 
    0x307F, 0x30DF, 0xFF90, 0x2212, 0x0320, 0x2296, 0x02D7, 0x2213, 
    0x2032, 0x334A, 0x3349, 0x0270, 0x3396, 0x33A3, 0xFF4D, 0x339F, 
    0x3082, 0x33C1, 0x30E2, 0xFF93, 0x33D6, 0x0E21, 0x33A7, 0x33A8, 
    0x24A8, 0x33AB, 0x33B3, 0xF6EF, 0x026F, 0x00B5, 0x00B5, 0x3382, 
    0x226B, 0x226A, 0x338C, 0x03BC, 0x338D, 0x3080, 0x30E0, 0xFF91, 
    0x3395, 0x00D7, 0x339B, 0x05A3, 0x05A3, 0x266A, 0x266B, 0x266D, 
    0x266F, 0x33B2, 0x33B6, 0x33BC, 0x33B9, 0x33B7, 0x33BF, 0x33BD, 
    0x006E, 0x09A8, 0x2207, 0x0144, 0x0928, 0x0AA8, 0x0A28, 0x306A, 
    0x30CA, 0xFF85, 0x0149, 0x3381, 0x310B, 0x00A0, 0x0148, 0x0146, 
    0x24DD, 0x1E4B, 0x0146, 0x1E45, 0x1E47, 0x306D, 0x30CD, 0xFF88, 
    0x20AA, 0x338B, 0x0999, 0x0919, 0x0A99, 0x0A19, 0x0E07, 0x3093, 
    0x0272, 0x0273, 0x326F, 0x320F, 0x3135, 0x3261, 0x3136, 0x3134, 
    0x3168, 0x3201, 0x3167, 0x3166, 0x306B, 0x30CB, 0xFF86, 0xF899, 
    0x0E4D, 0x0039, 0x0669, 0x09EF, 0x2468, 0x2792, 0x096F, 0x0AEF, 
    0x0A6F, 0x0669, 0x3029, 0x3228, 0x2089, 0xFF19, 0xF739, 0x247C, 
    0x2490, 0x06F9, 0x2178, 0x2079, 0x2472, 0x2486, 0x249A, 0x0E59, 
    0x01CC, 0x045A, 0x30F3, 0xFF9D, 0x019E, 0x1E49, 0xFF4E, 0x339A, 
    0x09A3, 0x0923, 0x0AA3, 0x0A23, 0x0929, 0x306E, 0x30CE, 0xFF89, 
    0x00A0, 0x0E13, 0x0E19, 0x0646, 0xFEE6, 0x06BA, 0xFB9F, 0xFEE7, 
    0xFCD2, 0xFC4B, 0xFEE8, 0xFCD5, 0xFC4E, 0xFC8D, 0x220C, 0x2209, 
    0x2209, 0x2260, 0x226F, 0x2271, 0x2279, 0x2262, 0x226E, 0x2270, 
    0x2226, 0x2280, 0x2284, 0x2281, 0x2285, 0x0576, 0x24A9, 0x33B1, 
    0x207F, 0x00F1, 0x03BD, 0x306C, 0x30CC, 0xFF87, 0x09BC, 0x093C, 
    0x0ABC, 0x0A3C, 0x0023, 0xFF03, 0xFE5F, 0x0374, 0x0375, 0x2116, 
    0x05E0, 0xFB40, 0xFB40, 0x05E0, 0x33B5, 0x33BB, 0x099E, 0x091E, 
    0x0A9E, 0x0A1E, 0x006F, 0x00F3, 0x0E2D, 0x0275, 0x04E9, 0x04EB, 
    0x0993, 0x311B, 0x014F, 0x0911, 0x0A91, 0x0949, 0x0AC9, 0x01D2, 
    0x24DE, 0x00F4, 0x1ED1, 0x1ED9, 0x1ED3, 0x1ED5, 0x1ED7, 0x043E, 
    0x0151, 0x020D, 0x0913, 0x00F6, 0x04E7, 0x1ECD, 0x0153, 0x315A, 
    0x02DB, 0x0328, 0x00F2, 0x0A93, 0x0585, 0x304A, 0x1ECF, 0x01A1, 
    0x1EDB, 0x1EE3, 0x1EDD, 0x1EDF, 0x1EE1, 0x0151, 0x01A3, 0x020F, 
    0x30AA, 0xFF75, 0x3157, 0x05AB, 0x014D, 0x1E53, 0x1E51, 0x0950, 
    0x03C9, 0x03D6, 0x0461, 0x0277, 0x047B, 0x047D, 0x03CE, 0x0AD0, 
    0x03BF, 0x03CC, 0xFF4F, 0x0031, 0x0661, 0x09E7, 0x2460, 0x278A, 
    0x0967, 0x2024, 0x215B, 0xF6DC, 0x0AE7, 0x0A67, 0x0661, 0x00BD, 
    0x3021, 0x3220, 0x2081, 0xFF11, 0x09F4, 0xF731, 0x2474, 0x2488, 
    0x06F1, 0x00BC, 0x2170, 0x00B9, 0x0E51, 0x2153, 0x01EB, 0x01ED, 
    0x0A13, 0x0A4B, 0x0254, 0x24AA, 0x25E6, 0x2325, 0x00AA, 0x00BA, 
    0x221F, 0x0912, 0x094A, 0x00F8, 0x01FF, 0x3049, 0x30A9, 0xFF6B, 
    0x01FF, 0xF6F0, 0x047F, 0x00F5, 0x1E4D, 0x1E4F, 0x3121, 0x203E, 
    0xFE4A, 0x0305, 0xFE49, 0xFE4C, 0xFE4B, 0x00AF, 0x09CB, 0x094B, 
    0x0ACB, 0x0070, 0x3380, 0x332B, 0x09AA, 0x1E55, 0x092A, 0x21DF, 
    0x21DE, 0x0AAA, 0x0A2A, 0x3071, 0x0E2F, 0x30D1, 0x0484, 0x04C0, 
    0x317F, 0x00B6, 0x2225, 0x0028, 0xFD3E, 0xF8ED, 0xF8EC, 0x208D, 
    0xFF08, 0xFE59, 0x207D, 0xF8EB, 0xFE35, 0x0029, 0xFD3F, 0xF8F8, 
    0xF8F7, 0x208E, 0xFF09, 0xFE5A, 0x207E, 0xF8F6, 0xFE36, 0x2202, 
    0x05C0, 0x0599, 0x33A9, 0x05B7, 0x05B7, 0x05B7, 0x05B7, 0x05B7, 
    0x05B7, 0x05B7, 0x05B7, 0x05A1, 0x3106, 0x24DF, 0x1E57, 0x05E4, 
    0x043F, 0xFB44, 0xFB44, 0x333B, 0xFB43, 0x067E, 0x057A, 0x05E4, 
    0xFB57, 0xFB58, 0x307A, 0xFB59, 0x30DA, 0x04A7, 0xFB4E, 0x0025, 
    0x066A, 0xFF05, 0xFE6A, 0x002E, 0x0589, 0x00B7, 0xFF61, 0xF6E7, 
    0xFF0E, 0xFE52, 0xF6E8, 0x0342, 0x22A5, 0x2030, 0x20A7, 0x338A, 
    0x09AB, 0x092B, 0x0AAB, 0x0A2B, 0x03C6, 0x03D5, 0x327A, 0x321A, 
    0x326C, 0x314D, 0x320C, 0x0278, 0x0E3A, 0x03D5, 0x01A5, 0x0E1E, 
    0x0E1C, 0x0E20, 0x03C0, 0x3273, 0x3213, 0x3176, 0x3265, 0x3172, 
    0x3142, 0x3205, 0x3174, 0x3144, 0x3175, 0x3177, 0x3173, 0x3074, 
    0x30D4, 0x03D6, 0x0583, 0x002B, 0x031F, 0x2295, 0x00B1, 0x02D6, 
    0xFF0B, 0xFE62, 0x207A, 0xFF50, 0x33D8, 0x307D, 0x261F, 0x261C, 
    0x261E, 0x261D, 0x30DD, 0x0E1B, 0x3012, 0x3020, 0x24AB, 0x227A, 
    0x211E, 0x02B9, 0x2035, 0x220F, 0x2305, 0x30FC, 0x2318, 0x2282, 
    0x2283, 0x2237, 0x221D, 0x03C8, 0x0471, 0x0486, 0x33B0, 0x3077, 
    0x30D7, 0x33B4, 0x33BA, 0x0071, 0x0958, 0x05A8, 0x0642, 0xFED6, 
    0xFED7, 0xFED8, 0x05B8, 0x05B8, 0x05B8, 0x05B8, 0x05B8, 0x05B8, 
    0x05B8, 0x05B8, 0x05B8, 0x05B8, 0x05B8, 0x05B8, 0x05B8, 0x05B8, 
    0x05B8, 0x05B8, 0x059F, 0x3111, 0x24E0, 0x02A0, 0xFF51, 0x05E7, 
    0xFB47, 0xFB47, 0x05E7, 0x24AC, 0x2669, 0x05BB, 0x05BB, 0x05BB, 
    0x05BB, 0x05BB, 0x05BB, 0x05BB, 0x05BB, 0x003F, 0x061F, 0x055E, 
    0x00BF, 0xF7BF, 0x037E, 0xFF1F, 0xF73F, 0x0022, 0x201E, 0x201C, 
    0xFF02, 0x301E, 0x301D, 0x201D, 0x2018, 0x201B, 0x201B, 0x2019, 
    0x0149, 0x201A, 0x0027, 0xFF07, 0x0072, 0x057C, 0x09B0, 0x0155, 
    0x0930, 0x221A, 0xF8E5, 0x33AE, 0x33AF, 0x33AD, 0x05BF, 0x05BF, 
    0x0AB0, 0x0A30, 0x3089, 0x30E9, 0xFF97, 0x09F1, 0x09F0, 0x0264, 
    0x2236, 0x3116, 0x0159, 0x0157, 0x24E1, 0x0157, 0x0211, 0x1E59, 
    0x1E5B, 0x1E5D, 0x203B, 0x2286, 0x2287, 0x00AE, 0xF8E8, 0xF6DA, 
    0x0631, 0x0580, 0xFEAE, 0x308C, 0x30EC, 0xFF9A, 0x05E8, 0xFB48, 
    0x05E8, 0x223D, 0x0597, 0x0597, 0x2310, 0x027E, 0x027F, 0x09DD, 
    0x095D, 0x03C1, 0x027D, 0x027B, 0x02B5, 0x03F1, 0x02DE, 0x3271, 
    0x3211, 0x3263, 0x3140, 0x313A, 0x3169, 0x3139, 0x313B, 0x316C, 
    0x3203, 0x313F, 0x313C, 0x316B, 0x313D, 0x313E, 0x316A, 0x316D, 
    0x221F, 0x0319, 0x22BF, 0x308A, 0x30EA, 0xFF98, 0x02DA, 0x0325, 
    0x030A, 0x02BF, 0x0559, 0x031C, 0x02D3, 0x02BE, 0x0339, 0x02D2, 
    0x0213, 0x3351, 0x1E5F, 0x027C, 0x027A, 0xFF52, 0x308D, 0x30ED, 
    0xFF9B, 0x0E23, 0x24AD, 0x09DC, 0x0931, 0x0A5C, 0x0691, 0xFB8D, 
    0x09E0, 0x0960, 0x0AE0, 0x09C4, 0x0944, 0x0AC4, 0xF6F1, 0x2590, 
    0x0279, 0x02B4, 0x308B, 0x30EB, 0xFF99, 0x09F2, 0x09F3, 0xF6DD, 
    0x0E24, 0x098B, 0x090B, 0x0A8B, 0x09C3, 0x0943, 0x0AC3, 0x0073, 
    0x09B8, 0x015B, 0x1E65, 0x0635, 0x0938, 0xFEBA, 0xFEBB, 0xFEBC, 
    0x0AB8, 0x0A38, 0x3055, 0x30B5, 0xFF7B, 0xFDFA, 0x05E1, 0xFB41, 
    0xFB41, 0x05E1, 0x0E32, 0x0E41, 0x0E44, 0x0E43, 0x0E33, 0x0E30, 
    0x0E40, 0xF886, 0x0E35, 0xF885, 0x0E34, 0x0E42, 0xF888, 0x0E37, 
    0xF887, 0x0E36, 0x0E38, 0x0E39, 0x3119, 0x0161, 0x1E67, 0x015F, 
    0x0259, 0x04D9, 0x04DB, 0x025A, 0x24E2, 0x015D, 0x0219, 0x1E61, 
    0x1E63, 0x1E69, 0x033C, 0x2033, 0x02CA, 0x00A7, 0x0633, 0xFEB2, 
    0xFEB3, 0xFEB4, 0x05B6, 0x05B6, 0x05B6, 0x05B6, 0x05B6, 0x05B6, 
    0x05B6, 0x0592, 0x05B6, 0x057D, 0x305B, 0x30BB, 0xFF7E, 0x003B, 
    0x061B, 0xFF1B, 0xFE54, 0x309C, 0xFF9F, 0x3322, 0x3323, 0x0037, 
    0x0667, 0x09ED, 0x2466, 0x2790, 0x096D, 0x215E, 0x0AED, 0x0A6D, 
    0x0667, 0x3027, 0x3226, 0x2087, 0xFF17, 0xF737, 0x247A, 0x248E, 
    0x06F7, 0x2176, 0x2077, 0x2470, 0x2484, 0x2498, 0x0E57, 0x00AD, 
    0x0577, 0x09B6, 0x0448, 0x0651, 0xFC61, 0xFC5E, 0xFC60, 0xFC62, 
    0xFC5F, 0x2592, 0x2593, 0x2591, 0x2592, 0x0936, 0x0AB6, 0x0A36, 
    0x0593, 0x3115, 0x0449, 0x0634, 0xFEB6, 0xFEB7, 0xFEB8, 0x03E3, 
    0x20AA, 0x20AA, 0x05B0, 0x05B0, 0x05B0, 0x05B0, 0x05B0, 0x05B0, 
    0x05B0, 0x05B0, 0x05B0, 0x04BB, 0x03ED, 0x05E9, 0xFB49, 0xFB49, 
    0xFB2C, 0xFB2C, 0xFB2D, 0xFB2D, 0x05C1, 0x05E9, 0xFB2A, 0xFB2A, 
    0xFB2B, 0xFB2B, 0x0282, 0x03C3, 0x03C2, 0x03C2, 0x03F2, 0x3057, 
    0x30B7, 0xFF7C, 0x05BD, 0x05BD, 0x223C, 0x05C2, 0x3274, 0x3214, 
    0x317E, 0x3266, 0x317A, 0x3145, 0x317B, 0x3206, 0x317D, 0x317C, 
    0x0036, 0x0666, 0x09EC, 0x2465, 0x278F, 0x096C, 0x0AEC, 0x0A6C, 
    0x0666, 0x3026, 0x3225, 0x2086, 0xFF16, 0xF736, 0x2479, 0x248D, 
    0x06F6, 0x2175, 0x2076, 0x246F, 0x09F9, 0x2483, 0x2497, 0x0E56, 
    0x002F, 0xFF0F, 0x017F, 0x1E9B, 0x263A, 0xFF53, 0x05C3, 0x00AD, 
    0x044C, 0x305D, 0x30BD, 0xFF7F, 0x0338, 0x0337, 0x0E29, 0x0E28, 
    0x0E0B, 0x0E2A, 0x0020, 0x0020, 0x2660, 0x2660, 0x2664, 0x24AE, 
    0x033B, 0x33C4, 0x339D, 0x25A9, 0x25A4, 0x338F, 0x339E, 0x33CE, 
    0x33D1, 0x33D2, 0x338E, 0x33D5, 0x339C, 0x33A1, 0x25A6, 0x25A7, 
    0x25A8, 0x25A5, 0x25A3, 0x33DB, 0x09B7, 0x0937, 0x0AB7, 0x3149, 
    0x3185, 0x3180, 0x3132, 0x3165, 0x3143, 0x3146, 0x3138, 0xF6F2, 
    0x00A3, 0xFFE1, 0x0336, 0x0335, 0x2282, 0x228A, 0x2286, 0x227B, 
    0x220B, 0x3059, 0x30B9, 0xFF7D, 0x0652, 0x2211, 0x263C, 0x2283, 
    0x228B, 0x2287, 0x33DC, 0x337C, 0x0074, 0x09A4, 0x22A4, 0x22A3, 
    0x0924, 0x0AA4, 0x0A24, 0x0637, 0xFEC2, 0xFEC3, 0x305F, 0xFEC4, 
    0x337D, 0x30BF, 0xFF80, 0x0640, 0x03C4, 0x05EA, 0xFB4A, 0xFB4A, 
    0xFB4A, 0x05EA, 0x0167, 0x310A, 0x0165, 0x02A8, 0x0163, 0x0686, 
    0xFB7B, 0xFB7C, 0xFB7D, 0x24E3, 0x1E71, 0x0163, 0x1E97, 0x1E6B, 
    0x1E6D, 0x0442, 0x04AD, 0x062A, 0xFE96, 0xFCA2, 0xFC0C, 0xFE97, 
    0x3066, 0xFCA1, 0xFC0B, 0x0629, 0xFE94, 0xFE98, 0xFCA4, 0xFC0E, 
    0xFC73, 0x30C6, 0xFF83, 0x2121, 0x260E, 0x05A0, 0x05A9, 0x2469, 
    0x3229, 0x247D, 0x2491, 0x2179, 0x02A7, 0x05D8, 0xFB38, 0xFB38, 
    0x05D8, 0x04B5, 0x059B, 0x059B, 0x09A5, 0x0925, 0x0AA5, 0x0A25, 
    0x0630, 0xFEAC, 0xF898, 0xF897, 0x0E4C, 0xF896, 0x062B, 0xFE9A, 
    0xFE9B, 0xFE9C, 0x2203, 0x2234, 0x03B8, 0x03D1, 0x03D1, 0x3279, 
    0x3219, 0x326B, 0x314C, 0x320B, 0x246C, 0x2480, 0x2494, 0x0E11, 
    0x01AD, 0x0E12, 0x00FE, 0x0E17, 0x0E10, 0x0E18, 0x0E16, 0x0482, 
    0x066C, 0x066C, 0x0033, 0x0663, 0x09E9, 0x2462, 0x278C, 0x0969, 
    0x215C, 0x0AE9, 0x0A69, 0x0663, 0x3023, 0x3222, 0x2083, 0xFF13, 
    0x09F6, 0xF733, 0x2476, 0x248A, 0x06F3, 0x00BE, 0xF6DE, 0x2172, 
    0x00B3, 0x0E53, 0x3394, 0x3061, 0x30C1, 0xFF81, 0x3270, 0x3210, 
    0x3262, 0x3137, 0x3202, 0x02DC, 0x0330, 0x0303, 0x0303, 0x0360, 
    0x223C, 0x0334, 0x033E, 0x2297, 0x0596, 0x0596, 0x0A70, 0x0483, 
    0x057F, 0x1E6F, 0xFF54, 0x0569, 0x3068, 0x30C8, 0xFF84, 0x02E5, 
    0x02E9, 0x02E6, 0x02E8, 0x02E7, 0x01BD, 0x0185, 0x01A8, 0x0384, 
    0x3327, 0x0E0F, 0x3014, 0xFE5D, 0xFE39, 0x3015, 0xFE5E, 0xFE3A, 
    0x0E15, 0x01AB, 0x24AF, 0x2122, 0xF8EA, 0xF6DB, 0x0288, 0x25BC, 
    0x25C4, 0x25BA, 0x25B2, 0x02A6, 0x05E6, 0xFB46, 0xFB46, 0x05E6, 
    0x0446, 0x05B5, 0x05B5, 0x05B5, 0x05B5, 0x05B5, 0x05B5, 0x05B5, 
    0x05B5, 0x045B, 0xF6F3, 0x099F, 0x091F, 0x0A9F, 0x0A1F, 0x0679, 
    0xFB67, 0xFB68, 0xFB69, 0x09A0, 0x0920, 0x0AA0, 0x0A20, 0x0287, 
    0x3064, 0x30C4, 0xFF82, 0x3063, 0x30C3, 0xFF6F, 0x246B, 0x247F, 
    0x2493, 0x217B, 0x2473, 0x5344, 0x2487, 0x249B, 0x0032, 0x0662, 
    0x09E8, 0x2461, 0x278B, 0x0968, 0x2025, 0x2025, 0xFE30, 0x0AE8, 
    0x0A68, 0x0662, 0x3022, 0x3221, 0x2082, 0xFF12, 0x09F5, 0xF732, 
    0x2475, 0x2489, 0x06F2, 0x2171, 0x01BB, 0x00B2, 0x0E52, 0x2154, 
    0x0075, 0x00FA, 0x0289, 0x0989, 0x3128, 0x016D, 0x01D4, 0x24E4, 
    0x00FB, 0x1E77, 0x0443, 0x0951, 0x0171, 0x0215, 0x0909, 0x00FC, 
    0x01D8, 0x1E73, 0x01DA, 0x04F1, 0x01DC, 0x01D6, 0x1EE5, 0x00F9, 
    0x0A89, 0x0A09, 0x3046, 0x1EE7, 0x01B0, 0x1EE9, 0x1EF1, 0x1EEB, 
    0x1EED, 0x1EEF, 0x0171, 0x04F3, 0x0217, 0x30A6, 0xFF73, 0x0479, 
    0x315C, 0x016B, 0x04EF, 0x1E7B, 0x0A41, 0xFF55, 0x005F, 0x2017, 
    0xFF3F, 0xFE33, 0xFE4F, 0x222A, 0x2200, 0x0173, 0x24B0, 0x2580, 
    0x05C4, 0x03C5, 0x03CB, 0x03B0, 0x028A, 0x03CD, 0x031D, 0x02D4, 
    0x0A73, 0x016F, 0x045E, 0x3045, 0x30A5, 0xFF69, 0x04AF, 0x04B1, 
    0x0169, 0x1E79, 0x1E75, 0x098A, 0x090A, 0x0A8A, 0x0A0A, 0x0A42, 
    0x09C2, 0x0942, 0x0AC2, 0x09C1, 0x0941, 0x0AC1, 0x0076, 0x0935, 
    0x0AB5, 0x0A35, 0x30F7, 0x05D5, 0xFB35, 0xFB35, 0xFB35, 0x05D5, 
    0xFB4B, 0xFB4B, 0x05F0, 0x05F1, 0x24E5, 0x1E7F, 0x0432, 0x06A4, 
    0xFB6B, 0xFB6C, 0xFB6D, 0x30F9, 0x2640, 0x007C, 0x030D, 0x0329, 
    0x02CC, 0x02C8, 0x057E, 0x028B, 0x30F8, 0x09CD, 0x094D, 0x0ACD, 
    0x0983, 0x0903, 0x0A83, 0xFF56, 0x0578, 0x309E, 0x30FE, 0x309B, 
    0xFF9E, 0x30FA, 0x24B1, 0x1E7D, 0x028C, 0x3094, 0x30F4, 0x0077, 
    0x1E83, 0x3159, 0x308F, 0x30EF, 0xFF9C, 0x3158, 0x308E, 0x30EE, 
    0x3357, 0x301C, 0xFE34, 0x0648, 0xFEEE, 0x0624, 0xFE86, 0x33DD, 
    0x24E6, 0x0175, 0x1E85, 0x1E87, 0x1E89, 0x3091, 0x2118, 0x30F1, 
    0x315E, 0x315D, 0x1E81, 0x25E6, 0x25CB, 0x25D9, 0x300E, 0xFE43, 
    0x300F, 0xFE44, 0x25C7, 0x25C8, 0x25BF, 0x25BD, 0x25C3, 0x25C1, 
    0x3016, 0x3017, 0x25B9, 0x25B7, 0x25AB, 0x263A, 0x25A1, 0x2606, 
    0x260F, 0x3018, 0x3019, 0x25B5, 0x25B3, 0x3090, 0x30F0, 0x315F, 
    0xFF57, 0x3092, 0x30F2, 0xFF66, 0x20A9, 0xFFE6, 0x0E27, 0x24B2, 
    0x1E98, 0x02B7, 0x028D, 0x01BF, 0x0078, 0x033D, 0x3112, 0x24E7, 
    0x1E8D, 0x1E8B, 0x056D, 0x03BE, 0xFF58, 0x24B3, 0x02E3, 0x0079, 
    0x334E, 0x09AF, 0x00FD, 0x092F, 0x3152, 0x0AAF, 0x0A2F, 0x3084, 
    0x30E4, 0xFF94, 0x3151, 0x0E4E, 0x3083, 0x30E3, 0xFF6C, 0x0463, 
    0x24E8, 0x0177, 0x00FF, 0x1E8F, 0x1EF5, 0x064A, 0x06D2, 0xFBAF, 
    0xFEF2, 0x0626, 0xFE8A, 0xFE8B, 0xFE8C, 0xFEF3, 0xFEF4, 0xFCDD, 
    0xFC58, 0xFC94, 0x06D1, 0x3156, 0x00A5, 0xFFE5, 0x3155, 0x3186, 
    0x05AA, 0x05AA, 0x044B, 0x04F9, 0x3181, 0x3183, 0x3182, 0x059A, 
    0x1EF3, 0x01B4, 0x1EF7, 0x0575, 0x0457, 0x3162, 0x262F, 0x0582, 
    0xFF59, 0x05D9, 0xFB39, 0xFB39, 0x05D9, 0x05F2, 0xFB1F, 0x3088, 
    0x3189, 0x30E8, 0xFF96, 0x315B, 0x3087, 0x30E7, 0xFF6E, 0x03F3, 
    0x3188, 0x3187, 0x0E22, 0x0E0D, 0x24B4, 0x037A, 0x0345, 0x01A6, 
    0x1E99, 0x02B8, 0x1EF9, 0x028E, 0x3086, 0x318C, 0x30E6, 0xFF95, 
    0x3160, 0x046B, 0x046D, 0x0467, 0x0469, 0x3085, 0x30E5, 0xFF6D, 
    0x318B, 0x318A, 0x09DF, 0x095F, 0x007A, 0x0566, 0x017A, 0x095B, 
    0x0A5B, 0x0638, 0xFEC6, 0xFEC7, 0x3056, 0xFEC8, 0x0632, 0xFEB0, 
    0x30B6, 0x0595, 0x0594, 0x0598, 0x05D6, 0xFB36, 0xFB36, 0x05D6, 
    0x3117, 0x017E, 0x24E9, 0x1E91, 0x0291, 0x017C, 0x017C, 0x1E93, 
    0x0437, 0x0499, 0x04DF, 0x305C, 0x30BC, 0x0030, 0x0660, 0x09E6, 
    0x0966, 0x0AE6, 0x0A66, 0x0660, 0x2080, 0xFF10, 0xF730, 0x06F0, 
    0x2070, 0x0E50, 0xFEFF, 0x200C, 0x200B, 0x03B6, 0x3113, 0x056A, 
    0x04C2, 0x0436, 0x0497, 0x04DD, 0x3058, 0x30B8, 0x05AE, 0x1E95, 
    0xFF5A, 0x305E, 0x30BE, 0x24B5, 0x0290, 0x01B6, 0x305A, 0x30BA, 
};

wchar_t ps_glyph_to_unicode(char const *glyph)
{
    int i, j, k, c;

    i = -1;
    j = lenof(ps_glyphs_alphabetic);
    while (j-i > 1) {
	k = (i + j) / 2;
	c = strcmp(glyph, ps_glyphs_alphabetic[k]);

	if (c == 0)
	    return ps_codes_alphabetic[k];
	else if (c < 0)
	    j = k;
	else
	    i = k;
    }

    return 0xFFFF;		       /* illegal value means not found */
}

/* ----------------------------------------------------------------------
 * Data about the standard fonts: available glyphs and font metrics.
 */

/*
 * Character set list extracted from the back of the PostScript
 * Language Reference Manual.
 * 
 * I'm going to include a bit of shell which creates a file
 * containing the list of characters, and then several further bits
 * of shell that process it in different ways.
 */

/*

tr -s ' \n' '\n' << EOF > stdchars.txt
A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
a b c d e f g h i j k l m n o p q r s t u v w x y z
AE Aacute Acircumflex Adieresis Agrave Aring Atilde
Ccedilla
Eacute Ecircumflex Edieresis Egrave
Eth
Iacute Icircumflex Idieresis Igrave
Lslash
Ntilde
OE Oacute Ocircumflex Odieresis Ograve Oslash Otilde
Scaron
Thorn
Uacute Ucircumflex Udieresis Ugrave
Yacute Ydieresis
Zcaron
ae aacute acircumflex adieresis agrave aring atilde
ccedilla
eacute ecircumflex edieresis egrave
eth
iacute icircumflex idieresis igrave
lslash
ntilde
oe oacute ocircumflex odieresis ograve oslash otilde
scaron
thorn
uacute ucircumflex udieresis ugrave
yacute ydieresis
zcaron
acute ampersand asciicircum asciitilde asterisk at backslash bar
braceleft braceright bracketleft bracketright breve brokenbar bullet
caron cedilla cent circumflex colon comma copyright currency dagger
daggerdbl degree dieresis divide dollar dotaccent dotlessi eight
ellipsis emdash endash equal exclam exclamdown fi five fl florin
four fraction germandbls grave greater guillemotleft guillemotright
guilsinglleft guilsinglright hungarumlaut hyphen less logicalnot
macron minus mu multiply nine numbersign ogonek one onehalf onequarter
onesuperior ordfeminine ordmasculine paragraph parenleft parenright
percent period periodcentered perthousand plus plusminus question
questiondown quotedbl quotedblbase quotedblleft quotedblright quoteleft
quoteright quotesinglbase quotesingle registered ring section semicolon
seven six slash space sterling three threequarters threesuperior tilde
trademark two twosuperior underscore yen zero
EOF

 */

/*
 * A simple string array giving the glyph list.
 */

/*

perl -ne 'chomp; print "\"$_\", "; END { print "NULL" }' stdchars.txt | \
    fold -s -w68 | sed 's/^/    /'

*/

const char *const ps_std_glyphs[] = {
    "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", 
    "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", 
    "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", 
    "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", 
    "AE", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", 
    "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", 
    "Egrave", "Eth", "Iacute", "Icircumflex", "Idieresis", "Igrave", 
    "Lslash", "Ntilde", "OE", "Oacute", "Ocircumflex", "Odieresis", 
    "Ograve", "Oslash", "Otilde", "Scaron", "Thorn", "Uacute", 
    "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", 
    "Zcaron", "ae", "aacute", "acircumflex", "adieresis", "agrave", 
    "aring", "atilde", "ccedilla", "eacute", "ecircumflex", 
    "edieresis", "egrave", "eth", "iacute", "icircumflex", "idieresis", 
    "igrave", "lslash", "ntilde", "oe", "oacute", "ocircumflex", 
    "odieresis", "ograve", "oslash", "otilde", "scaron", "thorn", 
    "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", 
    "ydieresis", "zcaron", "acute", "ampersand", "asciicircum", 
    "asciitilde", "asterisk", "at", "backslash", "bar", "braceleft", 
    "braceright", "bracketleft", "bracketright", "breve", "brokenbar", 
    "bullet", "caron", "cedilla", "cent", "circumflex", "colon", 
    "comma", "copyright", "currency", "dagger", "daggerdbl", "degree", 
    "dieresis", "divide", "dollar", "dotaccent", "dotlessi", "eight", 
    "ellipsis", "emdash", "endash", "equal", "exclam", "exclamdown", 
    "fi", "five", "fl", "florin", "four", "fraction", "germandbls", 
    "grave", "greater", "guillemotleft", "guillemotright", 
    "guilsinglleft", "guilsinglright", "hungarumlaut", "hyphen", 
    "less", "logicalnot", "macron", "minus", "mu", "multiply", "nine", 
    "numbersign", "ogonek", "one", "onehalf", "onequarter", 
    "onesuperior", "ordfeminine", "ordmasculine", "paragraph", 
    "parenleft", "parenright", "percent", "period", "periodcentered", 
    "perthousand", "plus", "plusminus", "question", "questiondown", 
    "quotedbl", "quotedblbase", "quotedblleft", "quotedblright", 
    "quoteleft", "quoteright", "quotesinglbase", "quotesingle", 
    "registered", "ring", "section", "semicolon", "seven", "six", 
    "slash", "space", "sterling", "three", "threequarters", 
    "threesuperior", "tilde", "trademark", "two", "twosuperior", 
    "underscore", "yen", "zero", NULL
};

/*
 * Character width information from the standard PS fonts.
 * Units are UNITS_PER_PT defined in paper.h.
 * Extracted from the (non-free) AFM files in
 * <http://partners.adobe.com/asn/acrobat/download/fontinfo/Core14_AFMs.tar>
 * by the following script:

fonts="Times-Roman Times-Italic Times-Bold Times-BoldItalic \
       Helvetica Helvetica-Oblique Helvetica-Bold Helvetica-BoldOblique \
       Courier Courier-Oblique Courier-Bold Courier-BoldOblique"

for i in $fonts; do
  printf 'static const kern_pair %s_kerns[] = {\n' $(echo $i | tr 'A-Z\-' a-z_)
  perl -e '
open G, "stdchars.txt" or die;
chomp(@g = <G>); %g = map(($_, $i++), @g);
open M, "$ARGV[0].afm" or die;
while (<M>) { /KPX (\S+) (\S+) (\S+)/ and exists $g{$1} and exists $g{$2} and
  print "{$g{$1},$g{$2},$3}, "; } print "\n"' $i |\
    fold -sw 68 | sed 's/^/    /'
  printf '    {0xFFFF,0xFFFF,0}\n};\n'
done

cat <<DECL

static const struct ps_std_font_data {
    char const *name;
    kern_pair const *kerns;
    int widths[lenof(ps_std_glyphs)-1];
} ps_std_fonts[] = {
DECL
for i in $fonts; do
  printf '    { "%s", %s_kerns, {\n' $i $(echo $i | tr 'A-Z\-' a-z_)
  perl -e '
open M, "$ARGV[0].afm" or die;
while (<M>) { /WX (\d+) ; N (\S+)/ and $m{$2} = $1; }
open G, "stdchars.txt" or die;
while (<G>) { chomp; print "$m{$_}, " }; print "\n"' $i |\
    fold -sw 68 | sed 's/^/	/'
  printf '    }},\n'
done
printf '};\n'

 */

static const kern_pair times_roman_kerns[] = {
    {0,2,-40}, {0,59,-40}, {0,6,-40}, {0,14,-55}, {0,72,-55}, 
    {0,73,-55}, {0,74,-55}, {0,75,-55}, {0,76,-55}, {0,77,-55}, 
    {0,16,-55}, {0,19,-111}, {0,20,-55}, {0,80,-55}, {0,81,-55}, 
    {0,82,-55}, {0,83,-55}, {0,21,-135}, {0,22,-90}, {0,24,-105}, 
    {0,84,-105}, {0,85,-105}, {0,206,-111}, {0,47,-74}, {0,48,-92}, 
    {0,50,-92}, {0,119,-92}, {0,120,-92}, {53,2,-40}, {53,59,-40}, 
    {53,6,-40}, {53,14,-55}, {53,72,-55}, {53,73,-55}, {53,74,-55}, 
    {53,75,-55}, {53,76,-55}, {53,77,-55}, {53,16,-55}, {53,19,-111}, 
    {53,20,-55}, {53,80,-55}, {53,81,-55}, {53,82,-55}, {53,83,-55}, 
    {53,21,-135}, {53,22,-90}, {53,24,-105}, {53,84,-105}, 
    {53,85,-105}, {53,206,-111}, {53,47,-74}, {53,48,-92}, {53,50,-92}, 
    {53,119,-92}, {53,120,-92}, {54,2,-40}, {54,59,-40}, {54,6,-40}, 
    {54,14,-55}, {54,72,-55}, {54,73,-55}, {54,74,-55}, {54,75,-55}, 
    {54,76,-55}, {54,77,-55}, {54,16,-55}, {54,19,-111}, {54,20,-55}, 
    {54,80,-55}, {54,81,-55}, {54,82,-55}, {54,83,-55}, {54,21,-135}, 
    {54,22,-90}, {54,24,-105}, {54,84,-105}, {54,85,-105}, 
    {54,206,-111}, {54,47,-74}, {54,48,-92}, {54,50,-92}, {54,119,-92}, 
    {54,120,-92}, {55,2,-40}, {55,59,-40}, {55,6,-40}, {55,14,-55}, 
    {55,72,-55}, {55,73,-55}, {55,74,-55}, {55,75,-55}, {55,76,-55}, 
    {55,77,-55}, {55,16,-55}, {55,19,-111}, {55,20,-55}, {55,80,-55}, 
    {55,81,-55}, {55,82,-55}, {55,83,-55}, {55,21,-135}, {55,22,-90}, 
    {55,24,-105}, {55,84,-105}, {55,85,-105}, {55,206,-111}, 
    {55,47,-74}, {55,48,-92}, {55,50,-92}, {55,119,-92}, {55,120,-92}, 
    {56,2,-40}, {56,59,-40}, {56,6,-40}, {56,14,-55}, {56,72,-55}, 
    {56,73,-55}, {56,74,-55}, {56,75,-55}, {56,76,-55}, {56,77,-55}, 
    {56,16,-55}, {56,19,-111}, {56,20,-55}, {56,80,-55}, {56,81,-55}, 
    {56,82,-55}, {56,83,-55}, {56,21,-135}, {56,22,-90}, {56,24,-105}, 
    {56,84,-105}, {56,85,-105}, {56,206,-111}, {56,47,-74}, 
    {56,48,-92}, {56,50,-92}, {56,119,-92}, {56,120,-92}, {57,2,-40}, 
    {57,59,-40}, {57,6,-40}, {57,14,-55}, {57,72,-55}, {57,73,-55}, 
    {57,74,-55}, {57,75,-55}, {57,76,-55}, {57,77,-55}, {57,16,-55}, 
    {57,19,-111}, {57,20,-55}, {57,80,-55}, {57,81,-55}, {57,82,-55}, 
    {57,83,-55}, {57,21,-135}, {57,22,-90}, {57,24,-105}, {57,84,-105}, 
    {57,85,-105}, {57,206,-111}, {57,47,-74}, {57,48,-92}, {57,50,-92}, 
    {57,119,-92}, {57,120,-92}, {58,2,-40}, {58,59,-40}, {58,6,-40}, 
    {58,14,-55}, {58,72,-55}, {58,73,-55}, {58,74,-55}, {58,75,-55}, 
    {58,76,-55}, {58,77,-55}, {58,16,-55}, {58,19,-111}, {58,20,-55}, 
    {58,80,-55}, {58,81,-55}, {58,82,-55}, {58,83,-55}, {58,21,-135}, 
    {58,22,-90}, {58,24,-105}, {58,84,-105}, {58,85,-105}, 
    {58,206,-111}, {58,47,-74}, {58,48,-92}, {58,50,-92}, {58,119,-92}, 
    {58,120,-92}, {1,0,-35}, {1,53,-35}, {1,54,-35}, {1,55,-35}, 
    {1,56,-35}, {1,57,-35}, {1,58,-35}, {1,20,-10}, {1,80,-10}, 
    {1,81,-10}, {1,82,-10}, {1,83,-10}, {3,0,-40}, {3,53,-40}, 
    {3,54,-40}, {3,55,-40}, {3,56,-40}, {3,57,-40}, {3,58,-40}, 
    {3,21,-40}, {3,22,-30}, {3,24,-55}, {3,84,-55}, {3,85,-55}, 
    {5,0,-74}, {5,53,-74}, {5,54,-74}, {5,55,-74}, {5,56,-74}, 
    {5,57,-74}, {5,58,-74}, {5,26,-15}, {5,88,-15}, {5,89,-15}, 
    {5,90,-15}, {5,91,-15}, {5,92,-15}, {5,93,-15}, {5,142,-80}, 
    {5,40,-15}, {5,107,-15}, {5,108,-15}, {5,109,-15}, {5,110,-15}, 
    {5,111,-15}, {5,112,-15}, {5,194,-80}, {9,0,-60}, {9,53,-60}, 
    {9,54,-60}, {9,55,-60}, {9,56,-60}, {9,57,-60}, {9,58,-60}, 
    {10,14,-30}, {10,72,-30}, {10,73,-30}, {10,74,-30}, {10,75,-30}, 
    {10,76,-30}, {10,77,-30}, {10,30,-25}, {10,95,-25}, {10,96,-25}, 
    {10,97,-25}, {10,98,-25}, {10,40,-35}, {10,107,-35}, {10,108,-35}, 
    {10,109,-35}, {10,110,-35}, {10,111,-35}, {10,112,-35}, 
    {10,46,-15}, {10,115,-15}, {10,116,-15}, {10,117,-15}, 
    {10,118,-15}, {10,50,-25}, {10,119,-25}, {10,120,-25}, {11,19,-92}, 
    {11,21,-100}, {11,22,-74}, {11,24,-100}, {11,84,-100}, 
    {11,85,-100}, {11,206,-92}, {11,50,-55}, {11,119,-55}, 
    {11,120,-55}, {69,19,-92}, {69,21,-100}, {69,22,-74}, {69,24,-100}, 
    {69,84,-100}, {69,85,-100}, {69,206,-92}, {69,50,-55}, 
    {69,119,-55}, {69,120,-55}, {13,0,-35}, {13,53,-35}, {13,54,-35}, 
    {13,55,-35}, {13,56,-35}, {13,57,-35}, {13,58,-35}, {70,0,-35}, 
    {70,53,-35}, {70,54,-35}, {70,55,-35}, {70,56,-35}, {70,57,-35}, 
    {70,58,-35}, {14,0,-35}, {14,53,-35}, {14,54,-35}, {14,55,-35}, 
    {14,56,-35}, {14,57,-35}, {14,58,-35}, {14,19,-40}, {14,21,-50}, 
    {14,22,-35}, {14,23,-40}, {14,24,-50}, {14,84,-50}, {14,85,-50}, 
    {72,0,-35}, {72,53,-35}, {72,54,-35}, {72,55,-35}, {72,56,-35}, 
    {72,57,-35}, {72,58,-35}, {72,19,-40}, {72,21,-50}, {72,22,-35}, 
    {72,23,-40}, {72,24,-50}, {72,84,-50}, {72,85,-50}, {73,0,-35}, 
    {73,53,-35}, {73,54,-35}, {73,55,-35}, {73,56,-35}, {73,57,-35}, 
    {73,58,-35}, {73,19,-40}, {73,21,-50}, {73,22,-35}, {73,23,-40}, 
    {73,24,-50}, {73,84,-50}, {73,85,-50}, {74,0,-35}, {74,53,-35}, 
    {74,54,-35}, {74,55,-35}, {74,56,-35}, {74,57,-35}, {74,58,-35}, 
    {74,19,-40}, {74,21,-50}, {74,22,-35}, {74,23,-40}, {74,24,-50}, 
    {74,84,-50}, {74,85,-50}, {75,0,-35}, {75,53,-35}, {75,54,-35}, 
    {75,55,-35}, {75,56,-35}, {75,57,-35}, {75,58,-35}, {75,19,-40}, 
    {75,21,-50}, {75,22,-35}, {75,23,-40}, {75,24,-50}, {75,84,-50}, 
    {75,85,-50}, {76,0,-35}, {76,53,-35}, {76,54,-35}, {76,55,-35}, 
    {76,56,-35}, {76,57,-35}, {76,58,-35}, {76,19,-40}, {76,21,-50}, 
    {76,22,-35}, {76,23,-40}, {76,24,-50}, {76,84,-50}, {76,85,-50}, 
    {77,0,-35}, {77,53,-35}, {77,54,-35}, {77,55,-35}, {77,56,-35}, 
    {77,57,-35}, {77,58,-35}, {77,19,-40}, {77,21,-50}, {77,22,-35}, 
    {77,23,-40}, {77,24,-50}, {77,84,-50}, {77,85,-50}, {15,0,-92}, 
    {15,53,-92}, {15,54,-92}, {15,55,-92}, {15,56,-92}, {15,57,-92}, 
    {15,58,-92}, {15,26,-15}, {15,88,-15}, {15,89,-15}, {15,90,-15}, 
    {15,91,-15}, {15,92,-15}, {15,93,-15}, {15,142,-111}, 
    {15,194,-111}, {16,20,-10}, {16,80,-10}, {16,81,-10}, {16,82,-10}, 
    {16,83,-10}, {17,14,-40}, {17,72,-40}, {17,73,-40}, {17,74,-40}, 
    {17,75,-40}, {17,76,-40}, {17,77,-40}, {17,19,-60}, {17,20,-40}, 
    {17,80,-40}, {17,81,-40}, {17,82,-40}, {17,83,-40}, {17,21,-80}, 
    {17,22,-55}, {17,24,-65}, {17,84,-65}, {17,85,-65}, {19,0,-93}, 
    {19,53,-93}, {19,54,-93}, {19,55,-93}, {19,56,-93}, {19,57,-93}, 
    {19,58,-93}, {19,14,-18}, {19,72,-18}, {19,73,-18}, {19,74,-18}, 
    {19,75,-18}, {19,76,-18}, {19,77,-18}, {19,26,-80}, {19,88,-80}, 
    {19,89,-80}, {19,90,-40}, {19,91,-40}, {19,92,-80}, {19,93,-40}, 
    {19,141,-50}, {19,142,-74}, {19,30,-70}, {19,95,-70}, {19,96,-70}, 
    {19,97,-30}, {19,98,-70}, {19,174,-92}, {19,34,-35}, {19,100,-35}, 
    {19,40,-80}, {19,107,-80}, {19,108,-80}, {19,109,-80}, 
    {19,110,-80}, {19,111,-80}, {19,112,-80}, {19,194,-74}, 
    {19,43,-35}, {19,212,-55}, {19,46,-45}, {19,115,-45}, {19,116,-45}, 
    {19,117,-45}, {19,118,-45}, {19,48,-80}, {19,50,-80}, {19,119,-80}, 
    {19,120,-80}, {20,0,-40}, {20,53,-40}, {20,54,-40}, {20,55,-40}, 
    {20,56,-40}, {20,57,-40}, {20,58,-40}, {80,0,-40}, {80,53,-40}, 
    {80,54,-40}, {80,55,-40}, {80,56,-40}, {80,57,-40}, {80,58,-40}, 
    {81,0,-40}, {81,53,-40}, {81,54,-40}, {81,55,-40}, {81,56,-40}, 
    {81,57,-40}, {81,58,-40}, {82,0,-40}, {82,53,-40}, {82,54,-40}, 
    {82,55,-40}, {82,56,-40}, {82,57,-40}, {82,58,-40}, {83,0,-40}, 
    {83,53,-40}, {83,54,-40}, {83,55,-40}, {83,56,-40}, {83,57,-40}, 
    {83,58,-40}, {21,0,-135}, {21,53,-135}, {21,54,-135}, {21,55,-135}, 
    {21,56,-135}, {21,57,-135}, {21,58,-135}, {21,6,-15}, {21,14,-40}, 
    {21,72,-40}, {21,73,-40}, {21,74,-40}, {21,75,-40}, {21,76,-40}, 
    {21,77,-40}, {21,26,-111}, {21,88,-111}, {21,89,-71}, {21,90,-71}, 
    {21,91,-71}, {21,92,-111}, {21,93,-71}, {21,141,-74}, 
    {21,142,-129}, {21,30,-111}, {21,95,-111}, {21,96,-71}, 
    {21,97,-71}, {21,98,-71}, {21,174,-100}, {21,34,-60}, {21,100,-60}, 
    {21,101,-20}, {21,102,-20}, {21,103,-20}, {21,40,-129}, 
    {21,107,-129}, {21,108,-129}, {21,109,-89}, {21,110,-89}, 
    {21,111,-129}, {21,112,-89}, {21,194,-129}, {21,212,-74}, 
    {21,46,-75}, {21,115,-75}, {21,116,-75}, {21,117,-75}, 
    {21,118,-75}, {22,0,-120}, {22,53,-120}, {22,54,-120}, 
    {22,55,-120}, {22,56,-120}, {22,57,-120}, {22,58,-120}, 
    {22,14,-10}, {22,72,-10}, {22,73,-10}, {22,74,-10}, {22,75,-10}, 
    {22,76,-10}, {22,77,-10}, {22,26,-80}, {22,88,-80}, {22,89,-80}, 
    {22,90,-80}, {22,91,-80}, {22,92,-80}, {22,93,-80}, {22,141,-37}, 
    {22,142,-92}, {22,30,-80}, {22,95,-80}, {22,96,-80}, {22,97,-40}, 
    {22,98,-40}, {22,174,-65}, {22,34,-40}, {22,100,-40}, {22,40,-80}, 
    {22,107,-80}, {22,108,-80}, {22,109,-80}, {22,110,-80}, 
    {22,111,-80}, {22,112,-80}, {22,194,-92}, {22,212,-37}, 
    {22,46,-50}, {22,115,-50}, {22,116,-50}, {22,117,-50}, 
    {22,118,-50}, {22,50,-73}, {22,119,-73}, {22,120,-73}, {24,0,-120}, 
    {24,53,-120}, {24,54,-120}, {24,55,-120}, {24,56,-120}, 
    {24,57,-120}, {24,58,-120}, {24,14,-30}, {24,72,-30}, {24,73,-30}, 
    {24,74,-30}, {24,75,-30}, {24,76,-30}, {24,77,-30}, {24,26,-100}, 
    {24,88,-100}, {24,89,-100}, {24,90,-60}, {24,91,-60}, {24,92,-100}, 
    {24,93,-60}, {24,141,-92}, {24,142,-129}, {24,30,-100}, 
    {24,95,-100}, {24,96,-100}, {24,97,-60}, {24,98,-60}, 
    {24,174,-111}, {24,34,-55}, {24,100,-55}, {24,40,-110}, 
    {24,107,-110}, {24,108,-110}, {24,109,-70}, {24,110,-70}, 
    {24,111,-110}, {24,112,-70}, {24,194,-129}, {24,212,-92}, 
    {24,46,-111}, {24,115,-111}, {24,116,-111}, {24,117,-71}, 
    {24,118,-71}, {84,0,-120}, {84,53,-120}, {84,54,-120}, 
    {84,55,-120}, {84,56,-120}, {84,57,-120}, {84,58,-120}, 
    {84,14,-30}, {84,72,-30}, {84,73,-30}, {84,74,-30}, {84,75,-30}, 
    {84,76,-30}, {84,77,-30}, {84,26,-100}, {84,88,-100}, {84,89,-100}, 
    {84,90,-60}, {84,91,-60}, {84,92,-100}, {84,93,-60}, {84,141,-92}, 
    {84,142,-129}, {84,30,-100}, {84,95,-100}, {84,96,-100}, 
    {84,97,-60}, {84,98,-60}, {84,174,-111}, {84,34,-55}, {84,100,-55}, 
    {84,40,-110}, {84,107,-110}, {84,108,-110}, {84,109,-70}, 
    {84,110,-70}, {84,111,-110}, {84,112,-70}, {84,194,-129}, 
    {84,212,-92}, {84,46,-111}, {84,115,-111}, {84,116,-111}, 
    {84,117,-71}, {84,118,-71}, {85,0,-120}, {85,53,-120}, 
    {85,54,-120}, {85,55,-120}, {85,56,-120}, {85,57,-120}, 
    {85,58,-120}, {85,14,-30}, {85,72,-30}, {85,73,-30}, {85,74,-30}, 
    {85,75,-30}, {85,76,-30}, {85,77,-30}, {85,26,-100}, {85,88,-100}, 
    {85,89,-100}, {85,90,-60}, {85,91,-60}, {85,92,-100}, {85,93,-100}, 
    {85,141,-92}, {85,142,-129}, {85,30,-100}, {85,95,-100}, 
    {85,96,-100}, {85,97,-60}, {85,98,-60}, {85,174,-111}, {85,34,-55}, 
    {85,100,-55}, {85,40,-110}, {85,107,-110}, {85,108,-110}, 
    {85,109,-70}, {85,110,-70}, {85,111,-110}, {85,112,-70}, 
    {85,194,-129}, {85,212,-92}, {85,46,-111}, {85,115,-111}, 
    {85,116,-111}, {85,117,-71}, {85,118,-71}, {26,47,-20}, 
    {26,48,-15}, {88,47,-20}, {88,48,-15}, {89,47,-20}, {89,48,-15}, 
    {90,47,-20}, {90,48,-15}, {91,47,-20}, {91,48,-15}, {92,47,-20}, 
    {92,48,-15}, {93,47,-20}, {93,48,-15}, {27,194,-40}, {27,46,-20}, 
    {27,115,-20}, {27,116,-20}, {27,117,-20}, {27,118,-20}, 
    {27,47,-15}, {28,50,-15}, {28,119,-15}, {28,120,-15}, {94,50,-15}, 
    {94,119,-15}, {94,120,-15}, {142,204,-70}, {142,206,-70}, 
    {30,32,-15}, {30,47,-25}, {30,48,-25}, {30,49,-15}, {30,50,-15}, 
    {30,119,-15}, {30,120,-15}, {95,32,-15}, {95,47,-25}, {95,48,-25}, 
    {95,49,-15}, {95,50,-15}, {95,119,-15}, {95,120,-15}, {96,32,-15}, 
    {96,47,-25}, {96,48,-25}, {96,49,-15}, {96,50,-15}, {96,119,-15}, 
    {96,120,-15}, {97,32,-15}, {97,47,-25}, {97,48,-25}, {97,49,-15}, 
    {97,50,-15}, {97,119,-15}, {97,120,-15}, {98,32,-15}, {98,47,-25}, 
    {98,48,-25}, {98,49,-15}, {98,50,-15}, {98,119,-15}, {98,120,-15}, 
    {31,26,-10}, {31,88,-10}, {31,89,-10}, {31,90,-10}, {31,91,-10}, 
    {31,92,-10}, {31,93,-10}, {31,152,-50}, {31,31,-25}, {31,34,-20}, 
    {31,100,-20}, {31,206,55}, {32,26,-5}, {32,88,-5}, {32,89,-5}, 
    {32,90,-5}, {32,91,-5}, {32,92,-5}, {32,93,-5}, {33,50,-5}, 
    {33,119,-5}, {33,120,-5}, {34,47,-25}, {100,47,-25}, {101,47,-25}, 
    {102,47,-25}, {103,47,-25}, {36,30,-10}, {36,95,-10}, {36,96,-10}, 
    {36,97,-10}, {36,98,-10}, {36,40,-10}, {36,107,-10}, {36,108,-10}, 
    {36,109,-10}, {36,110,-10}, {36,111,-10}, {36,112,-10}, 
    {36,50,-15}, {36,119,-15}, {36,120,-15}, {37,48,-10}, {104,48,-10}, 
    {39,47,-40}, {39,50,-15}, {39,119,-15}, {39,120,-15}, {105,47,-40}, 
    {105,50,-15}, {105,119,-15}, {105,120,-15}, {40,47,-15}, 
    {40,48,-25}, {40,50,-10}, {40,119,-10}, {40,120,-10}, {107,47,-15}, 
    {107,48,-25}, {107,50,-10}, {107,119,-10}, {107,120,-10}, 
    {108,47,-15}, {108,48,-25}, {108,50,-10}, {108,119,-10}, 
    {108,120,-10}, {109,47,-15}, {109,48,-25}, {109,50,-10}, 
    {109,119,-10}, {109,120,-10}, {110,47,-15}, {110,48,-25}, 
    {110,50,-10}, {110,119,-10}, {110,120,-10}, {111,47,-15}, 
    {111,48,-25}, {111,50,-10}, {111,119,-10}, {111,120,-10}, 
    {112,47,-15}, {112,48,-25}, {112,50,-10}, {112,119,-10}, 
    {112,120,-10}, {41,50,-10}, {41,119,-10}, {41,120,-10}, 
    {194,204,-70}, {194,206,-70}, {203,0,-80}, {203,53,-80}, 
    {203,54,-80}, {203,55,-80}, {203,56,-80}, {203,57,-80}, 
    {203,58,-80}, {205,0,-80}, {205,53,-80}, {205,54,-80}, 
    {205,55,-80}, {205,56,-80}, {205,57,-80}, {205,58,-80}, 
    {205,205,-74}, {206,29,-50}, {206,37,-10}, {206,104,-10}, 
    {206,206,-74}, {206,43,-50}, {206,44,-55}, {206,113,-55}, 
    {206,216,-74}, {206,45,-18}, {206,47,-50}, {43,142,-40}, 
    {43,32,-18}, {43,174,-20}, {43,194,-55}, {216,0,-55}, {216,53,-55}, 
    {216,54,-55}, {216,55,-55}, {216,56,-55}, {216,57,-55}, 
    {216,58,-55}, {216,19,-18}, {216,21,-50}, {216,22,-30}, 
    {216,24,-90}, {216,84,-90}, {216,85,-90}, {47,26,-25}, {47,88,-25}, 
    {47,89,-25}, {47,90,-25}, {47,91,-25}, {47,92,-25}, {47,93,-25}, 
    {47,142,-65}, {47,30,-15}, {47,95,-15}, {47,96,-15}, {47,97,-15}, 
    {47,98,-15}, {47,40,-20}, {47,107,-20}, {47,108,-20}, {47,109,-20}, 
    {47,110,-20}, {47,111,-20}, {47,112,-20}, {47,194,-65}, 
    {48,26,-10}, {48,88,-10}, {48,89,-10}, {48,90,-10}, {48,91,-10}, 
    {48,92,-10}, {48,93,-10}, {48,142,-65}, {48,40,-10}, {48,107,-10}, 
    {48,108,-10}, {48,109,-10}, {48,110,-10}, {48,111,-10}, 
    {48,112,-10}, {48,194,-65}, {49,30,-15}, {49,95,-15}, {49,96,-15}, 
    {49,97,-15}, {49,98,-15}, {50,142,-65}, {50,194,-65}, 
    {119,142,-65}, {119,194,-65}, {120,142,-65}, {120,194,-65}, 
    {0xFFFF,0xFFFF,0}
};
static const kern_pair times_italic_kerns[] = {
    {0,2,-30}, {0,59,-30}, {0,6,-35}, {0,14,-40}, {0,72,-40}, 
    {0,73,-40}, {0,74,-40}, {0,75,-40}, {0,76,-40}, {0,77,-40}, 
    {0,16,-40}, {0,19,-37}, {0,20,-50}, {0,80,-50}, {0,81,-50}, 
    {0,82,-50}, {0,83,-50}, {0,21,-105}, {0,22,-95}, {0,24,-55}, 
    {0,84,-55}, {0,85,-55}, {0,206,-37}, {0,46,-20}, {0,115,-20}, 
    {0,116,-20}, {0,117,-20}, {0,118,-20}, {0,47,-55}, {0,48,-55}, 
    {0,50,-55}, {0,119,-55}, {0,120,-55}, {53,2,-30}, {53,59,-30}, 
    {53,6,-35}, {53,14,-40}, {53,72,-40}, {53,73,-40}, {53,74,-40}, 
    {53,75,-40}, {53,76,-40}, {53,77,-40}, {53,16,-40}, {53,19,-37}, 
    {53,20,-50}, {53,80,-50}, {53,81,-50}, {53,82,-50}, {53,83,-50}, 
    {53,21,-105}, {53,22,-95}, {53,24,-55}, {53,84,-55}, {53,85,-55}, 
    {53,206,-37}, {53,46,-20}, {53,115,-20}, {53,116,-20}, 
    {53,117,-20}, {53,118,-20}, {53,47,-55}, {53,48,-55}, {53,50,-55}, 
    {53,119,-55}, {53,120,-55}, {54,2,-30}, {54,59,-30}, {54,6,-35}, 
    {54,14,-40}, {54,72,-40}, {54,73,-40}, {54,74,-40}, {54,75,-40}, 
    {54,76,-40}, {54,77,-40}, {54,16,-40}, {54,19,-37}, {54,20,-50}, 
    {54,80,-50}, {54,81,-50}, {54,82,-50}, {54,83,-50}, {54,21,-105}, 
    {54,22,-95}, {54,24,-55}, {54,84,-55}, {54,85,-55}, {54,206,-37}, 
    {54,46,-20}, {54,115,-20}, {54,116,-20}, {54,117,-20}, 
    {54,118,-20}, {54,47,-55}, {54,48,-55}, {54,50,-55}, {54,119,-55}, 
    {54,120,-55}, {55,2,-30}, {55,59,-30}, {55,6,-35}, {55,14,-40}, 
    {55,72,-40}, {55,73,-40}, {55,74,-40}, {55,75,-40}, {55,76,-40}, 
    {55,77,-40}, {55,16,-40}, {55,19,-37}, {55,20,-50}, {55,80,-50}, 
    {55,81,-50}, {55,82,-50}, {55,83,-50}, {55,21,-105}, {55,22,-95}, 
    {55,24,-55}, {55,84,-55}, {55,85,-55}, {55,206,-37}, {55,46,-20}, 
    {55,115,-20}, {55,116,-20}, {55,117,-20}, {55,118,-20}, 
    {55,47,-55}, {55,48,-55}, {55,50,-55}, {55,119,-55}, {55,120,-55}, 
    {56,2,-30}, {56,59,-30}, {56,6,-35}, {56,14,-40}, {56,72,-40}, 
    {56,73,-40}, {56,74,-40}, {56,75,-40}, {56,76,-40}, {56,77,-40}, 
    {56,16,-40}, {56,19,-37}, {56,20,-50}, {56,80,-50}, {56,81,-50}, 
    {56,82,-50}, {56,83,-50}, {56,21,-105}, {56,22,-95}, {56,24,-55}, 
    {56,84,-55}, {56,85,-55}, {56,206,-37}, {56,46,-20}, {56,115,-20}, 
    {56,116,-20}, {56,117,-20}, {56,118,-20}, {56,47,-55}, {56,48,-55}, 
    {56,50,-55}, {56,119,-55}, {56,120,-55}, {57,2,-30}, {57,59,-30}, 
    {57,6,-35}, {57,14,-40}, {57,72,-40}, {57,73,-40}, {57,74,-40}, 
    {57,75,-40}, {57,76,-40}, {57,77,-40}, {57,16,-40}, {57,19,-37}, 
    {57,20,-50}, {57,80,-50}, {57,81,-50}, {57,82,-50}, {57,83,-50}, 
    {57,21,-105}, {57,22,-95}, {57,24,-55}, {57,84,-55}, {57,85,-55}, 
    {57,206,-37}, {57,46,-20}, {57,115,-20}, {57,116,-20}, 
    {57,117,-20}, {57,118,-20}, {57,47,-55}, {57,48,-55}, {57,50,-55}, 
    {57,119,-55}, {57,120,-55}, {58,2,-30}, {58,59,-30}, {58,6,-35}, 
    {58,14,-40}, {58,72,-40}, {58,73,-40}, {58,74,-40}, {58,75,-40}, 
    {58,76,-40}, {58,77,-40}, {58,16,-40}, {58,19,-37}, {58,20,-50}, 
    {58,80,-50}, {58,81,-50}, {58,82,-50}, {58,83,-50}, {58,21,-105}, 
    {58,22,-95}, {58,24,-55}, {58,84,-55}, {58,85,-55}, {58,206,-37}, 
    {58,46,-20}, {58,115,-20}, {58,116,-20}, {58,117,-20}, 
    {58,118,-20}, {58,47,-55}, {58,48,-55}, {58,50,-55}, {58,119,-55}, 
    {58,120,-55}, {1,0,-25}, {1,53,-25}, {1,54,-25}, {1,55,-25}, 
    {1,56,-25}, {1,57,-25}, {1,58,-25}, {1,20,-10}, {1,80,-10}, 
    {1,81,-10}, {1,82,-10}, {1,83,-10}, {3,0,-35}, {3,53,-35}, 
    {3,54,-35}, {3,55,-35}, {3,56,-35}, {3,57,-35}, {3,58,-35}, 
    {3,21,-40}, {3,22,-40}, {3,24,-40}, {3,84,-40}, {3,85,-40}, 
    {5,0,-115}, {5,53,-115}, {5,54,-115}, {5,55,-115}, {5,56,-115}, 
    {5,57,-115}, {5,58,-115}, {5,26,-75}, {5,88,-75}, {5,89,-75}, 
    {5,90,-75}, {5,91,-75}, {5,92,-75}, {5,93,-75}, {5,142,-135}, 
    {5,30,-75}, {5,95,-75}, {5,96,-75}, {5,97,-75}, {5,98,-75}, 
    {5,34,-45}, {5,100,-45}, {5,101,-45}, {5,102,-45}, {5,103,-45}, 
    {5,40,-105}, {5,107,-105}, {5,108,-105}, {5,109,-105}, 
    {5,110,-105}, {5,111,-105}, {5,112,-105}, {5,194,-135}, {5,43,-55}, 
    {9,0,-40}, {9,53,-40}, {9,54,-40}, {9,55,-40}, {9,56,-40}, 
    {9,57,-40}, {9,58,-40}, {9,26,-35}, {9,88,-35}, {9,89,-35}, 
    {9,90,-35}, {9,91,-35}, {9,92,-35}, {9,93,-35}, {9,142,-25}, 
    {9,30,-25}, {9,95,-25}, {9,96,-25}, {9,97,-25}, {9,98,-25}, 
    {9,40,-25}, {9,107,-25}, {9,108,-25}, {9,109,-25}, {9,110,-25}, 
    {9,111,-25}, {9,112,-25}, {9,194,-25}, {9,46,-35}, {9,115,-35}, 
    {9,116,-35}, {9,117,-35}, {9,118,-35}, {10,14,-50}, {10,72,-50}, 
    {10,73,-50}, {10,74,-50}, {10,75,-50}, {10,76,-50}, {10,77,-50}, 
    {10,30,-35}, {10,95,-35}, {10,96,-35}, {10,97,-35}, {10,98,-35}, 
    {10,40,-40}, {10,107,-40}, {10,108,-40}, {10,109,-40}, 
    {10,110,-40}, {10,111,-40}, {10,112,-40}, {10,46,-40}, 
    {10,115,-40}, {10,116,-40}, {10,117,-40}, {10,118,-40}, 
    {10,50,-40}, {10,119,-40}, {10,120,-40}, {11,19,-20}, {11,21,-55}, 
    {11,22,-55}, {11,24,-20}, {11,84,-20}, {11,85,-20}, {11,206,-37}, 
    {11,50,-30}, {11,119,-30}, {11,120,-30}, {69,19,-20}, {69,21,-55}, 
    {69,22,-55}, {69,24,-20}, {69,84,-20}, {69,85,-20}, {69,206,-37}, 
    {69,50,-30}, {69,119,-30}, {69,120,-30}, {13,0,-27}, {13,53,-27}, 
    {13,54,-27}, {13,55,-27}, {13,56,-27}, {13,57,-27}, {13,58,-27}, 
    {70,0,-27}, {70,53,-27}, {70,54,-27}, {70,55,-27}, {70,56,-27}, 
    {70,57,-27}, {70,58,-27}, {14,0,-55}, {14,53,-55}, {14,54,-55}, 
    {14,55,-55}, {14,56,-55}, {14,57,-55}, {14,58,-55}, {14,19,-40}, 
    {14,21,-50}, {14,22,-50}, {14,23,-40}, {14,24,-50}, {14,84,-50}, 
    {14,85,-50}, {72,0,-55}, {72,53,-55}, {72,54,-55}, {72,55,-55}, 
    {72,56,-55}, {72,57,-55}, {72,58,-55}, {72,19,-40}, {72,21,-50}, 
    {72,22,-50}, {72,23,-40}, {72,24,-50}, {72,84,-50}, {72,85,-50}, 
    {73,0,-55}, {73,53,-55}, {73,54,-55}, {73,55,-55}, {73,56,-55}, 
    {73,57,-55}, {73,58,-55}, {73,19,-40}, {73,21,-50}, {73,22,-50}, 
    {73,23,-40}, {73,24,-50}, {73,84,-50}, {73,85,-50}, {74,0,-55}, 
    {74,53,-55}, {74,54,-55}, {74,55,-55}, {74,56,-55}, {74,57,-55}, 
    {74,58,-55}, {74,19,-40}, {74,21,-50}, {74,22,-50}, {74,23,-40}, 
    {74,24,-50}, {74,84,-50}, {74,85,-50}, {75,0,-55}, {75,53,-55}, 
    {75,54,-55}, {75,55,-55}, {75,56,-55}, {75,57,-55}, {75,58,-55}, 
    {75,19,-40}, {75,21,-50}, {75,22,-50}, {75,23,-40}, {75,24,-50}, 
    {75,84,-50}, {75,85,-50}, {76,0,-55}, {76,53,-55}, {76,54,-55}, 
    {76,55,-55}, {76,56,-55}, {76,57,-55}, {76,58,-55}, {76,19,-40}, 
    {76,21,-50}, {76,22,-50}, {76,23,-40}, {76,24,-50}, {76,84,-50}, 
    {76,85,-50}, {77,0,-55}, {77,53,-55}, {77,54,-55}, {77,55,-55}, 
    {77,56,-55}, {77,57,-55}, {77,58,-55}, {77,19,-40}, {77,21,-50}, 
    {77,22,-50}, {77,23,-40}, {77,24,-50}, {77,84,-50}, {77,85,-50}, 
    {15,0,-90}, {15,53,-90}, {15,54,-90}, {15,55,-90}, {15,56,-90}, 
    {15,57,-90}, {15,58,-90}, {15,26,-80}, {15,88,-80}, {15,89,-80}, 
    {15,90,-80}, {15,91,-80}, {15,92,-80}, {15,93,-80}, {15,142,-135}, 
    {15,30,-80}, {15,95,-80}, {15,96,-80}, {15,97,-80}, {15,98,-80}, 
    {15,40,-80}, {15,107,-80}, {15,108,-80}, {15,109,-80}, 
    {15,110,-80}, {15,111,-80}, {15,112,-80}, {15,194,-135}, 
    {16,20,-10}, {16,80,-10}, {16,81,-10}, {16,82,-10}, {16,83,-10}, 
    {17,14,-40}, {17,72,-40}, {17,73,-40}, {17,74,-40}, {17,75,-40}, 
    {17,76,-40}, {17,77,-40}, {17,20,-40}, {17,80,-40}, {17,81,-40}, 
    {17,82,-40}, {17,83,-40}, {17,21,-18}, {17,22,-18}, {17,24,-18}, 
    {17,84,-18}, {17,85,-18}, {19,0,-50}, {19,53,-50}, {19,54,-50}, 
    {19,55,-50}, {19,56,-50}, {19,57,-50}, {19,58,-50}, {19,14,-18}, 
    {19,72,-18}, {19,73,-18}, {19,74,-18}, {19,75,-18}, {19,76,-18}, 
    {19,77,-18}, {19,26,-92}, {19,88,-92}, {19,89,-92}, {19,90,-92}, 
    {19,91,-92}, {19,92,-92}, {19,93,-92}, {19,141,-55}, {19,142,-74}, 
    {19,30,-92}, {19,95,-92}, {19,96,-52}, {19,97,-52}, {19,98,-52}, 
    {19,174,-74}, {19,34,-55}, {19,100,-55}, {19,40,-92}, {19,107,-92}, 
    {19,108,-92}, {19,109,-92}, {19,110,-92}, {19,111,-92}, 
    {19,112,-92}, {19,194,-74}, {19,43,-55}, {19,212,-65}, {19,46,-55}, 
    {19,115,-55}, {19,116,-55}, {19,117,-55}, {19,118,-55}, 
    {19,48,-74}, {19,50,-74}, {19,119,-74}, {19,120,-34}, {20,0,-40}, 
    {20,53,-40}, {20,54,-40}, {20,55,-40}, {20,56,-40}, {20,57,-40}, 
    {20,58,-40}, {20,142,-25}, {20,194,-25}, {80,0,-40}, {80,53,-40}, 
    {80,54,-40}, {80,55,-40}, {80,56,-40}, {80,57,-40}, {80,58,-40}, 
    {80,142,-25}, {80,194,-25}, {81,0,-40}, {81,53,-40}, {81,54,-40}, 
    {81,55,-40}, {81,56,-40}, {81,57,-40}, {81,58,-40}, {81,142,-25}, 
    {81,194,-25}, {82,0,-40}, {82,53,-40}, {82,54,-40}, {82,55,-40}, 
    {82,56,-40}, {82,57,-40}, {82,58,-40}, {82,142,-25}, {82,194,-25}, 
    {83,0,-40}, {83,53,-40}, {83,54,-40}, {83,55,-40}, {83,56,-40}, 
    {83,57,-40}, {83,58,-40}, {83,142,-25}, {83,194,-25}, {21,0,-60}, 
    {21,53,-60}, {21,54,-60}, {21,55,-60}, {21,56,-60}, {21,57,-60}, 
    {21,58,-60}, {21,14,-30}, {21,72,-30}, {21,73,-30}, {21,74,-30}, 
    {21,75,-30}, {21,76,-30}, {21,77,-30}, {21,26,-111}, {21,88,-111}, 
    {21,89,-111}, {21,90,-111}, {21,91,-111}, {21,92,-111}, 
    {21,93,-111}, {21,141,-65}, {21,142,-129}, {21,30,-111}, 
    {21,95,-111}, {21,96,-111}, {21,97,-71}, {21,98,-71}, {21,174,-55}, 
    {21,34,-74}, {21,100,-74}, {21,101,-34}, {21,102,-34}, 
    {21,103,-34}, {21,40,-111}, {21,107,-111}, {21,108,-111}, 
    {21,109,-111}, {21,110,-111}, {21,111,-111}, {21,112,-111}, 
    {21,194,-129}, {21,212,-74}, {21,46,-74}, {21,115,-74}, 
    {21,116,-74}, {21,117,-74}, {21,118,-74}, {22,0,-60}, {22,53,-60}, 
    {22,54,-60}, {22,55,-60}, {22,56,-60}, {22,57,-60}, {22,58,-60}, 
    {22,14,-25}, {22,72,-25}, {22,73,-25}, {22,74,-25}, {22,75,-25}, 
    {22,76,-25}, {22,77,-25}, {22,26,-92}, {22,88,-92}, {22,89,-92}, 
    {22,90,-92}, {22,91,-92}, {22,92,-92}, {22,93,-92}, {22,141,-65}, 
    {22,142,-92}, {22,30,-92}, {22,95,-92}, {22,96,-92}, {22,97,-52}, 
    {22,98,-52}, {22,174,-37}, {22,34,-55}, {22,100,-55}, {22,40,-92}, 
    {22,107,-92}, {22,108,-92}, {22,109,-92}, {22,110,-92}, 
    {22,111,-92}, {22,112,-92}, {22,194,-92}, {22,212,-65}, 
    {22,46,-55}, {22,115,-55}, {22,116,-55}, {22,117,-55}, 
    {22,118,-55}, {22,50,-70}, {22,119,-70}, {22,120,-70}, {24,0,-50}, 
    {24,53,-50}, {24,54,-50}, {24,55,-50}, {24,56,-50}, {24,57,-50}, 
    {24,58,-50}, {24,14,-15}, {24,72,-15}, {24,73,-15}, {24,74,-15}, 
    {24,75,-15}, {24,76,-15}, {24,77,-15}, {24,26,-92}, {24,88,-92}, 
    {24,89,-92}, {24,90,-92}, {24,91,-92}, {24,92,-92}, {24,93,-92}, 
    {24,141,-65}, {24,142,-92}, {24,30,-92}, {24,95,-92}, {24,96,-92}, 
    {24,97,-52}, {24,98,-52}, {24,174,-74}, {24,34,-74}, {24,100,-74}, 
    {24,101,-34}, {24,102,-34}, {24,103,-34}, {24,40,-92}, 
    {24,107,-92}, {24,108,-92}, {24,109,-92}, {24,110,-92}, 
    {24,111,-92}, {24,112,-92}, {24,194,-92}, {24,212,-65}, 
    {24,46,-92}, {24,115,-92}, {24,116,-92}, {24,117,-92}, 
    {24,118,-92}, {84,0,-50}, {84,53,-50}, {84,54,-50}, {84,55,-50}, 
    {84,56,-50}, {84,57,-50}, {84,58,-50}, {84,14,-15}, {84,72,-15}, 
    {84,73,-15}, {84,74,-15}, {84,75,-15}, {84,76,-15}, {84,77,-15}, 
    {84,26,-92}, {84,88,-92}, {84,89,-92}, {84,90,-92}, {84,91,-92}, 
    {84,92,-92}, {84,93,-92}, {84,141,-65}, {84,142,-92}, {84,30,-92}, 
    {84,95,-92}, {84,96,-92}, {84,97,-52}, {84,98,-52}, {84,174,-74}, 
    {84,34,-74}, {84,100,-74}, {84,101,-34}, {84,102,-34}, 
    {84,103,-34}, {84,40,-92}, {84,107,-92}, {84,108,-92}, 
    {84,109,-92}, {84,110,-92}, {84,111,-92}, {84,112,-92}, 
    {84,194,-92}, {84,212,-65}, {84,46,-92}, {84,115,-92}, 
    {84,116,-92}, {84,117,-92}, {84,118,-92}, {85,0,-50}, {85,53,-50}, 
    {85,54,-50}, {85,55,-50}, {85,56,-50}, {85,57,-50}, {85,58,-50}, 
    {85,14,-15}, {85,72,-15}, {85,73,-15}, {85,74,-15}, {85,75,-15}, 
    {85,76,-15}, {85,77,-15}, {85,26,-92}, {85,88,-92}, {85,89,-92}, 
    {85,90,-92}, {85,91,-92}, {85,92,-92}, {85,93,-92}, {85,141,-65}, 
    {85,142,-92}, {85,30,-92}, {85,95,-92}, {85,96,-92}, {85,97,-52}, 
    {85,98,-52}, {85,174,-74}, {85,34,-74}, {85,100,-74}, {85,101,-34}, 
    {85,102,-34}, {85,103,-34}, {85,40,-92}, {85,107,-92}, 
    {85,108,-92}, {85,109,-92}, {85,110,-92}, {85,111,-92}, 
    {85,112,-92}, {85,194,-92}, {85,212,-65}, {85,46,-92}, 
    {85,115,-92}, {85,116,-92}, {85,117,-92}, {85,118,-92}, 
    {26,32,-10}, {88,32,-10}, {89,32,-10}, {90,32,-10}, {91,32,-10}, 
    {92,32,-10}, {93,32,-10}, {27,194,-40}, {27,46,-20}, {27,115,-20}, 
    {27,116,-20}, {27,117,-20}, {27,118,-20}, {28,33,-15}, {28,36,-20}, 
    {94,33,-15}, {94,36,-20}, {142,204,-140}, {142,206,-140}, 
    {30,142,-10}, {30,32,-40}, {30,194,-15}, {30,47,-15}, {30,48,-15}, 
    {30,49,-20}, {30,50,-30}, {30,119,-30}, {30,120,-30}, {95,142,-10}, 
    {95,32,-40}, {95,194,-15}, {95,47,-15}, {95,48,-15}, {95,49,-20}, 
    {95,50,-30}, {95,119,-30}, {95,120,-30}, {96,142,-10}, {96,32,-40}, 
    {96,194,-15}, {96,47,-15}, {96,48,-15}, {96,49,-20}, {96,50,-30}, 
    {96,119,-30}, {96,120,-30}, {97,142,-10}, {97,32,-40}, 
    {97,194,-15}, {97,47,-15}, {97,48,-15}, {97,49,-20}, {97,50,-30}, 
    {97,119,-30}, {97,120,-30}, {98,142,-10}, {98,32,-40}, 
    {98,194,-15}, {98,47,-15}, {98,48,-15}, {98,49,-20}, {98,50,-30}, 
    {98,119,-30}, {98,120,-30}, {31,142,-10}, {31,152,-60}, 
    {31,31,-18}, {31,34,-20}, {31,194,-15}, {31,206,92}, {32,142,-10}, 
    {32,30,-10}, {32,95,-10}, {32,96,-10}, {32,97,-10}, {32,98,-10}, 
    {32,32,-10}, {32,194,-15}, {36,30,-10}, {36,95,-10}, {36,96,-10}, 
    {36,97,-10}, {36,98,-10}, {36,40,-10}, {36,107,-10}, {36,108,-10}, 
    {36,109,-10}, {36,110,-10}, {36,111,-10}, {36,112,-10}, 
    {36,50,-10}, {36,119,-10}, {36,120,-10}, {39,47,-40}, {105,47,-40}, 
    {40,32,-10}, {40,47,-10}, {107,32,-10}, {107,47,-10}, {108,32,-10}, 
    {108,47,-10}, {109,32,-10}, {109,47,-10}, {110,32,-10}, 
    {110,47,-10}, {111,32,-10}, {111,47,-10}, {112,32,-10}, 
    {112,47,-10}, {194,204,-140}, {194,206,-140}, {205,205,-111}, 
    {206,29,-25}, {206,206,-111}, {206,43,-25}, {206,44,-40}, 
    {206,113,-40}, {206,216,-111}, {206,45,-30}, {206,47,-10}, 
    {43,26,-15}, {43,88,-15}, {43,89,-15}, {43,90,-15}, {43,91,-15}, 
    {43,92,-15}, {43,93,-15}, {43,28,-37}, {43,94,-37}, {43,142,-111}, 
    {43,29,-37}, {43,30,-37}, {43,95,-37}, {43,96,-37}, {43,97,-37}, 
    {43,98,-37}, {43,32,-37}, {43,174,-20}, {43,40,-45}, {43,107,-45}, 
    {43,108,-45}, {43,109,-45}, {43,110,-45}, {43,111,-45}, 
    {43,112,-45}, {43,194,-111}, {43,42,-37}, {43,44,-10}, 
    {43,113,-10}, {216,0,-18}, {216,53,-18}, {216,54,-18}, 
    {216,55,-18}, {216,56,-18}, {216,57,-18}, {216,58,-18}, 
    {216,19,-18}, {216,21,-35}, {216,22,-40}, {216,24,-75}, 
    {216,84,-75}, {216,85,-75}, {47,142,-74}, {47,194,-74}, 
    {48,142,-74}, {48,194,-74}, {50,142,-55}, {50,194,-55}, 
    {119,142,-55}, {119,194,-55}, {120,142,-55}, {120,194,-55}, 
    {0xFFFF,0xFFFF,0}
};
static const kern_pair times_bold_kerns[] = {
    {0,2,-55}, {0,59,-55}, {0,6,-55}, {0,14,-45}, {0,72,-45}, 
    {0,73,-45}, {0,74,-45}, {0,75,-45}, {0,76,-45}, {0,77,-45}, 
    {0,16,-45}, {0,19,-95}, {0,20,-50}, {0,80,-50}, {0,81,-50}, 
    {0,82,-50}, {0,83,-50}, {0,21,-145}, {0,22,-130}, {0,24,-100}, 
    {0,84,-100}, {0,85,-100}, {0,41,-25}, {0,206,-74}, {0,46,-50}, 
    {0,115,-50}, {0,116,-50}, {0,117,-50}, {0,118,-50}, {0,47,-100}, 
    {0,48,-90}, {0,50,-74}, {0,119,-74}, {0,120,-74}, {53,2,-55}, 
    {53,59,-55}, {53,6,-55}, {53,14,-45}, {53,72,-45}, {53,73,-45}, 
    {53,74,-45}, {53,75,-45}, {53,76,-45}, {53,77,-45}, {53,16,-45}, 
    {53,19,-95}, {53,20,-50}, {53,80,-50}, {53,81,-50}, {53,82,-50}, 
    {53,83,-50}, {53,21,-145}, {53,22,-130}, {53,24,-100}, 
    {53,84,-100}, {53,85,-100}, {53,41,-25}, {53,206,-74}, {53,46,-50}, 
    {53,115,-50}, {53,116,-50}, {53,117,-50}, {53,118,-50}, 
    {53,47,-100}, {53,48,-90}, {53,50,-74}, {53,119,-74}, {53,120,-74}, 
    {54,2,-55}, {54,59,-55}, {54,6,-55}, {54,14,-45}, {54,72,-45}, 
    {54,73,-45}, {54,74,-45}, {54,75,-45}, {54,76,-45}, {54,77,-45}, 
    {54,16,-45}, {54,19,-95}, {54,20,-50}, {54,80,-50}, {54,81,-50}, 
    {54,82,-50}, {54,83,-50}, {54,21,-145}, {54,22,-130}, {54,24,-100}, 
    {54,84,-100}, {54,85,-100}, {54,41,-25}, {54,206,-74}, {54,46,-50}, 
    {54,115,-50}, {54,116,-50}, {54,117,-50}, {54,118,-50}, 
    {54,47,-100}, {54,48,-90}, {54,50,-74}, {54,119,-74}, {54,120,-74}, 
    {55,2,-55}, {55,59,-55}, {55,6,-55}, {55,14,-45}, {55,72,-45}, 
    {55,73,-45}, {55,74,-45}, {55,75,-45}, {55,76,-45}, {55,77,-45}, 
    {55,16,-45}, {55,19,-95}, {55,20,-50}, {55,80,-50}, {55,81,-50}, 
    {55,82,-50}, {55,83,-50}, {55,21,-145}, {55,22,-130}, {55,24,-100}, 
    {55,84,-100}, {55,85,-100}, {55,41,-25}, {55,206,-74}, {55,46,-50}, 
    {55,115,-50}, {55,116,-50}, {55,117,-50}, {55,118,-50}, 
    {55,47,-100}, {55,48,-90}, {55,50,-74}, {55,119,-74}, {55,120,-74}, 
    {56,2,-55}, {56,59,-55}, {56,6,-55}, {56,14,-45}, {56,72,-45}, 
    {56,73,-45}, {56,74,-45}, {56,75,-45}, {56,76,-45}, {56,77,-45}, 
    {56,16,-45}, {56,19,-95}, {56,20,-50}, {56,80,-50}, {56,81,-50}, 
    {56,82,-50}, {56,83,-50}, {56,21,-145}, {56,22,-130}, {56,24,-100}, 
    {56,84,-100}, {56,85,-100}, {56,41,-25}, {56,206,-74}, {56,46,-50}, 
    {56,115,-50}, {56,116,-50}, {56,117,-50}, {56,118,-50}, 
    {56,47,-100}, {56,48,-90}, {56,50,-74}, {56,119,-74}, {56,120,-74}, 
    {57,2,-55}, {57,59,-55}, {57,6,-55}, {57,14,-45}, {57,72,-45}, 
    {57,73,-45}, {57,74,-45}, {57,75,-45}, {57,76,-45}, {57,77,-45}, 
    {57,16,-45}, {57,19,-95}, {57,20,-50}, {57,80,-50}, {57,81,-50}, 
    {57,82,-50}, {57,83,-50}, {57,21,-145}, {57,22,-130}, {57,24,-100}, 
    {57,84,-100}, {57,85,-100}, {57,41,-25}, {57,206,-74}, {57,46,-50}, 
    {57,115,-50}, {57,116,-50}, {57,117,-50}, {57,118,-50}, 
    {57,47,-100}, {57,48,-90}, {57,50,-74}, {57,119,-74}, {57,120,-74}, 
    {58,2,-55}, {58,59,-55}, {58,6,-55}, {58,14,-45}, {58,72,-45}, 
    {58,73,-45}, {58,74,-45}, {58,75,-45}, {58,76,-45}, {58,77,-45}, 
    {58,16,-45}, {58,19,-95}, {58,20,-50}, {58,80,-50}, {58,81,-50}, 
    {58,82,-50}, {58,83,-50}, {58,21,-145}, {58,22,-130}, {58,24,-100}, 
    {58,84,-100}, {58,85,-100}, {58,41,-25}, {58,206,-74}, {58,46,-50}, 
    {58,115,-50}, {58,116,-50}, {58,117,-50}, {58,118,-50}, 
    {58,47,-100}, {58,48,-90}, {58,50,-74}, {58,119,-74}, {58,120,-74}, 
    {1,0,-30}, {1,53,-30}, {1,54,-30}, {1,55,-30}, {1,56,-30}, 
    {1,57,-30}, {1,58,-30}, {1,20,-10}, {1,80,-10}, {1,81,-10}, 
    {1,82,-10}, {1,83,-10}, {3,0,-35}, {3,53,-35}, {3,54,-35}, 
    {3,55,-35}, {3,56,-35}, {3,57,-35}, {3,58,-35}, {3,21,-40}, 
    {3,22,-40}, {3,24,-40}, {3,84,-40}, {3,85,-40}, {3,194,-20}, 
    {5,0,-90}, {5,53,-90}, {5,54,-90}, {5,55,-90}, {5,56,-90}, 
    {5,57,-90}, {5,58,-90}, {5,26,-25}, {5,88,-25}, {5,89,-25}, 
    {5,90,-25}, {5,91,-25}, {5,92,-25}, {5,93,-25}, {5,142,-92}, 
    {5,30,-25}, {5,95,-25}, {5,96,-25}, {5,97,-25}, {5,98,-25}, 
    {5,40,-25}, {5,107,-25}, {5,108,-25}, {5,109,-25}, {5,110,-25}, 
    {5,111,-25}, {5,112,-25}, {5,194,-110}, {9,0,-30}, {9,53,-30}, 
    {9,54,-30}, {9,55,-30}, {9,56,-30}, {9,57,-30}, {9,58,-30}, 
    {9,26,-15}, {9,88,-15}, {9,89,-15}, {9,90,-15}, {9,91,-15}, 
    {9,92,-15}, {9,93,-15}, {9,30,-15}, {9,95,-15}, {9,96,-15}, 
    {9,97,-15}, {9,98,-15}, {9,40,-15}, {9,107,-15}, {9,108,-15}, 
    {9,109,-15}, {9,110,-15}, {9,111,-15}, {9,112,-15}, {9,194,-20}, 
    {9,46,-15}, {9,115,-15}, {9,116,-15}, {9,117,-15}, {9,118,-15}, 
    {10,14,-30}, {10,72,-30}, {10,73,-30}, {10,74,-30}, {10,75,-30}, 
    {10,76,-30}, {10,77,-30}, {10,30,-25}, {10,95,-25}, {10,96,-25}, 
    {10,97,-25}, {10,98,-25}, {10,40,-25}, {10,107,-25}, {10,108,-25}, 
    {10,109,-25}, {10,110,-25}, {10,111,-25}, {10,112,-25}, 
    {10,46,-15}, {10,115,-15}, {10,116,-15}, {10,117,-15}, 
    {10,118,-15}, {10,50,-45}, {10,119,-45}, {10,120,-45}, {11,19,-92}, 
    {11,21,-92}, {11,22,-92}, {11,24,-92}, {11,84,-92}, {11,85,-92}, 
    {11,204,-20}, {11,206,-110}, {11,50,-55}, {11,119,-55}, 
    {11,120,-55}, {69,19,-92}, {69,21,-92}, {69,22,-92}, {69,24,-92}, 
    {69,84,-92}, {69,85,-92}, {69,204,-20}, {69,206,-110}, {69,50,-55}, 
    {69,119,-55}, {69,120,-55}, {13,0,-20}, {13,53,-20}, {13,54,-20}, 
    {13,55,-20}, {13,56,-20}, {13,57,-20}, {13,58,-20}, {70,0,-20}, 
    {70,53,-20}, {70,54,-20}, {70,55,-20}, {70,56,-20}, {70,57,-20}, 
    {70,58,-20}, {14,0,-40}, {14,53,-40}, {14,54,-40}, {14,55,-40}, 
    {14,56,-40}, {14,57,-40}, {14,58,-40}, {14,19,-40}, {14,21,-50}, 
    {14,22,-50}, {14,23,-40}, {14,24,-50}, {14,84,-50}, {14,85,-50}, 
    {72,0,-40}, {72,53,-40}, {72,54,-40}, {72,55,-40}, {72,56,-40}, 
    {72,57,-40}, {72,58,-40}, {72,19,-40}, {72,21,-50}, {72,22,-50}, 
    {72,23,-40}, {72,24,-50}, {72,84,-50}, {72,85,-50}, {73,0,-40}, 
    {73,53,-40}, {73,54,-40}, {73,55,-40}, {73,56,-40}, {73,57,-40}, 
    {73,58,-40}, {73,19,-40}, {73,21,-50}, {73,22,-50}, {73,23,-40}, 
    {73,24,-50}, {73,84,-50}, {73,85,-50}, {74,0,-40}, {74,53,-40}, 
    {74,54,-40}, {74,55,-40}, {74,56,-40}, {74,57,-40}, {74,58,-40}, 
    {74,19,-40}, {74,21,-50}, {74,22,-50}, {74,23,-40}, {74,24,-50}, 
    {74,84,-50}, {74,85,-50}, {75,0,-40}, {75,53,-40}, {75,54,-40}, 
    {75,55,-40}, {75,56,-40}, {75,57,-40}, {75,58,-40}, {75,19,-40}, 
    {75,21,-50}, {75,22,-50}, {75,23,-40}, {75,24,-50}, {75,84,-50}, 
    {75,85,-50}, {76,0,-40}, {76,53,-40}, {76,54,-40}, {76,55,-40}, 
    {76,56,-40}, {76,57,-40}, {76,58,-40}, {76,19,-40}, {76,21,-50}, 
    {76,22,-50}, {76,23,-40}, {76,24,-50}, {76,84,-50}, {76,85,-50}, 
    {77,0,-40}, {77,53,-40}, {77,54,-40}, {77,55,-40}, {77,56,-40}, 
    {77,57,-40}, {77,58,-40}, {77,19,-40}, {77,21,-50}, {77,22,-50}, 
    {77,23,-40}, {77,24,-50}, {77,84,-50}, {77,85,-50}, {15,0,-74}, 
    {15,53,-74}, {15,54,-74}, {15,55,-74}, {15,56,-74}, {15,57,-74}, 
    {15,58,-74}, {15,26,-10}, {15,88,-10}, {15,89,-10}, {15,90,-10}, 
    {15,91,-10}, {15,92,-10}, {15,93,-10}, {15,142,-92}, {15,30,-20}, 
    {15,95,-20}, {15,96,-20}, {15,97,-20}, {15,98,-20}, {15,40,-20}, 
    {15,107,-20}, {15,108,-20}, {15,109,-20}, {15,110,-20}, 
    {15,111,-20}, {15,112,-20}, {15,194,-110}, {16,20,-10}, 
    {16,80,-10}, {16,81,-10}, {16,82,-10}, {16,83,-10}, {16,194,-20}, 
    {17,14,-30}, {17,72,-30}, {17,73,-30}, {17,74,-30}, {17,75,-30}, 
    {17,76,-30}, {17,77,-30}, {17,19,-40}, {17,20,-30}, {17,80,-30}, 
    {17,81,-30}, {17,82,-30}, {17,83,-30}, {17,21,-55}, {17,22,-35}, 
    {17,24,-35}, {17,84,-35}, {17,85,-35}, {19,0,-90}, {19,53,-90}, 
    {19,54,-90}, {19,55,-90}, {19,56,-90}, {19,57,-90}, {19,58,-90}, 
    {19,14,-18}, {19,72,-18}, {19,73,-18}, {19,74,-18}, {19,75,-18}, 
    {19,76,-18}, {19,77,-18}, {19,26,-92}, {19,88,-92}, {19,89,-52}, 
    {19,90,-52}, {19,91,-52}, {19,92,-92}, {19,93,-52}, {19,141,-74}, 
    {19,142,-74}, {19,30,-92}, {19,95,-92}, {19,96,-92}, {19,97,-52}, 
    {19,98,-52}, {19,174,-92}, {19,34,-18}, {19,100,-18}, {19,40,-92}, 
    {19,107,-92}, {19,108,-92}, {19,109,-92}, {19,110,-92}, 
    {19,111,-92}, {19,112,-92}, {19,194,-90}, {19,43,-74}, 
    {19,212,-74}, {19,46,-92}, {19,115,-92}, {19,116,-92}, 
    {19,117,-92}, {19,118,-92}, {19,48,-74}, {19,50,-34}, {19,119,-34}, 
    {19,120,-34}, {20,0,-60}, {20,53,-60}, {20,54,-60}, {20,55,-60}, 
    {20,56,-60}, {20,57,-60}, {20,58,-60}, {20,142,-50}, {20,194,-50}, 
    {80,0,-60}, {80,53,-60}, {80,54,-60}, {80,55,-60}, {80,56,-60}, 
    {80,57,-60}, {80,58,-60}, {80,142,-50}, {80,194,-50}, {81,0,-60}, 
    {81,53,-60}, {81,54,-60}, {81,55,-60}, {81,56,-60}, {81,57,-60}, 
    {81,58,-60}, {81,142,-50}, {81,194,-50}, {82,0,-60}, {82,53,-60}, 
    {82,54,-60}, {82,55,-60}, {82,56,-60}, {82,57,-60}, {82,58,-60}, 
    {82,142,-50}, {82,194,-50}, {83,0,-60}, {83,53,-60}, {83,54,-60}, 
    {83,55,-60}, {83,56,-60}, {83,57,-60}, {83,58,-60}, {83,142,-50}, 
    {83,194,-50}, {21,0,-135}, {21,53,-135}, {21,54,-135}, 
    {21,55,-135}, {21,56,-135}, {21,57,-135}, {21,58,-135}, {21,6,-30}, 
    {21,14,-45}, {21,72,-45}, {21,73,-45}, {21,74,-45}, {21,75,-45}, 
    {21,76,-45}, {21,77,-45}, {21,26,-92}, {21,88,-92}, {21,89,-92}, 
    {21,90,-92}, {21,91,-92}, {21,92,-92}, {21,93,-92}, {21,141,-92}, 
    {21,142,-129}, {21,30,-100}, {21,95,-100}, {21,96,-100}, 
    {21,97,-100}, {21,98,-100}, {21,174,-74}, {21,34,-37}, 
    {21,100,-37}, {21,101,-37}, {21,102,-37}, {21,103,-37}, 
    {21,40,-100}, {21,107,-100}, {21,108,-100}, {21,109,-100}, 
    {21,110,-100}, {21,111,-100}, {21,112,-100}, {21,194,-145}, 
    {21,212,-92}, {21,46,-92}, {21,115,-92}, {21,116,-92}, 
    {21,117,-92}, {21,118,-92}, {22,0,-120}, {22,53,-120}, 
    {22,54,-120}, {22,55,-120}, {22,56,-120}, {22,57,-120}, 
    {22,58,-120}, {22,14,-10}, {22,72,-10}, {22,73,-10}, {22,74,-10}, 
    {22,75,-10}, {22,76,-10}, {22,77,-10}, {22,26,-65}, {22,88,-65}, 
    {22,89,-65}, {22,90,-65}, {22,91,-65}, {22,92,-65}, {22,93,-65}, 
    {22,141,-55}, {22,142,-92}, {22,30,-65}, {22,95,-65}, {22,96,-65}, 
    {22,97,-65}, {22,98,-65}, {22,174,-37}, {22,34,-18}, {22,100,-18}, 
    {22,40,-75}, {22,107,-75}, {22,108,-75}, {22,109,-75}, 
    {22,110,-75}, {22,111,-75}, {22,112,-75}, {22,194,-92}, 
    {22,212,-55}, {22,46,-50}, {22,115,-50}, {22,116,-50}, 
    {22,117,-50}, {22,118,-50}, {22,50,-60}, {22,119,-60}, 
    {22,120,-60}, {24,0,-110}, {24,53,-110}, {24,54,-110}, 
    {24,55,-110}, {24,56,-110}, {24,57,-110}, {24,58,-110}, 
    {24,14,-35}, {24,72,-35}, {24,73,-35}, {24,74,-35}, {24,75,-35}, 
    {24,76,-35}, {24,77,-35}, {24,26,-85}, {24,88,-85}, {24,89,-85}, 
    {24,90,-85}, {24,91,-85}, {24,92,-85}, {24,93,-85}, {24,141,-92}, 
    {24,142,-92}, {24,30,-111}, {24,95,-111}, {24,96,-111}, 
    {24,97,-71}, {24,98,-71}, {24,174,-92}, {24,34,-37}, {24,100,-37}, 
    {24,40,-111}, {24,107,-111}, {24,108,-111}, {24,109,-111}, 
    {24,110,-111}, {24,111,-111}, {24,112,-111}, {24,194,-92}, 
    {24,212,-92}, {24,46,-92}, {24,115,-92}, {24,116,-92}, 
    {24,117,-92}, {24,118,-92}, {84,0,-110}, {84,53,-110}, 
    {84,54,-110}, {84,55,-110}, {84,56,-110}, {84,57,-110}, 
    {84,58,-110}, {84,14,-35}, {84,72,-35}, {84,73,-35}, {84,74,-35}, 
    {84,75,-35}, {84,76,-35}, {84,77,-35}, {84,26,-85}, {84,88,-85}, 
    {84,89,-85}, {84,90,-85}, {84,91,-85}, {84,92,-85}, {84,93,-85}, 
    {84,141,-92}, {84,142,-92}, {84,30,-111}, {84,95,-111}, 
    {84,96,-111}, {84,97,-71}, {84,98,-71}, {84,174,-92}, {84,34,-37}, 
    {84,100,-37}, {84,40,-111}, {84,107,-111}, {84,108,-111}, 
    {84,109,-111}, {84,110,-111}, {84,111,-111}, {84,112,-111}, 
    {84,194,-92}, {84,212,-92}, {84,46,-92}, {84,115,-92}, 
    {84,116,-92}, {84,117,-92}, {84,118,-92}, {85,0,-110}, 
    {85,53,-110}, {85,54,-110}, {85,55,-110}, {85,56,-110}, 
    {85,57,-110}, {85,58,-110}, {85,14,-35}, {85,72,-35}, {85,73,-35}, 
    {85,74,-35}, {85,75,-35}, {85,76,-35}, {85,77,-35}, {85,26,-85}, 
    {85,88,-85}, {85,89,-85}, {85,90,-85}, {85,91,-85}, {85,92,-85}, 
    {85,93,-85}, {85,141,-92}, {85,142,-92}, {85,30,-111}, 
    {85,95,-111}, {85,96,-111}, {85,97,-71}, {85,98,-71}, {85,174,-92}, 
    {85,34,-37}, {85,100,-37}, {85,40,-111}, {85,107,-111}, 
    {85,108,-111}, {85,109,-111}, {85,110,-111}, {85,111,-111}, 
    {85,112,-111}, {85,194,-92}, {85,212,-92}, {85,46,-92}, 
    {85,115,-92}, {85,116,-92}, {85,117,-92}, {85,118,-92}, 
    {26,47,-25}, {88,47,-25}, {89,47,-25}, {90,47,-25}, {91,47,-25}, 
    {92,47,-25}, {93,47,-25}, {27,27,-10}, {27,194,-40}, {27,46,-20}, 
    {27,115,-20}, {27,116,-20}, {27,117,-20}, {27,118,-20}, 
    {27,47,-15}, {142,204,-45}, {142,206,-55}, {29,48,-15}, 
    {30,47,-15}, {95,47,-15}, {96,47,-15}, {97,47,-15}, {98,47,-15}, 
    {31,142,-15}, {31,152,-35}, {31,34,-25}, {31,40,-25}, {31,107,-25}, 
    {31,108,-25}, {31,109,-25}, {31,110,-25}, {31,111,-25}, 
    {31,112,-25}, {31,194,-15}, {31,204,50}, {31,206,55}, {32,194,-15}, 
    {33,50,-15}, {33,119,-15}, {33,120,-15}, {34,47,-10}, {100,47,-10}, 
    {101,47,-10}, {102,47,-10}, {103,47,-10}, {36,30,-10}, {36,95,-10}, 
    {36,96,-10}, {36,97,-10}, {36,98,-10}, {36,40,-15}, {36,107,-15}, 
    {36,108,-15}, {36,109,-15}, {36,110,-15}, {36,111,-15}, 
    {36,112,-15}, {36,50,-15}, {36,119,-15}, {36,120,-15}, {39,47,-40}, 
    {105,47,-40}, {40,47,-10}, {40,48,-10}, {107,47,-10}, {107,48,-10}, 
    {108,47,-10}, {108,48,-10}, {109,47,-10}, {109,48,-10}, 
    {110,47,-10}, {110,48,-10}, {111,47,-10}, {111,48,-10}, 
    {112,47,-10}, {112,48,-10}, {194,204,-55}, {194,206,-55}, 
    {203,0,-10}, {203,53,-10}, {203,54,-10}, {203,55,-10}, 
    {203,56,-10}, {203,57,-10}, {203,58,-10}, {205,0,-10}, 
    {205,53,-10}, {205,54,-10}, {205,55,-10}, {205,56,-10}, 
    {205,57,-10}, {205,58,-10}, {205,205,-63}, {206,29,-20}, 
    {206,206,-63}, {206,43,-20}, {206,44,-37}, {206,113,-37}, 
    {206,216,-74}, {206,47,-20}, {43,28,-18}, {43,94,-18}, 
    {43,142,-92}, {43,30,-18}, {43,95,-18}, {43,96,-18}, {43,97,-18}, 
    {43,98,-18}, {43,32,-10}, {43,174,-37}, {43,39,-15}, {43,105,-15}, 
    {43,40,-18}, {43,107,-18}, {43,108,-18}, {43,109,-18}, 
    {43,110,-18}, {43,111,-18}, {43,112,-18}, {43,41,-10}, 
    {43,194,-100}, {43,42,-18}, {43,47,-10}, {216,0,-55}, {216,53,-55}, 
    {216,54,-55}, {216,55,-55}, {216,56,-55}, {216,57,-55}, 
    {216,58,-55}, {216,19,-30}, {216,21,-45}, {216,22,-30}, 
    {216,24,-55}, {216,84,-55}, {216,85,-55}, {47,26,-10}, {47,88,-10}, 
    {47,89,-10}, {47,90,-10}, {47,91,-10}, {47,92,-10}, {47,93,-10}, 
    {47,142,-55}, {47,30,-10}, {47,95,-10}, {47,96,-10}, {47,97,-10}, 
    {47,98,-10}, {47,40,-10}, {47,107,-10}, {47,108,-10}, {47,109,-10}, 
    {47,110,-10}, {47,111,-10}, {47,112,-10}, {47,194,-70}, 
    {48,142,-55}, {48,40,-10}, {48,107,-10}, {48,108,-10}, 
    {48,109,-10}, {48,110,-10}, {48,111,-10}, {48,112,-10}, 
    {48,194,-70}, {50,142,-55}, {50,30,-10}, {50,95,-10}, {50,96,-10}, 
    {50,97,-10}, {50,98,-10}, {50,40,-25}, {50,107,-25}, {50,108,-25}, 
    {50,109,-25}, {50,110,-25}, {50,111,-25}, {50,112,-25}, 
    {50,194,-70}, {119,142,-55}, {119,30,-10}, {119,95,-10}, 
    {119,96,-10}, {119,97,-10}, {119,98,-10}, {119,40,-25}, 
    {119,107,-25}, {119,108,-25}, {119,109,-25}, {119,110,-25}, 
    {119,111,-25}, {119,112,-25}, {119,194,-70}, {120,142,-55}, 
    {120,30,-10}, {120,95,-10}, {120,96,-10}, {120,97,-10}, 
    {120,98,-10}, {120,40,-25}, {120,107,-25}, {120,108,-25}, 
    {120,109,-25}, {120,110,-25}, {120,111,-25}, {120,112,-25}, 
    {120,194,-70}, 
    {0xFFFF,0xFFFF,0}
};
static const kern_pair times_bolditalic_kerns[] = {
    {0,2,-65}, {0,59,-65}, {0,6,-60}, {0,14,-50}, {0,72,-50}, 
    {0,73,-50}, {0,74,-50}, {0,75,-50}, {0,76,-50}, {0,77,-50}, 
    {0,16,-55}, {0,19,-55}, {0,20,-50}, {0,80,-50}, {0,81,-50}, 
    {0,82,-50}, {0,83,-50}, {0,21,-95}, {0,22,-100}, {0,24,-70}, 
    {0,84,-70}, {0,85,-70}, {0,206,-74}, {0,46,-30}, {0,115,-30}, 
    {0,116,-30}, {0,117,-30}, {0,118,-30}, {0,47,-74}, {0,48,-74}, 
    {0,50,-74}, {0,119,-74}, {0,120,-74}, {53,2,-65}, {53,59,-65}, 
    {53,6,-60}, {53,14,-50}, {53,72,-50}, {53,73,-50}, {53,74,-50}, 
    {53,75,-50}, {53,76,-50}, {53,77,-50}, {53,16,-55}, {53,19,-55}, 
    {53,20,-50}, {53,80,-50}, {53,81,-50}, {53,82,-50}, {53,83,-50}, 
    {53,21,-95}, {53,22,-100}, {53,24,-70}, {53,84,-70}, {53,85,-70}, 
    {53,206,-74}, {53,46,-30}, {53,115,-30}, {53,116,-30}, 
    {53,117,-30}, {53,118,-30}, {53,47,-74}, {53,48,-74}, {53,50,-74}, 
    {53,119,-74}, {53,120,-74}, {54,2,-65}, {54,59,-65}, {54,6,-60}, 
    {54,14,-50}, {54,72,-50}, {54,73,-50}, {54,74,-50}, {54,75,-50}, 
    {54,76,-50}, {54,77,-50}, {54,16,-55}, {54,19,-55}, {54,20,-50}, 
    {54,80,-50}, {54,81,-50}, {54,82,-50}, {54,83,-50}, {54,21,-95}, 
    {54,22,-100}, {54,24,-70}, {54,84,-70}, {54,85,-70}, {54,206,-74}, 
    {54,46,-30}, {54,115,-30}, {54,116,-30}, {54,117,-30}, 
    {54,118,-30}, {54,47,-74}, {54,48,-74}, {54,50,-74}, {54,119,-74}, 
    {54,120,-74}, {55,2,-65}, {55,59,-65}, {55,6,-60}, {55,14,-50}, 
    {55,72,-50}, {55,73,-50}, {55,74,-50}, {55,75,-50}, {55,76,-50}, 
    {55,77,-50}, {55,16,-55}, {55,19,-55}, {55,20,-50}, {55,80,-50}, 
    {55,81,-50}, {55,82,-50}, {55,83,-50}, {55,21,-95}, {55,22,-100}, 
    {55,24,-70}, {55,84,-70}, {55,85,-70}, {55,206,-74}, {55,46,-30}, 
    {55,115,-30}, {55,116,-30}, {55,117,-30}, {55,118,-30}, 
    {55,47,-74}, {55,48,-74}, {55,50,-74}, {55,119,-74}, {55,120,-74}, 
    {56,2,-65}, {56,59,-65}, {56,6,-60}, {56,14,-50}, {56,72,-50}, 
    {56,73,-50}, {56,74,-50}, {56,75,-50}, {56,76,-50}, {56,77,-50}, 
    {56,16,-55}, {56,19,-55}, {56,20,-50}, {56,80,-50}, {56,81,-50}, 
    {56,82,-50}, {56,83,-50}, {56,21,-95}, {56,22,-100}, {56,24,-70}, 
    {56,84,-70}, {56,85,-70}, {56,206,-74}, {56,46,-30}, {56,115,-30}, 
    {56,116,-30}, {56,117,-30}, {56,118,-30}, {56,47,-74}, {56,48,-74}, 
    {56,50,-74}, {56,119,-74}, {56,120,-74}, {57,2,-65}, {57,59,-65}, 
    {57,6,-60}, {57,14,-50}, {57,72,-50}, {57,73,-50}, {57,74,-50}, 
    {57,75,-50}, {57,76,-50}, {57,77,-50}, {57,16,-55}, {57,19,-55}, 
    {57,20,-50}, {57,80,-50}, {57,81,-50}, {57,82,-50}, {57,83,-50}, 
    {57,21,-95}, {57,22,-100}, {57,24,-70}, {57,84,-70}, {57,85,-70}, 
    {57,206,-74}, {57,46,-30}, {57,115,-30}, {57,116,-30}, 
    {57,117,-30}, {57,118,-30}, {57,47,-74}, {57,48,-74}, {57,50,-74}, 
    {57,119,-74}, {57,120,-74}, {58,2,-65}, {58,59,-65}, {58,6,-60}, 
    {58,14,-50}, {58,72,-50}, {58,73,-50}, {58,74,-50}, {58,75,-50}, 
    {58,76,-50}, {58,77,-50}, {58,16,-55}, {58,19,-55}, {58,20,-50}, 
    {58,80,-50}, {58,81,-50}, {58,82,-50}, {58,83,-50}, {58,21,-95}, 
    {58,22,-100}, {58,24,-70}, {58,84,-70}, {58,85,-70}, {58,206,-74}, 
    {58,46,-30}, {58,115,-30}, {58,116,-30}, {58,117,-30}, 
    {58,118,-30}, {58,47,-74}, {58,48,-74}, {58,50,-74}, {58,119,-74}, 
    {58,120,-74}, {1,0,-25}, {1,53,-25}, {1,54,-25}, {1,55,-25}, 
    {1,56,-25}, {1,57,-25}, {1,58,-25}, {1,20,-10}, {1,80,-10}, 
    {1,81,-10}, {1,82,-10}, {1,83,-10}, {3,0,-25}, {3,53,-25}, 
    {3,54,-25}, {3,55,-25}, {3,56,-25}, {3,57,-25}, {3,58,-25}, 
    {3,21,-50}, {3,22,-40}, {3,24,-50}, {3,84,-50}, {3,85,-50}, 
    {5,0,-100}, {5,53,-100}, {5,54,-100}, {5,55,-100}, {5,56,-100}, 
    {5,57,-100}, {5,58,-100}, {5,26,-95}, {5,88,-95}, {5,89,-95}, 
    {5,90,-95}, {5,91,-95}, {5,92,-95}, {5,93,-95}, {5,142,-129}, 
    {5,30,-100}, {5,95,-100}, {5,96,-100}, {5,97,-100}, {5,98,-100}, 
    {5,34,-40}, {5,100,-40}, {5,101,-40}, {5,102,-40}, {5,103,-40}, 
    {5,40,-70}, {5,107,-70}, {5,108,-70}, {5,109,-70}, {5,110,-70}, 
    {5,111,-70}, {5,112,-70}, {5,194,-129}, {5,43,-50}, {9,0,-25}, 
    {9,53,-25}, {9,54,-25}, {9,55,-25}, {9,56,-25}, {9,57,-25}, 
    {9,58,-25}, {9,26,-40}, {9,88,-40}, {9,89,-40}, {9,90,-40}, 
    {9,91,-40}, {9,92,-40}, {9,93,-40}, {9,142,-10}, {9,30,-40}, 
    {9,95,-40}, {9,96,-40}, {9,97,-40}, {9,98,-40}, {9,40,-40}, 
    {9,107,-40}, {9,108,-40}, {9,109,-40}, {9,110,-40}, {9,111,-40}, 
    {9,112,-40}, {9,194,-10}, {9,46,-40}, {9,115,-40}, {9,116,-40}, 
    {9,117,-40}, {9,118,-40}, {10,14,-30}, {10,72,-30}, {10,73,-30}, 
    {10,74,-30}, {10,75,-30}, {10,76,-30}, {10,77,-30}, {10,30,-25}, 
    {10,95,-25}, {10,96,-25}, {10,97,-25}, {10,98,-25}, {10,40,-25}, 
    {10,107,-25}, {10,108,-25}, {10,109,-25}, {10,110,-25}, 
    {10,111,-25}, {10,112,-25}, {10,46,-20}, {10,115,-20}, 
    {10,116,-20}, {10,117,-20}, {10,118,-20}, {10,50,-20}, 
    {10,119,-20}, {10,120,-20}, {11,19,-18}, {11,21,-37}, {11,22,-37}, 
    {11,24,-37}, {11,84,-37}, {11,85,-37}, {11,206,-55}, {11,50,-37}, 
    {11,119,-37}, {11,120,-37}, {69,19,-18}, {69,21,-37}, {69,22,-37}, 
    {69,24,-37}, {69,84,-37}, {69,85,-37}, {69,206,-55}, {69,50,-37}, 
    {69,119,-37}, {69,120,-37}, {13,0,-30}, {13,53,-30}, {13,54,-30}, 
    {13,55,-30}, {13,56,-30}, {13,57,-30}, {13,58,-30}, {70,0,-30}, 
    {70,53,-30}, {70,54,-30}, {70,55,-30}, {70,56,-30}, {70,57,-30}, 
    {70,58,-30}, {14,0,-40}, {14,53,-40}, {14,54,-40}, {14,55,-40}, 
    {14,56,-40}, {14,57,-40}, {14,58,-40}, {14,19,-40}, {14,21,-50}, 
    {14,22,-50}, {14,23,-40}, {14,24,-50}, {14,84,-50}, {14,85,-50}, 
    {72,0,-40}, {72,53,-40}, {72,54,-40}, {72,55,-40}, {72,56,-40}, 
    {72,57,-40}, {72,58,-40}, {72,19,-40}, {72,21,-50}, {72,22,-50}, 
    {72,23,-40}, {72,24,-50}, {72,84,-50}, {72,85,-50}, {73,0,-40}, 
    {73,53,-40}, {73,54,-40}, {73,55,-40}, {73,56,-40}, {73,57,-40}, 
    {73,58,-40}, {73,19,-40}, {73,21,-50}, {73,22,-50}, {73,23,-40}, 
    {73,24,-50}, {73,84,-50}, {73,85,-50}, {74,0,-40}, {74,53,-40}, 
    {74,54,-40}, {74,55,-40}, {74,56,-40}, {74,57,-40}, {74,58,-40}, 
    {74,19,-40}, {74,21,-50}, {74,22,-50}, {74,23,-40}, {74,24,-50}, 
    {74,84,-50}, {74,85,-50}, {75,0,-40}, {75,53,-40}, {75,54,-40}, 
    {75,55,-40}, {75,56,-40}, {75,57,-40}, {75,58,-40}, {75,19,-40}, 
    {75,21,-50}, {75,22,-50}, {75,23,-40}, {75,24,-50}, {75,84,-50}, 
    {75,85,-50}, {76,0,-40}, {76,53,-40}, {76,54,-40}, {76,55,-40}, 
    {76,56,-40}, {76,57,-40}, {76,58,-40}, {76,19,-40}, {76,21,-50}, 
    {76,22,-50}, {76,23,-40}, {76,24,-50}, {76,84,-50}, {76,85,-50}, 
    {77,0,-40}, {77,53,-40}, {77,54,-40}, {77,55,-40}, {77,56,-40}, 
    {77,57,-40}, {77,58,-40}, {77,19,-40}, {77,21,-50}, {77,22,-50}, 
    {77,23,-40}, {77,24,-50}, {77,84,-50}, {77,85,-50}, {15,0,-85}, 
    {15,53,-85}, {15,54,-85}, {15,55,-85}, {15,56,-85}, {15,57,-85}, 
    {15,58,-85}, {15,26,-40}, {15,88,-40}, {15,89,-40}, {15,90,-40}, 
    {15,91,-40}, {15,92,-40}, {15,93,-40}, {15,142,-129}, {15,30,-50}, 
    {15,95,-50}, {15,96,-50}, {15,97,-50}, {15,98,-50}, {15,40,-55}, 
    {15,107,-55}, {15,108,-55}, {15,109,-55}, {15,110,-55}, 
    {15,111,-55}, {15,112,-55}, {15,194,-129}, {16,20,-10}, 
    {16,80,-10}, {16,81,-10}, {16,82,-10}, {16,83,-10}, {17,14,-40}, 
    {17,72,-40}, {17,73,-40}, {17,74,-40}, {17,75,-40}, {17,76,-40}, 
    {17,77,-40}, {17,19,-30}, {17,20,-40}, {17,80,-40}, {17,81,-40}, 
    {17,82,-40}, {17,83,-40}, {17,21,-18}, {17,22,-18}, {17,24,-18}, 
    {17,84,-18}, {17,85,-18}, {19,0,-55}, {19,53,-55}, {19,54,-55}, 
    {19,55,-55}, {19,56,-55}, {19,57,-55}, {19,58,-55}, {19,14,-18}, 
    {19,72,-18}, {19,73,-18}, {19,74,-18}, {19,75,-18}, {19,76,-18}, 
    {19,77,-18}, {19,26,-92}, {19,88,-92}, {19,89,-92}, {19,90,-92}, 
    {19,91,-92}, {19,92,-92}, {19,93,-92}, {19,141,-74}, {19,142,-92}, 
    {19,30,-92}, {19,95,-92}, {19,96,-92}, {19,97,-52}, {19,98,-52}, 
    {19,174,-92}, {19,34,-37}, {19,100,-37}, {19,40,-95}, {19,107,-95}, 
    {19,108,-95}, {19,109,-95}, {19,110,-95}, {19,111,-95}, 
    {19,112,-95}, {19,194,-92}, {19,43,-37}, {19,212,-74}, {19,46,-37}, 
    {19,115,-37}, {19,116,-37}, {19,117,-37}, {19,118,-37}, 
    {19,48,-37}, {19,50,-37}, {19,119,-37}, {19,120,-37}, {20,0,-45}, 
    {20,53,-45}, {20,54,-45}, {20,55,-45}, {20,56,-45}, {20,57,-45}, 
    {20,58,-45}, {80,0,-45}, {80,53,-45}, {80,54,-45}, {80,55,-45}, 
    {80,56,-45}, {80,57,-45}, {80,58,-45}, {81,0,-45}, {81,53,-45}, 
    {81,54,-45}, {81,55,-45}, {81,56,-45}, {81,57,-45}, {81,58,-45}, 
    {82,0,-45}, {82,53,-45}, {82,54,-45}, {82,55,-45}, {82,56,-45}, 
    {82,57,-45}, {82,58,-45}, {83,0,-45}, {83,53,-45}, {83,54,-45}, 
    {83,55,-45}, {83,56,-45}, {83,57,-45}, {83,58,-45}, {21,0,-85}, 
    {21,53,-85}, {21,54,-85}, {21,55,-85}, {21,56,-85}, {21,57,-85}, 
    {21,58,-85}, {21,6,-10}, {21,14,-30}, {21,72,-30}, {21,73,-30}, 
    {21,74,-30}, {21,75,-30}, {21,76,-30}, {21,77,-30}, {21,26,-111}, 
    {21,88,-111}, {21,89,-111}, {21,90,-111}, {21,91,-111}, 
    {21,92,-111}, {21,93,-111}, {21,141,-74}, {21,142,-129}, 
    {21,30,-111}, {21,95,-111}, {21,96,-111}, {21,97,-71}, {21,98,-71}, 
    {21,174,-70}, {21,34,-55}, {21,100,-55}, {21,40,-111}, 
    {21,107,-111}, {21,108,-111}, {21,109,-111}, {21,110,-111}, 
    {21,111,-111}, {21,112,-111}, {21,194,-129}, {21,212,-74}, 
    {21,46,-55}, {21,115,-55}, {21,116,-55}, {21,117,-55}, 
    {21,118,-55}, {22,0,-74}, {22,53,-74}, {22,54,-74}, {22,55,-74}, 
    {22,56,-74}, {22,57,-74}, {22,58,-74}, {22,14,-15}, {22,72,-15}, 
    {22,73,-15}, {22,74,-15}, {22,75,-15}, {22,76,-15}, {22,77,-15}, 
    {22,26,-85}, {22,88,-85}, {22,89,-85}, {22,90,-85}, {22,91,-85}, 
    {22,92,-85}, {22,93,-85}, {22,141,-55}, {22,142,-74}, {22,30,-90}, 
    {22,95,-90}, {22,96,-90}, {22,97,-50}, {22,98,-50}, {22,174,-50}, 
    {22,34,-37}, {22,100,-37}, {22,40,-80}, {22,107,-80}, {22,108,-80}, 
    {22,109,-80}, {22,110,-80}, {22,111,-80}, {22,112,-80}, 
    {22,194,-74}, {22,212,-55}, {22,46,-55}, {22,115,-55}, 
    {22,116,-55}, {22,117,-55}, {22,118,-55}, {22,50,-55}, 
    {22,119,-55}, {22,120,-55}, {24,0,-74}, {24,53,-74}, {24,54,-74}, 
    {24,55,-74}, {24,56,-74}, {24,57,-74}, {24,58,-74}, {24,14,-25}, 
    {24,72,-25}, {24,73,-25}, {24,74,-25}, {24,75,-25}, {24,76,-25}, 
    {24,77,-25}, {24,26,-92}, {24,88,-92}, {24,89,-92}, {24,90,-92}, 
    {24,91,-92}, {24,92,-92}, {24,93,-92}, {24,141,-92}, {24,142,-92}, 
    {24,30,-111}, {24,95,-111}, {24,96,-71}, {24,97,-71}, {24,98,-71}, 
    {24,174,-92}, {24,34,-55}, {24,100,-55}, {24,40,-111}, 
    {24,107,-111}, {24,108,-111}, {24,109,-111}, {24,110,-111}, 
    {24,111,-111}, {24,112,-111}, {24,194,-74}, {24,212,-92}, 
    {24,46,-92}, {24,115,-92}, {24,116,-92}, {24,117,-92}, 
    {24,118,-92}, {84,0,-74}, {84,53,-74}, {84,54,-74}, {84,55,-74}, 
    {84,56,-74}, {84,57,-74}, {84,58,-74}, {84,14,-25}, {84,72,-25}, 
    {84,73,-25}, {84,74,-25}, {84,75,-25}, {84,76,-25}, {84,77,-25}, 
    {84,26,-92}, {84,88,-92}, {84,89,-92}, {84,90,-92}, {84,91,-92}, 
    {84,92,-92}, {84,93,-92}, {84,141,-92}, {84,142,-92}, {84,30,-111}, 
    {84,95,-111}, {84,96,-71}, {84,97,-71}, {84,98,-71}, {84,174,-92}, 
    {84,34,-55}, {84,100,-55}, {84,40,-111}, {84,107,-111}, 
    {84,108,-111}, {84,109,-111}, {84,110,-111}, {84,111,-111}, 
    {84,112,-111}, {84,194,-74}, {84,212,-92}, {84,46,-92}, 
    {84,115,-92}, {84,116,-92}, {84,117,-92}, {84,118,-92}, {85,0,-74}, 
    {85,53,-74}, {85,54,-74}, {85,55,-74}, {85,56,-74}, {85,57,-74}, 
    {85,58,-74}, {85,14,-25}, {85,72,-25}, {85,73,-25}, {85,74,-25}, 
    {85,75,-25}, {85,76,-25}, {85,77,-25}, {85,26,-92}, {85,88,-92}, 
    {85,89,-92}, {85,90,-92}, {85,91,-92}, {85,92,-92}, {85,93,-92}, 
    {85,141,-92}, {85,142,-92}, {85,30,-111}, {85,95,-111}, 
    {85,96,-71}, {85,97,-71}, {85,98,-71}, {85,174,-92}, {85,34,-55}, 
    {85,100,-55}, {85,40,-111}, {85,107,-111}, {85,108,-111}, 
    {85,109,-111}, {85,110,-111}, {85,111,-111}, {85,112,-111}, 
    {85,194,-74}, {85,212,-92}, {85,46,-92}, {85,115,-92}, 
    {85,116,-92}, {85,117,-92}, {85,118,-92}, {27,27,-10}, 
    {27,194,-40}, {27,46,-20}, {27,115,-20}, {27,116,-20}, 
    {27,117,-20}, {27,118,-20}, {28,33,-10}, {28,36,-10}, {94,33,-10}, 
    {94,36,-10}, {142,204,-95}, {142,206,-95}, {30,27,-10}, 
    {95,27,-10}, {96,27,-10}, {97,27,-10}, {98,27,-10}, {31,142,-10}, 
    {31,152,-30}, {31,30,-10}, {31,95,-10}, {31,31,-18}, {31,40,-10}, 
    {31,107,-10}, {31,108,-10}, {31,110,-10}, {31,111,-10}, 
    {31,112,-10}, {31,194,-10}, {31,206,55}, {36,30,-30}, {36,95,-30}, 
    {36,96,-30}, {36,97,-30}, {36,98,-30}, {36,40,-10}, {36,107,-10}, 
    {36,108,-10}, {36,109,-10}, {36,110,-10}, {36,111,-10}, 
    {36,112,-10}, {39,47,-40}, {105,47,-40}, {40,47,-15}, {40,48,-25}, 
    {40,49,-10}, {40,50,-10}, {40,119,-10}, {40,120,-10}, {107,47,-15}, 
    {107,48,-25}, {107,49,-10}, {107,50,-10}, {107,119,-10}, 
    {107,120,-10}, {108,47,-15}, {108,48,-25}, {108,49,-10}, 
    {108,50,-10}, {108,119,-10}, {108,120,-10}, {109,47,-15}, 
    {109,48,-25}, {109,49,-10}, {109,50,-10}, {109,119,-10}, 
    {109,120,-10}, {110,47,-15}, {110,48,-25}, {110,49,-10}, 
    {110,50,-10}, {110,119,-10}, {110,120,-10}, {111,47,-15}, 
    {111,48,-25}, {111,49,-10}, {111,50,-10}, {111,119,-10}, 
    {111,120,-10}, {112,47,-15}, {112,48,-25}, {112,49,-10}, 
    {112,50,-10}, {112,119,-10}, {112,120,-10}, {194,204,-95}, 
    {194,206,-95}, {205,205,-74}, {206,29,-15}, {206,206,-74}, 
    {206,43,-15}, {206,44,-74}, {206,113,-74}, {206,216,-74}, 
    {206,45,-37}, {206,47,-15}, {43,142,-65}, {43,194,-65}, 
    {216,0,-37}, {216,53,-37}, {216,54,-37}, {216,55,-37}, 
    {216,56,-37}, {216,57,-37}, {216,58,-37}, {216,21,-70}, 
    {216,22,-70}, {216,24,-70}, {216,84,-70}, {216,85,-70}, 
    {47,142,-37}, {47,30,-15}, {47,95,-15}, {47,96,-15}, {47,97,-15}, 
    {47,98,-15}, {47,40,-15}, {47,107,-15}, {47,108,-15}, {47,109,-15}, 
    {47,110,-15}, {47,111,-15}, {47,112,-15}, {47,194,-37}, 
    {48,26,-10}, {48,88,-10}, {48,89,-10}, {48,90,-10}, {48,91,-10}, 
    {48,92,-10}, {48,93,-10}, {48,142,-37}, {48,30,-10}, {48,95,-10}, 
    {48,96,-10}, {48,97,-10}, {48,98,-10}, {48,40,-15}, {48,107,-15}, 
    {48,108,-15}, {48,109,-15}, {48,110,-15}, {48,111,-15}, 
    {48,112,-15}, {48,194,-37}, {49,30,-10}, {49,95,-10}, {49,96,-10}, 
    {49,97,-10}, {49,98,-10}, {50,142,-37}, {50,194,-37}, 
    {119,142,-37}, {119,194,-37}, {120,142,-37}, {120,194,-37}, 
    {0xFFFF,0xFFFF,0}
};
static const kern_pair helvetica_kerns[] = {
    {0,2,-30}, {0,59,-30}, {0,6,-30}, {0,14,-30}, {0,72,-30}, 
    {0,73,-30}, {0,74,-30}, {0,75,-30}, {0,76,-30}, {0,77,-30}, 
    {0,16,-30}, {0,19,-120}, {0,20,-50}, {0,80,-50}, {0,81,-50}, 
    {0,82,-50}, {0,83,-50}, {0,21,-70}, {0,22,-50}, {0,24,-100}, 
    {0,84,-100}, {0,85,-100}, {0,46,-30}, {0,115,-30}, {0,116,-30}, 
    {0,117,-30}, {0,118,-30}, {0,47,-40}, {0,48,-40}, {0,50,-40}, 
    {0,119,-40}, {0,120,-40}, {53,2,-30}, {53,59,-30}, {53,6,-30}, 
    {53,14,-30}, {53,72,-30}, {53,73,-30}, {53,74,-30}, {53,75,-30}, 
    {53,76,-30}, {53,77,-30}, {53,16,-30}, {53,19,-120}, {53,20,-50}, 
    {53,80,-50}, {53,81,-50}, {53,82,-50}, {53,83,-50}, {53,21,-70}, 
    {53,22,-50}, {53,24,-100}, {53,84,-100}, {53,85,-100}, {53,46,-30}, 
    {53,115,-30}, {53,116,-30}, {53,117,-30}, {53,118,-30}, 
    {53,47,-40}, {53,48,-40}, {53,50,-40}, {53,119,-40}, {53,120,-40}, 
    {54,2,-30}, {54,59,-30}, {54,6,-30}, {54,14,-30}, {54,72,-30}, 
    {54,73,-30}, {54,74,-30}, {54,75,-30}, {54,76,-30}, {54,77,-30}, 
    {54,16,-30}, {54,19,-120}, {54,20,-50}, {54,80,-50}, {54,81,-50}, 
    {54,82,-50}, {54,83,-50}, {54,21,-70}, {54,22,-50}, {54,24,-100}, 
    {54,84,-100}, {54,85,-100}, {54,46,-30}, {54,115,-30}, 
    {54,116,-30}, {54,117,-30}, {54,118,-30}, {54,47,-40}, {54,48,-40}, 
    {54,50,-40}, {54,119,-40}, {54,120,-40}, {55,2,-30}, {55,59,-30}, 
    {55,6,-30}, {55,14,-30}, {55,72,-30}, {55,73,-30}, {55,74,-30}, 
    {55,75,-30}, {55,76,-30}, {55,77,-30}, {55,16,-30}, {55,19,-120}, 
    {55,20,-50}, {55,80,-50}, {55,81,-50}, {55,82,-50}, {55,83,-50}, 
    {55,21,-70}, {55,22,-50}, {55,24,-100}, {55,84,-100}, {55,85,-100}, 
    {55,46,-30}, {55,115,-30}, {55,116,-30}, {55,117,-30}, 
    {55,118,-30}, {55,47,-40}, {55,48,-40}, {55,50,-40}, {55,119,-40}, 
    {55,120,-40}, {56,2,-30}, {56,59,-30}, {56,6,-30}, {56,14,-30}, 
    {56,72,-30}, {56,73,-30}, {56,74,-30}, {56,75,-30}, {56,76,-30}, 
    {56,77,-30}, {56,16,-30}, {56,19,-120}, {56,20,-50}, {56,80,-50}, 
    {56,81,-50}, {56,82,-50}, {56,83,-50}, {56,21,-70}, {56,22,-50}, 
    {56,24,-100}, {56,84,-100}, {56,85,-100}, {56,46,-30}, 
    {56,115,-30}, {56,116,-30}, {56,117,-30}, {56,118,-30}, 
    {56,47,-40}, {56,48,-40}, {56,50,-40}, {56,119,-40}, {56,120,-40}, 
    {57,2,-30}, {57,59,-30}, {57,6,-30}, {57,14,-30}, {57,72,-30}, 
    {57,73,-30}, {57,74,-30}, {57,75,-30}, {57,76,-30}, {57,77,-30}, 
    {57,16,-30}, {57,19,-120}, {57,20,-50}, {57,80,-50}, {57,81,-50}, 
    {57,82,-50}, {57,83,-50}, {57,21,-70}, {57,22,-50}, {57,24,-100}, 
    {57,84,-100}, {57,85,-100}, {57,46,-30}, {57,115,-30}, 
    {57,116,-30}, {57,117,-30}, {57,118,-30}, {57,47,-40}, {57,48,-40}, 
    {57,50,-40}, {57,119,-40}, {57,120,-40}, {58,2,-30}, {58,59,-30}, 
    {58,6,-30}, {58,14,-30}, {58,72,-30}, {58,73,-30}, {58,74,-30}, 
    {58,75,-30}, {58,76,-30}, {58,77,-30}, {58,16,-30}, {58,19,-120}, 
    {58,20,-50}, {58,80,-50}, {58,81,-50}, {58,82,-50}, {58,83,-50}, 
    {58,21,-70}, {58,22,-50}, {58,24,-100}, {58,84,-100}, {58,85,-100}, 
    {58,46,-30}, {58,115,-30}, {58,116,-30}, {58,117,-30}, 
    {58,118,-30}, {58,47,-40}, {58,48,-40}, {58,50,-40}, {58,119,-40}, 
    {58,120,-40}, {1,20,-10}, {1,80,-10}, {1,81,-10}, {1,82,-10}, 
    {1,83,-10}, {1,142,-20}, {1,194,-20}, {2,142,-30}, {2,194,-30}, 
    {59,142,-30}, {59,194,-30}, {3,0,-40}, {3,53,-40}, {3,54,-40}, 
    {3,55,-40}, {3,56,-40}, {3,57,-40}, {3,58,-40}, {3,21,-70}, 
    {3,22,-40}, {3,24,-90}, {3,84,-90}, {3,85,-90}, {3,142,-70}, 
    {3,194,-70}, {5,0,-80}, {5,53,-80}, {5,54,-80}, {5,55,-80}, 
    {5,56,-80}, {5,57,-80}, {5,58,-80}, {5,26,-50}, {5,88,-50}, 
    {5,89,-50}, {5,90,-50}, {5,91,-50}, {5,92,-50}, {5,93,-50}, 
    {5,142,-150}, {5,30,-30}, {5,95,-30}, {5,96,-30}, {5,97,-30}, 
    {5,98,-30}, {5,40,-30}, {5,107,-30}, {5,108,-30}, {5,109,-30}, 
    {5,110,-30}, {5,111,-30}, {5,112,-30}, {5,194,-150}, {5,43,-45}, 
    {9,0,-20}, {9,53,-20}, {9,54,-20}, {9,55,-20}, {9,56,-20}, 
    {9,57,-20}, {9,58,-20}, {9,26,-20}, {9,88,-20}, {9,89,-20}, 
    {9,90,-20}, {9,91,-20}, {9,92,-20}, {9,93,-20}, {9,142,-30}, 
    {9,194,-30}, {9,46,-20}, {9,115,-20}, {9,116,-20}, {9,117,-20}, 
    {9,118,-20}, {10,14,-50}, {10,72,-50}, {10,73,-50}, {10,74,-50}, 
    {10,75,-50}, {10,76,-50}, {10,77,-50}, {10,30,-40}, {10,95,-40}, 
    {10,96,-40}, {10,97,-40}, {10,98,-40}, {10,40,-40}, {10,107,-40}, 
    {10,108,-40}, {10,109,-40}, {10,110,-40}, {10,111,-40}, 
    {10,112,-40}, {10,46,-30}, {10,115,-30}, {10,116,-30}, 
    {10,117,-30}, {10,118,-30}, {10,50,-50}, {10,119,-50}, 
    {10,120,-50}, {11,19,-110}, {11,21,-110}, {11,22,-70}, 
    {11,24,-140}, {11,84,-140}, {11,85,-140}, {11,204,-140}, 
    {11,206,-160}, {11,50,-30}, {11,119,-30}, {11,120,-30}, 
    {69,19,-110}, {69,21,-110}, {69,22,-70}, {69,24,-140}, 
    {69,84,-140}, {69,85,-140}, {69,204,-140}, {69,206,-160}, 
    {69,50,-30}, {69,119,-30}, {69,120,-30}, {14,0,-20}, {14,53,-20}, 
    {14,54,-20}, {14,55,-20}, {14,56,-20}, {14,57,-20}, {14,58,-20}, 
    {14,19,-40}, {14,21,-50}, {14,22,-30}, {14,23,-60}, {14,24,-70}, 
    {14,84,-70}, {14,85,-70}, {14,142,-40}, {14,194,-40}, {72,0,-20}, 
    {72,53,-20}, {72,54,-20}, {72,55,-20}, {72,56,-20}, {72,57,-20}, 
    {72,58,-20}, {72,19,-40}, {72,21,-50}, {72,22,-30}, {72,23,-60}, 
    {72,24,-70}, {72,84,-70}, {72,85,-70}, {72,142,-40}, {72,194,-40}, 
    {73,0,-20}, {73,53,-20}, {73,54,-20}, {73,55,-20}, {73,56,-20}, 
    {73,57,-20}, {73,58,-20}, {73,19,-40}, {73,21,-50}, {73,22,-30}, 
    {73,23,-60}, {73,24,-70}, {73,84,-70}, {73,85,-70}, {73,142,-40}, 
    {73,194,-40}, {74,0,-20}, {74,53,-20}, {74,54,-20}, {74,55,-20}, 
    {74,56,-20}, {74,57,-20}, {74,58,-20}, {74,19,-40}, {74,21,-50}, 
    {74,22,-30}, {74,23,-60}, {74,24,-70}, {74,84,-70}, {74,85,-70}, 
    {74,142,-40}, {74,194,-40}, {75,0,-20}, {75,53,-20}, {75,54,-20}, 
    {75,55,-20}, {75,56,-20}, {75,57,-20}, {75,58,-20}, {75,19,-40}, 
    {75,21,-50}, {75,22,-30}, {75,23,-60}, {75,24,-70}, {75,84,-70}, 
    {75,85,-70}, {75,142,-40}, {75,194,-40}, {76,0,-20}, {76,53,-20}, 
    {76,54,-20}, {76,55,-20}, {76,56,-20}, {76,57,-20}, {76,58,-20}, 
    {76,19,-40}, {76,21,-50}, {76,22,-30}, {76,23,-60}, {76,24,-70}, 
    {76,84,-70}, {76,85,-70}, {76,142,-40}, {76,194,-40}, {77,0,-20}, 
    {77,53,-20}, {77,54,-20}, {77,55,-20}, {77,56,-20}, {77,57,-20}, 
    {77,58,-20}, {77,19,-40}, {77,21,-50}, {77,22,-30}, {77,23,-60}, 
    {77,24,-70}, {77,84,-70}, {77,85,-70}, {77,142,-40}, {77,194,-40}, 
    {15,0,-120}, {15,53,-120}, {15,54,-120}, {15,55,-120}, 
    {15,56,-120}, {15,57,-120}, {15,58,-120}, {15,26,-40}, {15,88,-40}, 
    {15,89,-40}, {15,90,-40}, {15,91,-40}, {15,92,-40}, {15,93,-40}, 
    {15,142,-180}, {15,30,-50}, {15,95,-50}, {15,96,-50}, {15,97,-50}, 
    {15,98,-50}, {15,40,-50}, {15,107,-50}, {15,108,-50}, {15,109,-50}, 
    {15,110,-50}, {15,111,-50}, {15,112,-50}, {15,194,-180}, 
    {16,20,-10}, {16,80,-10}, {16,81,-10}, {16,82,-10}, {16,83,-10}, 
    {17,14,-20}, {17,72,-20}, {17,73,-20}, {17,74,-20}, {17,75,-20}, 
    {17,76,-20}, {17,77,-20}, {17,19,-30}, {17,20,-40}, {17,80,-40}, 
    {17,81,-40}, {17,82,-40}, {17,83,-40}, {17,21,-50}, {17,22,-30}, 
    {17,24,-50}, {17,84,-50}, {17,85,-50}, {18,142,-20}, {18,194,-20}, 
    {78,142,-20}, {78,194,-20}, {19,0,-120}, {19,53,-120}, 
    {19,54,-120}, {19,55,-120}, {19,56,-120}, {19,57,-120}, 
    {19,58,-120}, {19,14,-40}, {19,72,-40}, {19,73,-40}, {19,74,-40}, 
    {19,75,-40}, {19,76,-40}, {19,77,-40}, {19,26,-120}, {19,88,-120}, 
    {19,89,-120}, {19,90,-120}, {19,91,-120}, {19,92,-120}, 
    {19,93,-60}, {19,141,-20}, {19,142,-120}, {19,30,-120}, 
    {19,95,-120}, {19,96,-120}, {19,97,-120}, {19,98,-60}, 
    {19,174,-140}, {19,40,-120}, {19,107,-120}, {19,108,-120}, 
    {19,109,-120}, {19,110,-120}, {19,111,-120}, {19,112,-60}, 
    {19,194,-120}, {19,43,-120}, {19,212,-20}, {19,46,-120}, 
    {19,115,-120}, {19,116,-120}, {19,117,-120}, {19,118,-120}, 
    {19,48,-120}, {19,50,-120}, {19,119,-120}, {19,120,-60}, 
    {20,0,-40}, {20,53,-40}, {20,54,-40}, {20,55,-40}, {20,56,-40}, 
    {20,57,-40}, {20,58,-40}, {20,142,-40}, {20,194,-40}, {80,0,-40}, 
    {80,53,-40}, {80,54,-40}, {80,55,-40}, {80,56,-40}, {80,57,-40}, 
    {80,58,-40}, {80,142,-40}, {80,194,-40}, {81,0,-40}, {81,53,-40}, 
    {81,54,-40}, {81,55,-40}, {81,56,-40}, {81,57,-40}, {81,58,-40}, 
    {81,142,-40}, {81,194,-40}, {82,0,-40}, {82,53,-40}, {82,54,-40}, 
    {82,55,-40}, {82,56,-40}, {82,57,-40}, {82,58,-40}, {82,142,-40}, 
    {82,194,-40}, {83,0,-40}, {83,53,-40}, {83,54,-40}, {83,55,-40}, 
    {83,56,-40}, {83,57,-40}, {83,58,-40}, {83,142,-40}, {83,194,-40}, 
    {21,0,-80}, {21,53,-80}, {21,54,-80}, {21,55,-80}, {21,56,-80}, 
    {21,57,-80}, {21,58,-80}, {21,6,-40}, {21,14,-40}, {21,72,-40}, 
    {21,73,-40}, {21,74,-40}, {21,75,-40}, {21,76,-40}, {21,77,-40}, 
    {21,26,-70}, {21,88,-70}, {21,89,-70}, {21,90,-70}, {21,91,-70}, 
    {21,92,-70}, {21,93,-70}, {21,141,-40}, {21,142,-125}, {21,30,-80}, 
    {21,95,-80}, {21,96,-80}, {21,97,-80}, {21,98,-80}, {21,174,-80}, 
    {21,40,-80}, {21,107,-80}, {21,108,-80}, {21,109,-80}, 
    {21,110,-80}, {21,111,-80}, {21,112,-80}, {21,194,-125}, 
    {21,212,-40}, {21,46,-70}, {21,115,-70}, {21,116,-70}, 
    {21,117,-70}, {21,118,-70}, {22,0,-50}, {22,53,-50}, {22,54,-50}, 
    {22,55,-50}, {22,56,-50}, {22,57,-50}, {22,58,-50}, {22,14,-20}, 
    {22,72,-20}, {22,73,-20}, {22,74,-20}, {22,75,-20}, {22,76,-20}, 
    {22,77,-20}, {22,26,-40}, {22,88,-40}, {22,89,-40}, {22,90,-40}, 
    {22,91,-40}, {22,92,-40}, {22,93,-40}, {22,142,-80}, {22,30,-30}, 
    {22,95,-30}, {22,96,-30}, {22,97,-30}, {22,98,-30}, {22,174,-40}, 
    {22,40,-30}, {22,107,-30}, {22,108,-30}, {22,109,-30}, 
    {22,110,-30}, {22,111,-30}, {22,112,-30}, {22,194,-80}, 
    {22,46,-30}, {22,115,-30}, {22,116,-30}, {22,117,-30}, 
    {22,118,-30}, {22,50,-20}, {22,119,-20}, {22,120,-20}, {24,0,-110}, 
    {24,53,-110}, {24,54,-110}, {24,55,-110}, {24,56,-110}, 
    {24,57,-110}, {24,58,-110}, {24,14,-85}, {24,72,-85}, {24,73,-85}, 
    {24,74,-85}, {24,75,-85}, {24,76,-85}, {24,77,-85}, {24,26,-140}, 
    {24,88,-140}, {24,89,-140}, {24,90,-140}, {24,91,-140}, 
    {24,92,-140}, {24,93,-140}, {24,141,-60}, {24,142,-140}, 
    {24,30,-140}, {24,95,-140}, {24,96,-140}, {24,97,-140}, 
    {24,98,-140}, {24,174,-140}, {24,34,-20}, {24,100,-20}, 
    {24,40,-140}, {24,107,-140}, {24,108,-140}, {24,109,-140}, 
    {24,110,-140}, {24,111,-140}, {24,112,-140}, {24,194,-140}, 
    {24,212,-60}, {24,46,-110}, {24,115,-110}, {24,116,-110}, 
    {24,117,-110}, {24,118,-110}, {84,0,-110}, {84,53,-110}, 
    {84,54,-110}, {84,55,-110}, {84,56,-110}, {84,57,-110}, 
    {84,58,-110}, {84,14,-85}, {84,72,-85}, {84,73,-85}, {84,74,-85}, 
    {84,75,-85}, {84,76,-85}, {84,77,-85}, {84,26,-140}, {84,88,-140}, 
    {84,89,-140}, {84,90,-140}, {84,91,-140}, {84,92,-140}, 
    {84,93,-70}, {84,141,-60}, {84,142,-140}, {84,30,-140}, 
    {84,95,-140}, {84,96,-140}, {84,97,-140}, {84,98,-140}, 
    {84,174,-140}, {84,34,-20}, {84,100,-20}, {84,40,-140}, 
    {84,107,-140}, {84,108,-140}, {84,109,-140}, {84,110,-140}, 
    {84,111,-140}, {84,112,-140}, {84,194,-140}, {84,212,-60}, 
    {84,46,-110}, {84,115,-110}, {84,116,-110}, {84,117,-110}, 
    {84,118,-110}, {85,0,-110}, {85,53,-110}, {85,54,-110}, 
    {85,55,-110}, {85,56,-110}, {85,57,-110}, {85,58,-110}, 
    {85,14,-85}, {85,72,-85}, {85,73,-85}, {85,74,-85}, {85,75,-85}, 
    {85,76,-85}, {85,77,-85}, {85,26,-140}, {85,88,-140}, {85,89,-140}, 
    {85,90,-140}, {85,91,-140}, {85,92,-140}, {85,93,-70}, 
    {85,141,-60}, {85,142,-140}, {85,30,-140}, {85,95,-140}, 
    {85,96,-140}, {85,97,-140}, {85,98,-140}, {85,174,-140}, 
    {85,34,-20}, {85,100,-20}, {85,40,-140}, {85,107,-140}, 
    {85,108,-140}, {85,109,-140}, {85,110,-140}, {85,111,-140}, 
    {85,112,-140}, {85,194,-140}, {85,212,-60}, {85,46,-110}, 
    {85,115,-110}, {85,116,-110}, {85,117,-110}, {85,118,-110}, 
    {26,47,-20}, {26,48,-20}, {26,50,-30}, {26,119,-30}, {26,120,-30}, 
    {88,47,-20}, {88,48,-20}, {88,50,-30}, {88,119,-30}, {88,120,-30}, 
    {89,47,-20}, {89,48,-20}, {89,50,-30}, {89,119,-30}, {89,120,-30}, 
    {90,47,-20}, {90,48,-20}, {90,50,-30}, {90,119,-30}, {90,120,-30}, 
    {91,47,-20}, {91,48,-20}, {91,50,-30}, {91,119,-30}, {91,120,-30}, 
    {92,47,-20}, {92,48,-20}, {92,50,-30}, {92,119,-30}, {92,120,-30}, 
    {93,47,-20}, {93,48,-20}, {93,50,-30}, {93,119,-30}, {93,120,-30}, 
    {27,27,-10}, {27,142,-40}, {27,37,-20}, {27,104,-20}, {27,194,-40}, 
    {27,46,-20}, {27,115,-20}, {27,116,-20}, {27,117,-20}, 
    {27,118,-20}, {27,47,-20}, {27,50,-20}, {27,119,-20}, {27,120,-20}, 
    {28,142,-15}, {28,36,-20}, {94,142,-15}, {94,36,-20}, 
    {141,216,-50}, {142,204,-100}, {142,206,-100}, {30,142,-15}, 
    {30,194,-15}, {30,47,-30}, {30,48,-20}, {30,49,-30}, {30,50,-20}, 
    {30,119,-20}, {30,120,-20}, {95,142,-15}, {95,194,-15}, 
    {95,47,-30}, {95,48,-20}, {95,49,-30}, {95,50,-20}, {95,119,-20}, 
    {95,120,-20}, {96,142,-15}, {96,194,-15}, {96,47,-30}, {96,48,-20}, 
    {96,49,-30}, {96,50,-20}, {96,119,-20}, {96,120,-20}, {97,142,-15}, 
    {97,194,-15}, {97,47,-30}, {97,48,-20}, {97,49,-30}, {97,50,-20}, 
    {97,119,-20}, {97,120,-20}, {98,142,-15}, {98,194,-15}, 
    {98,47,-30}, {98,48,-20}, {98,49,-30}, {98,50,-20}, {98,119,-20}, 
    {98,120,-20}, {31,26,-30}, {31,88,-30}, {31,89,-30}, {31,90,-30}, 
    {31,91,-30}, {31,92,-30}, {31,93,-30}, {31,142,-30}, {31,152,-28}, 
    {31,30,-30}, {31,95,-30}, {31,96,-30}, {31,97,-30}, {31,98,-30}, 
    {31,40,-30}, {31,107,-30}, {31,108,-30}, {31,109,-30}, 
    {31,110,-30}, {31,111,-30}, {31,112,-30}, {31,194,-30}, 
    {31,204,60}, {31,206,50}, {32,43,-10}, {33,50,-30}, {33,119,-30}, 
    {33,120,-30}, {36,30,-20}, {36,95,-20}, {36,96,-20}, {36,97,-20}, 
    {36,98,-20}, {36,40,-20}, {36,107,-20}, {36,108,-20}, {36,109,-20}, 
    {36,110,-20}, {36,111,-20}, {36,112,-20}, {38,46,-10}, 
    {38,115,-10}, {38,116,-10}, {38,117,-10}, {38,118,-10}, 
    {38,50,-15}, {38,119,-15}, {38,120,-15}, {39,46,-10}, {39,115,-10}, 
    {39,116,-10}, {39,117,-10}, {39,118,-10}, {39,47,-20}, {39,50,-15}, 
    {39,119,-15}, {39,120,-15}, {105,46,-10}, {105,115,-10}, 
    {105,116,-10}, {105,117,-10}, {105,118,-10}, {105,47,-20}, 
    {105,50,-15}, {105,119,-15}, {105,120,-15}, {40,142,-40}, 
    {40,194,-40}, {40,47,-15}, {40,48,-15}, {40,49,-30}, {40,50,-30}, 
    {40,119,-30}, {40,120,-30}, {107,142,-40}, {107,194,-40}, 
    {107,47,-15}, {107,48,-15}, {107,49,-30}, {107,50,-30}, 
    {107,119,-30}, {107,120,-30}, {108,142,-40}, {108,194,-40}, 
    {108,47,-15}, {108,48,-15}, {108,49,-30}, {108,50,-30}, 
    {108,119,-30}, {108,120,-30}, {109,142,-40}, {109,194,-40}, 
    {109,47,-15}, {109,48,-15}, {109,49,-30}, {109,50,-30}, 
    {109,119,-30}, {109,120,-30}, {110,142,-40}, {110,194,-40}, 
    {110,47,-15}, {110,48,-15}, {110,49,-30}, {110,50,-30}, 
    {110,119,-30}, {110,120,-30}, {111,26,-55}, {111,88,-55}, 
    {111,89,-55}, {111,90,-55}, {111,91,-55}, {111,92,-55}, 
    {111,93,-55}, {111,27,-55}, {111,28,-55}, {111,94,-55}, 
    {111,142,-95}, {111,29,-55}, {111,30,-55}, {111,95,-55}, 
    {111,96,-55}, {111,97,-55}, {111,98,-55}, {111,31,-55}, 
    {111,32,-55}, {111,33,-55}, {111,34,-55}, {111,100,-55}, 
    {111,101,-55}, {111,102,-55}, {111,103,-55}, {111,35,-55}, 
    {111,36,-55}, {111,37,-55}, {111,104,-55}, {111,38,-55}, 
    {111,39,-55}, {111,105,-55}, {111,40,-55}, {111,107,-55}, 
    {111,108,-55}, {111,109,-55}, {111,110,-55}, {111,111,-55}, 
    {111,112,-55}, {111,41,-55}, {111,194,-95}, {111,42,-55}, 
    {111,43,-55}, {111,44,-55}, {111,113,-55}, {111,45,-55}, 
    {111,46,-55}, {111,115,-55}, {111,116,-55}, {111,117,-55}, 
    {111,118,-55}, {111,47,-70}, {111,48,-70}, {111,49,-85}, 
    {111,50,-70}, {111,119,-70}, {111,120,-70}, {111,51,-55}, 
    {111,121,-55}, {112,142,-40}, {112,194,-40}, {112,47,-15}, 
    {112,48,-15}, {112,49,-30}, {112,50,-30}, {112,119,-30}, 
    {112,120,-30}, {41,142,-35}, {41,194,-35}, {41,50,-30}, 
    {41,119,-30}, {41,120,-30}, {194,204,-100}, {194,206,-100}, 
    {194,216,-60}, {204,216,-40}, {205,205,-57}, {206,29,-50}, 
    {206,206,-57}, {206,43,-50}, {206,44,-50}, {206,113,-50}, 
    {206,216,-70}, {43,26,-10}, {43,88,-10}, {43,89,-10}, {43,90,-10}, 
    {43,91,-10}, {43,92,-10}, {43,93,-10}, {43,141,30}, {43,142,-50}, 
    {43,34,15}, {43,100,15}, {43,101,15}, {43,102,15}, {43,103,15}, 
    {43,36,15}, {43,37,15}, {43,104,15}, {43,38,25}, {43,39,25}, 
    {43,105,25}, {43,41,30}, {43,194,-50}, {43,212,30}, {43,45,40}, 
    {43,46,15}, {43,115,15}, {43,116,15}, {43,117,15}, {43,118,15}, 
    {43,47,30}, {43,50,30}, {43,119,30}, {43,120,30}, {44,142,-15}, 
    {44,194,-15}, {44,48,-30}, {113,142,-15}, {113,194,-15}, 
    {113,48,-30}, {212,216,-50}, {216,19,-50}, {216,21,-50}, 
    {216,22,-40}, {216,24,-90}, {216,84,-90}, {216,85,-90}, 
    {216,203,-30}, {216,205,-60}, {47,26,-25}, {47,88,-25}, 
    {47,89,-25}, {47,90,-25}, {47,91,-25}, {47,92,-25}, {47,93,-25}, 
    {47,142,-80}, {47,30,-25}, {47,95,-25}, {47,96,-25}, {47,97,-25}, 
    {47,98,-25}, {47,40,-25}, {47,107,-25}, {47,108,-25}, {47,109,-25}, 
    {47,110,-25}, {47,111,-25}, {47,112,-25}, {47,194,-80}, 
    {48,26,-15}, {48,88,-15}, {48,89,-15}, {48,90,-15}, {48,91,-15}, 
    {48,92,-15}, {48,93,-15}, {48,142,-60}, {48,30,-10}, {48,95,-10}, 
    {48,96,-10}, {48,97,-10}, {48,98,-10}, {48,40,-10}, {48,107,-10}, 
    {48,108,-10}, {48,109,-10}, {48,110,-10}, {48,111,-10}, 
    {48,112,-10}, {48,194,-60}, {49,30,-30}, {49,95,-30}, {49,96,-30}, 
    {49,97,-30}, {49,98,-30}, {50,26,-20}, {50,88,-20}, {50,89,-20}, 
    {50,90,-20}, {50,91,-20}, {50,92,-20}, {50,93,-20}, {50,142,-100}, 
    {50,30,-20}, {50,95,-20}, {50,96,-20}, {50,97,-20}, {50,98,-20}, 
    {50,40,-20}, {50,107,-20}, {50,108,-20}, {50,109,-20}, 
    {50,110,-20}, {50,111,-20}, {50,112,-20}, {50,194,-100}, 
    {119,26,-20}, {119,88,-20}, {119,89,-20}, {119,90,-20}, 
    {119,91,-20}, {119,92,-20}, {119,93,-20}, {119,142,-100}, 
    {119,30,-20}, {119,95,-20}, {119,96,-20}, {119,97,-20}, 
    {119,98,-20}, {119,40,-20}, {119,107,-20}, {119,108,-20}, 
    {119,109,-20}, {119,110,-20}, {119,111,-20}, {119,112,-20}, 
    {119,194,-100}, {120,26,-20}, {120,88,-20}, {120,89,-20}, 
    {120,90,-20}, {120,91,-20}, {120,92,-20}, {120,93,-20}, 
    {120,142,-100}, {120,30,-20}, {120,95,-20}, {120,96,-20}, 
    {120,97,-20}, {120,98,-20}, {120,40,-20}, {120,107,-20}, 
    {120,108,-20}, {120,109,-20}, {120,110,-20}, {120,111,-20}, 
    {120,112,-20}, {120,194,-100}, {51,30,-15}, {51,95,-15}, 
    {51,96,-15}, {51,97,-15}, {51,98,-15}, {51,40,-15}, {51,107,-15}, 
    {51,108,-15}, {51,109,-15}, {51,110,-15}, {51,111,-15}, 
    {51,112,-15}, {121,30,-15}, {121,95,-15}, {121,96,-15}, 
    {121,97,-15}, {121,98,-15}, {121,40,-15}, {121,107,-15}, 
    {121,108,-15}, {121,109,-15}, {121,110,-15}, {121,111,-15}, 
    {121,112,-15}, 
    {0xFFFF,0xFFFF,0}
};
static const kern_pair helvetica_oblique_kerns[] = {
    {0,2,-30}, {0,59,-30}, {0,6,-30}, {0,14,-30}, {0,72,-30}, 
    {0,73,-30}, {0,74,-30}, {0,75,-30}, {0,76,-30}, {0,77,-30}, 
    {0,16,-30}, {0,19,-120}, {0,20,-50}, {0,80,-50}, {0,81,-50}, 
    {0,82,-50}, {0,83,-50}, {0,21,-70}, {0,22,-50}, {0,24,-100}, 
    {0,84,-100}, {0,85,-100}, {0,46,-30}, {0,115,-30}, {0,116,-30}, 
    {0,117,-30}, {0,118,-30}, {0,47,-40}, {0,48,-40}, {0,50,-40}, 
    {0,119,-40}, {0,120,-40}, {53,2,-30}, {53,59,-30}, {53,6,-30}, 
    {53,14,-30}, {53,72,-30}, {53,73,-30}, {53,74,-30}, {53,75,-30}, 
    {53,76,-30}, {53,77,-30}, {53,16,-30}, {53,19,-120}, {53,20,-50}, 
    {53,80,-50}, {53,81,-50}, {53,82,-50}, {53,83,-50}, {53,21,-70}, 
    {53,22,-50}, {53,24,-100}, {53,84,-100}, {53,85,-100}, {53,46,-30}, 
    {53,115,-30}, {53,116,-30}, {53,117,-30}, {53,118,-30}, 
    {53,47,-40}, {53,48,-40}, {53,50,-40}, {53,119,-40}, {53,120,-40}, 
    {54,2,-30}, {54,59,-30}, {54,6,-30}, {54,14,-30}, {54,72,-30}, 
    {54,73,-30}, {54,74,-30}, {54,75,-30}, {54,76,-30}, {54,77,-30}, 
    {54,16,-30}, {54,19,-120}, {54,20,-50}, {54,80,-50}, {54,81,-50}, 
    {54,82,-50}, {54,83,-50}, {54,21,-70}, {54,22,-50}, {54,24,-100}, 
    {54,84,-100}, {54,85,-100}, {54,46,-30}, {54,115,-30}, 
    {54,116,-30}, {54,117,-30}, {54,118,-30}, {54,47,-40}, {54,48,-40}, 
    {54,50,-40}, {54,119,-40}, {54,120,-40}, {55,2,-30}, {55,59,-30}, 
    {55,6,-30}, {55,14,-30}, {55,72,-30}, {55,73,-30}, {55,74,-30}, 
    {55,75,-30}, {55,76,-30}, {55,77,-30}, {55,16,-30}, {55,19,-120}, 
    {55,20,-50}, {55,80,-50}, {55,81,-50}, {55,82,-50}, {55,83,-50}, 
    {55,21,-70}, {55,22,-50}, {55,24,-100}, {55,84,-100}, {55,85,-100}, 
    {55,46,-30}, {55,115,-30}, {55,116,-30}, {55,117,-30}, 
    {55,118,-30}, {55,47,-40}, {55,48,-40}, {55,50,-40}, {55,119,-40}, 
    {55,120,-40}, {56,2,-30}, {56,59,-30}, {56,6,-30}, {56,14,-30}, 
    {56,72,-30}, {56,73,-30}, {56,74,-30}, {56,75,-30}, {56,76,-30}, 
    {56,77,-30}, {56,16,-30}, {56,19,-120}, {56,20,-50}, {56,80,-50}, 
    {56,81,-50}, {56,82,-50}, {56,83,-50}, {56,21,-70}, {56,22,-50}, 
    {56,24,-100}, {56,84,-100}, {56,85,-100}, {56,46,-30}, 
    {56,115,-30}, {56,116,-30}, {56,117,-30}, {56,118,-30}, 
    {56,47,-40}, {56,48,-40}, {56,50,-40}, {56,119,-40}, {56,120,-40}, 
    {57,2,-30}, {57,59,-30}, {57,6,-30}, {57,14,-30}, {57,72,-30}, 
    {57,73,-30}, {57,74,-30}, {57,75,-30}, {57,76,-30}, {57,77,-30}, 
    {57,16,-30}, {57,19,-120}, {57,20,-50}, {57,80,-50}, {57,81,-50}, 
    {57,82,-50}, {57,83,-50}, {57,21,-70}, {57,22,-50}, {57,24,-100}, 
    {57,84,-100}, {57,85,-100}, {57,46,-30}, {57,115,-30}, 
    {57,116,-30}, {57,117,-30}, {57,118,-30}, {57,47,-40}, {57,48,-40}, 
    {57,50,-40}, {57,119,-40}, {57,120,-40}, {58,2,-30}, {58,59,-30}, 
    {58,6,-30}, {58,14,-30}, {58,72,-30}, {58,73,-30}, {58,74,-30}, 
    {58,75,-30}, {58,76,-30}, {58,77,-30}, {58,16,-30}, {58,19,-120}, 
    {58,20,-50}, {58,80,-50}, {58,81,-50}, {58,82,-50}, {58,83,-50}, 
    {58,21,-70}, {58,22,-50}, {58,24,-100}, {58,84,-100}, {58,85,-100}, 
    {58,46,-30}, {58,115,-30}, {58,116,-30}, {58,117,-30}, 
    {58,118,-30}, {58,47,-40}, {58,48,-40}, {58,50,-40}, {58,119,-40}, 
    {58,120,-40}, {1,20,-10}, {1,80,-10}, {1,81,-10}, {1,82,-10}, 
    {1,83,-10}, {1,142,-20}, {1,194,-20}, {2,142,-30}, {2,194,-30}, 
    {59,142,-30}, {59,194,-30}, {3,0,-40}, {3,53,-40}, {3,54,-40}, 
    {3,55,-40}, {3,56,-40}, {3,57,-40}, {3,58,-40}, {3,21,-70}, 
    {3,22,-40}, {3,24,-90}, {3,84,-90}, {3,85,-90}, {3,142,-70}, 
    {3,194,-70}, {5,0,-80}, {5,53,-80}, {5,54,-80}, {5,55,-80}, 
    {5,56,-80}, {5,57,-80}, {5,58,-80}, {5,26,-50}, {5,88,-50}, 
    {5,89,-50}, {5,90,-50}, {5,91,-50}, {5,92,-50}, {5,93,-50}, 
    {5,142,-150}, {5,30,-30}, {5,95,-30}, {5,96,-30}, {5,97,-30}, 
    {5,98,-30}, {5,40,-30}, {5,107,-30}, {5,108,-30}, {5,109,-30}, 
    {5,110,-30}, {5,111,-30}, {5,112,-30}, {5,194,-150}, {5,43,-45}, 
    {9,0,-20}, {9,53,-20}, {9,54,-20}, {9,55,-20}, {9,56,-20}, 
    {9,57,-20}, {9,58,-20}, {9,26,-20}, {9,88,-20}, {9,89,-20}, 
    {9,90,-20}, {9,91,-20}, {9,92,-20}, {9,93,-20}, {9,142,-30}, 
    {9,194,-30}, {9,46,-20}, {9,115,-20}, {9,116,-20}, {9,117,-20}, 
    {9,118,-20}, {10,14,-50}, {10,72,-50}, {10,73,-50}, {10,74,-50}, 
    {10,75,-50}, {10,76,-50}, {10,77,-50}, {10,30,-40}, {10,95,-40}, 
    {10,96,-40}, {10,97,-40}, {10,98,-40}, {10,40,-40}, {10,107,-40}, 
    {10,108,-40}, {10,109,-40}, {10,110,-40}, {10,111,-40}, 
    {10,112,-40}, {10,46,-30}, {10,115,-30}, {10,116,-30}, 
    {10,117,-30}, {10,118,-30}, {10,50,-50}, {10,119,-50}, 
    {10,120,-50}, {11,19,-110}, {11,21,-110}, {11,22,-70}, 
    {11,24,-140}, {11,84,-140}, {11,85,-140}, {11,204,-140}, 
    {11,206,-160}, {11,50,-30}, {11,119,-30}, {11,120,-30}, 
    {69,19,-110}, {69,21,-110}, {69,22,-70}, {69,24,-140}, 
    {69,84,-140}, {69,85,-140}, {69,204,-140}, {69,206,-160}, 
    {69,50,-30}, {69,119,-30}, {69,120,-30}, {14,0,-20}, {14,53,-20}, 
    {14,54,-20}, {14,55,-20}, {14,56,-20}, {14,57,-20}, {14,58,-20}, 
    {14,19,-40}, {14,21,-50}, {14,22,-30}, {14,23,-60}, {14,24,-70}, 
    {14,84,-70}, {14,85,-70}, {14,142,-40}, {14,194,-40}, {72,0,-20}, 
    {72,53,-20}, {72,54,-20}, {72,55,-20}, {72,56,-20}, {72,57,-20}, 
    {72,58,-20}, {72,19,-40}, {72,21,-50}, {72,22,-30}, {72,23,-60}, 
    {72,24,-70}, {72,84,-70}, {72,85,-70}, {72,142,-40}, {72,194,-40}, 
    {73,0,-20}, {73,53,-20}, {73,54,-20}, {73,55,-20}, {73,56,-20}, 
    {73,57,-20}, {73,58,-20}, {73,19,-40}, {73,21,-50}, {73,22,-30}, 
    {73,23,-60}, {73,24,-70}, {73,84,-70}, {73,85,-70}, {73,142,-40}, 
    {73,194,-40}, {74,0,-20}, {74,53,-20}, {74,54,-20}, {74,55,-20}, 
    {74,56,-20}, {74,57,-20}, {74,58,-20}, {74,19,-40}, {74,21,-50}, 
    {74,22,-30}, {74,23,-60}, {74,24,-70}, {74,84,-70}, {74,85,-70}, 
    {74,142,-40}, {74,194,-40}, {75,0,-20}, {75,53,-20}, {75,54,-20}, 
    {75,55,-20}, {75,56,-20}, {75,57,-20}, {75,58,-20}, {75,19,-40}, 
    {75,21,-50}, {75,22,-30}, {75,23,-60}, {75,24,-70}, {75,84,-70}, 
    {75,85,-70}, {75,142,-40}, {75,194,-40}, {76,0,-20}, {76,53,-20}, 
    {76,54,-20}, {76,55,-20}, {76,56,-20}, {76,57,-20}, {76,58,-20}, 
    {76,19,-40}, {76,21,-50}, {76,22,-30}, {76,23,-60}, {76,24,-70}, 
    {76,84,-70}, {76,85,-70}, {76,142,-40}, {76,194,-40}, {77,0,-20}, 
    {77,53,-20}, {77,54,-20}, {77,55,-20}, {77,56,-20}, {77,57,-20}, 
    {77,58,-20}, {77,19,-40}, {77,21,-50}, {77,22,-30}, {77,23,-60}, 
    {77,24,-70}, {77,84,-70}, {77,85,-70}, {77,142,-40}, {77,194,-40}, 
    {15,0,-120}, {15,53,-120}, {15,54,-120}, {15,55,-120}, 
    {15,56,-120}, {15,57,-120}, {15,58,-120}, {15,26,-40}, {15,88,-40}, 
    {15,89,-40}, {15,90,-40}, {15,91,-40}, {15,92,-40}, {15,93,-40}, 
    {15,142,-180}, {15,30,-50}, {15,95,-50}, {15,96,-50}, {15,97,-50}, 
    {15,98,-50}, {15,40,-50}, {15,107,-50}, {15,108,-50}, {15,109,-50}, 
    {15,110,-50}, {15,111,-50}, {15,112,-50}, {15,194,-180}, 
    {16,20,-10}, {16,80,-10}, {16,81,-10}, {16,82,-10}, {16,83,-10}, 
    {17,14,-20}, {17,72,-20}, {17,73,-20}, {17,74,-20}, {17,75,-20}, 
    {17,76,-20}, {17,77,-20}, {17,19,-30}, {17,20,-40}, {17,80,-40}, 
    {17,81,-40}, {17,82,-40}, {17,83,-40}, {17,21,-50}, {17,22,-30}, 
    {17,24,-50}, {17,84,-50}, {17,85,-50}, {18,142,-20}, {18,194,-20}, 
    {78,142,-20}, {78,194,-20}, {19,0,-120}, {19,53,-120}, 
    {19,54,-120}, {19,55,-120}, {19,56,-120}, {19,57,-120}, 
    {19,58,-120}, {19,14,-40}, {19,72,-40}, {19,73,-40}, {19,74,-40}, 
    {19,75,-40}, {19,76,-40}, {19,77,-40}, {19,26,-120}, {19,88,-120}, 
    {19,89,-120}, {19,90,-120}, {19,91,-120}, {19,92,-120}, 
    {19,93,-60}, {19,141,-20}, {19,142,-120}, {19,30,-120}, 
    {19,95,-120}, {19,96,-120}, {19,97,-120}, {19,98,-60}, 
    {19,174,-140}, {19,40,-120}, {19,107,-120}, {19,108,-120}, 
    {19,109,-120}, {19,110,-120}, {19,111,-120}, {19,112,-60}, 
    {19,194,-120}, {19,43,-120}, {19,212,-20}, {19,46,-120}, 
    {19,115,-120}, {19,116,-120}, {19,117,-120}, {19,118,-120}, 
    {19,48,-120}, {19,50,-120}, {19,119,-120}, {19,120,-60}, 
    {20,0,-40}, {20,53,-40}, {20,54,-40}, {20,55,-40}, {20,56,-40}, 
    {20,57,-40}, {20,58,-40}, {20,142,-40}, {20,194,-40}, {80,0,-40}, 
    {80,53,-40}, {80,54,-40}, {80,55,-40}, {80,56,-40}, {80,57,-40}, 
    {80,58,-40}, {80,142,-40}, {80,194,-40}, {81,0,-40}, {81,53,-40}, 
    {81,54,-40}, {81,55,-40}, {81,56,-40}, {81,57,-40}, {81,58,-40}, 
    {81,142,-40}, {81,194,-40}, {82,0,-40}, {82,53,-40}, {82,54,-40}, 
    {82,55,-40}, {82,56,-40}, {82,57,-40}, {82,58,-40}, {82,142,-40}, 
    {82,194,-40}, {83,0,-40}, {83,53,-40}, {83,54,-40}, {83,55,-40}, 
    {83,56,-40}, {83,57,-40}, {83,58,-40}, {83,142,-40}, {83,194,-40}, 
    {21,0,-80}, {21,53,-80}, {21,54,-80}, {21,55,-80}, {21,56,-80}, 
    {21,57,-80}, {21,58,-80}, {21,6,-40}, {21,14,-40}, {21,72,-40}, 
    {21,73,-40}, {21,74,-40}, {21,75,-40}, {21,76,-40}, {21,77,-40}, 
    {21,26,-70}, {21,88,-70}, {21,89,-70}, {21,90,-70}, {21,91,-70}, 
    {21,92,-70}, {21,93,-70}, {21,141,-40}, {21,142,-125}, {21,30,-80}, 
    {21,95,-80}, {21,96,-80}, {21,97,-80}, {21,98,-80}, {21,174,-80}, 
    {21,40,-80}, {21,107,-80}, {21,108,-80}, {21,109,-80}, 
    {21,110,-80}, {21,111,-80}, {21,112,-80}, {21,194,-125}, 
    {21,212,-40}, {21,46,-70}, {21,115,-70}, {21,116,-70}, 
    {21,117,-70}, {21,118,-70}, {22,0,-50}, {22,53,-50}, {22,54,-50}, 
    {22,55,-50}, {22,56,-50}, {22,57,-50}, {22,58,-50}, {22,14,-20}, 
    {22,72,-20}, {22,73,-20}, {22,74,-20}, {22,75,-20}, {22,76,-20}, 
    {22,77,-20}, {22,26,-40}, {22,88,-40}, {22,89,-40}, {22,90,-40}, 
    {22,91,-40}, {22,92,-40}, {22,93,-40}, {22,142,-80}, {22,30,-30}, 
    {22,95,-30}, {22,96,-30}, {22,97,-30}, {22,98,-30}, {22,174,-40}, 
    {22,40,-30}, {22,107,-30}, {22,108,-30}, {22,109,-30}, 
    {22,110,-30}, {22,111,-30}, {22,112,-30}, {22,194,-80}, 
    {22,46,-30}, {22,115,-30}, {22,116,-30}, {22,117,-30}, 
    {22,118,-30}, {22,50,-20}, {22,119,-20}, {22,120,-20}, {24,0,-110}, 
    {24,53,-110}, {24,54,-110}, {24,55,-110}, {24,56,-110}, 
    {24,57,-110}, {24,58,-110}, {24,14,-85}, {24,72,-85}, {24,73,-85}, 
    {24,74,-85}, {24,75,-85}, {24,76,-85}, {24,77,-85}, {24,26,-140}, 
    {24,88,-140}, {24,89,-140}, {24,90,-140}, {24,91,-140}, 
    {24,92,-140}, {24,93,-140}, {24,141,-60}, {24,142,-140}, 
    {24,30,-140}, {24,95,-140}, {24,96,-140}, {24,97,-140}, 
    {24,98,-140}, {24,174,-140}, {24,34,-20}, {24,100,-20}, 
    {24,40,-140}, {24,107,-140}, {24,108,-140}, {24,109,-140}, 
    {24,110,-140}, {24,111,-140}, {24,112,-140}, {24,194,-140}, 
    {24,212,-60}, {24,46,-110}, {24,115,-110}, {24,116,-110}, 
    {24,117,-110}, {24,118,-110}, {84,0,-110}, {84,53,-110}, 
    {84,54,-110}, {84,55,-110}, {84,56,-110}, {84,57,-110}, 
    {84,58,-110}, {84,14,-85}, {84,72,-85}, {84,73,-85}, {84,74,-85}, 
    {84,75,-85}, {84,76,-85}, {84,77,-85}, {84,26,-140}, {84,88,-140}, 
    {84,89,-140}, {84,90,-140}, {84,91,-140}, {84,92,-140}, 
    {84,93,-70}, {84,141,-60}, {84,142,-140}, {84,30,-140}, 
    {84,95,-140}, {84,96,-140}, {84,97,-140}, {84,98,-140}, 
    {84,174,-140}, {84,34,-20}, {84,100,-20}, {84,40,-140}, 
    {84,107,-140}, {84,108,-140}, {84,109,-140}, {84,110,-140}, 
    {84,111,-140}, {84,112,-140}, {84,194,-140}, {84,212,-60}, 
    {84,46,-110}, {84,115,-110}, {84,116,-110}, {84,117,-110}, 
    {84,118,-110}, {85,0,-110}, {85,53,-110}, {85,54,-110}, 
    {85,55,-110}, {85,56,-110}, {85,57,-110}, {85,58,-110}, 
    {85,14,-85}, {85,72,-85}, {85,73,-85}, {85,74,-85}, {85,75,-85}, 
    {85,76,-85}, {85,77,-85}, {85,26,-140}, {85,88,-140}, {85,89,-140}, 
    {85,90,-140}, {85,91,-140}, {85,92,-140}, {85,93,-70}, 
    {85,141,-60}, {85,142,-140}, {85,30,-140}, {85,95,-140}, 
    {85,96,-140}, {85,97,-140}, {85,98,-140}, {85,174,-140}, 
    {85,34,-20}, {85,100,-20}, {85,40,-140}, {85,107,-140}, 
    {85,108,-140}, {85,109,-140}, {85,110,-140}, {85,111,-140}, 
    {85,112,-140}, {85,194,-140}, {85,212,-60}, {85,46,-110}, 
    {85,115,-110}, {85,116,-110}, {85,117,-110}, {85,118,-110}, 
    {26,47,-20}, {26,48,-20}, {26,50,-30}, {26,119,-30}, {26,120,-30}, 
    {88,47,-20}, {88,48,-20}, {88,50,-30}, {88,119,-30}, {88,120,-30}, 
    {89,47,-20}, {89,48,-20}, {89,50,-30}, {89,119,-30}, {89,120,-30}, 
    {90,47,-20}, {90,48,-20}, {90,50,-30}, {90,119,-30}, {90,120,-30}, 
    {91,47,-20}, {91,48,-20}, {91,50,-30}, {91,119,-30}, {91,120,-30}, 
    {92,47,-20}, {92,48,-20}, {92,50,-30}, {92,119,-30}, {92,120,-30}, 
    {93,47,-20}, {93,48,-20}, {93,50,-30}, {93,119,-30}, {93,120,-30}, 
    {27,27,-10}, {27,142,-40}, {27,37,-20}, {27,104,-20}, {27,194,-40}, 
    {27,46,-20}, {27,115,-20}, {27,116,-20}, {27,117,-20}, 
    {27,118,-20}, {27,47,-20}, {27,50,-20}, {27,119,-20}, {27,120,-20}, 
    {28,142,-15}, {28,36,-20}, {94,142,-15}, {94,36,-20}, 
    {141,216,-50}, {142,204,-100}, {142,206,-100}, {30,142,-15}, 
    {30,194,-15}, {30,47,-30}, {30,48,-20}, {30,49,-30}, {30,50,-20}, 
    {30,119,-20}, {30,120,-20}, {95,142,-15}, {95,194,-15}, 
    {95,47,-30}, {95,48,-20}, {95,49,-30}, {95,50,-20}, {95,119,-20}, 
    {95,120,-20}, {96,142,-15}, {96,194,-15}, {96,47,-30}, {96,48,-20}, 
    {96,49,-30}, {96,50,-20}, {96,119,-20}, {96,120,-20}, {97,142,-15}, 
    {97,194,-15}, {97,47,-30}, {97,48,-20}, {97,49,-30}, {97,50,-20}, 
    {97,119,-20}, {97,120,-20}, {98,142,-15}, {98,194,-15}, 
    {98,47,-30}, {98,48,-20}, {98,49,-30}, {98,50,-20}, {98,119,-20}, 
    {98,120,-20}, {31,26,-30}, {31,88,-30}, {31,89,-30}, {31,90,-30}, 
    {31,91,-30}, {31,92,-30}, {31,93,-30}, {31,142,-30}, {31,152,-28}, 
    {31,30,-30}, {31,95,-30}, {31,96,-30}, {31,97,-30}, {31,98,-30}, 
    {31,40,-30}, {31,107,-30}, {31,108,-30}, {31,109,-30}, 
    {31,110,-30}, {31,111,-30}, {31,112,-30}, {31,194,-30}, 
    {31,204,60}, {31,206,50}, {32,43,-10}, {33,50,-30}, {33,119,-30}, 
    {33,120,-30}, {36,30,-20}, {36,95,-20}, {36,96,-20}, {36,97,-20}, 
    {36,98,-20}, {36,40,-20}, {36,107,-20}, {36,108,-20}, {36,109,-20}, 
    {36,110,-20}, {36,111,-20}, {36,112,-20}, {38,46,-10}, 
    {38,115,-10}, {38,116,-10}, {38,117,-10}, {38,118,-10}, 
    {38,50,-15}, {38,119,-15}, {38,120,-15}, {39,46,-10}, {39,115,-10}, 
    {39,116,-10}, {39,117,-10}, {39,118,-10}, {39,47,-20}, {39,50,-15}, 
    {39,119,-15}, {39,120,-15}, {105,46,-10}, {105,115,-10}, 
    {105,116,-10}, {105,117,-10}, {105,118,-10}, {105,47,-20}, 
    {105,50,-15}, {105,119,-15}, {105,120,-15}, {40,142,-40}, 
    {40,194,-40}, {40,47,-15}, {40,48,-15}, {40,49,-30}, {40,50,-30}, 
    {40,119,-30}, {40,120,-30}, {107,142,-40}, {107,194,-40}, 
    {107,47,-15}, {107,48,-15}, {107,49,-30}, {107,50,-30}, 
    {107,119,-30}, {107,120,-30}, {108,142,-40}, {108,194,-40}, 
    {108,47,-15}, {108,48,-15}, {108,49,-30}, {108,50,-30}, 
    {108,119,-30}, {108,120,-30}, {109,142,-40}, {109,194,-40}, 
    {109,47,-15}, {109,48,-15}, {109,49,-30}, {109,50,-30}, 
    {109,119,-30}, {109,120,-30}, {110,142,-40}, {110,194,-40}, 
    {110,47,-15}, {110,48,-15}, {110,49,-30}, {110,50,-30}, 
    {110,119,-30}, {110,120,-30}, {111,26,-55}, {111,88,-55}, 
    {111,89,-55}, {111,90,-55}, {111,91,-55}, {111,92,-55}, 
    {111,93,-55}, {111,27,-55}, {111,28,-55}, {111,94,-55}, 
    {111,142,-95}, {111,29,-55}, {111,30,-55}, {111,95,-55}, 
    {111,96,-55}, {111,97,-55}, {111,98,-55}, {111,31,-55}, 
    {111,32,-55}, {111,33,-55}, {111,34,-55}, {111,100,-55}, 
    {111,101,-55}, {111,102,-55}, {111,103,-55}, {111,35,-55}, 
    {111,36,-55}, {111,37,-55}, {111,104,-55}, {111,38,-55}, 
    {111,39,-55}, {111,105,-55}, {111,40,-55}, {111,107,-55}, 
    {111,108,-55}, {111,109,-55}, {111,110,-55}, {111,111,-55}, 
    {111,112,-55}, {111,41,-55}, {111,194,-95}, {111,42,-55}, 
    {111,43,-55}, {111,44,-55}, {111,113,-55}, {111,45,-55}, 
    {111,46,-55}, {111,115,-55}, {111,116,-55}, {111,117,-55}, 
    {111,118,-55}, {111,47,-70}, {111,48,-70}, {111,49,-85}, 
    {111,50,-70}, {111,119,-70}, {111,120,-70}, {111,51,-55}, 
    {111,121,-55}, {112,142,-40}, {112,194,-40}, {112,47,-15}, 
    {112,48,-15}, {112,49,-30}, {112,50,-30}, {112,119,-30}, 
    {112,120,-30}, {41,142,-35}, {41,194,-35}, {41,50,-30}, 
    {41,119,-30}, {41,120,-30}, {194,204,-100}, {194,206,-100}, 
    {194,216,-60}, {204,216,-40}, {205,205,-57}, {206,29,-50}, 
    {206,206,-57}, {206,43,-50}, {206,44,-50}, {206,113,-50}, 
    {206,216,-70}, {43,26,-10}, {43,88,-10}, {43,89,-10}, {43,90,-10}, 
    {43,91,-10}, {43,92,-10}, {43,93,-10}, {43,141,30}, {43,142,-50}, 
    {43,34,15}, {43,100,15}, {43,101,15}, {43,102,15}, {43,103,15}, 
    {43,36,15}, {43,37,15}, {43,104,15}, {43,38,25}, {43,39,25}, 
    {43,105,25}, {43,41,30}, {43,194,-50}, {43,212,30}, {43,45,40}, 
    {43,46,15}, {43,115,15}, {43,116,15}, {43,117,15}, {43,118,15}, 
    {43,47,30}, {43,50,30}, {43,119,30}, {43,120,30}, {44,142,-15}, 
    {44,194,-15}, {44,48,-30}, {113,142,-15}, {113,194,-15}, 
    {113,48,-30}, {212,216,-50}, {216,19,-50}, {216,21,-50}, 
    {216,22,-40}, {216,24,-90}, {216,84,-90}, {216,85,-90}, 
    {216,203,-30}, {216,205,-60}, {47,26,-25}, {47,88,-25}, 
    {47,89,-25}, {47,90,-25}, {47,91,-25}, {47,92,-25}, {47,93,-25}, 
    {47,142,-80}, {47,30,-25}, {47,95,-25}, {47,96,-25}, {47,97,-25}, 
    {47,98,-25}, {47,40,-25}, {47,107,-25}, {47,108,-25}, {47,109,-25}, 
    {47,110,-25}, {47,111,-25}, {47,112,-25}, {47,194,-80}, 
    {48,26,-15}, {48,88,-15}, {48,89,-15}, {48,90,-15}, {48,91,-15}, 
    {48,92,-15}, {48,93,-15}, {48,142,-60}, {48,30,-10}, {48,95,-10}, 
    {48,96,-10}, {48,97,-10}, {48,98,-10}, {48,40,-10}, {48,107,-10}, 
    {48,108,-10}, {48,109,-10}, {48,110,-10}, {48,111,-10}, 
    {48,112,-10}, {48,194,-60}, {49,30,-30}, {49,95,-30}, {49,96,-30}, 
    {49,97,-30}, {49,98,-30}, {50,26,-20}, {50,88,-20}, {50,89,-20}, 
    {50,90,-20}, {50,91,-20}, {50,92,-20}, {50,93,-20}, {50,142,-100}, 
    {50,30,-20}, {50,95,-20}, {50,96,-20}, {50,97,-20}, {50,98,-20}, 
    {50,40,-20}, {50,107,-20}, {50,108,-20}, {50,109,-20}, 
    {50,110,-20}, {50,111,-20}, {50,112,-20}, {50,194,-100}, 
    {119,26,-20}, {119,88,-20}, {119,89,-20}, {119,90,-20}, 
    {119,91,-20}, {119,92,-20}, {119,93,-20}, {119,142,-100}, 
    {119,30,-20}, {119,95,-20}, {119,96,-20}, {119,97,-20}, 
    {119,98,-20}, {119,40,-20}, {119,107,-20}, {119,108,-20}, 
    {119,109,-20}, {119,110,-20}, {119,111,-20}, {119,112,-20}, 
    {119,194,-100}, {120,26,-20}, {120,88,-20}, {120,89,-20}, 
    {120,90,-20}, {120,91,-20}, {120,92,-20}, {120,93,-20}, 
    {120,142,-100}, {120,30,-20}, {120,95,-20}, {120,96,-20}, 
    {120,97,-20}, {120,98,-20}, {120,40,-20}, {120,107,-20}, 
    {120,108,-20}, {120,109,-20}, {120,110,-20}, {120,111,-20}, 
    {120,112,-20}, {120,194,-100}, {51,30,-15}, {51,95,-15}, 
    {51,96,-15}, {51,97,-15}, {51,98,-15}, {51,40,-15}, {51,107,-15}, 
    {51,108,-15}, {51,109,-15}, {51,110,-15}, {51,111,-15}, 
    {51,112,-15}, {121,30,-15}, {121,95,-15}, {121,96,-15}, 
    {121,97,-15}, {121,98,-15}, {121,40,-15}, {121,107,-15}, 
    {121,108,-15}, {121,109,-15}, {121,110,-15}, {121,111,-15}, 
    {121,112,-15}, 
    {0xFFFF,0xFFFF,0}
};
static const kern_pair helvetica_bold_kerns[] = {
    {0,2,-40}, {0,59,-40}, {0,6,-50}, {0,14,-40}, {0,72,-40}, 
    {0,73,-40}, {0,74,-40}, {0,75,-40}, {0,76,-40}, {0,77,-40}, 
    {0,16,-40}, {0,19,-90}, {0,20,-50}, {0,80,-50}, {0,81,-50}, 
    {0,82,-50}, {0,83,-50}, {0,21,-80}, {0,22,-60}, {0,24,-110}, 
    {0,84,-110}, {0,85,-110}, {0,46,-30}, {0,115,-30}, {0,116,-30}, 
    {0,117,-30}, {0,118,-30}, {0,47,-40}, {0,48,-30}, {0,50,-30}, 
    {0,119,-30}, {0,120,-30}, {53,2,-40}, {53,59,-40}, {53,6,-50}, 
    {53,14,-40}, {53,72,-40}, {53,73,-40}, {53,74,-40}, {53,75,-40}, 
    {53,76,-40}, {53,77,-40}, {53,16,-40}, {53,19,-90}, {53,20,-50}, 
    {53,80,-50}, {53,81,-50}, {53,82,-50}, {53,83,-50}, {53,21,-80}, 
    {53,22,-60}, {53,24,-110}, {53,84,-110}, {53,85,-110}, {53,46,-30}, 
    {53,115,-30}, {53,116,-30}, {53,117,-30}, {53,118,-30}, 
    {53,47,-40}, {53,48,-30}, {53,50,-30}, {53,119,-30}, {53,120,-30}, 
    {54,2,-40}, {54,59,-40}, {54,6,-50}, {54,14,-40}, {54,72,-40}, 
    {54,73,-40}, {54,74,-40}, {54,75,-40}, {54,76,-40}, {54,77,-40}, 
    {54,16,-40}, {54,19,-90}, {54,20,-50}, {54,80,-50}, {54,81,-50}, 
    {54,82,-50}, {54,83,-50}, {54,21,-80}, {54,22,-60}, {54,24,-110}, 
    {54,84,-110}, {54,85,-110}, {54,46,-30}, {54,115,-30}, 
    {54,116,-30}, {54,117,-30}, {54,118,-30}, {54,47,-40}, {54,48,-30}, 
    {54,50,-30}, {54,119,-30}, {54,120,-30}, {55,2,-40}, {55,59,-40}, 
    {55,6,-50}, {55,14,-40}, {55,72,-40}, {55,73,-40}, {55,74,-40}, 
    {55,75,-40}, {55,76,-40}, {55,77,-40}, {55,16,-40}, {55,19,-90}, 
    {55,20,-50}, {55,80,-50}, {55,81,-50}, {55,82,-50}, {55,83,-50}, 
    {55,21,-80}, {55,22,-60}, {55,24,-110}, {55,84,-110}, {55,85,-110}, 
    {55,46,-30}, {55,115,-30}, {55,116,-30}, {55,117,-30}, 
    {55,118,-30}, {55,47,-40}, {55,48,-30}, {55,50,-30}, {55,119,-30}, 
    {55,120,-30}, {56,2,-40}, {56,59,-40}, {56,6,-50}, {56,14,-40}, 
    {56,72,-40}, {56,73,-40}, {56,74,-40}, {56,75,-40}, {56,76,-40}, 
    {56,77,-40}, {56,16,-40}, {56,19,-90}, {56,20,-50}, {56,80,-50}, 
    {56,81,-50}, {56,82,-50}, {56,83,-50}, {56,21,-80}, {56,22,-60}, 
    {56,24,-110}, {56,84,-110}, {56,85,-110}, {56,46,-30}, 
    {56,115,-30}, {56,116,-30}, {56,117,-30}, {56,118,-30}, 
    {56,47,-40}, {56,48,-30}, {56,50,-30}, {56,119,-30}, {56,120,-30}, 
    {57,2,-40}, {57,59,-40}, {57,6,-50}, {57,14,-40}, {57,72,-40}, 
    {57,73,-40}, {57,74,-40}, {57,75,-40}, {57,76,-40}, {57,77,-40}, 
    {57,16,-40}, {57,19,-90}, {57,20,-50}, {57,80,-50}, {57,81,-50}, 
    {57,82,-50}, {57,83,-50}, {57,21,-80}, {57,22,-60}, {57,24,-110}, 
    {57,84,-110}, {57,85,-110}, {57,46,-30}, {57,115,-30}, 
    {57,116,-30}, {57,117,-30}, {57,118,-30}, {57,47,-40}, {57,48,-30}, 
    {57,50,-30}, {57,119,-30}, {57,120,-30}, {58,2,-40}, {58,59,-40}, 
    {58,6,-50}, {58,14,-40}, {58,72,-40}, {58,73,-40}, {58,74,-40}, 
    {58,75,-40}, {58,76,-40}, {58,77,-40}, {58,16,-40}, {58,19,-90}, 
    {58,20,-50}, {58,80,-50}, {58,81,-50}, {58,82,-50}, {58,83,-50}, 
    {58,21,-80}, {58,22,-60}, {58,24,-110}, {58,84,-110}, {58,85,-110}, 
    {58,46,-30}, {58,115,-30}, {58,116,-30}, {58,117,-30}, 
    {58,118,-30}, {58,47,-40}, {58,48,-30}, {58,50,-30}, {58,119,-30}, 
    {58,120,-30}, {1,0,-30}, {1,53,-30}, {1,54,-30}, {1,55,-30}, 
    {1,56,-30}, {1,57,-30}, {1,58,-30}, {1,20,-10}, {1,80,-10}, 
    {1,81,-10}, {1,82,-10}, {1,83,-10}, {3,0,-40}, {3,53,-40}, 
    {3,54,-40}, {3,55,-40}, {3,56,-40}, {3,57,-40}, {3,58,-40}, 
    {3,21,-40}, {3,22,-40}, {3,24,-70}, {3,84,-70}, {3,85,-70}, 
    {3,142,-30}, {3,194,-30}, {5,0,-80}, {5,53,-80}, {5,54,-80}, 
    {5,55,-80}, {5,56,-80}, {5,57,-80}, {5,58,-80}, {5,26,-20}, 
    {5,88,-20}, {5,89,-20}, {5,90,-20}, {5,91,-20}, {5,92,-20}, 
    {5,93,-20}, {5,142,-100}, {5,194,-100}, {9,0,-20}, {9,53,-20}, 
    {9,54,-20}, {9,55,-20}, {9,56,-20}, {9,57,-20}, {9,58,-20}, 
    {9,142,-20}, {9,194,-20}, {9,46,-20}, {9,115,-20}, {9,116,-20}, 
    {9,117,-20}, {9,118,-20}, {10,14,-30}, {10,72,-30}, {10,73,-30}, 
    {10,74,-30}, {10,75,-30}, {10,76,-30}, {10,77,-30}, {10,30,-15}, 
    {10,95,-15}, {10,96,-15}, {10,97,-15}, {10,98,-15}, {10,40,-35}, 
    {10,107,-35}, {10,108,-35}, {10,109,-35}, {10,110,-35}, 
    {10,111,-35}, {10,112,-35}, {10,46,-30}, {10,115,-30}, 
    {10,116,-30}, {10,117,-30}, {10,118,-30}, {10,50,-40}, 
    {10,119,-40}, {10,120,-40}, {11,19,-90}, {11,21,-110}, {11,22,-80}, 
    {11,24,-120}, {11,84,-120}, {11,85,-120}, {11,204,-140}, 
    {11,206,-140}, {11,50,-30}, {11,119,-30}, {11,120,-30}, 
    {69,19,-90}, {69,21,-110}, {69,22,-80}, {69,24,-120}, {69,84,-120}, 
    {69,85,-120}, {69,204,-140}, {69,206,-140}, {69,50,-30}, 
    {69,119,-30}, {69,120,-30}, {14,0,-50}, {14,53,-50}, {14,54,-50}, 
    {14,55,-50}, {14,56,-50}, {14,57,-50}, {14,58,-50}, {14,19,-40}, 
    {14,21,-50}, {14,22,-50}, {14,23,-50}, {14,24,-70}, {14,84,-70}, 
    {14,85,-70}, {14,142,-40}, {14,194,-40}, {72,0,-50}, {72,53,-50}, 
    {72,54,-50}, {72,55,-50}, {72,56,-50}, {72,57,-50}, {72,58,-50}, 
    {72,19,-40}, {72,21,-50}, {72,22,-50}, {72,23,-50}, {72,24,-70}, 
    {72,84,-70}, {72,85,-70}, {72,142,-40}, {72,194,-40}, {73,0,-50}, 
    {73,53,-50}, {73,54,-50}, {73,55,-50}, {73,56,-50}, {73,57,-50}, 
    {73,58,-50}, {73,19,-40}, {73,21,-50}, {73,22,-50}, {73,23,-50}, 
    {73,24,-70}, {73,84,-70}, {73,85,-70}, {73,142,-40}, {73,194,-40}, 
    {74,0,-50}, {74,53,-50}, {74,54,-50}, {74,55,-50}, {74,56,-50}, 
    {74,57,-50}, {74,58,-50}, {74,19,-40}, {74,21,-50}, {74,22,-50}, 
    {74,23,-50}, {74,24,-70}, {74,84,-70}, {74,85,-70}, {74,142,-40}, 
    {74,194,-40}, {75,0,-50}, {75,53,-50}, {75,54,-50}, {75,55,-50}, 
    {75,56,-50}, {75,57,-50}, {75,58,-50}, {75,19,-40}, {75,21,-50}, 
    {75,22,-50}, {75,23,-50}, {75,24,-70}, {75,84,-70}, {75,85,-70}, 
    {75,142,-40}, {75,194,-40}, {76,0,-50}, {76,53,-50}, {76,54,-50}, 
    {76,55,-50}, {76,56,-50}, {76,57,-50}, {76,58,-50}, {76,19,-40}, 
    {76,21,-50}, {76,22,-50}, {76,23,-50}, {76,24,-70}, {76,84,-70}, 
    {76,85,-70}, {76,142,-40}, {76,194,-40}, {77,0,-50}, {77,53,-50}, 
    {77,54,-50}, {77,55,-50}, {77,56,-50}, {77,57,-50}, {77,58,-50}, 
    {77,19,-40}, {77,21,-50}, {77,22,-50}, {77,23,-50}, {77,24,-70}, 
    {77,84,-70}, {77,85,-70}, {77,142,-40}, {77,194,-40}, {15,0,-100}, 
    {15,53,-100}, {15,54,-100}, {15,55,-100}, {15,56,-100}, 
    {15,57,-100}, {15,58,-100}, {15,26,-30}, {15,88,-30}, {15,89,-30}, 
    {15,90,-30}, {15,91,-30}, {15,92,-30}, {15,93,-30}, {15,142,-120}, 
    {15,30,-30}, {15,95,-30}, {15,96,-30}, {15,97,-30}, {15,98,-30}, 
    {15,40,-40}, {15,107,-40}, {15,108,-40}, {15,109,-40}, 
    {15,110,-40}, {15,111,-40}, {15,112,-40}, {15,194,-120}, 
    {16,20,-10}, {16,80,-10}, {16,81,-10}, {16,82,-10}, {16,83,-10}, 
    {16,142,20}, {16,194,20}, {17,14,-20}, {17,72,-20}, {17,73,-20}, 
    {17,74,-20}, {17,75,-20}, {17,76,-20}, {17,77,-20}, {17,19,-20}, 
    {17,20,-20}, {17,80,-20}, {17,81,-20}, {17,82,-20}, {17,83,-20}, 
    {17,21,-50}, {17,22,-40}, {17,24,-50}, {17,84,-50}, {17,85,-50}, 
    {19,0,-90}, {19,53,-90}, {19,54,-90}, {19,55,-90}, {19,56,-90}, 
    {19,57,-90}, {19,58,-90}, {19,14,-40}, {19,72,-40}, {19,73,-40}, 
    {19,74,-40}, {19,75,-40}, {19,76,-40}, {19,77,-40}, {19,26,-80}, 
    {19,88,-80}, {19,89,-80}, {19,90,-80}, {19,91,-80}, {19,92,-80}, 
    {19,93,-80}, {19,141,-40}, {19,142,-80}, {19,30,-60}, {19,95,-60}, 
    {19,96,-60}, {19,97,-60}, {19,98,-60}, {19,174,-120}, {19,40,-80}, 
    {19,107,-80}, {19,108,-80}, {19,109,-80}, {19,110,-80}, 
    {19,111,-80}, {19,112,-80}, {19,194,-80}, {19,43,-80}, 
    {19,212,-40}, {19,46,-90}, {19,115,-90}, {19,116,-90}, 
    {19,117,-90}, {19,118,-90}, {19,48,-60}, {19,50,-60}, {19,119,-60}, 
    {19,120,-60}, {20,0,-50}, {20,53,-50}, {20,54,-50}, {20,55,-50}, 
    {20,56,-50}, {20,57,-50}, {20,58,-50}, {20,142,-30}, {20,194,-30}, 
    {80,0,-50}, {80,53,-50}, {80,54,-50}, {80,55,-50}, {80,56,-50}, 
    {80,57,-50}, {80,58,-50}, {80,142,-30}, {80,194,-30}, {81,0,-50}, 
    {81,53,-50}, {81,54,-50}, {81,55,-50}, {81,56,-50}, {81,57,-50}, 
    {81,58,-50}, {81,142,-30}, {81,194,-30}, {82,0,-50}, {82,53,-50}, 
    {82,54,-50}, {82,55,-50}, {82,56,-50}, {82,57,-50}, {82,58,-50}, 
    {82,142,-30}, {82,194,-30}, {83,0,-50}, {83,53,-50}, {83,54,-50}, 
    {83,55,-50}, {83,56,-50}, {83,57,-50}, {83,58,-50}, {83,142,-30}, 
    {83,194,-30}, {21,0,-80}, {21,53,-80}, {21,54,-80}, {21,55,-80}, 
    {21,56,-80}, {21,57,-80}, {21,58,-80}, {21,6,-50}, {21,14,-50}, 
    {21,72,-50}, {21,73,-50}, {21,74,-50}, {21,75,-50}, {21,76,-50}, 
    {21,77,-50}, {21,26,-60}, {21,88,-60}, {21,89,-60}, {21,90,-60}, 
    {21,91,-60}, {21,92,-60}, {21,93,-60}, {21,141,-40}, {21,142,-120}, 
    {21,30,-50}, {21,95,-50}, {21,96,-50}, {21,97,-50}, {21,98,-50}, 
    {21,174,-80}, {21,40,-90}, {21,107,-90}, {21,108,-90}, 
    {21,109,-90}, {21,110,-90}, {21,111,-90}, {21,112,-90}, 
    {21,194,-120}, {21,212,-40}, {21,46,-60}, {21,115,-60}, 
    {21,116,-60}, {21,117,-60}, {21,118,-60}, {22,0,-60}, {22,53,-60}, 
    {22,54,-60}, {22,55,-60}, {22,56,-60}, {22,57,-60}, {22,58,-60}, 
    {22,14,-20}, {22,72,-20}, {22,73,-20}, {22,74,-20}, {22,75,-20}, 
    {22,76,-20}, {22,77,-20}, {22,26,-40}, {22,88,-40}, {22,89,-40}, 
    {22,90,-40}, {22,91,-40}, {22,92,-40}, {22,93,-40}, {22,141,-10}, 
    {22,142,-80}, {22,30,-35}, {22,95,-35}, {22,96,-35}, {22,97,-35}, 
    {22,98,-35}, {22,174,-40}, {22,40,-60}, {22,107,-60}, {22,108,-60}, 
    {22,109,-60}, {22,110,-60}, {22,111,-60}, {22,112,-60}, 
    {22,194,-80}, {22,212,-10}, {22,46,-45}, {22,115,-45}, 
    {22,116,-45}, {22,117,-45}, {22,118,-45}, {22,50,-20}, 
    {22,119,-20}, {22,120,-20}, {24,0,-110}, {24,53,-110}, 
    {24,54,-110}, {24,55,-110}, {24,56,-110}, {24,57,-110}, 
    {24,58,-110}, {24,14,-70}, {24,72,-70}, {24,73,-70}, {24,74,-70}, 
    {24,75,-70}, {24,76,-70}, {24,77,-70}, {24,26,-90}, {24,88,-90}, 
    {24,89,-90}, {24,90,-90}, {24,91,-90}, {24,92,-90}, {24,93,-90}, 
    {24,141,-50}, {24,142,-100}, {24,30,-80}, {24,95,-80}, {24,96,-80}, 
    {24,97,-80}, {24,98,-80}, {24,40,-100}, {24,107,-100}, 
    {24,108,-100}, {24,109,-100}, {24,110,-100}, {24,111,-100}, 
    {24,112,-100}, {24,194,-100}, {24,212,-50}, {24,46,-100}, 
    {24,115,-100}, {24,116,-100}, {24,117,-100}, {24,118,-100}, 
    {84,0,-110}, {84,53,-110}, {84,54,-110}, {84,55,-110}, 
    {84,56,-110}, {84,57,-110}, {84,58,-110}, {84,14,-70}, {84,72,-70}, 
    {84,73,-70}, {84,74,-70}, {84,75,-70}, {84,76,-70}, {84,77,-70}, 
    {84,26,-90}, {84,88,-90}, {84,89,-90}, {84,90,-90}, {84,91,-90}, 
    {84,92,-90}, {84,93,-90}, {84,141,-50}, {84,142,-100}, {84,30,-80}, 
    {84,95,-80}, {84,96,-80}, {84,97,-80}, {84,98,-80}, {84,40,-100}, 
    {84,107,-100}, {84,108,-100}, {84,109,-100}, {84,110,-100}, 
    {84,111,-100}, {84,112,-100}, {84,194,-100}, {84,212,-50}, 
    {84,46,-100}, {84,115,-100}, {84,116,-100}, {84,117,-100}, 
    {84,118,-100}, {85,0,-110}, {85,53,-110}, {85,54,-110}, 
    {85,55,-110}, {85,56,-110}, {85,57,-110}, {85,58,-110}, 
    {85,14,-70}, {85,72,-70}, {85,73,-70}, {85,74,-70}, {85,75,-70}, 
    {85,76,-70}, {85,77,-70}, {85,26,-90}, {85,88,-90}, {85,89,-90}, 
    {85,90,-90}, {85,91,-90}, {85,92,-90}, {85,93,-90}, {85,141,-50}, 
    {85,142,-100}, {85,30,-80}, {85,95,-80}, {85,96,-80}, {85,97,-80}, 
    {85,98,-80}, {85,40,-100}, {85,107,-100}, {85,108,-100}, 
    {85,109,-100}, {85,110,-100}, {85,111,-100}, {85,112,-100}, 
    {85,194,-100}, {85,212,-50}, {85,46,-100}, {85,115,-100}, 
    {85,116,-100}, {85,117,-100}, {85,118,-100}, {26,32,-10}, 
    {26,47,-15}, {26,48,-15}, {26,50,-20}, {26,119,-20}, {26,120,-20}, 
    {88,32,-10}, {88,47,-15}, {88,48,-15}, {88,50,-20}, {88,119,-20}, 
    {88,120,-20}, {89,32,-10}, {89,47,-15}, {89,48,-15}, {89,50,-20}, 
    {89,119,-20}, {89,120,-20}, {90,32,-10}, {90,47,-15}, {90,48,-15}, 
    {90,50,-20}, {90,119,-20}, {90,120,-20}, {91,32,-10}, {91,47,-15}, 
    {91,48,-15}, {91,50,-20}, {91,119,-20}, {91,120,-20}, {92,32,-10}, 
    {92,47,-15}, {92,48,-15}, {92,50,-20}, {92,119,-20}, {92,120,-20}, 
    {93,32,-10}, {93,47,-15}, {93,48,-15}, {93,50,-20}, {93,119,-20}, 
    {93,120,-20}, {27,37,-10}, {27,104,-10}, {27,46,-20}, {27,115,-20}, 
    {27,116,-20}, {27,117,-20}, {27,118,-20}, {27,47,-20}, {27,50,-20}, 
    {27,119,-20}, {27,120,-20}, {28,33,-10}, {28,36,-20}, {28,37,-20}, 
    {28,104,-20}, {28,50,-10}, {28,119,-10}, {28,120,-10}, {94,33,-10}, 
    {94,36,-20}, {94,37,-20}, {94,104,-20}, {94,50,-10}, {94,119,-10}, 
    {94,120,-10}, {141,216,-40}, {142,204,-120}, {142,206,-120}, 
    {142,216,-40}, {29,29,-10}, {29,47,-15}, {29,48,-15}, {29,50,-15}, 
    {29,119,-15}, {29,120,-15}, {30,142,10}, {30,194,20}, {30,47,-15}, 
    {30,48,-15}, {30,49,-15}, {30,50,-15}, {30,119,-15}, {30,120,-15}, 
    {95,142,10}, {95,194,20}, {95,47,-15}, {95,48,-15}, {95,49,-15}, 
    {95,50,-15}, {95,119,-15}, {95,120,-15}, {96,142,10}, {96,194,20}, 
    {96,47,-15}, {96,48,-15}, {96,49,-15}, {96,50,-15}, {96,119,-15}, 
    {96,120,-15}, {97,142,10}, {97,194,20}, {97,47,-15}, {97,48,-15}, 
    {97,49,-15}, {97,50,-15}, {97,119,-15}, {97,120,-15}, {98,142,10}, 
    {98,194,20}, {98,47,-15}, {98,48,-15}, {98,49,-15}, {98,50,-15}, 
    {98,119,-15}, {98,120,-15}, {31,142,-10}, {31,30,-10}, {31,95,-10}, 
    {31,96,-10}, {31,97,-10}, {31,98,-10}, {31,40,-20}, {31,107,-20}, 
    {31,108,-20}, {31,109,-20}, {31,110,-20}, {31,111,-20}, 
    {31,112,-20}, {31,194,-10}, {31,204,30}, {31,206,30}, {32,30,10}, 
    {32,95,10}, {32,96,10}, {32,97,10}, {32,98,10}, {32,32,-10}, 
    {33,50,-20}, {33,119,-20}, {33,120,-20}, {36,40,-15}, {36,107,-15}, 
    {36,108,-15}, {36,109,-15}, {36,110,-15}, {36,111,-15}, 
    {36,112,-15}, {37,48,-15}, {37,50,-15}, {37,119,-15}, {37,120,-15}, 
    {104,48,-15}, {104,50,-15}, {104,119,-15}, {104,120,-15}, 
    {38,46,-20}, {38,115,-20}, {38,116,-20}, {38,117,-20}, 
    {38,118,-20}, {38,50,-30}, {38,119,-30}, {38,120,-30}, {39,46,-10}, 
    {39,115,-10}, {39,116,-10}, {39,117,-10}, {39,118,-10}, 
    {39,47,-40}, {39,50,-20}, {39,119,-20}, {39,120,-20}, {105,46,-10}, 
    {105,115,-10}, {105,116,-10}, {105,117,-10}, {105,118,-10}, 
    {105,47,-40}, {105,50,-20}, {105,119,-20}, {105,120,-20}, 
    {40,47,-20}, {40,48,-15}, {40,49,-30}, {40,50,-20}, {40,119,-20}, 
    {40,120,-20}, {107,47,-20}, {107,48,-15}, {107,49,-30}, 
    {107,50,-20}, {107,119,-20}, {107,120,-20}, {108,47,-20}, 
    {108,48,-15}, {108,49,-30}, {108,50,-20}, {108,119,-20}, 
    {108,120,-20}, {109,47,-20}, {109,48,-15}, {109,49,-30}, 
    {109,50,-20}, {109,119,-20}, {109,120,-20}, {110,47,-20}, 
    {110,48,-15}, {110,49,-30}, {110,50,-20}, {110,119,-20}, 
    {110,120,-20}, {111,47,-20}, {111,48,-15}, {111,49,-30}, 
    {111,50,-20}, {111,119,-20}, {111,120,-20}, {112,47,-20}, 
    {112,48,-15}, {112,49,-30}, {112,50,-20}, {112,119,-20}, 
    {112,120,-20}, {41,50,-15}, {41,119,-15}, {41,120,-15}, 
    {194,204,-120}, {194,206,-120}, {194,216,-40}, {204,216,-80}, 
    {205,205,-46}, {206,29,-80}, {206,37,-20}, {206,104,-20}, 
    {206,206,-46}, {206,43,-40}, {206,44,-60}, {206,113,-60}, 
    {206,216,-80}, {206,47,-20}, {43,28,-20}, {43,94,-20}, 
    {43,142,-60}, {43,29,-20}, {43,32,-15}, {43,174,-20}, {43,40,-20}, 
    {43,107,-20}, {43,108,-20}, {43,109,-20}, {43,110,-20}, 
    {43,111,-20}, {43,112,-20}, {43,194,-60}, {43,42,-20}, {43,44,-15}, 
    {43,113,-15}, {43,45,20}, {43,47,10}, {43,50,10}, {43,119,10}, 
    {43,120,10}, {44,48,-15}, {113,48,-15}, {212,216,-40}, 
    {216,19,-100}, {216,21,-80}, {216,22,-80}, {216,24,-120}, 
    {216,84,-120}, {216,85,-120}, {216,203,-80}, {216,205,-60}, 
    {47,26,-20}, {47,88,-20}, {47,89,-20}, {47,90,-20}, {47,91,-20}, 
    {47,92,-20}, {47,93,-20}, {47,142,-80}, {47,40,-30}, {47,107,-30}, 
    {47,108,-30}, {47,109,-30}, {47,110,-30}, {47,111,-30}, 
    {47,112,-30}, {47,194,-80}, {48,142,-40}, {48,40,-20}, 
    {48,107,-20}, {48,108,-20}, {48,109,-20}, {48,110,-20}, 
    {48,111,-20}, {48,112,-20}, {48,194,-40}, {49,30,-10}, {49,95,-10}, 
    {49,96,-10}, {49,97,-10}, {49,98,-10}, {50,26,-30}, {50,88,-30}, 
    {50,89,-30}, {50,90,-30}, {50,91,-30}, {50,92,-30}, {50,93,-30}, 
    {50,142,-80}, {50,30,-10}, {50,95,-10}, {50,96,-10}, {50,97,-10}, 
    {50,98,-10}, {50,40,-25}, {50,107,-25}, {50,108,-25}, {50,109,-25}, 
    {50,110,-25}, {50,111,-25}, {50,112,-25}, {50,194,-80}, 
    {119,26,-30}, {119,88,-30}, {119,89,-30}, {119,90,-30}, 
    {119,91,-30}, {119,92,-30}, {119,93,-30}, {119,142,-80}, 
    {119,30,-10}, {119,95,-10}, {119,96,-10}, {119,97,-10}, 
    {119,98,-10}, {119,40,-25}, {119,107,-25}, {119,108,-25}, 
    {119,109,-25}, {119,110,-25}, {119,111,-25}, {119,112,-25}, 
    {119,194,-80}, {120,26,-30}, {120,88,-30}, {120,89,-30}, 
    {120,90,-30}, {120,91,-30}, {120,92,-30}, {120,93,-30}, 
    {120,142,-80}, {120,30,-10}, {120,95,-10}, {120,96,-10}, 
    {120,97,-10}, {120,98,-10}, {120,40,-25}, {120,107,-25}, 
    {120,108,-25}, {120,109,-25}, {120,110,-25}, {120,111,-25}, 
    {120,112,-25}, {120,194,-80}, {51,30,10}, {51,95,10}, {51,96,10}, 
    {51,97,10}, {51,98,10}, {121,30,10}, {121,95,10}, {121,96,10}, 
    {121,97,10}, {121,98,10}, 
    {0xFFFF,0xFFFF,0}
};
static const kern_pair helvetica_boldoblique_kerns[] = {
    {0,2,-40}, {0,59,-40}, {0,6,-50}, {0,14,-40}, {0,72,-40}, 
    {0,73,-40}, {0,74,-40}, {0,75,-40}, {0,76,-40}, {0,77,-40}, 
    {0,16,-40}, {0,19,-90}, {0,20,-50}, {0,80,-50}, {0,81,-50}, 
    {0,82,-50}, {0,83,-50}, {0,21,-80}, {0,22,-60}, {0,24,-110}, 
    {0,84,-110}, {0,85,-110}, {0,46,-30}, {0,115,-30}, {0,116,-30}, 
    {0,117,-30}, {0,118,-30}, {0,47,-40}, {0,48,-30}, {0,50,-30}, 
    {0,119,-30}, {0,120,-30}, {53,2,-40}, {53,59,-40}, {53,6,-50}, 
    {53,14,-40}, {53,72,-40}, {53,73,-40}, {53,74,-40}, {53,75,-40}, 
    {53,76,-40}, {53,77,-40}, {53,16,-40}, {53,19,-90}, {53,20,-50}, 
    {53,80,-50}, {53,81,-50}, {53,82,-50}, {53,83,-50}, {53,21,-80}, 
    {53,22,-60}, {53,24,-110}, {53,84,-110}, {53,85,-110}, {53,46,-30}, 
    {53,115,-30}, {53,116,-30}, {53,117,-30}, {53,118,-30}, 
    {53,47,-40}, {53,48,-30}, {53,50,-30}, {53,119,-30}, {53,120,-30}, 
    {54,2,-40}, {54,59,-40}, {54,6,-50}, {54,14,-40}, {54,72,-40}, 
    {54,73,-40}, {54,74,-40}, {54,75,-40}, {54,76,-40}, {54,77,-40}, 
    {54,16,-40}, {54,19,-90}, {54,20,-50}, {54,80,-50}, {54,81,-50}, 
    {54,82,-50}, {54,83,-50}, {54,21,-80}, {54,22,-60}, {54,24,-110}, 
    {54,84,-110}, {54,85,-110}, {54,46,-30}, {54,115,-30}, 
    {54,116,-30}, {54,117,-30}, {54,118,-30}, {54,47,-40}, {54,48,-30}, 
    {54,50,-30}, {54,119,-30}, {54,120,-30}, {55,2,-40}, {55,59,-40}, 
    {55,6,-50}, {55,14,-40}, {55,72,-40}, {55,73,-40}, {55,74,-40}, 
    {55,75,-40}, {55,76,-40}, {55,77,-40}, {55,16,-40}, {55,19,-90}, 
    {55,20,-50}, {55,80,-50}, {55,81,-50}, {55,82,-50}, {55,83,-50}, 
    {55,21,-80}, {55,22,-60}, {55,24,-110}, {55,84,-110}, {55,85,-110}, 
    {55,46,-30}, {55,115,-30}, {55,116,-30}, {55,117,-30}, 
    {55,118,-30}, {55,47,-40}, {55,48,-30}, {55,50,-30}, {55,119,-30}, 
    {55,120,-30}, {56,2,-40}, {56,59,-40}, {56,6,-50}, {56,14,-40}, 
    {56,72,-40}, {56,73,-40}, {56,74,-40}, {56,75,-40}, {56,76,-40}, 
    {56,77,-40}, {56,16,-40}, {56,19,-90}, {56,20,-50}, {56,80,-50}, 
    {56,81,-50}, {56,82,-50}, {56,83,-50}, {56,21,-80}, {56,22,-60}, 
    {56,24,-110}, {56,84,-110}, {56,85,-110}, {56,46,-30}, 
    {56,115,-30}, {56,116,-30}, {56,117,-30}, {56,118,-30}, 
    {56,47,-40}, {56,48,-30}, {56,50,-30}, {56,119,-30}, {56,120,-30}, 
    {57,2,-40}, {57,59,-40}, {57,6,-50}, {57,14,-40}, {57,72,-40}, 
    {57,73,-40}, {57,74,-40}, {57,75,-40}, {57,76,-40}, {57,77,-40}, 
    {57,16,-40}, {57,19,-90}, {57,20,-50}, {57,80,-50}, {57,81,-50}, 
    {57,82,-50}, {57,83,-50}, {57,21,-80}, {57,22,-60}, {57,24,-110}, 
    {57,84,-110}, {57,85,-110}, {57,46,-30}, {57,115,-30}, 
    {57,116,-30}, {57,117,-30}, {57,118,-30}, {57,47,-40}, {57,48,-30}, 
    {57,50,-30}, {57,119,-30}, {57,120,-30}, {58,2,-40}, {58,59,-40}, 
    {58,6,-50}, {58,14,-40}, {58,72,-40}, {58,73,-40}, {58,74,-40}, 
    {58,75,-40}, {58,76,-40}, {58,77,-40}, {58,16,-40}, {58,19,-90}, 
    {58,20,-50}, {58,80,-50}, {58,81,-50}, {58,82,-50}, {58,83,-50}, 
    {58,21,-80}, {58,22,-60}, {58,24,-110}, {58,84,-110}, {58,85,-110}, 
    {58,46,-30}, {58,115,-30}, {58,116,-30}, {58,117,-30}, 
    {58,118,-30}, {58,47,-40}, {58,48,-30}, {58,50,-30}, {58,119,-30}, 
    {58,120,-30}, {1,0,-30}, {1,53,-30}, {1,54,-30}, {1,55,-30}, 
    {1,56,-30}, {1,57,-30}, {1,58,-30}, {1,20,-10}, {1,80,-10}, 
    {1,81,-10}, {1,82,-10}, {1,83,-10}, {3,0,-40}, {3,53,-40}, 
    {3,54,-40}, {3,55,-40}, {3,56,-40}, {3,57,-40}, {3,58,-40}, 
    {3,21,-40}, {3,22,-40}, {3,24,-70}, {3,84,-70}, {3,85,-70}, 
    {3,142,-30}, {3,194,-30}, {5,0,-80}, {5,53,-80}, {5,54,-80}, 
    {5,55,-80}, {5,56,-80}, {5,57,-80}, {5,58,-80}, {5,26,-20}, 
    {5,88,-20}, {5,89,-20}, {5,90,-20}, {5,91,-20}, {5,92,-20}, 
    {5,93,-20}, {5,142,-100}, {5,194,-100}, {9,0,-20}, {9,53,-20}, 
    {9,54,-20}, {9,55,-20}, {9,56,-20}, {9,57,-20}, {9,58,-20}, 
    {9,142,-20}, {9,194,-20}, {9,46,-20}, {9,115,-20}, {9,116,-20}, 
    {9,117,-20}, {9,118,-20}, {10,14,-30}, {10,72,-30}, {10,73,-30}, 
    {10,74,-30}, {10,75,-30}, {10,76,-30}, {10,77,-30}, {10,30,-15}, 
    {10,95,-15}, {10,96,-15}, {10,97,-15}, {10,98,-15}, {10,40,-35}, 
    {10,107,-35}, {10,108,-35}, {10,109,-35}, {10,110,-35}, 
    {10,111,-35}, {10,112,-35}, {10,46,-30}, {10,115,-30}, 
    {10,116,-30}, {10,117,-30}, {10,118,-30}, {10,50,-40}, 
    {10,119,-40}, {10,120,-40}, {11,19,-90}, {11,21,-110}, {11,22,-80}, 
    {11,24,-120}, {11,84,-120}, {11,85,-120}, {11,204,-140}, 
    {11,206,-140}, {11,50,-30}, {11,119,-30}, {11,120,-30}, 
    {69,19,-90}, {69,21,-110}, {69,22,-80}, {69,24,-120}, {69,84,-120}, 
    {69,85,-120}, {69,204,-140}, {69,206,-140}, {69,50,-30}, 
    {69,119,-30}, {69,120,-30}, {14,0,-50}, {14,53,-50}, {14,54,-50}, 
    {14,55,-50}, {14,56,-50}, {14,57,-50}, {14,58,-50}, {14,19,-40}, 
    {14,21,-50}, {14,22,-50}, {14,23,-50}, {14,24,-70}, {14,84,-70}, 
    {14,85,-70}, {14,142,-40}, {14,194,-40}, {72,0,-50}, {72,53,-50}, 
    {72,54,-50}, {72,55,-50}, {72,56,-50}, {72,57,-50}, {72,58,-50}, 
    {72,19,-40}, {72,21,-50}, {72,22,-50}, {72,23,-50}, {72,24,-70}, 
    {72,84,-70}, {72,85,-70}, {72,142,-40}, {72,194,-40}, {73,0,-50}, 
    {73,53,-50}, {73,54,-50}, {73,55,-50}, {73,56,-50}, {73,57,-50}, 
    {73,58,-50}, {73,19,-40}, {73,21,-50}, {73,22,-50}, {73,23,-50}, 
    {73,24,-70}, {73,84,-70}, {73,85,-70}, {73,142,-40}, {73,194,-40}, 
    {74,0,-50}, {74,53,-50}, {74,54,-50}, {74,55,-50}, {74,56,-50}, 
    {74,57,-50}, {74,58,-50}, {74,19,-40}, {74,21,-50}, {74,22,-50}, 
    {74,23,-50}, {74,24,-70}, {74,84,-70}, {74,85,-70}, {74,142,-40}, 
    {74,194,-40}, {75,0,-50}, {75,53,-50}, {75,54,-50}, {75,55,-50}, 
    {75,56,-50}, {75,57,-50}, {75,58,-50}, {75,19,-40}, {75,21,-50}, 
    {75,22,-50}, {75,23,-50}, {75,24,-70}, {75,84,-70}, {75,85,-70}, 
    {75,142,-40}, {75,194,-40}, {76,0,-50}, {76,53,-50}, {76,54,-50}, 
    {76,55,-50}, {76,56,-50}, {76,57,-50}, {76,58,-50}, {76,19,-40}, 
    {76,21,-50}, {76,22,-50}, {76,23,-50}, {76,24,-70}, {76,84,-70}, 
    {76,85,-70}, {76,142,-40}, {76,194,-40}, {77,0,-50}, {77,53,-50}, 
    {77,54,-50}, {77,55,-50}, {77,56,-50}, {77,57,-50}, {77,58,-50}, 
    {77,19,-40}, {77,21,-50}, {77,22,-50}, {77,23,-50}, {77,24,-70}, 
    {77,84,-70}, {77,85,-70}, {77,142,-40}, {77,194,-40}, {15,0,-100}, 
    {15,53,-100}, {15,54,-100}, {15,55,-100}, {15,56,-100}, 
    {15,57,-100}, {15,58,-100}, {15,26,-30}, {15,88,-30}, {15,89,-30}, 
    {15,90,-30}, {15,91,-30}, {15,92,-30}, {15,93,-30}, {15,142,-120}, 
    {15,30,-30}, {15,95,-30}, {15,96,-30}, {15,97,-30}, {15,98,-30}, 
    {15,40,-40}, {15,107,-40}, {15,108,-40}, {15,109,-40}, 
    {15,110,-40}, {15,111,-40}, {15,112,-40}, {15,194,-120}, 
    {16,20,-10}, {16,80,-10}, {16,81,-10}, {16,82,-10}, {16,83,-10}, 
    {16,142,20}, {16,194,20}, {17,14,-20}, {17,72,-20}, {17,73,-20}, 
    {17,74,-20}, {17,75,-20}, {17,76,-20}, {17,77,-20}, {17,19,-20}, 
    {17,20,-20}, {17,80,-20}, {17,81,-20}, {17,82,-20}, {17,83,-20}, 
    {17,21,-50}, {17,22,-40}, {17,24,-50}, {17,84,-50}, {17,85,-50}, 
    {19,0,-90}, {19,53,-90}, {19,54,-90}, {19,55,-90}, {19,56,-90}, 
    {19,57,-90}, {19,58,-90}, {19,14,-40}, {19,72,-40}, {19,73,-40}, 
    {19,74,-40}, {19,75,-40}, {19,76,-40}, {19,77,-40}, {19,26,-80}, 
    {19,88,-80}, {19,89,-80}, {19,90,-80}, {19,91,-80}, {19,92,-80}, 
    {19,93,-80}, {19,141,-40}, {19,142,-80}, {19,30,-60}, {19,95,-60}, 
    {19,96,-60}, {19,97,-60}, {19,98,-60}, {19,174,-120}, {19,40,-80}, 
    {19,107,-80}, {19,108,-80}, {19,109,-80}, {19,110,-80}, 
    {19,111,-80}, {19,112,-80}, {19,194,-80}, {19,43,-80}, 
    {19,212,-40}, {19,46,-90}, {19,115,-90}, {19,116,-90}, 
    {19,117,-90}, {19,118,-90}, {19,48,-60}, {19,50,-60}, {19,119,-60}, 
    {19,120,-60}, {20,0,-50}, {20,53,-50}, {20,54,-50}, {20,55,-50}, 
    {20,56,-50}, {20,57,-50}, {20,58,-50}, {20,142,-30}, {20,194,-30}, 
    {80,0,-50}, {80,53,-50}, {80,54,-50}, {80,55,-50}, {80,56,-50}, 
    {80,57,-50}, {80,58,-50}, {80,142,-30}, {80,194,-30}, {81,0,-50}, 
    {81,53,-50}, {81,54,-50}, {81,55,-50}, {81,56,-50}, {81,57,-50}, 
    {81,58,-50}, {81,142,-30}, {81,194,-30}, {82,0,-50}, {82,53,-50}, 
    {82,54,-50}, {82,55,-50}, {82,56,-50}, {82,57,-50}, {82,58,-50}, 
    {82,142,-30}, {82,194,-30}, {83,0,-50}, {83,53,-50}, {83,54,-50}, 
    {83,55,-50}, {83,56,-50}, {83,57,-50}, {83,58,-50}, {83,142,-30}, 
    {83,194,-30}, {21,0,-80}, {21,53,-80}, {21,54,-80}, {21,55,-80}, 
    {21,56,-80}, {21,57,-80}, {21,58,-80}, {21,6,-50}, {21,14,-50}, 
    {21,72,-50}, {21,73,-50}, {21,74,-50}, {21,75,-50}, {21,76,-50}, 
    {21,77,-50}, {21,26,-60}, {21,88,-60}, {21,89,-60}, {21,90,-60}, 
    {21,91,-60}, {21,92,-60}, {21,93,-60}, {21,141,-40}, {21,142,-120}, 
    {21,30,-50}, {21,95,-50}, {21,96,-50}, {21,97,-50}, {21,98,-50}, 
    {21,174,-80}, {21,40,-90}, {21,107,-90}, {21,108,-90}, 
    {21,109,-90}, {21,110,-90}, {21,111,-90}, {21,112,-90}, 
    {21,194,-120}, {21,212,-40}, {21,46,-60}, {21,115,-60}, 
    {21,116,-60}, {21,117,-60}, {21,118,-60}, {22,0,-60}, {22,53,-60}, 
    {22,54,-60}, {22,55,-60}, {22,56,-60}, {22,57,-60}, {22,58,-60}, 
    {22,14,-20}, {22,72,-20}, {22,73,-20}, {22,74,-20}, {22,75,-20}, 
    {22,76,-20}, {22,77,-20}, {22,26,-40}, {22,88,-40}, {22,89,-40}, 
    {22,90,-40}, {22,91,-40}, {22,92,-40}, {22,93,-40}, {22,141,-10}, 
    {22,142,-80}, {22,30,-35}, {22,95,-35}, {22,96,-35}, {22,97,-35}, 
    {22,98,-35}, {22,174,-40}, {22,40,-60}, {22,107,-60}, {22,108,-60}, 
    {22,109,-60}, {22,110,-60}, {22,111,-60}, {22,112,-60}, 
    {22,194,-80}, {22,212,-10}, {22,46,-45}, {22,115,-45}, 
    {22,116,-45}, {22,117,-45}, {22,118,-45}, {22,50,-20}, 
    {22,119,-20}, {22,120,-20}, {24,0,-110}, {24,53,-110}, 
    {24,54,-110}, {24,55,-110}, {24,56,-110}, {24,57,-110}, 
    {24,58,-110}, {24,14,-70}, {24,72,-70}, {24,73,-70}, {24,74,-70}, 
    {24,75,-70}, {24,76,-70}, {24,77,-70}, {24,26,-90}, {24,88,-90}, 
    {24,89,-90}, {24,90,-90}, {24,91,-90}, {24,92,-90}, {24,93,-90}, 
    {24,141,-50}, {24,142,-100}, {24,30,-80}, {24,95,-80}, {24,96,-80}, 
    {24,97,-80}, {24,98,-80}, {24,40,-100}, {24,107,-100}, 
    {24,108,-100}, {24,109,-100}, {24,110,-100}, {24,111,-100}, 
    {24,112,-100}, {24,194,-100}, {24,212,-50}, {24,46,-100}, 
    {24,115,-100}, {24,116,-100}, {24,117,-100}, {24,118,-100}, 
    {84,0,-110}, {84,53,-110}, {84,54,-110}, {84,55,-110}, 
    {84,56,-110}, {84,57,-110}, {84,58,-110}, {84,14,-70}, {84,72,-70}, 
    {84,73,-70}, {84,74,-70}, {84,75,-70}, {84,76,-70}, {84,77,-70}, 
    {84,26,-90}, {84,88,-90}, {84,89,-90}, {84,90,-90}, {84,91,-90}, 
    {84,92,-90}, {84,93,-90}, {84,141,-50}, {84,142,-100}, {84,30,-80}, 
    {84,95,-80}, {84,96,-80}, {84,97,-80}, {84,98,-80}, {84,40,-100}, 
    {84,107,-100}, {84,108,-100}, {84,109,-100}, {84,110,-100}, 
    {84,111,-100}, {84,112,-100}, {84,194,-100}, {84,212,-50}, 
    {84,46,-100}, {84,115,-100}, {84,116,-100}, {84,117,-100}, 
    {84,118,-100}, {85,0,-110}, {85,53,-110}, {85,54,-110}, 
    {85,55,-110}, {85,56,-110}, {85,57,-110}, {85,58,-110}, 
    {85,14,-70}, {85,72,-70}, {85,73,-70}, {85,74,-70}, {85,75,-70}, 
    {85,76,-70}, {85,77,-70}, {85,26,-90}, {85,88,-90}, {85,89,-90}, 
    {85,90,-90}, {85,91,-90}, {85,92,-90}, {85,93,-90}, {85,141,-50}, 
    {85,142,-100}, {85,30,-80}, {85,95,-80}, {85,96,-80}, {85,97,-80}, 
    {85,98,-80}, {85,40,-100}, {85,107,-100}, {85,108,-100}, 
    {85,109,-100}, {85,110,-100}, {85,111,-100}, {85,112,-100}, 
    {85,194,-100}, {85,212,-50}, {85,46,-100}, {85,115,-100}, 
    {85,116,-100}, {85,117,-100}, {85,118,-100}, {26,32,-10}, 
    {26,47,-15}, {26,48,-15}, {26,50,-20}, {26,119,-20}, {26,120,-20}, 
    {88,32,-10}, {88,47,-15}, {88,48,-15}, {88,50,-20}, {88,119,-20}, 
    {88,120,-20}, {89,32,-10}, {89,47,-15}, {89,48,-15}, {89,50,-20}, 
    {89,119,-20}, {89,120,-20}, {90,32,-10}, {90,47,-15}, {90,48,-15}, 
    {90,50,-20}, {90,119,-20}, {90,120,-20}, {91,32,-10}, {91,47,-15}, 
    {91,48,-15}, {91,50,-20}, {91,119,-20}, {91,120,-20}, {92,32,-10}, 
    {92,47,-15}, {92,48,-15}, {92,50,-20}, {92,119,-20}, {92,120,-20}, 
    {93,32,-10}, {93,47,-15}, {93,48,-15}, {93,50,-20}, {93,119,-20}, 
    {93,120,-20}, {27,37,-10}, {27,104,-10}, {27,46,-20}, {27,115,-20}, 
    {27,116,-20}, {27,117,-20}, {27,118,-20}, {27,47,-20}, {27,50,-20}, 
    {27,119,-20}, {27,120,-20}, {28,33,-10}, {28,36,-20}, {28,37,-20}, 
    {28,104,-20}, {28,50,-10}, {28,119,-10}, {28,120,-10}, {94,33,-10}, 
    {94,36,-20}, {94,37,-20}, {94,104,-20}, {94,50,-10}, {94,119,-10}, 
    {94,120,-10}, {141,216,-40}, {142,204,-120}, {142,206,-120}, 
    {142,216,-40}, {29,29,-10}, {29,47,-15}, {29,48,-15}, {29,50,-15}, 
    {29,119,-15}, {29,120,-15}, {30,142,10}, {30,194,20}, {30,47,-15}, 
    {30,48,-15}, {30,49,-15}, {30,50,-15}, {30,119,-15}, {30,120,-15}, 
    {95,142,10}, {95,194,20}, {95,47,-15}, {95,48,-15}, {95,49,-15}, 
    {95,50,-15}, {95,119,-15}, {95,120,-15}, {96,142,10}, {96,194,20}, 
    {96,47,-15}, {96,48,-15}, {96,49,-15}, {96,50,-15}, {96,119,-15}, 
    {96,120,-15}, {97,142,10}, {97,194,20}, {97,47,-15}, {97,48,-15}, 
    {97,49,-15}, {97,50,-15}, {97,119,-15}, {97,120,-15}, {98,142,10}, 
    {98,194,20}, {98,47,-15}, {98,48,-15}, {98,49,-15}, {98,50,-15}, 
    {98,119,-15}, {98,120,-15}, {31,142,-10}, {31,30,-10}, {31,95,-10}, 
    {31,96,-10}, {31,97,-10}, {31,98,-10}, {31,40,-20}, {31,107,-20}, 
    {31,108,-20}, {31,109,-20}, {31,110,-20}, {31,111,-20}, 
    {31,112,-20}, {31,194,-10}, {31,204,30}, {31,206,30}, {32,30,10}, 
    {32,95,10}, {32,96,10}, {32,97,10}, {32,98,10}, {32,32,-10}, 
    {33,50,-20}, {33,119,-20}, {33,120,-20}, {36,40,-15}, {36,107,-15}, 
    {36,108,-15}, {36,109,-15}, {36,110,-15}, {36,111,-15}, 
    {36,112,-15}, {37,48,-15}, {37,50,-15}, {37,119,-15}, {37,120,-15}, 
    {104,48,-15}, {104,50,-15}, {104,119,-15}, {104,120,-15}, 
    {38,46,-20}, {38,115,-20}, {38,116,-20}, {38,117,-20}, 
    {38,118,-20}, {38,50,-30}, {38,119,-30}, {38,120,-30}, {39,46,-10}, 
    {39,115,-10}, {39,116,-10}, {39,117,-10}, {39,118,-10}, 
    {39,47,-40}, {39,50,-20}, {39,119,-20}, {39,120,-20}, {105,46,-10}, 
    {105,115,-10}, {105,116,-10}, {105,117,-10}, {105,118,-10}, 
    {105,47,-40}, {105,50,-20}, {105,119,-20}, {105,120,-20}, 
    {40,47,-20}, {40,48,-15}, {40,49,-30}, {40,50,-20}, {40,119,-20}, 
    {40,120,-20}, {107,47,-20}, {107,48,-15}, {107,49,-30}, 
    {107,50,-20}, {107,119,-20}, {107,120,-20}, {108,47,-20}, 
    {108,48,-15}, {108,49,-30}, {108,50,-20}, {108,119,-20}, 
    {108,120,-20}, {109,47,-20}, {109,48,-15}, {109,49,-30}, 
    {109,50,-20}, {109,119,-20}, {109,120,-20}, {110,47,-20}, 
    {110,48,-15}, {110,49,-30}, {110,50,-20}, {110,119,-20}, 
    {110,120,-20}, {111,47,-20}, {111,48,-15}, {111,49,-30}, 
    {111,50,-20}, {111,119,-20}, {111,120,-20}, {112,47,-20}, 
    {112,48,-15}, {112,49,-30}, {112,50,-20}, {112,119,-20}, 
    {112,120,-20}, {41,50,-15}, {41,119,-15}, {41,120,-15}, 
    {194,204,-120}, {194,206,-120}, {194,216,-40}, {204,216,-80}, 
    {205,205,-46}, {206,29,-80}, {206,37,-20}, {206,104,-20}, 
    {206,206,-46}, {206,43,-40}, {206,44,-60}, {206,113,-60}, 
    {206,216,-80}, {206,47,-20}, {43,28,-20}, {43,94,-20}, 
    {43,142,-60}, {43,29,-20}, {43,32,-15}, {43,174,-20}, {43,40,-20}, 
    {43,107,-20}, {43,108,-20}, {43,109,-20}, {43,110,-20}, 
    {43,111,-20}, {43,112,-20}, {43,194,-60}, {43,42,-20}, {43,44,-15}, 
    {43,113,-15}, {43,45,20}, {43,47,10}, {43,50,10}, {43,119,10}, 
    {43,120,10}, {44,48,-15}, {113,48,-15}, {212,216,-40}, 
    {216,19,-100}, {216,21,-80}, {216,22,-80}, {216,24,-120}, 
    {216,84,-120}, {216,85,-120}, {216,203,-80}, {216,205,-60}, 
    {47,26,-20}, {47,88,-20}, {47,89,-20}, {47,90,-20}, {47,91,-20}, 
    {47,92,-20}, {47,93,-20}, {47,142,-80}, {47,40,-30}, {47,107,-30}, 
    {47,108,-30}, {47,109,-30}, {47,110,-30}, {47,111,-30}, 
    {47,112,-30}, {47,194,-80}, {48,142,-40}, {48,40,-20}, 
    {48,107,-20}, {48,108,-20}, {48,109,-20}, {48,110,-20}, 
    {48,111,-20}, {48,112,-20}, {48,194,-40}, {49,30,-10}, {49,95,-10}, 
    {49,96,-10}, {49,97,-10}, {49,98,-10}, {50,26,-30}, {50,88,-30}, 
    {50,89,-30}, {50,90,-30}, {50,91,-30}, {50,92,-30}, {50,93,-30}, 
    {50,142,-80}, {50,30,-10}, {50,95,-10}, {50,96,-10}, {50,97,-10}, 
    {50,98,-10}, {50,40,-25}, {50,107,-25}, {50,108,-25}, {50,109,-25}, 
    {50,110,-25}, {50,111,-25}, {50,112,-25}, {50,194,-80}, 
    {119,26,-30}, {119,88,-30}, {119,89,-30}, {119,90,-30}, 
    {119,91,-30}, {119,92,-30}, {119,93,-30}, {119,142,-80}, 
    {119,30,-10}, {119,95,-10}, {119,96,-10}, {119,97,-10}, 
    {119,98,-10}, {119,40,-25}, {119,107,-25}, {119,108,-25}, 
    {119,109,-25}, {119,110,-25}, {119,111,-25}, {119,112,-25}, 
    {119,194,-80}, {120,26,-30}, {120,88,-30}, {120,89,-30}, 
    {120,90,-30}, {120,91,-30}, {120,92,-30}, {120,93,-30}, 
    {120,142,-80}, {120,30,-10}, {120,95,-10}, {120,96,-10}, 
    {120,97,-10}, {120,98,-10}, {120,40,-25}, {120,107,-25}, 
    {120,108,-25}, {120,109,-25}, {120,110,-25}, {120,111,-25}, 
    {120,112,-25}, {120,194,-80}, {51,30,10}, {51,95,10}, {51,96,10}, 
    {51,97,10}, {51,98,10}, {121,30,10}, {121,95,10}, {121,96,10}, 
    {121,97,10}, {121,98,10}, 
    {0xFFFF,0xFFFF,0}
};
static const kern_pair courier_kerns[] = {
    
    {0xFFFF,0xFFFF,0}
};
static const kern_pair courier_oblique_kerns[] = {
    
    {0xFFFF,0xFFFF,0}
};
static const kern_pair courier_bold_kerns[] = {
    
    {0xFFFF,0xFFFF,0}
};
static const kern_pair courier_boldoblique_kerns[] = {
    
    {0xFFFF,0xFFFF,0}
};

static const struct ps_std_font_data {
    char const *name;
    kern_pair const *kerns;
    int widths[lenof(ps_std_glyphs)-1];
} ps_std_fonts[] = {
    { "Times-Roman", times_roman_kerns, {
	722, 667, 667, 722, 611, 556, 722, 722, 333, 389, 722, 611, 889, 
	722, 722, 556, 722, 667, 556, 611, 722, 722, 944, 722, 722, 611, 
	444, 500, 444, 500, 444, 333, 500, 500, 278, 278, 500, 278, 778, 
	500, 500, 500, 500, 333, 389, 278, 500, 500, 722, 500, 500, 444, 
	889, 722, 722, 722, 722, 722, 722, 667, 611, 611, 611, 611, 722, 
	333, 333, 333, 333, 611, 722, 889, 722, 722, 722, 722, 722, 722, 
	556, 556, 722, 722, 722, 722, 722, 722, 611, 667, 444, 444, 444, 
	444, 444, 444, 444, 444, 444, 444, 444, 500, 278, 278, 278, 278, 
	278, 500, 722, 500, 500, 500, 500, 500, 500, 389, 500, 500, 500, 
	500, 500, 500, 500, 444, 333, 778, 469, 541, 500, 921, 278, 200, 
	480, 480, 333, 333, 333, 200, 350, 333, 333, 500, 333, 278, 250, 
	760, 500, 500, 500, 400, 333, 564, 500, 333, 278, 500, 1000, 1000, 
	500, 564, 333, 333, 556, 500, 556, 500, 500, 167, 500, 333, 564, 
	500, 500, 333, 333, 333, 333, 564, 564, 333, 564, 500, 564, 500, 
	500, 333, 500, 750, 750, 300, 276, 310, 453, 333, 333, 833, 250, 
	250, 1000, 564, 564, 444, 444, 408, 444, 444, 444, 333, 333, 333, 
	180, 760, 333, 500, 278, 500, 500, 278, 250, 500, 500, 750, 300, 
	333, 980, 500, 300, 500, 500, 500, 
    }},
    { "Times-Italic", times_italic_kerns, {
	611, 611, 667, 722, 611, 611, 722, 722, 333, 444, 667, 556, 833, 
	667, 722, 611, 722, 611, 500, 556, 722, 611, 833, 611, 556, 556, 
	500, 500, 444, 500, 444, 278, 500, 500, 278, 278, 444, 278, 722, 
	500, 500, 500, 500, 389, 389, 278, 500, 444, 667, 444, 444, 389, 
	889, 611, 611, 611, 611, 611, 611, 667, 611, 611, 611, 611, 722, 
	333, 333, 333, 333, 556, 667, 944, 722, 722, 722, 722, 722, 722, 
	500, 611, 722, 722, 722, 722, 556, 556, 556, 667, 500, 500, 500, 
	500, 500, 500, 444, 444, 444, 444, 444, 500, 278, 278, 278, 278, 
	278, 500, 667, 500, 500, 500, 500, 500, 500, 389, 500, 500, 500, 
	500, 500, 444, 444, 389, 333, 778, 422, 541, 500, 920, 278, 275, 
	400, 400, 389, 389, 333, 275, 350, 333, 333, 500, 333, 333, 250, 
	760, 500, 500, 500, 400, 333, 675, 500, 333, 278, 500, 889, 889, 
	500, 675, 333, 389, 500, 500, 500, 500, 500, 167, 500, 333, 675, 
	500, 500, 333, 333, 333, 333, 675, 675, 333, 675, 500, 675, 500, 
	500, 333, 500, 750, 750, 300, 276, 310, 523, 333, 333, 833, 250, 
	250, 1000, 675, 675, 500, 500, 420, 556, 556, 556, 333, 333, 333, 
	214, 760, 333, 500, 333, 500, 500, 278, 250, 500, 500, 750, 300, 
	333, 980, 500, 300, 500, 500, 500, 
    }},
    { "Times-Bold", times_bold_kerns, {
	722, 667, 722, 722, 667, 611, 778, 778, 389, 500, 778, 667, 944, 
	722, 778, 611, 778, 722, 556, 667, 722, 722, 1000, 722, 722, 667, 
	500, 556, 444, 556, 444, 333, 500, 556, 278, 333, 556, 278, 833, 
	556, 500, 556, 556, 444, 389, 333, 556, 500, 722, 500, 500, 444, 
	1000, 722, 722, 722, 722, 722, 722, 722, 667, 667, 667, 667, 722, 
	389, 389, 389, 389, 667, 722, 1000, 778, 778, 778, 778, 778, 778, 
	556, 611, 722, 722, 722, 722, 722, 722, 667, 722, 500, 500, 500, 
	500, 500, 500, 444, 444, 444, 444, 444, 500, 278, 278, 278, 278, 
	278, 556, 722, 500, 500, 500, 500, 500, 500, 389, 556, 556, 556, 
	556, 556, 500, 500, 444, 333, 833, 581, 520, 500, 930, 278, 220, 
	394, 394, 333, 333, 333, 220, 350, 333, 333, 500, 333, 333, 250, 
	747, 500, 500, 500, 400, 333, 570, 500, 333, 278, 500, 1000, 1000, 
	500, 570, 333, 333, 556, 500, 556, 500, 500, 167, 556, 333, 570, 
	500, 500, 333, 333, 333, 333, 570, 570, 333, 570, 556, 570, 500, 
	500, 333, 500, 750, 750, 300, 300, 330, 540, 333, 333, 1000, 250, 
	250, 1000, 570, 570, 500, 500, 555, 500, 500, 500, 333, 333, 333, 
	278, 747, 333, 500, 333, 500, 500, 278, 250, 500, 500, 750, 300, 
	333, 1000, 500, 300, 500, 500, 500, 
    }},
    { "Times-BoldItalic", times_bolditalic_kerns, {
	667, 667, 667, 722, 667, 667, 722, 778, 389, 500, 667, 611, 889, 
	722, 722, 611, 722, 667, 556, 611, 722, 667, 889, 667, 611, 611, 
	500, 500, 444, 500, 444, 333, 500, 556, 278, 278, 500, 278, 778, 
	556, 500, 500, 500, 389, 389, 278, 556, 444, 667, 500, 444, 389, 
	944, 667, 667, 667, 667, 667, 667, 667, 667, 667, 667, 667, 722, 
	389, 389, 389, 389, 611, 722, 944, 722, 722, 722, 722, 722, 722, 
	556, 611, 722, 722, 722, 722, 611, 611, 611, 722, 500, 500, 500, 
	500, 500, 500, 444, 444, 444, 444, 444, 500, 278, 278, 278, 278, 
	278, 556, 722, 500, 500, 500, 500, 500, 500, 389, 500, 556, 556, 
	556, 556, 444, 444, 389, 333, 778, 570, 570, 500, 832, 278, 220, 
	348, 348, 333, 333, 333, 220, 350, 333, 333, 500, 333, 333, 250, 
	747, 500, 500, 500, 400, 333, 570, 500, 333, 278, 500, 1000, 1000, 
	500, 570, 389, 389, 556, 500, 556, 500, 500, 167, 500, 333, 570, 
	500, 500, 333, 333, 333, 333, 570, 606, 333, 606, 576, 570, 500, 
	500, 333, 500, 750, 750, 300, 266, 300, 500, 333, 333, 833, 250, 
	250, 1000, 570, 570, 500, 500, 555, 500, 500, 500, 333, 333, 333, 
	278, 747, 333, 500, 333, 500, 500, 278, 250, 500, 500, 750, 300, 
	333, 1000, 500, 300, 500, 500, 500, 
    }},
    { "Helvetica", helvetica_kerns, {
	667, 667, 722, 722, 667, 611, 778, 722, 278, 500, 667, 556, 833, 
	722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 
	556, 556, 500, 556, 556, 278, 556, 556, 222, 222, 500, 222, 833, 
	556, 556, 556, 556, 333, 500, 278, 556, 500, 722, 500, 500, 500, 
	1000, 667, 667, 667, 667, 667, 667, 722, 667, 667, 667, 667, 722, 
	278, 278, 278, 278, 556, 722, 1000, 778, 778, 778, 778, 778, 778, 
	667, 667, 722, 722, 722, 722, 667, 667, 611, 889, 556, 556, 556, 
	556, 556, 556, 500, 556, 556, 556, 556, 556, 278, 278, 278, 278, 
	222, 556, 944, 556, 556, 556, 556, 611, 556, 500, 556, 556, 556, 
	556, 556, 500, 500, 500, 333, 667, 469, 584, 389, 1015, 278, 260, 
	334, 334, 278, 278, 333, 260, 350, 333, 333, 556, 333, 278, 278, 
	737, 556, 556, 556, 400, 333, 584, 556, 333, 278, 556, 1000, 1000, 
	556, 584, 278, 333, 500, 556, 500, 556, 556, 167, 611, 333, 584, 
	556, 556, 333, 333, 333, 333, 584, 584, 333, 584, 556, 584, 556, 
	556, 333, 556, 834, 834, 333, 370, 365, 537, 333, 333, 889, 278, 
	278, 1000, 584, 584, 556, 611, 355, 333, 333, 333, 222, 222, 222, 
	191, 737, 333, 556, 278, 556, 556, 278, 278, 556, 556, 834, 333, 
	333, 1000, 556, 333, 556, 556, 556, 
    }},
    { "Helvetica-Oblique", helvetica_oblique_kerns, {
	667, 667, 722, 722, 667, 611, 778, 722, 278, 500, 667, 556, 833, 
	722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 
	556, 556, 500, 556, 556, 278, 556, 556, 222, 222, 500, 222, 833, 
	556, 556, 556, 556, 333, 500, 278, 556, 500, 722, 500, 500, 500, 
	1000, 667, 667, 667, 667, 667, 667, 722, 667, 667, 667, 667, 722, 
	278, 278, 278, 278, 556, 722, 1000, 778, 778, 778, 778, 778, 778, 
	667, 667, 722, 722, 722, 722, 667, 667, 611, 889, 556, 556, 556, 
	556, 556, 556, 500, 556, 556, 556, 556, 556, 278, 278, 278, 278, 
	222, 556, 944, 556, 556, 556, 556, 611, 556, 500, 556, 556, 556, 
	556, 556, 500, 500, 500, 333, 667, 469, 584, 389, 1015, 278, 260, 
	334, 334, 278, 278, 333, 260, 350, 333, 333, 556, 333, 278, 278, 
	737, 556, 556, 556, 400, 333, 584, 556, 333, 278, 556, 1000, 1000, 
	556, 584, 278, 333, 500, 556, 500, 556, 556, 167, 611, 333, 584, 
	556, 556, 333, 333, 333, 333, 584, 584, 333, 584, 556, 584, 556, 
	556, 333, 556, 834, 834, 333, 370, 365, 537, 333, 333, 889, 278, 
	278, 1000, 584, 584, 556, 611, 355, 333, 333, 333, 222, 222, 222, 
	191, 737, 333, 556, 278, 556, 556, 278, 278, 556, 556, 834, 333, 
	333, 1000, 556, 333, 556, 556, 556, 
    }},
    { "Helvetica-Bold", helvetica_bold_kerns, {
	722, 722, 722, 722, 667, 611, 778, 722, 278, 556, 722, 611, 833, 
	722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 
	556, 611, 556, 611, 556, 333, 611, 611, 278, 278, 556, 278, 889, 
	611, 611, 611, 611, 389, 556, 333, 611, 556, 778, 556, 556, 500, 
	1000, 722, 722, 722, 722, 722, 722, 722, 667, 667, 667, 667, 722, 
	278, 278, 278, 278, 611, 722, 1000, 778, 778, 778, 778, 778, 778, 
	667, 667, 722, 722, 722, 722, 667, 667, 611, 889, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 611, 278, 278, 278, 278, 
	278, 611, 944, 611, 611, 611, 611, 611, 611, 556, 611, 611, 611, 
	611, 611, 556, 556, 500, 333, 722, 584, 584, 389, 975, 278, 280, 
	389, 389, 333, 333, 333, 280, 350, 333, 333, 556, 333, 333, 278, 
	737, 556, 556, 556, 400, 333, 584, 556, 333, 278, 556, 1000, 1000, 
	556, 584, 333, 333, 611, 556, 611, 556, 556, 167, 611, 333, 584, 
	556, 556, 333, 333, 333, 333, 584, 584, 333, 584, 611, 584, 556, 
	556, 333, 556, 834, 834, 333, 370, 365, 556, 333, 333, 889, 278, 
	278, 1000, 584, 584, 611, 611, 474, 500, 500, 500, 278, 278, 278, 
	238, 737, 333, 556, 333, 556, 556, 278, 278, 556, 556, 834, 333, 
	333, 1000, 556, 333, 556, 556, 556, 
    }},
    { "Helvetica-BoldOblique", helvetica_boldoblique_kerns, {
	722, 722, 722, 722, 667, 611, 778, 722, 278, 556, 722, 611, 833, 
	722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 
	556, 611, 556, 611, 556, 333, 611, 611, 278, 278, 556, 278, 889, 
	611, 611, 611, 611, 389, 556, 333, 611, 556, 778, 556, 556, 500, 
	1000, 722, 722, 722, 722, 722, 722, 722, 667, 667, 667, 667, 722, 
	278, 278, 278, 278, 611, 722, 1000, 778, 778, 778, 778, 778, 778, 
	667, 667, 722, 722, 722, 722, 667, 667, 611, 889, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 611, 278, 278, 278, 278, 
	278, 611, 944, 611, 611, 611, 611, 611, 611, 556, 611, 611, 611, 
	611, 611, 556, 556, 500, 333, 722, 584, 584, 389, 975, 278, 280, 
	389, 389, 333, 333, 333, 280, 350, 333, 333, 556, 333, 333, 278, 
	737, 556, 556, 556, 400, 333, 584, 556, 333, 278, 556, 1000, 1000, 
	556, 584, 333, 333, 611, 556, 611, 556, 556, 167, 611, 333, 584, 
	556, 556, 333, 333, 333, 333, 584, 584, 333, 584, 611, 584, 556, 
	556, 333, 556, 834, 834, 333, 370, 365, 556, 333, 333, 889, 278, 
	278, 1000, 584, 584, 611, 611, 474, 500, 500, 500, 278, 278, 278, 
	238, 737, 333, 556, 333, 556, 556, 278, 278, 556, 556, 834, 333, 
	333, 1000, 556, 333, 556, 556, 556, 
    }},
    { "Courier", courier_kerns, {
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 
    }},
    { "Courier-Oblique", courier_oblique_kerns, {
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 
    }},
    { "Courier-Bold", courier_bold_kerns, {
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 
    }},
    { "Courier-BoldOblique", courier_boldoblique_kerns, {
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 
    }},
};

const int *ps_std_font_widths(char const *fontname)
{
    int i;

    for (i = 0; i < (int)lenof(ps_std_fonts); i++)
	if (!strcmp(ps_std_fonts[i].name, fontname))
	    return ps_std_fonts[i].widths;

    return NULL;
}

const kern_pair *ps_std_font_kerns(char const *fontname)
{
    int i;

    for (i = 0; i < (int)lenof(ps_std_fonts); i++)
	if (!strcmp(ps_std_fonts[i].name, fontname))
	    return ps_std_fonts[i].kerns;

    return NULL;
}
