/*C* -*-c++-*-
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef vgaxx_VgaContext_h
#define vgaxx_VgaContext_h

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mode.h"
#include "Rect.h"

#ifdef GGI
#include <ggi/ggi.h>
#endif

class VgaContext
{
private:
 unsigned char** pFb;

public:
 VgaContext();
 ~VgaContext();

 unsigned char * const * fb() { return pFb; }

 static void copyBox(VgaContext* sc, class Rect sr, VgaContext* dc, class Point dp); // no clipping
 static void copyBox(VgaContext* sc, class Rect sr, VgaContext* dc) { copyBox(sc, sr, dc, sr.topLeft()); }
 inline void copyBoxFrom(VgaContext* sc, class Rect sr, class Point dp) { copyBox(sc, sr, this, dp); }
 inline void copyBoxFrom(VgaContext* sc, class Rect sr) { copyBox(sc, sr, this, sr.topLeft()); }
 inline void copyBoxTo(class Rect sr, VgaContext* dc, class Point dp) { copyBox(this, sr, dc, dp); }
 inline void copyBoxTo(class Rect sr, VgaContext* dc) { copyBox(this, sr, dc, sr.topLeft()); }
 inline void copyFrom(VgaContext* sc) { copyBox(sc, screenRect, this, origin); }
 inline void copyTo(VgaContext* dc) { copyBox(this, screenRect, dc, origin); }

 class Rect fillBox(class Rect r, class Color c);
 void fill(class Color c);

 class Rect drawHLine(Point p, int w, class Color c); // no clipping
 class Rect drawVLine(Point p, int h, class Color c); // no clipping
 class Rect drawRect(Rect r, class Color c); // no clipping

 bool clipping;
 Rect clippingRect;
};

extern void initAlphaTable();

#endif
