/*C* $Id: gluetext.cc,v 1.4 1997/08/11 23:15:16 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "gluetext.h"
#include "../gl/Color.h"
#include "../gl/Font.h"
#include "../gl/VgaBlur.h"
#include "../util/util.h"
#include <stdarg.h>

template class Collection<GlueText>;

GlueText::GlueText(Point _p, int _time, const char* format, ...)
{
 va_list ap;
 va_start(ap, format);
 char *s;
 vasprintf(&s, format, ap);
 text = newString(s);
 free(s);
 va_end(ap);
 p = _p;
 time = _time;
}

GlueTextManager::GlueTextManager(Font* _font)
{
 font = _font;
 glueTexts = new Collection<GlueText>(32, 32);
}

GlueTextManager::~GlueTextManager()
{
 delete glueTexts;
}

void GlueTextManager::blur(VgaBlur* vc)
{
 font->vAlign = Font::VMiddle;
 font->hAlign = Font::HMiddle;
 for(int i=0; i<glueTexts->length(); i++)
  {
   GlueText* gt = (*glueTexts)[i];
   vc->blur2(font->writef(vc, gt->p, colorWhite, "%s", gt->text));
  }
}

void GlueTextManager::tick()
{
 foreach(*glueTexts, i) if(--(*glueTexts)[i]->time == 0) glueTexts->del(i);
 glueTexts->pack();
}
