-- do not edit; automatically generated by UU.AG
module Top.Cobalt.Generator where

import Top.Cobalt.ParseRules
import Top.Cobalt.ShowAG
import Top.Cobalt.AGSyntax
import Top.Cobalt.Syntax
import Top.Cobalt.Escape
import Top.Types
import Data.List
import Data.Maybe
import Data.FiniteMap

import Top.Cobalt.AGSyntax
import Top.Cobalt.ShowAG

-- Returns the elements in xs which occur more than once.  
duplicates :: [a] -> [a]
duplicates xs = map head (filter (\ys -> length ys > 1) (group (sort xs)))

-- Maps alternatives to lists of attributes.
type AttributesMap  = FiniteMap String{-alt or nt-} ([String{-inhs-}],[String{-syns-}])
type JudgementsAL   = [(String,([String],[String]))]
type ArgTypesMap = FiniteMap String{-alt-} [String]{-types of the arguments for this alternative-}
type VarAL = [(String, String)]


type FunctionEnvironment = FiniteMap String TpScheme


showConstraintTerm :: VarAL -> ConstraintTerm -> String
showConstraintTerm vm (ConstraintTerm term) = showTerm vm term 

showTerm :: VarAL -> Term -> String
showTerm vm (TermVar s)      = s ? vm
showTerm vm (TermString s)      = show s
showTerm vm (TermApp f args) = unwords (f : map (pars . showTerm vm) args)

bracks s = "[" ++ s ++ "]"
pars s = "(" ++ s ++ ")"

-- Association list things (functional mappings represented as lists of pairs)
domainAL :: [(a,b)] -> [a]
domainAL = map fst 
rangeAL :: [(a,b)] -> [b]
rangeAL = map snd

-- No maybe here. Simply omit the a's for which we can not map through b to a c.
joinAL :: [(a,b)] -> [(b,c)] -> [(a,c)]
joinAL [] as2     = []
joinAL ((x,y):xs) as2 = 
  case lookup y of
    Nothing -> rest
    Just z  -> (x,z):rest
   where
     rest = joinAL xs as2

x ? xs = let err = error ("Could not find " ++ show x ++ " in " ++ show xs) 
         in maybe err id (lookup x xs)
				 
{-
generator :: FunctionEnvironment -> ClassEnvironment -> TypeSystem -> IO ()
generator gamma classEnv system =
   let (agcode, _, staticErrors, typeErrors) = sem_TypeSystem system classEnv gamma
       reportErrors :: Show a => [a] -> IO ()
       reportErrors = putStrLn . unlines . map show
   in case staticErrors of 
         []   -> case typeErrors of
                    [] -> 
                       let msg = unlines [ "imports {", "import TempImport", "}", show agcode ]
                       in do putStrLn msg
                             writeFile "Temp.ag" msg
                             putStrLn "output written to <Temp.ag>"
                    errs -> reportErrors (map snd errs)
         errs -> reportErrors errs
-}
	
generator :: FunctionEnvironment -> ClassEnvironment -> TypeSystem -> IO ()
generator gamma classEnv system =
   let (_, staticErrors, staticWarnings) = sem_TypeSystem system classEnv gamma
       reportErrors :: Show a => [a] -> IO ()
       reportErrors = putStrLn . unlines . map show
   in case staticErrors of 
         []   -> case staticWarnings of
                    [] -> putStrLn 
                    errs -> reportErrors errs
         errs -> reportErrors errs
			 				 

type StaticMessages = [StaticMessage]
data StaticMessage = FunctionNotDefined         String{-rulename-} String
                   | UnknownType                String{-nt-}       String
                   | MetaVarNotDefined          String{-rulename-} String              
                   | DuplicateMetaVarInPremise  String{-rulename-} String
                   | DuplicateVar               String{-rulename-} String
                   | DuplicateRuleName          String{-rulename-}
                   | ConstraintIsNotApplication String{-rulename-} Term
                   | MustBeVar                  String{-rulename-} Term
                   | MustBeSimpleApp            String{-rulename-} Term  
                   | NonTerminalNotDefined      String     -- if a judgement is given for a non-existent nonterminal
                   | MissesJudgement            String{-nt-}
                   | NoJudgementForType         String{-rulename-} String{-type-}
                   | DuplicateAlternative       String
                   | UnknownAlternative         String{-rulename-} String
                   | WrongNumberOfArguments     String{-rulename-} String
                   | WrongNumberOfAttributes    String{-rulename-} String{-where-}
                   | InternalError              String{-rulename-} String{-what happened-}
                   
                   | DeclaredAndUsedInPremise   String{-rulename-} String
                   | MetaVarNotUsed             String{-rulename-} String
     deriving Show

type PremiseAttrs   = [PremiseAttr]
data PremiseAttr    = PremiseAttr 
   { preMeta           :: String 
   , preMetaType       :: String
--   , declaredInPremise :: [String] -- Variables declared by this construct: the syns in this case
   }
   
data ConclusionAttr = ConclusionAttr
   { conAlternative       :: String   -- name of the alternative
   , metaVarAL            :: VarAL    -- maps each metavar (that has a type referring to an AG datatype) to its type
   , conInhVars           :: [String] -- implicitly declared variables from the inherited attr section
--   , declaredInConclusion :: [String] -- Variables declared by this construct: the inhs and the meta vars in this case
   }


checkPremise :: String -> JudgementDeclMap -> VarAL -> Judgement -> Escape [StaticError] PremiseAttr
checkPremise rulename judgementdeclmap metavarAL (Judgement inhs expr syns) = 
   do{ var <- check (matchTermVar expr) [MustBeVar rulename expr]
     ; tp <- check (lookup var metavarAL) [MetaVarNotDefined rulename var]
     ; (declinhs, declsyns) <- 
         check (lookupFM var judgementdeclmap) [NoJudgementForType rulename tp]  -- retrieve info on judgement for this type
     ; let termVars = filter (isJust . matchTermVar) syns
     ; continueIf (length declinhs == length inhs) [WrongNumberOfAttributes rulename "premise " ++ var ++", inhs"] +++
       continueIf (length declsyns == length syns) [WrongNumberOfAttributes rulename "premise " ++ var ++ ", syns"] +++
       continueIf (length termVars == length syns) (map (MustBeVar rulename) (filter (not . isJust . matchTermVar) syns))
     ; return (PremiseAttr var tp)
     }

checkConclusion :: String -> JudgementDeclMap -> ArgTypesMap -> Judgement -> Escape [StaticError] ConclusionAttr 
checkConclusion rulename judgementdeclmap argtypesmap nts (Judgement inhs expr syns) =
   do{ (con, args) <- check (matchSimpleTermApp expr) [MustBeSimpleApp rulename expr]
     ; (declinhs, declsyns) <- 
         check (lookupFM con judgementsdeclmap) [UnknownAlternative rulename con]
     ; argTypes <- check (lookupFM con argtypesmap) [InternalError rulename "while doing lookup for argument type of conclusion"]     
     ; let termVars = filter (isJust . matchTermVar) inhs
     ; continueIf (length declinhs == length inhs) [WrongNumberOfAttributes rulename "conclusion,inhs"] +++
       continueIf (length declsyns == length syns) [WrongNumberOfAttributes rulename "conclusion,syns"] +++
       continueIf (length args == length argTypes) [WrongNumberOfArguments rulename expr] +++
       continueIf (length termVars == length inhs) (map (MustBeVar rulename) (filter (not . isJust . matchTermVar) inhs))
     ; return (ConclusionAttr con (metaFilter nts (zip args argTypes)) termVars)
     }

metaFilter :: [String] -> [(String,String)] -> [(String,String)] 
metaFilter metatypes = filter (\(var,tp) -> tp `elem` metatypes)

getTerm :: ConstraintTerm -> Term
getTerm (ConstraintTerm term) = term

isTermVar :: ConstraintTerm -> Bool
isTermVar = isJust . matchTermVar . getTerm

isTermApp :: ConstraintTerm -> Bool
isTermApp = isJust . matchTermApp . getTerm 

isSimpleTermApp :: ConstraintTerm -> Bool
isSimpleTermApp = isJust . matchSimpleTermApp . getTerm

matchTermVar :: Term -> Maybe String
matchTermVar (TermVar x) = Just x
matchTermVar _           = Nothing

matchTermApp :: Term -> Maybe String
matchTermApp (TermApp fun args) = Just fun
matchTermApp _                  = Nothing

matchSimpleTermApp :: Term -> Maybe (String, [String])
matchSimpleTermApp (TermApp fun args) = do xs <- mapM matchTermVar args ; return (fun, xs)
matchSimpleTermApp _                  = Nothing

-- Bastiaan
values = eltsFM

-- AGAttr ------------------------------------------------------
-- semantic domain
type T_AGAttr = ( (AGAttr))
-- cata
sem_AGAttr :: (AGAttr) ->
              (T_AGAttr)
sem_AGAttr ((AGAttr (_nonterminals) (_attrKind) (_attrName) (_attrType))) =
    (sem_AGAttr_AGAttr (_nonterminals) ((sem_Attr (_attrKind))) (_attrName) (_attrType))
sem_AGAttr_AGAttr :: (String) ->
                     (T_Attr) ->
                     (String) ->
                     (String) ->
                     (T_AGAttr)
sem_AGAttr_AGAttr (nonterminals_) (attrKind_) (attrName_) (attrType_) =
    let _lhsOself :: (AGAttr)
        _attrKindIself :: (Attr)
        ( _attrKindIself) =
            (attrKind_ )
        (_self@_) =
            AGAttr nonterminals_ _attrKindIself attrName_ attrType_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- AGAttrs -----------------------------------------------------
-- semantic domain
type T_AGAttrs = ( (AGAttrs))
-- cata
sem_AGAttrs :: (AGAttrs) ->
               (T_AGAttrs)
sem_AGAttrs (list) =
    (Prelude.foldr (sem_AGAttrs_Cons) (sem_AGAttrs_Nil) ((Prelude.map sem_AGAttr list)))
sem_AGAttrs_Cons :: (T_AGAttr) ->
                    (T_AGAttrs) ->
                    (T_AGAttrs)
sem_AGAttrs_Cons (hd_) (tl_) =
    let _lhsOself :: (AGAttrs)
        _hdIself :: (AGAttr)
        _tlIself :: (AGAttrs)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_AGAttrs_Nil :: (T_AGAttrs)
sem_AGAttrs_Nil  =
    let _lhsOself :: (AGAttrs)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- AGCode ------------------------------------------------------
-- semantic domain
type T_AGCode = ( (AGCode))
-- cata
sem_AGCode :: (AGCode) ->
              (T_AGCode)
sem_AGCode ((AGCode (_agdatas) (_agattrs) (_agsems))) =
    (sem_AGCode_AGCode ((sem_AGDatas (_agdatas))) ((sem_AGAttrs (_agattrs))) ((sem_AGSems (_agsems))))
sem_AGCode_AGCode :: (T_AGDatas) ->
                     (T_AGAttrs) ->
                     (T_AGSems) ->
                     (T_AGCode)
sem_AGCode_AGCode (agdatas_) (agattrs_) (agsems_) =
    let _lhsOself :: (AGCode)
        _agdatasIaltargtypes :: ([(String, [String])])
        _agdatasIaltnts :: ([(String, String)])
        _agdatasIalttypes :: ([(String, TpScheme)])
        _agdatasIself :: (AGDatas)
        _agattrsIself :: (AGAttrs)
        _agsemsIself :: (AGSems)
        ( _agdatasIaltargtypes,_agdatasIaltnts,_agdatasIalttypes,_agdatasIself) =
            (agdatas_ )
        ( _agattrsIself) =
            (agattrs_ )
        ( _agsemsIself) =
            (agsems_ )
        (_self@_) =
            AGCode _agdatasIself _agattrsIself _agsemsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- AGData ------------------------------------------------------
-- semantic domain
type T_AGData = ( ([(String, [String])]),([(String, String)]),([(String, TpScheme)]),(AGData))
-- cata
sem_AGData :: (AGData) ->
              (T_AGData)
sem_AGData ((AGData (_nonterminal) (_alternative) (_children))) =
    (sem_AGData_AGData (_nonterminal) (_alternative) (_children))
sem_AGData_AGData :: (String) ->
                     (String) ->
                     ([(String, String)]) ->
                     (T_AGData)
sem_AGData_AGData (nonterminal_) (alternative_) (children_) =
    let _lhsOaltargtypes :: ([(String, [String])])
        _lhsOaltnts :: ([(String, String)])
        _lhsOalttypes :: ([(String, TpScheme)])
        _lhsOself :: (AGData)
        (_altTp@_) =
            foldr (.->.) (TCon nonterminal_) (map (TCon . snd) children_)
        (_lhsOaltnts@_) =
            [(alternative_, nonterminal_)]
        (_lhsOaltargtypes@_) =
            [(alternative_, map snd children_)]
        (_lhsOalttypes@_) =
            [(alternative_, toTpScheme _altTp )]
        (_self@_) =
            AGData nonterminal_ alternative_ children_
        (_lhsOself@_) =
            _self
    in  ( _lhsOaltargtypes,_lhsOaltnts,_lhsOalttypes,_lhsOself)
-- AGDatas -----------------------------------------------------
-- semantic domain
type T_AGDatas = ( ([(String, [String])]),([(String, String)]),([(String, TpScheme)]),(AGDatas))
-- cata
sem_AGDatas :: (AGDatas) ->
               (T_AGDatas)
sem_AGDatas (list) =
    (Prelude.foldr (sem_AGDatas_Cons) (sem_AGDatas_Nil) ((Prelude.map sem_AGData list)))
sem_AGDatas_Cons :: (T_AGData) ->
                    (T_AGDatas) ->
                    (T_AGDatas)
sem_AGDatas_Cons (hd_) (tl_) =
    let _lhsOaltargtypes :: ([(String, [String])])
        _lhsOaltnts :: ([(String, String)])
        _lhsOalttypes :: ([(String, TpScheme)])
        _lhsOself :: (AGDatas)
        _hdIaltargtypes :: ([(String, [String])])
        _hdIaltnts :: ([(String, String)])
        _hdIalttypes :: ([(String, TpScheme)])
        _hdIself :: (AGData)
        _tlIaltargtypes :: ([(String, [String])])
        _tlIaltnts :: ([(String, String)])
        _tlIalttypes :: ([(String, TpScheme)])
        _tlIself :: (AGDatas)
        ( _hdIaltargtypes,_hdIaltnts,_hdIalttypes,_hdIself) =
            (hd_ )
        ( _tlIaltargtypes,_tlIaltnts,_tlIalttypes,_tlIself) =
            (tl_ )
        (_lhsOaltargtypes@_) =
            _hdIaltargtypes  ++  _tlIaltargtypes
        (_lhsOaltnts@_) =
            _hdIaltnts  ++  _tlIaltnts
        (_lhsOalttypes@_) =
            _hdIalttypes  ++  _tlIalttypes
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOaltargtypes,_lhsOaltnts,_lhsOalttypes,_lhsOself)
sem_AGDatas_Nil :: (T_AGDatas)
sem_AGDatas_Nil  =
    let _lhsOaltargtypes :: ([(String, [String])])
        _lhsOaltnts :: ([(String, String)])
        _lhsOalttypes :: ([(String, TpScheme)])
        _lhsOself :: (AGDatas)
        (_lhsOaltargtypes@_) =
            []
        (_lhsOaltnts@_) =
            []
        (_lhsOalttypes@_) =
            []
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOaltargtypes,_lhsOaltnts,_lhsOalttypes,_lhsOself)
-- AGSem -------------------------------------------------------
-- semantic domain
type T_AGSem = ( (AGSem))
-- cata
sem_AGSem :: (AGSem) ->
             (T_AGSem)
sem_AGSem ((AGSem (_nonterminal) (_alternative) (_semdecls))) =
    (sem_AGSem_AGSem (_nonterminal) (_alternative) ((sem_AGSemDecls (_semdecls))))
sem_AGSem_AGSem :: (String) ->
                   (String) ->
                   (T_AGSemDecls) ->
                   (T_AGSem)
sem_AGSem_AGSem (nonterminal_) (alternative_) (semdecls_) =
    let _lhsOself :: (AGSem)
        _semdeclsIself :: (AGSemDecls)
        ( _semdeclsIself) =
            (semdecls_ )
        (_self@_) =
            AGSem nonterminal_ alternative_ _semdeclsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- AGSemDecl ---------------------------------------------------
-- semantic domain
type T_AGSemDecl = ( (AGSemDecl))
-- cata
sem_AGSemDecl :: (AGSemDecl) ->
                 (T_AGSemDecl)
sem_AGSemDecl ((AGSemDecl (_leftNT) (_leftAttr) (_right))) =
    (sem_AGSemDecl_AGSemDecl (_leftNT) (_leftAttr) (_right))
sem_AGSemDecl_AGSemDecl :: (String) ->
                           (String) ->
                           (String) ->
                           (T_AGSemDecl)
sem_AGSemDecl_AGSemDecl (leftNT_) (leftAttr_) (right_) =
    let _lhsOself :: (AGSemDecl)
        (_self@_) =
            AGSemDecl leftNT_ leftAttr_ right_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- AGSemDecls --------------------------------------------------
-- semantic domain
type T_AGSemDecls = ( (AGSemDecls))
-- cata
sem_AGSemDecls :: (AGSemDecls) ->
                  (T_AGSemDecls)
sem_AGSemDecls (list) =
    (Prelude.foldr (sem_AGSemDecls_Cons) (sem_AGSemDecls_Nil) ((Prelude.map sem_AGSemDecl list)))
sem_AGSemDecls_Cons :: (T_AGSemDecl) ->
                       (T_AGSemDecls) ->
                       (T_AGSemDecls)
sem_AGSemDecls_Cons (hd_) (tl_) =
    let _lhsOself :: (AGSemDecls)
        _hdIself :: (AGSemDecl)
        _tlIself :: (AGSemDecls)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_AGSemDecls_Nil :: (T_AGSemDecls)
sem_AGSemDecls_Nil  =
    let _lhsOself :: (AGSemDecls)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- AGSems ------------------------------------------------------
-- semantic domain
type T_AGSems = ( (AGSems))
-- cata
sem_AGSems :: (AGSems) ->
              (T_AGSems)
sem_AGSems (list) =
    (Prelude.foldr (sem_AGSems_Cons) (sem_AGSems_Nil) ((Prelude.map sem_AGSem list)))
sem_AGSems_Cons :: (T_AGSem) ->
                   (T_AGSems) ->
                   (T_AGSems)
sem_AGSems_Cons (hd_) (tl_) =
    let _lhsOself :: (AGSems)
        _hdIself :: (AGSem)
        _tlIself :: (AGSems)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_AGSems_Nil :: (T_AGSems)
sem_AGSems_Nil  =
    let _lhsOself :: (AGSems)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Attr --------------------------------------------------------
-- semantic domain
type T_Attr = ( (Attr))
-- cata
sem_Attr :: (Attr) ->
            (T_Attr)
sem_Attr ((Chained )) =
    (sem_Attr_Chained )
sem_Attr ((Inherited )) =
    (sem_Attr_Inherited )
sem_Attr ((Synthesized )) =
    (sem_Attr_Synthesized )
sem_Attr_Chained :: (T_Attr)
sem_Attr_Chained  =
    let _lhsOself :: (Attr)
        (_self@_) =
            Chained
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Attr_Inherited :: (T_Attr)
sem_Attr_Inherited  =
    let _lhsOself :: (Attr)
        (_self@_) =
            Inherited
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Attr_Synthesized :: (T_Attr)
sem_Attr_Synthesized  =
    let _lhsOself :: (Attr)
        (_self@_) =
            Synthesized
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- ConstraintTerm ----------------------------------------------
-- semantic domain
type T_ConstraintTerm = (AGDatas) ->
                        (ArgTypesMap) ->
                        (FunctionEnvironment) ->
                        (JudgementsMap) ->
                        ([String]) ->
                        (String) ->
                        ( ([String]),(ConstraintTerm),(StaticMessages),(StaticMessages))
-- cata
sem_ConstraintTerm :: (ConstraintTerm) ->
                      (T_ConstraintTerm)
sem_ConstraintTerm ((ConstraintTerm (_constraint))) =
    (sem_ConstraintTerm_ConstraintTerm ((sem_Term (_constraint))))
sem_ConstraintTerm_ConstraintTerm :: (T_Term) ->
                                     (T_ConstraintTerm)
sem_ConstraintTerm_ConstraintTerm (constraint_) =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOself :: (ConstraintTerm)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            _constraintIallVariables :: ([String])
            _constraintIself :: (Term)
            _constraintIstaticErrors :: (StaticMessages)
            _constraintIstaticWarnings :: (StaticMessages)
            _constraintOagdatas :: (AGDatas)
            _constraintOargTypesMap :: (ArgTypesMap)
            _constraintOfunctions :: (FunctionEnvironment)
            _constraintOjudgementsMap :: (JudgementsMap)
            _constraintOnts :: ([String])
            _constraintOrulename :: (String)
            ( _constraintIallVariables,_constraintIself,_constraintIstaticErrors,_constraintIstaticWarnings) =
                (constraint_ (_constraintOagdatas) (_constraintOargTypesMap) (_constraintOfunctions) (_constraintOjudgementsMap) (_constraintOnts) (_constraintOrulename))
            (_lhsOstaticErrors@_) =
                [ ConstraintIsNotApplication _lhsIrulename (getTerm con)
                | con <- _self
                , not (isTermApp con)
                ]
                ++ constraint.staticErrors
            (_lhsOallVariables@_) =
                _constraintIallVariables
            (_lhsOstaticWarnings@_) =
                _constraintIstaticWarnings
            (_self@_) =
                ConstraintTerm _constraintIself
            (_lhsOself@_) =
                _self
            (_constraintOagdatas@_) =
                _lhsIagdatas
            (_constraintOargTypesMap@_) =
                _lhsIargTypesMap
            (_constraintOfunctions@_) =
                _lhsIfunctions
            (_constraintOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_constraintOnts@_) =
                _lhsInts
            (_constraintOrulename@_) =
                _lhsIrulename
        in  ( _lhsOallVariables,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)
-- ConstraintTerms ---------------------------------------------
-- semantic domain
type T_ConstraintTerms = (AGDatas) ->
                         (ArgTypesMap) ->
                         (FunctionEnvironment) ->
                         (JudgementsMap) ->
                         ([String]) ->
                         (String) ->
                         ( ([String]),(ConstraintTerms),(StaticMessages),(StaticMessages))
-- cata
sem_ConstraintTerms :: (ConstraintTerms) ->
                       (T_ConstraintTerms)
sem_ConstraintTerms (list) =
    (Prelude.foldr (sem_ConstraintTerms_Cons) (sem_ConstraintTerms_Nil) ((Prelude.map sem_ConstraintTerm list)))
sem_ConstraintTerms_Cons :: (T_ConstraintTerm) ->
                            (T_ConstraintTerms) ->
                            (T_ConstraintTerms)
sem_ConstraintTerms_Cons (hd_) (tl_) =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOself :: (ConstraintTerms)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            _hdIallVariables :: ([String])
            _hdIself :: (ConstraintTerm)
            _hdIstaticErrors :: (StaticMessages)
            _hdIstaticWarnings :: (StaticMessages)
            _hdOagdatas :: (AGDatas)
            _hdOargTypesMap :: (ArgTypesMap)
            _hdOfunctions :: (FunctionEnvironment)
            _hdOjudgementsMap :: (JudgementsMap)
            _hdOnts :: ([String])
            _hdOrulename :: (String)
            _tlIallVariables :: ([String])
            _tlIself :: (ConstraintTerms)
            _tlIstaticErrors :: (StaticMessages)
            _tlIstaticWarnings :: (StaticMessages)
            _tlOagdatas :: (AGDatas)
            _tlOargTypesMap :: (ArgTypesMap)
            _tlOfunctions :: (FunctionEnvironment)
            _tlOjudgementsMap :: (JudgementsMap)
            _tlOnts :: ([String])
            _tlOrulename :: (String)
            ( _hdIallVariables,_hdIself,_hdIstaticErrors,_hdIstaticWarnings) =
                (hd_ (_hdOagdatas) (_hdOargTypesMap) (_hdOfunctions) (_hdOjudgementsMap) (_hdOnts) (_hdOrulename))
            ( _tlIallVariables,_tlIself,_tlIstaticErrors,_tlIstaticWarnings) =
                (tl_ (_tlOagdatas) (_tlOargTypesMap) (_tlOfunctions) (_tlOjudgementsMap) (_tlOnts) (_tlOrulename))
            (_lhsOallVariables@_) =
                _hdIallVariables  ++  _tlIallVariables
            (_lhsOstaticErrors@_) =
                _hdIstaticErrors  ++  _tlIstaticErrors
            (_lhsOstaticWarnings@_) =
                _hdIstaticWarnings  ++  _tlIstaticWarnings
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_hdOagdatas@_) =
                _lhsIagdatas
            (_hdOargTypesMap@_) =
                _lhsIargTypesMap
            (_hdOfunctions@_) =
                _lhsIfunctions
            (_hdOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_hdOnts@_) =
                _lhsInts
            (_hdOrulename@_) =
                _lhsIrulename
            (_tlOagdatas@_) =
                _lhsIagdatas
            (_tlOargTypesMap@_) =
                _lhsIargTypesMap
            (_tlOfunctions@_) =
                _lhsIfunctions
            (_tlOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_tlOnts@_) =
                _lhsInts
            (_tlOrulename@_) =
                _lhsIrulename
        in  ( _lhsOallVariables,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)
sem_ConstraintTerms_Nil :: (T_ConstraintTerms)
sem_ConstraintTerms_Nil  =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOself :: (ConstraintTerms)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            (_lhsOallVariables@_) =
                []
            (_lhsOstaticErrors@_) =
                []
            (_lhsOstaticWarnings@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
        in  ( _lhsOallVariables,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)
-- DeductionRule -----------------------------------------------
-- semantic domain
type T_DeductionRule = (AGDatas) ->
                       (ArgTypesMap) ->
                       (FunctionEnvironment) ->
                       (JudgementsMap) ->
                       ([String]) ->
                       (String) ->
                       ( ([String]),(ConclusionAttr),([String]),(PremiseAttrs),(DeductionRule),(StaticMessages),(StaticMessages),([String]))
-- cata
sem_DeductionRule :: (DeductionRule) ->
                     (T_DeductionRule)
sem_DeductionRule ((DeductionRule (_premises) (_conclusion))) =
    (sem_DeductionRule_DeductionRule ((sem_Judgements (_premises))) ((sem_Judgement (_conclusion))))
sem_DeductionRule_DeductionRule :: (T_Judgements) ->
                                   (T_Judgement) ->
                                   (T_DeductionRule)
sem_DeductionRule_DeductionRule (premises_) (conclusion_) =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOconclusionAttr :: (ConclusionAttr)
            _lhsOdeclaredVars :: ([String])
            _lhsOpremiseAttrs :: (PremiseAttrs)
            _lhsOself :: (DeductionRule)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            _lhsOusedVars :: ([String])
            _premisesIallVariables :: ([String])
            _premisesIdeclaredVars :: ([String])
            _premisesIpremiseAttrs :: (PremiseAttrs)
            _premisesIself :: (Judgements)
            _premisesIstaticErrors :: (StaticMessages)
            _premisesIstaticWarnings :: (StaticMessages)
            _premisesIusedVars :: ([String])
            _premisesOagdatas :: (AGDatas)
            _premisesOargTypesMap :: (ArgTypesMap)
            _premisesOfunctions :: (FunctionEnvironment)
            _premisesOisConclusion :: (Bool)
            _premisesOjudgementsMap :: (JudgementsMap)
            _premisesOmetaVarAL :: (VarAL)
            _premisesOnts :: ([String])
            _premisesOrulename :: (String)
            _conclusionIallVariables :: ([String])
            _conclusionIdeclaredVars :: ([String])
            _conclusionIpremiseAttrs :: (PremiseAttrs)
            _conclusionIself :: (Judgement)
            _conclusionIstaticErrors :: (StaticMessages)
            _conclusionIstaticWarnings :: (StaticMessages)
            _conclusionIusedVars :: ([String])
            _conclusionOagdatas :: (AGDatas)
            _conclusionOargTypesMap :: (ArgTypesMap)
            _conclusionOfunctions :: (FunctionEnvironment)
            _conclusionOisConclusion :: (Bool)
            _conclusionOjudgementsMap :: (JudgementsMap)
            _conclusionOmetaVarAL :: (VarAL)
            _conclusionOnts :: ([String])
            _conclusionOrulename :: (String)
            ( _premisesIallVariables,_premisesIdeclaredVars,_premisesIpremiseAttrs,_premisesIself,_premisesIstaticErrors,_premisesIstaticWarnings,_premisesIusedVars) =
                (premises_ (_premisesOagdatas) (_premisesOargTypesMap) (_premisesOfunctions) (_premisesOisConclusion) (_premisesOjudgementsMap) (_premisesOmetaVarAL) (_premisesOnts) (_premisesOrulename))
            ( _conclusionIallVariables,_conclusionIdeclaredVars,_conclusionIpremiseAttrs,_conclusionIself,_conclusionIstaticErrors,_conclusionIstaticWarnings,_conclusionIusedVars) =
                (conclusion_ (_conclusionOagdatas) (_conclusionOargTypesMap) (_conclusionOfunctions) (_conclusionOisConclusion) (_conclusionOjudgementsMap) (_conclusionOmetaVarAL) (_conclusionOnts) (_conclusionOrulename))
            (_lhsOstaticErrors@_) =
                _staticErrorsConclusion ++
                [ DuplicateVar _lhsIrulename x
                | x <- duplicates _declaredVars
                ] ++
                if (_conclusionAttr == Nothing) then []
                else
                  let metaVarsPremise = map preMeta _premisesIpremiseAttrs
                  in _premisesIstaticErrors ++
                     [ DuplicateMetaVarInPremise _lhsIrulename x
                     | x <- duplicates metaVarsPremise
                     ] ++
                     [ DuplicateVar _lhsIrulename x
                     | x <- duplicates _declaredVars
                     ]
            (_lhsOstaticWarnings@_) =
                _conclusionIstaticWarnings ++ _premisesIstaticWarnings ++
                [ MetaVarNotUsed _lhsIrulename x
                | x <- map snd (metaVarAL _conclusionAttr)
                , x `notElem` _usedVars
                ] ++
                [ DeclaredAndUsedInPremise _lhsIrulename x
                | x <- _premisesIusedVars
                , x `elem` _premisesIdeclaredVars
                ]
            (_declaredVars@_) =
                _premisesIdeclaredVars ++ _conclusionIdeclaredVars
            (_lhsOusedVars@_) =
                _usedVars
            (_usedVars@_) =
                nub (_premisesIusedVars ++ _conclusionIusedVars)
            ((_staticErrorsConclusion@_,_conclusionAttr@_,_premisesOmetaVarAL@_)) =
                case checkConclusion _lhsIrulename _lhsIjudgementsMap _lhsIargTypesMap _lhsInts _conclusionIself of
                  Escape errors           -> (errors, Nothing, [])
                  Continue conclusionAttr -> ([], Just conclusionAttr, metaVarAL conclusionAttr)
            (_premisesOisConclusion@_) =
                False
            (_conclusionOmetaVarAL@_) =
                []
            (_conclusionOisConclusion@_) =
                True
            (_lhsOallVariables@_) =
                _premisesIallVariables  ++  _conclusionIallVariables
            (_lhsOdeclaredVars@_) =
                _declaredVars
            (_lhsOpremiseAttrs@_) =
                _premisesIpremiseAttrs  ++  _conclusionIpremiseAttrs
            (_self@_) =
                DeductionRule _premisesIself _conclusionIself
            (_lhsOself@_) =
                _self
            (_lhsOconclusionAttr@_) =
                _conclusionAttr
            (_premisesOagdatas@_) =
                _lhsIagdatas
            (_premisesOargTypesMap@_) =
                _lhsIargTypesMap
            (_premisesOfunctions@_) =
                _lhsIfunctions
            (_premisesOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_premisesOnts@_) =
                _lhsInts
            (_premisesOrulename@_) =
                _lhsIrulename
            (_conclusionOagdatas@_) =
                _lhsIagdatas
            (_conclusionOargTypesMap@_) =
                _lhsIargTypesMap
            (_conclusionOfunctions@_) =
                _lhsIfunctions
            (_conclusionOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_conclusionOnts@_) =
                _lhsInts
            (_conclusionOrulename@_) =
                _lhsIrulename
        in  ( _lhsOallVariables,_lhsOconclusionAttr,_lhsOdeclaredVars,_lhsOpremiseAttrs,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings,_lhsOusedVars)
-- Judgement ---------------------------------------------------
-- semantic domain
type T_Judgement = (AGDatas) ->
                   (ArgTypesMap) ->
                   (FunctionEnvironment) ->
                   (Bool) ->
                   (JudgementsMap) ->
                   (VarAL) ->
                   ([String]) ->
                   (String) ->
                   ( ([String]),([String]),(PremiseAttrs),(Judgement),(StaticMessages),(StaticMessages),([String]))
-- cata
sem_Judgement :: (Judgement) ->
                 (T_Judgement)
sem_Judgement ((Judgement (_inhs) (_expression) (_syns))) =
    (sem_Judgement_Judgement ((sem_Terms (_inhs))) ((sem_Term (_expression))) ((sem_Terms (_syns))))
sem_Judgement_Judgement :: (T_Terms) ->
                           (T_Term) ->
                           (T_Terms) ->
                           (T_Judgement)
sem_Judgement_Judgement (inhs_) (expression_) (syns_) =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIisConclusion
      _lhsIjudgementsMap
      _lhsImetaVarAL
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOdeclaredVars :: ([String])
            _lhsOpremiseAttrs :: (PremiseAttrs)
            _lhsOself :: (Judgement)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            _lhsOusedVars :: ([String])
            _inhsIallVariables :: ([String])
            _inhsIself :: (Terms)
            _inhsIstaticErrors :: (StaticMessages)
            _inhsIstaticWarnings :: (StaticMessages)
            _inhsOagdatas :: (AGDatas)
            _inhsOargTypesMap :: (ArgTypesMap)
            _inhsOfunctions :: (FunctionEnvironment)
            _inhsOjudgementsMap :: (JudgementsMap)
            _inhsOnts :: ([String])
            _inhsOrulename :: (String)
            _expressionIallVariables :: ([String])
            _expressionIself :: (Term)
            _expressionIstaticErrors :: (StaticMessages)
            _expressionIstaticWarnings :: (StaticMessages)
            _expressionOagdatas :: (AGDatas)
            _expressionOargTypesMap :: (ArgTypesMap)
            _expressionOfunctions :: (FunctionEnvironment)
            _expressionOjudgementsMap :: (JudgementsMap)
            _expressionOnts :: ([String])
            _expressionOrulename :: (String)
            _synsIallVariables :: ([String])
            _synsIself :: (Terms)
            _synsIstaticErrors :: (StaticMessages)
            _synsIstaticWarnings :: (StaticMessages)
            _synsOagdatas :: (AGDatas)
            _synsOargTypesMap :: (ArgTypesMap)
            _synsOfunctions :: (FunctionEnvironment)
            _synsOjudgementsMap :: (JudgementsMap)
            _synsOnts :: ([String])
            _synsOrulename :: (String)
            ( _inhsIallVariables,_inhsIself,_inhsIstaticErrors,_inhsIstaticWarnings) =
                (inhs_ (_inhsOagdatas) (_inhsOargTypesMap) (_inhsOfunctions) (_inhsOjudgementsMap) (_inhsOnts) (_inhsOrulename))
            ( _expressionIallVariables,_expressionIself,_expressionIstaticErrors,_expressionIstaticWarnings) =
                (expression_ (_expressionOagdatas) (_expressionOargTypesMap) (_expressionOfunctions) (_expressionOjudgementsMap) (_expressionOnts) (_expressionOrulename))
            ( _synsIallVariables,_synsIself,_synsIstaticErrors,_synsIstaticWarnings) =
                (syns_ (_synsOagdatas) (_synsOargTypesMap) (_synsOfunctions) (_synsOjudgementsMap) (_synsOnts) (_synsOrulename))
            (_lhsOdeclaredVars@_) =
                if _lhsIisConclusion then _inhsIallVariables ++ _expressionIallVariables else _synsIallVariables
            (_lhsOusedVars@_) =
                if _lhsIisConclusion then _synsIallVariables else _inhsIallVariables ++ _expressionIallVariables
            ((_lhsOpremiseAttrs@_,_newErrors@_)) =
                if _lhsIisConclusion then ([], [])
                else checkPremise _lhsIrulename _lhsIjudgementsMap _lhsImetaVarAL _self
            (_lhsOstaticErrors@_) =
                _inhsIstaticErrors ++ _expressionIstaticErrors ++ _newErrors ++ _synsIstaticErrors
            (_lhsOallVariables@_) =
                _inhsIallVariables  ++  _expressionIallVariables  ++  _synsIallVariables
            (_lhsOstaticWarnings@_) =
                _inhsIstaticWarnings  ++  _expressionIstaticWarnings  ++  _synsIstaticWarnings
            (_self@_) =
                Judgement _inhsIself _expressionIself _synsIself
            (_lhsOself@_) =
                _self
            (_inhsOagdatas@_) =
                _lhsIagdatas
            (_inhsOargTypesMap@_) =
                _lhsIargTypesMap
            (_inhsOfunctions@_) =
                _lhsIfunctions
            (_inhsOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_inhsOnts@_) =
                _lhsInts
            (_inhsOrulename@_) =
                _lhsIrulename
            (_expressionOagdatas@_) =
                _lhsIagdatas
            (_expressionOargTypesMap@_) =
                _lhsIargTypesMap
            (_expressionOfunctions@_) =
                _lhsIfunctions
            (_expressionOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_expressionOnts@_) =
                _lhsInts
            (_expressionOrulename@_) =
                _lhsIrulename
            (_synsOagdatas@_) =
                _lhsIagdatas
            (_synsOargTypesMap@_) =
                _lhsIargTypesMap
            (_synsOfunctions@_) =
                _lhsIfunctions
            (_synsOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_synsOnts@_) =
                _lhsInts
            (_synsOrulename@_) =
                _lhsIrulename
        in  ( _lhsOallVariables,_lhsOdeclaredVars,_lhsOpremiseAttrs,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings,_lhsOusedVars)
-- JudgementDecl -----------------------------------------------
-- semantic domain
type T_JudgementDecl = ([String]) ->
                       ( (JudgementsAL),(JudgementDecl),(StaticMessages))
-- cata
sem_JudgementDecl :: (JudgementDecl) ->
                     (T_JudgementDecl)
sem_JudgementDecl ((JudgementDecl (_datatype) (_inhs) (_syns))) =
    (sem_JudgementDecl_JudgementDecl (_datatype) (_inhs) (_syns))
sem_JudgementDecl_JudgementDecl :: (String) ->
                                   ([String]) ->
                                   ([String]) ->
                                   (T_JudgementDecl)
sem_JudgementDecl_JudgementDecl (datatype_) (inhs_) (syns_) =
    \ _lhsItypes ->
        let _lhsOjudgements :: (JudgementsAL)
            _lhsOself :: (JudgementDecl)
            _lhsOstaticErrors :: (StaticMessages)
            (_lhsOjudgements@_) =
                [(datatype_, (inhs_, syns_))]
            (_lhsOstaticErrors@_) =
                [ UnknownType datatype_ tp
                | tp <- inhs_ ++ syns_
                , tp `notElem` _lhsItypes
                ]
            (_self@_) =
                JudgementDecl datatype_ inhs_ syns_
            (_lhsOself@_) =
                _self
        in  ( _lhsOjudgements,_lhsOself,_lhsOstaticErrors)
-- JudgementDecls ----------------------------------------------
-- semantic domain
type T_JudgementDecls = ([String]) ->
                        ( (JudgementsAL),(JudgementDecls),(StaticMessages))
-- cata
sem_JudgementDecls :: (JudgementDecls) ->
                      (T_JudgementDecls)
sem_JudgementDecls (list) =
    (Prelude.foldr (sem_JudgementDecls_Cons) (sem_JudgementDecls_Nil) ((Prelude.map sem_JudgementDecl list)))
sem_JudgementDecls_Cons :: (T_JudgementDecl) ->
                           (T_JudgementDecls) ->
                           (T_JudgementDecls)
sem_JudgementDecls_Cons (hd_) (tl_) =
    \ _lhsItypes ->
        let _lhsOjudgements :: (JudgementsAL)
            _lhsOself :: (JudgementDecls)
            _lhsOstaticErrors :: (StaticMessages)
            _hdIjudgements :: (JudgementsAL)
            _hdIself :: (JudgementDecl)
            _hdIstaticErrors :: (StaticMessages)
            _hdOtypes :: ([String])
            _tlIjudgements :: (JudgementsAL)
            _tlIself :: (JudgementDecls)
            _tlIstaticErrors :: (StaticMessages)
            _tlOtypes :: ([String])
            ( _hdIjudgements,_hdIself,_hdIstaticErrors) =
                (hd_ (_hdOtypes))
            ( _tlIjudgements,_tlIself,_tlIstaticErrors) =
                (tl_ (_tlOtypes))
            (_lhsOjudgements@_) =
                _hdIjudgements  ++  _tlIjudgements
            (_lhsOstaticErrors@_) =
                _hdIstaticErrors  ++  _tlIstaticErrors
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_hdOtypes@_) =
                _lhsItypes
            (_tlOtypes@_) =
                _lhsItypes
        in  ( _lhsOjudgements,_lhsOself,_lhsOstaticErrors)
sem_JudgementDecls_Nil :: (T_JudgementDecls)
sem_JudgementDecls_Nil  =
    \ _lhsItypes ->
        let _lhsOjudgements :: (JudgementsAL)
            _lhsOself :: (JudgementDecls)
            _lhsOstaticErrors :: (StaticMessages)
            (_lhsOjudgements@_) =
                []
            (_lhsOstaticErrors@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
        in  ( _lhsOjudgements,_lhsOself,_lhsOstaticErrors)
-- Judgements --------------------------------------------------
-- semantic domain
type T_Judgements = (AGDatas) ->
                    (ArgTypesMap) ->
                    (FunctionEnvironment) ->
                    (Bool) ->
                    (JudgementsMap) ->
                    (VarAL) ->
                    ([String]) ->
                    (String) ->
                    ( ([String]),([String]),(PremiseAttrs),(Judgements),(StaticMessages),(StaticMessages),([String]))
-- cata
sem_Judgements :: (Judgements) ->
                  (T_Judgements)
sem_Judgements (list) =
    (Prelude.foldr (sem_Judgements_Cons) (sem_Judgements_Nil) ((Prelude.map sem_Judgement list)))
sem_Judgements_Cons :: (T_Judgement) ->
                       (T_Judgements) ->
                       (T_Judgements)
sem_Judgements_Cons (hd_) (tl_) =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIisConclusion
      _lhsIjudgementsMap
      _lhsImetaVarAL
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOdeclaredVars :: ([String])
            _lhsOpremiseAttrs :: (PremiseAttrs)
            _lhsOself :: (Judgements)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            _lhsOusedVars :: ([String])
            _hdIallVariables :: ([String])
            _hdIdeclaredVars :: ([String])
            _hdIpremiseAttrs :: (PremiseAttrs)
            _hdIself :: (Judgement)
            _hdIstaticErrors :: (StaticMessages)
            _hdIstaticWarnings :: (StaticMessages)
            _hdIusedVars :: ([String])
            _hdOagdatas :: (AGDatas)
            _hdOargTypesMap :: (ArgTypesMap)
            _hdOfunctions :: (FunctionEnvironment)
            _hdOisConclusion :: (Bool)
            _hdOjudgementsMap :: (JudgementsMap)
            _hdOmetaVarAL :: (VarAL)
            _hdOnts :: ([String])
            _hdOrulename :: (String)
            _tlIallVariables :: ([String])
            _tlIdeclaredVars :: ([String])
            _tlIpremiseAttrs :: (PremiseAttrs)
            _tlIself :: (Judgements)
            _tlIstaticErrors :: (StaticMessages)
            _tlIstaticWarnings :: (StaticMessages)
            _tlIusedVars :: ([String])
            _tlOagdatas :: (AGDatas)
            _tlOargTypesMap :: (ArgTypesMap)
            _tlOfunctions :: (FunctionEnvironment)
            _tlOisConclusion :: (Bool)
            _tlOjudgementsMap :: (JudgementsMap)
            _tlOmetaVarAL :: (VarAL)
            _tlOnts :: ([String])
            _tlOrulename :: (String)
            ( _hdIallVariables,_hdIdeclaredVars,_hdIpremiseAttrs,_hdIself,_hdIstaticErrors,_hdIstaticWarnings,_hdIusedVars) =
                (hd_ (_hdOagdatas) (_hdOargTypesMap) (_hdOfunctions) (_hdOisConclusion) (_hdOjudgementsMap) (_hdOmetaVarAL) (_hdOnts) (_hdOrulename))
            ( _tlIallVariables,_tlIdeclaredVars,_tlIpremiseAttrs,_tlIself,_tlIstaticErrors,_tlIstaticWarnings,_tlIusedVars) =
                (tl_ (_tlOagdatas) (_tlOargTypesMap) (_tlOfunctions) (_tlOisConclusion) (_tlOjudgementsMap) (_tlOmetaVarAL) (_tlOnts) (_tlOrulename))
            (_lhsOallVariables@_) =
                _hdIallVariables  ++  _tlIallVariables
            (_lhsOdeclaredVars@_) =
                _hdIdeclaredVars  ++  _tlIdeclaredVars
            (_lhsOpremiseAttrs@_) =
                _hdIpremiseAttrs  ++  _tlIpremiseAttrs
            (_lhsOstaticErrors@_) =
                _hdIstaticErrors  ++  _tlIstaticErrors
            (_lhsOstaticWarnings@_) =
                _hdIstaticWarnings  ++  _tlIstaticWarnings
            (_lhsOusedVars@_) =
                _hdIusedVars  ++  _tlIusedVars
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_hdOagdatas@_) =
                _lhsIagdatas
            (_hdOargTypesMap@_) =
                _lhsIargTypesMap
            (_hdOfunctions@_) =
                _lhsIfunctions
            (_hdOisConclusion@_) =
                _lhsIisConclusion
            (_hdOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_hdOmetaVarAL@_) =
                _lhsImetaVarAL
            (_hdOnts@_) =
                _lhsInts
            (_hdOrulename@_) =
                _lhsIrulename
            (_tlOagdatas@_) =
                _lhsIagdatas
            (_tlOargTypesMap@_) =
                _lhsIargTypesMap
            (_tlOfunctions@_) =
                _lhsIfunctions
            (_tlOisConclusion@_) =
                _lhsIisConclusion
            (_tlOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_tlOmetaVarAL@_) =
                _lhsImetaVarAL
            (_tlOnts@_) =
                _lhsInts
            (_tlOrulename@_) =
                _lhsIrulename
        in  ( _lhsOallVariables,_lhsOdeclaredVars,_lhsOpremiseAttrs,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings,_lhsOusedVars)
sem_Judgements_Nil :: (T_Judgements)
sem_Judgements_Nil  =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIisConclusion
      _lhsIjudgementsMap
      _lhsImetaVarAL
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOdeclaredVars :: ([String])
            _lhsOpremiseAttrs :: (PremiseAttrs)
            _lhsOself :: (Judgements)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            _lhsOusedVars :: ([String])
            (_lhsOallVariables@_) =
                []
            (_lhsOdeclaredVars@_) =
                []
            (_lhsOpremiseAttrs@_) =
                []
            (_lhsOstaticErrors@_) =
                []
            (_lhsOstaticWarnings@_) =
                []
            (_lhsOusedVars@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
        in  ( _lhsOallVariables,_lhsOdeclaredVars,_lhsOpremiseAttrs,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings,_lhsOusedVars)
-- Term --------------------------------------------------------
-- semantic domain
type T_Term = (AGDatas) ->
              (ArgTypesMap) ->
              (FunctionEnvironment) ->
              (JudgementsMap) ->
              ([String]) ->
              (String) ->
              ( ([String]),(Term),(StaticMessages),(StaticMessages))
-- cata
sem_Term :: (Term) ->
            (T_Term)
sem_Term ((TermApp (_function) (_arguments))) =
    (sem_Term_TermApp (_function) ((sem_Terms (_arguments))))
sem_Term ((TermString (_string))) =
    (sem_Term_TermString (_string))
sem_Term ((TermVar (_variable))) =
    (sem_Term_TermVar (_variable))
sem_Term_TermApp :: (String) ->
                    (T_Terms) ->
                    (T_Term)
sem_Term_TermApp (function_) (arguments_) =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOself :: (Term)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            _argumentsIallVariables :: ([String])
            _argumentsIself :: (Terms)
            _argumentsIstaticErrors :: (StaticMessages)
            _argumentsIstaticWarnings :: (StaticMessages)
            _argumentsOagdatas :: (AGDatas)
            _argumentsOargTypesMap :: (ArgTypesMap)
            _argumentsOfunctions :: (FunctionEnvironment)
            _argumentsOjudgementsMap :: (JudgementsMap)
            _argumentsOnts :: ([String])
            _argumentsOrulename :: (String)
            ( _argumentsIallVariables,_argumentsIself,_argumentsIstaticErrors,_argumentsIstaticWarnings) =
                (arguments_ (_argumentsOagdatas) (_argumentsOargTypesMap) (_argumentsOfunctions) (_argumentsOjudgementsMap) (_argumentsOnts) (_argumentsOrulename))
            (_lhsOstaticErrors@_) =
                [ FunctionNotDefined _lhsIrulename function_
                | function_ `notElem` keysFM _lhsIfunctions
                ] ++
                _argumentsIstaticErrors
            (_lhsOallVariables@_) =
                _argumentsIallVariables
            (_lhsOstaticWarnings@_) =
                _argumentsIstaticWarnings
            (_self@_) =
                TermApp function_ _argumentsIself
            (_lhsOself@_) =
                _self
            (_argumentsOagdatas@_) =
                _lhsIagdatas
            (_argumentsOargTypesMap@_) =
                _lhsIargTypesMap
            (_argumentsOfunctions@_) =
                _lhsIfunctions
            (_argumentsOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_argumentsOnts@_) =
                _lhsInts
            (_argumentsOrulename@_) =
                _lhsIrulename
        in  ( _lhsOallVariables,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)
sem_Term_TermString :: (String) ->
                       (T_Term)
sem_Term_TermString (string_) =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOself :: (Term)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            (_lhsOallVariables@_) =
                []
            (_lhsOstaticErrors@_) =
                []
            (_lhsOstaticWarnings@_) =
                []
            (_self@_) =
                TermString string_
            (_lhsOself@_) =
                _self
        in  ( _lhsOallVariables,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)
sem_Term_TermVar :: (String) ->
                    (T_Term)
sem_Term_TermVar (variable_) =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOself :: (Term)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            (_lhsOallVariables@_) =
                [variable_]
            (_lhsOstaticErrors@_) =
                []
            (_lhsOstaticWarnings@_) =
                []
            (_self@_) =
                TermVar variable_
            (_lhsOself@_) =
                _self
        in  ( _lhsOallVariables,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)
-- Terms -------------------------------------------------------
-- semantic domain
type T_Terms = (AGDatas) ->
               (ArgTypesMap) ->
               (FunctionEnvironment) ->
               (JudgementsMap) ->
               ([String]) ->
               (String) ->
               ( ([String]),(Terms),(StaticMessages),(StaticMessages))
-- cata
sem_Terms :: (Terms) ->
             (T_Terms)
sem_Terms (list) =
    (Prelude.foldr (sem_Terms_Cons) (sem_Terms_Nil) ((Prelude.map sem_Term list)))
sem_Terms_Cons :: (T_Term) ->
                  (T_Terms) ->
                  (T_Terms)
sem_Terms_Cons (hd_) (tl_) =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOself :: (Terms)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            _hdIallVariables :: ([String])
            _hdIself :: (Term)
            _hdIstaticErrors :: (StaticMessages)
            _hdIstaticWarnings :: (StaticMessages)
            _hdOagdatas :: (AGDatas)
            _hdOargTypesMap :: (ArgTypesMap)
            _hdOfunctions :: (FunctionEnvironment)
            _hdOjudgementsMap :: (JudgementsMap)
            _hdOnts :: ([String])
            _hdOrulename :: (String)
            _tlIallVariables :: ([String])
            _tlIself :: (Terms)
            _tlIstaticErrors :: (StaticMessages)
            _tlIstaticWarnings :: (StaticMessages)
            _tlOagdatas :: (AGDatas)
            _tlOargTypesMap :: (ArgTypesMap)
            _tlOfunctions :: (FunctionEnvironment)
            _tlOjudgementsMap :: (JudgementsMap)
            _tlOnts :: ([String])
            _tlOrulename :: (String)
            ( _hdIallVariables,_hdIself,_hdIstaticErrors,_hdIstaticWarnings) =
                (hd_ (_hdOagdatas) (_hdOargTypesMap) (_hdOfunctions) (_hdOjudgementsMap) (_hdOnts) (_hdOrulename))
            ( _tlIallVariables,_tlIself,_tlIstaticErrors,_tlIstaticWarnings) =
                (tl_ (_tlOagdatas) (_tlOargTypesMap) (_tlOfunctions) (_tlOjudgementsMap) (_tlOnts) (_tlOrulename))
            (_lhsOallVariables@_) =
                _hdIallVariables  ++  _tlIallVariables
            (_lhsOstaticErrors@_) =
                _hdIstaticErrors  ++  _tlIstaticErrors
            (_lhsOstaticWarnings@_) =
                _hdIstaticWarnings  ++  _tlIstaticWarnings
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_hdOagdatas@_) =
                _lhsIagdatas
            (_hdOargTypesMap@_) =
                _lhsIargTypesMap
            (_hdOfunctions@_) =
                _lhsIfunctions
            (_hdOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_hdOnts@_) =
                _lhsInts
            (_hdOrulename@_) =
                _lhsIrulename
            (_tlOagdatas@_) =
                _lhsIagdatas
            (_tlOargTypesMap@_) =
                _lhsIargTypesMap
            (_tlOfunctions@_) =
                _lhsIfunctions
            (_tlOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_tlOnts@_) =
                _lhsInts
            (_tlOrulename@_) =
                _lhsIrulename
        in  ( _lhsOallVariables,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)
sem_Terms_Nil :: (T_Terms)
sem_Terms_Nil  =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts
      _lhsIrulename ->
        let _lhsOallVariables :: ([String])
            _lhsOself :: (Terms)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            (_lhsOallVariables@_) =
                []
            (_lhsOstaticErrors@_) =
                []
            (_lhsOstaticWarnings@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
        in  ( _lhsOallVariables,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)
-- TypeRule ----------------------------------------------------
-- semantic domain
type T_TypeRule = (AGDatas) ->
                  (ArgTypesMap) ->
                  (FunctionEnvironment) ->
                  (JudgementsMap) ->
                  ([String]) ->
                  ( ([String]),(TypeRule),(StaticMessages),(StaticMessages))
-- cata
sem_TypeRule :: (TypeRule) ->
                (T_TypeRule)
sem_TypeRule ((TypeRule (_rulename) (_deduction) (_constraints))) =
    (sem_TypeRule_TypeRule (_rulename) ((sem_DeductionRule (_deduction))) ((sem_ConstraintTerms (_constraints))))
sem_TypeRule_TypeRule :: (String) ->
                         (T_DeductionRule) ->
                         (T_ConstraintTerms) ->
                         (T_TypeRule)
sem_TypeRule_TypeRule (rulename_) (deduction_) (constraints_) =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts ->
        let _lhsOrulenames :: ([String])
            _lhsOself :: (TypeRule)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            _deductionIallVariables :: ([String])
            _deductionIconclusionAttr :: (ConclusionAttr)
            _deductionIdeclaredVars :: ([String])
            _deductionIpremiseAttrs :: (PremiseAttrs)
            _deductionIself :: (DeductionRule)
            _deductionIstaticErrors :: (StaticMessages)
            _deductionIstaticWarnings :: (StaticMessages)
            _deductionIusedVars :: ([String])
            _deductionOagdatas :: (AGDatas)
            _deductionOargTypesMap :: (ArgTypesMap)
            _deductionOfunctions :: (FunctionEnvironment)
            _deductionOjudgementsMap :: (JudgementsMap)
            _deductionOnts :: ([String])
            _deductionOrulename :: (String)
            _constraintsIallVariables :: ([String])
            _constraintsIself :: (ConstraintTerms)
            _constraintsIstaticErrors :: (StaticMessages)
            _constraintsIstaticWarnings :: (StaticMessages)
            _constraintsOagdatas :: (AGDatas)
            _constraintsOargTypesMap :: (ArgTypesMap)
            _constraintsOfunctions :: (FunctionEnvironment)
            _constraintsOjudgementsMap :: (JudgementsMap)
            _constraintsOnts :: ([String])
            _constraintsOrulename :: (String)
            ( _deductionIallVariables,_deductionIconclusionAttr,_deductionIdeclaredVars,_deductionIpremiseAttrs,_deductionIself,_deductionIstaticErrors,_deductionIstaticWarnings,_deductionIusedVars) =
                (deduction_ (_deductionOagdatas) (_deductionOargTypesMap) (_deductionOfunctions) (_deductionOjudgementsMap) (_deductionOnts) (_deductionOrulename))
            ( _constraintsIallVariables,_constraintsIself,_constraintsIstaticErrors,_constraintsIstaticWarnings) =
                (constraints_ (_constraintsOagdatas) (_constraintsOargTypesMap) (_constraintsOfunctions) (_constraintsOjudgementsMap) (_constraintsOnts) (_constraintsOrulename))
            (_constraintsOrulename@_) =
                rulename_
            (_deductionOrulename@_) =
                rulename_
            (_lhsOrulenames@_) =
                [rulename_]
            (_lhsOstaticErrors@_) =
                _deductionIstaticErrors  ++  _constraintsIstaticErrors
            (_lhsOstaticWarnings@_) =
                _deductionIstaticWarnings  ++  _constraintsIstaticWarnings
            (_self@_) =
                TypeRule rulename_ _deductionIself _constraintsIself
            (_lhsOself@_) =
                _self
            (_deductionOagdatas@_) =
                _lhsIagdatas
            (_deductionOargTypesMap@_) =
                _lhsIargTypesMap
            (_deductionOfunctions@_) =
                _lhsIfunctions
            (_deductionOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_deductionOnts@_) =
                _lhsInts
            (_constraintsOagdatas@_) =
                _lhsIagdatas
            (_constraintsOargTypesMap@_) =
                _lhsIargTypesMap
            (_constraintsOfunctions@_) =
                _lhsIfunctions
            (_constraintsOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_constraintsOnts@_) =
                _lhsInts
        in  ( _lhsOrulenames,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)
-- TypeRules ---------------------------------------------------
-- semantic domain
type T_TypeRules = (AGDatas) ->
                   (ArgTypesMap) ->
                   (FunctionEnvironment) ->
                   (JudgementsMap) ->
                   ([String]) ->
                   ( ([String]),(TypeRules),(StaticMessages),(StaticMessages))
-- cata
sem_TypeRules :: (TypeRules) ->
                 (T_TypeRules)
sem_TypeRules (list) =
    (Prelude.foldr (sem_TypeRules_Cons) (sem_TypeRules_Nil) ((Prelude.map sem_TypeRule list)))
sem_TypeRules_Cons :: (T_TypeRule) ->
                      (T_TypeRules) ->
                      (T_TypeRules)
sem_TypeRules_Cons (hd_) (tl_) =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts ->
        let _lhsOrulenames :: ([String])
            _lhsOself :: (TypeRules)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            _hdIrulenames :: ([String])
            _hdIself :: (TypeRule)
            _hdIstaticErrors :: (StaticMessages)
            _hdIstaticWarnings :: (StaticMessages)
            _hdOagdatas :: (AGDatas)
            _hdOargTypesMap :: (ArgTypesMap)
            _hdOfunctions :: (FunctionEnvironment)
            _hdOjudgementsMap :: (JudgementsMap)
            _hdOnts :: ([String])
            _tlIrulenames :: ([String])
            _tlIself :: (TypeRules)
            _tlIstaticErrors :: (StaticMessages)
            _tlIstaticWarnings :: (StaticMessages)
            _tlOagdatas :: (AGDatas)
            _tlOargTypesMap :: (ArgTypesMap)
            _tlOfunctions :: (FunctionEnvironment)
            _tlOjudgementsMap :: (JudgementsMap)
            _tlOnts :: ([String])
            ( _hdIrulenames,_hdIself,_hdIstaticErrors,_hdIstaticWarnings) =
                (hd_ (_hdOagdatas) (_hdOargTypesMap) (_hdOfunctions) (_hdOjudgementsMap) (_hdOnts))
            ( _tlIrulenames,_tlIself,_tlIstaticErrors,_tlIstaticWarnings) =
                (tl_ (_tlOagdatas) (_tlOargTypesMap) (_tlOfunctions) (_tlOjudgementsMap) (_tlOnts))
            (_lhsOrulenames@_) =
                _hdIrulenames  ++  _tlIrulenames
            (_lhsOstaticErrors@_) =
                _hdIstaticErrors  ++  _tlIstaticErrors
            (_lhsOstaticWarnings@_) =
                _hdIstaticWarnings  ++  _tlIstaticWarnings
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_hdOagdatas@_) =
                _lhsIagdatas
            (_hdOargTypesMap@_) =
                _lhsIargTypesMap
            (_hdOfunctions@_) =
                _lhsIfunctions
            (_hdOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_hdOnts@_) =
                _lhsInts
            (_tlOagdatas@_) =
                _lhsIagdatas
            (_tlOargTypesMap@_) =
                _lhsIargTypesMap
            (_tlOfunctions@_) =
                _lhsIfunctions
            (_tlOjudgementsMap@_) =
                _lhsIjudgementsMap
            (_tlOnts@_) =
                _lhsInts
        in  ( _lhsOrulenames,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)
sem_TypeRules_Nil :: (T_TypeRules)
sem_TypeRules_Nil  =
    \ _lhsIagdatas
      _lhsIargTypesMap
      _lhsIfunctions
      _lhsIjudgementsMap
      _lhsInts ->
        let _lhsOrulenames :: ([String])
            _lhsOself :: (TypeRules)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            (_lhsOrulenames@_) =
                []
            (_lhsOstaticErrors@_) =
                []
            (_lhsOstaticWarnings@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
        in  ( _lhsOrulenames,_lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)
-- TypeSystem --------------------------------------------------
-- semantic domain
type T_TypeSystem = (ClassEnvironment) ->
                    (FunctionEnvironment) ->
                    ( (TypeSystem),(StaticMessages),(StaticMessages))
-- cata
sem_TypeSystem :: (TypeSystem) ->
                  (T_TypeSystem)
sem_TypeSystem ((TypeSystem (_agDATAs) (_judgementdecls) (_typerules))) =
    (sem_TypeSystem_TypeSystem ((sem_AGDatas (_agDATAs))) ((sem_JudgementDecls (_judgementdecls))) ((sem_TypeRules (_typerules))))
sem_TypeSystem_TypeSystem :: (T_AGDatas) ->
                             (T_JudgementDecls) ->
                             (T_TypeRules) ->
                             (T_TypeSystem)
sem_TypeSystem_TypeSystem (agDATAs_) (judgementdecls_) (typerules_) =
    \ _lhsIclassEnvironment
      _lhsIfunctions ->
        let _lhsOself :: (TypeSystem)
            _lhsOstaticErrors :: (StaticMessages)
            _lhsOstaticWarnings :: (StaticMessages)
            _agDATAsIaltargtypes :: ([(String, [String])])
            _agDATAsIaltnts :: ([(String, String)])
            _agDATAsIalttypes :: ([(String, TpScheme)])
            _agDATAsIself :: (AGDatas)
            _judgementdeclsIjudgements :: (JudgementsAL)
            _judgementdeclsIself :: (JudgementDecls)
            _judgementdeclsIstaticErrors :: (StaticMessages)
            _judgementdeclsOtypes :: ([String])
            _typerulesIrulenames :: ([String])
            _typerulesIself :: (TypeRules)
            _typerulesIstaticErrors :: (StaticMessages)
            _typerulesIstaticWarnings :: (StaticMessages)
            _typerulesOagdatas :: (AGDatas)
            _typerulesOargTypesMap :: (ArgTypesMap)
            _typerulesOfunctions :: (FunctionEnvironment)
            _typerulesOjudgementsMap :: (JudgementsMap)
            _typerulesOnts :: ([String])
            ( _agDATAsIaltargtypes,_agDATAsIaltnts,_agDATAsIalttypes,_agDATAsIself) =
                (agDATAs_ )
            ( _judgementdeclsIjudgements,_judgementdeclsIself,_judgementdeclsIstaticErrors) =
                (judgementdecls_ (_judgementdeclsOtypes))
            ( _typerulesIrulenames,_typerulesIself,_typerulesIstaticErrors,_typerulesIstaticWarnings) =
                (typerules_ (_typerulesOagdatas) (_typerulesOargTypesMap) (_typerulesOfunctions) (_typerulesOjudgementsMap) (_typerulesOnts))
            (_errorsAfterWhichTyperulesAreSkipped@_) =
                _ntNotDefined ++ _ntMissesJudgement ++ _dupAlternative ++ _judgementdeclsIstaticErrors
            (_ntMissesJudgement@_) =
                [ MissesJudgement nt
                | nt <- _agnts
                , not (nt `elem` _judgementsnts)
                ]
            (_ntNotDefined@_) =
                [ NonTerminalNotDefined nt
                | nt <- _judgementsnts
                , not (nt `elem` _agnts)
                ]
            (_dupAlternative@_) =
                [ DuplicateAlternative x | x <- duplicates _alternatives ]
            (_dupRuleName@_) =
                [ DuplicateRuleName x | x <- duplicates _typerulesIrulenames ]
            (_judgementsnts@_) =
                nub (domainAL _judgementdeclsIjudgements)
            (_agnts@_) =
                nub (rangeAL _agDATAsIaltnts)
            (_alternatives@_) =
                nub (domainAL _agDATAsIaltnts)
            (_typerulesOnts@_) =
                _agnts
            (_typerulesOjudgementsMap@_) =
                listToFM (joinAL _agDATAsIaltnts _judgementdeclsIjudgements)
            (_typerulesOargTypesMap@_) =
                listToFM _agDATAsIaltargtypes
            (_judgementdeclsOtypes@_) =
                nub (map constantsInType (values _allfunctions))
            (_typerulesOfunctions@_) =
                _allfunctions
            (_allfunctions@_) =
                _lhsIfunctions `plusFM` listToFM _agDATAsIalttypes
            (_typerulesOagdatas@_) =
                _agDATAsIself
            (_lhsOstaticErrors@_) =
                _errorsAfterWhichTyperulesAreSkipped ++
                _dupRuleName ++
                if null _errorsAfterWhichTyperulesAreSkipped then _typerulesIstaticErrors else []
            (_self@_) =
                TypeSystem _agDATAsIself _judgementdeclsIself _typerulesIself
            (_lhsOself@_) =
                _self
            (_lhsOstaticWarnings@_) =
                _typerulesIstaticWarnings
        in  ( _lhsOself,_lhsOstaticErrors,_lhsOstaticWarnings)


