-- do not edit; automatically generated by UU.AG
module TypeInferencing where


-- types
import Top.Types
import TypeConversion

-- error messages and warnings
import Messages
import TypeErrors
import Warnings
import ConstraintInfo
import DoublyLinkedTree
import UHA_Source

-- constraints and constraint trees
import TypeConstraints
import Top.Ordering.Tree

-- constraint solving
import SelectConstraintSolver (selectConstraintSolver)
import Top.Solver (SolveResult(..), LogEntries)
import HeuristicsInfo (makeUnifier, skip_UHA_FB_RHS)
import BindingGroupAnalysis

-- UHA syntax
import UHA_Syntax
import UHA_Range                 
import UHA_Utils                 (showNameAsOperator, intUnaryMinusName, NameWithRange(..), nameFromString)
         
-- other
import Utils                     (internalError)
import DerivingShow              (typeOfShowFunction, nameOfShowFunction)
import ImportEnvironment  hiding (setTypeSynonyms)
import DictionaryEnvironment
import Args

-- standard
import qualified Data.Map as M
import Data.Maybe 
import Data.List

import List
import Matchers
import TS_Apply (applyTypingStrategy, matchInformation)
import TS_CoreSyntax
import TS_Attributes

import UHA_Utils

typeInferencing :: [Option] -> ImportEnvironment -> Module
                      -> (IO (), DictionaryEnvironment, TypeEnvironment, TypeErrors, Warnings)
typeInferencing options importEnv module_ =
   let (_, dictionaryEnv, _, logEntries, _, solveResult, toplevelTypes, typeErrors, warnings) =
            TypeInferencing.sem_Module module_ importEnv options
       debugIO = putStrLn (show logEntries)
   in (debugIO, dictionaryEnv, toplevelTypes, typeErrors, warnings)

proximaTypeInferencing :: [Option] -> ImportEnvironment -> Module
                      -> (TypeErrors, Warnings, TypeEnvironment, [(Range, TpScheme)])  
proximaTypeInferencing options importEnv module_ =
   let (_, _, infoTree, _, _, solveResult, toplevelTypes, typeErrors, warnings) =
            TypeInferencing.sem_Module module_ importEnv options
       localTypeSchemes = typeSchemesInInfoTree (substitutionFromResult solveResult)
                                                (qualifiersFromResult solveResult) 
                                                infoTree
   in (typeErrors, warnings, toplevelTypes, localTypeSchemes)
         
getRequiredDictionaries :: OrderedTypeSynonyms -> Tp -> TpScheme -> Predicates
getRequiredDictionaries synonyms useType defType =
   expandPredicates synonyms (matchTypeWithScheme synonyms useType defType)

matchTypeWithScheme :: OrderedTypeSynonyms -> Tp -> TpScheme -> Predicates
matchTypeWithScheme synonyms tp scheme =
   let (ips, itp) = split . snd . instantiate 0 . freezeFTV $ scheme
   in case mguWithTypeSynonyms synonyms itp (freezeVariablesInType tp) of
         Left _ -> internalError "TypeInferenceOverloading.ag" "matchTypeWithScheme" "no unification"
         Right (_, sub) -> 
            let f (Predicate s tp) = Predicate s (unfreezeVariablesInType $ sub |-> tp)
            in map f ips
            
resolveOverloading :: ClassEnvironment -> Name -> Predicates -> Predicates ->
                         DictionaryEnvironment -> DictionaryEnvironment
resolveOverloading classEnv name availablePredicates predicates dEnv = 
   let maybeTrees = map (makeDictionaryTree classEnv availablePredicates) predicates
   in if all isJust maybeTrees
        then addForVariable name (map fromJust maybeTrees) dEnv
        else internalError "TypeInferenceOverloading.ag" "resolveOverloading" ("cannot resolve overloading (" ++ show name ++ ")")
   
expandPredicates :: OrderedTypeSynonyms -> Predicates -> Predicates
expandPredicates synonyms = map (expandPredicate synonyms)

expandPredicate :: OrderedTypeSynonyms -> Predicate -> Predicate
expandPredicate (_, synonyms) (Predicate className tp) = Predicate className (expandType synonyms tp)

findInferredTypes :: M.Map Int (Scheme Predicates) -> M.Map Name (Sigma Predicates) -> TypeEnvironment
findInferredTypes typeschemeMap =
   let err = internalError "TypeInferenceCollect.ag" "findInferredTypes" "could not find type scheme variable"
       f :: Sigma Predicates -> TpScheme
       f (SigmaVar i)     = M.findWithDefault err i typeschemeMap
       f (SigmaScheme ts) = ts
   in M.map f
   
missingTypeSignature :: Bool -> Names -> TypeEnvironment -> Warnings
missingTypeSignature topLevel simplePats = 
   let -- for the moment, only missing type signature for top-level functions are reported (unless monomorphic).
      makeWarning (name, scheme) =
         let fromSimple = name `elem` simplePats && isOverloaded scheme
         in [ NoTypeDef name scheme topLevel fromSimple | null (ftv scheme) && (topLevel || fromSimple)  ]
   in concatMap makeWarning . M.assocs
   
restrictedNameErrors :: TypeEnvironment -> Names -> TypeErrors
restrictedNameErrors env = 
   let f name = case M.lookup name env of
                   Just scheme -> [ makeRestrictedButOverloadedError name scheme | isOverloaded scheme ]
                   Nothing     -> []
   in concatMap f


makeLocalTypeEnv :: TypeEnvironment -> BindingGroups -> M.Map NameWithRange TpScheme
makeLocalTypeEnv local groups =
   let (environment, _, _) = concatBindingGroups groups
       names = M.keys environment
       f x   = maybe err id (find (==x) names) 
       err   = internalError "TypeInferenceCollect.ag" "makeLocalTypeEnv" "could not find name"
   in M.fromList [ (NameWithRange (f name), scheme) | (name, scheme) <- M.assocs local ]

isSimplePattern :: Pattern -> Bool
isSimplePattern pattern =
   case pattern of
      Pattern_Variable _ _ -> True
      Pattern_Parenthesized  _ p -> isSimplePattern p
      _ -> False

globalInfoError :: a
globalInfoError = internalError "GlobalInfo.ag" "n/a" "global info not available"
                  
type ScopeInfo = ( [Names]          -- duplicated variables
                 , [Name]           -- unused variables
                 , [(Name, Name)]   -- shadowed variables
                 )

changeOfScope :: Names -> Names -> Names -> (Names, Names, ScopeInfo)
changeOfScope names unboundNames namesInScope = 
   let (uniqueNames, duplicatedNames) = uniqueAppearance names
       unusedNames   = uniqueNames \\ unboundNames
       shadowedNames = let f n = [ (n, n') | n' <- namesInScope, n == n' ]
                       in concatMap f uniqueNames
   in ( uniqueNames ++ map head duplicatedNames ++ (namesInScope \\ names)
      , unboundNames \\ names
      , (duplicatedNames, unusedNames, shadowedNames)
      )
      
uniqueAppearance :: Ord a => [a] -> ([a],[[a]])
uniqueAppearance = foldr insert ([],[]) . group . sort
   where insert [x] (as,bs) = (x:as,bs)
         insert xs  (as,bs) = (as,xs:bs)

matchConverter0 :: [([String],())] -> ()
matchConverter0 = const ()

matchConverter1 :: [([String],a)] -> [(a,[String])]
matchConverter1 = map (\(a,b) -> (b,a))  
                  
matchConverter2 :: [([String],(a,b))] -> ([(a,[String])],[(b,[String])])
matchConverter2 = let insert (metas,(a,b)) (as,bs) = ((a,metas):as,(b,metas):bs)
                  in foldr insert ([],[])                  

matchConverter3 :: [([String],(a,b,c))] -> ([(a,[String])],[(b,[String])],[(c,[String])])
matchConverter3 = let insert (metas,(a,b,c)) (as,bs,cs) = ((a,metas):as,(b,metas):bs,(c,metas):cs)
                  in foldr insert ([],[],[]) 

allMatch :: [Maybe [a]] -> Maybe [a]
allMatch = rec []
  where rec xs []             = Just xs
        rec xs (Nothing:_)    = Nothing
        rec xs (Just ys:rest) = rec (ys ++ xs) rest

data Match a = NoMatch | NonTerminalMatch a | MetaVariableMatch String

instance Show (Match a) where
  show (NoMatch) = "NoMatch"
  show (NonTerminalMatch a) = "NonTerminal ??"
  show (MetaVariableMatch s) = "MetaVariableMatch "++show s

expressionVariableMatcher :: Expression -> Maybe String
expressionVariableMatcher expr =
   case expr of
      Expression_Variable _ name -> Just (show name)
      _                          -> Nothing

match0 = generalMatch expressionVariableMatcher matchConverter0
match1 = generalMatch expressionVariableMatcher matchConverter1
match2 = generalMatch expressionVariableMatcher matchConverter2
match3 = generalMatch expressionVariableMatcher matchConverter3

match0' = generalMatch noMatch matchConverter0 noMetaVariableInfo 0
match1' = generalMatch noMatch matchConverter1 noMetaVariableInfo 0
match2' = generalMatch noMatch matchConverter2 noMetaVariableInfo 0

matchOnlyVariable infoTuple tryPats = 
       let ((),matches,_,_,_,_) = match0 infoTuple 0 noMatch tryPats [] []
   in matches

noMatch :: a -> Maybe b
noMatch = const Nothing

noMetaVariableInfo = internalError "PatternMatching.ag" "noMetaVariableInfo" ""

generalMatch :: (nonTerminal -> Maybe String) 
             -> ([([String], childrenTuple)] -> childrenResult)
             -> MetaVariableInfo
             -> Int
             -> (nonTerminal -> Maybe childrenTuple) 
             -> [(nonTerminal, [String])] 
             -> [((nonTerminal, [String]), Core_TypingStrategy)] 
             -> [[Maybe MetaVariableTable]] 
             -> ( childrenResult
                , [Maybe MetaVariableTable]
                , ConstraintSet
                , Assumptions
                , Int
                , IO ()
                )

generalMatch exprVarMatcher converter metaInfo unique matcher tryPats allPats childrenResults =
   let match (expr,metas) = 
          case exprVarMatcher expr of
             Just s | s `elem` metas -> MetaVariableMatch s
             _ -> case matcher expr of
                     Just x  -> NonTerminalMatch (metas,x)
                     Nothing -> NoMatch
           
       (allPatterns, allStrategies) = unzip allPats
       matchListTry = map match tryPats
       matchListNew = map match allPatterns
       
       matchNTTry  = [ x | NonTerminalMatch x <- matchListTry ]
       matchNTNew  = [ x | NonTerminalMatch x <- matchListNew ]
       forChildren = converter (matchNTTry ++ matchNTNew)
       
       numberOfTry = length matchNTTry
       (resultTry,resultNew) = unzip . map (splitAt numberOfTry) $ 
                               if null childrenResults
                                 then [repeat (Just [])]
                                 else childrenResults
       inspectMatch m (res, nts) =
          case m of
             NoMatch             -> (Nothing:res, nts)
             NonTerminalMatch _  -> (allMatch (head nts):res, tail nts)
             MetaVariableMatch s -> (Just [(s, metaInfo)]:res, nts) --  !!!
       
       result   = fst (foldr inspectMatch ([],reverse $ transpose resultTry) matchListTry)       
       complete = let (list,_) = foldr inspectMatch ([],reverse $ transpose resultNew) matchListNew
                  in [ (x, y) | (Just x, y) <- zip list allStrategies ]

       (assumptions, constraintSet, debugIO, newUnique) = 
          case complete of
          
             [] -> (getAssumptions metaInfo, getConstraintSet metaInfo, return (), unique)
             
             (childrenInfo, typingStrategy):_ 
                -> applyTypingStrategy typingStrategy metaInfo childrenInfo unique            
   in (forChildren, result, constraintSet, assumptions, newUnique, debugIO)

pmError = internalError "PatternMatchWarnings"

expandTypeFromImportEnvironment :: ImportEnvironment -> Tp -> Tp
expandTypeFromImportEnvironment env = expandType (snd $ getOrderedTypeSynonyms env)

patternMatchWarnings :: Substitution substitution
                     => ImportEnvironment          -- the importenvironment
                     -> substitution               -- substitution that contains the real types
                     -> Tp                         -- type of the patterns, unsubstituted
                     -> (Tp -> Tps)                -- how should the type be interpreted?
                     -> [([PatternElement], Bool)] -- the patterns to be processed
                     -> Range                      -- range for the missing-warnings
                     -> Maybe Name                 -- maybe the name of the function
                     -> Bool                       -- should there be parentheses around the patterns?
                     -> [Warning]                  -- list of overlap-warnings for all of the patterns  
                     -> String                     -- description of the place where the patterns are
                     -> String                     -- symbol after the patterns
                     -> [Warning]                  -- returns: list of warnings
patternMatchWarnings impenv sub tp strip elementss rng name parens unrwars place sym
  = unreachablewarnings ++ missingwarnings
    where
      env                 = importEnvironmentToEnv impenv
      exprtype            = expandTypeFromImportEnvironment impenv $ sub |-> tp
      types               = strip exprtype
      unreachables        = unreachable impenv types $ map (\((a, b), c) -> (a, c)) $ filter (not.snd.fst) $ zip elementss [0..]
      missing             = complement  impenv types $ map fst elementss
      unreachablewarnings = map (unrwars !!) unreachables
      missingwarnings
        | null $ unMissing missing = []
        | otherwise                = [MissingPatterns rng name exprtype (map (nicePattern parens env) $ missingList missing) place sym]


----------
-- misc --
----------

-- lifted or
(|^|) :: (a -> Bool) -> (a -> Bool) -> a -> Bool
(|^|) f g x = f x || g x

----------------------------------------------
--- environments and substitution of types ---
----------------------------------------------

-- environment of constructors [(type, (constructorname, arguments))]
type Env = [(Tp, (Name, [Tp]))]
importEnvironmentToEnv = map rearrange . M.assocs . valueConstructors

-- return the number of arguments of a constructor
-- tuples ar not in the Env so they require special treatment
nrOfArguments :: Env -> String -> Int
nrOfArguments env con | isTupleConstructor con = length con - 1
                      | otherwise = case lookup (nameFromString con) $ map snd env
                                    of Just args -> length args
                                       Nothing   -> 0

-- convert constructor to fit in an Env
rearrange :: (Name, TpScheme) -> (Tp, (Name, [Tp]))
rearrange (name, tpscheme) = let (args, res) = functionSpine $ unqualify $ unquantify tpscheme
                             in (res, (name, args))

-- get the constructors of a given type out of an Env
-- tuples ar not in the Env so they require special treatment
constructors :: ImportEnvironment -> Tp -> [(Name, [Tp])]
constructors _ (TVar _) = []
constructors impenv tp | isTupleConstructor name = [tupleconstructor]
                       | otherwise               = map expand $ concatMap (substitute tp) $ importEnvironmentToEnv impenv
  where
    name :: String
    name = unTCon $ fst $ leftSpine tp
    tupleconstructor :: (Name, [Tp])
    tupleconstructor = (nameFromString name, snd $ leftSpine tp)
    unTCon :: Tp -> String
    unTCon (TCon c) = c
    unTCon tp = pmError "unTCon" $ "type " ++ show tp ++ " is not a TCon"
    expand :: (Name, [Tp]) -> (Name, [Tp])
    expand (n, ts) = (n, map (expandTypeFromImportEnvironment impenv) ts)

-- check of an entry in an Env is a constructor for the given type
-- if so, return this constructor, but with variables substituted for whatever is in the given type
-- the list returns zero or one elements
-- for example: substitute (Maybe Int) (Maybe a, (Just, [a])) will return [(Just, [Int])]
substitute :: Tp -> (Tp, (Name, [Tp])) -> [(Name, [Tp])]
substitute t1 (t2, (con, args)) = let (c1, ts1) = leftSpine t1
                                      (c2, ts2) = leftSpine t2
                                      sub = listToSubstitution $ zip (map unTVar ts2) ts1
                                  in if c1 == c2
                                     then [(con, map (sub |->) args)]
                                     else []
  where
    unTVar :: Tp -> Int
    unTVar (TVar v) = v
    unTVar _ = pmError "unTVar" "type is not a TVar"

---------------------------------------------------------------
--- datastructures and functions for the solution structure ---
---------------------------------------------------------------

-- a pattern is a list of patternelements
data PatternElement = WildcardElement | InfiniteElement String | FiniteElement String deriving Eq
isInfiniteElement :: PatternElement -> Bool
isInfiniteElement (InfiniteElement _) = True
isInfiniteElement _                   = False
elementString :: PatternElement -> String
elementString (InfiniteElement s) = s
elementString (  FiniteElement s) = s
elementString _                   = []

-- needed for Pattern_List and Literal_String occurences
listPat :: [[PatternElement]] -> [PatternElement]
listPat [] = [FiniteElement "[]"]
listPat (ps:pss) = FiniteElement ":" : ps ++ listPat pss

stringPat :: String -> [PatternElement]
stringPat [] = [FiniteElement "[]"]
stringPat (c:cs) = FiniteElement ":" : InfiniteElement [c] : stringPat cs

-- tree of missing patterns
data PatternsMissing = PatternsMissing [(PatternElement, PatternsMissing)]
unMissing :: PatternsMissing -> [(PatternElement, PatternsMissing)]
unMissing (PatternsMissing l) = l

-- create a branch consisting of only wildcards
wildMissing :: Int -> PatternsMissing
wildMissing 0 = PatternsMissing []
wildMissing n = PatternsMissing [(WildcardElement, wildMissing $ n - 1)]

-- convert a missing patterns tree to a list of seperated missing patterns
missingList :: PatternsMissing -> [[PatternElement]]
missingList (PatternsMissing []) = [[]]
missingList (PatternsMissing [(d,t)]) = map (d:) $ missingList t
missingList (PatternsMissing (d:ds)) = (missingList $ PatternsMissing [d]) ++ (missingList $ PatternsMissing ds)

-------------------------------------------------------------------
--- functions to create a UHA_Pattern out of a [PatternElement] ---
-------------------------------------------------------------------

-- nice creates the actual pattern without parentheses
-- [Just, True, True, (,), Just, Nothing, False] -> [Just True, True, (Just Nothing, False)]
nicePattern :: Bool -> Env -> [PatternElement] -> [Pattern]
nicePattern b env = map (parensPattern b) . nice
  where
    nice :: [PatternElement] -> [Pattern]
    nice []             = []
    nice (WildcardElement    :ps) = Pattern_Wildcard noRange : nice ps
    nice (InfiniteElement _  :ps) = pmError "nicePattern" "InfiniteElement in pattern!"
    nice (FiniteElement con:ps) =
      let rest = nice ps
          name = nameFromString con
          n    = nrOfArguments env con
      in case name 
         of Name_Identifier _ _ _                          -> Pattern_Constructor noRange name (take n rest) : drop n rest -- !!!Name
            Name_Operator   _ _ _ | con == ":"             -> case head $ tail rest -- !!!Name
                                                              of Pattern_List _ ps -> Pattern_List noRange (head rest:ps) : (tail $ tail rest)
                                                                 _ -> Pattern_InfixConstructor noRange (head rest) name (head $ tail rest) : (tail $ tail rest)
                                  | otherwise              -> Pattern_InfixConstructor noRange (head rest) name (head $ tail rest) : (tail $ tail rest)
            Name_Special    _ _ _ | isTupleConstructor con -> Pattern_Tuple noRange (take n rest) : drop n rest -- !!!Name
                                  | con == "[]"            -> Pattern_List  noRange [] : rest
                                  | otherwise              -> Pattern_Constructor noRange name (take n rest) : drop n rest

-- add parentheses to a pattern in the correct places
-- bool means: if needed, should there be parenthesis around the complete pattern?
parensPattern :: Bool -> Pattern -> Pattern
parensPattern b = if b then rap . par else fst . par
  where
    par :: Pattern -> (Pattern, Bool) -- Bool means: are parentheses needed around this pattern, shoud it be used in a more complex pattern
    par p@(Pattern_Literal          _ _    ) = (p, False)
    par p@(Pattern_Variable         _ _    ) = (p, False)
    par   (Pattern_Constructor      r n ps ) = (Pattern_Constructor r n $ map (rap.par) ps, length ps > 0)
    par   (Pattern_Parenthesized    _ p    ) = par p
    par   (Pattern_InfixConstructor r l n k) = (Pattern_InfixConstructor r (rap $ par l) n (rap $ par k), True)
    par   (Pattern_List             r ps   ) = (Pattern_List r $ map (fst.par) ps, False)
    par   (Pattern_Tuple            r ps   ) = (Pattern_Tuple r $ map (fst.par) ps, False)
    par   (Pattern_Record           _ _ _  ) = pmError "parensPattern" "Records are not supported" 
    par p@(Pattern_Negate           _ _    ) = (p, True)
    par p@(Pattern_NegateFloat      _ _    ) = (p, True)
    par   (Pattern_As               r n p  ) = (Pattern_As r n (rap $ par p), False)
    par p@(Pattern_Wildcard         _      ) = (p, False)
    par   (Pattern_Irrefutable      _ _    ) = pmError "parensPattern" "Irrefutable patterns are not supported"  
    par   (Pattern_Successor        _ _ _  ) = pmError "parensPattern" "Successors are not supported" 
    rap :: (Pattern, Bool) -> Pattern
    rap (p, False) = p
    rap (p, True ) = Pattern_Parenthesized noRange p

--------------------------------------
--- finally, the algorithm itself! ---
--------------------------------------

-- returns the tree of missing patterns for a given list of patterns    
complement :: ImportEnvironment -> [Tp] -> [[PatternElement]] -> PatternsMissing
complement _   []       _      = PatternsMissing []
complement _   _        ([]:_) = PatternsMissing []
complement env (tp:tps) pss    | null $ unMissing anyComplement                              = PatternsMissing []
                               | all (((== WildcardElement) |^| isInfiniteElement).head) pss = anyComplement
                               | otherwise                                                   = finComplement
  where
    patComplement :: [[PatternElement]] -> PatternElement -> [Tp] -> PatternsMissing
    patComplement []  current tps = PatternsMissing [(current, wildMissing $ length tps)]
    patComplement pss current tps = case unMissing $ complement env tps $ map tail $ pss
                                    of []   -> PatternsMissing []
                                       tegs -> PatternsMissing [(current, PatternsMissing tegs)]
    anyComplement :: PatternsMissing
    anyComplement = patComplement (filter ((== WildcardElement).head) pss) WildcardElement tps
    conComplement :: (Name, [Tp]) -> PatternsMissing
    conComplement (con, args) = patComplement (  filter ((== FiniteElement (getNameName con)).head) pss
                                              ++ map (\ps -> FiniteElement (getNameName con) : replicate (length args) WildcardElement ++ tail ps)
                                                     (filter ((== WildcardElement).head) pss)
                                              )
                                              (FiniteElement (getNameName con)) (args ++ tps)
    finComplement :: PatternsMissing
    finComplement = case constructors env tp
                    of []   -> wildMissing $ 1 + length tps
                       cons -> PatternsMissing $ concatMap (unMissing.conComplement) cons

----------------------------
--- unreachable patterns ---
----------------------------

-- complements the list of reachable patterns
unreachable :: ImportEnvironment -> [Tp] -> [([PatternElement], Int)] -> [Int]
unreachable env tps ps = let reach = reachable env tps ps
                         in  filter (not . flip elem reach) (map snd ps)

-- determines which patterns are reachable
-- possibly multiple occurances of indices
reachable :: ImportEnvironment -> [Tp] -> [([PatternElement], Int)] -> [Int]
reachable _   []       _  = pmError "reachable" "empty type list!"
reachable env (tp:tps) ps 
  | all ((== WildcardElement).head.fst) ps = conReachable ps
  | otherwise                              = concat $ map (conReachable.conPats) $ stop cons
  where
    cons :: [PatternElement]
    cons = thin $ map (head.fst) ps
    conPats :: PatternElement -> [([PatternElement], Int)]
    conPats con = map (\(es, i) -> (fill con es, i)) $ filter (((== con) |^| (== WildcardElement)).head.fst) ps
    fill :: PatternElement -> [PatternElement] -> [PatternElement]
    fill e@(FiniteElement c) (WildcardElement : es) = e : replicate (nrOfArguments (importEnvironmentToEnv env) c) WildcardElement ++ es
    fill e                   (_               : es) = e : es
    stop :: [PatternElement] -> [PatternElement]
    stop es | length (constructors env tp) > length es = FiniteElement "[*]" : es
            | length (constructors env tp) == 0        = FiniteElement "[*]" : es
            | otherwise                                = es
    conReachable :: [([PatternElement], Int)] -> [Int]
    conReachable [] = []
    conReachable pats 
      | null.tail.fst.head $ pats = [snd.head $ pats]
      | otherwise                 = reachable env (arguments (elementString.head.fst.head $ pats) ++ tps) 
                                            $ map (\(es, i) -> (tail es, i)) pats
    arguments :: String -> [Tp]
    arguments c = maybe [] id $ lookup c $ map (\(n, tps) -> (getNameName n, tps)) $ constructors env tp

-- remove double occurances and wildcards
thin :: [PatternElement] -> [PatternElement]
thin []                     = []
thin (WildcardElement : es) = thin es
thin (e               : es) | elem e thines =     thines
                            | otherwise     = e : thines
  where thines = thin es                            
                       
-- Alternative -------------------------------------------------
-- semantic domain
type T_Alternative = ([((Expression, [String]), Core_TypingStrategy)]) ->
                     (M.Map NameWithRange TpScheme) ->
                     (Predicates) ->
                     (Tp) ->
                     (Tp) ->
                     (Int) ->
                     (ClassEnvironment) ->
                     (TypeErrors) ->
                     (Warnings) ->
                     (Int) ->
                     (DictionaryEnvironment) ->
                     (ImportEnvironment) ->
                     (IO ()) ->
                     (Monos) ->
                     (Names) ->
                     (OrderedTypeSynonyms) ->
                     (InfoTree) ->
                     ([Warning]) ->
                     (FixpointSubstitution) ->
                     (M.Map Int (Scheme Predicates)) ->
                     (Int) ->
                     ( (Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(DictionaryEnvironment),( ([PatternElement], Bool) ),(InfoTrees),(IO ()),([Warning]),(Alternative),(Names),(Int),(Warning))
-- cata
sem_Alternative :: (Alternative) ->
                   (T_Alternative)
sem_Alternative ((Alternative_Alternative (_range) (_pattern) (_righthandside))) =
    (sem_Alternative_Alternative ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_RightHandSide (_righthandside))))
sem_Alternative ((Alternative_Empty (_range))) =
    (sem_Alternative_Empty ((sem_Range (_range))))
sem_Alternative_Alternative :: (T_Range) ->
                               (T_Pattern) ->
                               (T_RightHandSide) ->
                               (T_Alternative)
sem_Alternative_Alternative (range_) (pattern_) (righthandside_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaLeft
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOelements :: ( ([PatternElement], Bool) )
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Alternative)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOunrwar :: (Warning)
            _rangeIself :: (Range)
            _patternIbeta :: (Tp)
            _patternIbetaUnique :: (Int)
            _patternIconstraints :: (ConstraintSet)
            _patternIelements :: (  [PatternElement]        )
            _patternIenvironment :: (PatternAssumptions)
            _patternIinfoTree :: (InfoTree)
            _patternIpatVarNames :: (Names)
            _patternIpatternMatchWarnings :: ([Warning])
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternObetaUnique :: (Int)
            _patternOimportEnvironment :: (ImportEnvironment)
            _patternOmonos :: (Monos)
            _patternOnamesInScope :: (Names)
            _patternOparentTree :: (InfoTree)
            _patternOpatternMatchWarnings :: ([Warning])
            _righthandsideIassumptions :: (Assumptions)
            _righthandsideIbetaUnique :: (Int)
            _righthandsideIcollectErrors :: (TypeErrors)
            _righthandsideIcollectInstances :: ([(Name, Instance)])
            _righthandsideIcollectWarnings :: (Warnings)
            _righthandsideIconstraints :: (ConstraintSet)
            _righthandsideIdictionaryEnvironment :: (DictionaryEnvironment)
            _righthandsideIfallthrough :: (Bool)
            _righthandsideIinfoTree :: (InfoTree)
            _righthandsideImatchIO :: (IO ())
            _righthandsideIpatternMatchWarnings :: ([Warning])
            _righthandsideIself :: (RightHandSide)
            _righthandsideIunboundNames :: (Names)
            _righthandsideIuniqueChunk :: (Int)
            _righthandsideOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _righthandsideOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _righthandsideOavailablePredicates :: (Predicates)
            _righthandsideObetaRight :: (Tp)
            _righthandsideObetaUnique :: (Int)
            _righthandsideOclassEnvironment :: (ClassEnvironment)
            _righthandsideOcollectErrors :: (TypeErrors)
            _righthandsideOcollectWarnings :: (Warnings)
            _righthandsideOcurrentChunk :: (Int)
            _righthandsideOdictionaryEnvironment :: (DictionaryEnvironment)
            _righthandsideOimportEnvironment :: (ImportEnvironment)
            _righthandsideOmatchIO :: (IO ())
            _righthandsideOmonos :: (Monos)
            _righthandsideOnamesInScope :: (Names)
            _righthandsideOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _righthandsideOparentTree :: (InfoTree)
            _righthandsideOpatternMatchWarnings :: ([Warning])
            _righthandsideOsubstitution :: (FixpointSubstitution)
            _righthandsideOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _righthandsideOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _patternIbeta,_patternIbetaUnique,_patternIconstraints,_patternIelements,_patternIenvironment,_patternIinfoTree,_patternIpatVarNames,_patternIpatternMatchWarnings,_patternIself,_patternIunboundNames) =
                (pattern_ (_patternObetaUnique) (_patternOimportEnvironment) (_patternOmonos) (_patternOnamesInScope) (_patternOparentTree) (_patternOpatternMatchWarnings))
            ( _righthandsideIassumptions,_righthandsideIbetaUnique,_righthandsideIcollectErrors,_righthandsideIcollectInstances,_righthandsideIcollectWarnings,_righthandsideIconstraints,_righthandsideIdictionaryEnvironment,_righthandsideIfallthrough,_righthandsideIinfoTree,_righthandsideImatchIO,_righthandsideIpatternMatchWarnings,_righthandsideIself,_righthandsideIunboundNames,_righthandsideIuniqueChunk) =
                (righthandside_ (_righthandsideOallPatterns)
                                (_righthandsideOallTypeSchemes)
                                (_righthandsideOavailablePredicates)
                                (_righthandsideObetaRight)
                                (_righthandsideObetaUnique)
                                (_righthandsideOclassEnvironment)
                                (_righthandsideOcollectErrors)
                                (_righthandsideOcollectWarnings)
                                (_righthandsideOcurrentChunk)
                                (_righthandsideOdictionaryEnvironment)
                                (_righthandsideOimportEnvironment)
                                (_righthandsideOmatchIO)
                                (_righthandsideOmonos)
                                (_righthandsideOnamesInScope)
                                (_righthandsideOorderedTypeSynonyms)
                                (_righthandsideOparentTree)
                                (_righthandsideOpatternMatchWarnings)
                                (_righthandsideOsubstitution)
                                (_righthandsideOtypeschemeMap)
                                (_righthandsideOuniqueChunk))
            ((_csetBinds@_,_lhsOassumptions@_)) =
                (_patternIenvironment .===. _righthandsideIassumptions) _cinfoBind
            (_conLeft@_) =
                [ (_patternIbeta .==. _lhsIbetaLeft) _cinfoLeft ]
            (_constraints@_) =
                _csetBinds .>>.
                Node [ _conLeft  .<. _patternIconstraints
                     , _righthandsideIconstraints
                     ]
            (_righthandsideOmonos@_) =
                M.elems _patternIenvironment ++ getMonos _csetBinds ++ _lhsImonos
            (_cinfoLeft@_) =
                resultConstraint "case pattern" _patternIinfoTree
                   [ Unifier (head (ftv _lhsIbetaLeft)) ("case patterns", attribute _lhsIparentTree, "case pattern") ]
            (_cinfoBind@_) =
                \name -> variableConstraint "variable" (nameToUHA_Expr name)
                   [ FolkloreConstraint
                   , makeUnifier name "case alternative" _patternIenvironment _lhsIparentTree
                   ]
            (_lhsOinfoTrees@_) =
                [_patternIinfoTree, _righthandsideIinfoTree]
            (_lhsOunboundNames@_) =
                _unboundNames
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _patternIpatVarNames _righthandsideIunboundNames _lhsInamesInScope
            (_lhsOunrwar@_) =
                UnreachablePatternCase range_ _patternIself
            (_lhsOelements@_) =
                (_patternIelements, _righthandsideIfallthrough)
            (_lhsOcollectInstances@_) =
                _righthandsideIcollectInstances
            (_self@_) =
                Alternative_Alternative _rangeIself _patternIself _righthandsideIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _righthandsideIbetaUnique
            (_lhsOcollectErrors@_) =
                _righthandsideIcollectErrors
            (_lhsOcollectWarnings@_) =
                _righthandsideIcollectWarnings
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOdictionaryEnvironment@_) =
                _righthandsideIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _righthandsideImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _righthandsideIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _righthandsideIuniqueChunk
            (_patternObetaUnique@_) =
                _lhsIbetaUnique
            (_patternOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternOmonos@_) =
                _lhsImonos
            (_patternOnamesInScope@_) =
                _namesInScope
            (_patternOparentTree@_) =
                _lhsIparentTree
            (_patternOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_righthandsideOallPatterns@_) =
                _lhsIallPatterns
            (_righthandsideOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_righthandsideOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_righthandsideObetaRight@_) =
                _lhsIbetaRight
            (_righthandsideObetaUnique@_) =
                _patternIbetaUnique
            (_righthandsideOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_righthandsideOcollectErrors@_) =
                _lhsIcollectErrors
            (_righthandsideOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_righthandsideOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_righthandsideOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_righthandsideOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_righthandsideOmatchIO@_) =
                _lhsImatchIO
            (_righthandsideOnamesInScope@_) =
                _namesInScope
            (_righthandsideOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_righthandsideOparentTree@_) =
                _lhsIparentTree
            (_righthandsideOpatternMatchWarnings@_) =
                _patternIpatternMatchWarnings
            (_righthandsideOsubstitution@_) =
                _lhsIsubstitution
            (_righthandsideOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_righthandsideOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOelements,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOunrwar)
sem_Alternative_Empty :: (T_Range) ->
                         (T_Alternative)
sem_Alternative_Empty (range_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaLeft
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOelements :: ( ([PatternElement], Bool) )
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Alternative)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOunrwar :: (Warning)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_constraints@_) =
                emptyTree
            (_lhsOassumptions@_) =
                noAssumptions
            (_lhsOinfoTrees@_) =
                []
            (_lhsOunrwar@_) =
                pmError "Alternative_Empty.unrwar" "empty alternative"
            (_lhsOelements@_) =
                ([], False)
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Alternative_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOelements,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOunrwar)
-- Alternatives ------------------------------------------------
-- semantic domain
type T_Alternatives = ([((Expression, [String]), Core_TypingStrategy)]) ->
                      (M.Map NameWithRange TpScheme) ->
                      (Predicates) ->
                      (Tp) ->
                      (Tp) ->
                      (Int) ->
                      (ClassEnvironment) ->
                      (TypeErrors) ->
                      (Warnings) ->
                      (Int) ->
                      (DictionaryEnvironment) ->
                      (ImportEnvironment) ->
                      (IO ()) ->
                      (Monos) ->
                      (Names) ->
                      (OrderedTypeSynonyms) ->
                      (InfoTree) ->
                      ([Warning]) ->
                      (FixpointSubstitution) ->
                      (M.Map Int (Scheme Predicates)) ->
                      (Int) ->
                      ( (Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSets),(DictionaryEnvironment),([([PatternElement], Bool)]),(InfoTrees),(IO ()),([Warning]),(Alternatives),(Names),(Int),([Warning]))
-- cata
sem_Alternatives :: (Alternatives) ->
                    (T_Alternatives)
sem_Alternatives (list) =
    (Prelude.foldr (sem_Alternatives_Cons) (sem_Alternatives_Nil) ((Prelude.map sem_Alternative list)))
sem_Alternatives_Cons :: (T_Alternative) ->
                         (T_Alternatives) ->
                         (T_Alternatives)
sem_Alternatives_Cons (hd_) (tl_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaLeft
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraintslist :: (ConstraintSets)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOelementss :: ([([PatternElement], Bool)])
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Alternatives)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOunrwars :: ([Warning])
            _hdIassumptions :: (Assumptions)
            _hdIbetaUnique :: (Int)
            _hdIcollectErrors :: (TypeErrors)
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectWarnings :: (Warnings)
            _hdIconstraints :: (ConstraintSet)
            _hdIdictionaryEnvironment :: (DictionaryEnvironment)
            _hdIelements :: ( ([PatternElement], Bool) )
            _hdIinfoTrees :: (InfoTrees)
            _hdImatchIO :: (IO ())
            _hdIpatternMatchWarnings :: ([Warning])
            _hdIself :: (Alternative)
            _hdIunboundNames :: (Names)
            _hdIuniqueChunk :: (Int)
            _hdIunrwar :: (Warning)
            _hdOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _hdOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _hdOavailablePredicates :: (Predicates)
            _hdObetaLeft :: (Tp)
            _hdObetaRight :: (Tp)
            _hdObetaUnique :: (Int)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectErrors :: (TypeErrors)
            _hdOcollectWarnings :: (Warnings)
            _hdOcurrentChunk :: (Int)
            _hdOdictionaryEnvironment :: (DictionaryEnvironment)
            _hdOimportEnvironment :: (ImportEnvironment)
            _hdOmatchIO :: (IO ())
            _hdOmonos :: (Monos)
            _hdOnamesInScope :: (Names)
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOparentTree :: (InfoTree)
            _hdOpatternMatchWarnings :: ([Warning])
            _hdOsubstitution :: (FixpointSubstitution)
            _hdOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _hdOuniqueChunk :: (Int)
            _tlIassumptions :: (Assumptions)
            _tlIbetaUnique :: (Int)
            _tlIcollectErrors :: (TypeErrors)
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectWarnings :: (Warnings)
            _tlIconstraintslist :: (ConstraintSets)
            _tlIdictionaryEnvironment :: (DictionaryEnvironment)
            _tlIelementss :: ([([PatternElement], Bool)])
            _tlIinfoTrees :: (InfoTrees)
            _tlImatchIO :: (IO ())
            _tlIpatternMatchWarnings :: ([Warning])
            _tlIself :: (Alternatives)
            _tlIunboundNames :: (Names)
            _tlIuniqueChunk :: (Int)
            _tlIunrwars :: ([Warning])
            _tlOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _tlOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _tlOavailablePredicates :: (Predicates)
            _tlObetaLeft :: (Tp)
            _tlObetaRight :: (Tp)
            _tlObetaUnique :: (Int)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectErrors :: (TypeErrors)
            _tlOcollectWarnings :: (Warnings)
            _tlOcurrentChunk :: (Int)
            _tlOdictionaryEnvironment :: (DictionaryEnvironment)
            _tlOimportEnvironment :: (ImportEnvironment)
            _tlOmatchIO :: (IO ())
            _tlOmonos :: (Monos)
            _tlOnamesInScope :: (Names)
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOparentTree :: (InfoTree)
            _tlOpatternMatchWarnings :: ([Warning])
            _tlOsubstitution :: (FixpointSubstitution)
            _tlOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _tlOuniqueChunk :: (Int)
            ( _hdIassumptions,_hdIbetaUnique,_hdIcollectErrors,_hdIcollectInstances,_hdIcollectWarnings,_hdIconstraints,_hdIdictionaryEnvironment,_hdIelements,_hdIinfoTrees,_hdImatchIO,_hdIpatternMatchWarnings,_hdIself,_hdIunboundNames,_hdIuniqueChunk,_hdIunrwar) =
                (hd_ (_hdOallPatterns) (_hdOallTypeSchemes) (_hdOavailablePredicates) (_hdObetaLeft) (_hdObetaRight) (_hdObetaUnique) (_hdOclassEnvironment) (_hdOcollectErrors) (_hdOcollectWarnings) (_hdOcurrentChunk) (_hdOdictionaryEnvironment) (_hdOimportEnvironment) (_hdOmatchIO) (_hdOmonos) (_hdOnamesInScope) (_hdOorderedTypeSynonyms) (_hdOparentTree) (_hdOpatternMatchWarnings) (_hdOsubstitution) (_hdOtypeschemeMap) (_hdOuniqueChunk))
            ( _tlIassumptions,_tlIbetaUnique,_tlIcollectErrors,_tlIcollectInstances,_tlIcollectWarnings,_tlIconstraintslist,_tlIdictionaryEnvironment,_tlIelementss,_tlIinfoTrees,_tlImatchIO,_tlIpatternMatchWarnings,_tlIself,_tlIunboundNames,_tlIuniqueChunk,_tlIunrwars) =
                (tl_ (_tlOallPatterns) (_tlOallTypeSchemes) (_tlOavailablePredicates) (_tlObetaLeft) (_tlObetaRight) (_tlObetaUnique) (_tlOclassEnvironment) (_tlOcollectErrors) (_tlOcollectWarnings) (_tlOcurrentChunk) (_tlOdictionaryEnvironment) (_tlOimportEnvironment) (_tlOmatchIO) (_tlOmonos) (_tlOnamesInScope) (_tlOorderedTypeSynonyms) (_tlOparentTree) (_tlOpatternMatchWarnings) (_tlOsubstitution) (_tlOtypeschemeMap) (_tlOuniqueChunk))
            (_lhsOconstraintslist@_) =
                _hdIconstraints : _tlIconstraintslist
            (_lhsOassumptions@_) =
                _hdIassumptions `combine` _tlIassumptions
            (_lhsOinfoTrees@_) =
                _hdIinfoTrees ++ _tlIinfoTrees
            (_lhsOunrwars@_) =
                _hdIunrwar   : _tlIunrwars
            (_lhsOelementss@_) =
                _hdIelements : _tlIelementss
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _tlIbetaUnique
            (_lhsOcollectErrors@_) =
                _tlIcollectErrors
            (_lhsOcollectWarnings@_) =
                _tlIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _tlIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _tlImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _tlIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _tlIuniqueChunk
            (_hdOallPatterns@_) =
                _lhsIallPatterns
            (_hdOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_hdOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_hdObetaLeft@_) =
                _lhsIbetaLeft
            (_hdObetaRight@_) =
                _lhsIbetaRight
            (_hdObetaUnique@_) =
                _lhsIbetaUnique
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectErrors@_) =
                _lhsIcollectErrors
            (_hdOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_hdOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_hdOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_hdOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_hdOmatchIO@_) =
                _lhsImatchIO
            (_hdOmonos@_) =
                _lhsImonos
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOparentTree@_) =
                _lhsIparentTree
            (_hdOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_hdOsubstitution@_) =
                _lhsIsubstitution
            (_hdOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_hdOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_tlOallPatterns@_) =
                _lhsIallPatterns
            (_tlOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_tlOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_tlObetaLeft@_) =
                _lhsIbetaLeft
            (_tlObetaRight@_) =
                _lhsIbetaRight
            (_tlObetaUnique@_) =
                _hdIbetaUnique
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectErrors@_) =
                _hdIcollectErrors
            (_tlOcollectWarnings@_) =
                _hdIcollectWarnings
            (_tlOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_tlOdictionaryEnvironment@_) =
                _hdIdictionaryEnvironment
            (_tlOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_tlOmatchIO@_) =
                _hdImatchIO
            (_tlOmonos@_) =
                _lhsImonos
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOparentTree@_) =
                _lhsIparentTree
            (_tlOpatternMatchWarnings@_) =
                _hdIpatternMatchWarnings
            (_tlOsubstitution@_) =
                _lhsIsubstitution
            (_tlOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_tlOuniqueChunk@_) =
                _hdIuniqueChunk
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraintslist,_lhsOdictionaryEnvironment,_lhsOelementss,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOunrwars)
sem_Alternatives_Nil :: (T_Alternatives)
sem_Alternatives_Nil  =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaLeft
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraintslist :: (ConstraintSets)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOelementss :: ([([PatternElement], Bool)])
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Alternatives)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOunrwars :: ([Warning])
            (_lhsOconstraintslist@_) =
                []
            (_lhsOassumptions@_) =
                noAssumptions
            (_lhsOinfoTrees@_) =
                []
            (_lhsOunrwars@_) =
                []
            (_lhsOelementss@_) =
                []
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraintslist,_lhsOdictionaryEnvironment,_lhsOelementss,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOunrwars)
-- AnnotatedType -----------------------------------------------
-- semantic domain
type T_AnnotatedType = (Names) ->
                       ( (AnnotatedType),(Names))
-- cata
sem_AnnotatedType :: (AnnotatedType) ->
                     (T_AnnotatedType)
sem_AnnotatedType ((AnnotatedType_AnnotatedType (_range) (_strict) (_type))) =
    (sem_AnnotatedType_AnnotatedType ((sem_Range (_range))) (_strict) ((sem_Type (_type))))
sem_AnnotatedType_AnnotatedType :: (T_Range) ->
                                   (Bool) ->
                                   (T_Type) ->
                                   (T_AnnotatedType)
sem_AnnotatedType_AnnotatedType (range_) (strict_) (type_) =
    \ _lhsInamesInScope ->
        let _lhsOself :: (AnnotatedType)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _typeIself :: (Type)
            ( _rangeIself) =
                (range_ )
            ( _typeIself) =
                (type_ )
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                AnnotatedType_AnnotatedType _rangeIself strict_ _typeIself
            (_lhsOself@_) =
                _self
        in  ( _lhsOself,_lhsOunboundNames)
-- AnnotatedTypes ----------------------------------------------
-- semantic domain
type T_AnnotatedTypes = (Names) ->
                        ( (AnnotatedTypes),(Names))
-- cata
sem_AnnotatedTypes :: (AnnotatedTypes) ->
                      (T_AnnotatedTypes)
sem_AnnotatedTypes (list) =
    (Prelude.foldr (sem_AnnotatedTypes_Cons) (sem_AnnotatedTypes_Nil) ((Prelude.map sem_AnnotatedType list)))
sem_AnnotatedTypes_Cons :: (T_AnnotatedType) ->
                           (T_AnnotatedTypes) ->
                           (T_AnnotatedTypes)
sem_AnnotatedTypes_Cons (hd_) (tl_) =
    \ _lhsInamesInScope ->
        let _lhsOself :: (AnnotatedTypes)
            _lhsOunboundNames :: (Names)
            _hdIself :: (AnnotatedType)
            _hdIunboundNames :: (Names)
            _hdOnamesInScope :: (Names)
            _tlIself :: (AnnotatedTypes)
            _tlIunboundNames :: (Names)
            _tlOnamesInScope :: (Names)
            ( _hdIself,_hdIunboundNames) =
                (hd_ (_hdOnamesInScope))
            ( _tlIself,_tlIunboundNames) =
                (tl_ (_tlOnamesInScope))
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
        in  ( _lhsOself,_lhsOunboundNames)
sem_AnnotatedTypes_Nil :: (T_AnnotatedTypes)
sem_AnnotatedTypes_Nil  =
    \ _lhsInamesInScope ->
        let _lhsOself :: (AnnotatedTypes)
            _lhsOunboundNames :: (Names)
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
        in  ( _lhsOself,_lhsOunboundNames)
-- Body --------------------------------------------------------
-- semantic domain
type T_Body = ([((Expression, [String]), Core_TypingStrategy)]) ->
              (M.Map NameWithRange TpScheme) ->
              (Predicates) ->
              (Int) ->
              (ClassEnvironment) ->
              (TypeErrors) ->
              (Warnings) ->
              (Int) ->
              (DictionaryEnvironment) ->
              (ImportEnvironment) ->
              (IO ()) ->
              (Monos) ->
              (Names) ->
              (OrderedTypeSynonyms) ->
              ([Warning]) ->
              (FixpointSubstitution) ->
              (M.Map Int (Scheme Predicates)) ->
              (Int) ->
              ( (Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(Names),(DictionaryEnvironment),(InfoTree),(IO ()),([Warning]),(Body),(TypeEnvironment),(Names),(Int))
-- cata
sem_Body :: (Body) ->
            (T_Body)
sem_Body ((Body_Body (_range) (_importdeclarations) (_declarations))) =
    (sem_Body_Body ((sem_Range (_range))) ((sem_ImportDeclarations (_importdeclarations))) ((sem_Declarations (_declarations))))
sem_Body_Body :: (T_Range) ->
                 (T_ImportDeclarations) ->
                 (T_Declarations) ->
                 (T_Body)
sem_Body_Body (range_) (importdeclarations_) (declarations_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Body)
            _lhsOtoplevelTypes :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _importdeclarationsIself :: (ImportDeclarations)
            _declarationsIbetaUnique :: (Int)
            _declarationsIbindingGroups :: (BindingGroups)
            _declarationsIcollectErrors :: (TypeErrors)
            _declarationsIcollectInstances :: ([(Name, Instance)])
            _declarationsIcollectWarnings :: (Warnings)
            _declarationsIdeclVarNames :: (Names)
            _declarationsIdictionaryEnvironment :: (DictionaryEnvironment)
            _declarationsIinfoTrees :: (InfoTrees)
            _declarationsImatchIO :: (IO ())
            _declarationsIpatternMatchWarnings :: ([Warning])
            _declarationsIrestrictedNames :: (Names)
            _declarationsIself :: (Declarations)
            _declarationsIsimplePatNames :: (Names)
            _declarationsItypeSignatures :: (TypeEnvironment)
            _declarationsIunboundNames :: (Names)
            _declarationsIuniqueChunk :: (Int)
            _declarationsOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _declarationsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _declarationsOavailablePredicates :: (Predicates)
            _declarationsObetaUnique :: (Int)
            _declarationsObindingGroups :: (BindingGroups)
            _declarationsOclassEnvironment :: (ClassEnvironment)
            _declarationsOcollectErrors :: (TypeErrors)
            _declarationsOcollectWarnings :: (Warnings)
            _declarationsOcurrentChunk :: (Int)
            _declarationsOdictionaryEnvironment :: (DictionaryEnvironment)
            _declarationsOimportEnvironment :: (ImportEnvironment)
            _declarationsOinheritedBDG :: (InheritedBDG)
            _declarationsOmatchIO :: (IO ())
            _declarationsOmonos :: (Monos)
            _declarationsOnamesInScope :: (Names)
            _declarationsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _declarationsOparentTree :: (InfoTree)
            _declarationsOpatternMatchWarnings :: ([Warning])
            _declarationsOsubstitution :: (FixpointSubstitution)
            _declarationsOtypeSignatures :: (TypeEnvironment)
            _declarationsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _declarationsOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _importdeclarationsIself) =
                (importdeclarations_ )
            ( _declarationsIbetaUnique
             ,_declarationsIbindingGroups
             ,_declarationsIcollectErrors
             ,_declarationsIcollectInstances
             ,_declarationsIcollectWarnings
             ,_declarationsIdeclVarNames
             ,_declarationsIdictionaryEnvironment
             ,_declarationsIinfoTrees
             ,_declarationsImatchIO
             ,_declarationsIpatternMatchWarnings
             ,_declarationsIrestrictedNames
             ,_declarationsIself
             ,_declarationsIsimplePatNames
             ,_declarationsItypeSignatures
             ,_declarationsIunboundNames
             ,_declarationsIuniqueChunk
             ) =
                (declarations_ (_declarationsOallPatterns)
                               (_declarationsOallTypeSchemes)
                               (_declarationsOavailablePredicates)
                               (_declarationsObetaUnique)
                               (_declarationsObindingGroups)
                               (_declarationsOclassEnvironment)
                               (_declarationsOcollectErrors)
                               (_declarationsOcollectWarnings)
                               (_declarationsOcurrentChunk)
                               (_declarationsOdictionaryEnvironment)
                               (_declarationsOimportEnvironment)
                               (_declarationsOinheritedBDG)
                               (_declarationsOmatchIO)
                               (_declarationsOmonos)
                               (_declarationsOnamesInScope)
                               (_declarationsOorderedTypeSynonyms)
                               (_declarationsOparentTree)
                               (_declarationsOpatternMatchWarnings)
                               (_declarationsOsubstitution)
                               (_declarationsOtypeSignatures)
                               (_declarationsOtypeschemeMap)
                               (_declarationsOuniqueChunk))
            ((_aset@_,_cset@_,_inheritedBDG@_,_chunkNr@_,_lhsObetaUnique@_,_implicitsFM@_)) =
                let inputBDG = (True, _lhsIcurrentChunk, _declarationsIuniqueChunk, _lhsImonos, _declarationsItypeSignatures, Nothing, _declarationsIbetaUnique)
                in performBindingGroup inputBDG _declarationsIbindingGroups
            (_constraints@_) =
                _csetBinds .>>. _cset
            ((_csetBinds@_,_lhsOassumptions@_)) =
                (typeEnvironment _lhsIimportEnvironment .:::. _aset) _cinfo
            (_declarationsObindingGroups@_) =
                []
            (_lhsOcollectErrors@_) =
                restrictedNameErrors _inferredTypes _declarationsIrestrictedNames
                ++ _declarationsIcollectErrors
            (_lhsOcollectWarnings@_) =
                missingTypeSignature True _declarationsIsimplePatNames _inferredTypes
                ++ _declarationsIcollectWarnings
            (_inferredTypes@_) =
                findInferredTypes _lhsItypeschemeMap _implicitsFM
            (_lhsOtoplevelTypes@_) =
                _declarationsItypeSignatures `M.union` _inferredTypes
            (_localTypes@_) =
                makeLocalTypeEnv (_declarationsItypeSignatures `M.union` _inferredTypes) _declarationsIbindingGroups
            (_allTypeSchemes@_) =
                _localTypes `M.union` _lhsIallTypeSchemes
            (_declarationsOtypeSignatures@_) =
                M.empty
            (_lhsOuniqueChunk@_) =
                _chunkNr
            (_cinfo@_) =
                \name -> variableConstraint "variable" (nameToUHA_Expr name)
                   [ FolkloreConstraint, HasTrustFactor 10.0, IsImported name ]
            (_declInfo@_) =
                LocalInfo { self = UHA_Decls _declarationsIself
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                root _declInfo _declarationsIinfoTrees
            (_lhsOcollectInstances@_) =
                _declarationsIcollectInstances
            (_lhsOdeclVarNames@_) =
                _declarationsIdeclVarNames
            (_lhsOunboundNames@_) =
                _declarationsIunboundNames
            (_self@_) =
                Body_Body _rangeIself _importdeclarationsIself _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOdictionaryEnvironment@_) =
                _declarationsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _declarationsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _declarationsIpatternMatchWarnings
            (_declarationsOallPatterns@_) =
                _lhsIallPatterns
            (_declarationsOallTypeSchemes@_) =
                _allTypeSchemes
            (_declarationsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_declarationsObetaUnique@_) =
                _lhsIbetaUnique
            (_declarationsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_declarationsOcollectErrors@_) =
                _lhsIcollectErrors
            (_declarationsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_declarationsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_declarationsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_declarationsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_declarationsOinheritedBDG@_) =
                _inheritedBDG
            (_declarationsOmatchIO@_) =
                _lhsImatchIO
            (_declarationsOmonos@_) =
                _lhsImonos
            (_declarationsOnamesInScope@_) =
                _lhsInamesInScope
            (_declarationsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_declarationsOparentTree@_) =
                _parentTree
            (_declarationsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_declarationsOsubstitution@_) =
                _lhsIsubstitution
            (_declarationsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_declarationsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOself,_lhsOtoplevelTypes,_lhsOunboundNames,_lhsOuniqueChunk)
-- Constructor -------------------------------------------------
-- semantic domain
type T_Constructor = (Names) ->
                     ( (Constructor),(Names))
-- cata
sem_Constructor :: (Constructor) ->
                   (T_Constructor)
sem_Constructor ((Constructor_Constructor (_range) (_constructor) (_types))) =
    (sem_Constructor_Constructor ((sem_Range (_range))) ((sem_Name (_constructor))) ((sem_AnnotatedTypes (_types))))
sem_Constructor ((Constructor_Infix (_range) (_leftType) (_constructorOperator) (_rightType))) =
    (sem_Constructor_Infix ((sem_Range (_range))) ((sem_AnnotatedType (_leftType))) ((sem_Name (_constructorOperator))) ((sem_AnnotatedType (_rightType))))
sem_Constructor ((Constructor_Record (_range) (_constructor) (_fieldDeclarations))) =
    (sem_Constructor_Record ((sem_Range (_range))) ((sem_Name (_constructor))) ((sem_FieldDeclarations (_fieldDeclarations))))
sem_Constructor_Constructor :: (T_Range) ->
                               (T_Name) ->
                               (T_AnnotatedTypes) ->
                               (T_Constructor)
sem_Constructor_Constructor (range_) (constructor_) (types_) =
    \ _lhsInamesInScope ->
        let _lhsOself :: (Constructor)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _constructorIself :: (Name)
            _typesIself :: (AnnotatedTypes)
            _typesIunboundNames :: (Names)
            _typesOnamesInScope :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _constructorIself) =
                (constructor_ )
            ( _typesIself,_typesIunboundNames) =
                (types_ (_typesOnamesInScope))
            (_lhsOunboundNames@_) =
                _typesIunboundNames
            (_self@_) =
                Constructor_Constructor _rangeIself _constructorIself _typesIself
            (_lhsOself@_) =
                _self
            (_typesOnamesInScope@_) =
                _lhsInamesInScope
        in  ( _lhsOself,_lhsOunboundNames)
sem_Constructor_Infix :: (T_Range) ->
                         (T_AnnotatedType) ->
                         (T_Name) ->
                         (T_AnnotatedType) ->
                         (T_Constructor)
sem_Constructor_Infix (range_) (leftType_) (constructorOperator_) (rightType_) =
    \ _lhsInamesInScope ->
        let _lhsOself :: (Constructor)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _leftTypeIself :: (AnnotatedType)
            _leftTypeIunboundNames :: (Names)
            _leftTypeOnamesInScope :: (Names)
            _constructorOperatorIself :: (Name)
            _rightTypeIself :: (AnnotatedType)
            _rightTypeIunboundNames :: (Names)
            _rightTypeOnamesInScope :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _leftTypeIself,_leftTypeIunboundNames) =
                (leftType_ (_leftTypeOnamesInScope))
            ( _constructorOperatorIself) =
                (constructorOperator_ )
            ( _rightTypeIself,_rightTypeIunboundNames) =
                (rightType_ (_rightTypeOnamesInScope))
            (_lhsOunboundNames@_) =
                _leftTypeIunboundNames ++ _rightTypeIunboundNames
            (_self@_) =
                Constructor_Infix _rangeIself _leftTypeIself _constructorOperatorIself _rightTypeIself
            (_lhsOself@_) =
                _self
            (_leftTypeOnamesInScope@_) =
                _lhsInamesInScope
            (_rightTypeOnamesInScope@_) =
                _lhsInamesInScope
        in  ( _lhsOself,_lhsOunboundNames)
sem_Constructor_Record :: (T_Range) ->
                          (T_Name) ->
                          (T_FieldDeclarations) ->
                          (T_Constructor)
sem_Constructor_Record (range_) (constructor_) (fieldDeclarations_) =
    \ _lhsInamesInScope ->
        let _lhsOself :: (Constructor)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _constructorIself :: (Name)
            _fieldDeclarationsIself :: (FieldDeclarations)
            _fieldDeclarationsIunboundNames :: (Names)
            _fieldDeclarationsOnamesInScope :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _constructorIself) =
                (constructor_ )
            ( _fieldDeclarationsIself,_fieldDeclarationsIunboundNames) =
                (fieldDeclarations_ (_fieldDeclarationsOnamesInScope))
            (_lhsOunboundNames@_) =
                _fieldDeclarationsIunboundNames
            (_self@_) =
                Constructor_Record _rangeIself _constructorIself _fieldDeclarationsIself
            (_lhsOself@_) =
                _self
            (_fieldDeclarationsOnamesInScope@_) =
                _lhsInamesInScope
        in  ( _lhsOself,_lhsOunboundNames)
-- Constructors ------------------------------------------------
-- semantic domain
type T_Constructors = (Names) ->
                      ( (Constructors),(Names))
-- cata
sem_Constructors :: (Constructors) ->
                    (T_Constructors)
sem_Constructors (list) =
    (Prelude.foldr (sem_Constructors_Cons) (sem_Constructors_Nil) ((Prelude.map sem_Constructor list)))
sem_Constructors_Cons :: (T_Constructor) ->
                         (T_Constructors) ->
                         (T_Constructors)
sem_Constructors_Cons (hd_) (tl_) =
    \ _lhsInamesInScope ->
        let _lhsOself :: (Constructors)
            _lhsOunboundNames :: (Names)
            _hdIself :: (Constructor)
            _hdIunboundNames :: (Names)
            _hdOnamesInScope :: (Names)
            _tlIself :: (Constructors)
            _tlIunboundNames :: (Names)
            _tlOnamesInScope :: (Names)
            ( _hdIself,_hdIunboundNames) =
                (hd_ (_hdOnamesInScope))
            ( _tlIself,_tlIunboundNames) =
                (tl_ (_tlOnamesInScope))
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
        in  ( _lhsOself,_lhsOunboundNames)
sem_Constructors_Nil :: (T_Constructors)
sem_Constructors_Nil  =
    \ _lhsInamesInScope ->
        let _lhsOself :: (Constructors)
            _lhsOunboundNames :: (Names)
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
        in  ( _lhsOself,_lhsOunboundNames)
-- ContextItem -------------------------------------------------
-- semantic domain
type T_ContextItem = ( (ContextItem))
-- cata
sem_ContextItem :: (ContextItem) ->
                   (T_ContextItem)
sem_ContextItem ((ContextItem_ContextItem (_range) (_name) (_types))) =
    (sem_ContextItem_ContextItem ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Types (_types))))
sem_ContextItem_ContextItem :: (T_Range) ->
                               (T_Name) ->
                               (T_Types) ->
                               (T_ContextItem)
sem_ContextItem_ContextItem (range_) (name_) (types_) =
    let _lhsOself :: (ContextItem)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _typesIself :: (Types)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _typesIself) =
            (types_ )
        (_tyconEnv@_) =
            internalError "PartialSyntax.ag" "n/a" "ContextItem.ContextItem"
        (_self@_) =
            ContextItem_ContextItem _rangeIself _nameIself _typesIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- ContextItems ------------------------------------------------
-- semantic domain
type T_ContextItems = ( (ContextItems))
-- cata
sem_ContextItems :: (ContextItems) ->
                    (T_ContextItems)
sem_ContextItems (list) =
    (Prelude.foldr (sem_ContextItems_Cons) (sem_ContextItems_Nil) ((Prelude.map sem_ContextItem list)))
sem_ContextItems_Cons :: (T_ContextItem) ->
                         (T_ContextItems) ->
                         (T_ContextItems)
sem_ContextItems_Cons (hd_) (tl_) =
    let _lhsOself :: (ContextItems)
        _hdIself :: (ContextItem)
        _tlIself :: (ContextItems)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_ContextItems_Nil :: (T_ContextItems)
sem_ContextItems_Nil  =
    let _lhsOself :: (ContextItems)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Declaration -------------------------------------------------
-- semantic domain
type T_Declaration = ([((Expression, [String]), Core_TypingStrategy)]) ->
                     (M.Map NameWithRange TpScheme) ->
                     (Predicates) ->
                     (Int) ->
                     (BindingGroups) ->
                     (ClassEnvironment) ->
                     (TypeErrors) ->
                     (Warnings) ->
                     (Int) ->
                     (DictionaryEnvironment) ->
                     (ImportEnvironment) ->
                     (InheritedBDG) ->
                     (IO ()) ->
                     (Monos) ->
                     (Names) ->
                     (OrderedTypeSynonyms) ->
                     (InfoTree) ->
                     ([Warning]) ->
                     (FixpointSubstitution) ->
                     (TypeEnvironment) ->
                     (M.Map Int (Scheme Predicates)) ->
                     (Int) ->
                     ( (Int),(BindingGroups),(TypeErrors),([(Name, Instance)]),(Warnings),(Names),(DictionaryEnvironment),(InfoTrees),(IO ()),([Warning]),(Names),(Declaration),(Names),(TypeEnvironment),(Names),(Int))
-- cata
sem_Declaration :: (Declaration) ->
                   (T_Declaration)
sem_Declaration ((Declaration_Class (_range) (_context) (_simpletype) (_where))) =
    (sem_Declaration_Class ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_SimpleType (_simpletype))) ((sem_MaybeDeclarations (_where))))
sem_Declaration ((Declaration_Data (_range) (_context) (_simpletype) (_constructors) (_derivings))) =
    (sem_Declaration_Data ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_SimpleType (_simpletype))) ((sem_Constructors (_constructors))) ((sem_Names (_derivings))))
sem_Declaration ((Declaration_Default (_range) (_types))) =
    (sem_Declaration_Default ((sem_Range (_range))) ((sem_Types (_types))))
sem_Declaration ((Declaration_Empty (_range))) =
    (sem_Declaration_Empty ((sem_Range (_range))))
sem_Declaration ((Declaration_Fixity (_range) (_fixity) (_priority) (_operators))) =
    (sem_Declaration_Fixity ((sem_Range (_range))) ((sem_Fixity (_fixity))) ((sem_MaybeInt (_priority))) ((sem_Names (_operators))))
sem_Declaration ((Declaration_FunctionBindings (_range) (_bindings))) =
    (sem_Declaration_FunctionBindings ((sem_Range (_range))) ((sem_FunctionBindings (_bindings))))
sem_Declaration ((Declaration_Instance (_range) (_context) (_name) (_types) (_where))) =
    (sem_Declaration_Instance ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_Name (_name))) ((sem_Types (_types))) ((sem_MaybeDeclarations (_where))))
sem_Declaration ((Declaration_Newtype (_range) (_context) (_simpletype) (_constructor) (_derivings))) =
    (sem_Declaration_Newtype ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_SimpleType (_simpletype))) ((sem_Constructor (_constructor))) ((sem_Names (_derivings))))
sem_Declaration ((Declaration_PatternBinding (_range) (_pattern) (_righthandside))) =
    (sem_Declaration_PatternBinding ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_RightHandSide (_righthandside))))
sem_Declaration ((Declaration_Type (_range) (_simpletype) (_type))) =
    (sem_Declaration_Type ((sem_Range (_range))) ((sem_SimpleType (_simpletype))) ((sem_Type (_type))))
sem_Declaration ((Declaration_TypeSignature (_range) (_names) (_type))) =
    (sem_Declaration_TypeSignature ((sem_Range (_range))) ((sem_Names (_names))) ((sem_Type (_type))))
sem_Declaration_Class :: (T_Range) ->
                         (T_ContextItems) ->
                         (T_SimpleType) ->
                         (T_MaybeDeclarations) ->
                         (T_Declaration)
sem_Declaration_Class (range_) (context_) (simpletype_) (where_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _contextIself :: (ContextItems)
            _simpletypeIname :: (Name)
            _simpletypeIself :: (SimpleType)
            _simpletypeItypevariables :: (Names)
            _whereIassumptions :: (Assumptions)
            _whereIbetaUnique :: (Int)
            _whereIcollectErrors :: (TypeErrors)
            _whereIcollectInstances :: ([(Name, Instance)])
            _whereIcollectWarnings :: (Warnings)
            _whereIconstraints :: (ConstraintSet)
            _whereIdictionaryEnvironment :: (DictionaryEnvironment)
            _whereIinfoTrees :: (InfoTrees)
            _whereIlocalTypes :: (M.Map NameWithRange TpScheme)
            _whereImatchIO :: (IO ())
            _whereInamesInScope :: (Names)
            _whereIpatternMatchWarnings :: ([Warning])
            _whereIself :: (MaybeDeclarations)
            _whereIunboundNames :: (Names)
            _whereIuniqueChunk :: (Int)
            _whereOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _whereOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _whereOassumptions :: (Assumptions)
            _whereOavailablePredicates :: (Predicates)
            _whereObetaUnique :: (Int)
            _whereOclassEnvironment :: (ClassEnvironment)
            _whereOcollectErrors :: (TypeErrors)
            _whereOcollectWarnings :: (Warnings)
            _whereOconstraints :: (ConstraintSet)
            _whereOcurrentChunk :: (Int)
            _whereOdictionaryEnvironment :: (DictionaryEnvironment)
            _whereOimportEnvironment :: (ImportEnvironment)
            _whereOmatchIO :: (IO ())
            _whereOmonos :: (Monos)
            _whereOnamesInScope :: (Names)
            _whereOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _whereOparentTree :: (InfoTree)
            _whereOpatternMatchWarnings :: ([Warning])
            _whereOsubstitution :: (FixpointSubstitution)
            _whereOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _whereOunboundNames :: (Names)
            _whereOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _contextIself) =
                (context_ )
            ( _simpletypeIname,_simpletypeIself,_simpletypeItypevariables) =
                (simpletype_ )
            ( _whereIassumptions,_whereIbetaUnique,_whereIcollectErrors,_whereIcollectInstances,_whereIcollectWarnings,_whereIconstraints,_whereIdictionaryEnvironment,_whereIinfoTrees,_whereIlocalTypes,_whereImatchIO,_whereInamesInScope,_whereIpatternMatchWarnings,_whereIself,_whereIunboundNames,_whereIuniqueChunk) =
                (where_ (_whereOallPatterns)
                        (_whereOallTypeSchemes)
                        (_whereOassumptions)
                        (_whereOavailablePredicates)
                        (_whereObetaUnique)
                        (_whereOclassEnvironment)
                        (_whereOcollectErrors)
                        (_whereOcollectWarnings)
                        (_whereOconstraints)
                        (_whereOcurrentChunk)
                        (_whereOdictionaryEnvironment)
                        (_whereOimportEnvironment)
                        (_whereOmatchIO)
                        (_whereOmonos)
                        (_whereOnamesInScope)
                        (_whereOorderedTypeSynonyms)
                        (_whereOparentTree)
                        (_whereOpatternMatchWarnings)
                        (_whereOsubstitution)
                        (_whereOtypeschemeMap)
                        (_whereOunboundNames)
                        (_whereOuniqueChunk))
            ((_assumptions@_,_constraints@_,_unboundNames@_)) =
                internalError "PartialSyntax.ag" "n/a" "Declaration.Class"
            (_lhsOcollectInstances@_) =
                _whereIcollectInstances
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOsimplePatNames@_) =
                []
            (_lhsOunboundNames@_) =
                _unboundNames
            (_self@_) =
                Declaration_Class _rangeIself _contextIself _simpletypeIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _whereIbetaUnique
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOcollectErrors@_) =
                _whereIcollectErrors
            (_lhsOcollectWarnings@_) =
                _whereIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _whereIdictionaryEnvironment
            (_lhsOinfoTrees@_) =
                _whereIinfoTrees
            (_lhsOmatchIO@_) =
                _whereImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _whereIpatternMatchWarnings
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOuniqueChunk@_) =
                _whereIuniqueChunk
            (_whereOallPatterns@_) =
                _lhsIallPatterns
            (_whereOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_whereOassumptions@_) =
                _assumptions
            (_whereOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_whereObetaUnique@_) =
                _lhsIbetaUnique
            (_whereOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_whereOcollectErrors@_) =
                _lhsIcollectErrors
            (_whereOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_whereOconstraints@_) =
                _constraints
            (_whereOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_whereOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_whereOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_whereOmatchIO@_) =
                _lhsImatchIO
            (_whereOmonos@_) =
                _lhsImonos
            (_whereOnamesInScope@_) =
                _lhsInamesInScope
            (_whereOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_whereOparentTree@_) =
                _lhsIparentTree
            (_whereOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_whereOsubstitution@_) =
                _lhsIsubstitution
            (_whereOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_whereOunboundNames@_) =
                _unboundNames
            (_whereOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
sem_Declaration_Data :: (T_Range) ->
                        (T_ContextItems) ->
                        (T_SimpleType) ->
                        (T_Constructors) ->
                        (T_Names) ->
                        (T_Declaration)
sem_Declaration_Data (range_) (context_) (simpletype_) (constructors_) (derivings_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _contextIself :: (ContextItems)
            _simpletypeIname :: (Name)
            _simpletypeIself :: (SimpleType)
            _simpletypeItypevariables :: (Names)
            _constructorsIself :: (Constructors)
            _constructorsIunboundNames :: (Names)
            _constructorsOnamesInScope :: (Names)
            _derivingsIself :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _contextIself) =
                (context_ )
            ( _simpletypeIname,_simpletypeIself,_simpletypeItypevariables) =
                (simpletype_ )
            ( _constructorsIself,_constructorsIunboundNames) =
                (constructors_ (_constructorsOnamesInScope))
            ( _derivingsIself) =
                (derivings_ )
            (_lhsOcollectInstances@_) =
                [ (cl, makeInstance (show cl) (length _simpletypeItypevariables) (show _simpletypeIname) )
                | cl <- derivings_
                ]
            (_lhsOinfoTrees@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOsimplePatNames@_) =
                []
            (_lhsOunboundNames@_) =
                _constructorsIunboundNames
            (_self@_) =
                Declaration_Data _rangeIself _contextIself _simpletypeIself _constructorsIself _derivingsIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_constructorsOnamesInScope@_) =
                _lhsInamesInScope
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
sem_Declaration_Default :: (T_Range) ->
                           (T_Types) ->
                           (T_Declaration)
sem_Declaration_Default (range_) (types_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _typesIself :: (Types)
            ( _rangeIself) =
                (range_ )
            ( _typesIself) =
                (types_ )
            (_infoTrees@_) =
                globalInfoError
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOsimplePatNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Declaration_Default _rangeIself _typesIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOinfoTrees@_) =
                _infoTrees
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
sem_Declaration_Empty :: (T_Range) ->
                         (T_Declaration)
sem_Declaration_Empty (range_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_lhsOinfoTrees@_) =
                []
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOsimplePatNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Declaration_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
sem_Declaration_Fixity :: (T_Range) ->
                          (T_Fixity) ->
                          (T_MaybeInt) ->
                          (T_Names) ->
                          (T_Declaration)
sem_Declaration_Fixity (range_) (fixity_) (priority_) (operators_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _fixityIself :: (Fixity)
            _priorityIself :: (MaybeInt)
            _operatorsIself :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _fixityIself) =
                (fixity_ )
            ( _priorityIself) =
                (priority_ )
            ( _operatorsIself) =
                (operators_ )
            (_lhsOinfoTrees@_) =
                []
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOsimplePatNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Declaration_Fixity _rangeIself _fixityIself _priorityIself _operatorsIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
sem_Declaration_FunctionBindings :: (T_Range) ->
                                    (T_FunctionBindings) ->
                                    (T_Declaration)
sem_Declaration_FunctionBindings (range_) (bindings_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _bindingsIargcount :: (Int)
            _bindingsIassumptions :: (Assumptions)
            _bindingsIbetaUnique :: (Int)
            _bindingsIcollectErrors :: (TypeErrors)
            _bindingsIcollectInstances :: ([(Name, Instance)])
            _bindingsIcollectWarnings :: (Warnings)
            _bindingsIconstraintslist :: (ConstraintSets)
            _bindingsIdictionaryEnvironment :: (DictionaryEnvironment)
            _bindingsIelementss :: ([([PatternElement], Bool)])
            _bindingsIinfoTrees :: (InfoTrees)
            _bindingsImatchIO :: (IO ())
            _bindingsIname :: (Name)
            _bindingsInumberOfPatterns :: (Int)
            _bindingsIpatternMatchWarnings :: ([Warning])
            _bindingsIself :: (FunctionBindings)
            _bindingsIunboundNames :: (Names)
            _bindingsIuniqueChunk :: (Int)
            _bindingsIunrwars :: ([Warning])
            _bindingsOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _bindingsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _bindingsOavailablePredicates :: (Predicates)
            _bindingsObetaRight :: (Tp)
            _bindingsObetaUnique :: (Int)
            _bindingsObetasLeft :: (Tps)
            _bindingsOclassEnvironment :: (ClassEnvironment)
            _bindingsOcollectErrors :: (TypeErrors)
            _bindingsOcollectWarnings :: (Warnings)
            _bindingsOcurrentChunk :: (Int)
            _bindingsOdictionaryEnvironment :: (DictionaryEnvironment)
            _bindingsOimportEnvironment :: (ImportEnvironment)
            _bindingsOmatchIO :: (IO ())
            _bindingsOmonos :: (Monos)
            _bindingsOnamesInScope :: (Names)
            _bindingsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _bindingsOparentTree :: (InfoTree)
            _bindingsOpatternMatchWarnings :: ([Warning])
            _bindingsOsubstitution :: (FixpointSubstitution)
            _bindingsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _bindingsOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _bindingsIargcount,_bindingsIassumptions,_bindingsIbetaUnique,_bindingsIcollectErrors,_bindingsIcollectInstances,_bindingsIcollectWarnings,_bindingsIconstraintslist,_bindingsIdictionaryEnvironment,_bindingsIelementss,_bindingsIinfoTrees,_bindingsImatchIO,_bindingsIname,_bindingsInumberOfPatterns,_bindingsIpatternMatchWarnings,_bindingsIself,_bindingsIunboundNames,_bindingsIuniqueChunk,_bindingsIunrwars) =
                (bindings_ (_bindingsOallPatterns)
                           (_bindingsOallTypeSchemes)
                           (_bindingsOavailablePredicates)
                           (_bindingsObetaRight)
                           (_bindingsObetaUnique)
                           (_bindingsObetasLeft)
                           (_bindingsOclassEnvironment)
                           (_bindingsOcollectErrors)
                           (_bindingsOcollectWarnings)
                           (_bindingsOcurrentChunk)
                           (_bindingsOdictionaryEnvironment)
                           (_bindingsOimportEnvironment)
                           (_bindingsOmatchIO)
                           (_bindingsOmonos)
                           (_bindingsOnamesInScope)
                           (_bindingsOorderedTypeSynonyms)
                           (_bindingsOparentTree)
                           (_bindingsOpatternMatchWarnings)
                           (_bindingsOsubstitution)
                           (_bindingsOtypeschemeMap)
                           (_bindingsOuniqueChunk))
            (_mybdggrp@_) =
                ( M.singleton _bindingsIname _beta
                , _bindingsIassumptions
                , [ Node [ Phase (-1) [_newcon]
                         , Receive _lhsIbetaUnique
                         , Node _bindingsIconstraintslist
                         ]
                  ]
                )
            (_newcon@_) =
                (_beta .==. foldr (.->.) _betaRight _betasLeft) _cinfo
            (_betasLeft@_) =
                take _bindingsInumberOfPatterns (map TVar [_lhsIbetaUnique + 2..])
            (_betaRight@_) =
                TVar (_lhsIbetaUnique + 1)
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_bindingsOmonos@_) =
                findMono _bindingsIname _lhsIinheritedBDG ++ _lhsImonos
            (_bindingsObetaUnique@_) =
                _lhsIbetaUnique + 2 + _bindingsInumberOfPatterns
            (_lhsObindingGroups@_) =
                _mybdggrp : _lhsIbindingGroups
            (_lhsOdictionaryEnvironment@_) =
                addForDeclaration _bindingsIname _declPredicates _bindingsIdictionaryEnvironment
            (_bindingsOavailablePredicates@_) =
                _declPredicates ++ _lhsIavailablePredicates
            (_declPredicates@_) =
                let scheme     = M.findWithDefault err (NameWithRange _bindingsIname) _lhsIallTypeSchemes
                    predicates = matchTypeWithScheme _lhsIorderedTypeSynonyms
                                    (_lhsIsubstitution |-> _beta)
                                    (_lhsIsubstitution |-> scheme)
                    err = internalError "TypeInferenceOverloading.ag" "n/a" "could not find type for function binding"
                in expandPredicates _lhsIorderedTypeSynonyms predicates
            (_bindingsOcurrentChunk@_) =
                findCurrentChunk _bindingsIname _lhsIinheritedBDG
            (_cinfo@_) =
                resultConstraint "function bindings (INTERNAL ERROR)" _parentTree
                   [ FolkloreConstraint, highlyTrusted, FuntionBindingEdge _bindingsInumberOfPatterns ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Decl _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTrees@_) =
                [_parentTree]
            (_parentTree@_) =
                node _lhsIparentTree _localInfo _bindingsIinfoTrees
            (_lhsOdeclVarNames@_) =
                [_bindingsIname]
            (_lhsOpatternMatchWarnings@_) =
                patternMatchWarnings _lhsIimportEnvironment
                                     _lhsIsubstitution
                                     _beta
                                     (take _bindingsIargcount . fst . functionSpine)
                                     _bindingsIelementss
                                     range_
                                     (Just _bindingsIname)
                                     True
                                     _bindingsIunrwars
                                     "function bindings"
                                     "="
                ++ _bindingsIpatternMatchWarnings
            (_lhsOcollectInstances@_) =
                _bindingsIcollectInstances
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOsimplePatNames@_) =
                []
            (_lhsOunboundNames@_) =
                _bindingsIunboundNames
            (_self@_) =
                Declaration_FunctionBindings _rangeIself _bindingsIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _bindingsIbetaUnique
            (_lhsOcollectErrors@_) =
                _bindingsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _bindingsIcollectWarnings
            (_lhsOmatchIO@_) =
                _bindingsImatchIO
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOuniqueChunk@_) =
                _bindingsIuniqueChunk
            (_bindingsOallPatterns@_) =
                _lhsIallPatterns
            (_bindingsOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_bindingsObetaRight@_) =
                _betaRight
            (_bindingsObetasLeft@_) =
                _betasLeft
            (_bindingsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_bindingsOcollectErrors@_) =
                _lhsIcollectErrors
            (_bindingsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_bindingsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_bindingsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_bindingsOmatchIO@_) =
                _lhsImatchIO
            (_bindingsOnamesInScope@_) =
                _lhsInamesInScope
            (_bindingsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_bindingsOparentTree@_) =
                _parentTree
            (_bindingsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_bindingsOsubstitution@_) =
                _lhsIsubstitution
            (_bindingsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_bindingsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
sem_Declaration_Instance :: (T_Range) ->
                            (T_ContextItems) ->
                            (T_Name) ->
                            (T_Types) ->
                            (T_MaybeDeclarations) ->
                            (T_Declaration)
sem_Declaration_Instance (range_) (context_) (name_) (types_) (where_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _contextIself :: (ContextItems)
            _nameIself :: (Name)
            _typesIself :: (Types)
            _whereIassumptions :: (Assumptions)
            _whereIbetaUnique :: (Int)
            _whereIcollectErrors :: (TypeErrors)
            _whereIcollectInstances :: ([(Name, Instance)])
            _whereIcollectWarnings :: (Warnings)
            _whereIconstraints :: (ConstraintSet)
            _whereIdictionaryEnvironment :: (DictionaryEnvironment)
            _whereIinfoTrees :: (InfoTrees)
            _whereIlocalTypes :: (M.Map NameWithRange TpScheme)
            _whereImatchIO :: (IO ())
            _whereInamesInScope :: (Names)
            _whereIpatternMatchWarnings :: ([Warning])
            _whereIself :: (MaybeDeclarations)
            _whereIunboundNames :: (Names)
            _whereIuniqueChunk :: (Int)
            _whereOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _whereOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _whereOassumptions :: (Assumptions)
            _whereOavailablePredicates :: (Predicates)
            _whereObetaUnique :: (Int)
            _whereOclassEnvironment :: (ClassEnvironment)
            _whereOcollectErrors :: (TypeErrors)
            _whereOcollectWarnings :: (Warnings)
            _whereOconstraints :: (ConstraintSet)
            _whereOcurrentChunk :: (Int)
            _whereOdictionaryEnvironment :: (DictionaryEnvironment)
            _whereOimportEnvironment :: (ImportEnvironment)
            _whereOmatchIO :: (IO ())
            _whereOmonos :: (Monos)
            _whereOnamesInScope :: (Names)
            _whereOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _whereOparentTree :: (InfoTree)
            _whereOpatternMatchWarnings :: ([Warning])
            _whereOsubstitution :: (FixpointSubstitution)
            _whereOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _whereOunboundNames :: (Names)
            _whereOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _contextIself) =
                (context_ )
            ( _nameIself) =
                (name_ )
            ( _typesIself) =
                (types_ )
            ( _whereIassumptions,_whereIbetaUnique,_whereIcollectErrors,_whereIcollectInstances,_whereIcollectWarnings,_whereIconstraints,_whereIdictionaryEnvironment,_whereIinfoTrees,_whereIlocalTypes,_whereImatchIO,_whereInamesInScope,_whereIpatternMatchWarnings,_whereIself,_whereIunboundNames,_whereIuniqueChunk) =
                (where_ (_whereOallPatterns)
                        (_whereOallTypeSchemes)
                        (_whereOassumptions)
                        (_whereOavailablePredicates)
                        (_whereObetaUnique)
                        (_whereOclassEnvironment)
                        (_whereOcollectErrors)
                        (_whereOcollectWarnings)
                        (_whereOconstraints)
                        (_whereOcurrentChunk)
                        (_whereOdictionaryEnvironment)
                        (_whereOimportEnvironment)
                        (_whereOmatchIO)
                        (_whereOmonos)
                        (_whereOnamesInScope)
                        (_whereOorderedTypeSynonyms)
                        (_whereOparentTree)
                        (_whereOpatternMatchWarnings)
                        (_whereOsubstitution)
                        (_whereOtypeschemeMap)
                        (_whereOunboundNames)
                        (_whereOuniqueChunk))
            ((_assumptions@_,_constraints@_,_unboundNames@_)) =
                internalError "PartialSyntax.ag" "n/a" "Declaration.Instance"
            (_lhsOcollectInstances@_) =
                _whereIcollectInstances
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOsimplePatNames@_) =
                []
            (_lhsOunboundNames@_) =
                _unboundNames
            (_self@_) =
                Declaration_Instance _rangeIself _contextIself _nameIself _typesIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _whereIbetaUnique
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOcollectErrors@_) =
                _whereIcollectErrors
            (_lhsOcollectWarnings@_) =
                _whereIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _whereIdictionaryEnvironment
            (_lhsOinfoTrees@_) =
                _whereIinfoTrees
            (_lhsOmatchIO@_) =
                _whereImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _whereIpatternMatchWarnings
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOuniqueChunk@_) =
                _whereIuniqueChunk
            (_whereOallPatterns@_) =
                _lhsIallPatterns
            (_whereOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_whereOassumptions@_) =
                _assumptions
            (_whereOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_whereObetaUnique@_) =
                _lhsIbetaUnique
            (_whereOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_whereOcollectErrors@_) =
                _lhsIcollectErrors
            (_whereOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_whereOconstraints@_) =
                _constraints
            (_whereOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_whereOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_whereOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_whereOmatchIO@_) =
                _lhsImatchIO
            (_whereOmonos@_) =
                _lhsImonos
            (_whereOnamesInScope@_) =
                _lhsInamesInScope
            (_whereOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_whereOparentTree@_) =
                _lhsIparentTree
            (_whereOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_whereOsubstitution@_) =
                _lhsIsubstitution
            (_whereOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_whereOunboundNames@_) =
                _unboundNames
            (_whereOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
sem_Declaration_Newtype :: (T_Range) ->
                           (T_ContextItems) ->
                           (T_SimpleType) ->
                           (T_Constructor) ->
                           (T_Names) ->
                           (T_Declaration)
sem_Declaration_Newtype (range_) (context_) (simpletype_) (constructor_) (derivings_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _contextIself :: (ContextItems)
            _simpletypeIname :: (Name)
            _simpletypeIself :: (SimpleType)
            _simpletypeItypevariables :: (Names)
            _constructorIself :: (Constructor)
            _constructorIunboundNames :: (Names)
            _constructorOnamesInScope :: (Names)
            _derivingsIself :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _contextIself) =
                (context_ )
            ( _simpletypeIname,_simpletypeIself,_simpletypeItypevariables) =
                (simpletype_ )
            ( _constructorIself,_constructorIunboundNames) =
                (constructor_ (_constructorOnamesInScope))
            ( _derivingsIself) =
                (derivings_ )
            (_infoTrees@_) =
                globalInfoError
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOsimplePatNames@_) =
                []
            (_lhsOunboundNames@_) =
                _constructorIunboundNames
            (_self@_) =
                Declaration_Newtype _rangeIself _contextIself _simpletypeIself _constructorIself _derivingsIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOinfoTrees@_) =
                _infoTrees
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_constructorOnamesInScope@_) =
                _lhsInamesInScope
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
sem_Declaration_PatternBinding :: (T_Range) ->
                                  (T_Pattern) ->
                                  (T_RightHandSide) ->
                                  (T_Declaration)
sem_Declaration_PatternBinding (range_) (pattern_) (righthandside_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _patternIbeta :: (Tp)
            _patternIbetaUnique :: (Int)
            _patternIconstraints :: (ConstraintSet)
            _patternIelements :: (  [PatternElement]        )
            _patternIenvironment :: (PatternAssumptions)
            _patternIinfoTree :: (InfoTree)
            _patternIpatVarNames :: (Names)
            _patternIpatternMatchWarnings :: ([Warning])
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternObetaUnique :: (Int)
            _patternOimportEnvironment :: (ImportEnvironment)
            _patternOmonos :: (Monos)
            _patternOnamesInScope :: (Names)
            _patternOparentTree :: (InfoTree)
            _patternOpatternMatchWarnings :: ([Warning])
            _righthandsideIassumptions :: (Assumptions)
            _righthandsideIbetaUnique :: (Int)
            _righthandsideIcollectErrors :: (TypeErrors)
            _righthandsideIcollectInstances :: ([(Name, Instance)])
            _righthandsideIcollectWarnings :: (Warnings)
            _righthandsideIconstraints :: (ConstraintSet)
            _righthandsideIdictionaryEnvironment :: (DictionaryEnvironment)
            _righthandsideIfallthrough :: (Bool)
            _righthandsideIinfoTree :: (InfoTree)
            _righthandsideImatchIO :: (IO ())
            _righthandsideIpatternMatchWarnings :: ([Warning])
            _righthandsideIself :: (RightHandSide)
            _righthandsideIunboundNames :: (Names)
            _righthandsideIuniqueChunk :: (Int)
            _righthandsideOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _righthandsideOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _righthandsideOavailablePredicates :: (Predicates)
            _righthandsideObetaRight :: (Tp)
            _righthandsideObetaUnique :: (Int)
            _righthandsideOclassEnvironment :: (ClassEnvironment)
            _righthandsideOcollectErrors :: (TypeErrors)
            _righthandsideOcollectWarnings :: (Warnings)
            _righthandsideOcurrentChunk :: (Int)
            _righthandsideOdictionaryEnvironment :: (DictionaryEnvironment)
            _righthandsideOimportEnvironment :: (ImportEnvironment)
            _righthandsideOmatchIO :: (IO ())
            _righthandsideOmonos :: (Monos)
            _righthandsideOnamesInScope :: (Names)
            _righthandsideOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _righthandsideOparentTree :: (InfoTree)
            _righthandsideOpatternMatchWarnings :: ([Warning])
            _righthandsideOsubstitution :: (FixpointSubstitution)
            _righthandsideOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _righthandsideOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _patternIbeta,_patternIbetaUnique,_patternIconstraints,_patternIelements,_patternIenvironment,_patternIinfoTree,_patternIpatVarNames,_patternIpatternMatchWarnings,_patternIself,_patternIunboundNames) =
                (pattern_ (_patternObetaUnique) (_patternOimportEnvironment) (_patternOmonos) (_patternOnamesInScope) (_patternOparentTree) (_patternOpatternMatchWarnings))
            ( _righthandsideIassumptions,_righthandsideIbetaUnique,_righthandsideIcollectErrors,_righthandsideIcollectInstances,_righthandsideIcollectWarnings,_righthandsideIconstraints,_righthandsideIdictionaryEnvironment,_righthandsideIfallthrough,_righthandsideIinfoTree,_righthandsideImatchIO,_righthandsideIpatternMatchWarnings,_righthandsideIself,_righthandsideIunboundNames,_righthandsideIuniqueChunk) =
                (righthandside_ (_righthandsideOallPatterns)
                                (_righthandsideOallTypeSchemes)
                                (_righthandsideOavailablePredicates)
                                (_righthandsideObetaRight)
                                (_righthandsideObetaUnique)
                                (_righthandsideOclassEnvironment)
                                (_righthandsideOcollectErrors)
                                (_righthandsideOcollectWarnings)
                                (_righthandsideOcurrentChunk)
                                (_righthandsideOdictionaryEnvironment)
                                (_righthandsideOimportEnvironment)
                                (_righthandsideOmatchIO)
                                (_righthandsideOmonos)
                                (_righthandsideOnamesInScope)
                                (_righthandsideOorderedTypeSynonyms)
                                (_righthandsideOparentTree)
                                (_righthandsideOpatternMatchWarnings)
                                (_righthandsideOsubstitution)
                                (_righthandsideOtypeschemeMap)
                                (_righthandsideOuniqueChunk))
            (_mybdggrp@_) =
                ( _patternIenvironment
                , _righthandsideIassumptions
                , [ _newcon .>.
                    Node [ _patternIconstraints
                         , _righthandsideIconstraints
                         ]
                  ]
                )
            (_newcon@_) =
                [ (_betaRight .==. _patternIbeta) _cinfo ]
            (_betaRight@_) =
                TVar _lhsIbetaUnique
            (_righthandsideOmonos@_) =
                findMono (head (M.keys _patternIenvironment)) _lhsIinheritedBDG ++ _lhsImonos
            (_patternObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_lhsObindingGroups@_) =
                _mybdggrp : _lhsIbindingGroups
            (_lhsOdictionaryEnvironment@_) =
                case _declPredicates of
                   Just (n, ps) -> addForDeclaration n ps _righthandsideIdictionaryEnvironment
                   Nothing      -> _righthandsideIdictionaryEnvironment
            (_righthandsideOavailablePredicates@_) =
                case _declPredicates of
                   Just (n, ps) -> ps ++ _lhsIavailablePredicates
                   Nothing      -> _lhsIavailablePredicates
            (_declPredicates@_) =
                case _patternIself of
                  Pattern_Variable _ name ->
                     let scheme     = M.findWithDefault err (NameWithRange name) _lhsIallTypeSchemes
                         predicates = matchTypeWithScheme _lhsIorderedTypeSynonyms
                                         (_lhsIsubstitution |-> _betaRight)
                                         (_lhsIsubstitution |-> scheme)
                         err = internalError "TypeInferenceOverloading.ag" "n/a" ("could not find type for pattern binding "++show name)
                     in Just (name, expandPredicates _lhsIorderedTypeSynonyms predicates)
                  _ -> Nothing
            ((_lhsOrestrictedNames@_,_lhsOsimplePatNames@_)) =
                if isSimplePattern _patternIself
                  then ([], _patternIpatVarNames)
                  else (_patternIpatVarNames, [])
            (_righthandsideOcurrentChunk@_) =
                findCurrentChunk (head (M.keys _patternIenvironment)) _lhsIinheritedBDG
            (_cinfo@_) =
                orphanConstraint 1 "right hand side" _parentTree
                   []
            (_localInfo@_) =
                LocalInfo { self = UHA_Decl _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTrees@_) =
                [_parentTree]
            (_parentTree@_) =
                node _lhsIparentTree _localInfo [_patternIinfoTree, _righthandsideIinfoTree]
            (_lhsOdeclVarNames@_) =
                _patternIpatVarNames
            (_lhsOpatternMatchWarnings@_) =
                patternMatchWarnings _lhsIimportEnvironment
                                     _lhsIsubstitution
                                     _patternIbeta
                                     (:[])
                                     [(_patternIelements, _righthandsideIfallthrough)]
                                     range_
                                     Nothing
                                     False
                                     []
                                     "pattern binding"
                                     "="
                ++ _righthandsideIpatternMatchWarnings
            (_lhsOcollectInstances@_) =
                _righthandsideIcollectInstances
            (_lhsOunboundNames@_) =
                _patternIunboundNames ++ _righthandsideIunboundNames
            (_self@_) =
                Declaration_PatternBinding _rangeIself _patternIself _righthandsideIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _righthandsideIbetaUnique
            (_lhsOcollectErrors@_) =
                _righthandsideIcollectErrors
            (_lhsOcollectWarnings@_) =
                _righthandsideIcollectWarnings
            (_lhsOmatchIO@_) =
                _righthandsideImatchIO
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOuniqueChunk@_) =
                _righthandsideIuniqueChunk
            (_patternOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternOmonos@_) =
                _lhsImonos
            (_patternOnamesInScope@_) =
                _lhsInamesInScope
            (_patternOparentTree@_) =
                _parentTree
            (_patternOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_righthandsideOallPatterns@_) =
                _lhsIallPatterns
            (_righthandsideOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_righthandsideObetaRight@_) =
                _betaRight
            (_righthandsideObetaUnique@_) =
                _patternIbetaUnique
            (_righthandsideOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_righthandsideOcollectErrors@_) =
                _lhsIcollectErrors
            (_righthandsideOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_righthandsideOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_righthandsideOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_righthandsideOmatchIO@_) =
                _lhsImatchIO
            (_righthandsideOnamesInScope@_) =
                _lhsInamesInScope
            (_righthandsideOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_righthandsideOparentTree@_) =
                _parentTree
            (_righthandsideOpatternMatchWarnings@_) =
                _patternIpatternMatchWarnings
            (_righthandsideOsubstitution@_) =
                _lhsIsubstitution
            (_righthandsideOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_righthandsideOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
sem_Declaration_Type :: (T_Range) ->
                        (T_SimpleType) ->
                        (T_Type) ->
                        (T_Declaration)
sem_Declaration_Type (range_) (simpletype_) (type_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _simpletypeIname :: (Name)
            _simpletypeIself :: (SimpleType)
            _simpletypeItypevariables :: (Names)
            _typeIself :: (Type)
            ( _rangeIself) =
                (range_ )
            ( _simpletypeIname,_simpletypeIself,_simpletypeItypevariables) =
                (simpletype_ )
            ( _typeIself) =
                (type_ )
            (_lhsOinfoTrees@_) =
                []
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOsimplePatNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Declaration_Type _rangeIself _simpletypeIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
sem_Declaration_TypeSignature :: (T_Range) ->
                                 (T_Names) ->
                                 (T_Type) ->
                                 (T_Declaration)
sem_Declaration_TypeSignature (range_) (names_) (type_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declaration)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _namesIself :: (Names)
            _typeIself :: (Type)
            ( _rangeIself) =
                (range_ )
            ( _namesIself) =
                (names_ )
            ( _typeIself) =
                (type_ )
            (_typeScheme@_) =
                makeTpSchemeFromType _typeIself
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures `M.union` (M.fromList [ (name, _typeScheme) | name <- _namesIself ])
            (_lhsOinfoTrees@_) =
                []
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOsimplePatNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Declaration_TypeSignature _rangeIself _namesIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
-- Declarations ------------------------------------------------
-- semantic domain
type T_Declarations = ([((Expression, [String]), Core_TypingStrategy)]) ->
                      (M.Map NameWithRange TpScheme) ->
                      (Predicates) ->
                      (Int) ->
                      (BindingGroups) ->
                      (ClassEnvironment) ->
                      (TypeErrors) ->
                      (Warnings) ->
                      (Int) ->
                      (DictionaryEnvironment) ->
                      (ImportEnvironment) ->
                      (InheritedBDG) ->
                      (IO ()) ->
                      (Monos) ->
                      (Names) ->
                      (OrderedTypeSynonyms) ->
                      (InfoTree) ->
                      ([Warning]) ->
                      (FixpointSubstitution) ->
                      (TypeEnvironment) ->
                      (M.Map Int (Scheme Predicates)) ->
                      (Int) ->
                      ( (Int),(BindingGroups),(TypeErrors),([(Name, Instance)]),(Warnings),(Names),(DictionaryEnvironment),(InfoTrees),(IO ()),([Warning]),(Names),(Declarations),(Names),(TypeEnvironment),(Names),(Int))
-- cata
sem_Declarations :: (Declarations) ->
                    (T_Declarations)
sem_Declarations (list) =
    (Prelude.foldr (sem_Declarations_Cons) (sem_Declarations_Nil) ((Prelude.map sem_Declaration list)))
sem_Declarations_Cons :: (T_Declaration) ->
                         (T_Declarations) ->
                         (T_Declarations)
sem_Declarations_Cons (hd_) (tl_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declarations)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _hdIbetaUnique :: (Int)
            _hdIbindingGroups :: (BindingGroups)
            _hdIcollectErrors :: (TypeErrors)
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectWarnings :: (Warnings)
            _hdIdeclVarNames :: (Names)
            _hdIdictionaryEnvironment :: (DictionaryEnvironment)
            _hdIinfoTrees :: (InfoTrees)
            _hdImatchIO :: (IO ())
            _hdIpatternMatchWarnings :: ([Warning])
            _hdIrestrictedNames :: (Names)
            _hdIself :: (Declaration)
            _hdIsimplePatNames :: (Names)
            _hdItypeSignatures :: (TypeEnvironment)
            _hdIunboundNames :: (Names)
            _hdIuniqueChunk :: (Int)
            _hdOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _hdOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _hdOavailablePredicates :: (Predicates)
            _hdObetaUnique :: (Int)
            _hdObindingGroups :: (BindingGroups)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectErrors :: (TypeErrors)
            _hdOcollectWarnings :: (Warnings)
            _hdOcurrentChunk :: (Int)
            _hdOdictionaryEnvironment :: (DictionaryEnvironment)
            _hdOimportEnvironment :: (ImportEnvironment)
            _hdOinheritedBDG :: (InheritedBDG)
            _hdOmatchIO :: (IO ())
            _hdOmonos :: (Monos)
            _hdOnamesInScope :: (Names)
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOparentTree :: (InfoTree)
            _hdOpatternMatchWarnings :: ([Warning])
            _hdOsubstitution :: (FixpointSubstitution)
            _hdOtypeSignatures :: (TypeEnvironment)
            _hdOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _hdOuniqueChunk :: (Int)
            _tlIbetaUnique :: (Int)
            _tlIbindingGroups :: (BindingGroups)
            _tlIcollectErrors :: (TypeErrors)
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectWarnings :: (Warnings)
            _tlIdeclVarNames :: (Names)
            _tlIdictionaryEnvironment :: (DictionaryEnvironment)
            _tlIinfoTrees :: (InfoTrees)
            _tlImatchIO :: (IO ())
            _tlIpatternMatchWarnings :: ([Warning])
            _tlIrestrictedNames :: (Names)
            _tlIself :: (Declarations)
            _tlIsimplePatNames :: (Names)
            _tlItypeSignatures :: (TypeEnvironment)
            _tlIunboundNames :: (Names)
            _tlIuniqueChunk :: (Int)
            _tlOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _tlOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _tlOavailablePredicates :: (Predicates)
            _tlObetaUnique :: (Int)
            _tlObindingGroups :: (BindingGroups)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectErrors :: (TypeErrors)
            _tlOcollectWarnings :: (Warnings)
            _tlOcurrentChunk :: (Int)
            _tlOdictionaryEnvironment :: (DictionaryEnvironment)
            _tlOimportEnvironment :: (ImportEnvironment)
            _tlOinheritedBDG :: (InheritedBDG)
            _tlOmatchIO :: (IO ())
            _tlOmonos :: (Monos)
            _tlOnamesInScope :: (Names)
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOparentTree :: (InfoTree)
            _tlOpatternMatchWarnings :: ([Warning])
            _tlOsubstitution :: (FixpointSubstitution)
            _tlOtypeSignatures :: (TypeEnvironment)
            _tlOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _tlOuniqueChunk :: (Int)
            ( _hdIbetaUnique,_hdIbindingGroups,_hdIcollectErrors,_hdIcollectInstances,_hdIcollectWarnings,_hdIdeclVarNames,_hdIdictionaryEnvironment,_hdIinfoTrees,_hdImatchIO,_hdIpatternMatchWarnings,_hdIrestrictedNames,_hdIself,_hdIsimplePatNames,_hdItypeSignatures,_hdIunboundNames,_hdIuniqueChunk) =
                (hd_ (_hdOallPatterns)
                     (_hdOallTypeSchemes)
                     (_hdOavailablePredicates)
                     (_hdObetaUnique)
                     (_hdObindingGroups)
                     (_hdOclassEnvironment)
                     (_hdOcollectErrors)
                     (_hdOcollectWarnings)
                     (_hdOcurrentChunk)
                     (_hdOdictionaryEnvironment)
                     (_hdOimportEnvironment)
                     (_hdOinheritedBDG)
                     (_hdOmatchIO)
                     (_hdOmonos)
                     (_hdOnamesInScope)
                     (_hdOorderedTypeSynonyms)
                     (_hdOparentTree)
                     (_hdOpatternMatchWarnings)
                     (_hdOsubstitution)
                     (_hdOtypeSignatures)
                     (_hdOtypeschemeMap)
                     (_hdOuniqueChunk))
            ( _tlIbetaUnique,_tlIbindingGroups,_tlIcollectErrors,_tlIcollectInstances,_tlIcollectWarnings,_tlIdeclVarNames,_tlIdictionaryEnvironment,_tlIinfoTrees,_tlImatchIO,_tlIpatternMatchWarnings,_tlIrestrictedNames,_tlIself,_tlIsimplePatNames,_tlItypeSignatures,_tlIunboundNames,_tlIuniqueChunk) =
                (tl_ (_tlOallPatterns)
                     (_tlOallTypeSchemes)
                     (_tlOavailablePredicates)
                     (_tlObetaUnique)
                     (_tlObindingGroups)
                     (_tlOclassEnvironment)
                     (_tlOcollectErrors)
                     (_tlOcollectWarnings)
                     (_tlOcurrentChunk)
                     (_tlOdictionaryEnvironment)
                     (_tlOimportEnvironment)
                     (_tlOinheritedBDG)
                     (_tlOmatchIO)
                     (_tlOmonos)
                     (_tlOnamesInScope)
                     (_tlOorderedTypeSynonyms)
                     (_tlOparentTree)
                     (_tlOpatternMatchWarnings)
                     (_tlOsubstitution)
                     (_tlOtypeSignatures)
                     (_tlOtypeschemeMap)
                     (_tlOuniqueChunk))
            (_lhsOinfoTrees@_) =
                _hdIinfoTrees ++ _tlIinfoTrees
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOdeclVarNames@_) =
                _hdIdeclVarNames ++ _tlIdeclVarNames
            (_lhsOrestrictedNames@_) =
                _hdIrestrictedNames  ++  _tlIrestrictedNames
            (_lhsOsimplePatNames@_) =
                _hdIsimplePatNames  ++  _tlIsimplePatNames
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _tlIbetaUnique
            (_lhsObindingGroups@_) =
                _tlIbindingGroups
            (_lhsOcollectErrors@_) =
                _tlIcollectErrors
            (_lhsOcollectWarnings@_) =
                _tlIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _tlIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _tlImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _tlIpatternMatchWarnings
            (_lhsOtypeSignatures@_) =
                _tlItypeSignatures
            (_lhsOuniqueChunk@_) =
                _tlIuniqueChunk
            (_hdOallPatterns@_) =
                _lhsIallPatterns
            (_hdOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_hdOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_hdObetaUnique@_) =
                _lhsIbetaUnique
            (_hdObindingGroups@_) =
                _lhsIbindingGroups
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectErrors@_) =
                _lhsIcollectErrors
            (_hdOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_hdOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_hdOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_hdOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_hdOinheritedBDG@_) =
                _lhsIinheritedBDG
            (_hdOmatchIO@_) =
                _lhsImatchIO
            (_hdOmonos@_) =
                _lhsImonos
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOparentTree@_) =
                _lhsIparentTree
            (_hdOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_hdOsubstitution@_) =
                _lhsIsubstitution
            (_hdOtypeSignatures@_) =
                _lhsItypeSignatures
            (_hdOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_hdOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_tlOallPatterns@_) =
                _lhsIallPatterns
            (_tlOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_tlOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_tlObetaUnique@_) =
                _hdIbetaUnique
            (_tlObindingGroups@_) =
                _hdIbindingGroups
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectErrors@_) =
                _hdIcollectErrors
            (_tlOcollectWarnings@_) =
                _hdIcollectWarnings
            (_tlOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_tlOdictionaryEnvironment@_) =
                _hdIdictionaryEnvironment
            (_tlOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_tlOinheritedBDG@_) =
                _lhsIinheritedBDG
            (_tlOmatchIO@_) =
                _hdImatchIO
            (_tlOmonos@_) =
                _lhsImonos
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOparentTree@_) =
                _lhsIparentTree
            (_tlOpatternMatchWarnings@_) =
                _hdIpatternMatchWarnings
            (_tlOsubstitution@_) =
                _lhsIsubstitution
            (_tlOtypeSignatures@_) =
                _hdItypeSignatures
            (_tlOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_tlOuniqueChunk@_) =
                _hdIuniqueChunk
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
sem_Declarations_Nil :: (T_Declarations)
sem_Declarations_Nil  =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIbindingGroups
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsIinheritedBDG
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeSignatures
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsObetaUnique :: (Int)
            _lhsObindingGroups :: (BindingGroups)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdeclVarNames :: (Names)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrestrictedNames :: (Names)
            _lhsOself :: (Declarations)
            _lhsOsimplePatNames :: (Names)
            _lhsOtypeSignatures :: (TypeEnvironment)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            (_lhsOinfoTrees@_) =
                []
            (_lhsOcollectInstances@_) =
                []
            (_lhsOdeclVarNames@_) =
                []
            (_lhsOrestrictedNames@_) =
                []
            (_lhsOsimplePatNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOtypeSignatures@_) =
                _lhsItypeSignatures
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsObetaUnique,_lhsObindingGroups,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdeclVarNames,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrestrictedNames,_lhsOself,_lhsOsimplePatNames,_lhsOtypeSignatures,_lhsOunboundNames,_lhsOuniqueChunk)
-- Export ------------------------------------------------------
-- semantic domain
type T_Export = ( (Export))
-- cata
sem_Export :: (Export) ->
              (T_Export)
sem_Export ((Export_Module (_range) (_name))) =
    (sem_Export_Module ((sem_Range (_range))) ((sem_Name (_name))))
sem_Export ((Export_TypeOrClass (_range) (_name) (_names))) =
    (sem_Export_TypeOrClass ((sem_Range (_range))) ((sem_Name (_name))) ((sem_MaybeNames (_names))))
sem_Export ((Export_TypeOrClassComplete (_range) (_name))) =
    (sem_Export_TypeOrClassComplete ((sem_Range (_range))) ((sem_Name (_name))))
sem_Export ((Export_Variable (_range) (_name))) =
    (sem_Export_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Export_Module :: (T_Range) ->
                     (T_Name) ->
                     (T_Export)
sem_Export_Module (range_) (name_) =
    let _lhsOself :: (Export)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Export_Module _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Export_TypeOrClass :: (T_Range) ->
                          (T_Name) ->
                          (T_MaybeNames) ->
                          (T_Export)
sem_Export_TypeOrClass (range_) (name_) (names_) =
    let _lhsOself :: (Export)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _namesIself :: (MaybeNames)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _namesIself) =
            (names_ )
        (_self@_) =
            Export_TypeOrClass _rangeIself _nameIself _namesIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Export_TypeOrClassComplete :: (T_Range) ->
                                  (T_Name) ->
                                  (T_Export)
sem_Export_TypeOrClassComplete (range_) (name_) =
    let _lhsOself :: (Export)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Export_TypeOrClassComplete _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Export_Variable :: (T_Range) ->
                       (T_Name) ->
                       (T_Export)
sem_Export_Variable (range_) (name_) =
    let _lhsOself :: (Export)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Export_Variable _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Exports -----------------------------------------------------
-- semantic domain
type T_Exports = ( (Exports))
-- cata
sem_Exports :: (Exports) ->
               (T_Exports)
sem_Exports (list) =
    (Prelude.foldr (sem_Exports_Cons) (sem_Exports_Nil) ((Prelude.map sem_Export list)))
sem_Exports_Cons :: (T_Export) ->
                    (T_Exports) ->
                    (T_Exports)
sem_Exports_Cons (hd_) (tl_) =
    let _lhsOself :: (Exports)
        _hdIself :: (Export)
        _tlIself :: (Exports)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Exports_Nil :: (T_Exports)
sem_Exports_Nil  =
    let _lhsOself :: (Exports)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Expression --------------------------------------------------
-- semantic domain
type T_Expression = ([((Expression, [String]), Core_TypingStrategy)]) ->
                    (M.Map NameWithRange TpScheme) ->
                    (Predicates) ->
                    (Int) ->
                    (ClassEnvironment) ->
                    (TypeErrors) ->
                    (Warnings) ->
                    (Int) ->
                    (DictionaryEnvironment) ->
                    (ImportEnvironment) ->
                    (IO ()) ->
                    (Monos) ->
                    (Names) ->
                    (OrderedTypeSynonyms) ->
                    (InfoTree) ->
                    ([Warning]) ->
                    (FixpointSubstitution) ->
                    ([(Expression     , [String])]) ->
                    (M.Map Int (Scheme Predicates)) ->
                    (Int) ->
                    (Int) ->
                    ( (Assumptions),(Tp),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(DictionaryEnvironment),(InfoTree),(IO ()),([Maybe MetaVariableTable]),([Warning]),(Expression),(Names),(Int),(Int))
-- cata
sem_Expression :: (Expression) ->
                  (T_Expression)
sem_Expression ((Expression_Case (_range) (_expression) (_alternatives))) =
    (sem_Expression_Case ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_Alternatives (_alternatives))))
sem_Expression ((Expression_Comprehension (_range) (_expression) (_qualifiers))) =
    (sem_Expression_Comprehension ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_Qualifiers (_qualifiers))))
sem_Expression ((Expression_Constructor (_range) (_name))) =
    (sem_Expression_Constructor ((sem_Range (_range))) ((sem_Name (_name))))
sem_Expression ((Expression_Do (_range) (_statements))) =
    (sem_Expression_Do ((sem_Range (_range))) ((sem_Statements (_statements))))
sem_Expression ((Expression_Enum (_range) (_from) (_then) (_to))) =
    (sem_Expression_Enum ((sem_Range (_range))) ((sem_Expression (_from))) ((sem_MaybeExpression (_then))) ((sem_MaybeExpression (_to))))
sem_Expression ((Expression_If (_range) (_guardExpression) (_thenExpression) (_elseExpression))) =
    (sem_Expression_If ((sem_Range (_range))) ((sem_Expression (_guardExpression))) ((sem_Expression (_thenExpression))) ((sem_Expression (_elseExpression))))
sem_Expression ((Expression_InfixApplication (_range) (_leftExpression) (_operator) (_rightExpression))) =
    (sem_Expression_InfixApplication ((sem_Range (_range))) ((sem_MaybeExpression (_leftExpression))) ((sem_Expression (_operator))) ((sem_MaybeExpression (_rightExpression))))
sem_Expression ((Expression_Lambda (_range) (_patterns) (_expression))) =
    (sem_Expression_Lambda ((sem_Range (_range))) ((sem_Patterns (_patterns))) ((sem_Expression (_expression))))
sem_Expression ((Expression_Let (_range) (_declarations) (_expression))) =
    (sem_Expression_Let ((sem_Range (_range))) ((sem_Declarations (_declarations))) ((sem_Expression (_expression))))
sem_Expression ((Expression_List (_range) (_expressions))) =
    (sem_Expression_List ((sem_Range (_range))) ((sem_Expressions (_expressions))))
sem_Expression ((Expression_Literal (_range) (_literal))) =
    (sem_Expression_Literal ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Expression ((Expression_Negate (_range) (_expression))) =
    (sem_Expression_Negate ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Expression ((Expression_NegateFloat (_range) (_expression))) =
    (sem_Expression_NegateFloat ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Expression ((Expression_NormalApplication (_range) (_function) (_arguments))) =
    (sem_Expression_NormalApplication ((sem_Range (_range))) ((sem_Expression (_function))) ((sem_Expressions (_arguments))))
sem_Expression ((Expression_Parenthesized (_range) (_expression))) =
    (sem_Expression_Parenthesized ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Expression ((Expression_RecordConstruction (_range) (_name) (_recordExpressionBindings))) =
    (sem_Expression_RecordConstruction ((sem_Range (_range))) ((sem_Name (_name))) ((sem_RecordExpressionBindings (_recordExpressionBindings))))
sem_Expression ((Expression_RecordUpdate (_range) (_expression) (_recordExpressionBindings))) =
    (sem_Expression_RecordUpdate ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_RecordExpressionBindings (_recordExpressionBindings))))
sem_Expression ((Expression_Tuple (_range) (_expressions))) =
    (sem_Expression_Tuple ((sem_Range (_range))) ((sem_Expressions (_expressions))))
sem_Expression ((Expression_Typed (_range) (_expression) (_type))) =
    (sem_Expression_Typed ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_Type (_type))))
sem_Expression ((Expression_Variable (_range) (_name))) =
    (sem_Expression_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Expression_Case :: (T_Range) ->
                       (T_Expression) ->
                       (T_Alternatives) ->
                       (T_Expression)
sem_Expression_Case (range_) (expression_) (alternatives_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            _alternativesIassumptions :: (Assumptions)
            _alternativesIbetaUnique :: (Int)
            _alternativesIcollectErrors :: (TypeErrors)
            _alternativesIcollectInstances :: ([(Name, Instance)])
            _alternativesIcollectWarnings :: (Warnings)
            _alternativesIconstraintslist :: (ConstraintSets)
            _alternativesIdictionaryEnvironment :: (DictionaryEnvironment)
            _alternativesIelementss :: ([([PatternElement], Bool)])
            _alternativesIinfoTrees :: (InfoTrees)
            _alternativesImatchIO :: (IO ())
            _alternativesIpatternMatchWarnings :: ([Warning])
            _alternativesIself :: (Alternatives)
            _alternativesIunboundNames :: (Names)
            _alternativesIuniqueChunk :: (Int)
            _alternativesIunrwars :: ([Warning])
            _alternativesOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _alternativesOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _alternativesOavailablePredicates :: (Predicates)
            _alternativesObetaLeft :: (Tp)
            _alternativesObetaRight :: (Tp)
            _alternativesObetaUnique :: (Int)
            _alternativesOclassEnvironment :: (ClassEnvironment)
            _alternativesOcollectErrors :: (TypeErrors)
            _alternativesOcollectWarnings :: (Warnings)
            _alternativesOcurrentChunk :: (Int)
            _alternativesOdictionaryEnvironment :: (DictionaryEnvironment)
            _alternativesOimportEnvironment :: (ImportEnvironment)
            _alternativesOmatchIO :: (IO ())
            _alternativesOmonos :: (Monos)
            _alternativesOnamesInScope :: (Names)
            _alternativesOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _alternativesOparentTree :: (InfoTree)
            _alternativesOpatternMatchWarnings :: ([Warning])
            _alternativesOsubstitution :: (FixpointSubstitution)
            _alternativesOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _alternativesOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            ( _alternativesIassumptions,_alternativesIbetaUnique,_alternativesIcollectErrors,_alternativesIcollectInstances,_alternativesIcollectWarnings,_alternativesIconstraintslist,_alternativesIdictionaryEnvironment,_alternativesIelementss,_alternativesIinfoTrees,_alternativesImatchIO,_alternativesIpatternMatchWarnings,_alternativesIself,_alternativesIunboundNames,_alternativesIuniqueChunk,_alternativesIunrwars) =
                (alternatives_ (_alternativesOallPatterns)
                               (_alternativesOallTypeSchemes)
                               (_alternativesOavailablePredicates)
                               (_alternativesObetaLeft)
                               (_alternativesObetaRight)
                               (_alternativesObetaUnique)
                               (_alternativesOclassEnvironment)
                               (_alternativesOcollectErrors)
                               (_alternativesOcollectWarnings)
                               (_alternativesOcurrentChunk)
                               (_alternativesOdictionaryEnvironment)
                               (_alternativesOimportEnvironment)
                               (_alternativesOmatchIO)
                               (_alternativesOmonos)
                               (_alternativesOnamesInScope)
                               (_alternativesOorderedTypeSynonyms)
                               (_alternativesOparentTree)
                               (_alternativesOpatternMatchWarnings)
                               (_alternativesOsubstitution)
                               (_alternativesOtypeschemeMap)
                               (_alternativesOuniqueChunk))
            (_newcon@_) =
                [ (_expressionIbeta .==. _beta') _cinfo ]
            (_beta'@_) =
                TVar (_lhsIbetaUnique + 1)
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                Node [ _newcon .<. _expressionIconstraints
                     , Node _alternativesIconstraintslist
                     ]
            (_assumptions@_) =
                _expressionIassumptions `combine` _alternativesIassumptions
            (_alternativesObetaRight@_) =
                _beta
            (_alternativesObetaLeft@_) =
                _beta'
            (_expressionObetaUnique@_) =
                _lhsIbetaUnique + 2
            (_cinfo@_) =
                childConstraint 0 "scrutinee of case expression" _parentTree
                   [ Unifier (head (ftv _beta')) ("case patterns", _localInfo, "scrutinee") ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo (_expressionIinfoTree : _alternativesIinfoTrees)
            (_lhsOmatches@_) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in matchOnlyVariable infoTuple _lhsItryPatterns
            (_expressionOtryPatterns@_) =
                []
            (_lhsOpatternMatchWarnings@_) =
                patternMatchWarnings _lhsIimportEnvironment
                                     _lhsIsubstitution
                                     _expressionIbeta
                                     (:[])
                                     _alternativesIelementss
                                     range_
                                     Nothing
                                     False
                                     _alternativesIunrwars
                                     "case expression"
                                     "->"
                ++ _alternativesIpatternMatchWarnings
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances  ++  _alternativesIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames ++ _alternativesIunboundNames
            (_self@_) =
                Expression_Case _rangeIself _expressionIself _alternativesIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _assumptions
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _alternativesIbetaUnique
            (_lhsOcollectErrors@_) =
                _alternativesIcollectErrors
            (_lhsOcollectWarnings@_) =
                _alternativesIcollectWarnings
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOdictionaryEnvironment@_) =
                _alternativesIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _alternativesImatchIO
            (_lhsOuniqueChunk@_) =
                _alternativesIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _parentTree
            (_expressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_alternativesOallPatterns@_) =
                _lhsIallPatterns
            (_alternativesOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_alternativesOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_alternativesObetaUnique@_) =
                _expressionIbetaUnique
            (_alternativesOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_alternativesOcollectErrors@_) =
                _expressionIcollectErrors
            (_alternativesOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_alternativesOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_alternativesOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_alternativesOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_alternativesOmatchIO@_) =
                _expressionImatchIO
            (_alternativesOmonos@_) =
                _lhsImonos
            (_alternativesOnamesInScope@_) =
                _lhsInamesInScope
            (_alternativesOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_alternativesOparentTree@_) =
                _parentTree
            (_alternativesOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_alternativesOsubstitution@_) =
                _lhsIsubstitution
            (_alternativesOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_alternativesOuniqueChunk@_) =
                _expressionIuniqueChunk
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Comprehension :: (T_Range) ->
                                (T_Expression) ->
                                (T_Qualifiers) ->
                                (T_Expression)
sem_Expression_Comprehension (range_) (expression_) (qualifiers_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            _qualifiersIassumptions :: (Assumptions)
            _qualifiersIbetaUnique :: (Int)
            _qualifiersIcollectErrors :: (TypeErrors)
            _qualifiersIcollectInstances :: ([(Name, Instance)])
            _qualifiersIcollectWarnings :: (Warnings)
            _qualifiersIconstraints :: (ConstraintSet)
            _qualifiersIdictionaryEnvironment :: (DictionaryEnvironment)
            _qualifiersIinfoTrees :: (InfoTrees)
            _qualifiersImatchIO :: (IO ())
            _qualifiersImonos :: (Monos)
            _qualifiersInamesInScope :: (Names)
            _qualifiersIpatternMatchWarnings :: ([Warning])
            _qualifiersIself :: (Qualifiers)
            _qualifiersIunboundNames :: (Names)
            _qualifiersIuniqueChunk :: (Int)
            _qualifiersIuniqueSecondRound :: (Int)
            _qualifiersOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _qualifiersOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _qualifiersOassumptions :: (Assumptions)
            _qualifiersOavailablePredicates :: (Predicates)
            _qualifiersObetaUnique :: (Int)
            _qualifiersOclassEnvironment :: (ClassEnvironment)
            _qualifiersOcollectErrors :: (TypeErrors)
            _qualifiersOcollectWarnings :: (Warnings)
            _qualifiersOconstraints :: (ConstraintSet)
            _qualifiersOcurrentChunk :: (Int)
            _qualifiersOdictionaryEnvironment :: (DictionaryEnvironment)
            _qualifiersOimportEnvironment :: (ImportEnvironment)
            _qualifiersOmatchIO :: (IO ())
            _qualifiersOmonos :: (Monos)
            _qualifiersOnamesInScope :: (Names)
            _qualifiersOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _qualifiersOparentTree :: (InfoTree)
            _qualifiersOpatternMatchWarnings :: ([Warning])
            _qualifiersOsubstitution :: (FixpointSubstitution)
            _qualifiersOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _qualifiersOunboundNames :: (Names)
            _qualifiersOuniqueChunk :: (Int)
            _qualifiersOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            ( _qualifiersIassumptions,_qualifiersIbetaUnique,_qualifiersIcollectErrors,_qualifiersIcollectInstances,_qualifiersIcollectWarnings,_qualifiersIconstraints,_qualifiersIdictionaryEnvironment,_qualifiersIinfoTrees,_qualifiersImatchIO,_qualifiersImonos,_qualifiersInamesInScope,_qualifiersIpatternMatchWarnings,_qualifiersIself,_qualifiersIunboundNames,_qualifiersIuniqueChunk,_qualifiersIuniqueSecondRound) =
                (qualifiers_ (_qualifiersOallPatterns)
                             (_qualifiersOallTypeSchemes)
                             (_qualifiersOassumptions)
                             (_qualifiersOavailablePredicates)
                             (_qualifiersObetaUnique)
                             (_qualifiersOclassEnvironment)
                             (_qualifiersOcollectErrors)
                             (_qualifiersOcollectWarnings)
                             (_qualifiersOconstraints)
                             (_qualifiersOcurrentChunk)
                             (_qualifiersOdictionaryEnvironment)
                             (_qualifiersOimportEnvironment)
                             (_qualifiersOmatchIO)
                             (_qualifiersOmonos)
                             (_qualifiersOnamesInScope)
                             (_qualifiersOorderedTypeSynonyms)
                             (_qualifiersOparentTree)
                             (_qualifiersOpatternMatchWarnings)
                             (_qualifiersOsubstitution)
                             (_qualifiersOtypeschemeMap)
                             (_qualifiersOunboundNames)
                             (_qualifiersOuniqueChunk)
                             (_qualifiersOuniqueSecondRound))
            (_newcon@_) =
                [ (listType _expressionIbeta .==. _beta) _cinfo ]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _newcon .>. Node [ _qualifiersIconstraints ]
            (_assumptions@_) =
                _qualifiersIassumptions
            (_qualifiersOmonos@_) =
                _lhsImonos
            (_qualifiersOconstraints@_) =
                _expressionIconstraints
            (_qualifiersOassumptions@_) =
                _expressionIassumptions
            (_expressionOmonos@_) =
                _qualifiersImonos
            (_expressionObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfo@_) =
                resultConstraint "list comprehension" _parentTree
                   [ FolkloreConstraint ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo _qualifiersIinfoTrees
            (_qualifiersOunboundNames@_) =
                _expressionIunboundNames
            (_qualifiersOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOnamesInScope@_) =
                _qualifiersInamesInScope
            (_lhsOunboundNames@_) =
                _qualifiersIunboundNames
            (_lhsOmatches@_) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in matchOnlyVariable infoTuple _lhsItryPatterns
            (_expressionOtryPatterns@_) =
                []
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances  ++  _qualifiersIcollectInstances
            (_self@_) =
                Expression_Comprehension _rangeIself _expressionIself _qualifiersIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _assumptions
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _qualifiersIbetaUnique
            (_lhsOcollectErrors@_) =
                _qualifiersIcollectErrors
            (_lhsOcollectWarnings@_) =
                _qualifiersIcollectWarnings
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOdictionaryEnvironment@_) =
                _qualifiersIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _qualifiersImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _qualifiersIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _qualifiersIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _qualifiersIuniqueSecondRound
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _parentTree
            (_expressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_qualifiersOallPatterns@_) =
                _lhsIallPatterns
            (_qualifiersOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_qualifiersOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_qualifiersObetaUnique@_) =
                _expressionIbetaUnique
            (_qualifiersOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_qualifiersOcollectErrors@_) =
                _expressionIcollectErrors
            (_qualifiersOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_qualifiersOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_qualifiersOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_qualifiersOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_qualifiersOmatchIO@_) =
                _expressionImatchIO
            (_qualifiersOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_qualifiersOparentTree@_) =
                _parentTree
            (_qualifiersOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_qualifiersOsubstitution@_) =
                _lhsIsubstitution
            (_qualifiersOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_qualifiersOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_qualifiersOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Constructor :: (T_Range) ->
                              (T_Name) ->
                              (T_Expression)
sem_Expression_Constructor (range_) (name_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_newcon@_) =
                case M.lookup _nameIself (valueConstructors _lhsIimportEnvironment) of
                   Nothing  -> []
                   Just ctp -> [ (_beta .::. ctp) _cinfo ]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                listTree _newcon
            (_assumptions@_) =
                noAssumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfo@_) =
                resultConstraint "constructor" _parentTree
                   [ FolkloreConstraint, HasTrustFactor 10.0, IsImported _nameIself ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo []
            (((),_lhsOmatches@_,_lhsOconstraints@_,_lhsOassumptions@_,_lhsOuniqueSecondRound@_,_ioMatch@_)) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in match0 infoTuple _lhsIuniqueSecondRound
                          (match_Expression_Constructor _nameIself)
                          _lhsItryPatterns _lhsIallPatterns
                          []
            (_lhsOmatchIO@_) =
                _lhsImatchIO             >> _ioMatch
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Expression_Constructor _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Do :: (T_Range) ->
                     (T_Statements) ->
                     (T_Expression)
sem_Expression_Do (range_) (statements_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _statementsIassumptions :: (Assumptions)
            _statementsIbetaUnique :: (Int)
            _statementsIcollectErrors :: (TypeErrors)
            _statementsIcollectInstances :: ([(Name, Instance)])
            _statementsIcollectWarnings :: (Warnings)
            _statementsIconstraints :: (ConstraintSet)
            _statementsIdictionaryEnvironment :: (DictionaryEnvironment)
            _statementsIgeneratorBeta :: (Maybe Tp)
            _statementsIinfoTrees :: (InfoTrees)
            _statementsImatchIO :: (IO ())
            _statementsInamesInScope :: (Names)
            _statementsIpatternMatchWarnings :: ([Warning])
            _statementsIself :: (Statements)
            _statementsIunboundNames :: (Names)
            _statementsIuniqueChunk :: (Int)
            _statementsIuniqueSecondRound :: (Int)
            _statementsOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _statementsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _statementsOassumptions :: (Assumptions)
            _statementsOavailablePredicates :: (Predicates)
            _statementsObetaUnique :: (Int)
            _statementsOclassEnvironment :: (ClassEnvironment)
            _statementsOcollectErrors :: (TypeErrors)
            _statementsOcollectWarnings :: (Warnings)
            _statementsOconstraints :: (ConstraintSet)
            _statementsOcurrentChunk :: (Int)
            _statementsOdictionaryEnvironment :: (DictionaryEnvironment)
            _statementsOgeneratorBeta :: (Maybe Tp)
            _statementsOimportEnvironment :: (ImportEnvironment)
            _statementsOmatchIO :: (IO ())
            _statementsOmonos :: (Monos)
            _statementsOnamesInScope :: (Names)
            _statementsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _statementsOparentTree :: (InfoTree)
            _statementsOpatternMatchWarnings :: ([Warning])
            _statementsOsubstitution :: (FixpointSubstitution)
            _statementsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _statementsOunboundNames :: (Names)
            _statementsOuniqueChunk :: (Int)
            _statementsOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _statementsIassumptions,_statementsIbetaUnique,_statementsIcollectErrors,_statementsIcollectInstances,_statementsIcollectWarnings,_statementsIconstraints,_statementsIdictionaryEnvironment,_statementsIgeneratorBeta,_statementsIinfoTrees,_statementsImatchIO,_statementsInamesInScope,_statementsIpatternMatchWarnings,_statementsIself,_statementsIunboundNames,_statementsIuniqueChunk,_statementsIuniqueSecondRound) =
                (statements_ (_statementsOallPatterns)
                             (_statementsOallTypeSchemes)
                             (_statementsOassumptions)
                             (_statementsOavailablePredicates)
                             (_statementsObetaUnique)
                             (_statementsOclassEnvironment)
                             (_statementsOcollectErrors)
                             (_statementsOcollectWarnings)
                             (_statementsOconstraints)
                             (_statementsOcurrentChunk)
                             (_statementsOdictionaryEnvironment)
                             (_statementsOgeneratorBeta)
                             (_statementsOimportEnvironment)
                             (_statementsOmatchIO)
                             (_statementsOmonos)
                             (_statementsOnamesInScope)
                             (_statementsOorderedTypeSynonyms)
                             (_statementsOparentTree)
                             (_statementsOpatternMatchWarnings)
                             (_statementsOsubstitution)
                             (_statementsOtypeschemeMap)
                             (_statementsOunboundNames)
                             (_statementsOuniqueChunk)
                             (_statementsOuniqueSecondRound))
            (_newcon@_) =
                case _statementsIgeneratorBeta of
                   Nothing -> []
                   Just b  -> [ (ioType b .==. _beta) _cinfo ]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                emptyTree
            (_assumptions@_) =
                _statementsIassumptions
            (_statementsOassumptions@_) =
                noAssumptions
            (_statementsOgeneratorBeta@_) =
                Nothing
            (_statementsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_lhsOconstraints@_) =
                Node [ _newcon .<. _statementsIconstraints ]
            (_cinfo@_) =
                resultConstraint "do-expression" _parentTree
                   [ FolkloreConstraint ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo _statementsIinfoTrees
            (_statementsOunboundNames@_) =
                []
            (_lhsOmatches@_) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in matchOnlyVariable infoTuple _lhsItryPatterns
            (_lhsOcollectInstances@_) =
                _statementsIcollectInstances
            (_lhsOunboundNames@_) =
                _statementsIunboundNames
            (_self@_) =
                Expression_Do _rangeIself _statementsIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _assumptions
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _statementsIbetaUnique
            (_lhsOcollectErrors@_) =
                _statementsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _statementsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _statementsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _statementsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _statementsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _statementsIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _statementsIuniqueSecondRound
            (_statementsOallPatterns@_) =
                _lhsIallPatterns
            (_statementsOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_statementsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_statementsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_statementsOcollectErrors@_) =
                _lhsIcollectErrors
            (_statementsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_statementsOconstraints@_) =
                _constraints
            (_statementsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_statementsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_statementsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_statementsOmatchIO@_) =
                _lhsImatchIO
            (_statementsOmonos@_) =
                _lhsImonos
            (_statementsOnamesInScope@_) =
                _lhsInamesInScope
            (_statementsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_statementsOparentTree@_) =
                _parentTree
            (_statementsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_statementsOsubstitution@_) =
                _lhsIsubstitution
            (_statementsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_statementsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_statementsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Enum :: (T_Range) ->
                       (T_Expression) ->
                       (T_MaybeExpression) ->
                       (T_MaybeExpression) ->
                       (T_Expression)
sem_Expression_Enum (range_) (from_) (then_) (to_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _fromIassumptions :: (Assumptions)
            _fromIbeta :: (Tp)
            _fromIbetaUnique :: (Int)
            _fromIcollectErrors :: (TypeErrors)
            _fromIcollectInstances :: ([(Name, Instance)])
            _fromIcollectWarnings :: (Warnings)
            _fromIconstraints :: (ConstraintSet)
            _fromIdictionaryEnvironment :: (DictionaryEnvironment)
            _fromIinfoTree :: (InfoTree)
            _fromImatchIO :: (IO ())
            _fromImatches :: ([Maybe MetaVariableTable])
            _fromIpatternMatchWarnings :: ([Warning])
            _fromIself :: (Expression)
            _fromIunboundNames :: (Names)
            _fromIuniqueChunk :: (Int)
            _fromIuniqueSecondRound :: (Int)
            _fromOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _fromOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _fromOavailablePredicates :: (Predicates)
            _fromObetaUnique :: (Int)
            _fromOclassEnvironment :: (ClassEnvironment)
            _fromOcollectErrors :: (TypeErrors)
            _fromOcollectWarnings :: (Warnings)
            _fromOcurrentChunk :: (Int)
            _fromOdictionaryEnvironment :: (DictionaryEnvironment)
            _fromOimportEnvironment :: (ImportEnvironment)
            _fromOmatchIO :: (IO ())
            _fromOmonos :: (Monos)
            _fromOnamesInScope :: (Names)
            _fromOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _fromOparentTree :: (InfoTree)
            _fromOpatternMatchWarnings :: ([Warning])
            _fromOsubstitution :: (FixpointSubstitution)
            _fromOtryPatterns :: ([(Expression     , [String])])
            _fromOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _fromOuniqueChunk :: (Int)
            _fromOuniqueSecondRound :: (Int)
            _thenIassumptions :: (Assumptions)
            _thenIbeta :: (Tp)
            _thenIbetaUnique :: (Int)
            _thenIcollectErrors :: (TypeErrors)
            _thenIcollectInstances :: ([(Name, Instance)])
            _thenIcollectWarnings :: (Warnings)
            _thenIconstraints :: (ConstraintSet)
            _thenIdictionaryEnvironment :: (DictionaryEnvironment)
            _thenIinfoTrees :: (InfoTrees)
            _thenImatchIO :: (IO ())
            _thenImatches :: ([Maybe MetaVariableTable])
            _thenIpatternMatchWarnings :: ([Warning])
            _thenIsection :: (Bool)
            _thenIself :: (MaybeExpression)
            _thenIunboundNames :: (Names)
            _thenIuniqueChunk :: (Int)
            _thenIuniqueSecondRound :: (Int)
            _thenOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _thenOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _thenOavailablePredicates :: (Predicates)
            _thenObetaUnique :: (Int)
            _thenOclassEnvironment :: (ClassEnvironment)
            _thenOcollectErrors :: (TypeErrors)
            _thenOcollectWarnings :: (Warnings)
            _thenOcurrentChunk :: (Int)
            _thenOdictionaryEnvironment :: (DictionaryEnvironment)
            _thenOimportEnvironment :: (ImportEnvironment)
            _thenOmatchIO :: (IO ())
            _thenOmonos :: (Monos)
            _thenOnamesInScope :: (Names)
            _thenOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _thenOparentTree :: (InfoTree)
            _thenOpatternMatchWarnings :: ([Warning])
            _thenOsubstitution :: (FixpointSubstitution)
            _thenOtryPatterns :: ([(MaybeExpression, [String])])
            _thenOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _thenOuniqueChunk :: (Int)
            _thenOuniqueSecondRound :: (Int)
            _toIassumptions :: (Assumptions)
            _toIbeta :: (Tp)
            _toIbetaUnique :: (Int)
            _toIcollectErrors :: (TypeErrors)
            _toIcollectInstances :: ([(Name, Instance)])
            _toIcollectWarnings :: (Warnings)
            _toIconstraints :: (ConstraintSet)
            _toIdictionaryEnvironment :: (DictionaryEnvironment)
            _toIinfoTrees :: (InfoTrees)
            _toImatchIO :: (IO ())
            _toImatches :: ([Maybe MetaVariableTable])
            _toIpatternMatchWarnings :: ([Warning])
            _toIsection :: (Bool)
            _toIself :: (MaybeExpression)
            _toIunboundNames :: (Names)
            _toIuniqueChunk :: (Int)
            _toIuniqueSecondRound :: (Int)
            _toOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _toOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _toOavailablePredicates :: (Predicates)
            _toObetaUnique :: (Int)
            _toOclassEnvironment :: (ClassEnvironment)
            _toOcollectErrors :: (TypeErrors)
            _toOcollectWarnings :: (Warnings)
            _toOcurrentChunk :: (Int)
            _toOdictionaryEnvironment :: (DictionaryEnvironment)
            _toOimportEnvironment :: (ImportEnvironment)
            _toOmatchIO :: (IO ())
            _toOmonos :: (Monos)
            _toOnamesInScope :: (Names)
            _toOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _toOparentTree :: (InfoTree)
            _toOpatternMatchWarnings :: ([Warning])
            _toOsubstitution :: (FixpointSubstitution)
            _toOtryPatterns :: ([(MaybeExpression, [String])])
            _toOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _toOuniqueChunk :: (Int)
            _toOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _fromIassumptions,_fromIbeta,_fromIbetaUnique,_fromIcollectErrors,_fromIcollectInstances,_fromIcollectWarnings,_fromIconstraints,_fromIdictionaryEnvironment,_fromIinfoTree,_fromImatchIO,_fromImatches,_fromIpatternMatchWarnings,_fromIself,_fromIunboundNames,_fromIuniqueChunk,_fromIuniqueSecondRound) =
                (from_ (_fromOallPatterns)
                       (_fromOallTypeSchemes)
                       (_fromOavailablePredicates)
                       (_fromObetaUnique)
                       (_fromOclassEnvironment)
                       (_fromOcollectErrors)
                       (_fromOcollectWarnings)
                       (_fromOcurrentChunk)
                       (_fromOdictionaryEnvironment)
                       (_fromOimportEnvironment)
                       (_fromOmatchIO)
                       (_fromOmonos)
                       (_fromOnamesInScope)
                       (_fromOorderedTypeSynonyms)
                       (_fromOparentTree)
                       (_fromOpatternMatchWarnings)
                       (_fromOsubstitution)
                       (_fromOtryPatterns)
                       (_fromOtypeschemeMap)
                       (_fromOuniqueChunk)
                       (_fromOuniqueSecondRound))
            ( _thenIassumptions,_thenIbeta,_thenIbetaUnique,_thenIcollectErrors,_thenIcollectInstances,_thenIcollectWarnings,_thenIconstraints,_thenIdictionaryEnvironment,_thenIinfoTrees,_thenImatchIO,_thenImatches,_thenIpatternMatchWarnings,_thenIsection,_thenIself,_thenIunboundNames,_thenIuniqueChunk,_thenIuniqueSecondRound) =
                (then_ (_thenOallPatterns)
                       (_thenOallTypeSchemes)
                       (_thenOavailablePredicates)
                       (_thenObetaUnique)
                       (_thenOclassEnvironment)
                       (_thenOcollectErrors)
                       (_thenOcollectWarnings)
                       (_thenOcurrentChunk)
                       (_thenOdictionaryEnvironment)
                       (_thenOimportEnvironment)
                       (_thenOmatchIO)
                       (_thenOmonos)
                       (_thenOnamesInScope)
                       (_thenOorderedTypeSynonyms)
                       (_thenOparentTree)
                       (_thenOpatternMatchWarnings)
                       (_thenOsubstitution)
                       (_thenOtryPatterns)
                       (_thenOtypeschemeMap)
                       (_thenOuniqueChunk)
                       (_thenOuniqueSecondRound))
            ( _toIassumptions,_toIbeta,_toIbetaUnique,_toIcollectErrors,_toIcollectInstances,_toIcollectWarnings,_toIconstraints,_toIdictionaryEnvironment,_toIinfoTrees,_toImatchIO,_toImatches,_toIpatternMatchWarnings,_toIsection,_toIself,_toIunboundNames,_toIuniqueChunk,_toIuniqueSecondRound) =
                (to_ (_toOallPatterns)
                     (_toOallTypeSchemes)
                     (_toOavailablePredicates)
                     (_toObetaUnique)
                     (_toOclassEnvironment)
                     (_toOcollectErrors)
                     (_toOcollectWarnings)
                     (_toOcurrentChunk)
                     (_toOdictionaryEnvironment)
                     (_toOimportEnvironment)
                     (_toOmatchIO)
                     (_toOmonos)
                     (_toOnamesInScope)
                     (_toOorderedTypeSynonyms)
                     (_toOparentTree)
                     (_toOpatternMatchWarnings)
                     (_toOsubstitution)
                     (_toOtryPatterns)
                     (_toOtypeschemeMap)
                     (_toOuniqueChunk)
                     (_toOuniqueSecondRound))
            (_conTo@_) =
                [ (_toIbeta   .==. _elementType) _cinfoTo   ]
            (_conThen@_) =
                [ (_thenIbeta .==. _elementType) _cinfoThen ]
            (_conFrom@_) =
                [ (_fromIbeta .==. _elementType) _cinfoFrom ]
            (_conList@_) =
                [ (listType _elementType .==. _beta) _cinfoResult ]
            (_conPredicate@_) =
                if _overloaded then [predicate (Predicate "Enum" _elementType) _cinfoPred] else []
            (_elementType@_) =
                if _overloaded then TVar (_lhsIbetaUnique + 1) else intType
            (_overloaded@_) =
                case M.lookup enumFromName (typeEnvironment _lhsIimportEnvironment) of
                   Just scheme -> isOverloaded scheme
                   Nothing     -> False
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                (_conList ++ _conPredicate) .>.
                Node [ _conFrom .<. _fromIconstraints
                     , _conThen .<. _thenIconstraints
                     , _conTo   .<. _toIconstraints
                     ]
            (_assumptions@_) =
                _fromIassumptions `combine` _thenIassumptions `combine` _toIassumptions
            (_fromObetaUnique@_) =
                _lhsIbetaUnique + (if _overloaded then 2 else 1)
            (_newDEnv@_) =
                resolveOverloading (_lhsIclassEnvironment)  _localName
                                   (_lhsIsubstitution |-> _lhsIavailablePredicates)
                                   (_lhsIsubstitution |-> _requiredDictionaries)
                                   _toIdictionaryEnvironment
            (_requiredDictionaries@_) =
                if _overloaded then _lhsIsubstitution |-> [Predicate "Enum" _elementType] else []
            (_localName@_) =
                flip setNameRange _rangeIself $
                case (_thenIsection, _toIsection) of
                   (False, False) -> enumFromThenToName
                   (False, True ) -> enumFromThenName
                   (True , False) -> enumFromToName
                   (True , True ) -> enumFromName
            (_lhsOdictionaryEnvironment@_) =
                _newDEnv
            (_cinfoFrom@_) =
                childConstraint 0 "enumeration" _parentTree
                   []
            (_cinfoThen@_) =
                childConstraint 1 "enumeration" _parentTree
                   []
            (_cinfoTo@_) =
                childConstraint _toChildNr "enumeration" _parentTree
                   []
            (_toChildNr@_) =
                1 + length _thenIinfoTrees
            (_cinfoResult@_) =
                resultConstraint "enumeration" _parentTree
                   [ FolkloreConstraint ]
            (_cinfoPred@_) =
                resultConstraint "enumeration" _parentTree
                   [ ReductionErrorInfo (Predicate "Enum" _elementType) ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo (_fromIinfoTree : _thenIinfoTrees ++ _toIinfoTrees)
            (((_fromOtryPatterns@_,_thenOtryPatterns@_,_toOtryPatterns@_),_lhsOmatches@_,_lhsOconstraints@_,_lhsOassumptions@_,_lhsOuniqueSecondRound@_,_ioMatch@_)) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in match3 infoTuple _toIuniqueSecondRound
                          match_Expression_Enum
                          _lhsItryPatterns _lhsIallPatterns
                          [_fromImatches, _thenImatches, _toImatches]
            (_lhsOmatchIO@_) =
                _toImatchIO              >> _ioMatch
            (_lhsOcollectInstances@_) =
                _fromIcollectInstances  ++  _thenIcollectInstances  ++  _toIcollectInstances
            (_lhsOunboundNames@_) =
                _fromIunboundNames ++ _thenIunboundNames ++ _toIunboundNames
            (_self@_) =
                Expression_Enum _rangeIself _fromIself _thenIself _toIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _toIbetaUnique
            (_lhsOcollectErrors@_) =
                _toIcollectErrors
            (_lhsOcollectWarnings@_) =
                _toIcollectWarnings
            (_lhsOpatternMatchWarnings@_) =
                _toIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _toIuniqueChunk
            (_fromOallPatterns@_) =
                _lhsIallPatterns
            (_fromOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_fromOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_fromOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_fromOcollectErrors@_) =
                _lhsIcollectErrors
            (_fromOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_fromOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_fromOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_fromOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_fromOmatchIO@_) =
                _lhsImatchIO
            (_fromOmonos@_) =
                _lhsImonos
            (_fromOnamesInScope@_) =
                _lhsInamesInScope
            (_fromOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_fromOparentTree@_) =
                _parentTree
            (_fromOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_fromOsubstitution@_) =
                _lhsIsubstitution
            (_fromOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_fromOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_fromOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_thenOallPatterns@_) =
                _lhsIallPatterns
            (_thenOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_thenOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_thenObetaUnique@_) =
                _fromIbetaUnique
            (_thenOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_thenOcollectErrors@_) =
                _fromIcollectErrors
            (_thenOcollectWarnings@_) =
                _fromIcollectWarnings
            (_thenOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_thenOdictionaryEnvironment@_) =
                _fromIdictionaryEnvironment
            (_thenOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_thenOmatchIO@_) =
                _fromImatchIO
            (_thenOmonos@_) =
                _lhsImonos
            (_thenOnamesInScope@_) =
                _lhsInamesInScope
            (_thenOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_thenOparentTree@_) =
                _parentTree
            (_thenOpatternMatchWarnings@_) =
                _fromIpatternMatchWarnings
            (_thenOsubstitution@_) =
                _lhsIsubstitution
            (_thenOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_thenOuniqueChunk@_) =
                _fromIuniqueChunk
            (_thenOuniqueSecondRound@_) =
                _fromIuniqueSecondRound
            (_toOallPatterns@_) =
                _lhsIallPatterns
            (_toOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_toOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_toObetaUnique@_) =
                _thenIbetaUnique
            (_toOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_toOcollectErrors@_) =
                _thenIcollectErrors
            (_toOcollectWarnings@_) =
                _thenIcollectWarnings
            (_toOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_toOdictionaryEnvironment@_) =
                _thenIdictionaryEnvironment
            (_toOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_toOmatchIO@_) =
                _thenImatchIO
            (_toOmonos@_) =
                _lhsImonos
            (_toOnamesInScope@_) =
                _lhsInamesInScope
            (_toOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_toOparentTree@_) =
                _parentTree
            (_toOpatternMatchWarnings@_) =
                _thenIpatternMatchWarnings
            (_toOsubstitution@_) =
                _lhsIsubstitution
            (_toOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_toOuniqueChunk@_) =
                _thenIuniqueChunk
            (_toOuniqueSecondRound@_) =
                _thenIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_If :: (T_Range) ->
                     (T_Expression) ->
                     (T_Expression) ->
                     (T_Expression) ->
                     (T_Expression)
sem_Expression_If (range_) (guardExpression_) (thenExpression_) (elseExpression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _guardExpressionIassumptions :: (Assumptions)
            _guardExpressionIbeta :: (Tp)
            _guardExpressionIbetaUnique :: (Int)
            _guardExpressionIcollectErrors :: (TypeErrors)
            _guardExpressionIcollectInstances :: ([(Name, Instance)])
            _guardExpressionIcollectWarnings :: (Warnings)
            _guardExpressionIconstraints :: (ConstraintSet)
            _guardExpressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _guardExpressionIinfoTree :: (InfoTree)
            _guardExpressionImatchIO :: (IO ())
            _guardExpressionImatches :: ([Maybe MetaVariableTable])
            _guardExpressionIpatternMatchWarnings :: ([Warning])
            _guardExpressionIself :: (Expression)
            _guardExpressionIunboundNames :: (Names)
            _guardExpressionIuniqueChunk :: (Int)
            _guardExpressionIuniqueSecondRound :: (Int)
            _guardExpressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _guardExpressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _guardExpressionOavailablePredicates :: (Predicates)
            _guardExpressionObetaUnique :: (Int)
            _guardExpressionOclassEnvironment :: (ClassEnvironment)
            _guardExpressionOcollectErrors :: (TypeErrors)
            _guardExpressionOcollectWarnings :: (Warnings)
            _guardExpressionOcurrentChunk :: (Int)
            _guardExpressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _guardExpressionOimportEnvironment :: (ImportEnvironment)
            _guardExpressionOmatchIO :: (IO ())
            _guardExpressionOmonos :: (Monos)
            _guardExpressionOnamesInScope :: (Names)
            _guardExpressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _guardExpressionOparentTree :: (InfoTree)
            _guardExpressionOpatternMatchWarnings :: ([Warning])
            _guardExpressionOsubstitution :: (FixpointSubstitution)
            _guardExpressionOtryPatterns :: ([(Expression     , [String])])
            _guardExpressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _guardExpressionOuniqueChunk :: (Int)
            _guardExpressionOuniqueSecondRound :: (Int)
            _thenExpressionIassumptions :: (Assumptions)
            _thenExpressionIbeta :: (Tp)
            _thenExpressionIbetaUnique :: (Int)
            _thenExpressionIcollectErrors :: (TypeErrors)
            _thenExpressionIcollectInstances :: ([(Name, Instance)])
            _thenExpressionIcollectWarnings :: (Warnings)
            _thenExpressionIconstraints :: (ConstraintSet)
            _thenExpressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _thenExpressionIinfoTree :: (InfoTree)
            _thenExpressionImatchIO :: (IO ())
            _thenExpressionImatches :: ([Maybe MetaVariableTable])
            _thenExpressionIpatternMatchWarnings :: ([Warning])
            _thenExpressionIself :: (Expression)
            _thenExpressionIunboundNames :: (Names)
            _thenExpressionIuniqueChunk :: (Int)
            _thenExpressionIuniqueSecondRound :: (Int)
            _thenExpressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _thenExpressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _thenExpressionOavailablePredicates :: (Predicates)
            _thenExpressionObetaUnique :: (Int)
            _thenExpressionOclassEnvironment :: (ClassEnvironment)
            _thenExpressionOcollectErrors :: (TypeErrors)
            _thenExpressionOcollectWarnings :: (Warnings)
            _thenExpressionOcurrentChunk :: (Int)
            _thenExpressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _thenExpressionOimportEnvironment :: (ImportEnvironment)
            _thenExpressionOmatchIO :: (IO ())
            _thenExpressionOmonos :: (Monos)
            _thenExpressionOnamesInScope :: (Names)
            _thenExpressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _thenExpressionOparentTree :: (InfoTree)
            _thenExpressionOpatternMatchWarnings :: ([Warning])
            _thenExpressionOsubstitution :: (FixpointSubstitution)
            _thenExpressionOtryPatterns :: ([(Expression     , [String])])
            _thenExpressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _thenExpressionOuniqueChunk :: (Int)
            _thenExpressionOuniqueSecondRound :: (Int)
            _elseExpressionIassumptions :: (Assumptions)
            _elseExpressionIbeta :: (Tp)
            _elseExpressionIbetaUnique :: (Int)
            _elseExpressionIcollectErrors :: (TypeErrors)
            _elseExpressionIcollectInstances :: ([(Name, Instance)])
            _elseExpressionIcollectWarnings :: (Warnings)
            _elseExpressionIconstraints :: (ConstraintSet)
            _elseExpressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _elseExpressionIinfoTree :: (InfoTree)
            _elseExpressionImatchIO :: (IO ())
            _elseExpressionImatches :: ([Maybe MetaVariableTable])
            _elseExpressionIpatternMatchWarnings :: ([Warning])
            _elseExpressionIself :: (Expression)
            _elseExpressionIunboundNames :: (Names)
            _elseExpressionIuniqueChunk :: (Int)
            _elseExpressionIuniqueSecondRound :: (Int)
            _elseExpressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _elseExpressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _elseExpressionOavailablePredicates :: (Predicates)
            _elseExpressionObetaUnique :: (Int)
            _elseExpressionOclassEnvironment :: (ClassEnvironment)
            _elseExpressionOcollectErrors :: (TypeErrors)
            _elseExpressionOcollectWarnings :: (Warnings)
            _elseExpressionOcurrentChunk :: (Int)
            _elseExpressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _elseExpressionOimportEnvironment :: (ImportEnvironment)
            _elseExpressionOmatchIO :: (IO ())
            _elseExpressionOmonos :: (Monos)
            _elseExpressionOnamesInScope :: (Names)
            _elseExpressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _elseExpressionOparentTree :: (InfoTree)
            _elseExpressionOpatternMatchWarnings :: ([Warning])
            _elseExpressionOsubstitution :: (FixpointSubstitution)
            _elseExpressionOtryPatterns :: ([(Expression     , [String])])
            _elseExpressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _elseExpressionOuniqueChunk :: (Int)
            _elseExpressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _guardExpressionIassumptions
             ,_guardExpressionIbeta
             ,_guardExpressionIbetaUnique
             ,_guardExpressionIcollectErrors
             ,_guardExpressionIcollectInstances
             ,_guardExpressionIcollectWarnings
             ,_guardExpressionIconstraints
             ,_guardExpressionIdictionaryEnvironment
             ,_guardExpressionIinfoTree
             ,_guardExpressionImatchIO
             ,_guardExpressionImatches
             ,_guardExpressionIpatternMatchWarnings
             ,_guardExpressionIself
             ,_guardExpressionIunboundNames
             ,_guardExpressionIuniqueChunk
             ,_guardExpressionIuniqueSecondRound
             ) =
                (guardExpression_ (_guardExpressionOallPatterns)
                                  (_guardExpressionOallTypeSchemes)
                                  (_guardExpressionOavailablePredicates)
                                  (_guardExpressionObetaUnique)
                                  (_guardExpressionOclassEnvironment)
                                  (_guardExpressionOcollectErrors)
                                  (_guardExpressionOcollectWarnings)
                                  (_guardExpressionOcurrentChunk)
                                  (_guardExpressionOdictionaryEnvironment)
                                  (_guardExpressionOimportEnvironment)
                                  (_guardExpressionOmatchIO)
                                  (_guardExpressionOmonos)
                                  (_guardExpressionOnamesInScope)
                                  (_guardExpressionOorderedTypeSynonyms)
                                  (_guardExpressionOparentTree)
                                  (_guardExpressionOpatternMatchWarnings)
                                  (_guardExpressionOsubstitution)
                                  (_guardExpressionOtryPatterns)
                                  (_guardExpressionOtypeschemeMap)
                                  (_guardExpressionOuniqueChunk)
                                  (_guardExpressionOuniqueSecondRound))
            ( _thenExpressionIassumptions
             ,_thenExpressionIbeta
             ,_thenExpressionIbetaUnique
             ,_thenExpressionIcollectErrors
             ,_thenExpressionIcollectInstances
             ,_thenExpressionIcollectWarnings
             ,_thenExpressionIconstraints
             ,_thenExpressionIdictionaryEnvironment
             ,_thenExpressionIinfoTree
             ,_thenExpressionImatchIO
             ,_thenExpressionImatches
             ,_thenExpressionIpatternMatchWarnings
             ,_thenExpressionIself
             ,_thenExpressionIunboundNames
             ,_thenExpressionIuniqueChunk
             ,_thenExpressionIuniqueSecondRound
             ) =
                (thenExpression_ (_thenExpressionOallPatterns)
                                 (_thenExpressionOallTypeSchemes)
                                 (_thenExpressionOavailablePredicates)
                                 (_thenExpressionObetaUnique)
                                 (_thenExpressionOclassEnvironment)
                                 (_thenExpressionOcollectErrors)
                                 (_thenExpressionOcollectWarnings)
                                 (_thenExpressionOcurrentChunk)
                                 (_thenExpressionOdictionaryEnvironment)
                                 (_thenExpressionOimportEnvironment)
                                 (_thenExpressionOmatchIO)
                                 (_thenExpressionOmonos)
                                 (_thenExpressionOnamesInScope)
                                 (_thenExpressionOorderedTypeSynonyms)
                                 (_thenExpressionOparentTree)
                                 (_thenExpressionOpatternMatchWarnings)
                                 (_thenExpressionOsubstitution)
                                 (_thenExpressionOtryPatterns)
                                 (_thenExpressionOtypeschemeMap)
                                 (_thenExpressionOuniqueChunk)
                                 (_thenExpressionOuniqueSecondRound))
            ( _elseExpressionIassumptions
             ,_elseExpressionIbeta
             ,_elseExpressionIbetaUnique
             ,_elseExpressionIcollectErrors
             ,_elseExpressionIcollectInstances
             ,_elseExpressionIcollectWarnings
             ,_elseExpressionIconstraints
             ,_elseExpressionIdictionaryEnvironment
             ,_elseExpressionIinfoTree
             ,_elseExpressionImatchIO
             ,_elseExpressionImatches
             ,_elseExpressionIpatternMatchWarnings
             ,_elseExpressionIself
             ,_elseExpressionIunboundNames
             ,_elseExpressionIuniqueChunk
             ,_elseExpressionIuniqueSecondRound
             ) =
                (elseExpression_ (_elseExpressionOallPatterns)
                                 (_elseExpressionOallTypeSchemes)
                                 (_elseExpressionOavailablePredicates)
                                 (_elseExpressionObetaUnique)
                                 (_elseExpressionOclassEnvironment)
                                 (_elseExpressionOcollectErrors)
                                 (_elseExpressionOcollectWarnings)
                                 (_elseExpressionOcurrentChunk)
                                 (_elseExpressionOdictionaryEnvironment)
                                 (_elseExpressionOimportEnvironment)
                                 (_elseExpressionOmatchIO)
                                 (_elseExpressionOmonos)
                                 (_elseExpressionOnamesInScope)
                                 (_elseExpressionOorderedTypeSynonyms)
                                 (_elseExpressionOparentTree)
                                 (_elseExpressionOpatternMatchWarnings)
                                 (_elseExpressionOsubstitution)
                                 (_elseExpressionOtryPatterns)
                                 (_elseExpressionOtypeschemeMap)
                                 (_elseExpressionOuniqueChunk)
                                 (_elseExpressionOuniqueSecondRound))
            (_conElse@_) =
                [ (_elseExpressionIbeta  .==. _beta   ) _cinfoElse  ]
            (_conThen@_) =
                [ (_thenExpressionIbeta  .==. _beta   ) _cinfoThen  ]
            (_conGuard@_) =
                [ (_guardExpressionIbeta .==. boolType) _cinfoGuard ]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                Node [ _conGuard .<. _guardExpressionIconstraints
                     , _conThen  .<. _thenExpressionIconstraints
                     , _conElse  .<. _elseExpressionIconstraints
                     ]
            (_assumptions@_) =
                _guardExpressionIassumptions `combine` _thenExpressionIassumptions `combine` _elseExpressionIassumptions
            (_guardExpressionObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfoGuard@_) =
                childConstraint 0 "conditional" _parentTree
                   []
            (_cinfoThen@_) =
                childConstraint 1 "then branch of conditional" _parentTree
                   [ Unifier (head (ftv _beta)) ("conditional", _localInfo, "then branch") ]
            (_cinfoElse@_) =
                childConstraint 2 "else branch of conditional" _parentTree
                   [ Unifier (head (ftv _beta)) ("conditional", _localInfo, "else branch") ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo [_guardExpressionIinfoTree, _thenExpressionIinfoTree, _elseExpressionIinfoTree]
            (((_guardExpressionOtryPatterns@_,_thenExpressionOtryPatterns@_,_elseExpressionOtryPatterns@_),_lhsOmatches@_,_lhsOconstraints@_,_lhsOassumptions@_,_lhsOuniqueSecondRound@_,_ioMatch@_)) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in match3 infoTuple _elseExpressionIuniqueSecondRound
                          match_Expression_If
                          _lhsItryPatterns _lhsIallPatterns
                          [_guardExpressionImatches,_thenExpressionImatches,_elseExpressionImatches]
            (_lhsOmatchIO@_) =
                _elseExpressionImatchIO  >> _ioMatch
            (_lhsOcollectInstances@_) =
                _guardExpressionIcollectInstances  ++  _thenExpressionIcollectInstances  ++  _elseExpressionIcollectInstances
            (_lhsOunboundNames@_) =
                _guardExpressionIunboundNames ++ _thenExpressionIunboundNames ++ _elseExpressionIunboundNames
            (_self@_) =
                Expression_If _rangeIself _guardExpressionIself _thenExpressionIself _elseExpressionIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _elseExpressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _elseExpressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _elseExpressionIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _elseExpressionIdictionaryEnvironment
            (_lhsOpatternMatchWarnings@_) =
                _elseExpressionIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _elseExpressionIuniqueChunk
            (_guardExpressionOallPatterns@_) =
                _lhsIallPatterns
            (_guardExpressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_guardExpressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_guardExpressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_guardExpressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_guardExpressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_guardExpressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_guardExpressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_guardExpressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_guardExpressionOmatchIO@_) =
                _lhsImatchIO
            (_guardExpressionOmonos@_) =
                _lhsImonos
            (_guardExpressionOnamesInScope@_) =
                _lhsInamesInScope
            (_guardExpressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_guardExpressionOparentTree@_) =
                _parentTree
            (_guardExpressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_guardExpressionOsubstitution@_) =
                _lhsIsubstitution
            (_guardExpressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_guardExpressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_guardExpressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_thenExpressionOallPatterns@_) =
                _lhsIallPatterns
            (_thenExpressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_thenExpressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_thenExpressionObetaUnique@_) =
                _guardExpressionIbetaUnique
            (_thenExpressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_thenExpressionOcollectErrors@_) =
                _guardExpressionIcollectErrors
            (_thenExpressionOcollectWarnings@_) =
                _guardExpressionIcollectWarnings
            (_thenExpressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_thenExpressionOdictionaryEnvironment@_) =
                _guardExpressionIdictionaryEnvironment
            (_thenExpressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_thenExpressionOmatchIO@_) =
                _guardExpressionImatchIO
            (_thenExpressionOmonos@_) =
                _lhsImonos
            (_thenExpressionOnamesInScope@_) =
                _lhsInamesInScope
            (_thenExpressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_thenExpressionOparentTree@_) =
                _parentTree
            (_thenExpressionOpatternMatchWarnings@_) =
                _guardExpressionIpatternMatchWarnings
            (_thenExpressionOsubstitution@_) =
                _lhsIsubstitution
            (_thenExpressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_thenExpressionOuniqueChunk@_) =
                _guardExpressionIuniqueChunk
            (_thenExpressionOuniqueSecondRound@_) =
                _guardExpressionIuniqueSecondRound
            (_elseExpressionOallPatterns@_) =
                _lhsIallPatterns
            (_elseExpressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_elseExpressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_elseExpressionObetaUnique@_) =
                _thenExpressionIbetaUnique
            (_elseExpressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_elseExpressionOcollectErrors@_) =
                _thenExpressionIcollectErrors
            (_elseExpressionOcollectWarnings@_) =
                _thenExpressionIcollectWarnings
            (_elseExpressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_elseExpressionOdictionaryEnvironment@_) =
                _thenExpressionIdictionaryEnvironment
            (_elseExpressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_elseExpressionOmatchIO@_) =
                _thenExpressionImatchIO
            (_elseExpressionOmonos@_) =
                _lhsImonos
            (_elseExpressionOnamesInScope@_) =
                _lhsInamesInScope
            (_elseExpressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_elseExpressionOparentTree@_) =
                _parentTree
            (_elseExpressionOpatternMatchWarnings@_) =
                _thenExpressionIpatternMatchWarnings
            (_elseExpressionOsubstitution@_) =
                _lhsIsubstitution
            (_elseExpressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_elseExpressionOuniqueChunk@_) =
                _thenExpressionIuniqueChunk
            (_elseExpressionOuniqueSecondRound@_) =
                _thenExpressionIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_InfixApplication :: (T_Range) ->
                                   (T_MaybeExpression) ->
                                   (T_Expression) ->
                                   (T_MaybeExpression) ->
                                   (T_Expression)
sem_Expression_InfixApplication (range_) (leftExpression_) (operator_) (rightExpression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _leftExpressionIassumptions :: (Assumptions)
            _leftExpressionIbeta :: (Tp)
            _leftExpressionIbetaUnique :: (Int)
            _leftExpressionIcollectErrors :: (TypeErrors)
            _leftExpressionIcollectInstances :: ([(Name, Instance)])
            _leftExpressionIcollectWarnings :: (Warnings)
            _leftExpressionIconstraints :: (ConstraintSet)
            _leftExpressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _leftExpressionIinfoTrees :: (InfoTrees)
            _leftExpressionImatchIO :: (IO ())
            _leftExpressionImatches :: ([Maybe MetaVariableTable])
            _leftExpressionIpatternMatchWarnings :: ([Warning])
            _leftExpressionIsection :: (Bool)
            _leftExpressionIself :: (MaybeExpression)
            _leftExpressionIunboundNames :: (Names)
            _leftExpressionIuniqueChunk :: (Int)
            _leftExpressionIuniqueSecondRound :: (Int)
            _leftExpressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _leftExpressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _leftExpressionOavailablePredicates :: (Predicates)
            _leftExpressionObetaUnique :: (Int)
            _leftExpressionOclassEnvironment :: (ClassEnvironment)
            _leftExpressionOcollectErrors :: (TypeErrors)
            _leftExpressionOcollectWarnings :: (Warnings)
            _leftExpressionOcurrentChunk :: (Int)
            _leftExpressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _leftExpressionOimportEnvironment :: (ImportEnvironment)
            _leftExpressionOmatchIO :: (IO ())
            _leftExpressionOmonos :: (Monos)
            _leftExpressionOnamesInScope :: (Names)
            _leftExpressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _leftExpressionOparentTree :: (InfoTree)
            _leftExpressionOpatternMatchWarnings :: ([Warning])
            _leftExpressionOsubstitution :: (FixpointSubstitution)
            _leftExpressionOtryPatterns :: ([(MaybeExpression, [String])])
            _leftExpressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _leftExpressionOuniqueChunk :: (Int)
            _leftExpressionOuniqueSecondRound :: (Int)
            _operatorIassumptions :: (Assumptions)
            _operatorIbeta :: (Tp)
            _operatorIbetaUnique :: (Int)
            _operatorIcollectErrors :: (TypeErrors)
            _operatorIcollectInstances :: ([(Name, Instance)])
            _operatorIcollectWarnings :: (Warnings)
            _operatorIconstraints :: (ConstraintSet)
            _operatorIdictionaryEnvironment :: (DictionaryEnvironment)
            _operatorIinfoTree :: (InfoTree)
            _operatorImatchIO :: (IO ())
            _operatorImatches :: ([Maybe MetaVariableTable])
            _operatorIpatternMatchWarnings :: ([Warning])
            _operatorIself :: (Expression)
            _operatorIunboundNames :: (Names)
            _operatorIuniqueChunk :: (Int)
            _operatorIuniqueSecondRound :: (Int)
            _operatorOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _operatorOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _operatorOavailablePredicates :: (Predicates)
            _operatorObetaUnique :: (Int)
            _operatorOclassEnvironment :: (ClassEnvironment)
            _operatorOcollectErrors :: (TypeErrors)
            _operatorOcollectWarnings :: (Warnings)
            _operatorOcurrentChunk :: (Int)
            _operatorOdictionaryEnvironment :: (DictionaryEnvironment)
            _operatorOimportEnvironment :: (ImportEnvironment)
            _operatorOmatchIO :: (IO ())
            _operatorOmonos :: (Monos)
            _operatorOnamesInScope :: (Names)
            _operatorOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _operatorOparentTree :: (InfoTree)
            _operatorOpatternMatchWarnings :: ([Warning])
            _operatorOsubstitution :: (FixpointSubstitution)
            _operatorOtryPatterns :: ([(Expression     , [String])])
            _operatorOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _operatorOuniqueChunk :: (Int)
            _operatorOuniqueSecondRound :: (Int)
            _rightExpressionIassumptions :: (Assumptions)
            _rightExpressionIbeta :: (Tp)
            _rightExpressionIbetaUnique :: (Int)
            _rightExpressionIcollectErrors :: (TypeErrors)
            _rightExpressionIcollectInstances :: ([(Name, Instance)])
            _rightExpressionIcollectWarnings :: (Warnings)
            _rightExpressionIconstraints :: (ConstraintSet)
            _rightExpressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _rightExpressionIinfoTrees :: (InfoTrees)
            _rightExpressionImatchIO :: (IO ())
            _rightExpressionImatches :: ([Maybe MetaVariableTable])
            _rightExpressionIpatternMatchWarnings :: ([Warning])
            _rightExpressionIsection :: (Bool)
            _rightExpressionIself :: (MaybeExpression)
            _rightExpressionIunboundNames :: (Names)
            _rightExpressionIuniqueChunk :: (Int)
            _rightExpressionIuniqueSecondRound :: (Int)
            _rightExpressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _rightExpressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _rightExpressionOavailablePredicates :: (Predicates)
            _rightExpressionObetaUnique :: (Int)
            _rightExpressionOclassEnvironment :: (ClassEnvironment)
            _rightExpressionOcollectErrors :: (TypeErrors)
            _rightExpressionOcollectWarnings :: (Warnings)
            _rightExpressionOcurrentChunk :: (Int)
            _rightExpressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _rightExpressionOimportEnvironment :: (ImportEnvironment)
            _rightExpressionOmatchIO :: (IO ())
            _rightExpressionOmonos :: (Monos)
            _rightExpressionOnamesInScope :: (Names)
            _rightExpressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _rightExpressionOparentTree :: (InfoTree)
            _rightExpressionOpatternMatchWarnings :: ([Warning])
            _rightExpressionOsubstitution :: (FixpointSubstitution)
            _rightExpressionOtryPatterns :: ([(MaybeExpression, [String])])
            _rightExpressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _rightExpressionOuniqueChunk :: (Int)
            _rightExpressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _leftExpressionIassumptions
             ,_leftExpressionIbeta
             ,_leftExpressionIbetaUnique
             ,_leftExpressionIcollectErrors
             ,_leftExpressionIcollectInstances
             ,_leftExpressionIcollectWarnings
             ,_leftExpressionIconstraints
             ,_leftExpressionIdictionaryEnvironment
             ,_leftExpressionIinfoTrees
             ,_leftExpressionImatchIO
             ,_leftExpressionImatches
             ,_leftExpressionIpatternMatchWarnings
             ,_leftExpressionIsection
             ,_leftExpressionIself
             ,_leftExpressionIunboundNames
             ,_leftExpressionIuniqueChunk
             ,_leftExpressionIuniqueSecondRound
             ) =
                (leftExpression_ (_leftExpressionOallPatterns)
                                 (_leftExpressionOallTypeSchemes)
                                 (_leftExpressionOavailablePredicates)
                                 (_leftExpressionObetaUnique)
                                 (_leftExpressionOclassEnvironment)
                                 (_leftExpressionOcollectErrors)
                                 (_leftExpressionOcollectWarnings)
                                 (_leftExpressionOcurrentChunk)
                                 (_leftExpressionOdictionaryEnvironment)
                                 (_leftExpressionOimportEnvironment)
                                 (_leftExpressionOmatchIO)
                                 (_leftExpressionOmonos)
                                 (_leftExpressionOnamesInScope)
                                 (_leftExpressionOorderedTypeSynonyms)
                                 (_leftExpressionOparentTree)
                                 (_leftExpressionOpatternMatchWarnings)
                                 (_leftExpressionOsubstitution)
                                 (_leftExpressionOtryPatterns)
                                 (_leftExpressionOtypeschemeMap)
                                 (_leftExpressionOuniqueChunk)
                                 (_leftExpressionOuniqueSecondRound))
            ( _operatorIassumptions,_operatorIbeta,_operatorIbetaUnique,_operatorIcollectErrors,_operatorIcollectInstances,_operatorIcollectWarnings,_operatorIconstraints,_operatorIdictionaryEnvironment,_operatorIinfoTree,_operatorImatchIO,_operatorImatches,_operatorIpatternMatchWarnings,_operatorIself,_operatorIunboundNames,_operatorIuniqueChunk,_operatorIuniqueSecondRound) =
                (operator_ (_operatorOallPatterns)
                           (_operatorOallTypeSchemes)
                           (_operatorOavailablePredicates)
                           (_operatorObetaUnique)
                           (_operatorOclassEnvironment)
                           (_operatorOcollectErrors)
                           (_operatorOcollectWarnings)
                           (_operatorOcurrentChunk)
                           (_operatorOdictionaryEnvironment)
                           (_operatorOimportEnvironment)
                           (_operatorOmatchIO)
                           (_operatorOmonos)
                           (_operatorOnamesInScope)
                           (_operatorOorderedTypeSynonyms)
                           (_operatorOparentTree)
                           (_operatorOpatternMatchWarnings)
                           (_operatorOsubstitution)
                           (_operatorOtryPatterns)
                           (_operatorOtypeschemeMap)
                           (_operatorOuniqueChunk)
                           (_operatorOuniqueSecondRound))
            ( _rightExpressionIassumptions
             ,_rightExpressionIbeta
             ,_rightExpressionIbetaUnique
             ,_rightExpressionIcollectErrors
             ,_rightExpressionIcollectInstances
             ,_rightExpressionIcollectWarnings
             ,_rightExpressionIconstraints
             ,_rightExpressionIdictionaryEnvironment
             ,_rightExpressionIinfoTrees
             ,_rightExpressionImatchIO
             ,_rightExpressionImatches
             ,_rightExpressionIpatternMatchWarnings
             ,_rightExpressionIsection
             ,_rightExpressionIself
             ,_rightExpressionIunboundNames
             ,_rightExpressionIuniqueChunk
             ,_rightExpressionIuniqueSecondRound
             ) =
                (rightExpression_ (_rightExpressionOallPatterns)
                                  (_rightExpressionOallTypeSchemes)
                                  (_rightExpressionOavailablePredicates)
                                  (_rightExpressionObetaUnique)
                                  (_rightExpressionOclassEnvironment)
                                  (_rightExpressionOcollectErrors)
                                  (_rightExpressionOcollectWarnings)
                                  (_rightExpressionOcurrentChunk)
                                  (_rightExpressionOdictionaryEnvironment)
                                  (_rightExpressionOimportEnvironment)
                                  (_rightExpressionOmatchIO)
                                  (_rightExpressionOmonos)
                                  (_rightExpressionOnamesInScope)
                                  (_rightExpressionOorderedTypeSynonyms)
                                  (_rightExpressionOparentTree)
                                  (_rightExpressionOpatternMatchWarnings)
                                  (_rightExpressionOsubstitution)
                                  (_rightExpressionOtryPatterns)
                                  (_rightExpressionOtypeschemeMap)
                                  (_rightExpressionOuniqueChunk)
                                  (_rightExpressionOuniqueSecondRound))
            (_conTotal@_) =
                case (_leftExpressionIsection,_rightExpressionIsection) of
                       (False,False) -> [ _conOperator, (_betaResOp     .==. _beta)                        _cinfoComplete     ]
                       (True ,True ) -> [               (_operatorIbeta .==. _beta)                        _cinfoEmpty        ]
                       (False,True ) -> [ _conOperator, (_rightExpressionIbeta .->. _betaResOp .==. _beta) _cinfoRightSection ]
                       (True ,False) -> [ _conOperator, (_leftExpressionIbeta  .->. _betaResOp .==. _beta) _cinfoLeftSection  ]
            (_conOperator@_) =
                (_operatorIbeta .==. _leftExpressionIbeta .->. _rightExpressionIbeta .->. _betaResOp) _cinfoOperator
            (_betaResOp@_) =
                TVar (_lhsIbetaUnique + 1)
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _conTotal .>.
                Node [ _operatorIconstraints
                     , _leftExpressionIconstraints
                     , _rightExpressionIconstraints
                     ]
            (_assumptions@_) =
                _leftExpressionIassumptions `combine` _operatorIassumptions `combine` _rightExpressionIassumptions
            (_leftExpressionObetaUnique@_) =
                _lhsIbetaUnique + 2
            (_cinfoOperator@_) =
                childConstraint _operatorNr "infix application" _parentTree $
                   if _leftExpressionIsection || _rightExpressionIsection
                   then [ HasTrustFactor 10.0 ]
                   else [ ApplicationEdge True (map attribute (_leftExpressionIinfoTrees ++ _rightExpressionIinfoTrees)) ]
            (_operatorNr@_) =
                length _leftExpressionIinfoTrees
            (_cinfoComplete@_) =
                specialConstraint "infix application (INTERNAL ERROR)" _parentTree
                   (self _localInfo, Nothing)
                   [ FolkloreConstraint, highlyTrusted ]
            (_cinfoLeftSection@_) =
                specialConstraint "left section" _parentTree
                   (self _localInfo, Nothing)
                   [  ]
            (_cinfoRightSection@_) =
                specialConstraint "right section" _parentTree
                   (self _localInfo, Nothing)
                   [ ]
            (_cinfoEmpty@_) =
                specialConstraint "infix application" _parentTree
                  (self _localInfo, Nothing)
                  [ FolkloreConstraint, HasTrustFactor 10.0 ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo
                  (_leftExpressionIinfoTrees ++ [_operatorIinfoTree] ++ _rightExpressionIinfoTrees)
            (((_leftExpressionOtryPatterns@_,_operatorOtryPatterns@_,_rightExpressionOtryPatterns@_),_lhsOmatches@_,_lhsOconstraints@_,_lhsOassumptions@_,_lhsOuniqueSecondRound@_,_ioMatch@_)) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in match3 infoTuple _rightExpressionIuniqueSecondRound
                          match_Expression_InfixApplication
                          _lhsItryPatterns _lhsIallPatterns
                          [_leftExpressionImatches, _operatorImatches,_rightExpressionImatches]
            (_lhsOmatchIO@_) =
                _rightExpressionImatchIO >> _ioMatch
            (_lhsOcollectInstances@_) =
                _leftExpressionIcollectInstances  ++  _operatorIcollectInstances  ++  _rightExpressionIcollectInstances
            (_lhsOunboundNames@_) =
                _leftExpressionIunboundNames ++ _operatorIunboundNames ++ _rightExpressionIunboundNames
            (_self@_) =
                Expression_InfixApplication _rangeIself _leftExpressionIself _operatorIself _rightExpressionIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _rightExpressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _rightExpressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _rightExpressionIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _rightExpressionIdictionaryEnvironment
            (_lhsOpatternMatchWarnings@_) =
                _rightExpressionIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _rightExpressionIuniqueChunk
            (_leftExpressionOallPatterns@_) =
                _lhsIallPatterns
            (_leftExpressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_leftExpressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_leftExpressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_leftExpressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_leftExpressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_leftExpressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_leftExpressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_leftExpressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_leftExpressionOmatchIO@_) =
                _lhsImatchIO
            (_leftExpressionOmonos@_) =
                _lhsImonos
            (_leftExpressionOnamesInScope@_) =
                _lhsInamesInScope
            (_leftExpressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_leftExpressionOparentTree@_) =
                _parentTree
            (_leftExpressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_leftExpressionOsubstitution@_) =
                _lhsIsubstitution
            (_leftExpressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_leftExpressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_leftExpressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_operatorOallPatterns@_) =
                _lhsIallPatterns
            (_operatorOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_operatorOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_operatorObetaUnique@_) =
                _leftExpressionIbetaUnique
            (_operatorOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_operatorOcollectErrors@_) =
                _leftExpressionIcollectErrors
            (_operatorOcollectWarnings@_) =
                _leftExpressionIcollectWarnings
            (_operatorOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_operatorOdictionaryEnvironment@_) =
                _leftExpressionIdictionaryEnvironment
            (_operatorOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_operatorOmatchIO@_) =
                _leftExpressionImatchIO
            (_operatorOmonos@_) =
                _lhsImonos
            (_operatorOnamesInScope@_) =
                _lhsInamesInScope
            (_operatorOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_operatorOparentTree@_) =
                _parentTree
            (_operatorOpatternMatchWarnings@_) =
                _leftExpressionIpatternMatchWarnings
            (_operatorOsubstitution@_) =
                _lhsIsubstitution
            (_operatorOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_operatorOuniqueChunk@_) =
                _leftExpressionIuniqueChunk
            (_operatorOuniqueSecondRound@_) =
                _leftExpressionIuniqueSecondRound
            (_rightExpressionOallPatterns@_) =
                _lhsIallPatterns
            (_rightExpressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_rightExpressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_rightExpressionObetaUnique@_) =
                _operatorIbetaUnique
            (_rightExpressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_rightExpressionOcollectErrors@_) =
                _operatorIcollectErrors
            (_rightExpressionOcollectWarnings@_) =
                _operatorIcollectWarnings
            (_rightExpressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_rightExpressionOdictionaryEnvironment@_) =
                _operatorIdictionaryEnvironment
            (_rightExpressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_rightExpressionOmatchIO@_) =
                _operatorImatchIO
            (_rightExpressionOmonos@_) =
                _lhsImonos
            (_rightExpressionOnamesInScope@_) =
                _lhsInamesInScope
            (_rightExpressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_rightExpressionOparentTree@_) =
                _parentTree
            (_rightExpressionOpatternMatchWarnings@_) =
                _operatorIpatternMatchWarnings
            (_rightExpressionOsubstitution@_) =
                _lhsIsubstitution
            (_rightExpressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_rightExpressionOuniqueChunk@_) =
                _operatorIuniqueChunk
            (_rightExpressionOuniqueSecondRound@_) =
                _operatorIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Lambda :: (T_Range) ->
                         (T_Patterns) ->
                         (T_Expression) ->
                         (T_Expression)
sem_Expression_Lambda (range_) (patterns_) (expression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _patternsIbetaUnique :: (Int)
            _patternsIbetas :: (Tps)
            _patternsIconstraintslist :: (ConstraintSets)
            _patternsIelementss :: ([ [PatternElement]       ])
            _patternsIenvironment :: (PatternAssumptions)
            _patternsIinfoTrees :: (InfoTrees)
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIpatternMatchWarnings :: ([Warning])
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsObetaUnique :: (Int)
            _patternsOimportEnvironment :: (ImportEnvironment)
            _patternsOmonos :: (Monos)
            _patternsOnamesInScope :: (Names)
            _patternsOparentTree :: (InfoTree)
            _patternsOpatternMatchWarnings :: ([Warning])
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _patternsIbetaUnique,_patternsIbetas,_patternsIconstraintslist,_patternsIelementss,_patternsIenvironment,_patternsIinfoTrees,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIpatternMatchWarnings,_patternsIself,_patternsIunboundNames) =
                (patterns_ (_patternsObetaUnique) (_patternsOimportEnvironment) (_patternsOmonos) (_patternsOnamesInScope) (_patternsOparentTree) (_patternsOpatternMatchWarnings))
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            ((_csetBinds@_,_assumptions@_)) =
                (_patternsIenvironment .===. _expressionIassumptions) _cinfoBind
            (_newcon@_) =
                [ (foldr (.->.) _expressionIbeta _patternsIbetas .==. _beta) _cinfoType ]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _newcon .>. _csetBinds .>>.
                Node [ Node _patternsIconstraintslist
                     , _expressionIconstraints
                     ]
            (_expressionOmonos@_) =
                M.elems _patternsIenvironment ++ getMonos _csetBinds ++ _lhsImonos
            (_patternsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfoBind@_) =
                \name -> variableConstraint "variable" (nameToUHA_Expr name)
                   [ FolkloreConstraint
                   , makeUnifier name "lambda abstraction" _patternsIenvironment _parentTree
                   ]
            (_cinfoType@_) =
                resultConstraint "lambda abstraction" _parentTree
                   [ FolkloreConstraint ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo (_patternsIinfoTrees ++ [_expressionIinfoTree])
            (_lhsOunboundNames@_) =
                _unboundNames
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _patternsIpatVarNames _expressionIunboundNames _lhsInamesInScope
            (_lhsOmatches@_) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in matchOnlyVariable infoTuple _lhsItryPatterns
            (_expressionOtryPatterns@_) =
                []
            (_lhsOpatternMatchWarnings@_) =
                patternMatchWarnings _lhsIimportEnvironment
                                     _lhsIsubstitution
                                     _beta
                                     (take (length _patternsIself) . fst . functionSpine)
                                     [(concat _patternsIelementss, False)]
                                     range_
                                     (Just $ Name_Special noRange [] "\\")
                                     True
                                     []
                                     "lambda expression"
                                     "->"
                ++ _expressionIpatternMatchWarnings
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_self@_) =
                Expression_Lambda _rangeIself _patternsIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _assumptions
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _expressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _expressionImatchIO
            (_lhsOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
            (_patternsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternsOmonos@_) =
                _lhsImonos
            (_patternsOnamesInScope@_) =
                _namesInScope
            (_patternsOparentTree@_) =
                _parentTree
            (_patternsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionObetaUnique@_) =
                _patternsIbetaUnique
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOnamesInScope@_) =
                _namesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _parentTree
            (_expressionOpatternMatchWarnings@_) =
                _patternsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Let :: (T_Range) ->
                      (T_Declarations) ->
                      (T_Expression) ->
                      (T_Expression)
sem_Expression_Let (range_) (declarations_) (expression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _declarationsIbetaUnique :: (Int)
            _declarationsIbindingGroups :: (BindingGroups)
            _declarationsIcollectErrors :: (TypeErrors)
            _declarationsIcollectInstances :: ([(Name, Instance)])
            _declarationsIcollectWarnings :: (Warnings)
            _declarationsIdeclVarNames :: (Names)
            _declarationsIdictionaryEnvironment :: (DictionaryEnvironment)
            _declarationsIinfoTrees :: (InfoTrees)
            _declarationsImatchIO :: (IO ())
            _declarationsIpatternMatchWarnings :: ([Warning])
            _declarationsIrestrictedNames :: (Names)
            _declarationsIself :: (Declarations)
            _declarationsIsimplePatNames :: (Names)
            _declarationsItypeSignatures :: (TypeEnvironment)
            _declarationsIunboundNames :: (Names)
            _declarationsIuniqueChunk :: (Int)
            _declarationsOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _declarationsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _declarationsOavailablePredicates :: (Predicates)
            _declarationsObetaUnique :: (Int)
            _declarationsObindingGroups :: (BindingGroups)
            _declarationsOclassEnvironment :: (ClassEnvironment)
            _declarationsOcollectErrors :: (TypeErrors)
            _declarationsOcollectWarnings :: (Warnings)
            _declarationsOcurrentChunk :: (Int)
            _declarationsOdictionaryEnvironment :: (DictionaryEnvironment)
            _declarationsOimportEnvironment :: (ImportEnvironment)
            _declarationsOinheritedBDG :: (InheritedBDG)
            _declarationsOmatchIO :: (IO ())
            _declarationsOmonos :: (Monos)
            _declarationsOnamesInScope :: (Names)
            _declarationsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _declarationsOparentTree :: (InfoTree)
            _declarationsOpatternMatchWarnings :: ([Warning])
            _declarationsOsubstitution :: (FixpointSubstitution)
            _declarationsOtypeSignatures :: (TypeEnvironment)
            _declarationsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _declarationsOuniqueChunk :: (Int)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _declarationsIbetaUnique
             ,_declarationsIbindingGroups
             ,_declarationsIcollectErrors
             ,_declarationsIcollectInstances
             ,_declarationsIcollectWarnings
             ,_declarationsIdeclVarNames
             ,_declarationsIdictionaryEnvironment
             ,_declarationsIinfoTrees
             ,_declarationsImatchIO
             ,_declarationsIpatternMatchWarnings
             ,_declarationsIrestrictedNames
             ,_declarationsIself
             ,_declarationsIsimplePatNames
             ,_declarationsItypeSignatures
             ,_declarationsIunboundNames
             ,_declarationsIuniqueChunk
             ) =
                (declarations_ (_declarationsOallPatterns)
                               (_declarationsOallTypeSchemes)
                               (_declarationsOavailablePredicates)
                               (_declarationsObetaUnique)
                               (_declarationsObindingGroups)
                               (_declarationsOclassEnvironment)
                               (_declarationsOcollectErrors)
                               (_declarationsOcollectWarnings)
                               (_declarationsOcurrentChunk)
                               (_declarationsOdictionaryEnvironment)
                               (_declarationsOimportEnvironment)
                               (_declarationsOinheritedBDG)
                               (_declarationsOmatchIO)
                               (_declarationsOmonos)
                               (_declarationsOnamesInScope)
                               (_declarationsOorderedTypeSynonyms)
                               (_declarationsOparentTree)
                               (_declarationsOpatternMatchWarnings)
                               (_declarationsOsubstitution)
                               (_declarationsOtypeSignatures)
                               (_declarationsOtypeschemeMap)
                               (_declarationsOuniqueChunk))
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            ((_assumptions@_,_cset@_,_inheritedBDG@_,_chunkNr@_,_lhsObetaUnique@_,_implicitsFM@_)) =
                let inputBDG   = (False, _lhsIcurrentChunk, _expressionIuniqueChunk, _lhsImonos, _declarationsItypeSignatures, mybdggroup, _expressionIbetaUnique)
                    mybdggroup = Just (_expressionIassumptions, [_expressionIconstraints])
                in performBindingGroup inputBDG _declarationsIbindingGroups
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                [ (_expressionIbeta .==. _beta) _cinfoType ] .>. _cset
            (_declarationsObindingGroups@_) =
                []
            (_declarationsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_lhsOcollectErrors@_) =
                restrictedNameErrors _inferredTypes _declarationsIrestrictedNames
                ++ _declarationsIcollectErrors
            (_lhsOcollectWarnings@_) =
                missingTypeSignature False _declarationsIsimplePatNames  _inferredTypes
                ++ _expressionIcollectWarnings
            (_inferredTypes@_) =
                findInferredTypes _lhsItypeschemeMap _implicitsFM
            (_localTypes@_) =
                makeLocalTypeEnv (_declarationsItypeSignatures `M.union` _inferredTypes) _declarationsIbindingGroups
            (_allTypeSchemes@_) =
                _localTypes `M.union` _lhsIallTypeSchemes
            (_declarationsOtypeSignatures@_) =
                M.empty
            (_lhsOuniqueChunk@_) =
                _chunkNr
            (_cinfoType@_) =
                resultConstraint "let expression (INTERNAL ERROR)" _thisTree
                   [ FolkloreConstraint, highlyTrusted ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_declInfo@_) =
                LocalInfo { self = UHA_Decls _declarationsIself
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_declarationsOparentTree@_) =
                _declTree
            (_expressionOparentTree@_) =
                _thisTree
            (_lhsOinfoTree@_) =
                _thisTree
            (_declTree@_) =
                node _thisTree _declInfo _declarationsIinfoTrees
            (_thisTree@_) =
                node _lhsIparentTree _localInfo [_declTree, _expressionIinfoTree]
            ((_collectTypeConstructors@_,_collectValueConstructors@_,_collectTypeSynonyms@_,_collectConstructorEnv@_,_derivedFunctions@_,_operatorFixities@_)) =
                internalError "PartialSyntax.ag" "n/a" "toplevel Expression"
            (_lhsOunboundNames@_) =
                _unboundNames
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _declarationsIdeclVarNames (_declarationsIunboundNames ++ _expressionIunboundNames) _lhsInamesInScope
            (_lhsOmatches@_) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in matchOnlyVariable infoTuple _lhsItryPatterns
            (_expressionOtryPatterns@_) =
                []
            (_lhsOcollectInstances@_) =
                _declarationsIcollectInstances  ++  _expressionIcollectInstances
            (_self@_) =
                Expression_Let _rangeIself _declarationsIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _assumptions
            (_lhsObeta@_) =
                _beta
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _expressionImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_lhsOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
            (_declarationsOallPatterns@_) =
                _lhsIallPatterns
            (_declarationsOallTypeSchemes@_) =
                _allTypeSchemes
            (_declarationsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_declarationsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_declarationsOcollectErrors@_) =
                _lhsIcollectErrors
            (_declarationsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_declarationsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_declarationsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_declarationsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_declarationsOinheritedBDG@_) =
                _inheritedBDG
            (_declarationsOmatchIO@_) =
                _lhsImatchIO
            (_declarationsOmonos@_) =
                _lhsImonos
            (_declarationsOnamesInScope@_) =
                _namesInScope
            (_declarationsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_declarationsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_declarationsOsubstitution@_) =
                _lhsIsubstitution
            (_declarationsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_declarationsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _allTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionObetaUnique@_) =
                _declarationsIbetaUnique
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _declarationsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _declarationsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _declarationsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _declarationsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOnamesInScope@_) =
                _namesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOpatternMatchWarnings@_) =
                _declarationsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _declarationsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_List :: (T_Range) ->
                       (T_Expressions) ->
                       (T_Expression)
sem_Expression_List (range_) (expressions_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _expressionsIassumptions :: (Assumptions)
            _expressionsIbetaUnique :: (Int)
            _expressionsIbetas :: (Tps)
            _expressionsIcollectErrors :: (TypeErrors)
            _expressionsIcollectInstances :: ([(Name, Instance)])
            _expressionsIcollectWarnings :: (Warnings)
            _expressionsIconstraintslist :: (ConstraintSets)
            _expressionsIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionsIinfoTrees :: (InfoTrees)
            _expressionsImatchIO :: (IO ())
            _expressionsImatches :: ([Maybe MetaVariableTable])
            _expressionsIpatternMatchWarnings :: ([Warning])
            _expressionsIself :: (Expressions)
            _expressionsIunboundNames :: (Names)
            _expressionsIuniqueChunk :: (Int)
            _expressionsIuniqueSecondRound :: (Int)
            _expressionsOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionsOavailablePredicates :: (Predicates)
            _expressionsObetaUnique :: (Int)
            _expressionsOclassEnvironment :: (ClassEnvironment)
            _expressionsOcollectErrors :: (TypeErrors)
            _expressionsOcollectWarnings :: (Warnings)
            _expressionsOcurrentChunk :: (Int)
            _expressionsOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionsOimportEnvironment :: (ImportEnvironment)
            _expressionsOmatchIO :: (IO ())
            _expressionsOmonos :: (Monos)
            _expressionsOnamesInScope :: (Names)
            _expressionsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionsOparentTree :: (InfoTree)
            _expressionsOpatternMatchWarnings :: ([Warning])
            _expressionsOsubstitution :: (FixpointSubstitution)
            _expressionsOtryPatterns :: ([(Expressions    , [String])])
            _expressionsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionsOuniqueChunk :: (Int)
            _expressionsOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionsIassumptions,_expressionsIbetaUnique,_expressionsIbetas,_expressionsIcollectErrors,_expressionsIcollectInstances,_expressionsIcollectWarnings,_expressionsIconstraintslist,_expressionsIdictionaryEnvironment,_expressionsIinfoTrees,_expressionsImatchIO,_expressionsImatches,_expressionsIpatternMatchWarnings,_expressionsIself,_expressionsIunboundNames,_expressionsIuniqueChunk,_expressionsIuniqueSecondRound) =
                (expressions_ (_expressionsOallPatterns)
                              (_expressionsOallTypeSchemes)
                              (_expressionsOavailablePredicates)
                              (_expressionsObetaUnique)
                              (_expressionsOclassEnvironment)
                              (_expressionsOcollectErrors)
                              (_expressionsOcollectWarnings)
                              (_expressionsOcurrentChunk)
                              (_expressionsOdictionaryEnvironment)
                              (_expressionsOimportEnvironment)
                              (_expressionsOmatchIO)
                              (_expressionsOmonos)
                              (_expressionsOnamesInScope)
                              (_expressionsOorderedTypeSynonyms)
                              (_expressionsOparentTree)
                              (_expressionsOpatternMatchWarnings)
                              (_expressionsOsubstitution)
                              (_expressionsOtryPatterns)
                              (_expressionsOtypeschemeMap)
                              (_expressionsOuniqueChunk)
                              (_expressionsOuniqueSecondRound))
            (_zipf@_) =
                \tp childNr ctree -> [ (tp .==. _beta') (_cinfoElem childNr) ] .<. ctree
            (_newcon@_) =
                [ (listType _beta' .==. _beta) _cinfoResult ]
            (_beta'@_) =
                TVar (_lhsIbetaUnique + 1)
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _newcon .>.
                 Node (zipWith3 _zipf _expressionsIbetas [0..] _expressionsIconstraintslist)
            (_expressionsObetaUnique@_) =
                _lhsIbetaUnique + 2
            (_cinfoElem@_) =
                \elemNr ->
                childConstraint elemNr "element of list" _parentTree $
                   [ HasTrustFactor 10.0 | length _expressionsIbetas < 2 ] ++
                   [ Unifier (head (ftv _beta')) ("list", _localInfo, ordinal False (elemNr+1) ++ " element") ]
            (_cinfoResult@_) =
                resultConstraint "list" _parentTree
                [ FolkloreConstraint ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo (_expressionsIinfoTrees)
            ((_expressionsOtryPatterns@_,_lhsOmatches@_,_lhsOconstraints@_,_lhsOassumptions@_,_lhsOuniqueSecondRound@_,_ioMatch@_)) =
                let infoTuple = metaVarInfo _constraints _expressionsIassumptions _localInfo
                in match1 infoTuple _expressionsIuniqueSecondRound
                          match_Expression_List
                          _lhsItryPatterns _lhsIallPatterns
                          [_expressionsImatches]
            (_lhsOmatchIO@_) =
                _expressionsImatchIO     >> _ioMatch
            (_lhsOcollectInstances@_) =
                _expressionsIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionsIunboundNames
            (_self@_) =
                Expression_List _rangeIself _expressionsIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _expressionsIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _expressionsIdictionaryEnvironment
            (_lhsOpatternMatchWarnings@_) =
                _expressionsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _expressionsIuniqueChunk
            (_expressionsOallPatterns@_) =
                _lhsIallPatterns
            (_expressionsOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionsOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionsOmatchIO@_) =
                _lhsImatchIO
            (_expressionsOmonos@_) =
                _lhsImonos
            (_expressionsOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionsOparentTree@_) =
                _parentTree
            (_expressionsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionsOsubstitution@_) =
                _lhsIsubstitution
            (_expressionsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Literal :: (T_Range) ->
                          (T_Literal) ->
                          (T_Expression)
sem_Expression_Literal (range_) (literal_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _literalIelements :: (  [PatternElement]        )
            _literalIliteralType :: (Tp)
            _literalIself :: (Literal)
            ( _rangeIself) =
                (range_ )
            ( _literalIelements,_literalIliteralType,_literalIself) =
                (literal_ )
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                unitTree ((_literalIliteralType .==. _beta) _cinfo)
            (_assumptions@_) =
                noAssumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfo@_) =
                resultConstraint "literal" _parentTree
                   [ FolkloreConstraint, HasTrustFactor 10.0 ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo []
            (((),_lhsOmatches@_,_lhsOconstraints@_,_lhsOassumptions@_,_lhsOuniqueSecondRound@_,_ioMatch@_)) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in match0 infoTuple _lhsIuniqueSecondRound
                          (match_Expression_Literal _literalIself)
                          _lhsItryPatterns _lhsIallPatterns
                          []
            (_lhsOmatchIO@_) =
                _lhsImatchIO             >> _ioMatch
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Expression_Literal _rangeIself _literalIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Negate :: (T_Range) ->
                         (T_Expression) ->
                         (T_Expression)
sem_Expression_Negate (range_) (expression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            (_newcon@_) =
                let standard = makeScheme [] [Predicate "Num" (TVar 0)] (TVar 0 .->. TVar 0)
                    tpscheme = M.findWithDefault standard (nameFromString "negate") (typeEnvironment _lhsIimportEnvironment)
                in [ (_expressionIbeta .->. _beta .::. tpscheme) _cinfo]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _newcon .>. Node [ _expressionIconstraints ]
            (_expressionObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_newDEnv@_) =
                resolveOverloading (_lhsIclassEnvironment)  _localName
                                   (_lhsIsubstitution |-> _lhsIavailablePredicates)
                                   (_lhsIsubstitution |-> _requiredDictionaries)
                                   _expressionIdictionaryEnvironment
            (_usedAsType@_) =
                _lhsIsubstitution |-> (_expressionIbeta .->. _beta)
            (_requiredDictionaries@_) =
                getRequiredDictionaries
                   (getOrderedTypeSynonyms _lhsIimportEnvironment)
                   (_lhsIsubstitution |-> _usedAsType)
                   (_lhsIsubstitution |-> _negateTypeScheme)
            (_negateTypeScheme@_) =
                case M.lookup _localName (typeEnvironment _lhsIimportEnvironment) of
                   Just scheme -> scheme
                   Nothing     -> internalError "TypeInferenceOverloading.ag" "n/a" "type of negate unknown"
            (_localName@_) =
                setNameRange intUnaryMinusName _rangeIself
            (_lhsOdictionaryEnvironment@_) =
                _newDEnv
            (_cinfo@_) =
                specialConstraint "negation" _parentTree
                   (self _localInfo, Just $ nameToUHA_Expr (Name_Operator range_ [] "-"))
                   []
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo [_expressionIinfoTree]
            ((_expressionOtryPatterns@_,_lhsOmatches@_,_lhsOconstraints@_,_lhsOassumptions@_,_lhsOuniqueSecondRound@_,_ioMatch@_)) =
                let infoTuple = metaVarInfo _constraints _expressionIassumptions _localInfo
                in match1 infoTuple _expressionIuniqueSecondRound
                          match_Expression_Negate
                          _lhsItryPatterns _lhsIallPatterns
                          [_expressionImatches]
            (_lhsOmatchIO@_) =
                _expressionImatchIO      >> _ioMatch
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                Expression_Negate _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _expressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_lhsOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _parentTree
            (_expressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_NegateFloat :: (T_Range) ->
                              (T_Expression) ->
                              (T_Expression)
sem_Expression_NegateFloat (range_) (expression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            (_newcon@_) =
                [ (floatType .->. floatType .==. _expressionIbeta .->. _beta) _cinfo]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _newcon .>. Node [ _expressionIconstraints ]
            (_expressionObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfo@_) =
                specialConstraint "negation" _parentTree
                   (self _localInfo, Just $ nameToUHA_Expr (Name_Operator range_ [] "-."))
                   []
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo [_expressionIinfoTree]
            ((_expressionOtryPatterns@_,_lhsOmatches@_,_lhsOconstraints@_,_lhsOassumptions@_,_lhsOuniqueSecondRound@_,_ioMatch@_)) =
                let infoTuple = metaVarInfo _constraints _expressionIassumptions _localInfo
                in match1 infoTuple _expressionIuniqueSecondRound
                          match_Expression_NegateFloat
                          _lhsItryPatterns _lhsIallPatterns
                          [_expressionImatches]
            (_lhsOmatchIO@_) =
                _expressionImatchIO      >> _ioMatch
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                Expression_NegateFloat _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _expressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_lhsOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _parentTree
            (_expressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_NormalApplication :: (T_Range) ->
                                    (T_Expression) ->
                                    (T_Expressions) ->
                                    (T_Expression)
sem_Expression_NormalApplication (range_) (function_) (arguments_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _functionIassumptions :: (Assumptions)
            _functionIbeta :: (Tp)
            _functionIbetaUnique :: (Int)
            _functionIcollectErrors :: (TypeErrors)
            _functionIcollectInstances :: ([(Name, Instance)])
            _functionIcollectWarnings :: (Warnings)
            _functionIconstraints :: (ConstraintSet)
            _functionIdictionaryEnvironment :: (DictionaryEnvironment)
            _functionIinfoTree :: (InfoTree)
            _functionImatchIO :: (IO ())
            _functionImatches :: ([Maybe MetaVariableTable])
            _functionIpatternMatchWarnings :: ([Warning])
            _functionIself :: (Expression)
            _functionIunboundNames :: (Names)
            _functionIuniqueChunk :: (Int)
            _functionIuniqueSecondRound :: (Int)
            _functionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _functionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _functionOavailablePredicates :: (Predicates)
            _functionObetaUnique :: (Int)
            _functionOclassEnvironment :: (ClassEnvironment)
            _functionOcollectErrors :: (TypeErrors)
            _functionOcollectWarnings :: (Warnings)
            _functionOcurrentChunk :: (Int)
            _functionOdictionaryEnvironment :: (DictionaryEnvironment)
            _functionOimportEnvironment :: (ImportEnvironment)
            _functionOmatchIO :: (IO ())
            _functionOmonos :: (Monos)
            _functionOnamesInScope :: (Names)
            _functionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _functionOparentTree :: (InfoTree)
            _functionOpatternMatchWarnings :: ([Warning])
            _functionOsubstitution :: (FixpointSubstitution)
            _functionOtryPatterns :: ([(Expression     , [String])])
            _functionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _functionOuniqueChunk :: (Int)
            _functionOuniqueSecondRound :: (Int)
            _argumentsIassumptions :: (Assumptions)
            _argumentsIbetaUnique :: (Int)
            _argumentsIbetas :: (Tps)
            _argumentsIcollectErrors :: (TypeErrors)
            _argumentsIcollectInstances :: ([(Name, Instance)])
            _argumentsIcollectWarnings :: (Warnings)
            _argumentsIconstraintslist :: (ConstraintSets)
            _argumentsIdictionaryEnvironment :: (DictionaryEnvironment)
            _argumentsIinfoTrees :: (InfoTrees)
            _argumentsImatchIO :: (IO ())
            _argumentsImatches :: ([Maybe MetaVariableTable])
            _argumentsIpatternMatchWarnings :: ([Warning])
            _argumentsIself :: (Expressions)
            _argumentsIunboundNames :: (Names)
            _argumentsIuniqueChunk :: (Int)
            _argumentsIuniqueSecondRound :: (Int)
            _argumentsOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _argumentsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _argumentsOavailablePredicates :: (Predicates)
            _argumentsObetaUnique :: (Int)
            _argumentsOclassEnvironment :: (ClassEnvironment)
            _argumentsOcollectErrors :: (TypeErrors)
            _argumentsOcollectWarnings :: (Warnings)
            _argumentsOcurrentChunk :: (Int)
            _argumentsOdictionaryEnvironment :: (DictionaryEnvironment)
            _argumentsOimportEnvironment :: (ImportEnvironment)
            _argumentsOmatchIO :: (IO ())
            _argumentsOmonos :: (Monos)
            _argumentsOnamesInScope :: (Names)
            _argumentsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _argumentsOparentTree :: (InfoTree)
            _argumentsOpatternMatchWarnings :: ([Warning])
            _argumentsOsubstitution :: (FixpointSubstitution)
            _argumentsOtryPatterns :: ([(Expressions    , [String])])
            _argumentsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _argumentsOuniqueChunk :: (Int)
            _argumentsOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _functionIassumptions,_functionIbeta,_functionIbetaUnique,_functionIcollectErrors,_functionIcollectInstances,_functionIcollectWarnings,_functionIconstraints,_functionIdictionaryEnvironment,_functionIinfoTree,_functionImatchIO,_functionImatches,_functionIpatternMatchWarnings,_functionIself,_functionIunboundNames,_functionIuniqueChunk,_functionIuniqueSecondRound) =
                (function_ (_functionOallPatterns)
                           (_functionOallTypeSchemes)
                           (_functionOavailablePredicates)
                           (_functionObetaUnique)
                           (_functionOclassEnvironment)
                           (_functionOcollectErrors)
                           (_functionOcollectWarnings)
                           (_functionOcurrentChunk)
                           (_functionOdictionaryEnvironment)
                           (_functionOimportEnvironment)
                           (_functionOmatchIO)
                           (_functionOmonos)
                           (_functionOnamesInScope)
                           (_functionOorderedTypeSynonyms)
                           (_functionOparentTree)
                           (_functionOpatternMatchWarnings)
                           (_functionOsubstitution)
                           (_functionOtryPatterns)
                           (_functionOtypeschemeMap)
                           (_functionOuniqueChunk)
                           (_functionOuniqueSecondRound))
            ( _argumentsIassumptions,_argumentsIbetaUnique,_argumentsIbetas,_argumentsIcollectErrors,_argumentsIcollectInstances,_argumentsIcollectWarnings,_argumentsIconstraintslist,_argumentsIdictionaryEnvironment,_argumentsIinfoTrees,_argumentsImatchIO,_argumentsImatches,_argumentsIpatternMatchWarnings,_argumentsIself,_argumentsIunboundNames,_argumentsIuniqueChunk,_argumentsIuniqueSecondRound) =
                (arguments_ (_argumentsOallPatterns)
                            (_argumentsOallTypeSchemes)
                            (_argumentsOavailablePredicates)
                            (_argumentsObetaUnique)
                            (_argumentsOclassEnvironment)
                            (_argumentsOcollectErrors)
                            (_argumentsOcollectWarnings)
                            (_argumentsOcurrentChunk)
                            (_argumentsOdictionaryEnvironment)
                            (_argumentsOimportEnvironment)
                            (_argumentsOmatchIO)
                            (_argumentsOmonos)
                            (_argumentsOnamesInScope)
                            (_argumentsOorderedTypeSynonyms)
                            (_argumentsOparentTree)
                            (_argumentsOpatternMatchWarnings)
                            (_argumentsOsubstitution)
                            (_argumentsOtryPatterns)
                            (_argumentsOtypeschemeMap)
                            (_argumentsOuniqueChunk)
                            (_argumentsOuniqueSecondRound))
            (_newcon@_) =
                [ (_functionIbeta .==. foldr (.->.) _beta _argumentsIbetas) _cinfo ]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _newcon .>.
                Node [ _functionIconstraints
                     , Node _argumentsIconstraintslist
                     ]
            (_assumptions@_) =
                _functionIassumptions `combine` _argumentsIassumptions
            (_functionObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfo@_) =
                childConstraint 0 "application" _parentTree
                   [ ApplicationEdge False (map attribute _argumentsIinfoTrees) ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo (_functionIinfoTree : _argumentsIinfoTrees)
            (((_functionOtryPatterns@_,_argumentsOtryPatterns@_),_lhsOmatches@_,_lhsOconstraints@_,_lhsOassumptions@_,_lhsOuniqueSecondRound@_,_ioMatch@_)) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in match2 infoTuple _argumentsIuniqueSecondRound
                          match_Expression_NormalApplication
                          _lhsItryPatterns _lhsIallPatterns
                          [_functionImatches, _argumentsImatches]
            (_lhsOmatchIO@_) =
                _argumentsImatchIO       >> _ioMatch
            (_lhsOcollectInstances@_) =
                _functionIcollectInstances  ++  _argumentsIcollectInstances
            (_lhsOunboundNames@_) =
                _functionIunboundNames ++ _argumentsIunboundNames
            (_self@_) =
                Expression_NormalApplication _rangeIself _functionIself _argumentsIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _argumentsIbetaUnique
            (_lhsOcollectErrors@_) =
                _argumentsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _argumentsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _argumentsIdictionaryEnvironment
            (_lhsOpatternMatchWarnings@_) =
                _argumentsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _argumentsIuniqueChunk
            (_functionOallPatterns@_) =
                _lhsIallPatterns
            (_functionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_functionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_functionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_functionOcollectErrors@_) =
                _lhsIcollectErrors
            (_functionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_functionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_functionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_functionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_functionOmatchIO@_) =
                _lhsImatchIO
            (_functionOmonos@_) =
                _lhsImonos
            (_functionOnamesInScope@_) =
                _lhsInamesInScope
            (_functionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_functionOparentTree@_) =
                _parentTree
            (_functionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_functionOsubstitution@_) =
                _lhsIsubstitution
            (_functionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_functionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_functionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_argumentsOallPatterns@_) =
                _lhsIallPatterns
            (_argumentsOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_argumentsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_argumentsObetaUnique@_) =
                _functionIbetaUnique
            (_argumentsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_argumentsOcollectErrors@_) =
                _functionIcollectErrors
            (_argumentsOcollectWarnings@_) =
                _functionIcollectWarnings
            (_argumentsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_argumentsOdictionaryEnvironment@_) =
                _functionIdictionaryEnvironment
            (_argumentsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_argumentsOmatchIO@_) =
                _functionImatchIO
            (_argumentsOmonos@_) =
                _lhsImonos
            (_argumentsOnamesInScope@_) =
                _lhsInamesInScope
            (_argumentsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_argumentsOparentTree@_) =
                _parentTree
            (_argumentsOpatternMatchWarnings@_) =
                _functionIpatternMatchWarnings
            (_argumentsOsubstitution@_) =
                _lhsIsubstitution
            (_argumentsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_argumentsOuniqueChunk@_) =
                _functionIuniqueChunk
            (_argumentsOuniqueSecondRound@_) =
                _functionIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Parenthesized :: (T_Range) ->
                                (T_Expression) ->
                                (T_Expression)
sem_Expression_Parenthesized (range_) (expression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                Expression_Parenthesized _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _expressionIassumptions
            (_lhsObeta@_) =
                _expressionIbeta
            (_lhsObetaUnique@_) =
                _expressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_lhsOconstraints@_) =
                _expressionIconstraints
            (_lhsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_lhsOinfoTree@_) =
                _expressionIinfoTree
            (_lhsOmatchIO@_) =
                _expressionImatchIO
            (_lhsOmatches@_) =
                _expressionImatches
            (_lhsOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionObetaUnique@_) =
                _lhsIbetaUnique
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _lhsIparentTree
            (_expressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtryPatterns@_) =
                _lhsItryPatterns
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_RecordConstruction :: (T_Range) ->
                                     (T_Name) ->
                                     (T_RecordExpressionBindings) ->
                                     (T_Expression)
sem_Expression_RecordConstruction (range_) (name_) (recordExpressionBindings_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _recordExpressionBindingsIcollectErrors :: (TypeErrors)
            _recordExpressionBindingsIcollectInstances :: ([(Name, Instance)])
            _recordExpressionBindingsIcollectWarnings :: (Warnings)
            _recordExpressionBindingsIdictionaryEnvironment :: (DictionaryEnvironment)
            _recordExpressionBindingsIpatternMatchWarnings :: ([Warning])
            _recordExpressionBindingsIself :: (RecordExpressionBindings)
            _recordExpressionBindingsIunboundNames :: (Names)
            _recordExpressionBindingsIuniqueChunk :: (Int)
            _recordExpressionBindingsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _recordExpressionBindingsOavailablePredicates :: (Predicates)
            _recordExpressionBindingsOclassEnvironment :: (ClassEnvironment)
            _recordExpressionBindingsOcollectErrors :: (TypeErrors)
            _recordExpressionBindingsOcollectWarnings :: (Warnings)
            _recordExpressionBindingsOcurrentChunk :: (Int)
            _recordExpressionBindingsOdictionaryEnvironment :: (DictionaryEnvironment)
            _recordExpressionBindingsOimportEnvironment :: (ImportEnvironment)
            _recordExpressionBindingsOnamesInScope :: (Names)
            _recordExpressionBindingsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _recordExpressionBindingsOpatternMatchWarnings :: ([Warning])
            _recordExpressionBindingsOsubstitution :: (FixpointSubstitution)
            _recordExpressionBindingsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _recordExpressionBindingsOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _recordExpressionBindingsIcollectErrors,_recordExpressionBindingsIcollectInstances,_recordExpressionBindingsIcollectWarnings,_recordExpressionBindingsIdictionaryEnvironment,_recordExpressionBindingsIpatternMatchWarnings,_recordExpressionBindingsIself,_recordExpressionBindingsIunboundNames,_recordExpressionBindingsIuniqueChunk) =
                (recordExpressionBindings_ (_recordExpressionBindingsOallTypeSchemes)
                                           (_recordExpressionBindingsOavailablePredicates)
                                           (_recordExpressionBindingsOclassEnvironment)
                                           (_recordExpressionBindingsOcollectErrors)
                                           (_recordExpressionBindingsOcollectWarnings)
                                           (_recordExpressionBindingsOcurrentChunk)
                                           (_recordExpressionBindingsOdictionaryEnvironment)
                                           (_recordExpressionBindingsOimportEnvironment)
                                           (_recordExpressionBindingsOnamesInScope)
                                           (_recordExpressionBindingsOorderedTypeSynonyms)
                                           (_recordExpressionBindingsOpatternMatchWarnings)
                                           (_recordExpressionBindingsOsubstitution)
                                           (_recordExpressionBindingsOtypeschemeMap)
                                           (_recordExpressionBindingsOuniqueChunk))
            (_infoTree@_) =
                globalInfoError
            ((_assumptions@_,_constraints@_,_beta@_)) =
                internalError "PartialSyntax.ag" "n/a" "Expression.RecordConstruction"
            (_matches@_) =
                internalError "TS_PatternMatching.ag" "n/a" "RecordConstruction is not supported"
            (_lhsOcollectInstances@_) =
                _recordExpressionBindingsIcollectInstances
            (_lhsOunboundNames@_) =
                _recordExpressionBindingsIunboundNames
            (_self@_) =
                Expression_RecordConstruction _rangeIself _nameIself _recordExpressionBindingsIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _assumptions
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOcollectErrors@_) =
                _recordExpressionBindingsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _recordExpressionBindingsIcollectWarnings
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOdictionaryEnvironment@_) =
                _recordExpressionBindingsIdictionaryEnvironment
            (_lhsOinfoTree@_) =
                _infoTree
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOmatches@_) =
                _matches
            (_lhsOpatternMatchWarnings@_) =
                _recordExpressionBindingsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _recordExpressionBindingsIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_recordExpressionBindingsOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_recordExpressionBindingsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_recordExpressionBindingsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_recordExpressionBindingsOcollectErrors@_) =
                _lhsIcollectErrors
            (_recordExpressionBindingsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_recordExpressionBindingsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_recordExpressionBindingsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_recordExpressionBindingsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_recordExpressionBindingsOnamesInScope@_) =
                _lhsInamesInScope
            (_recordExpressionBindingsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_recordExpressionBindingsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_recordExpressionBindingsOsubstitution@_) =
                _lhsIsubstitution
            (_recordExpressionBindingsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_recordExpressionBindingsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_RecordUpdate :: (T_Range) ->
                               (T_Expression) ->
                               (T_RecordExpressionBindings) ->
                               (T_Expression)
sem_Expression_RecordUpdate (range_) (expression_) (recordExpressionBindings_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            _recordExpressionBindingsIcollectErrors :: (TypeErrors)
            _recordExpressionBindingsIcollectInstances :: ([(Name, Instance)])
            _recordExpressionBindingsIcollectWarnings :: (Warnings)
            _recordExpressionBindingsIdictionaryEnvironment :: (DictionaryEnvironment)
            _recordExpressionBindingsIpatternMatchWarnings :: ([Warning])
            _recordExpressionBindingsIself :: (RecordExpressionBindings)
            _recordExpressionBindingsIunboundNames :: (Names)
            _recordExpressionBindingsIuniqueChunk :: (Int)
            _recordExpressionBindingsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _recordExpressionBindingsOavailablePredicates :: (Predicates)
            _recordExpressionBindingsOclassEnvironment :: (ClassEnvironment)
            _recordExpressionBindingsOcollectErrors :: (TypeErrors)
            _recordExpressionBindingsOcollectWarnings :: (Warnings)
            _recordExpressionBindingsOcurrentChunk :: (Int)
            _recordExpressionBindingsOdictionaryEnvironment :: (DictionaryEnvironment)
            _recordExpressionBindingsOimportEnvironment :: (ImportEnvironment)
            _recordExpressionBindingsOnamesInScope :: (Names)
            _recordExpressionBindingsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _recordExpressionBindingsOpatternMatchWarnings :: ([Warning])
            _recordExpressionBindingsOsubstitution :: (FixpointSubstitution)
            _recordExpressionBindingsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _recordExpressionBindingsOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            ( _recordExpressionBindingsIcollectErrors,_recordExpressionBindingsIcollectInstances,_recordExpressionBindingsIcollectWarnings,_recordExpressionBindingsIdictionaryEnvironment,_recordExpressionBindingsIpatternMatchWarnings,_recordExpressionBindingsIself,_recordExpressionBindingsIunboundNames,_recordExpressionBindingsIuniqueChunk) =
                (recordExpressionBindings_ (_recordExpressionBindingsOallTypeSchemes)
                                           (_recordExpressionBindingsOavailablePredicates)
                                           (_recordExpressionBindingsOclassEnvironment)
                                           (_recordExpressionBindingsOcollectErrors)
                                           (_recordExpressionBindingsOcollectWarnings)
                                           (_recordExpressionBindingsOcurrentChunk)
                                           (_recordExpressionBindingsOdictionaryEnvironment)
                                           (_recordExpressionBindingsOimportEnvironment)
                                           (_recordExpressionBindingsOnamesInScope)
                                           (_recordExpressionBindingsOorderedTypeSynonyms)
                                           (_recordExpressionBindingsOpatternMatchWarnings)
                                           (_recordExpressionBindingsOsubstitution)
                                           (_recordExpressionBindingsOtypeschemeMap)
                                           (_recordExpressionBindingsOuniqueChunk))
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances  ++  _recordExpressionBindingsIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames ++ _recordExpressionBindingsIunboundNames
            (_self@_) =
                Expression_RecordUpdate _rangeIself _expressionIself _recordExpressionBindingsIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _expressionIassumptions
            (_lhsObeta@_) =
                _expressionIbeta
            (_lhsObetaUnique@_) =
                _expressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _recordExpressionBindingsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _recordExpressionBindingsIcollectWarnings
            (_lhsOconstraints@_) =
                _expressionIconstraints
            (_lhsOdictionaryEnvironment@_) =
                _recordExpressionBindingsIdictionaryEnvironment
            (_lhsOinfoTree@_) =
                _expressionIinfoTree
            (_lhsOmatchIO@_) =
                _expressionImatchIO
            (_lhsOmatches@_) =
                _expressionImatches
            (_lhsOpatternMatchWarnings@_) =
                _recordExpressionBindingsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _recordExpressionBindingsIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionObetaUnique@_) =
                _lhsIbetaUnique
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _lhsIparentTree
            (_expressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtryPatterns@_) =
                _lhsItryPatterns
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_recordExpressionBindingsOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_recordExpressionBindingsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_recordExpressionBindingsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_recordExpressionBindingsOcollectErrors@_) =
                _expressionIcollectErrors
            (_recordExpressionBindingsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_recordExpressionBindingsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_recordExpressionBindingsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_recordExpressionBindingsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_recordExpressionBindingsOnamesInScope@_) =
                _lhsInamesInScope
            (_recordExpressionBindingsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_recordExpressionBindingsOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_recordExpressionBindingsOsubstitution@_) =
                _lhsIsubstitution
            (_recordExpressionBindingsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_recordExpressionBindingsOuniqueChunk@_) =
                _expressionIuniqueChunk
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Tuple :: (T_Range) ->
                        (T_Expressions) ->
                        (T_Expression)
sem_Expression_Tuple (range_) (expressions_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _expressionsIassumptions :: (Assumptions)
            _expressionsIbetaUnique :: (Int)
            _expressionsIbetas :: (Tps)
            _expressionsIcollectErrors :: (TypeErrors)
            _expressionsIcollectInstances :: ([(Name, Instance)])
            _expressionsIcollectWarnings :: (Warnings)
            _expressionsIconstraintslist :: (ConstraintSets)
            _expressionsIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionsIinfoTrees :: (InfoTrees)
            _expressionsImatchIO :: (IO ())
            _expressionsImatches :: ([Maybe MetaVariableTable])
            _expressionsIpatternMatchWarnings :: ([Warning])
            _expressionsIself :: (Expressions)
            _expressionsIunboundNames :: (Names)
            _expressionsIuniqueChunk :: (Int)
            _expressionsIuniqueSecondRound :: (Int)
            _expressionsOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionsOavailablePredicates :: (Predicates)
            _expressionsObetaUnique :: (Int)
            _expressionsOclassEnvironment :: (ClassEnvironment)
            _expressionsOcollectErrors :: (TypeErrors)
            _expressionsOcollectWarnings :: (Warnings)
            _expressionsOcurrentChunk :: (Int)
            _expressionsOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionsOimportEnvironment :: (ImportEnvironment)
            _expressionsOmatchIO :: (IO ())
            _expressionsOmonos :: (Monos)
            _expressionsOnamesInScope :: (Names)
            _expressionsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionsOparentTree :: (InfoTree)
            _expressionsOpatternMatchWarnings :: ([Warning])
            _expressionsOsubstitution :: (FixpointSubstitution)
            _expressionsOtryPatterns :: ([(Expressions    , [String])])
            _expressionsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionsOuniqueChunk :: (Int)
            _expressionsOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionsIassumptions,_expressionsIbetaUnique,_expressionsIbetas,_expressionsIcollectErrors,_expressionsIcollectInstances,_expressionsIcollectWarnings,_expressionsIconstraintslist,_expressionsIdictionaryEnvironment,_expressionsIinfoTrees,_expressionsImatchIO,_expressionsImatches,_expressionsIpatternMatchWarnings,_expressionsIself,_expressionsIunboundNames,_expressionsIuniqueChunk,_expressionsIuniqueSecondRound) =
                (expressions_ (_expressionsOallPatterns)
                              (_expressionsOallTypeSchemes)
                              (_expressionsOavailablePredicates)
                              (_expressionsObetaUnique)
                              (_expressionsOclassEnvironment)
                              (_expressionsOcollectErrors)
                              (_expressionsOcollectWarnings)
                              (_expressionsOcurrentChunk)
                              (_expressionsOdictionaryEnvironment)
                              (_expressionsOimportEnvironment)
                              (_expressionsOmatchIO)
                              (_expressionsOmonos)
                              (_expressionsOnamesInScope)
                              (_expressionsOorderedTypeSynonyms)
                              (_expressionsOparentTree)
                              (_expressionsOpatternMatchWarnings)
                              (_expressionsOsubstitution)
                              (_expressionsOtryPatterns)
                              (_expressionsOtypeschemeMap)
                              (_expressionsOuniqueChunk)
                              (_expressionsOuniqueSecondRound))
            (_newcon@_) =
                [ (tupleType _expressionsIbetas .==. _beta) _cinfo ]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _newcon .>. Node _expressionsIconstraintslist
            (_expressionsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfo@_) =
                resultConstraint "tuple" _parentTree
                   [ FolkloreConstraint ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo (_expressionsIinfoTrees)
            ((_expressionsOtryPatterns@_,_lhsOmatches@_,_lhsOconstraints@_,_lhsOassumptions@_,_lhsOuniqueSecondRound@_,_ioMatch@_)) =
                let infoTuple = metaVarInfo _constraints _expressionsIassumptions _localInfo
                in match1 infoTuple _expressionsIuniqueSecondRound
                          match_Expression_Tuple
                          _lhsItryPatterns _lhsIallPatterns
                          [_expressionsImatches]
            (_lhsOmatchIO@_) =
                _expressionsImatchIO     >> _ioMatch
            (_lhsOcollectInstances@_) =
                _expressionsIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionsIunboundNames
            (_self@_) =
                Expression_Tuple _rangeIself _expressionsIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _expressionsIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _expressionsIdictionaryEnvironment
            (_lhsOpatternMatchWarnings@_) =
                _expressionsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _expressionsIuniqueChunk
            (_expressionsOallPatterns@_) =
                _lhsIallPatterns
            (_expressionsOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionsOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionsOmatchIO@_) =
                _lhsImatchIO
            (_expressionsOmonos@_) =
                _lhsImonos
            (_expressionsOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionsOparentTree@_) =
                _parentTree
            (_expressionsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionsOsubstitution@_) =
                _lhsIsubstitution
            (_expressionsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Typed :: (T_Range) ->
                        (T_Expression) ->
                        (T_Type) ->
                        (T_Expression)
sem_Expression_Typed (range_) (expression_) (type_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            _typeIself :: (Type)
            ( _rangeIself) =
                (range_ )
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            ( _typeIself) =
                (type_ )
            (_conExpr@_) =
                [ (_expressionIbeta !::! _typeScheme) _lhsImonos _cinfoExpr ]
            (_conResult@_) =
                [ (_beta            .::. _typeScheme) _cinfoResult          ]
            (_typeScheme@_) =
                makeTpSchemeFromType _typeIself
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _conResult .>.
                Node [ _conExpr .<. _expressionIconstraints ]
            (_assumptions@_) =
                _expressionIassumptions
            (_expressionObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfoExpr@_) =
                childConstraint 0 "type annotation" _parentTree
                   [ TypeSignatureLocation (getTypeRange _typeIself) ]
            (_cinfoResult@_) =
                resultConstraint "type annotation" _parentTree
                   [ FolkloreConstraint ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo [_expressionIinfoTree]
            (_lhsOmatches@_) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in matchOnlyVariable infoTuple _lhsItryPatterns
            (_expressionOtryPatterns@_) =
                []
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                Expression_Typed _rangeIself _expressionIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _assumptions
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _expressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _expressionImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _parentTree
            (_expressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expression_Variable :: (T_Range) ->
                           (T_Name) ->
                           (T_Expression)
sem_Expression_Variable (range_) (name_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                Node [ Receive _lhsIbetaUnique ]
            (_assumptions@_) =
                _nameIself `single` _beta
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_usedAsType@_) =
                _lhsIsubstitution |-> _beta
            (_newDEnv@_) =
                resolveOverloading (_lhsIclassEnvironment)
                                   _nameIself
                                   (_lhsIsubstitution |-> _lhsIavailablePredicates)
                                   (_lhsIsubstitution |-> _requiredDictionaries)
                                   _lhsIdictionaryEnvironment
            (_requiredDictionaries@_) =
                case _maybeInferredType of
                   Nothing     -> []
                   Just scheme -> getRequiredDictionaries
                                     (getOrderedTypeSynonyms _lhsIimportEnvironment)
                                     (_lhsIsubstitution |-> _usedAsType)
                                     (_lhsIsubstitution |-> scheme)
            (_maybeInferredType@_) =
                M.lookup _nameInScope _lhsIallTypeSchemes
            (_nameInScope@_) =
                case filter (_nameIself==) _lhsInamesInScope of
                   [name] -> NameWithRange name
                   _      -> internalError "TypeInferenceOverloading.ag" "n/a" "name not in scope"
            (_lhsOdictionaryEnvironment@_) =
                _newDEnv
            (_localInfo@_) =
                LocalInfo { self = UHA_Expr _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo []
            (_lhsOunboundNames@_) =
                [ _nameIself ]
            (((),_lhsOmatches@_,_lhsOconstraints@_,_lhsOassumptions@_,_lhsOuniqueSecondRound@_,_ioMatch@_)) =
                let infoTuple = metaVarInfo _constraints _assumptions _localInfo
                in match0 infoTuple _lhsIuniqueSecondRound
                          (match_Expression_Variable _nameIself)
                          _lhsItryPatterns _lhsIallPatterns
                          []
            (_lhsOmatchIO@_) =
                _lhsImatchIO             >> _ioMatch
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                Expression_Variable _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
-- Expressions -------------------------------------------------
-- semantic domain
type T_Expressions = ([((Expression, [String]), Core_TypingStrategy)]) ->
                     (M.Map NameWithRange TpScheme) ->
                     (Predicates) ->
                     (Int) ->
                     (ClassEnvironment) ->
                     (TypeErrors) ->
                     (Warnings) ->
                     (Int) ->
                     (DictionaryEnvironment) ->
                     (ImportEnvironment) ->
                     (IO ()) ->
                     (Monos) ->
                     (Names) ->
                     (OrderedTypeSynonyms) ->
                     (InfoTree) ->
                     ([Warning]) ->
                     (FixpointSubstitution) ->
                     ([(Expressions    , [String])]) ->
                     (M.Map Int (Scheme Predicates)) ->
                     (Int) ->
                     (Int) ->
                     ( (Assumptions),(Int),(Tps),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSets),(DictionaryEnvironment),(InfoTrees),(IO ()),([Maybe MetaVariableTable]),([Warning]),(Expressions),(Names),(Int),(Int))
-- cata
sem_Expressions :: (Expressions) ->
                   (T_Expressions)
sem_Expressions (list) =
    (Prelude.foldr (sem_Expressions_Cons) (sem_Expressions_Nil) ((Prelude.map sem_Expression list)))
sem_Expressions_Cons :: (T_Expression) ->
                        (T_Expressions) ->
                        (T_Expressions)
sem_Expressions_Cons (hd_) (tl_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsObetas :: (Tps)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraintslist :: (ConstraintSets)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expressions)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _hdIassumptions :: (Assumptions)
            _hdIbeta :: (Tp)
            _hdIbetaUnique :: (Int)
            _hdIcollectErrors :: (TypeErrors)
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectWarnings :: (Warnings)
            _hdIconstraints :: (ConstraintSet)
            _hdIdictionaryEnvironment :: (DictionaryEnvironment)
            _hdIinfoTree :: (InfoTree)
            _hdImatchIO :: (IO ())
            _hdImatches :: ([Maybe MetaVariableTable])
            _hdIpatternMatchWarnings :: ([Warning])
            _hdIself :: (Expression)
            _hdIunboundNames :: (Names)
            _hdIuniqueChunk :: (Int)
            _hdIuniqueSecondRound :: (Int)
            _hdOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _hdOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _hdOavailablePredicates :: (Predicates)
            _hdObetaUnique :: (Int)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectErrors :: (TypeErrors)
            _hdOcollectWarnings :: (Warnings)
            _hdOcurrentChunk :: (Int)
            _hdOdictionaryEnvironment :: (DictionaryEnvironment)
            _hdOimportEnvironment :: (ImportEnvironment)
            _hdOmatchIO :: (IO ())
            _hdOmonos :: (Monos)
            _hdOnamesInScope :: (Names)
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOparentTree :: (InfoTree)
            _hdOpatternMatchWarnings :: ([Warning])
            _hdOsubstitution :: (FixpointSubstitution)
            _hdOtryPatterns :: ([(Expression     , [String])])
            _hdOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _hdOuniqueChunk :: (Int)
            _hdOuniqueSecondRound :: (Int)
            _tlIassumptions :: (Assumptions)
            _tlIbetaUnique :: (Int)
            _tlIbetas :: (Tps)
            _tlIcollectErrors :: (TypeErrors)
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectWarnings :: (Warnings)
            _tlIconstraintslist :: (ConstraintSets)
            _tlIdictionaryEnvironment :: (DictionaryEnvironment)
            _tlIinfoTrees :: (InfoTrees)
            _tlImatchIO :: (IO ())
            _tlImatches :: ([Maybe MetaVariableTable])
            _tlIpatternMatchWarnings :: ([Warning])
            _tlIself :: (Expressions)
            _tlIunboundNames :: (Names)
            _tlIuniqueChunk :: (Int)
            _tlIuniqueSecondRound :: (Int)
            _tlOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _tlOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _tlOavailablePredicates :: (Predicates)
            _tlObetaUnique :: (Int)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectErrors :: (TypeErrors)
            _tlOcollectWarnings :: (Warnings)
            _tlOcurrentChunk :: (Int)
            _tlOdictionaryEnvironment :: (DictionaryEnvironment)
            _tlOimportEnvironment :: (ImportEnvironment)
            _tlOmatchIO :: (IO ())
            _tlOmonos :: (Monos)
            _tlOnamesInScope :: (Names)
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOparentTree :: (InfoTree)
            _tlOpatternMatchWarnings :: ([Warning])
            _tlOsubstitution :: (FixpointSubstitution)
            _tlOtryPatterns :: ([(Expressions    , [String])])
            _tlOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _tlOuniqueChunk :: (Int)
            _tlOuniqueSecondRound :: (Int)
            ( _hdIassumptions,_hdIbeta,_hdIbetaUnique,_hdIcollectErrors,_hdIcollectInstances,_hdIcollectWarnings,_hdIconstraints,_hdIdictionaryEnvironment,_hdIinfoTree,_hdImatchIO,_hdImatches,_hdIpatternMatchWarnings,_hdIself,_hdIunboundNames,_hdIuniqueChunk,_hdIuniqueSecondRound) =
                (hd_ (_hdOallPatterns)
                     (_hdOallTypeSchemes)
                     (_hdOavailablePredicates)
                     (_hdObetaUnique)
                     (_hdOclassEnvironment)
                     (_hdOcollectErrors)
                     (_hdOcollectWarnings)
                     (_hdOcurrentChunk)
                     (_hdOdictionaryEnvironment)
                     (_hdOimportEnvironment)
                     (_hdOmatchIO)
                     (_hdOmonos)
                     (_hdOnamesInScope)
                     (_hdOorderedTypeSynonyms)
                     (_hdOparentTree)
                     (_hdOpatternMatchWarnings)
                     (_hdOsubstitution)
                     (_hdOtryPatterns)
                     (_hdOtypeschemeMap)
                     (_hdOuniqueChunk)
                     (_hdOuniqueSecondRound))
            ( _tlIassumptions,_tlIbetaUnique,_tlIbetas,_tlIcollectErrors,_tlIcollectInstances,_tlIcollectWarnings,_tlIconstraintslist,_tlIdictionaryEnvironment,_tlIinfoTrees,_tlImatchIO,_tlImatches,_tlIpatternMatchWarnings,_tlIself,_tlIunboundNames,_tlIuniqueChunk,_tlIuniqueSecondRound) =
                (tl_ (_tlOallPatterns)
                     (_tlOallTypeSchemes)
                     (_tlOavailablePredicates)
                     (_tlObetaUnique)
                     (_tlOclassEnvironment)
                     (_tlOcollectErrors)
                     (_tlOcollectWarnings)
                     (_tlOcurrentChunk)
                     (_tlOdictionaryEnvironment)
                     (_tlOimportEnvironment)
                     (_tlOmatchIO)
                     (_tlOmonos)
                     (_tlOnamesInScope)
                     (_tlOorderedTypeSynonyms)
                     (_tlOparentTree)
                     (_tlOpatternMatchWarnings)
                     (_tlOsubstitution)
                     (_tlOtryPatterns)
                     (_tlOtypeschemeMap)
                     (_tlOuniqueChunk)
                     (_tlOuniqueSecondRound))
            (_lhsOconstraintslist@_) =
                _hdIconstraints : _tlIconstraintslist
            (_lhsOassumptions@_) =
                _hdIassumptions `combine` _tlIassumptions
            (_lhsObetas@_) =
                _hdIbeta : _tlIbetas
            (_lhsOinfoTrees@_) =
                _hdIinfoTree : _tlIinfoTrees
            (((_hdOtryPatterns@_,_tlOtryPatterns@_),_lhsOmatches@_,_,_,_,_)) =
                match2' match_Expressions_Cons _lhsItryPatterns [] [_hdImatches, _tlImatches]
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _tlIbetaUnique
            (_lhsOcollectErrors@_) =
                _tlIcollectErrors
            (_lhsOcollectWarnings@_) =
                _tlIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _tlIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _tlImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _tlIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _tlIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _tlIuniqueSecondRound
            (_hdOallPatterns@_) =
                _lhsIallPatterns
            (_hdOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_hdOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_hdObetaUnique@_) =
                _lhsIbetaUnique
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectErrors@_) =
                _lhsIcollectErrors
            (_hdOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_hdOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_hdOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_hdOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_hdOmatchIO@_) =
                _lhsImatchIO
            (_hdOmonos@_) =
                _lhsImonos
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOparentTree@_) =
                _lhsIparentTree
            (_hdOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_hdOsubstitution@_) =
                _lhsIsubstitution
            (_hdOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_hdOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_hdOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_tlOallPatterns@_) =
                _lhsIallPatterns
            (_tlOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_tlOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_tlObetaUnique@_) =
                _hdIbetaUnique
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectErrors@_) =
                _hdIcollectErrors
            (_tlOcollectWarnings@_) =
                _hdIcollectWarnings
            (_tlOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_tlOdictionaryEnvironment@_) =
                _hdIdictionaryEnvironment
            (_tlOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_tlOmatchIO@_) =
                _hdImatchIO
            (_tlOmonos@_) =
                _lhsImonos
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOparentTree@_) =
                _lhsIparentTree
            (_tlOpatternMatchWarnings@_) =
                _hdIpatternMatchWarnings
            (_tlOsubstitution@_) =
                _lhsIsubstitution
            (_tlOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_tlOuniqueChunk@_) =
                _hdIuniqueChunk
            (_tlOuniqueSecondRound@_) =
                _hdIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsObetas,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraintslist,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Expressions_Nil :: (T_Expressions)
sem_Expressions_Nil  =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsObetas :: (Tps)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraintslist :: (ConstraintSets)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Expressions)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            (_lhsOconstraintslist@_) =
                []
            (_lhsOassumptions@_) =
                noAssumptions
            (_lhsObetas@_) =
                []
            (_lhsOinfoTrees@_) =
                []
            (((),_lhsOmatches@_,_,_,_,_)) =
                match0' match_Expressions_Nil _lhsItryPatterns [] []
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsObetas,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraintslist,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
-- FieldDeclaration --------------------------------------------
-- semantic domain
type T_FieldDeclaration = (Names) ->
                          ( (FieldDeclaration),(Names))
-- cata
sem_FieldDeclaration :: (FieldDeclaration) ->
                        (T_FieldDeclaration)
sem_FieldDeclaration ((FieldDeclaration_FieldDeclaration (_range) (_names) (_type))) =
    (sem_FieldDeclaration_FieldDeclaration ((sem_Range (_range))) ((sem_Names (_names))) ((sem_AnnotatedType (_type))))
sem_FieldDeclaration_FieldDeclaration :: (T_Range) ->
                                         (T_Names) ->
                                         (T_AnnotatedType) ->
                                         (T_FieldDeclaration)
sem_FieldDeclaration_FieldDeclaration (range_) (names_) (type_) =
    \ _lhsInamesInScope ->
        let _lhsOself :: (FieldDeclaration)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _namesIself :: (Names)
            _typeIself :: (AnnotatedType)
            _typeIunboundNames :: (Names)
            _typeOnamesInScope :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _namesIself) =
                (names_ )
            ( _typeIself,_typeIunboundNames) =
                (type_ (_typeOnamesInScope))
            ((_kindErrors@_,_tyconEnv@_,_constructorenv@_,_importEnvironment@_,_valueConstructors@_,_allValueConstructors@_,_typeConstructors@_,_allTypeConstructors@_,_warnings@_)) =
                internalError "PartialSyntax.ag" "n/a" "FieldDeclaration.FieldDeclaration"
            (_lhsOunboundNames@_) =
                _typeIunboundNames
            (_self@_) =
                FieldDeclaration_FieldDeclaration _rangeIself _namesIself _typeIself
            (_lhsOself@_) =
                _self
            (_typeOnamesInScope@_) =
                _lhsInamesInScope
        in  ( _lhsOself,_lhsOunboundNames)
-- FieldDeclarations -------------------------------------------
-- semantic domain
type T_FieldDeclarations = (Names) ->
                           ( (FieldDeclarations),(Names))
-- cata
sem_FieldDeclarations :: (FieldDeclarations) ->
                         (T_FieldDeclarations)
sem_FieldDeclarations (list) =
    (Prelude.foldr (sem_FieldDeclarations_Cons) (sem_FieldDeclarations_Nil) ((Prelude.map sem_FieldDeclaration list)))
sem_FieldDeclarations_Cons :: (T_FieldDeclaration) ->
                              (T_FieldDeclarations) ->
                              (T_FieldDeclarations)
sem_FieldDeclarations_Cons (hd_) (tl_) =
    \ _lhsInamesInScope ->
        let _lhsOself :: (FieldDeclarations)
            _lhsOunboundNames :: (Names)
            _hdIself :: (FieldDeclaration)
            _hdIunboundNames :: (Names)
            _hdOnamesInScope :: (Names)
            _tlIself :: (FieldDeclarations)
            _tlIunboundNames :: (Names)
            _tlOnamesInScope :: (Names)
            ( _hdIself,_hdIunboundNames) =
                (hd_ (_hdOnamesInScope))
            ( _tlIself,_tlIunboundNames) =
                (tl_ (_tlOnamesInScope))
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
        in  ( _lhsOself,_lhsOunboundNames)
sem_FieldDeclarations_Nil :: (T_FieldDeclarations)
sem_FieldDeclarations_Nil  =
    \ _lhsInamesInScope ->
        let _lhsOself :: (FieldDeclarations)
            _lhsOunboundNames :: (Names)
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
        in  ( _lhsOself,_lhsOunboundNames)
-- Fixity ------------------------------------------------------
-- semantic domain
type T_Fixity = ( (Fixity))
-- cata
sem_Fixity :: (Fixity) ->
              (T_Fixity)
sem_Fixity ((Fixity_Infix (_range))) =
    (sem_Fixity_Infix ((sem_Range (_range))))
sem_Fixity ((Fixity_Infixl (_range))) =
    (sem_Fixity_Infixl ((sem_Range (_range))))
sem_Fixity ((Fixity_Infixr (_range))) =
    (sem_Fixity_Infixr ((sem_Range (_range))))
sem_Fixity_Infix :: (T_Range) ->
                    (T_Fixity)
sem_Fixity_Infix (range_) =
    let _lhsOself :: (Fixity)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Fixity_Infix _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Fixity_Infixl :: (T_Range) ->
                     (T_Fixity)
sem_Fixity_Infixl (range_) =
    let _lhsOself :: (Fixity)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Fixity_Infixl _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Fixity_Infixr :: (T_Range) ->
                     (T_Fixity)
sem_Fixity_Infixr (range_) =
    let _lhsOself :: (Fixity)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Fixity_Infixr _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- FunctionBinding ---------------------------------------------
-- semantic domain
type T_FunctionBinding = ([((Expression, [String]), Core_TypingStrategy)]) ->
                         (M.Map NameWithRange TpScheme) ->
                         (Predicates) ->
                         (Tp) ->
                         (Int) ->
                         (Tps) ->
                         (ClassEnvironment) ->
                         (TypeErrors) ->
                         (Warnings) ->
                         (Int) ->
                         (DictionaryEnvironment) ->
                         (ImportEnvironment) ->
                         (IO ()) ->
                         (Monos) ->
                         (Names) ->
                         (OrderedTypeSynonyms) ->
                         (InfoTree) ->
                         ([Warning]) ->
                         (FixpointSubstitution) ->
                         (M.Map Int (Scheme Predicates)) ->
                         (Int) ->
                         ( (Int),(Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(DictionaryEnvironment),( ([PatternElement], Bool) ),(InfoTree),(IO ()),(Name),(Int),([Warning]),(FunctionBinding),(Names),(Int),(Warning))
-- cata
sem_FunctionBinding :: (FunctionBinding) ->
                       (T_FunctionBinding)
sem_FunctionBinding ((FunctionBinding_FunctionBinding (_range) (_lefthandside) (_righthandside))) =
    (sem_FunctionBinding_FunctionBinding ((sem_Range (_range))) ((sem_LeftHandSide (_lefthandside))) ((sem_RightHandSide (_righthandside))))
sem_FunctionBinding_FunctionBinding :: (T_Range) ->
                                       (T_LeftHandSide) ->
                                       (T_RightHandSide) ->
                                       (T_FunctionBinding)
sem_FunctionBinding_FunctionBinding (range_) (lefthandside_) (righthandside_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIbetasLeft
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOargcount :: (Int)
            _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOelements :: ( ([PatternElement], Bool) )
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOname :: (Name)
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (FunctionBinding)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOunrwar :: (Warning)
            _rangeIself :: (Range)
            _lefthandsideIargcount :: (Int)
            _lefthandsideIbetaUnique :: (Int)
            _lefthandsideIbetas :: (Tps)
            _lefthandsideIconstraints :: (ConstraintSet)
            _lefthandsideIelements :: (  [PatternElement]        )
            _lefthandsideIenvironment :: (PatternAssumptions)
            _lefthandsideIinfoTrees :: (InfoTrees)
            _lefthandsideIname :: (Name)
            _lefthandsideInumberOfPatterns :: (Int)
            _lefthandsideIpatVarNames :: (Names)
            _lefthandsideIpatternMatchWarnings :: ([Warning])
            _lefthandsideIself :: (LeftHandSide)
            _lefthandsideIunboundNames :: (Names)
            _lefthandsideObetaUnique :: (Int)
            _lefthandsideOimportEnvironment :: (ImportEnvironment)
            _lefthandsideOmonos :: (Monos)
            _lefthandsideOnamesInScope :: (Names)
            _lefthandsideOparentTree :: (InfoTree)
            _lefthandsideOpatternMatchWarnings :: ([Warning])
            _righthandsideIassumptions :: (Assumptions)
            _righthandsideIbetaUnique :: (Int)
            _righthandsideIcollectErrors :: (TypeErrors)
            _righthandsideIcollectInstances :: ([(Name, Instance)])
            _righthandsideIcollectWarnings :: (Warnings)
            _righthandsideIconstraints :: (ConstraintSet)
            _righthandsideIdictionaryEnvironment :: (DictionaryEnvironment)
            _righthandsideIfallthrough :: (Bool)
            _righthandsideIinfoTree :: (InfoTree)
            _righthandsideImatchIO :: (IO ())
            _righthandsideIpatternMatchWarnings :: ([Warning])
            _righthandsideIself :: (RightHandSide)
            _righthandsideIunboundNames :: (Names)
            _righthandsideIuniqueChunk :: (Int)
            _righthandsideOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _righthandsideOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _righthandsideOavailablePredicates :: (Predicates)
            _righthandsideObetaRight :: (Tp)
            _righthandsideObetaUnique :: (Int)
            _righthandsideOclassEnvironment :: (ClassEnvironment)
            _righthandsideOcollectErrors :: (TypeErrors)
            _righthandsideOcollectWarnings :: (Warnings)
            _righthandsideOcurrentChunk :: (Int)
            _righthandsideOdictionaryEnvironment :: (DictionaryEnvironment)
            _righthandsideOimportEnvironment :: (ImportEnvironment)
            _righthandsideOmatchIO :: (IO ())
            _righthandsideOmonos :: (Monos)
            _righthandsideOnamesInScope :: (Names)
            _righthandsideOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _righthandsideOparentTree :: (InfoTree)
            _righthandsideOpatternMatchWarnings :: ([Warning])
            _righthandsideOsubstitution :: (FixpointSubstitution)
            _righthandsideOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _righthandsideOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _lefthandsideIargcount,_lefthandsideIbetaUnique,_lefthandsideIbetas,_lefthandsideIconstraints,_lefthandsideIelements,_lefthandsideIenvironment,_lefthandsideIinfoTrees,_lefthandsideIname,_lefthandsideInumberOfPatterns,_lefthandsideIpatVarNames,_lefthandsideIpatternMatchWarnings,_lefthandsideIself,_lefthandsideIunboundNames) =
                (lefthandside_ (_lefthandsideObetaUnique) (_lefthandsideOimportEnvironment) (_lefthandsideOmonos) (_lefthandsideOnamesInScope) (_lefthandsideOparentTree) (_lefthandsideOpatternMatchWarnings))
            ( _righthandsideIassumptions,_righthandsideIbetaUnique,_righthandsideIcollectErrors,_righthandsideIcollectInstances,_righthandsideIcollectWarnings,_righthandsideIconstraints,_righthandsideIdictionaryEnvironment,_righthandsideIfallthrough,_righthandsideIinfoTree,_righthandsideImatchIO,_righthandsideIpatternMatchWarnings,_righthandsideIself,_righthandsideIunboundNames,_righthandsideIuniqueChunk) =
                (righthandside_ (_righthandsideOallPatterns)
                                (_righthandsideOallTypeSchemes)
                                (_righthandsideOavailablePredicates)
                                (_righthandsideObetaRight)
                                (_righthandsideObetaUnique)
                                (_righthandsideOclassEnvironment)
                                (_righthandsideOcollectErrors)
                                (_righthandsideOcollectWarnings)
                                (_righthandsideOcurrentChunk)
                                (_righthandsideOdictionaryEnvironment)
                                (_righthandsideOimportEnvironment)
                                (_righthandsideOmatchIO)
                                (_righthandsideOmonos)
                                (_righthandsideOnamesInScope)
                                (_righthandsideOorderedTypeSynonyms)
                                (_righthandsideOparentTree)
                                (_righthandsideOpatternMatchWarnings)
                                (_righthandsideOsubstitution)
                                (_righthandsideOtypeschemeMap)
                                (_righthandsideOuniqueChunk))
            ((_csetBinds@_,_lhsOassumptions@_)) =
                (_lefthandsideIenvironment .===. _righthandsideIassumptions) _cinfoBind
            (_conLeft@_) =
                zipWith3 (\t1 t2 nr -> (t1 .==. t2) (_cinfoLeft nr)) _lefthandsideIbetas _lhsIbetasLeft [0..]
            (_constraints@_) =
                _csetBinds .>>.
                Node [ _conLeft  .<. _lefthandsideIconstraints
                     , _righthandsideIconstraints
                     ]
            (_righthandsideOmonos@_) =
                M.elems _lefthandsideIenvironment ++ getMonos _csetBinds ++ _lhsImonos
            (_cinfoLeft@_) =
                \num  ->
                orphanConstraint num "pattern of function binding" _parentTree
                   [ Unifier (head (ftv (_lhsIbetasLeft !! num))) (ordinal True (num+1)++" pattern of function bindings", attribute _lhsIparentTree, "pattern") ]
            (_cinfoBind@_) =
                \name -> variableConstraint "variable" (nameToUHA_Expr name)
                   [ FolkloreConstraint
                   , makeUnifier name "function binding" _lefthandsideIenvironment _parentTree
                   ]
            (_localInfo@_) =
                LocalInfo { self = UHA_FB _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo (_lefthandsideIinfoTrees ++ [_righthandsideIinfoTree])
            (_lhsOunboundNames@_) =
                _unboundNames
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _lefthandsideIpatVarNames _righthandsideIunboundNames _lhsInamesInScope
            (_lhsOelements@_) =
                (_lefthandsideIelements, _righthandsideIfallthrough)
            (_lhsOunrwar@_) =
                UnreachablePatternLHS _lefthandsideIself
            (_lhsOcollectInstances@_) =
                _righthandsideIcollectInstances
            (_self@_) =
                FunctionBinding_FunctionBinding _rangeIself _lefthandsideIself _righthandsideIself
            (_lhsOself@_) =
                _self
            (_lhsOargcount@_) =
                _lefthandsideIargcount
            (_lhsObetaUnique@_) =
                _righthandsideIbetaUnique
            (_lhsOcollectErrors@_) =
                _righthandsideIcollectErrors
            (_lhsOcollectWarnings@_) =
                _righthandsideIcollectWarnings
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOdictionaryEnvironment@_) =
                _righthandsideIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _righthandsideImatchIO
            (_lhsOname@_) =
                _lefthandsideIname
            (_lhsOnumberOfPatterns@_) =
                _lefthandsideInumberOfPatterns
            (_lhsOpatternMatchWarnings@_) =
                _righthandsideIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _righthandsideIuniqueChunk
            (_lefthandsideObetaUnique@_) =
                _lhsIbetaUnique
            (_lefthandsideOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_lefthandsideOmonos@_) =
                _lhsImonos
            (_lefthandsideOnamesInScope@_) =
                _namesInScope
            (_lefthandsideOparentTree@_) =
                _parentTree
            (_lefthandsideOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_righthandsideOallPatterns@_) =
                _lhsIallPatterns
            (_righthandsideOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_righthandsideOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_righthandsideObetaRight@_) =
                _lhsIbetaRight
            (_righthandsideObetaUnique@_) =
                _lefthandsideIbetaUnique
            (_righthandsideOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_righthandsideOcollectErrors@_) =
                _lhsIcollectErrors
            (_righthandsideOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_righthandsideOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_righthandsideOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_righthandsideOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_righthandsideOmatchIO@_) =
                _lhsImatchIO
            (_righthandsideOnamesInScope@_) =
                _namesInScope
            (_righthandsideOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_righthandsideOparentTree@_) =
                _parentTree
            (_righthandsideOpatternMatchWarnings@_) =
                _lefthandsideIpatternMatchWarnings
            (_righthandsideOsubstitution@_) =
                _lhsIsubstitution
            (_righthandsideOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_righthandsideOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOargcount,_lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOelements,_lhsOinfoTree,_lhsOmatchIO,_lhsOname,_lhsOnumberOfPatterns,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOunrwar)
-- FunctionBindings --------------------------------------------
-- semantic domain
type T_FunctionBindings = ([((Expression, [String]), Core_TypingStrategy)]) ->
                          (M.Map NameWithRange TpScheme) ->
                          (Predicates) ->
                          (Tp) ->
                          (Int) ->
                          (Tps) ->
                          (ClassEnvironment) ->
                          (TypeErrors) ->
                          (Warnings) ->
                          (Int) ->
                          (DictionaryEnvironment) ->
                          (ImportEnvironment) ->
                          (IO ()) ->
                          (Monos) ->
                          (Names) ->
                          (OrderedTypeSynonyms) ->
                          (InfoTree) ->
                          ([Warning]) ->
                          (FixpointSubstitution) ->
                          (M.Map Int (Scheme Predicates)) ->
                          (Int) ->
                          ( (Int),(Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSets),(DictionaryEnvironment),([([PatternElement], Bool)]),(InfoTrees),(IO ()),(Name),(Int),([Warning]),(FunctionBindings),(Names),(Int),([Warning]))
-- cata
sem_FunctionBindings :: (FunctionBindings) ->
                        (T_FunctionBindings)
sem_FunctionBindings (list) =
    (Prelude.foldr (sem_FunctionBindings_Cons) (sem_FunctionBindings_Nil) ((Prelude.map sem_FunctionBinding list)))
sem_FunctionBindings_Cons :: (T_FunctionBinding) ->
                             (T_FunctionBindings) ->
                             (T_FunctionBindings)
sem_FunctionBindings_Cons (hd_) (tl_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIbetasLeft
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOargcount :: (Int)
            _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraintslist :: (ConstraintSets)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOelementss :: ([([PatternElement], Bool)])
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOname :: (Name)
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (FunctionBindings)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOunrwars :: ([Warning])
            _hdIargcount :: (Int)
            _hdIassumptions :: (Assumptions)
            _hdIbetaUnique :: (Int)
            _hdIcollectErrors :: (TypeErrors)
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectWarnings :: (Warnings)
            _hdIconstraints :: (ConstraintSet)
            _hdIdictionaryEnvironment :: (DictionaryEnvironment)
            _hdIelements :: ( ([PatternElement], Bool) )
            _hdIinfoTree :: (InfoTree)
            _hdImatchIO :: (IO ())
            _hdIname :: (Name)
            _hdInumberOfPatterns :: (Int)
            _hdIpatternMatchWarnings :: ([Warning])
            _hdIself :: (FunctionBinding)
            _hdIunboundNames :: (Names)
            _hdIuniqueChunk :: (Int)
            _hdIunrwar :: (Warning)
            _hdOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _hdOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _hdOavailablePredicates :: (Predicates)
            _hdObetaRight :: (Tp)
            _hdObetaUnique :: (Int)
            _hdObetasLeft :: (Tps)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectErrors :: (TypeErrors)
            _hdOcollectWarnings :: (Warnings)
            _hdOcurrentChunk :: (Int)
            _hdOdictionaryEnvironment :: (DictionaryEnvironment)
            _hdOimportEnvironment :: (ImportEnvironment)
            _hdOmatchIO :: (IO ())
            _hdOmonos :: (Monos)
            _hdOnamesInScope :: (Names)
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOparentTree :: (InfoTree)
            _hdOpatternMatchWarnings :: ([Warning])
            _hdOsubstitution :: (FixpointSubstitution)
            _hdOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _hdOuniqueChunk :: (Int)
            _tlIargcount :: (Int)
            _tlIassumptions :: (Assumptions)
            _tlIbetaUnique :: (Int)
            _tlIcollectErrors :: (TypeErrors)
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectWarnings :: (Warnings)
            _tlIconstraintslist :: (ConstraintSets)
            _tlIdictionaryEnvironment :: (DictionaryEnvironment)
            _tlIelementss :: ([([PatternElement], Bool)])
            _tlIinfoTrees :: (InfoTrees)
            _tlImatchIO :: (IO ())
            _tlIname :: (Name)
            _tlInumberOfPatterns :: (Int)
            _tlIpatternMatchWarnings :: ([Warning])
            _tlIself :: (FunctionBindings)
            _tlIunboundNames :: (Names)
            _tlIuniqueChunk :: (Int)
            _tlIunrwars :: ([Warning])
            _tlOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _tlOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _tlOavailablePredicates :: (Predicates)
            _tlObetaRight :: (Tp)
            _tlObetaUnique :: (Int)
            _tlObetasLeft :: (Tps)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectErrors :: (TypeErrors)
            _tlOcollectWarnings :: (Warnings)
            _tlOcurrentChunk :: (Int)
            _tlOdictionaryEnvironment :: (DictionaryEnvironment)
            _tlOimportEnvironment :: (ImportEnvironment)
            _tlOmatchIO :: (IO ())
            _tlOmonos :: (Monos)
            _tlOnamesInScope :: (Names)
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOparentTree :: (InfoTree)
            _tlOpatternMatchWarnings :: ([Warning])
            _tlOsubstitution :: (FixpointSubstitution)
            _tlOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _tlOuniqueChunk :: (Int)
            ( _hdIargcount,_hdIassumptions,_hdIbetaUnique,_hdIcollectErrors,_hdIcollectInstances,_hdIcollectWarnings,_hdIconstraints,_hdIdictionaryEnvironment,_hdIelements,_hdIinfoTree,_hdImatchIO,_hdIname,_hdInumberOfPatterns,_hdIpatternMatchWarnings,_hdIself,_hdIunboundNames,_hdIuniqueChunk,_hdIunrwar) =
                (hd_ (_hdOallPatterns) (_hdOallTypeSchemes) (_hdOavailablePredicates) (_hdObetaRight) (_hdObetaUnique) (_hdObetasLeft) (_hdOclassEnvironment) (_hdOcollectErrors) (_hdOcollectWarnings) (_hdOcurrentChunk) (_hdOdictionaryEnvironment) (_hdOimportEnvironment) (_hdOmatchIO) (_hdOmonos) (_hdOnamesInScope) (_hdOorderedTypeSynonyms) (_hdOparentTree) (_hdOpatternMatchWarnings) (_hdOsubstitution) (_hdOtypeschemeMap) (_hdOuniqueChunk))
            ( _tlIargcount,_tlIassumptions,_tlIbetaUnique,_tlIcollectErrors,_tlIcollectInstances,_tlIcollectWarnings,_tlIconstraintslist,_tlIdictionaryEnvironment,_tlIelementss,_tlIinfoTrees,_tlImatchIO,_tlIname,_tlInumberOfPatterns,_tlIpatternMatchWarnings,_tlIself,_tlIunboundNames,_tlIuniqueChunk,_tlIunrwars) =
                (tl_ (_tlOallPatterns) (_tlOallTypeSchemes) (_tlOavailablePredicates) (_tlObetaRight) (_tlObetaUnique) (_tlObetasLeft) (_tlOclassEnvironment) (_tlOcollectErrors) (_tlOcollectWarnings) (_tlOcurrentChunk) (_tlOdictionaryEnvironment) (_tlOimportEnvironment) (_tlOmatchIO) (_tlOmonos) (_tlOnamesInScope) (_tlOorderedTypeSynonyms) (_tlOparentTree) (_tlOpatternMatchWarnings) (_tlOsubstitution) (_tlOtypeschemeMap) (_tlOuniqueChunk))
            (_lhsOconstraintslist@_) =
                _hdIconstraints : _tlIconstraintslist
            (_lhsOname@_) =
                _hdIname
            (_lhsOnumberOfPatterns@_) =
                _hdInumberOfPatterns
            (_lhsOassumptions@_) =
                _hdIassumptions `combine` _tlIassumptions
            (_lhsOinfoTrees@_) =
                _hdIinfoTree : _tlIinfoTrees
            (_lhsOargcount@_) =
                _hdIargcount
            (_lhsOunrwars@_) =
                _hdIunrwar   : _tlIunrwars
            (_lhsOelementss@_) =
                _hdIelements : _tlIelementss
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _tlIbetaUnique
            (_lhsOcollectErrors@_) =
                _tlIcollectErrors
            (_lhsOcollectWarnings@_) =
                _tlIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _tlIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _tlImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _tlIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _tlIuniqueChunk
            (_hdOallPatterns@_) =
                _lhsIallPatterns
            (_hdOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_hdOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_hdObetaRight@_) =
                _lhsIbetaRight
            (_hdObetaUnique@_) =
                _lhsIbetaUnique
            (_hdObetasLeft@_) =
                _lhsIbetasLeft
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectErrors@_) =
                _lhsIcollectErrors
            (_hdOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_hdOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_hdOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_hdOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_hdOmatchIO@_) =
                _lhsImatchIO
            (_hdOmonos@_) =
                _lhsImonos
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOparentTree@_) =
                _lhsIparentTree
            (_hdOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_hdOsubstitution@_) =
                _lhsIsubstitution
            (_hdOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_hdOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_tlOallPatterns@_) =
                _lhsIallPatterns
            (_tlOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_tlOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_tlObetaRight@_) =
                _lhsIbetaRight
            (_tlObetaUnique@_) =
                _hdIbetaUnique
            (_tlObetasLeft@_) =
                _lhsIbetasLeft
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectErrors@_) =
                _hdIcollectErrors
            (_tlOcollectWarnings@_) =
                _hdIcollectWarnings
            (_tlOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_tlOdictionaryEnvironment@_) =
                _hdIdictionaryEnvironment
            (_tlOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_tlOmatchIO@_) =
                _hdImatchIO
            (_tlOmonos@_) =
                _lhsImonos
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOparentTree@_) =
                _lhsIparentTree
            (_tlOpatternMatchWarnings@_) =
                _hdIpatternMatchWarnings
            (_tlOsubstitution@_) =
                _lhsIsubstitution
            (_tlOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_tlOuniqueChunk@_) =
                _hdIuniqueChunk
        in  ( _lhsOargcount,_lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraintslist,_lhsOdictionaryEnvironment,_lhsOelementss,_lhsOinfoTrees,_lhsOmatchIO,_lhsOname,_lhsOnumberOfPatterns,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOunrwars)
sem_FunctionBindings_Nil :: (T_FunctionBindings)
sem_FunctionBindings_Nil  =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIbetasLeft
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOargcount :: (Int)
            _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraintslist :: (ConstraintSets)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOelementss :: ([([PatternElement], Bool)])
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOname :: (Name)
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (FunctionBindings)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOunrwars :: ([Warning])
            (_lhsOconstraintslist@_) =
                []
            (_lhsOname@_) =
                internalError "TypeInferencing.ag" "n/a" "FunctionBindings(2)"
            (_lhsOnumberOfPatterns@_) =
                internalError "TypeInferencing.ag" "n/a" "FunctionBindings(1)"
            (_lhsOassumptions@_) =
                noAssumptions
            (_lhsOinfoTrees@_) =
                []
            (_lhsOargcount@_) =
                pmError "FunctionBindings_Nil.argcount" "?empty list of function bindings?"
            (_lhsOunrwars@_) =
                []
            (_lhsOelementss@_) =
                []
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOargcount,_lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraintslist,_lhsOdictionaryEnvironment,_lhsOelementss,_lhsOinfoTrees,_lhsOmatchIO,_lhsOname,_lhsOnumberOfPatterns,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOunrwars)
-- GuardedExpression -------------------------------------------
-- semantic domain
type T_GuardedExpression = ([((Expression, [String]), Core_TypingStrategy)]) ->
                           (M.Map NameWithRange TpScheme) ->
                           (Predicates) ->
                           (Tp) ->
                           (Int) ->
                           (ClassEnvironment) ->
                           (TypeErrors) ->
                           (Warnings) ->
                           (Int) ->
                           (DictionaryEnvironment) ->
                           (ImportEnvironment) ->
                           (IO ()) ->
                           (Monos) ->
                           (Names) ->
                           (Int) ->
                           (OrderedTypeSynonyms) ->
                           (InfoTree) ->
                           ([Warning]) ->
                           (FixpointSubstitution) ->
                           (M.Map Int (Scheme Predicates)) ->
                           (Int) ->
                           (Int) ->
                           ( (Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(DictionaryEnvironment),(Bool),(InfoTrees),(IO ()),([Warning]),(Range),(GuardedExpression),(Names),(Int),(Int),(Warning))
-- cata
sem_GuardedExpression :: (GuardedExpression) ->
                         (T_GuardedExpression)
sem_GuardedExpression ((GuardedExpression_GuardedExpression (_range) (_guard) (_expression))) =
    (sem_GuardedExpression_GuardedExpression ((sem_Range (_range))) ((sem_Expression (_guard))) ((sem_Expression (_expression))))
sem_GuardedExpression_GuardedExpression :: (T_Range) ->
                                           (T_Expression) ->
                                           (T_Expression) ->
                                           (T_GuardedExpression)
sem_GuardedExpression_GuardedExpression (range_) (guard_) (expression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsInumberOfGuards
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOfallthrough :: (Bool)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOrange :: (Range)
            _lhsOself :: (GuardedExpression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _lhsOunrwar :: (Warning)
            _rangeIself :: (Range)
            _guardIassumptions :: (Assumptions)
            _guardIbeta :: (Tp)
            _guardIbetaUnique :: (Int)
            _guardIcollectErrors :: (TypeErrors)
            _guardIcollectInstances :: ([(Name, Instance)])
            _guardIcollectWarnings :: (Warnings)
            _guardIconstraints :: (ConstraintSet)
            _guardIdictionaryEnvironment :: (DictionaryEnvironment)
            _guardIinfoTree :: (InfoTree)
            _guardImatchIO :: (IO ())
            _guardImatches :: ([Maybe MetaVariableTable])
            _guardIpatternMatchWarnings :: ([Warning])
            _guardIself :: (Expression)
            _guardIunboundNames :: (Names)
            _guardIuniqueChunk :: (Int)
            _guardIuniqueSecondRound :: (Int)
            _guardOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _guardOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _guardOavailablePredicates :: (Predicates)
            _guardObetaUnique :: (Int)
            _guardOclassEnvironment :: (ClassEnvironment)
            _guardOcollectErrors :: (TypeErrors)
            _guardOcollectWarnings :: (Warnings)
            _guardOcurrentChunk :: (Int)
            _guardOdictionaryEnvironment :: (DictionaryEnvironment)
            _guardOimportEnvironment :: (ImportEnvironment)
            _guardOmatchIO :: (IO ())
            _guardOmonos :: (Monos)
            _guardOnamesInScope :: (Names)
            _guardOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _guardOparentTree :: (InfoTree)
            _guardOpatternMatchWarnings :: ([Warning])
            _guardOsubstitution :: (FixpointSubstitution)
            _guardOtryPatterns :: ([(Expression     , [String])])
            _guardOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _guardOuniqueChunk :: (Int)
            _guardOuniqueSecondRound :: (Int)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _guardIassumptions,_guardIbeta,_guardIbetaUnique,_guardIcollectErrors,_guardIcollectInstances,_guardIcollectWarnings,_guardIconstraints,_guardIdictionaryEnvironment,_guardIinfoTree,_guardImatchIO,_guardImatches,_guardIpatternMatchWarnings,_guardIself,_guardIunboundNames,_guardIuniqueChunk,_guardIuniqueSecondRound) =
                (guard_ (_guardOallPatterns)
                        (_guardOallTypeSchemes)
                        (_guardOavailablePredicates)
                        (_guardObetaUnique)
                        (_guardOclassEnvironment)
                        (_guardOcollectErrors)
                        (_guardOcollectWarnings)
                        (_guardOcurrentChunk)
                        (_guardOdictionaryEnvironment)
                        (_guardOimportEnvironment)
                        (_guardOmatchIO)
                        (_guardOmonos)
                        (_guardOnamesInScope)
                        (_guardOorderedTypeSynonyms)
                        (_guardOparentTree)
                        (_guardOpatternMatchWarnings)
                        (_guardOsubstitution)
                        (_guardOtryPatterns)
                        (_guardOtypeschemeMap)
                        (_guardOuniqueChunk)
                        (_guardOuniqueSecondRound))
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            (_newconExpr@_) =
                [ (_expressionIbeta .==. _lhsIbetaRight) _cinfoExpr ]
            (_newconGuard@_) =
                [ (_guardIbeta .==. boolType) _cinfoGuard ]
            (_lhsOassumptions@_) =
                _guardIassumptions `combine` _expressionIassumptions
            (_lhsOconstraints@_) =
                Node [ _newconGuard .<. _guardIconstraints
                     , _newconExpr  .<. _expressionIconstraints
                     ]
            (_cinfoGuard@_) =
                resultConstraint "guard" _guardIinfoTree
                   []
            (_cinfoExpr@_) =
                resultConstraint "guarded expression" _expressionIinfoTree $
                   [ HasTrustFactor 10.0 | _lhsInumberOfGuards < 2 ] ++
                   [ Unifier (head (ftv _lhsIbetaRight)) ("right-hand sides", attribute (skip_UHA_FB_RHS _lhsIparentTree), "right-hand side") ]
            (_lhsOinfoTrees@_) =
                [_guardIinfoTree, _expressionIinfoTree]
            (_expressionOtryPatterns@_) =
                []
            (_guardOtryPatterns@_) =
                []
            (_lhsOunrwar@_) =
                UnreachableGuard range_ _guardIself
            (_lhsOfallthrough@_) =
                case _guardIself
                of Expression_Variable    _ (Name_Identifier _ _ "otherwise") -> False
                   Expression_Constructor _ (Name_Identifier _ _ "True"     ) -> False
                   _                                                          -> True
            (_lhsOrange@_) =
                range_
            (_lhsOcollectInstances@_) =
                _guardIcollectInstances  ++  _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _guardIunboundNames ++ _expressionIunboundNames
            (_self@_) =
                GuardedExpression_GuardedExpression _rangeIself _guardIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _expressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _expressionImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
            (_guardOallPatterns@_) =
                _lhsIallPatterns
            (_guardOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_guardOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_guardObetaUnique@_) =
                _lhsIbetaUnique
            (_guardOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_guardOcollectErrors@_) =
                _lhsIcollectErrors
            (_guardOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_guardOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_guardOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_guardOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_guardOmatchIO@_) =
                _lhsImatchIO
            (_guardOmonos@_) =
                _lhsImonos
            (_guardOnamesInScope@_) =
                _lhsInamesInScope
            (_guardOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_guardOparentTree@_) =
                _lhsIparentTree
            (_guardOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_guardOsubstitution@_) =
                _lhsIsubstitution
            (_guardOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_guardOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_guardOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionObetaUnique@_) =
                _guardIbetaUnique
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _guardIcollectErrors
            (_expressionOcollectWarnings@_) =
                _guardIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _guardIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _guardImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _lhsIparentTree
            (_expressionOpatternMatchWarnings@_) =
                _guardIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _guardIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _guardIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOfallthrough,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOrange,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound,_lhsOunrwar)
-- GuardedExpressions ------------------------------------------
-- semantic domain
type T_GuardedExpressions = ([((Expression, [String]), Core_TypingStrategy)]) ->
                            (M.Map NameWithRange TpScheme) ->
                            (Predicates) ->
                            (Tp) ->
                            (Int) ->
                            (ClassEnvironment) ->
                            (TypeErrors) ->
                            (Warnings) ->
                            (Int) ->
                            (DictionaryEnvironment) ->
                            (ImportEnvironment) ->
                            (IO ()) ->
                            (Monos) ->
                            (Names) ->
                            (Int) ->
                            (Bool) ->
                            (OrderedTypeSynonyms) ->
                            (InfoTree) ->
                            ([Warning]) ->
                            (FixpointSubstitution) ->
                            (M.Map Int (Scheme Predicates)) ->
                            (Int) ->
                            (Int) ->
                            ( (Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSets),(DictionaryEnvironment),(Bool),(InfoTrees),(IO ()),([Warning]),(GuardedExpressions),(Names),(Int),(Int))
-- cata
sem_GuardedExpressions :: (GuardedExpressions) ->
                          (T_GuardedExpressions)
sem_GuardedExpressions (list) =
    (Prelude.foldr (sem_GuardedExpressions_Cons) (sem_GuardedExpressions_Nil) ((Prelude.map sem_GuardedExpression list)))
sem_GuardedExpressions_Cons :: (T_GuardedExpression) ->
                               (T_GuardedExpressions) ->
                               (T_GuardedExpressions)
sem_GuardedExpressions_Cons (hd_) (tl_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsInumberOfGuards
      _lhsIopen
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraintslist :: (ConstraintSets)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOfallthrough :: (Bool)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (GuardedExpressions)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _hdIassumptions :: (Assumptions)
            _hdIbetaUnique :: (Int)
            _hdIcollectErrors :: (TypeErrors)
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectWarnings :: (Warnings)
            _hdIconstraints :: (ConstraintSet)
            _hdIdictionaryEnvironment :: (DictionaryEnvironment)
            _hdIfallthrough :: (Bool)
            _hdIinfoTrees :: (InfoTrees)
            _hdImatchIO :: (IO ())
            _hdIpatternMatchWarnings :: ([Warning])
            _hdIrange :: (Range)
            _hdIself :: (GuardedExpression)
            _hdIunboundNames :: (Names)
            _hdIuniqueChunk :: (Int)
            _hdIuniqueSecondRound :: (Int)
            _hdIunrwar :: (Warning)
            _hdOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _hdOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _hdOavailablePredicates :: (Predicates)
            _hdObetaRight :: (Tp)
            _hdObetaUnique :: (Int)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectErrors :: (TypeErrors)
            _hdOcollectWarnings :: (Warnings)
            _hdOcurrentChunk :: (Int)
            _hdOdictionaryEnvironment :: (DictionaryEnvironment)
            _hdOimportEnvironment :: (ImportEnvironment)
            _hdOmatchIO :: (IO ())
            _hdOmonos :: (Monos)
            _hdOnamesInScope :: (Names)
            _hdOnumberOfGuards :: (Int)
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOparentTree :: (InfoTree)
            _hdOpatternMatchWarnings :: ([Warning])
            _hdOsubstitution :: (FixpointSubstitution)
            _hdOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _hdOuniqueChunk :: (Int)
            _hdOuniqueSecondRound :: (Int)
            _tlIassumptions :: (Assumptions)
            _tlIbetaUnique :: (Int)
            _tlIcollectErrors :: (TypeErrors)
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectWarnings :: (Warnings)
            _tlIconstraintslist :: (ConstraintSets)
            _tlIdictionaryEnvironment :: (DictionaryEnvironment)
            _tlIfallthrough :: (Bool)
            _tlIinfoTrees :: (InfoTrees)
            _tlImatchIO :: (IO ())
            _tlIpatternMatchWarnings :: ([Warning])
            _tlIself :: (GuardedExpressions)
            _tlIunboundNames :: (Names)
            _tlIuniqueChunk :: (Int)
            _tlIuniqueSecondRound :: (Int)
            _tlOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _tlOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _tlOavailablePredicates :: (Predicates)
            _tlObetaRight :: (Tp)
            _tlObetaUnique :: (Int)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectErrors :: (TypeErrors)
            _tlOcollectWarnings :: (Warnings)
            _tlOcurrentChunk :: (Int)
            _tlOdictionaryEnvironment :: (DictionaryEnvironment)
            _tlOimportEnvironment :: (ImportEnvironment)
            _tlOmatchIO :: (IO ())
            _tlOmonos :: (Monos)
            _tlOnamesInScope :: (Names)
            _tlOnumberOfGuards :: (Int)
            _tlOopen :: (Bool)
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOparentTree :: (InfoTree)
            _tlOpatternMatchWarnings :: ([Warning])
            _tlOsubstitution :: (FixpointSubstitution)
            _tlOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _tlOuniqueChunk :: (Int)
            _tlOuniqueSecondRound :: (Int)
            ( _hdIassumptions,_hdIbetaUnique,_hdIcollectErrors,_hdIcollectInstances,_hdIcollectWarnings,_hdIconstraints,_hdIdictionaryEnvironment,_hdIfallthrough,_hdIinfoTrees,_hdImatchIO,_hdIpatternMatchWarnings,_hdIrange,_hdIself,_hdIunboundNames,_hdIuniqueChunk,_hdIuniqueSecondRound,_hdIunrwar) =
                (hd_ (_hdOallPatterns)
                     (_hdOallTypeSchemes)
                     (_hdOavailablePredicates)
                     (_hdObetaRight)
                     (_hdObetaUnique)
                     (_hdOclassEnvironment)
                     (_hdOcollectErrors)
                     (_hdOcollectWarnings)
                     (_hdOcurrentChunk)
                     (_hdOdictionaryEnvironment)
                     (_hdOimportEnvironment)
                     (_hdOmatchIO)
                     (_hdOmonos)
                     (_hdOnamesInScope)
                     (_hdOnumberOfGuards)
                     (_hdOorderedTypeSynonyms)
                     (_hdOparentTree)
                     (_hdOpatternMatchWarnings)
                     (_hdOsubstitution)
                     (_hdOtypeschemeMap)
                     (_hdOuniqueChunk)
                     (_hdOuniqueSecondRound))
            ( _tlIassumptions,_tlIbetaUnique,_tlIcollectErrors,_tlIcollectInstances,_tlIcollectWarnings,_tlIconstraintslist,_tlIdictionaryEnvironment,_tlIfallthrough,_tlIinfoTrees,_tlImatchIO,_tlIpatternMatchWarnings,_tlIself,_tlIunboundNames,_tlIuniqueChunk,_tlIuniqueSecondRound) =
                (tl_ (_tlOallPatterns)
                     (_tlOallTypeSchemes)
                     (_tlOavailablePredicates)
                     (_tlObetaRight)
                     (_tlObetaUnique)
                     (_tlOclassEnvironment)
                     (_tlOcollectErrors)
                     (_tlOcollectWarnings)
                     (_tlOcurrentChunk)
                     (_tlOdictionaryEnvironment)
                     (_tlOimportEnvironment)
                     (_tlOmatchIO)
                     (_tlOmonos)
                     (_tlOnamesInScope)
                     (_tlOnumberOfGuards)
                     (_tlOopen)
                     (_tlOorderedTypeSynonyms)
                     (_tlOparentTree)
                     (_tlOpatternMatchWarnings)
                     (_tlOsubstitution)
                     (_tlOtypeschemeMap)
                     (_tlOuniqueChunk)
                     (_tlOuniqueSecondRound))
            (_lhsOconstraintslist@_) =
                _hdIconstraints : _tlIconstraintslist
            (_lhsOassumptions@_) =
                _hdIassumptions `combine` _tlIassumptions
            (_lhsOinfoTrees@_) =
                _hdIinfoTrees ++ _tlIinfoTrees
            (_lhsOpatternMatchWarnings@_) =
                (if not _lhsIopen then [_hdIunrwar] else [])
                ++ _tlIpatternMatchWarnings
            (_tlOopen@_) =
                _hdIfallthrough && _lhsIopen
            (_lhsOfallthrough@_) =
                _hdIfallthrough && _tlIfallthrough
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _tlIbetaUnique
            (_lhsOcollectErrors@_) =
                _tlIcollectErrors
            (_lhsOcollectWarnings@_) =
                _tlIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _tlIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _tlImatchIO
            (_lhsOuniqueChunk@_) =
                _tlIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _tlIuniqueSecondRound
            (_hdOallPatterns@_) =
                _lhsIallPatterns
            (_hdOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_hdOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_hdObetaRight@_) =
                _lhsIbetaRight
            (_hdObetaUnique@_) =
                _lhsIbetaUnique
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectErrors@_) =
                _lhsIcollectErrors
            (_hdOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_hdOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_hdOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_hdOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_hdOmatchIO@_) =
                _lhsImatchIO
            (_hdOmonos@_) =
                _lhsImonos
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOnumberOfGuards@_) =
                _lhsInumberOfGuards
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOparentTree@_) =
                _lhsIparentTree
            (_hdOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_hdOsubstitution@_) =
                _lhsIsubstitution
            (_hdOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_hdOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_hdOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_tlOallPatterns@_) =
                _lhsIallPatterns
            (_tlOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_tlOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_tlObetaRight@_) =
                _lhsIbetaRight
            (_tlObetaUnique@_) =
                _hdIbetaUnique
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectErrors@_) =
                _hdIcollectErrors
            (_tlOcollectWarnings@_) =
                _hdIcollectWarnings
            (_tlOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_tlOdictionaryEnvironment@_) =
                _hdIdictionaryEnvironment
            (_tlOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_tlOmatchIO@_) =
                _hdImatchIO
            (_tlOmonos@_) =
                _lhsImonos
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOnumberOfGuards@_) =
                _lhsInumberOfGuards
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOparentTree@_) =
                _lhsIparentTree
            (_tlOpatternMatchWarnings@_) =
                _hdIpatternMatchWarnings
            (_tlOsubstitution@_) =
                _lhsIsubstitution
            (_tlOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_tlOuniqueChunk@_) =
                _hdIuniqueChunk
            (_tlOuniqueSecondRound@_) =
                _hdIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraintslist,_lhsOdictionaryEnvironment,_lhsOfallthrough,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_GuardedExpressions_Nil :: (T_GuardedExpressions)
sem_GuardedExpressions_Nil  =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsInumberOfGuards
      _lhsIopen
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraintslist :: (ConstraintSets)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOfallthrough :: (Bool)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (GuardedExpressions)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            (_lhsOconstraintslist@_) =
                []
            (_lhsOassumptions@_) =
                noAssumptions
            (_lhsOinfoTrees@_) =
                []
            (_lhsOfallthrough@_) =
                True
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraintslist,_lhsOdictionaryEnvironment,_lhsOfallthrough,_lhsOinfoTrees,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
-- Import ------------------------------------------------------
-- semantic domain
type T_Import = ( (Import))
-- cata
sem_Import :: (Import) ->
              (T_Import)
sem_Import ((Import_TypeOrClass (_range) (_name) (_names))) =
    (sem_Import_TypeOrClass ((sem_Range (_range))) ((sem_Name (_name))) ((sem_MaybeNames (_names))))
sem_Import ((Import_TypeOrClassComplete (_range) (_name))) =
    (sem_Import_TypeOrClassComplete ((sem_Range (_range))) ((sem_Name (_name))))
sem_Import ((Import_Variable (_range) (_name))) =
    (sem_Import_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Import_TypeOrClass :: (T_Range) ->
                          (T_Name) ->
                          (T_MaybeNames) ->
                          (T_Import)
sem_Import_TypeOrClass (range_) (name_) (names_) =
    let _lhsOself :: (Import)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _namesIself :: (MaybeNames)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _namesIself) =
            (names_ )
        (_self@_) =
            Import_TypeOrClass _rangeIself _nameIself _namesIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Import_TypeOrClassComplete :: (T_Range) ->
                                  (T_Name) ->
                                  (T_Import)
sem_Import_TypeOrClassComplete (range_) (name_) =
    let _lhsOself :: (Import)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Import_TypeOrClassComplete _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Import_Variable :: (T_Range) ->
                       (T_Name) ->
                       (T_Import)
sem_Import_Variable (range_) (name_) =
    let _lhsOself :: (Import)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Import_Variable _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- ImportDeclaration -------------------------------------------
-- semantic domain
type T_ImportDeclaration = ( (ImportDeclaration))
-- cata
sem_ImportDeclaration :: (ImportDeclaration) ->
                         (T_ImportDeclaration)
sem_ImportDeclaration ((ImportDeclaration_Empty (_range))) =
    (sem_ImportDeclaration_Empty ((sem_Range (_range))))
sem_ImportDeclaration ((ImportDeclaration_Import (_range) (_qualified) (_name) (_asname) (_importspecification))) =
    (sem_ImportDeclaration_Import ((sem_Range (_range))) (_qualified) ((sem_Name (_name))) ((sem_MaybeName (_asname))) ((sem_MaybeImportSpecification (_importspecification))))
sem_ImportDeclaration_Empty :: (T_Range) ->
                               (T_ImportDeclaration)
sem_ImportDeclaration_Empty (range_) =
    let _lhsOself :: (ImportDeclaration)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            ImportDeclaration_Empty _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_ImportDeclaration_Import :: (T_Range) ->
                                (Bool) ->
                                (T_Name) ->
                                (T_MaybeName) ->
                                (T_MaybeImportSpecification) ->
                                (T_ImportDeclaration)
sem_ImportDeclaration_Import (range_) (qualified_) (name_) (asname_) (importspecification_) =
    let _lhsOself :: (ImportDeclaration)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _asnameIself :: (MaybeName)
        _importspecificationIself :: (MaybeImportSpecification)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _asnameIself) =
            (asname_ )
        ( _importspecificationIself) =
            (importspecification_ )
        (_self@_) =
            ImportDeclaration_Import _rangeIself qualified_ _nameIself _asnameIself _importspecificationIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- ImportDeclarations ------------------------------------------
-- semantic domain
type T_ImportDeclarations = ( (ImportDeclarations))
-- cata
sem_ImportDeclarations :: (ImportDeclarations) ->
                          (T_ImportDeclarations)
sem_ImportDeclarations (list) =
    (Prelude.foldr (sem_ImportDeclarations_Cons) (sem_ImportDeclarations_Nil) ((Prelude.map sem_ImportDeclaration list)))
sem_ImportDeclarations_Cons :: (T_ImportDeclaration) ->
                               (T_ImportDeclarations) ->
                               (T_ImportDeclarations)
sem_ImportDeclarations_Cons (hd_) (tl_) =
    let _lhsOself :: (ImportDeclarations)
        _hdIself :: (ImportDeclaration)
        _tlIself :: (ImportDeclarations)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_ImportDeclarations_Nil :: (T_ImportDeclarations)
sem_ImportDeclarations_Nil  =
    let _lhsOself :: (ImportDeclarations)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- ImportSpecification -----------------------------------------
-- semantic domain
type T_ImportSpecification = ( (ImportSpecification))
-- cata
sem_ImportSpecification :: (ImportSpecification) ->
                           (T_ImportSpecification)
sem_ImportSpecification ((ImportSpecification_Import (_range) (_hiding) (_imports))) =
    (sem_ImportSpecification_Import ((sem_Range (_range))) (_hiding) ((sem_Imports (_imports))))
sem_ImportSpecification_Import :: (T_Range) ->
                                  (Bool) ->
                                  (T_Imports) ->
                                  (T_ImportSpecification)
sem_ImportSpecification_Import (range_) (hiding_) (imports_) =
    let _lhsOself :: (ImportSpecification)
        _rangeIself :: (Range)
        _importsIself :: (Imports)
        ( _rangeIself) =
            (range_ )
        ( _importsIself) =
            (imports_ )
        (_self@_) =
            ImportSpecification_Import _rangeIself hiding_ _importsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Imports -----------------------------------------------------
-- semantic domain
type T_Imports = ( (Imports))
-- cata
sem_Imports :: (Imports) ->
               (T_Imports)
sem_Imports (list) =
    (Prelude.foldr (sem_Imports_Cons) (sem_Imports_Nil) ((Prelude.map sem_Import list)))
sem_Imports_Cons :: (T_Import) ->
                    (T_Imports) ->
                    (T_Imports)
sem_Imports_Cons (hd_) (tl_) =
    let _lhsOself :: (Imports)
        _hdIself :: (Import)
        _tlIself :: (Imports)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Imports_Nil :: (T_Imports)
sem_Imports_Nil  =
    let _lhsOself :: (Imports)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- LeftHandSide ------------------------------------------------
-- semantic domain
type T_LeftHandSide = (Int) ->
                      (ImportEnvironment) ->
                      (Monos) ->
                      (Names) ->
                      (InfoTree) ->
                      ([Warning]) ->
                      ( (Int),(Int),(Tps),(ConstraintSet),(  [PatternElement]        ),(PatternAssumptions),(InfoTrees),(Name),(Int),(Names),([Warning]),(LeftHandSide),(Names))
-- cata
sem_LeftHandSide :: (LeftHandSide) ->
                    (T_LeftHandSide)
sem_LeftHandSide ((LeftHandSide_Function (_range) (_name) (_patterns))) =
    (sem_LeftHandSide_Function ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Patterns (_patterns))))
sem_LeftHandSide ((LeftHandSide_Infix (_range) (_leftPattern) (_operator) (_rightPattern))) =
    (sem_LeftHandSide_Infix ((sem_Range (_range))) ((sem_Pattern (_leftPattern))) ((sem_Name (_operator))) ((sem_Pattern (_rightPattern))))
sem_LeftHandSide ((LeftHandSide_Parenthesized (_range) (_lefthandside) (_patterns))) =
    (sem_LeftHandSide_Parenthesized ((sem_Range (_range))) ((sem_LeftHandSide (_lefthandside))) ((sem_Patterns (_patterns))))
sem_LeftHandSide_Function :: (T_Range) ->
                             (T_Name) ->
                             (T_Patterns) ->
                             (T_LeftHandSide)
sem_LeftHandSide_Function (range_) (name_) (patterns_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsOargcount :: (Int)
            _lhsObetaUnique :: (Int)
            _lhsObetas :: (Tps)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOname :: (Name)
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (LeftHandSide)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _patternsIbetaUnique :: (Int)
            _patternsIbetas :: (Tps)
            _patternsIconstraintslist :: (ConstraintSets)
            _patternsIelementss :: ([ [PatternElement]       ])
            _patternsIenvironment :: (PatternAssumptions)
            _patternsIinfoTrees :: (InfoTrees)
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIpatternMatchWarnings :: ([Warning])
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsObetaUnique :: (Int)
            _patternsOimportEnvironment :: (ImportEnvironment)
            _patternsOmonos :: (Monos)
            _patternsOnamesInScope :: (Names)
            _patternsOparentTree :: (InfoTree)
            _patternsOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _patternsIbetaUnique,_patternsIbetas,_patternsIconstraintslist,_patternsIelementss,_patternsIenvironment,_patternsIinfoTrees,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIpatternMatchWarnings,_patternsIself,_patternsIunboundNames) =
                (patterns_ (_patternsObetaUnique) (_patternsOimportEnvironment) (_patternsOmonos) (_patternsOnamesInScope) (_patternsOparentTree) (_patternsOpatternMatchWarnings))
            (_constraints@_) =
                Node _patternsIconstraintslist
            (_lhsOname@_) =
                _nameIself
            (_lhsOinfoTrees@_) =
                _patternsIinfoTrees
            (_lhsOargcount@_) =
                length _patternsIself
            (_lhsOelements@_) =
                concat _patternsIelementss
            (_lhsOpatVarNames@_) =
                _patternsIpatVarNames
            (_lhsOunboundNames@_) =
                _patternsIunboundNames
            (_self@_) =
                LeftHandSide_Function _rangeIself _nameIself _patternsIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _patternsIbetaUnique
            (_lhsObetas@_) =
                _patternsIbetas
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOenvironment@_) =
                _patternsIenvironment
            (_lhsOnumberOfPatterns@_) =
                _patternsInumberOfPatterns
            (_lhsOpatternMatchWarnings@_) =
                _patternsIpatternMatchWarnings
            (_patternsObetaUnique@_) =
                _lhsIbetaUnique
            (_patternsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternsOmonos@_) =
                _lhsImonos
            (_patternsOnamesInScope@_) =
                _lhsInamesInScope
            (_patternsOparentTree@_) =
                _lhsIparentTree
            (_patternsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsOargcount,_lhsObetaUnique,_lhsObetas,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTrees,_lhsOname,_lhsOnumberOfPatterns,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_LeftHandSide_Infix :: (T_Range) ->
                          (T_Pattern) ->
                          (T_Name) ->
                          (T_Pattern) ->
                          (T_LeftHandSide)
sem_LeftHandSide_Infix (range_) (leftPattern_) (operator_) (rightPattern_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsOargcount :: (Int)
            _lhsObetaUnique :: (Int)
            _lhsObetas :: (Tps)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOname :: (Name)
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (LeftHandSide)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _leftPatternIbeta :: (Tp)
            _leftPatternIbetaUnique :: (Int)
            _leftPatternIconstraints :: (ConstraintSet)
            _leftPatternIelements :: (  [PatternElement]        )
            _leftPatternIenvironment :: (PatternAssumptions)
            _leftPatternIinfoTree :: (InfoTree)
            _leftPatternIpatVarNames :: (Names)
            _leftPatternIpatternMatchWarnings :: ([Warning])
            _leftPatternIself :: (Pattern)
            _leftPatternIunboundNames :: (Names)
            _leftPatternObetaUnique :: (Int)
            _leftPatternOimportEnvironment :: (ImportEnvironment)
            _leftPatternOmonos :: (Monos)
            _leftPatternOnamesInScope :: (Names)
            _leftPatternOparentTree :: (InfoTree)
            _leftPatternOpatternMatchWarnings :: ([Warning])
            _operatorIself :: (Name)
            _rightPatternIbeta :: (Tp)
            _rightPatternIbetaUnique :: (Int)
            _rightPatternIconstraints :: (ConstraintSet)
            _rightPatternIelements :: (  [PatternElement]        )
            _rightPatternIenvironment :: (PatternAssumptions)
            _rightPatternIinfoTree :: (InfoTree)
            _rightPatternIpatVarNames :: (Names)
            _rightPatternIpatternMatchWarnings :: ([Warning])
            _rightPatternIself :: (Pattern)
            _rightPatternIunboundNames :: (Names)
            _rightPatternObetaUnique :: (Int)
            _rightPatternOimportEnvironment :: (ImportEnvironment)
            _rightPatternOmonos :: (Monos)
            _rightPatternOnamesInScope :: (Names)
            _rightPatternOparentTree :: (InfoTree)
            _rightPatternOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _leftPatternIbeta,_leftPatternIbetaUnique,_leftPatternIconstraints,_leftPatternIelements,_leftPatternIenvironment,_leftPatternIinfoTree,_leftPatternIpatVarNames,_leftPatternIpatternMatchWarnings,_leftPatternIself,_leftPatternIunboundNames) =
                (leftPattern_ (_leftPatternObetaUnique) (_leftPatternOimportEnvironment) (_leftPatternOmonos) (_leftPatternOnamesInScope) (_leftPatternOparentTree) (_leftPatternOpatternMatchWarnings))
            ( _operatorIself) =
                (operator_ )
            ( _rightPatternIbeta,_rightPatternIbetaUnique,_rightPatternIconstraints,_rightPatternIelements,_rightPatternIenvironment,_rightPatternIinfoTree,_rightPatternIpatVarNames,_rightPatternIpatternMatchWarnings,_rightPatternIself,_rightPatternIunboundNames) =
                (rightPattern_ (_rightPatternObetaUnique) (_rightPatternOimportEnvironment) (_rightPatternOmonos) (_rightPatternOnamesInScope) (_rightPatternOparentTree) (_rightPatternOpatternMatchWarnings))
            (_constraints@_) =
                Node [ _leftPatternIconstraints
                     , _rightPatternIconstraints
                     ]
            (_lhsOname@_) =
                _operatorIself
            (_lhsObetas@_) =
                [_leftPatternIbeta,_rightPatternIbeta]
            (_lhsOenvironment@_) =
                _leftPatternIenvironment `M.union` _rightPatternIenvironment
            (_lhsOnumberOfPatterns@_) =
                2
            (_lhsOinfoTrees@_) =
                [_leftPatternIinfoTree, _rightPatternIinfoTree]
            (_lhsOargcount@_) =
                2
            (_lhsOelements@_) =
                _leftPatternIelements ++ _rightPatternIelements
            (_lhsOpatVarNames@_) =
                _leftPatternIpatVarNames ++ _rightPatternIpatVarNames
            (_lhsOunboundNames@_) =
                _leftPatternIunboundNames ++ _rightPatternIunboundNames
            (_self@_) =
                LeftHandSide_Infix _rangeIself _leftPatternIself _operatorIself _rightPatternIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _rightPatternIbetaUnique
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOpatternMatchWarnings@_) =
                _rightPatternIpatternMatchWarnings
            (_leftPatternObetaUnique@_) =
                _lhsIbetaUnique
            (_leftPatternOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_leftPatternOmonos@_) =
                _lhsImonos
            (_leftPatternOnamesInScope@_) =
                _lhsInamesInScope
            (_leftPatternOparentTree@_) =
                _lhsIparentTree
            (_leftPatternOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_rightPatternObetaUnique@_) =
                _leftPatternIbetaUnique
            (_rightPatternOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_rightPatternOmonos@_) =
                _lhsImonos
            (_rightPatternOnamesInScope@_) =
                _lhsInamesInScope
            (_rightPatternOparentTree@_) =
                _lhsIparentTree
            (_rightPatternOpatternMatchWarnings@_) =
                _leftPatternIpatternMatchWarnings
        in  ( _lhsOargcount,_lhsObetaUnique,_lhsObetas,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTrees,_lhsOname,_lhsOnumberOfPatterns,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_LeftHandSide_Parenthesized :: (T_Range) ->
                                  (T_LeftHandSide) ->
                                  (T_Patterns) ->
                                  (T_LeftHandSide)
sem_LeftHandSide_Parenthesized (range_) (lefthandside_) (patterns_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsOargcount :: (Int)
            _lhsObetaUnique :: (Int)
            _lhsObetas :: (Tps)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOname :: (Name)
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (LeftHandSide)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _lefthandsideIargcount :: (Int)
            _lefthandsideIbetaUnique :: (Int)
            _lefthandsideIbetas :: (Tps)
            _lefthandsideIconstraints :: (ConstraintSet)
            _lefthandsideIelements :: (  [PatternElement]        )
            _lefthandsideIenvironment :: (PatternAssumptions)
            _lefthandsideIinfoTrees :: (InfoTrees)
            _lefthandsideIname :: (Name)
            _lefthandsideInumberOfPatterns :: (Int)
            _lefthandsideIpatVarNames :: (Names)
            _lefthandsideIpatternMatchWarnings :: ([Warning])
            _lefthandsideIself :: (LeftHandSide)
            _lefthandsideIunboundNames :: (Names)
            _lefthandsideObetaUnique :: (Int)
            _lefthandsideOimportEnvironment :: (ImportEnvironment)
            _lefthandsideOmonos :: (Monos)
            _lefthandsideOnamesInScope :: (Names)
            _lefthandsideOparentTree :: (InfoTree)
            _lefthandsideOpatternMatchWarnings :: ([Warning])
            _patternsIbetaUnique :: (Int)
            _patternsIbetas :: (Tps)
            _patternsIconstraintslist :: (ConstraintSets)
            _patternsIelementss :: ([ [PatternElement]       ])
            _patternsIenvironment :: (PatternAssumptions)
            _patternsIinfoTrees :: (InfoTrees)
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIpatternMatchWarnings :: ([Warning])
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsObetaUnique :: (Int)
            _patternsOimportEnvironment :: (ImportEnvironment)
            _patternsOmonos :: (Monos)
            _patternsOnamesInScope :: (Names)
            _patternsOparentTree :: (InfoTree)
            _patternsOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _lefthandsideIargcount,_lefthandsideIbetaUnique,_lefthandsideIbetas,_lefthandsideIconstraints,_lefthandsideIelements,_lefthandsideIenvironment,_lefthandsideIinfoTrees,_lefthandsideIname,_lefthandsideInumberOfPatterns,_lefthandsideIpatVarNames,_lefthandsideIpatternMatchWarnings,_lefthandsideIself,_lefthandsideIunboundNames) =
                (lefthandside_ (_lefthandsideObetaUnique) (_lefthandsideOimportEnvironment) (_lefthandsideOmonos) (_lefthandsideOnamesInScope) (_lefthandsideOparentTree) (_lefthandsideOpatternMatchWarnings))
            ( _patternsIbetaUnique,_patternsIbetas,_patternsIconstraintslist,_patternsIelementss,_patternsIenvironment,_patternsIinfoTrees,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIpatternMatchWarnings,_patternsIself,_patternsIunboundNames) =
                (patterns_ (_patternsObetaUnique) (_patternsOimportEnvironment) (_patternsOmonos) (_patternsOnamesInScope) (_patternsOparentTree) (_patternsOpatternMatchWarnings))
            (_constraints@_) =
                Node ( _lefthandsideIconstraints : _patternsIconstraintslist )
            (_lhsObetas@_) =
                _lefthandsideIbetas ++ _patternsIbetas
            (_lhsOenvironment@_) =
                _lefthandsideIenvironment `M.union` _patternsIenvironment
            (_lhsOnumberOfPatterns@_) =
                _lefthandsideInumberOfPatterns + _patternsInumberOfPatterns
            (_lhsOinfoTrees@_) =
                _lefthandsideIinfoTrees ++ _patternsIinfoTrees
            (_lhsOpatVarNames@_) =
                _lefthandsideIpatVarNames ++ _patternsIpatVarNames
            (_lhsOunboundNames@_) =
                _lefthandsideIunboundNames ++ _patternsIunboundNames
            (_self@_) =
                LeftHandSide_Parenthesized _rangeIself _lefthandsideIself _patternsIself
            (_lhsOself@_) =
                _self
            (_lhsOargcount@_) =
                _lefthandsideIargcount
            (_lhsObetaUnique@_) =
                _patternsIbetaUnique
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOelements@_) =
                _lefthandsideIelements
            (_lhsOname@_) =
                _lefthandsideIname
            (_lhsOpatternMatchWarnings@_) =
                _patternsIpatternMatchWarnings
            (_lefthandsideObetaUnique@_) =
                _lhsIbetaUnique
            (_lefthandsideOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_lefthandsideOmonos@_) =
                _lhsImonos
            (_lefthandsideOnamesInScope@_) =
                _lhsInamesInScope
            (_lefthandsideOparentTree@_) =
                _lhsIparentTree
            (_lefthandsideOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_patternsObetaUnique@_) =
                _lefthandsideIbetaUnique
            (_patternsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternsOmonos@_) =
                _lhsImonos
            (_patternsOnamesInScope@_) =
                _lhsInamesInScope
            (_patternsOparentTree@_) =
                _lhsIparentTree
            (_patternsOpatternMatchWarnings@_) =
                _lefthandsideIpatternMatchWarnings
        in  ( _lhsOargcount,_lhsObetaUnique,_lhsObetas,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTrees,_lhsOname,_lhsOnumberOfPatterns,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
-- Literal -----------------------------------------------------
-- semantic domain
type T_Literal = ( (  [PatternElement]        ),(Tp),(Literal))
-- cata
sem_Literal :: (Literal) ->
               (T_Literal)
sem_Literal ((Literal_Char (_range) (_value))) =
    (sem_Literal_Char ((sem_Range (_range))) (_value))
sem_Literal ((Literal_Float (_range) (_value))) =
    (sem_Literal_Float ((sem_Range (_range))) (_value))
sem_Literal ((Literal_Int (_range) (_value))) =
    (sem_Literal_Int ((sem_Range (_range))) (_value))
sem_Literal ((Literal_String (_range) (_value))) =
    (sem_Literal_String ((sem_Range (_range))) (_value))
sem_Literal_Char :: (T_Range) ->
                    (String) ->
                    (T_Literal)
sem_Literal_Char (range_) (value_) =
    let _lhsOelements :: (  [PatternElement]        )
        _lhsOliteralType :: (Tp)
        _lhsOself :: (Literal)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_lhsOliteralType@_) =
            charType
        (_lhsOelements@_) =
            [InfiniteElement value_]
        (_self@_) =
            Literal_Char _rangeIself value_
        (_lhsOself@_) =
            _self
    in  ( _lhsOelements,_lhsOliteralType,_lhsOself)
sem_Literal_Float :: (T_Range) ->
                     (String) ->
                     (T_Literal)
sem_Literal_Float (range_) (value_) =
    let _lhsOelements :: (  [PatternElement]        )
        _lhsOliteralType :: (Tp)
        _lhsOself :: (Literal)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_lhsOliteralType@_) =
            floatType
        (_lhsOelements@_) =
            [InfiniteElement value_]
        (_self@_) =
            Literal_Float _rangeIself value_
        (_lhsOself@_) =
            _self
    in  ( _lhsOelements,_lhsOliteralType,_lhsOself)
sem_Literal_Int :: (T_Range) ->
                   (String) ->
                   (T_Literal)
sem_Literal_Int (range_) (value_) =
    let _lhsOelements :: (  [PatternElement]        )
        _lhsOliteralType :: (Tp)
        _lhsOself :: (Literal)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_lhsOliteralType@_) =
            intType
        (_lhsOelements@_) =
            [InfiniteElement value_]
        (_self@_) =
            Literal_Int _rangeIself value_
        (_lhsOself@_) =
            _self
    in  ( _lhsOelements,_lhsOliteralType,_lhsOself)
sem_Literal_String :: (T_Range) ->
                      (String) ->
                      (T_Literal)
sem_Literal_String (range_) (value_) =
    let _lhsOelements :: (  [PatternElement]        )
        _lhsOliteralType :: (Tp)
        _lhsOself :: (Literal)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_lhsOliteralType@_) =
            stringType
        (_lhsOelements@_) =
            stringPat value_
        (_self@_) =
            Literal_String _rangeIself value_
        (_lhsOself@_) =
            _self
    in  ( _lhsOelements,_lhsOliteralType,_lhsOself)
-- MaybeDeclarations -------------------------------------------
-- semantic domain
type T_MaybeDeclarations = ([((Expression, [String]), Core_TypingStrategy)]) ->
                           (M.Map NameWithRange TpScheme) ->
                           (Assumptions) ->
                           (Predicates) ->
                           (Int) ->
                           (ClassEnvironment) ->
                           (TypeErrors) ->
                           (Warnings) ->
                           (ConstraintSet) ->
                           (Int) ->
                           (DictionaryEnvironment) ->
                           (ImportEnvironment) ->
                           (IO ()) ->
                           (Monos) ->
                           (Names) ->
                           (OrderedTypeSynonyms) ->
                           (InfoTree) ->
                           ([Warning]) ->
                           (FixpointSubstitution) ->
                           (M.Map Int (Scheme Predicates)) ->
                           (Names) ->
                           (Int) ->
                           ( (Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(DictionaryEnvironment),(InfoTrees),(M.Map NameWithRange TpScheme),(IO ()),(Names),([Warning]),(MaybeDeclarations),(Names),(Int))
-- cata
sem_MaybeDeclarations :: (MaybeDeclarations) ->
                         (T_MaybeDeclarations)
sem_MaybeDeclarations ((MaybeDeclarations_Just (_declarations))) =
    (sem_MaybeDeclarations_Just ((sem_Declarations (_declarations))))
sem_MaybeDeclarations ((MaybeDeclarations_Nothing )) =
    (sem_MaybeDeclarations_Nothing )
sem_MaybeDeclarations_Just :: (T_Declarations) ->
                              (T_MaybeDeclarations)
sem_MaybeDeclarations_Just (declarations_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOlocalTypes :: (M.Map NameWithRange TpScheme)
            _lhsOmatchIO :: (IO ())
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (MaybeDeclarations)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _declarationsIbetaUnique :: (Int)
            _declarationsIbindingGroups :: (BindingGroups)
            _declarationsIcollectErrors :: (TypeErrors)
            _declarationsIcollectInstances :: ([(Name, Instance)])
            _declarationsIcollectWarnings :: (Warnings)
            _declarationsIdeclVarNames :: (Names)
            _declarationsIdictionaryEnvironment :: (DictionaryEnvironment)
            _declarationsIinfoTrees :: (InfoTrees)
            _declarationsImatchIO :: (IO ())
            _declarationsIpatternMatchWarnings :: ([Warning])
            _declarationsIrestrictedNames :: (Names)
            _declarationsIself :: (Declarations)
            _declarationsIsimplePatNames :: (Names)
            _declarationsItypeSignatures :: (TypeEnvironment)
            _declarationsIunboundNames :: (Names)
            _declarationsIuniqueChunk :: (Int)
            _declarationsOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _declarationsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _declarationsOavailablePredicates :: (Predicates)
            _declarationsObetaUnique :: (Int)
            _declarationsObindingGroups :: (BindingGroups)
            _declarationsOclassEnvironment :: (ClassEnvironment)
            _declarationsOcollectErrors :: (TypeErrors)
            _declarationsOcollectWarnings :: (Warnings)
            _declarationsOcurrentChunk :: (Int)
            _declarationsOdictionaryEnvironment :: (DictionaryEnvironment)
            _declarationsOimportEnvironment :: (ImportEnvironment)
            _declarationsOinheritedBDG :: (InheritedBDG)
            _declarationsOmatchIO :: (IO ())
            _declarationsOmonos :: (Monos)
            _declarationsOnamesInScope :: (Names)
            _declarationsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _declarationsOparentTree :: (InfoTree)
            _declarationsOpatternMatchWarnings :: ([Warning])
            _declarationsOsubstitution :: (FixpointSubstitution)
            _declarationsOtypeSignatures :: (TypeEnvironment)
            _declarationsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _declarationsOuniqueChunk :: (Int)
            ( _declarationsIbetaUnique
             ,_declarationsIbindingGroups
             ,_declarationsIcollectErrors
             ,_declarationsIcollectInstances
             ,_declarationsIcollectWarnings
             ,_declarationsIdeclVarNames
             ,_declarationsIdictionaryEnvironment
             ,_declarationsIinfoTrees
             ,_declarationsImatchIO
             ,_declarationsIpatternMatchWarnings
             ,_declarationsIrestrictedNames
             ,_declarationsIself
             ,_declarationsIsimplePatNames
             ,_declarationsItypeSignatures
             ,_declarationsIunboundNames
             ,_declarationsIuniqueChunk
             ) =
                (declarations_ (_declarationsOallPatterns)
                               (_declarationsOallTypeSchemes)
                               (_declarationsOavailablePredicates)
                               (_declarationsObetaUnique)
                               (_declarationsObindingGroups)
                               (_declarationsOclassEnvironment)
                               (_declarationsOcollectErrors)
                               (_declarationsOcollectWarnings)
                               (_declarationsOcurrentChunk)
                               (_declarationsOdictionaryEnvironment)
                               (_declarationsOimportEnvironment)
                               (_declarationsOinheritedBDG)
                               (_declarationsOmatchIO)
                               (_declarationsOmonos)
                               (_declarationsOnamesInScope)
                               (_declarationsOorderedTypeSynonyms)
                               (_declarationsOparentTree)
                               (_declarationsOpatternMatchWarnings)
                               (_declarationsOsubstitution)
                               (_declarationsOtypeSignatures)
                               (_declarationsOtypeschemeMap)
                               (_declarationsOuniqueChunk))
            ((_lhsOassumptions@_,_lhsOconstraints@_,_inheritedBDG@_,_chunkNr@_,_lhsObetaUnique@_,_implicitsFM@_)) =
                let inputBDG   = (False, _lhsIcurrentChunk, _declarationsIuniqueChunk, _lhsImonos, _declarationsItypeSignatures, mybdggroup, _declarationsIbetaUnique)
                    mybdggroup = Just (_lhsIassumptions, [_lhsIconstraints])
                in performBindingGroup inputBDG _declarationsIbindingGroups
            (_declarationsObindingGroups@_) =
                []
            (_lhsOcollectErrors@_) =
                restrictedNameErrors _inferredTypes _declarationsIrestrictedNames
                ++ _declarationsIcollectErrors
            (_lhsOcollectWarnings@_) =
                missingTypeSignature False _declarationsIsimplePatNames _inferredTypes
                ++ _declarationsIcollectWarnings
            (_inferredTypes@_) =
                findInferredTypes _lhsItypeschemeMap _implicitsFM
            (_lhsOlocalTypes@_) =
                makeLocalTypeEnv (_declarationsItypeSignatures `M.union` _inferredTypes) _declarationsIbindingGroups
            (_declarationsOtypeSignatures@_) =
                M.empty
            (_lhsOuniqueChunk@_) =
                _chunkNr
            (_declInfo@_) =
                LocalInfo { self = UHA_Decls _declarationsIself
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_declarationsOparentTree@_) =
                _theNode
            (_lhsOinfoTrees@_) =
                [_theNode]
            (_theNode@_) =
                node _lhsIparentTree _declInfo _declarationsIinfoTrees
            ((_collectTypeConstructors@_,_collectValueConstructors@_,_collectTypeSynonyms@_,_collectConstructorEnv@_,_derivedFunctions@_,_operatorFixities@_)) =
                internalError "PartialSyntax.ag" "n/a" "toplevel MaybeDeclaration"
            (_lhsOunboundNames@_) =
                _unboundNames
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _declarationsIdeclVarNames (_declarationsIunboundNames ++ _lhsIunboundNames) _lhsInamesInScope
            (_lhsOcollectInstances@_) =
                _declarationsIcollectInstances
            (_self@_) =
                MaybeDeclarations_Just _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsOdictionaryEnvironment@_) =
                _declarationsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _declarationsImatchIO
            (_lhsOnamesInScope@_) =
                _namesInScope
            (_lhsOpatternMatchWarnings@_) =
                _declarationsIpatternMatchWarnings
            (_declarationsOallPatterns@_) =
                _lhsIallPatterns
            (_declarationsOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_declarationsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_declarationsObetaUnique@_) =
                _lhsIbetaUnique
            (_declarationsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_declarationsOcollectErrors@_) =
                _lhsIcollectErrors
            (_declarationsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_declarationsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_declarationsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_declarationsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_declarationsOinheritedBDG@_) =
                _inheritedBDG
            (_declarationsOmatchIO@_) =
                _lhsImatchIO
            (_declarationsOmonos@_) =
                _lhsImonos
            (_declarationsOnamesInScope@_) =
                _namesInScope
            (_declarationsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_declarationsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_declarationsOsubstitution@_) =
                _lhsIsubstitution
            (_declarationsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_declarationsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOlocalTypes,_lhsOmatchIO,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk)
sem_MaybeDeclarations_Nothing :: (T_MaybeDeclarations)
sem_MaybeDeclarations_Nothing  =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOlocalTypes :: (M.Map NameWithRange TpScheme)
            _lhsOmatchIO :: (IO ())
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (MaybeDeclarations)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            (_lhsOlocalTypes@_) =
                M.empty
            (_lhsOinfoTrees@_) =
                []
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                MaybeDeclarations_Nothing
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _lhsIassumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOconstraints@_) =
                _lhsIconstraints
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOlocalTypes,_lhsOmatchIO,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk)
-- MaybeExports ------------------------------------------------
-- semantic domain
type T_MaybeExports = ( (MaybeExports))
-- cata
sem_MaybeExports :: (MaybeExports) ->
                    (T_MaybeExports)
sem_MaybeExports ((MaybeExports_Just (_exports))) =
    (sem_MaybeExports_Just ((sem_Exports (_exports))))
sem_MaybeExports ((MaybeExports_Nothing )) =
    (sem_MaybeExports_Nothing )
sem_MaybeExports_Just :: (T_Exports) ->
                         (T_MaybeExports)
sem_MaybeExports_Just (exports_) =
    let _lhsOself :: (MaybeExports)
        _exportsIself :: (Exports)
        ( _exportsIself) =
            (exports_ )
        (_self@_) =
            MaybeExports_Just _exportsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeExports_Nothing :: (T_MaybeExports)
sem_MaybeExports_Nothing  =
    let _lhsOself :: (MaybeExports)
        (_self@_) =
            MaybeExports_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeExpression ---------------------------------------------
-- semantic domain
type T_MaybeExpression = ([((Expression, [String]), Core_TypingStrategy)]) ->
                         (M.Map NameWithRange TpScheme) ->
                         (Predicates) ->
                         (Int) ->
                         (ClassEnvironment) ->
                         (TypeErrors) ->
                         (Warnings) ->
                         (Int) ->
                         (DictionaryEnvironment) ->
                         (ImportEnvironment) ->
                         (IO ()) ->
                         (Monos) ->
                         (Names) ->
                         (OrderedTypeSynonyms) ->
                         (InfoTree) ->
                         ([Warning]) ->
                         (FixpointSubstitution) ->
                         ([(MaybeExpression, [String])]) ->
                         (M.Map Int (Scheme Predicates)) ->
                         (Int) ->
                         (Int) ->
                         ( (Assumptions),(Tp),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(DictionaryEnvironment),(InfoTrees),(IO ()),([Maybe MetaVariableTable]),([Warning]),(Bool),(MaybeExpression),(Names),(Int),(Int))
-- cata
sem_MaybeExpression :: (MaybeExpression) ->
                       (T_MaybeExpression)
sem_MaybeExpression ((MaybeExpression_Just (_expression))) =
    (sem_MaybeExpression_Just ((sem_Expression (_expression))))
sem_MaybeExpression ((MaybeExpression_Nothing )) =
    (sem_MaybeExpression_Nothing )
sem_MaybeExpression_Just :: (T_Expression) ->
                            (T_MaybeExpression)
sem_MaybeExpression_Just (expression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOsection :: (Bool)
            _lhsOself :: (MaybeExpression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            (_lhsOsection@_) =
                False
            (_lhsOinfoTrees@_) =
                [_expressionIinfoTree]
            ((_expressionOtryPatterns@_,_lhsOmatches@_,_,_,_,_)) =
                match1' match_MaybeExpression_Just _lhsItryPatterns [] [_expressionImatches]
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                MaybeExpression_Just _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _expressionIassumptions
            (_lhsObeta@_) =
                _expressionIbeta
            (_lhsObetaUnique@_) =
                _expressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_lhsOconstraints@_) =
                _expressionIconstraints
            (_lhsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _expressionImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionObetaUnique@_) =
                _lhsIbetaUnique
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _lhsIparentTree
            (_expressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOsection,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_MaybeExpression_Nothing :: (T_MaybeExpression)
sem_MaybeExpression_Nothing  =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItryPatterns
      _lhsItypeschemeMap
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOmatches :: ([Maybe MetaVariableTable])
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOsection :: (Bool)
            _lhsOself :: (MaybeExpression)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_lhsOconstraints@_) =
                emptyTree
            (_lhsOassumptions@_) =
                noAssumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_lhsOsection@_) =
                True
            (_lhsOinfoTrees@_) =
                []
            (((),_lhsOmatches@_,_,_,_,_)) =
                match0' match_MaybeExpression_Nothing _lhsItryPatterns [] []
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                MaybeExpression_Nothing
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObeta,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOmatches,_lhsOpatternMatchWarnings,_lhsOsection,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
-- MaybeImportSpecification ------------------------------------
-- semantic domain
type T_MaybeImportSpecification = ( (MaybeImportSpecification))
-- cata
sem_MaybeImportSpecification :: (MaybeImportSpecification) ->
                                (T_MaybeImportSpecification)
sem_MaybeImportSpecification ((MaybeImportSpecification_Just (_importspecification))) =
    (sem_MaybeImportSpecification_Just ((sem_ImportSpecification (_importspecification))))
sem_MaybeImportSpecification ((MaybeImportSpecification_Nothing )) =
    (sem_MaybeImportSpecification_Nothing )
sem_MaybeImportSpecification_Just :: (T_ImportSpecification) ->
                                     (T_MaybeImportSpecification)
sem_MaybeImportSpecification_Just (importspecification_) =
    let _lhsOself :: (MaybeImportSpecification)
        _importspecificationIself :: (ImportSpecification)
        ( _importspecificationIself) =
            (importspecification_ )
        (_self@_) =
            MaybeImportSpecification_Just _importspecificationIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeImportSpecification_Nothing :: (T_MaybeImportSpecification)
sem_MaybeImportSpecification_Nothing  =
    let _lhsOself :: (MaybeImportSpecification)
        (_self@_) =
            MaybeImportSpecification_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeInt ----------------------------------------------------
-- semantic domain
type T_MaybeInt = ( (MaybeInt))
-- cata
sem_MaybeInt :: (MaybeInt) ->
                (T_MaybeInt)
sem_MaybeInt ((MaybeInt_Just (_int))) =
    (sem_MaybeInt_Just (_int))
sem_MaybeInt ((MaybeInt_Nothing )) =
    (sem_MaybeInt_Nothing )
sem_MaybeInt_Just :: (Int) ->
                     (T_MaybeInt)
sem_MaybeInt_Just (int_) =
    let _lhsOself :: (MaybeInt)
        (_self@_) =
            MaybeInt_Just int_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeInt_Nothing :: (T_MaybeInt)
sem_MaybeInt_Nothing  =
    let _lhsOself :: (MaybeInt)
        (_self@_) =
            MaybeInt_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeName ---------------------------------------------------
-- semantic domain
type T_MaybeName = ( (MaybeName))
-- cata
sem_MaybeName :: (MaybeName) ->
                 (T_MaybeName)
sem_MaybeName ((MaybeName_Just (_name))) =
    (sem_MaybeName_Just ((sem_Name (_name))))
sem_MaybeName ((MaybeName_Nothing )) =
    (sem_MaybeName_Nothing )
sem_MaybeName_Just :: (T_Name) ->
                      (T_MaybeName)
sem_MaybeName_Just (name_) =
    let _lhsOself :: (MaybeName)
        _nameIself :: (Name)
        ( _nameIself) =
            (name_ )
        (_self@_) =
            MaybeName_Just _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeName_Nothing :: (T_MaybeName)
sem_MaybeName_Nothing  =
    let _lhsOself :: (MaybeName)
        (_self@_) =
            MaybeName_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeNames --------------------------------------------------
-- semantic domain
type T_MaybeNames = ( (MaybeNames))
-- cata
sem_MaybeNames :: (MaybeNames) ->
                  (T_MaybeNames)
sem_MaybeNames ((MaybeNames_Just (_names))) =
    (sem_MaybeNames_Just ((sem_Names (_names))))
sem_MaybeNames ((MaybeNames_Nothing )) =
    (sem_MaybeNames_Nothing )
sem_MaybeNames_Just :: (T_Names) ->
                       (T_MaybeNames)
sem_MaybeNames_Just (names_) =
    let _lhsOself :: (MaybeNames)
        _namesIself :: (Names)
        ( _namesIself) =
            (names_ )
        (_self@_) =
            MaybeNames_Just _namesIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeNames_Nothing :: (T_MaybeNames)
sem_MaybeNames_Nothing  =
    let _lhsOself :: (MaybeNames)
        (_self@_) =
            MaybeNames_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Module ------------------------------------------------------
-- semantic domain
type T_Module = (ImportEnvironment) ->
                ([Option]) ->
                ( (Assumptions),(DictionaryEnvironment),(InfoTree),(LogEntries),(Module),(SolveResult ConstraintInfo),(TypeEnvironment),(TypeErrors),(Warnings))
-- cata
sem_Module :: (Module) ->
              (T_Module)
sem_Module ((Module_Module (_range) (_name) (_exports) (_body))) =
    (sem_Module_Module ((sem_Range (_range))) ((sem_MaybeName (_name))) ((sem_MaybeExports (_exports))) ((sem_Body (_body))))
sem_Module_Module :: (T_Range) ->
                     (T_MaybeName) ->
                     (T_MaybeExports) ->
                     (T_Body) ->
                     (T_Module)
sem_Module_Module (range_) (name_) (exports_) (body_) =
    \ _lhsIimportEnvironment
      _lhsIoptions ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOlogEntries :: (LogEntries)
            _lhsOself :: (Module)
            _lhsOsolveResult :: (SolveResult ConstraintInfo)
            _lhsOtoplevelTypes :: (TypeEnvironment)
            _lhsOtypeErrors :: (TypeErrors)
            _lhsOwarnings :: (Warnings)
            _rangeIself :: (Range)
            _nameIself :: (MaybeName)
            _exportsIself :: (MaybeExports)
            _bodyIassumptions :: (Assumptions)
            _bodyIbetaUnique :: (Int)
            _bodyIcollectErrors :: (TypeErrors)
            _bodyIcollectInstances :: ([(Name, Instance)])
            _bodyIcollectWarnings :: (Warnings)
            _bodyIconstraints :: (ConstraintSet)
            _bodyIdeclVarNames :: (Names)
            _bodyIdictionaryEnvironment :: (DictionaryEnvironment)
            _bodyIinfoTree :: (InfoTree)
            _bodyImatchIO :: (IO ())
            _bodyIpatternMatchWarnings :: ([Warning])
            _bodyIself :: (Body)
            _bodyItoplevelTypes :: (TypeEnvironment)
            _bodyIunboundNames :: (Names)
            _bodyIuniqueChunk :: (Int)
            _bodyOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _bodyOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _bodyOavailablePredicates :: (Predicates)
            _bodyObetaUnique :: (Int)
            _bodyOclassEnvironment :: (ClassEnvironment)
            _bodyOcollectErrors :: (TypeErrors)
            _bodyOcollectWarnings :: (Warnings)
            _bodyOcurrentChunk :: (Int)
            _bodyOdictionaryEnvironment :: (DictionaryEnvironment)
            _bodyOimportEnvironment :: (ImportEnvironment)
            _bodyOmatchIO :: (IO ())
            _bodyOmonos :: (Monos)
            _bodyOnamesInScope :: (Names)
            _bodyOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _bodyOpatternMatchWarnings :: ([Warning])
            _bodyOsubstitution :: (FixpointSubstitution)
            _bodyOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _bodyOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _exportsIself) =
                (exports_ )
            ( _bodyIassumptions,_bodyIbetaUnique,_bodyIcollectErrors,_bodyIcollectInstances,_bodyIcollectWarnings,_bodyIconstraints,_bodyIdeclVarNames,_bodyIdictionaryEnvironment,_bodyIinfoTree,_bodyImatchIO,_bodyIpatternMatchWarnings,_bodyIself,_bodyItoplevelTypes,_bodyIunboundNames,_bodyIuniqueChunk) =
                (body_ (_bodyOallPatterns) (_bodyOallTypeSchemes) (_bodyOavailablePredicates) (_bodyObetaUnique) (_bodyOclassEnvironment) (_bodyOcollectErrors) (_bodyOcollectWarnings) (_bodyOcurrentChunk) (_bodyOdictionaryEnvironment) (_bodyOimportEnvironment) (_bodyOmatchIO) (_bodyOmonos) (_bodyOnamesInScope) (_bodyOorderedTypeSynonyms) (_bodyOpatternMatchWarnings) (_bodyOsubstitution) (_bodyOtypeschemeMap) (_bodyOuniqueChunk))
            (_lhsOwarnings@_) =
                _warnings     ++ _bodyIpatternMatchWarnings
            (_bodyObetaUnique@_) =
                if null _monomorphics
                  then 0
                  else maximum _monomorphics + 1
            (_bodyOtypeschemeMap@_) =
                M.fromList (M.assocs _typeschemeMap)
            (_monomorphics@_) =
                ftv (  (M.elems $ valueConstructors _lhsIimportEnvironment)
                    ++ (M.elems $ typeEnvironment   _lhsIimportEnvironment)
                    )
            (_monos@_) =
                map TVar _monomorphics
            (_initialScope@_) =
                M.keys (typeEnvironment _lhsIimportEnvironment)
            (_assumptions@_) =
                let f xs = [ (n, _substitution |-> tp) | (n, tp) <- xs ]
                in M.map f _bodyIassumptions
            (_warnings@_) =
                _bodyIcollectWarnings
            (_typeErrors@_) =
                case makeTypeErrors _classEnv _orderedTypeSynonyms _substitution _solveErrors of
                   []   -> _bodyIcollectErrors
                   errs -> reverse errs
            (_classEnv@_) =
                foldr (\(n, i) -> insertInstance (show n) i)
                      (createClassEnvironment _lhsIimportEnvironment)
                      _bodyIcollectInstances
            (_orderedTypeSynonyms@_) =
                getOrderedTypeSynonyms _lhsIimportEnvironment
            ((_solveResult@_,_logEntries@_)) =
                (selectConstraintSolver _lhsIoptions _lhsIimportEnvironment)
                   _classEnv
                   _orderedTypeSynonyms
                   _bodyIbetaUnique
                   _bodyIconstraints
            ((SolveResult (_betaUniqueAtTheEnd@_)(_substitution@_)(_typeschemeMap@_)(_)(_solveErrors@_))) =
                _solveResult
            (_bodyOavailablePredicates@_) =
                []
            (_bodyOclassEnvironment@_) =
                _classEnv
            (_bodyOdictionaryEnvironment@_) =
                emptyDictionaryEnvironment
            (_lhsOdictionaryEnvironment@_) =
                if Overloading `elem` _lhsIoptions
                  then _bodyIdictionaryEnvironment
                  else emptyDictionaryEnvironment
            (_bodyOcollectErrors@_) =
                []
            (_bodyOcollectWarnings@_) =
                []
            (_bodyOallTypeSchemes@_) =
                M.fromList [ (NameWithRange name, scheme) | (name, scheme) <- M.assocs (typeEnvironment _lhsIimportEnvironment) ]
            (_bodyOuniqueChunk@_) =
                1
            (_bodyOcurrentChunk@_) =
                0
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope (_initialScope ++ _bodyIdeclVarNames) _bodyIunboundNames []
            (_bodyOmatchIO@_) =
                return ()
            (_bodyOallPatterns@_) =
                [ (matchInfo, typingStrategy)
                | typingStrategy <- typingStrategies _lhsIimportEnvironment
                , matchInfo      <- matchInformation
                                     _lhsIimportEnvironment
                                     typingStrategy
                ]
            (_bodyOpatternMatchWarnings@_) =
                []
            (_self@_) =
                Module_Module _rangeIself _nameIself _exportsIself _bodyIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _assumptions
            (_lhsOinfoTree@_) =
                _bodyIinfoTree
            (_lhsOlogEntries@_) =
                _logEntries
            (_lhsOsolveResult@_) =
                _solveResult
            (_lhsOtoplevelTypes@_) =
                _bodyItoplevelTypes
            (_lhsOtypeErrors@_) =
                _typeErrors
            (_bodyOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_bodyOmonos@_) =
                _monos
            (_bodyOnamesInScope@_) =
                _namesInScope
            (_bodyOorderedTypeSynonyms@_) =
                _orderedTypeSynonyms
            (_bodyOsubstitution@_) =
                _substitution
        in  ( _lhsOassumptions,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOlogEntries,_lhsOself,_lhsOsolveResult,_lhsOtoplevelTypes,_lhsOtypeErrors,_lhsOwarnings)
-- Name --------------------------------------------------------
-- semantic domain
type T_Name = ( (Name))
-- cata
sem_Name :: (Name) ->
            (T_Name)
sem_Name ((Name_Identifier (_range) (_module) (_name))) =
    (sem_Name_Identifier ((sem_Range (_range))) ((sem_Strings (_module))) (_name))
sem_Name ((Name_Operator (_range) (_module) (_name))) =
    (sem_Name_Operator ((sem_Range (_range))) ((sem_Strings (_module))) (_name))
sem_Name ((Name_Special (_range) (_module) (_name))) =
    (sem_Name_Special ((sem_Range (_range))) ((sem_Strings (_module))) (_name))
sem_Name_Identifier :: (T_Range) ->
                       (T_Strings) ->
                       (String) ->
                       (T_Name)
sem_Name_Identifier (range_) (module_) (name_) =
    let _lhsOself :: (Name)
        _rangeIself :: (Range)
        _moduleIself :: (Strings)
        ( _rangeIself) =
            (range_ )
        ( _moduleIself) =
            (module_ )
        (_self@_) =
            Name_Identifier _rangeIself _moduleIself name_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Name_Operator :: (T_Range) ->
                     (T_Strings) ->
                     (String) ->
                     (T_Name)
sem_Name_Operator (range_) (module_) (name_) =
    let _lhsOself :: (Name)
        _rangeIself :: (Range)
        _moduleIself :: (Strings)
        ( _rangeIself) =
            (range_ )
        ( _moduleIself) =
            (module_ )
        (_self@_) =
            Name_Operator _rangeIself _moduleIself name_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Name_Special :: (T_Range) ->
                    (T_Strings) ->
                    (String) ->
                    (T_Name)
sem_Name_Special (range_) (module_) (name_) =
    let _lhsOself :: (Name)
        _rangeIself :: (Range)
        _moduleIself :: (Strings)
        ( _rangeIself) =
            (range_ )
        ( _moduleIself) =
            (module_ )
        (_self@_) =
            Name_Special _rangeIself _moduleIself name_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Names -------------------------------------------------------
-- semantic domain
type T_Names = ( (Names))
-- cata
sem_Names :: (Names) ->
             (T_Names)
sem_Names (list) =
    (Prelude.foldr (sem_Names_Cons) (sem_Names_Nil) ((Prelude.map sem_Name list)))
sem_Names_Cons :: (T_Name) ->
                  (T_Names) ->
                  (T_Names)
sem_Names_Cons (hd_) (tl_) =
    let _lhsOself :: (Names)
        _hdIself :: (Name)
        _tlIself :: (Names)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Names_Nil :: (T_Names)
sem_Names_Nil  =
    let _lhsOself :: (Names)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Pattern -----------------------------------------------------
-- semantic domain
type T_Pattern = (Int) ->
                 (ImportEnvironment) ->
                 (Monos) ->
                 (Names) ->
                 (InfoTree) ->
                 ([Warning]) ->
                 ( (Tp),(Int),(ConstraintSet),(  [PatternElement]        ),(PatternAssumptions),(InfoTree),(Names),([Warning]),(Pattern),(Names))
-- cata
sem_Pattern :: (Pattern) ->
               (T_Pattern)
sem_Pattern ((Pattern_As (_range) (_name) (_pattern))) =
    (sem_Pattern_As ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Pattern (_pattern))))
sem_Pattern ((Pattern_Constructor (_range) (_name) (_patterns))) =
    (sem_Pattern_Constructor ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Patterns (_patterns))))
sem_Pattern ((Pattern_InfixConstructor (_range) (_leftPattern) (_constructorOperator) (_rightPattern))) =
    (sem_Pattern_InfixConstructor ((sem_Range (_range))) ((sem_Pattern (_leftPattern))) ((sem_Name (_constructorOperator))) ((sem_Pattern (_rightPattern))))
sem_Pattern ((Pattern_Irrefutable (_range) (_pattern))) =
    (sem_Pattern_Irrefutable ((sem_Range (_range))) ((sem_Pattern (_pattern))))
sem_Pattern ((Pattern_List (_range) (_patterns))) =
    (sem_Pattern_List ((sem_Range (_range))) ((sem_Patterns (_patterns))))
sem_Pattern ((Pattern_Literal (_range) (_literal))) =
    (sem_Pattern_Literal ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_Negate (_range) (_literal))) =
    (sem_Pattern_Negate ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_NegateFloat (_range) (_literal))) =
    (sem_Pattern_NegateFloat ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_Parenthesized (_range) (_pattern))) =
    (sem_Pattern_Parenthesized ((sem_Range (_range))) ((sem_Pattern (_pattern))))
sem_Pattern ((Pattern_Record (_range) (_name) (_recordPatternBindings))) =
    (sem_Pattern_Record ((sem_Range (_range))) ((sem_Name (_name))) ((sem_RecordPatternBindings (_recordPatternBindings))))
sem_Pattern ((Pattern_Successor (_range) (_name) (_literal))) =
    (sem_Pattern_Successor ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_Tuple (_range) (_patterns))) =
    (sem_Pattern_Tuple ((sem_Range (_range))) ((sem_Patterns (_patterns))))
sem_Pattern ((Pattern_Variable (_range) (_name))) =
    (sem_Pattern_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Pattern ((Pattern_Wildcard (_range))) =
    (sem_Pattern_Wildcard ((sem_Range (_range))))
sem_Pattern_As :: (T_Range) ->
                  (T_Name) ->
                  (T_Pattern) ->
                  (T_Pattern)
sem_Pattern_As (range_) (name_) (pattern_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _patternIbeta :: (Tp)
            _patternIbetaUnique :: (Int)
            _patternIconstraints :: (ConstraintSet)
            _patternIelements :: (  [PatternElement]        )
            _patternIenvironment :: (PatternAssumptions)
            _patternIinfoTree :: (InfoTree)
            _patternIpatVarNames :: (Names)
            _patternIpatternMatchWarnings :: ([Warning])
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternObetaUnique :: (Int)
            _patternOimportEnvironment :: (ImportEnvironment)
            _patternOmonos :: (Monos)
            _patternOnamesInScope :: (Names)
            _patternOparentTree :: (InfoTree)
            _patternOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _patternIbeta,_patternIbetaUnique,_patternIconstraints,_patternIelements,_patternIenvironment,_patternIinfoTree,_patternIpatVarNames,_patternIpatternMatchWarnings,_patternIself,_patternIunboundNames) =
                (pattern_ (_patternObetaUnique) (_patternOimportEnvironment) (_patternOmonos) (_patternOnamesInScope) (_patternOparentTree) (_patternOpatternMatchWarnings))
            (_newcon@_) =
                [ (_beta .==. _patternIbeta) _cinfo ]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _newcon .>.
                Node [ Receive _lhsIbetaUnique
                     , _patternIconstraints
                     ]
            (_patternObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_lhsOenvironment@_) =
                M.insert _nameIself _beta _patternIenvironment
            (_cinfo@_) =
                specialConstraint "as pattern" _parentTree
                   (self _localInfo, Just $ nameToUHA_Pat _nameIself)
                   []
            (_localInfo@_) =
                LocalInfo { self = UHA_Pat _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo [_patternIinfoTree]
            (_lhsOpatVarNames@_) =
                _nameIself : _patternIpatVarNames
            (_lhsOunboundNames@_) =
                _patternIunboundNames
            (_self@_) =
                Pattern_As _rangeIself _nameIself _patternIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _patternIbetaUnique
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOelements@_) =
                _patternIelements
            (_lhsOpatternMatchWarnings@_) =
                _patternIpatternMatchWarnings
            (_patternOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternOmonos@_) =
                _lhsImonos
            (_patternOnamesInScope@_) =
                _lhsInamesInScope
            (_patternOparentTree@_) =
                _parentTree
            (_patternOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_Constructor :: (T_Range) ->
                           (T_Name) ->
                           (T_Patterns) ->
                           (T_Pattern)
sem_Pattern_Constructor (range_) (name_) (patterns_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _patternsIbetaUnique :: (Int)
            _patternsIbetas :: (Tps)
            _patternsIconstraintslist :: (ConstraintSets)
            _patternsIelementss :: ([ [PatternElement]       ])
            _patternsIenvironment :: (PatternAssumptions)
            _patternsIinfoTrees :: (InfoTrees)
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIpatternMatchWarnings :: ([Warning])
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsObetaUnique :: (Int)
            _patternsOimportEnvironment :: (ImportEnvironment)
            _patternsOmonos :: (Monos)
            _patternsOnamesInScope :: (Names)
            _patternsOparentTree :: (InfoTree)
            _patternsOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _patternsIbetaUnique,_patternsIbetas,_patternsIconstraintslist,_patternsIelementss,_patternsIenvironment,_patternsIinfoTrees,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIpatternMatchWarnings,_patternsIself,_patternsIunboundNames) =
                (patterns_ (_patternsObetaUnique) (_patternsOimportEnvironment) (_patternsOmonos) (_patternsOnamesInScope) (_patternsOparentTree) (_patternsOpatternMatchWarnings))
            (_conConstructor@_) =
                case M.lookup _nameIself (valueConstructors _lhsIimportEnvironment) of
                   Nothing  -> []
                   Just ctp -> [ (_betaCon .::. ctp) _cinfoConstructor ]
            (_conApply@_) =
                [ (_betaCon .==. foldr (.->.) _beta _patternsIbetas)
                  (if _patternsInumberOfPatterns == 0  then _cinfoEmpty else _cinfoApply) ]
            (_betaCon@_) =
                TVar (_lhsIbetaUnique + 1)
            (_beta@_) =
                TVar (_lhsIbetaUnique)
            (_constraints@_) =
                _conApply .>.
                Node [ listTree _conConstructor
                     , Node _patternsIconstraintslist
                     ]
            (_patternsObetaUnique@_) =
                _lhsIbetaUnique + 2
            (_cinfoConstructor@_) =
                resultConstraint "pattern constructor" _parentTree
                   [ FolkloreConstraint, HasTrustFactor 10.0 ]
            (_cinfoApply@_) =
                specialConstraint "pattern application" _parentTree
                   (self _localInfo, Just $ nameToUHA_Pat _nameIself)
                   [ ApplicationEdge False (map attribute _patternsIinfoTrees) ]
            (_cinfoEmpty@_) =
                resultConstraint "pattern constructor" _parentTree
                   [ HasTrustFactor 10.0 ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Pat _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo _patternsIinfoTrees
            (_lhsOelements@_) =
                FiniteElement (getNameName _nameIself) : concat _patternsIelementss
            (_lhsOpatVarNames@_) =
                _patternsIpatVarNames
            (_lhsOunboundNames@_) =
                _patternsIunboundNames
            (_self@_) =
                Pattern_Constructor _rangeIself _nameIself _patternsIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _patternsIbetaUnique
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOenvironment@_) =
                _patternsIenvironment
            (_lhsOpatternMatchWarnings@_) =
                _patternsIpatternMatchWarnings
            (_patternsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternsOmonos@_) =
                _lhsImonos
            (_patternsOnamesInScope@_) =
                _lhsInamesInScope
            (_patternsOparentTree@_) =
                _parentTree
            (_patternsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_InfixConstructor :: (T_Range) ->
                                (T_Pattern) ->
                                (T_Name) ->
                                (T_Pattern) ->
                                (T_Pattern)
sem_Pattern_InfixConstructor (range_) (leftPattern_) (constructorOperator_) (rightPattern_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _leftPatternIbeta :: (Tp)
            _leftPatternIbetaUnique :: (Int)
            _leftPatternIconstraints :: (ConstraintSet)
            _leftPatternIelements :: (  [PatternElement]        )
            _leftPatternIenvironment :: (PatternAssumptions)
            _leftPatternIinfoTree :: (InfoTree)
            _leftPatternIpatVarNames :: (Names)
            _leftPatternIpatternMatchWarnings :: ([Warning])
            _leftPatternIself :: (Pattern)
            _leftPatternIunboundNames :: (Names)
            _leftPatternObetaUnique :: (Int)
            _leftPatternOimportEnvironment :: (ImportEnvironment)
            _leftPatternOmonos :: (Monos)
            _leftPatternOnamesInScope :: (Names)
            _leftPatternOparentTree :: (InfoTree)
            _leftPatternOpatternMatchWarnings :: ([Warning])
            _constructorOperatorIself :: (Name)
            _rightPatternIbeta :: (Tp)
            _rightPatternIbetaUnique :: (Int)
            _rightPatternIconstraints :: (ConstraintSet)
            _rightPatternIelements :: (  [PatternElement]        )
            _rightPatternIenvironment :: (PatternAssumptions)
            _rightPatternIinfoTree :: (InfoTree)
            _rightPatternIpatVarNames :: (Names)
            _rightPatternIpatternMatchWarnings :: ([Warning])
            _rightPatternIself :: (Pattern)
            _rightPatternIunboundNames :: (Names)
            _rightPatternObetaUnique :: (Int)
            _rightPatternOimportEnvironment :: (ImportEnvironment)
            _rightPatternOmonos :: (Monos)
            _rightPatternOnamesInScope :: (Names)
            _rightPatternOparentTree :: (InfoTree)
            _rightPatternOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _leftPatternIbeta,_leftPatternIbetaUnique,_leftPatternIconstraints,_leftPatternIelements,_leftPatternIenvironment,_leftPatternIinfoTree,_leftPatternIpatVarNames,_leftPatternIpatternMatchWarnings,_leftPatternIself,_leftPatternIunboundNames) =
                (leftPattern_ (_leftPatternObetaUnique) (_leftPatternOimportEnvironment) (_leftPatternOmonos) (_leftPatternOnamesInScope) (_leftPatternOparentTree) (_leftPatternOpatternMatchWarnings))
            ( _constructorOperatorIself) =
                (constructorOperator_ )
            ( _rightPatternIbeta,_rightPatternIbetaUnique,_rightPatternIconstraints,_rightPatternIelements,_rightPatternIenvironment,_rightPatternIinfoTree,_rightPatternIpatVarNames,_rightPatternIpatternMatchWarnings,_rightPatternIself,_rightPatternIunboundNames) =
                (rightPattern_ (_rightPatternObetaUnique) (_rightPatternOimportEnvironment) (_rightPatternOmonos) (_rightPatternOnamesInScope) (_rightPatternOparentTree) (_rightPatternOpatternMatchWarnings))
            (_conConstructor@_) =
                case M.lookup _constructorOperatorIself (valueConstructors _lhsIimportEnvironment) of
                   Nothing  -> []
                   Just ctp -> [ (_betaCon .::. ctp) _cinfoConstructor ]
            (_conApply@_) =
                [ (_betaCon .==. _leftPatternIbeta .->. _rightPatternIbeta .->. _beta) _cinfoApply ]
            (_betaCon@_) =
                TVar (_lhsIbetaUnique + 1)
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _conApply .>.
                Node [ listTree _conConstructor
                     , _leftPatternIconstraints
                     , _rightPatternIconstraints
                     ]
            (_leftPatternObetaUnique@_) =
                _lhsIbetaUnique + 2
            (_lhsOenvironment@_) =
                _leftPatternIenvironment `M.union` _rightPatternIenvironment
            (_cinfoConstructor@_) =
                variableConstraint "pattern constructor" (nameToUHA_Pat _constructorOperatorIself)
                   [ FolkloreConstraint, HasTrustFactor 10.0 ]
            (_cinfoApply@_) =
                specialConstraint "infix pattern application" _parentTree
                   (self _localInfo, Just $ nameToUHA_Pat  _constructorOperatorIself)
                   [ ApplicationEdge True (map attribute [_leftPatternIinfoTree, _rightPatternIinfoTree]) ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Pat _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo [_leftPatternIinfoTree, _rightPatternIinfoTree]
            (_lhsOelements@_) =
                FiniteElement (getNameName _constructorOperatorIself) : _leftPatternIelements ++ _rightPatternIelements
            (_lhsOpatVarNames@_) =
                _leftPatternIpatVarNames ++ _rightPatternIpatVarNames
            (_lhsOunboundNames@_) =
                _leftPatternIunboundNames ++ _rightPatternIunboundNames
            (_self@_) =
                Pattern_InfixConstructor _rangeIself _leftPatternIself _constructorOperatorIself _rightPatternIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _rightPatternIbetaUnique
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOpatternMatchWarnings@_) =
                _rightPatternIpatternMatchWarnings
            (_leftPatternOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_leftPatternOmonos@_) =
                _lhsImonos
            (_leftPatternOnamesInScope@_) =
                _lhsInamesInScope
            (_leftPatternOparentTree@_) =
                _parentTree
            (_leftPatternOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_rightPatternObetaUnique@_) =
                _leftPatternIbetaUnique
            (_rightPatternOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_rightPatternOmonos@_) =
                _lhsImonos
            (_rightPatternOnamesInScope@_) =
                _lhsInamesInScope
            (_rightPatternOparentTree@_) =
                _parentTree
            (_rightPatternOpatternMatchWarnings@_) =
                _leftPatternIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_Irrefutable :: (T_Range) ->
                           (T_Pattern) ->
                           (T_Pattern)
sem_Pattern_Irrefutable (range_) (pattern_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _patternIbeta :: (Tp)
            _patternIbetaUnique :: (Int)
            _patternIconstraints :: (ConstraintSet)
            _patternIelements :: (  [PatternElement]        )
            _patternIenvironment :: (PatternAssumptions)
            _patternIinfoTree :: (InfoTree)
            _patternIpatVarNames :: (Names)
            _patternIpatternMatchWarnings :: ([Warning])
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternObetaUnique :: (Int)
            _patternOimportEnvironment :: (ImportEnvironment)
            _patternOmonos :: (Monos)
            _patternOnamesInScope :: (Names)
            _patternOparentTree :: (InfoTree)
            _patternOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternIbeta,_patternIbetaUnique,_patternIconstraints,_patternIelements,_patternIenvironment,_patternIinfoTree,_patternIpatVarNames,_patternIpatternMatchWarnings,_patternIself,_patternIunboundNames) =
                (pattern_ (_patternObetaUnique) (_patternOimportEnvironment) (_patternOmonos) (_patternOnamesInScope) (_patternOparentTree) (_patternOpatternMatchWarnings))
            (_lhsOpatVarNames@_) =
                _patternIpatVarNames
            (_lhsOunboundNames@_) =
                _patternIunboundNames
            (_self@_) =
                Pattern_Irrefutable _rangeIself _patternIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _patternIbeta
            (_lhsObetaUnique@_) =
                _patternIbetaUnique
            (_lhsOconstraints@_) =
                _patternIconstraints
            (_lhsOelements@_) =
                _patternIelements
            (_lhsOenvironment@_) =
                _patternIenvironment
            (_lhsOinfoTree@_) =
                _patternIinfoTree
            (_lhsOpatternMatchWarnings@_) =
                _patternIpatternMatchWarnings
            (_patternObetaUnique@_) =
                _lhsIbetaUnique
            (_patternOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternOmonos@_) =
                _lhsImonos
            (_patternOnamesInScope@_) =
                _lhsInamesInScope
            (_patternOparentTree@_) =
                _lhsIparentTree
            (_patternOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_List :: (T_Range) ->
                    (T_Patterns) ->
                    (T_Pattern)
sem_Pattern_List (range_) (patterns_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _patternsIbetaUnique :: (Int)
            _patternsIbetas :: (Tps)
            _patternsIconstraintslist :: (ConstraintSets)
            _patternsIelementss :: ([ [PatternElement]       ])
            _patternsIenvironment :: (PatternAssumptions)
            _patternsIinfoTrees :: (InfoTrees)
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIpatternMatchWarnings :: ([Warning])
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsObetaUnique :: (Int)
            _patternsOimportEnvironment :: (ImportEnvironment)
            _patternsOmonos :: (Monos)
            _patternsOnamesInScope :: (Names)
            _patternsOparentTree :: (InfoTree)
            _patternsOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternsIbetaUnique,_patternsIbetas,_patternsIconstraintslist,_patternsIelementss,_patternsIenvironment,_patternsIinfoTrees,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIpatternMatchWarnings,_patternsIself,_patternsIunboundNames) =
                (patterns_ (_patternsObetaUnique) (_patternsOimportEnvironment) (_patternsOmonos) (_patternsOnamesInScope) (_patternsOparentTree) (_patternsOpatternMatchWarnings))
            (_zipf@_) =
                \tp elemNr ctree -> [ (tp .==. _beta') (_cinfoElem elemNr) ] .<. ctree
            (_newcon@_) =
                [ (listType _beta' .==. _beta) _cinfoResult ]
            (_beta'@_) =
                TVar (_lhsIbetaUnique + 1)
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _newcon .>.
                Node (zipWith3 _zipf _patternsIbetas [0..] _patternsIconstraintslist)
            (_patternsObetaUnique@_) =
                _lhsIbetaUnique + 2
            (_cinfoElem@_) =
                \elemNr ->
                childConstraint elemNr "element of pattern list" _parentTree $
                   [ HasTrustFactor 10.0 | length _patternsIconstraintslist < 2 ] ++
                   [ Unifier (head (ftv _beta')) ("pattern list", _localInfo, ordinal False (elemNr+1) ++ " element") ]
            (_cinfoResult@_) =
                resultConstraint "pattern list" _parentTree
                   [ FolkloreConstraint ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Pat _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo _patternsIinfoTrees
            (_lhsOelements@_) =
                listPat _patternsIelementss
            (_lhsOpatVarNames@_) =
                _patternsIpatVarNames
            (_lhsOunboundNames@_) =
                _patternsIunboundNames
            (_self@_) =
                Pattern_List _rangeIself _patternsIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _patternsIbetaUnique
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOenvironment@_) =
                _patternsIenvironment
            (_lhsOpatternMatchWarnings@_) =
                _patternsIpatternMatchWarnings
            (_patternsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternsOmonos@_) =
                _lhsImonos
            (_patternsOnamesInScope@_) =
                _lhsInamesInScope
            (_patternsOparentTree@_) =
                _parentTree
            (_patternsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_Literal :: (T_Range) ->
                       (T_Literal) ->
                       (T_Pattern)
sem_Pattern_Literal (range_) (literal_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _literalIelements :: (  [PatternElement]        )
            _literalIliteralType :: (Tp)
            _literalIself :: (Literal)
            ( _rangeIself) =
                (range_ )
            ( _literalIelements,_literalIliteralType,_literalIself) =
                (literal_ )
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                unitTree ((_literalIliteralType .==. _beta) _cinfo)
            (_lhsOenvironment@_) =
                noAssumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfo@_) =
                resultConstraint "literal pattern" _parentTree
                   [ FolkloreConstraint, HasTrustFactor 10.0 ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Pat _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo []
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_Literal _rangeIself _literalIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOelements@_) =
                _literalIelements
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_Negate :: (T_Range) ->
                      (T_Literal) ->
                      (T_Pattern)
sem_Pattern_Negate (range_) (literal_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _literalIelements :: (  [PatternElement]        )
            _literalIliteralType :: (Tp)
            _literalIself :: (Literal)
            ( _rangeIself) =
                (range_ )
            ( _literalIelements,_literalIliteralType,_literalIself) =
                (literal_ )
            (_newcon@_) =
                let standard = makeScheme [] [Predicate "Num" (TVar 0)] (TVar 0 .->. TVar 0)
                    tpscheme = M.findWithDefault standard (nameFromString "negate") (typeEnvironment _lhsIimportEnvironment)
                in [ (_literalIliteralType .->. _beta .::. tpscheme) _cinfo]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                listTree _newcon
            (_lhsOenvironment@_) =
                noAssumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfo@_) =
                resultConstraint "pattern negation" _parentTree
                   [ FolkloreConstraint ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Pat _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo []
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_Negate _rangeIself _literalIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOelements@_) =
                _literalIelements
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_NegateFloat :: (T_Range) ->
                           (T_Literal) ->
                           (T_Pattern)
sem_Pattern_NegateFloat (range_) (literal_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _literalIelements :: (  [PatternElement]        )
            _literalIliteralType :: (Tp)
            _literalIself :: (Literal)
            ( _rangeIself) =
                (range_ )
            ( _literalIelements,_literalIliteralType,_literalIself) =
                (literal_ )
            (_newcon@_) =
                [ (floatType .==. _beta) _cinfo ]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                listTree _newcon
            (_lhsOenvironment@_) =
                noAssumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfo@_) =
                resultConstraint "pattern negation" _parentTree
                   [ FolkloreConstraint ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Pat _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo []
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_NegateFloat _rangeIself _literalIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOelements@_) =
                _literalIelements
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_Parenthesized :: (T_Range) ->
                             (T_Pattern) ->
                             (T_Pattern)
sem_Pattern_Parenthesized (range_) (pattern_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _patternIbeta :: (Tp)
            _patternIbetaUnique :: (Int)
            _patternIconstraints :: (ConstraintSet)
            _patternIelements :: (  [PatternElement]        )
            _patternIenvironment :: (PatternAssumptions)
            _patternIinfoTree :: (InfoTree)
            _patternIpatVarNames :: (Names)
            _patternIpatternMatchWarnings :: ([Warning])
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternObetaUnique :: (Int)
            _patternOimportEnvironment :: (ImportEnvironment)
            _patternOmonos :: (Monos)
            _patternOnamesInScope :: (Names)
            _patternOparentTree :: (InfoTree)
            _patternOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternIbeta,_patternIbetaUnique,_patternIconstraints,_patternIelements,_patternIenvironment,_patternIinfoTree,_patternIpatVarNames,_patternIpatternMatchWarnings,_patternIself,_patternIunboundNames) =
                (pattern_ (_patternObetaUnique) (_patternOimportEnvironment) (_patternOmonos) (_patternOnamesInScope) (_patternOparentTree) (_patternOpatternMatchWarnings))
            (_lhsOpatVarNames@_) =
                _patternIpatVarNames
            (_lhsOunboundNames@_) =
                _patternIunboundNames
            (_self@_) =
                Pattern_Parenthesized _rangeIself _patternIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _patternIbeta
            (_lhsObetaUnique@_) =
                _patternIbetaUnique
            (_lhsOconstraints@_) =
                _patternIconstraints
            (_lhsOelements@_) =
                _patternIelements
            (_lhsOenvironment@_) =
                _patternIenvironment
            (_lhsOinfoTree@_) =
                _patternIinfoTree
            (_lhsOpatternMatchWarnings@_) =
                _patternIpatternMatchWarnings
            (_patternObetaUnique@_) =
                _lhsIbetaUnique
            (_patternOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternOmonos@_) =
                _lhsImonos
            (_patternOnamesInScope@_) =
                _lhsInamesInScope
            (_patternOparentTree@_) =
                _lhsIparentTree
            (_patternOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_Record :: (T_Range) ->
                      (T_Name) ->
                      (T_RecordPatternBindings) ->
                      (T_Pattern)
sem_Pattern_Record (range_) (name_) (recordPatternBindings_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _recordPatternBindingsIpatternMatchWarnings :: ([Warning])
            _recordPatternBindingsIself :: (RecordPatternBindings)
            _recordPatternBindingsIunboundNames :: (Names)
            _recordPatternBindingsOnamesInScope :: (Names)
            _recordPatternBindingsOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _recordPatternBindingsIpatternMatchWarnings,_recordPatternBindingsIself,_recordPatternBindingsIunboundNames) =
                (recordPatternBindings_ (_recordPatternBindingsOnamesInScope) (_recordPatternBindingsOpatternMatchWarnings))
            (_infoTree@_) =
                globalInfoError
            ((_beta@_,_constraints@_,_environment@_)) =
                internalError "PartialSyntax.ag" "n/a" "Pattern.Record"
            (_lhsOelements@_) =
                pmError "Pattern_Record.elements" "Records are not supported"
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                _recordPatternBindingsIunboundNames
            (_self@_) =
                Pattern_Record _rangeIself _nameIself _recordPatternBindingsIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOenvironment@_) =
                _environment
            (_lhsOinfoTree@_) =
                _infoTree
            (_lhsOpatternMatchWarnings@_) =
                _recordPatternBindingsIpatternMatchWarnings
            (_recordPatternBindingsOnamesInScope@_) =
                _lhsInamesInScope
            (_recordPatternBindingsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_Successor :: (T_Range) ->
                         (T_Name) ->
                         (T_Literal) ->
                         (T_Pattern)
sem_Pattern_Successor (range_) (name_) (literal_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _literalIelements :: (  [PatternElement]        )
            _literalIliteralType :: (Tp)
            _literalIself :: (Literal)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _literalIelements,_literalIliteralType,_literalIself) =
                (literal_ )
            (_infoTree@_) =
                globalInfoError
            ((_beta@_,_constraints@_,_environment@_)) =
                internalError "PartialSyntax.ag" "n/a" "Pattern.Successor"
            (_lhsOelements@_) =
                pmError "Pattern_Successor.elements" "Successors are not supported"
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_Successor _rangeIself _nameIself _literalIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOenvironment@_) =
                _environment
            (_lhsOinfoTree@_) =
                _infoTree
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_Tuple :: (T_Range) ->
                     (T_Patterns) ->
                     (T_Pattern)
sem_Pattern_Tuple (range_) (patterns_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _patternsIbetaUnique :: (Int)
            _patternsIbetas :: (Tps)
            _patternsIconstraintslist :: (ConstraintSets)
            _patternsIelementss :: ([ [PatternElement]       ])
            _patternsIenvironment :: (PatternAssumptions)
            _patternsIinfoTrees :: (InfoTrees)
            _patternsInumberOfPatterns :: (Int)
            _patternsIpatVarNames :: (Names)
            _patternsIpatternMatchWarnings :: ([Warning])
            _patternsIself :: (Patterns)
            _patternsIunboundNames :: (Names)
            _patternsObetaUnique :: (Int)
            _patternsOimportEnvironment :: (ImportEnvironment)
            _patternsOmonos :: (Monos)
            _patternsOnamesInScope :: (Names)
            _patternsOparentTree :: (InfoTree)
            _patternsOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _patternsIbetaUnique,_patternsIbetas,_patternsIconstraintslist,_patternsIelementss,_patternsIenvironment,_patternsIinfoTrees,_patternsInumberOfPatterns,_patternsIpatVarNames,_patternsIpatternMatchWarnings,_patternsIself,_patternsIunboundNames) =
                (patterns_ (_patternsObetaUnique) (_patternsOimportEnvironment) (_patternsOmonos) (_patternsOnamesInScope) (_patternsOparentTree) (_patternsOpatternMatchWarnings))
            (_newcon@_) =
                [ (tupleType _patternsIbetas .==. _beta) _cinfo ]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                _newcon .>. Node _patternsIconstraintslist
            (_patternsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_cinfo@_) =
                resultConstraint "pattern tuple" _parentTree
                [ FolkloreConstraint ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Pat _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo _patternsIinfoTrees
            (_lhsOelements@_) =
                FiniteElement ("(" ++ replicate (length $ tail _patternsIself) ',' ++ ")") : concat _patternsIelementss
            (_lhsOpatVarNames@_) =
                _patternsIpatVarNames
            (_lhsOunboundNames@_) =
                _patternsIunboundNames
            (_self@_) =
                Pattern_Tuple _rangeIself _patternsIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsObetaUnique@_) =
                _patternsIbetaUnique
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOenvironment@_) =
                _patternsIenvironment
            (_lhsOpatternMatchWarnings@_) =
                _patternsIpatternMatchWarnings
            (_patternsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternsOmonos@_) =
                _lhsImonos
            (_patternsOnamesInScope@_) =
                _lhsInamesInScope
            (_patternsOparentTree@_) =
                _parentTree
            (_patternsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_Variable :: (T_Range) ->
                        (T_Name) ->
                        (T_Pattern)
sem_Pattern_Variable (range_) (name_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                Receive _lhsIbetaUnique
            (_lhsOenvironment@_) =
                M.singleton _nameIself _beta
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_localInfo@_) =
                LocalInfo { self = UHA_Pat _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo []
            (_lhsOpatVarNames@_) =
                [ _nameIself ]
            (_lhsOelements@_) =
                [WildcardElement]
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_Variable _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Pattern_Wildcard :: (T_Range) ->
                        (T_Pattern)
sem_Pattern_Wildcard (range_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObeta :: (Tp)
            _lhsObetaUnique :: (Int)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOelements :: (  [PatternElement]        )
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTree :: (InfoTree)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Pattern)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_constraints@_) =
                emptyTree
            (_lhsOenvironment@_) =
                noAssumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_localInfo@_) =
                LocalInfo { self = UHA_Pat _self
                          , assignedType = Just _beta
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo []
            (_lhsOelements@_) =
                [WildcardElement]
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                Pattern_Wildcard _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsObeta@_) =
                _beta
            (_lhsOconstraints@_) =
                _constraints
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObeta,_lhsObetaUnique,_lhsOconstraints,_lhsOelements,_lhsOenvironment,_lhsOinfoTree,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
-- Patterns ----------------------------------------------------
-- semantic domain
type T_Patterns = (Int) ->
                  (ImportEnvironment) ->
                  (Monos) ->
                  (Names) ->
                  (InfoTree) ->
                  ([Warning]) ->
                  ( (Int),(Tps),(ConstraintSets),([ [PatternElement]       ]),(PatternAssumptions),(InfoTrees),(Int),(Names),([Warning]),(Patterns),(Names))
-- cata
sem_Patterns :: (Patterns) ->
                (T_Patterns)
sem_Patterns (list) =
    (Prelude.foldr (sem_Patterns_Cons) (sem_Patterns_Nil) ((Prelude.map sem_Pattern list)))
sem_Patterns_Cons :: (T_Pattern) ->
                     (T_Patterns) ->
                     (T_Patterns)
sem_Patterns_Cons (hd_) (tl_) =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObetaUnique :: (Int)
            _lhsObetas :: (Tps)
            _lhsOconstraintslist :: (ConstraintSets)
            _lhsOelementss :: ([ [PatternElement]       ])
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Patterns)
            _lhsOunboundNames :: (Names)
            _hdIbeta :: (Tp)
            _hdIbetaUnique :: (Int)
            _hdIconstraints :: (ConstraintSet)
            _hdIelements :: (  [PatternElement]        )
            _hdIenvironment :: (PatternAssumptions)
            _hdIinfoTree :: (InfoTree)
            _hdIpatVarNames :: (Names)
            _hdIpatternMatchWarnings :: ([Warning])
            _hdIself :: (Pattern)
            _hdIunboundNames :: (Names)
            _hdObetaUnique :: (Int)
            _hdOimportEnvironment :: (ImportEnvironment)
            _hdOmonos :: (Monos)
            _hdOnamesInScope :: (Names)
            _hdOparentTree :: (InfoTree)
            _hdOpatternMatchWarnings :: ([Warning])
            _tlIbetaUnique :: (Int)
            _tlIbetas :: (Tps)
            _tlIconstraintslist :: (ConstraintSets)
            _tlIelementss :: ([ [PatternElement]       ])
            _tlIenvironment :: (PatternAssumptions)
            _tlIinfoTrees :: (InfoTrees)
            _tlInumberOfPatterns :: (Int)
            _tlIpatVarNames :: (Names)
            _tlIpatternMatchWarnings :: ([Warning])
            _tlIself :: (Patterns)
            _tlIunboundNames :: (Names)
            _tlObetaUnique :: (Int)
            _tlOimportEnvironment :: (ImportEnvironment)
            _tlOmonos :: (Monos)
            _tlOnamesInScope :: (Names)
            _tlOparentTree :: (InfoTree)
            _tlOpatternMatchWarnings :: ([Warning])
            ( _hdIbeta,_hdIbetaUnique,_hdIconstraints,_hdIelements,_hdIenvironment,_hdIinfoTree,_hdIpatVarNames,_hdIpatternMatchWarnings,_hdIself,_hdIunboundNames) =
                (hd_ (_hdObetaUnique) (_hdOimportEnvironment) (_hdOmonos) (_hdOnamesInScope) (_hdOparentTree) (_hdOpatternMatchWarnings))
            ( _tlIbetaUnique,_tlIbetas,_tlIconstraintslist,_tlIelementss,_tlIenvironment,_tlIinfoTrees,_tlInumberOfPatterns,_tlIpatVarNames,_tlIpatternMatchWarnings,_tlIself,_tlIunboundNames) =
                (tl_ (_tlObetaUnique) (_tlOimportEnvironment) (_tlOmonos) (_tlOnamesInScope) (_tlOparentTree) (_tlOpatternMatchWarnings))
            (_lhsOconstraintslist@_) =
                _hdIconstraints : _tlIconstraintslist
            (_lhsOnumberOfPatterns@_) =
                1 + _tlInumberOfPatterns
            (_lhsOenvironment@_) =
                _hdIenvironment `M.union` _tlIenvironment
            (_lhsObetas@_) =
                _hdIbeta : _tlIbetas
            (_lhsOinfoTrees@_) =
                _hdIinfoTree : _tlIinfoTrees
            (_lhsOelementss@_) =
                _hdIelements : _tlIelementss
            (_lhsOpatVarNames@_) =
                _hdIpatVarNames ++ _tlIpatVarNames
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _tlIbetaUnique
            (_lhsOpatternMatchWarnings@_) =
                _tlIpatternMatchWarnings
            (_hdObetaUnique@_) =
                _lhsIbetaUnique
            (_hdOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_hdOmonos@_) =
                _lhsImonos
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOparentTree@_) =
                _lhsIparentTree
            (_hdOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_tlObetaUnique@_) =
                _hdIbetaUnique
            (_tlOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_tlOmonos@_) =
                _lhsImonos
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOparentTree@_) =
                _lhsIparentTree
            (_tlOpatternMatchWarnings@_) =
                _hdIpatternMatchWarnings
        in  ( _lhsObetaUnique,_lhsObetas,_lhsOconstraintslist,_lhsOelementss,_lhsOenvironment,_lhsOinfoTrees,_lhsOnumberOfPatterns,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_Patterns_Nil :: (T_Patterns)
sem_Patterns_Nil  =
    \ _lhsIbetaUnique
      _lhsIimportEnvironment
      _lhsImonos
      _lhsInamesInScope
      _lhsIparentTree
      _lhsIpatternMatchWarnings ->
        let _lhsObetaUnique :: (Int)
            _lhsObetas :: (Tps)
            _lhsOconstraintslist :: (ConstraintSets)
            _lhsOelementss :: ([ [PatternElement]       ])
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOnumberOfPatterns :: (Int)
            _lhsOpatVarNames :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Patterns)
            _lhsOunboundNames :: (Names)
            (_lhsOconstraintslist@_) =
                []
            (_lhsOnumberOfPatterns@_) =
                0
            (_lhsOenvironment@_) =
                noAssumptions
            (_lhsObetas@_) =
                []
            (_lhsOinfoTrees@_) =
                []
            (_lhsOelementss@_) =
                []
            (_lhsOpatVarNames@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsObetaUnique,_lhsObetas,_lhsOconstraintslist,_lhsOelementss,_lhsOenvironment,_lhsOinfoTrees,_lhsOnumberOfPatterns,_lhsOpatVarNames,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
-- Position ----------------------------------------------------
-- semantic domain
type T_Position = ( (Position))
-- cata
sem_Position :: (Position) ->
                (T_Position)
sem_Position ((Position_Position (_filename) (_line) (_column))) =
    (sem_Position_Position (_filename) (_line) (_column))
sem_Position ((Position_Unknown )) =
    (sem_Position_Unknown )
sem_Position_Position :: (String) ->
                         (Int) ->
                         (Int) ->
                         (T_Position)
sem_Position_Position (filename_) (line_) (column_) =
    let _lhsOself :: (Position)
        (_self@_) =
            Position_Position filename_ line_ column_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Position_Unknown :: (T_Position)
sem_Position_Unknown  =
    let _lhsOself :: (Position)
        (_self@_) =
            Position_Unknown
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Qualifier ---------------------------------------------------
-- semantic domain
type T_Qualifier = ([((Expression, [String]), Core_TypingStrategy)]) ->
                   (M.Map NameWithRange TpScheme) ->
                   (Assumptions) ->
                   (Predicates) ->
                   (Int) ->
                   (ClassEnvironment) ->
                   (TypeErrors) ->
                   (Warnings) ->
                   (ConstraintSet) ->
                   (Int) ->
                   (DictionaryEnvironment) ->
                   (ImportEnvironment) ->
                   (IO ()) ->
                   (Monos) ->
                   (Names) ->
                   (OrderedTypeSynonyms) ->
                   (InfoTree) ->
                   ([Warning]) ->
                   (FixpointSubstitution) ->
                   (M.Map Int (Scheme Predicates)) ->
                   (Names) ->
                   (Int) ->
                   (Int) ->
                   ( (Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(DictionaryEnvironment),(InfoTree),(IO ()),(Monos),(Names),([Warning]),(Qualifier),(Names),(Int),(Int))
-- cata
sem_Qualifier :: (Qualifier) ->
                 (T_Qualifier)
sem_Qualifier ((Qualifier_Empty (_range))) =
    (sem_Qualifier_Empty ((sem_Range (_range))))
sem_Qualifier ((Qualifier_Generator (_range) (_pattern) (_expression))) =
    (sem_Qualifier_Generator ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_Expression (_expression))))
sem_Qualifier ((Qualifier_Guard (_range) (_guard))) =
    (sem_Qualifier_Guard ((sem_Range (_range))) ((sem_Expression (_guard))))
sem_Qualifier ((Qualifier_Let (_range) (_declarations))) =
    (sem_Qualifier_Let ((sem_Range (_range))) ((sem_Declarations (_declarations))))
sem_Qualifier_Empty :: (T_Range) ->
                       (T_Qualifier)
sem_Qualifier_Empty (range_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmonos :: (Monos)
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Qualifier)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_localInfo@_) =
                LocalInfo { self = UHA_Qual _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo []
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                Qualifier_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _lhsIassumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOconstraints@_) =
                _lhsIconstraints
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOmonos@_) =
                _lhsImonos
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmonos,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Qualifier_Generator :: (T_Range) ->
                           (T_Pattern) ->
                           (T_Expression) ->
                           (T_Qualifier)
sem_Qualifier_Generator (range_) (pattern_) (expression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmonos :: (Monos)
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Qualifier)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _patternIbeta :: (Tp)
            _patternIbetaUnique :: (Int)
            _patternIconstraints :: (ConstraintSet)
            _patternIelements :: (  [PatternElement]        )
            _patternIenvironment :: (PatternAssumptions)
            _patternIinfoTree :: (InfoTree)
            _patternIpatVarNames :: (Names)
            _patternIpatternMatchWarnings :: ([Warning])
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternObetaUnique :: (Int)
            _patternOimportEnvironment :: (ImportEnvironment)
            _patternOmonos :: (Monos)
            _patternOnamesInScope :: (Names)
            _patternOparentTree :: (InfoTree)
            _patternOpatternMatchWarnings :: ([Warning])
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _patternIbeta,_patternIbetaUnique,_patternIconstraints,_patternIelements,_patternIenvironment,_patternIinfoTree,_patternIpatVarNames,_patternIpatternMatchWarnings,_patternIself,_patternIunboundNames) =
                (pattern_ (_patternObetaUnique) (_patternOimportEnvironment) (_patternOmonos) (_patternOnamesInScope) (_patternOparentTree) (_patternOpatternMatchWarnings))
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            (_newcon@_) =
                [ (_expressionIbeta .==. listType _patternIbeta) _cinfoResult ]
            ((_csetBinds@_,_assumptions'@_)) =
                (_patternIenvironment .===. _lhsIassumptions) _cinfoBind
            (_locConstraints@_) =
                _newcon .>. _csetBinds .>>.
                   Node [ _patternIconstraints
                        , _expressionIconstraints
                        , _lhsIconstraints
                        ]
            (_lhsOmonos@_) =
                M.elems _patternIenvironment ++ getMonos _csetBinds ++ _lhsImonos
            (_lhsOconstraints@_) =
                _locConstraints
            (_lhsOassumptions@_) =
                _assumptions' `combine` _expressionIassumptions
            (_cinfoResult@_) =
                childConstraint 1 "generator" _parentTree
                   []
            (_cinfoBind@_) =
                \name -> variableConstraint "variable" (nameToUHA_Expr name)
                   [ FolkloreConstraint
                   , makeUnifier name "generator" _patternIenvironment _parentTree
                   ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Qual _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo [_patternIinfoTree, _expressionIinfoTree]
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _patternIpatVarNames (_expressionIunboundNames  ++ _lhsIunboundNames)  _lhsInamesInScope
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOunboundNames@_) =
                _unboundNames
            (_lhsOnamesInScope@_) =
                _namesInScope
            (_expressionOtryPatterns@_) =
                []
            (_lhsOpatternMatchWarnings@_) =
                patternMatchWarnings _lhsIimportEnvironment
                                     _lhsIsubstitution
                                     _patternIbeta
                                     (:[])
                                     [(_patternIelements, False)]
                                     range_
                                     Nothing
                                     False
                                     []
                                     "generator"
                                     "<-"
                ++ _expressionIpatternMatchWarnings
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_self@_) =
                Qualifier_Generator _rangeIself _patternIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _expressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _expressionImatchIO
            (_lhsOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
            (_patternObetaUnique@_) =
                _lhsIbetaUnique
            (_patternOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternOmonos@_) =
                _lhsImonos
            (_patternOnamesInScope@_) =
                _namesInScope
            (_patternOparentTree@_) =
                _parentTree
            (_patternOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionObetaUnique@_) =
                _patternIbetaUnique
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _parentTree
            (_expressionOpatternMatchWarnings@_) =
                _patternIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmonos,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Qualifier_Guard :: (T_Range) ->
                       (T_Expression) ->
                       (T_Qualifier)
sem_Qualifier_Guard (range_) (guard_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmonos :: (Monos)
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Qualifier)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _guardIassumptions :: (Assumptions)
            _guardIbeta :: (Tp)
            _guardIbetaUnique :: (Int)
            _guardIcollectErrors :: (TypeErrors)
            _guardIcollectInstances :: ([(Name, Instance)])
            _guardIcollectWarnings :: (Warnings)
            _guardIconstraints :: (ConstraintSet)
            _guardIdictionaryEnvironment :: (DictionaryEnvironment)
            _guardIinfoTree :: (InfoTree)
            _guardImatchIO :: (IO ())
            _guardImatches :: ([Maybe MetaVariableTable])
            _guardIpatternMatchWarnings :: ([Warning])
            _guardIself :: (Expression)
            _guardIunboundNames :: (Names)
            _guardIuniqueChunk :: (Int)
            _guardIuniqueSecondRound :: (Int)
            _guardOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _guardOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _guardOavailablePredicates :: (Predicates)
            _guardObetaUnique :: (Int)
            _guardOclassEnvironment :: (ClassEnvironment)
            _guardOcollectErrors :: (TypeErrors)
            _guardOcollectWarnings :: (Warnings)
            _guardOcurrentChunk :: (Int)
            _guardOdictionaryEnvironment :: (DictionaryEnvironment)
            _guardOimportEnvironment :: (ImportEnvironment)
            _guardOmatchIO :: (IO ())
            _guardOmonos :: (Monos)
            _guardOnamesInScope :: (Names)
            _guardOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _guardOparentTree :: (InfoTree)
            _guardOpatternMatchWarnings :: ([Warning])
            _guardOsubstitution :: (FixpointSubstitution)
            _guardOtryPatterns :: ([(Expression     , [String])])
            _guardOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _guardOuniqueChunk :: (Int)
            _guardOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _guardIassumptions,_guardIbeta,_guardIbetaUnique,_guardIcollectErrors,_guardIcollectInstances,_guardIcollectWarnings,_guardIconstraints,_guardIdictionaryEnvironment,_guardIinfoTree,_guardImatchIO,_guardImatches,_guardIpatternMatchWarnings,_guardIself,_guardIunboundNames,_guardIuniqueChunk,_guardIuniqueSecondRound) =
                (guard_ (_guardOallPatterns)
                        (_guardOallTypeSchemes)
                        (_guardOavailablePredicates)
                        (_guardObetaUnique)
                        (_guardOclassEnvironment)
                        (_guardOcollectErrors)
                        (_guardOcollectWarnings)
                        (_guardOcurrentChunk)
                        (_guardOdictionaryEnvironment)
                        (_guardOimportEnvironment)
                        (_guardOmatchIO)
                        (_guardOmonos)
                        (_guardOnamesInScope)
                        (_guardOorderedTypeSynonyms)
                        (_guardOparentTree)
                        (_guardOpatternMatchWarnings)
                        (_guardOsubstitution)
                        (_guardOtryPatterns)
                        (_guardOtypeschemeMap)
                        (_guardOuniqueChunk)
                        (_guardOuniqueSecondRound))
            (_newcon@_) =
                [ (_guardIbeta .==. boolType) _cinfo ]
            (_locConstraints@_) =
                Node [ _newcon .<. _guardIconstraints
                     , _lhsIconstraints
                     ]
            (_lhsOconstraints@_) =
                _locConstraints
            (_lhsOassumptions@_) =
                _lhsIassumptions `combine` _guardIassumptions
            (_cinfo@_) =
                orphanConstraint 0 "boolean qualifier" _parentTree
                   []
            (_localInfo@_) =
                LocalInfo { self = UHA_Qual _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo [_guardIinfoTree]
            (_lhsOunboundNames@_) =
                _guardIunboundNames ++ _lhsIunboundNames
            (_guardOtryPatterns@_) =
                []
            (_lhsOcollectInstances@_) =
                _guardIcollectInstances
            (_self@_) =
                Qualifier_Guard _rangeIself _guardIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _guardIbetaUnique
            (_lhsOcollectErrors@_) =
                _guardIcollectErrors
            (_lhsOcollectWarnings@_) =
                _guardIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _guardIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _guardImatchIO
            (_lhsOmonos@_) =
                _lhsImonos
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOpatternMatchWarnings@_) =
                _guardIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _guardIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _guardIuniqueSecondRound
            (_guardOallPatterns@_) =
                _lhsIallPatterns
            (_guardOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_guardOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_guardObetaUnique@_) =
                _lhsIbetaUnique
            (_guardOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_guardOcollectErrors@_) =
                _lhsIcollectErrors
            (_guardOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_guardOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_guardOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_guardOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_guardOmatchIO@_) =
                _lhsImatchIO
            (_guardOmonos@_) =
                _lhsImonos
            (_guardOnamesInScope@_) =
                _lhsInamesInScope
            (_guardOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_guardOparentTree@_) =
                _parentTree
            (_guardOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_guardOsubstitution@_) =
                _lhsIsubstitution
            (_guardOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_guardOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_guardOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmonos,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Qualifier_Let :: (T_Range) ->
                     (T_Declarations) ->
                     (T_Qualifier)
sem_Qualifier_Let (range_) (declarations_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmonos :: (Monos)
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Qualifier)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _declarationsIbetaUnique :: (Int)
            _declarationsIbindingGroups :: (BindingGroups)
            _declarationsIcollectErrors :: (TypeErrors)
            _declarationsIcollectInstances :: ([(Name, Instance)])
            _declarationsIcollectWarnings :: (Warnings)
            _declarationsIdeclVarNames :: (Names)
            _declarationsIdictionaryEnvironment :: (DictionaryEnvironment)
            _declarationsIinfoTrees :: (InfoTrees)
            _declarationsImatchIO :: (IO ())
            _declarationsIpatternMatchWarnings :: ([Warning])
            _declarationsIrestrictedNames :: (Names)
            _declarationsIself :: (Declarations)
            _declarationsIsimplePatNames :: (Names)
            _declarationsItypeSignatures :: (TypeEnvironment)
            _declarationsIunboundNames :: (Names)
            _declarationsIuniqueChunk :: (Int)
            _declarationsOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _declarationsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _declarationsOavailablePredicates :: (Predicates)
            _declarationsObetaUnique :: (Int)
            _declarationsObindingGroups :: (BindingGroups)
            _declarationsOclassEnvironment :: (ClassEnvironment)
            _declarationsOcollectErrors :: (TypeErrors)
            _declarationsOcollectWarnings :: (Warnings)
            _declarationsOcurrentChunk :: (Int)
            _declarationsOdictionaryEnvironment :: (DictionaryEnvironment)
            _declarationsOimportEnvironment :: (ImportEnvironment)
            _declarationsOinheritedBDG :: (InheritedBDG)
            _declarationsOmatchIO :: (IO ())
            _declarationsOmonos :: (Monos)
            _declarationsOnamesInScope :: (Names)
            _declarationsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _declarationsOparentTree :: (InfoTree)
            _declarationsOpatternMatchWarnings :: ([Warning])
            _declarationsOsubstitution :: (FixpointSubstitution)
            _declarationsOtypeSignatures :: (TypeEnvironment)
            _declarationsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _declarationsOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _declarationsIbetaUnique
             ,_declarationsIbindingGroups
             ,_declarationsIcollectErrors
             ,_declarationsIcollectInstances
             ,_declarationsIcollectWarnings
             ,_declarationsIdeclVarNames
             ,_declarationsIdictionaryEnvironment
             ,_declarationsIinfoTrees
             ,_declarationsImatchIO
             ,_declarationsIpatternMatchWarnings
             ,_declarationsIrestrictedNames
             ,_declarationsIself
             ,_declarationsIsimplePatNames
             ,_declarationsItypeSignatures
             ,_declarationsIunboundNames
             ,_declarationsIuniqueChunk
             ) =
                (declarations_ (_declarationsOallPatterns)
                               (_declarationsOallTypeSchemes)
                               (_declarationsOavailablePredicates)
                               (_declarationsObetaUnique)
                               (_declarationsObindingGroups)
                               (_declarationsOclassEnvironment)
                               (_declarationsOcollectErrors)
                               (_declarationsOcollectWarnings)
                               (_declarationsOcurrentChunk)
                               (_declarationsOdictionaryEnvironment)
                               (_declarationsOimportEnvironment)
                               (_declarationsOinheritedBDG)
                               (_declarationsOmatchIO)
                               (_declarationsOmonos)
                               (_declarationsOnamesInScope)
                               (_declarationsOorderedTypeSynonyms)
                               (_declarationsOparentTree)
                               (_declarationsOpatternMatchWarnings)
                               (_declarationsOsubstitution)
                               (_declarationsOtypeSignatures)
                               (_declarationsOtypeschemeMap)
                               (_declarationsOuniqueChunk))
            ((_lhsOassumptions@_,_lhsOconstraints@_,_inheritedBDG@_,_chunkNr@_,_lhsObetaUnique@_,_implicitsFM@_)) =
                let inputBDG   = (False, _lhsIcurrentChunk, _declarationsIuniqueChunk, _lhsImonos, _declarationsItypeSignatures, mybdggroup, _declarationsIbetaUnique)
                    mybdggroup = Just (_lhsIassumptions, [_lhsIconstraints])
                in performBindingGroup inputBDG _declarationsIbindingGroups
            (_declarationsObindingGroups@_) =
                []
            (_lhsOcollectErrors@_) =
                restrictedNameErrors _inferredTypes _declarationsIrestrictedNames
                ++ _declarationsIcollectErrors
            (_lhsOcollectWarnings@_) =
                missingTypeSignature False _declarationsIsimplePatNames _inferredTypes
                ++ _declarationsIcollectWarnings
            (_inferredTypes@_) =
                findInferredTypes _lhsItypeschemeMap _implicitsFM
            (_localTypes@_) =
                makeLocalTypeEnv (_declarationsItypeSignatures `M.union` _inferredTypes) _declarationsIbindingGroups
            (_allTypeSchemes@_) =
                _localTypes `M.union` _lhsIallTypeSchemes
            (_declarationsOtypeSignatures@_) =
                M.empty
            (_lhsOuniqueChunk@_) =
                _chunkNr
            (_localInfo@_) =
                LocalInfo { self = UHA_Qual _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_declInfo@_) =
                LocalInfo { self = UHA_Decls _declarationsIself
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_declarationsOparentTree@_) =
                _declTree
            (_lhsOinfoTree@_) =
                _thisTree
            (_declTree@_) =
                node _thisTree _declInfo _declarationsIinfoTrees
            (_thisTree@_) =
                node _lhsIparentTree _localInfo [_declTree]
            ((_collectTypeConstructors@_,_collectValueConstructors@_,_collectTypeSynonyms@_,_collectConstructorEnv@_,_derivedFunctions@_,_operatorFixities@_)) =
                internalError "PartialSyntax.ag" "n/a" "toplevel Qualifier"
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _declarationsIdeclVarNames (_declarationsIunboundNames ++ _lhsIunboundNames) _lhsInamesInScope
            (_lhsOunboundNames@_) =
                _unboundNames
            (_lhsOcollectInstances@_) =
                _declarationsIcollectInstances
            (_self@_) =
                Qualifier_Let _rangeIself _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsOdictionaryEnvironment@_) =
                _declarationsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _declarationsImatchIO
            (_lhsOmonos@_) =
                _lhsImonos
            (_lhsOnamesInScope@_) =
                _namesInScope
            (_lhsOpatternMatchWarnings@_) =
                _declarationsIpatternMatchWarnings
            (_lhsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_declarationsOallPatterns@_) =
                _lhsIallPatterns
            (_declarationsOallTypeSchemes@_) =
                _allTypeSchemes
            (_declarationsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_declarationsObetaUnique@_) =
                _lhsIbetaUnique
            (_declarationsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_declarationsOcollectErrors@_) =
                _lhsIcollectErrors
            (_declarationsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_declarationsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_declarationsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_declarationsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_declarationsOinheritedBDG@_) =
                _inheritedBDG
            (_declarationsOmatchIO@_) =
                _lhsImatchIO
            (_declarationsOmonos@_) =
                _lhsImonos
            (_declarationsOnamesInScope@_) =
                _namesInScope
            (_declarationsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_declarationsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_declarationsOsubstitution@_) =
                _lhsIsubstitution
            (_declarationsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_declarationsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTree,_lhsOmatchIO,_lhsOmonos,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
-- Qualifiers --------------------------------------------------
-- semantic domain
type T_Qualifiers = ([((Expression, [String]), Core_TypingStrategy)]) ->
                    (M.Map NameWithRange TpScheme) ->
                    (Assumptions) ->
                    (Predicates) ->
                    (Int) ->
                    (ClassEnvironment) ->
                    (TypeErrors) ->
                    (Warnings) ->
                    (ConstraintSet) ->
                    (Int) ->
                    (DictionaryEnvironment) ->
                    (ImportEnvironment) ->
                    (IO ()) ->
                    (Monos) ->
                    (Names) ->
                    (OrderedTypeSynonyms) ->
                    (InfoTree) ->
                    ([Warning]) ->
                    (FixpointSubstitution) ->
                    (M.Map Int (Scheme Predicates)) ->
                    (Names) ->
                    (Int) ->
                    (Int) ->
                    ( (Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(DictionaryEnvironment),(InfoTrees),(IO ()),(Monos),(Names),([Warning]),(Qualifiers),(Names),(Int),(Int))
-- cata
sem_Qualifiers :: (Qualifiers) ->
                  (T_Qualifiers)
sem_Qualifiers (list) =
    (Prelude.foldr (sem_Qualifiers_Cons) (sem_Qualifiers_Nil) ((Prelude.map sem_Qualifier list)))
sem_Qualifiers_Cons :: (T_Qualifier) ->
                       (T_Qualifiers) ->
                       (T_Qualifiers)
sem_Qualifiers_Cons (hd_) (tl_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOmonos :: (Monos)
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Qualifiers)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _hdIassumptions :: (Assumptions)
            _hdIbetaUnique :: (Int)
            _hdIcollectErrors :: (TypeErrors)
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectWarnings :: (Warnings)
            _hdIconstraints :: (ConstraintSet)
            _hdIdictionaryEnvironment :: (DictionaryEnvironment)
            _hdIinfoTree :: (InfoTree)
            _hdImatchIO :: (IO ())
            _hdImonos :: (Monos)
            _hdInamesInScope :: (Names)
            _hdIpatternMatchWarnings :: ([Warning])
            _hdIself :: (Qualifier)
            _hdIunboundNames :: (Names)
            _hdIuniqueChunk :: (Int)
            _hdIuniqueSecondRound :: (Int)
            _hdOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _hdOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _hdOassumptions :: (Assumptions)
            _hdOavailablePredicates :: (Predicates)
            _hdObetaUnique :: (Int)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectErrors :: (TypeErrors)
            _hdOcollectWarnings :: (Warnings)
            _hdOconstraints :: (ConstraintSet)
            _hdOcurrentChunk :: (Int)
            _hdOdictionaryEnvironment :: (DictionaryEnvironment)
            _hdOimportEnvironment :: (ImportEnvironment)
            _hdOmatchIO :: (IO ())
            _hdOmonos :: (Monos)
            _hdOnamesInScope :: (Names)
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOparentTree :: (InfoTree)
            _hdOpatternMatchWarnings :: ([Warning])
            _hdOsubstitution :: (FixpointSubstitution)
            _hdOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _hdOunboundNames :: (Names)
            _hdOuniqueChunk :: (Int)
            _hdOuniqueSecondRound :: (Int)
            _tlIassumptions :: (Assumptions)
            _tlIbetaUnique :: (Int)
            _tlIcollectErrors :: (TypeErrors)
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectWarnings :: (Warnings)
            _tlIconstraints :: (ConstraintSet)
            _tlIdictionaryEnvironment :: (DictionaryEnvironment)
            _tlIinfoTrees :: (InfoTrees)
            _tlImatchIO :: (IO ())
            _tlImonos :: (Monos)
            _tlInamesInScope :: (Names)
            _tlIpatternMatchWarnings :: ([Warning])
            _tlIself :: (Qualifiers)
            _tlIunboundNames :: (Names)
            _tlIuniqueChunk :: (Int)
            _tlIuniqueSecondRound :: (Int)
            _tlOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _tlOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _tlOassumptions :: (Assumptions)
            _tlOavailablePredicates :: (Predicates)
            _tlObetaUnique :: (Int)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectErrors :: (TypeErrors)
            _tlOcollectWarnings :: (Warnings)
            _tlOconstraints :: (ConstraintSet)
            _tlOcurrentChunk :: (Int)
            _tlOdictionaryEnvironment :: (DictionaryEnvironment)
            _tlOimportEnvironment :: (ImportEnvironment)
            _tlOmatchIO :: (IO ())
            _tlOmonos :: (Monos)
            _tlOnamesInScope :: (Names)
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOparentTree :: (InfoTree)
            _tlOpatternMatchWarnings :: ([Warning])
            _tlOsubstitution :: (FixpointSubstitution)
            _tlOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _tlOunboundNames :: (Names)
            _tlOuniqueChunk :: (Int)
            _tlOuniqueSecondRound :: (Int)
            ( _hdIassumptions,_hdIbetaUnique,_hdIcollectErrors,_hdIcollectInstances,_hdIcollectWarnings,_hdIconstraints,_hdIdictionaryEnvironment,_hdIinfoTree,_hdImatchIO,_hdImonos,_hdInamesInScope,_hdIpatternMatchWarnings,_hdIself,_hdIunboundNames,_hdIuniqueChunk,_hdIuniqueSecondRound) =
                (hd_ (_hdOallPatterns)
                     (_hdOallTypeSchemes)
                     (_hdOassumptions)
                     (_hdOavailablePredicates)
                     (_hdObetaUnique)
                     (_hdOclassEnvironment)
                     (_hdOcollectErrors)
                     (_hdOcollectWarnings)
                     (_hdOconstraints)
                     (_hdOcurrentChunk)
                     (_hdOdictionaryEnvironment)
                     (_hdOimportEnvironment)
                     (_hdOmatchIO)
                     (_hdOmonos)
                     (_hdOnamesInScope)
                     (_hdOorderedTypeSynonyms)
                     (_hdOparentTree)
                     (_hdOpatternMatchWarnings)
                     (_hdOsubstitution)
                     (_hdOtypeschemeMap)
                     (_hdOunboundNames)
                     (_hdOuniqueChunk)
                     (_hdOuniqueSecondRound))
            ( _tlIassumptions,_tlIbetaUnique,_tlIcollectErrors,_tlIcollectInstances,_tlIcollectWarnings,_tlIconstraints,_tlIdictionaryEnvironment,_tlIinfoTrees,_tlImatchIO,_tlImonos,_tlInamesInScope,_tlIpatternMatchWarnings,_tlIself,_tlIunboundNames,_tlIuniqueChunk,_tlIuniqueSecondRound) =
                (tl_ (_tlOallPatterns)
                     (_tlOallTypeSchemes)
                     (_tlOassumptions)
                     (_tlOavailablePredicates)
                     (_tlObetaUnique)
                     (_tlOclassEnvironment)
                     (_tlOcollectErrors)
                     (_tlOcollectWarnings)
                     (_tlOconstraints)
                     (_tlOcurrentChunk)
                     (_tlOdictionaryEnvironment)
                     (_tlOimportEnvironment)
                     (_tlOmatchIO)
                     (_tlOmonos)
                     (_tlOnamesInScope)
                     (_tlOorderedTypeSynonyms)
                     (_tlOparentTree)
                     (_tlOpatternMatchWarnings)
                     (_tlOsubstitution)
                     (_tlOtypeschemeMap)
                     (_tlOunboundNames)
                     (_tlOuniqueChunk)
                     (_tlOuniqueSecondRound))
            (_tlOconstraints@_) =
                _lhsIconstraints
            (_tlOassumptions@_) =
                _lhsIassumptions
            (_hdOconstraints@_) =
                _tlIconstraints
            (_hdOassumptions@_) =
                _tlIassumptions
            (_lhsOconstraints@_) =
                _hdIconstraints
            (_lhsOassumptions@_) =
                _hdIassumptions
            (_lhsOinfoTrees@_) =
                _hdIinfoTree : _tlIinfoTrees
            (_hdOunboundNames@_) =
                _tlIunboundNames
            (_tlOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOunboundNames@_) =
                _hdIunboundNames
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _tlIbetaUnique
            (_lhsOcollectErrors@_) =
                _tlIcollectErrors
            (_lhsOcollectWarnings@_) =
                _tlIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _tlIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _tlImatchIO
            (_lhsOmonos@_) =
                _tlImonos
            (_lhsOnamesInScope@_) =
                _tlInamesInScope
            (_lhsOpatternMatchWarnings@_) =
                _tlIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _tlIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _tlIuniqueSecondRound
            (_hdOallPatterns@_) =
                _lhsIallPatterns
            (_hdOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_hdOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_hdObetaUnique@_) =
                _lhsIbetaUnique
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectErrors@_) =
                _lhsIcollectErrors
            (_hdOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_hdOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_hdOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_hdOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_hdOmatchIO@_) =
                _lhsImatchIO
            (_hdOmonos@_) =
                _lhsImonos
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOparentTree@_) =
                _lhsIparentTree
            (_hdOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_hdOsubstitution@_) =
                _lhsIsubstitution
            (_hdOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_hdOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_hdOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_tlOallPatterns@_) =
                _lhsIallPatterns
            (_tlOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_tlOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_tlObetaUnique@_) =
                _hdIbetaUnique
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectErrors@_) =
                _hdIcollectErrors
            (_tlOcollectWarnings@_) =
                _hdIcollectWarnings
            (_tlOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_tlOdictionaryEnvironment@_) =
                _hdIdictionaryEnvironment
            (_tlOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_tlOmatchIO@_) =
                _hdImatchIO
            (_tlOmonos@_) =
                _hdImonos
            (_tlOnamesInScope@_) =
                _hdInamesInScope
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOparentTree@_) =
                _lhsIparentTree
            (_tlOpatternMatchWarnings@_) =
                _hdIpatternMatchWarnings
            (_tlOsubstitution@_) =
                _lhsIsubstitution
            (_tlOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_tlOuniqueChunk@_) =
                _hdIuniqueChunk
            (_tlOuniqueSecondRound@_) =
                _hdIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOmonos,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Qualifiers_Nil :: (T_Qualifiers)
sem_Qualifiers_Nil  =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOmonos :: (Monos)
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Qualifiers)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            (_lhsOinfoTrees@_) =
                []
            (_lhsOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _lhsIassumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOconstraints@_) =
                _lhsIconstraints
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOmonos@_) =
                _lhsImonos
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOinfoTrees,_lhsOmatchIO,_lhsOmonos,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
-- Range -------------------------------------------------------
-- semantic domain
type T_Range = ( (Range))
-- cata
sem_Range :: (Range) ->
             (T_Range)
sem_Range ((Range_Range (_start) (_stop))) =
    (sem_Range_Range ((sem_Position (_start))) ((sem_Position (_stop))))
sem_Range_Range :: (T_Position) ->
                   (T_Position) ->
                   (T_Range)
sem_Range_Range (start_) (stop_) =
    let _lhsOself :: (Range)
        _startIself :: (Position)
        _stopIself :: (Position)
        ( _startIself) =
            (start_ )
        ( _stopIself) =
            (stop_ )
        (_self@_) =
            Range_Range _startIself _stopIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- RecordExpressionBinding -------------------------------------
-- semantic domain
type T_RecordExpressionBinding = (M.Map NameWithRange TpScheme) ->
                                 (Predicates) ->
                                 (ClassEnvironment) ->
                                 (TypeErrors) ->
                                 (Warnings) ->
                                 (Int) ->
                                 (DictionaryEnvironment) ->
                                 (ImportEnvironment) ->
                                 (Names) ->
                                 (OrderedTypeSynonyms) ->
                                 ([Warning]) ->
                                 (FixpointSubstitution) ->
                                 (M.Map Int (Scheme Predicates)) ->
                                 (Int) ->
                                 ( (TypeErrors),([(Name, Instance)]),(Warnings),(DictionaryEnvironment),([Warning]),(RecordExpressionBinding),(Names),(Int))
-- cata
sem_RecordExpressionBinding :: (RecordExpressionBinding) ->
                               (T_RecordExpressionBinding)
sem_RecordExpressionBinding ((RecordExpressionBinding_RecordExpressionBinding (_range) (_name) (_expression))) =
    (sem_RecordExpressionBinding_RecordExpressionBinding ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Expression (_expression))))
sem_RecordExpressionBinding_RecordExpressionBinding :: (T_Range) ->
                                                       (T_Name) ->
                                                       (T_Expression) ->
                                                       (T_RecordExpressionBinding)
sem_RecordExpressionBinding_RecordExpressionBinding (range_) (name_) (expression_) =
    \ _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (RecordExpressionBinding)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            (_parentTree@_) =
                globalInfoError
            ((_monos@_,_constructorenv@_,_betaUnique@_,_miscerrors@_,_warnings@_,_kindErrors@_,_valueConstructors@_,_allValueConstructors@_,_typeConstructors@_,_allTypeConstructors@_,_importEnvironment@_)) =
                internalError "PartialSyntax.ag" "n/a" "RecordExpressionBinding.RecordExpressionBinding"
            ((_allPatterns@_,_tryPatterns@_,_matchIO@_,_uniqueSecondRound@_)) =
                internalError "TS_PatternMatching.ag" "n/a" "RecordExpressionBinding is not supported"
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_lhsOunboundNames@_) =
                _expressionIunboundNames
            (_self@_) =
                RecordExpressionBinding_RecordExpressionBinding _rangeIself _nameIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectErrors@_) =
                _expressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_lhsOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_expressionOallPatterns@_) =
                _allPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionObetaUnique@_) =
                _betaUnique
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _importEnvironment
            (_expressionOmatchIO@_) =
                _matchIO
            (_expressionOmonos@_) =
                _monos
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _parentTree
            (_expressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtryPatterns@_) =
                _tryPatterns
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _uniqueSecondRound
        in  ( _lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdictionaryEnvironment,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk)
-- RecordExpressionBindings ------------------------------------
-- semantic domain
type T_RecordExpressionBindings = (M.Map NameWithRange TpScheme) ->
                                  (Predicates) ->
                                  (ClassEnvironment) ->
                                  (TypeErrors) ->
                                  (Warnings) ->
                                  (Int) ->
                                  (DictionaryEnvironment) ->
                                  (ImportEnvironment) ->
                                  (Names) ->
                                  (OrderedTypeSynonyms) ->
                                  ([Warning]) ->
                                  (FixpointSubstitution) ->
                                  (M.Map Int (Scheme Predicates)) ->
                                  (Int) ->
                                  ( (TypeErrors),([(Name, Instance)]),(Warnings),(DictionaryEnvironment),([Warning]),(RecordExpressionBindings),(Names),(Int))
-- cata
sem_RecordExpressionBindings :: (RecordExpressionBindings) ->
                                (T_RecordExpressionBindings)
sem_RecordExpressionBindings (list) =
    (Prelude.foldr (sem_RecordExpressionBindings_Cons) (sem_RecordExpressionBindings_Nil) ((Prelude.map sem_RecordExpressionBinding list)))
sem_RecordExpressionBindings_Cons :: (T_RecordExpressionBinding) ->
                                     (T_RecordExpressionBindings) ->
                                     (T_RecordExpressionBindings)
sem_RecordExpressionBindings_Cons (hd_) (tl_) =
    \ _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (RecordExpressionBindings)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _hdIcollectErrors :: (TypeErrors)
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectWarnings :: (Warnings)
            _hdIdictionaryEnvironment :: (DictionaryEnvironment)
            _hdIpatternMatchWarnings :: ([Warning])
            _hdIself :: (RecordExpressionBinding)
            _hdIunboundNames :: (Names)
            _hdIuniqueChunk :: (Int)
            _hdOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _hdOavailablePredicates :: (Predicates)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectErrors :: (TypeErrors)
            _hdOcollectWarnings :: (Warnings)
            _hdOcurrentChunk :: (Int)
            _hdOdictionaryEnvironment :: (DictionaryEnvironment)
            _hdOimportEnvironment :: (ImportEnvironment)
            _hdOnamesInScope :: (Names)
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOpatternMatchWarnings :: ([Warning])
            _hdOsubstitution :: (FixpointSubstitution)
            _hdOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _hdOuniqueChunk :: (Int)
            _tlIcollectErrors :: (TypeErrors)
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectWarnings :: (Warnings)
            _tlIdictionaryEnvironment :: (DictionaryEnvironment)
            _tlIpatternMatchWarnings :: ([Warning])
            _tlIself :: (RecordExpressionBindings)
            _tlIunboundNames :: (Names)
            _tlIuniqueChunk :: (Int)
            _tlOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _tlOavailablePredicates :: (Predicates)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectErrors :: (TypeErrors)
            _tlOcollectWarnings :: (Warnings)
            _tlOcurrentChunk :: (Int)
            _tlOdictionaryEnvironment :: (DictionaryEnvironment)
            _tlOimportEnvironment :: (ImportEnvironment)
            _tlOnamesInScope :: (Names)
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOpatternMatchWarnings :: ([Warning])
            _tlOsubstitution :: (FixpointSubstitution)
            _tlOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _tlOuniqueChunk :: (Int)
            ( _hdIcollectErrors,_hdIcollectInstances,_hdIcollectWarnings,_hdIdictionaryEnvironment,_hdIpatternMatchWarnings,_hdIself,_hdIunboundNames,_hdIuniqueChunk) =
                (hd_ (_hdOallTypeSchemes) (_hdOavailablePredicates) (_hdOclassEnvironment) (_hdOcollectErrors) (_hdOcollectWarnings) (_hdOcurrentChunk) (_hdOdictionaryEnvironment) (_hdOimportEnvironment) (_hdOnamesInScope) (_hdOorderedTypeSynonyms) (_hdOpatternMatchWarnings) (_hdOsubstitution) (_hdOtypeschemeMap) (_hdOuniqueChunk))
            ( _tlIcollectErrors,_tlIcollectInstances,_tlIcollectWarnings,_tlIdictionaryEnvironment,_tlIpatternMatchWarnings,_tlIself,_tlIunboundNames,_tlIuniqueChunk) =
                (tl_ (_tlOallTypeSchemes) (_tlOavailablePredicates) (_tlOclassEnvironment) (_tlOcollectErrors) (_tlOcollectWarnings) (_tlOcurrentChunk) (_tlOdictionaryEnvironment) (_tlOimportEnvironment) (_tlOnamesInScope) (_tlOorderedTypeSynonyms) (_tlOpatternMatchWarnings) (_tlOsubstitution) (_tlOtypeschemeMap) (_tlOuniqueChunk))
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOcollectErrors@_) =
                _tlIcollectErrors
            (_lhsOcollectWarnings@_) =
                _tlIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _tlIdictionaryEnvironment
            (_lhsOpatternMatchWarnings@_) =
                _tlIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _tlIuniqueChunk
            (_hdOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_hdOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectErrors@_) =
                _lhsIcollectErrors
            (_hdOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_hdOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_hdOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_hdOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_hdOsubstitution@_) =
                _lhsIsubstitution
            (_hdOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_hdOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_tlOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_tlOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectErrors@_) =
                _hdIcollectErrors
            (_tlOcollectWarnings@_) =
                _hdIcollectWarnings
            (_tlOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_tlOdictionaryEnvironment@_) =
                _hdIdictionaryEnvironment
            (_tlOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOpatternMatchWarnings@_) =
                _hdIpatternMatchWarnings
            (_tlOsubstitution@_) =
                _lhsIsubstitution
            (_tlOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_tlOuniqueChunk@_) =
                _hdIuniqueChunk
        in  ( _lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdictionaryEnvironment,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk)
sem_RecordExpressionBindings_Nil :: (T_RecordExpressionBindings)
sem_RecordExpressionBindings_Nil  =
    \ _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (RecordExpressionBindings)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            (_lhsOcollectInstances@_) =
                []
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOdictionaryEnvironment,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk)
-- RecordPatternBinding ----------------------------------------
-- semantic domain
type T_RecordPatternBinding = (Names) ->
                              ([Warning]) ->
                              ( ([Warning]),(RecordPatternBinding),(Names))
-- cata
sem_RecordPatternBinding :: (RecordPatternBinding) ->
                            (T_RecordPatternBinding)
sem_RecordPatternBinding ((RecordPatternBinding_RecordPatternBinding (_range) (_name) (_pattern))) =
    (sem_RecordPatternBinding_RecordPatternBinding ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Pattern (_pattern))))
sem_RecordPatternBinding_RecordPatternBinding :: (T_Range) ->
                                                 (T_Name) ->
                                                 (T_Pattern) ->
                                                 (T_RecordPatternBinding)
sem_RecordPatternBinding_RecordPatternBinding (range_) (name_) (pattern_) =
    \ _lhsInamesInScope
      _lhsIpatternMatchWarnings ->
        let _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (RecordPatternBinding)
            _lhsOunboundNames :: (Names)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _patternIbeta :: (Tp)
            _patternIbetaUnique :: (Int)
            _patternIconstraints :: (ConstraintSet)
            _patternIelements :: (  [PatternElement]        )
            _patternIenvironment :: (PatternAssumptions)
            _patternIinfoTree :: (InfoTree)
            _patternIpatVarNames :: (Names)
            _patternIpatternMatchWarnings :: ([Warning])
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternObetaUnique :: (Int)
            _patternOimportEnvironment :: (ImportEnvironment)
            _patternOmonos :: (Monos)
            _patternOnamesInScope :: (Names)
            _patternOparentTree :: (InfoTree)
            _patternOpatternMatchWarnings :: ([Warning])
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _patternIbeta,_patternIbetaUnique,_patternIconstraints,_patternIelements,_patternIenvironment,_patternIinfoTree,_patternIpatVarNames,_patternIpatternMatchWarnings,_patternIself,_patternIunboundNames) =
                (pattern_ (_patternObetaUnique) (_patternOimportEnvironment) (_patternOmonos) (_patternOnamesInScope) (_patternOparentTree) (_patternOpatternMatchWarnings))
            (_parentTree@_) =
                globalInfoError
            ((_monos@_,_constructorenv@_,_betaUnique@_,_miscerrors@_,_warnings@_,_valueConstructors@_,_allValueConstructors@_,_typeConstructors@_,_allTypeConstructors@_,_importEnvironment@_)) =
                internalError "PartialSyntax.ag" "n/a" "RecordPatternBinding.RecordPatternBinding"
            (_lhsOunboundNames@_) =
                _patternIunboundNames
            (_self@_) =
                RecordPatternBinding_RecordPatternBinding _rangeIself _nameIself _patternIself
            (_lhsOself@_) =
                _self
            (_lhsOpatternMatchWarnings@_) =
                _patternIpatternMatchWarnings
            (_patternObetaUnique@_) =
                _betaUnique
            (_patternOimportEnvironment@_) =
                _importEnvironment
            (_patternOmonos@_) =
                _monos
            (_patternOnamesInScope@_) =
                _lhsInamesInScope
            (_patternOparentTree@_) =
                _parentTree
            (_patternOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
-- RecordPatternBindings ---------------------------------------
-- semantic domain
type T_RecordPatternBindings = (Names) ->
                               ([Warning]) ->
                               ( ([Warning]),(RecordPatternBindings),(Names))
-- cata
sem_RecordPatternBindings :: (RecordPatternBindings) ->
                             (T_RecordPatternBindings)
sem_RecordPatternBindings (list) =
    (Prelude.foldr (sem_RecordPatternBindings_Cons) (sem_RecordPatternBindings_Nil) ((Prelude.map sem_RecordPatternBinding list)))
sem_RecordPatternBindings_Cons :: (T_RecordPatternBinding) ->
                                  (T_RecordPatternBindings) ->
                                  (T_RecordPatternBindings)
sem_RecordPatternBindings_Cons (hd_) (tl_) =
    \ _lhsInamesInScope
      _lhsIpatternMatchWarnings ->
        let _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (RecordPatternBindings)
            _lhsOunboundNames :: (Names)
            _hdIpatternMatchWarnings :: ([Warning])
            _hdIself :: (RecordPatternBinding)
            _hdIunboundNames :: (Names)
            _hdOnamesInScope :: (Names)
            _hdOpatternMatchWarnings :: ([Warning])
            _tlIpatternMatchWarnings :: ([Warning])
            _tlIself :: (RecordPatternBindings)
            _tlIunboundNames :: (Names)
            _tlOnamesInScope :: (Names)
            _tlOpatternMatchWarnings :: ([Warning])
            ( _hdIpatternMatchWarnings,_hdIself,_hdIunboundNames) =
                (hd_ (_hdOnamesInScope) (_hdOpatternMatchWarnings))
            ( _tlIpatternMatchWarnings,_tlIself,_tlIunboundNames) =
                (tl_ (_tlOnamesInScope) (_tlOpatternMatchWarnings))
            (_lhsOunboundNames@_) =
                _hdIunboundNames ++ _tlIunboundNames
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOpatternMatchWarnings@_) =
                _tlIpatternMatchWarnings
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_tlOnamesInScope@_) =
                _lhsInamesInScope
            (_tlOpatternMatchWarnings@_) =
                _hdIpatternMatchWarnings
        in  ( _lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
sem_RecordPatternBindings_Nil :: (T_RecordPatternBindings)
sem_RecordPatternBindings_Nil  =
    \ _lhsInamesInScope
      _lhsIpatternMatchWarnings ->
        let _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (RecordPatternBindings)
            _lhsOunboundNames :: (Names)
            (_lhsOunboundNames@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
        in  ( _lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames)
-- RightHandSide -----------------------------------------------
-- semantic domain
type T_RightHandSide = ([((Expression, [String]), Core_TypingStrategy)]) ->
                       (M.Map NameWithRange TpScheme) ->
                       (Predicates) ->
                       (Tp) ->
                       (Int) ->
                       (ClassEnvironment) ->
                       (TypeErrors) ->
                       (Warnings) ->
                       (Int) ->
                       (DictionaryEnvironment) ->
                       (ImportEnvironment) ->
                       (IO ()) ->
                       (Monos) ->
                       (Names) ->
                       (OrderedTypeSynonyms) ->
                       (InfoTree) ->
                       ([Warning]) ->
                       (FixpointSubstitution) ->
                       (M.Map Int (Scheme Predicates)) ->
                       (Int) ->
                       ( (Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(DictionaryEnvironment),(Bool),(InfoTree),(IO ()),([Warning]),(RightHandSide),(Names),(Int))
-- cata
sem_RightHandSide :: (RightHandSide) ->
                     (T_RightHandSide)
sem_RightHandSide ((RightHandSide_Expression (_range) (_expression) (_where))) =
    (sem_RightHandSide_Expression ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_MaybeDeclarations (_where))))
sem_RightHandSide ((RightHandSide_Guarded (_range) (_guardedexpressions) (_where))) =
    (sem_RightHandSide_Guarded ((sem_Range (_range))) ((sem_GuardedExpressions (_guardedexpressions))) ((sem_MaybeDeclarations (_where))))
sem_RightHandSide_Expression :: (T_Range) ->
                                (T_Expression) ->
                                (T_MaybeDeclarations) ->
                                (T_RightHandSide)
sem_RightHandSide_Expression (range_) (expression_) (where_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOfallthrough :: (Bool)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (RightHandSide)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            _whereIassumptions :: (Assumptions)
            _whereIbetaUnique :: (Int)
            _whereIcollectErrors :: (TypeErrors)
            _whereIcollectInstances :: ([(Name, Instance)])
            _whereIcollectWarnings :: (Warnings)
            _whereIconstraints :: (ConstraintSet)
            _whereIdictionaryEnvironment :: (DictionaryEnvironment)
            _whereIinfoTrees :: (InfoTrees)
            _whereIlocalTypes :: (M.Map NameWithRange TpScheme)
            _whereImatchIO :: (IO ())
            _whereInamesInScope :: (Names)
            _whereIpatternMatchWarnings :: ([Warning])
            _whereIself :: (MaybeDeclarations)
            _whereIunboundNames :: (Names)
            _whereIuniqueChunk :: (Int)
            _whereOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _whereOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _whereOassumptions :: (Assumptions)
            _whereOavailablePredicates :: (Predicates)
            _whereObetaUnique :: (Int)
            _whereOclassEnvironment :: (ClassEnvironment)
            _whereOcollectErrors :: (TypeErrors)
            _whereOcollectWarnings :: (Warnings)
            _whereOconstraints :: (ConstraintSet)
            _whereOcurrentChunk :: (Int)
            _whereOdictionaryEnvironment :: (DictionaryEnvironment)
            _whereOimportEnvironment :: (ImportEnvironment)
            _whereOmatchIO :: (IO ())
            _whereOmonos :: (Monos)
            _whereOnamesInScope :: (Names)
            _whereOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _whereOparentTree :: (InfoTree)
            _whereOpatternMatchWarnings :: ([Warning])
            _whereOsubstitution :: (FixpointSubstitution)
            _whereOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _whereOunboundNames :: (Names)
            _whereOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            ( _whereIassumptions,_whereIbetaUnique,_whereIcollectErrors,_whereIcollectInstances,_whereIcollectWarnings,_whereIconstraints,_whereIdictionaryEnvironment,_whereIinfoTrees,_whereIlocalTypes,_whereImatchIO,_whereInamesInScope,_whereIpatternMatchWarnings,_whereIself,_whereIunboundNames,_whereIuniqueChunk) =
                (where_ (_whereOallPatterns)
                        (_whereOallTypeSchemes)
                        (_whereOassumptions)
                        (_whereOavailablePredicates)
                        (_whereObetaUnique)
                        (_whereOclassEnvironment)
                        (_whereOcollectErrors)
                        (_whereOcollectWarnings)
                        (_whereOconstraints)
                        (_whereOcurrentChunk)
                        (_whereOdictionaryEnvironment)
                        (_whereOimportEnvironment)
                        (_whereOmatchIO)
                        (_whereOmonos)
                        (_whereOnamesInScope)
                        (_whereOorderedTypeSynonyms)
                        (_whereOparentTree)
                        (_whereOpatternMatchWarnings)
                        (_whereOsubstitution)
                        (_whereOtypeschemeMap)
                        (_whereOunboundNames)
                        (_whereOuniqueChunk))
            (_newcon@_) =
                [ (_expressionIbeta .==. _lhsIbetaRight) _cinfo ]
            (_whereOconstraints@_) =
                _newcon .>. _expressionIconstraints
            (_whereOassumptions@_) =
                _expressionIassumptions
            (_lhsOconstraints@_) =
                _whereIconstraints
            (_lhsOassumptions@_) =
                _whereIassumptions
            (_allTypeSchemes@_) =
                _whereIlocalTypes `M.union` _lhsIallTypeSchemes
            (_cinfo@_) =
                orphanConstraint 0 "right-hand side" _parentTree
                   [ Unifier (head (ftv _lhsIbetaRight)) ("right-hand sides", attribute (skip_UHA_FB_RHS _lhsIparentTree), "right-hand side") ]
            (_localInfo@_) =
                LocalInfo { self = UHA_RHS _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo (_expressionIinfoTree : _whereIinfoTrees)
            (_whereOunboundNames@_) =
                _expressionIunboundNames
            (_expressionOnamesInScope@_) =
                _whereInamesInScope
            (_lhsOunboundNames@_) =
                _whereIunboundNames
            (_whereObetaUnique@_) =
                _expressionIuniqueSecondRound
            (_expressionOuniqueSecondRound@_) =
                _expressionIbetaUnique
            (_expressionOtryPatterns@_) =
                []
            (_lhsOfallthrough@_) =
                False
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances  ++  _whereIcollectInstances
            (_self@_) =
                RightHandSide_Expression _rangeIself _expressionIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _whereIbetaUnique
            (_lhsOcollectErrors@_) =
                _whereIcollectErrors
            (_lhsOcollectWarnings@_) =
                _whereIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _whereIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _whereImatchIO
            (_lhsOpatternMatchWarnings@_) =
                _whereIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _whereIuniqueChunk
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _allTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionObetaUnique@_) =
                _lhsIbetaUnique
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _parentTree
            (_expressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_whereOallPatterns@_) =
                _lhsIallPatterns
            (_whereOallTypeSchemes@_) =
                _allTypeSchemes
            (_whereOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_whereOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_whereOcollectErrors@_) =
                _expressionIcollectErrors
            (_whereOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_whereOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_whereOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_whereOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_whereOmatchIO@_) =
                _expressionImatchIO
            (_whereOmonos@_) =
                _lhsImonos
            (_whereOnamesInScope@_) =
                _lhsInamesInScope
            (_whereOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_whereOparentTree@_) =
                _parentTree
            (_whereOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_whereOsubstitution@_) =
                _lhsIsubstitution
            (_whereOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_whereOuniqueChunk@_) =
                _expressionIuniqueChunk
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOfallthrough,_lhsOinfoTree,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk)
sem_RightHandSide_Guarded :: (T_Range) ->
                             (T_GuardedExpressions) ->
                             (T_MaybeDeclarations) ->
                             (T_RightHandSide)
sem_RightHandSide_Guarded (range_) (guardedexpressions_) (where_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIavailablePredicates
      _lhsIbetaRight
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIuniqueChunk ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOfallthrough :: (Bool)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (RightHandSide)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _rangeIself :: (Range)
            _guardedexpressionsIassumptions :: (Assumptions)
            _guardedexpressionsIbetaUnique :: (Int)
            _guardedexpressionsIcollectErrors :: (TypeErrors)
            _guardedexpressionsIcollectInstances :: ([(Name, Instance)])
            _guardedexpressionsIcollectWarnings :: (Warnings)
            _guardedexpressionsIconstraintslist :: (ConstraintSets)
            _guardedexpressionsIdictionaryEnvironment :: (DictionaryEnvironment)
            _guardedexpressionsIfallthrough :: (Bool)
            _guardedexpressionsIinfoTrees :: (InfoTrees)
            _guardedexpressionsImatchIO :: (IO ())
            _guardedexpressionsIpatternMatchWarnings :: ([Warning])
            _guardedexpressionsIself :: (GuardedExpressions)
            _guardedexpressionsIunboundNames :: (Names)
            _guardedexpressionsIuniqueChunk :: (Int)
            _guardedexpressionsIuniqueSecondRound :: (Int)
            _guardedexpressionsOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _guardedexpressionsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _guardedexpressionsOavailablePredicates :: (Predicates)
            _guardedexpressionsObetaRight :: (Tp)
            _guardedexpressionsObetaUnique :: (Int)
            _guardedexpressionsOclassEnvironment :: (ClassEnvironment)
            _guardedexpressionsOcollectErrors :: (TypeErrors)
            _guardedexpressionsOcollectWarnings :: (Warnings)
            _guardedexpressionsOcurrentChunk :: (Int)
            _guardedexpressionsOdictionaryEnvironment :: (DictionaryEnvironment)
            _guardedexpressionsOimportEnvironment :: (ImportEnvironment)
            _guardedexpressionsOmatchIO :: (IO ())
            _guardedexpressionsOmonos :: (Monos)
            _guardedexpressionsOnamesInScope :: (Names)
            _guardedexpressionsOnumberOfGuards :: (Int)
            _guardedexpressionsOopen :: (Bool)
            _guardedexpressionsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _guardedexpressionsOparentTree :: (InfoTree)
            _guardedexpressionsOpatternMatchWarnings :: ([Warning])
            _guardedexpressionsOsubstitution :: (FixpointSubstitution)
            _guardedexpressionsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _guardedexpressionsOuniqueChunk :: (Int)
            _guardedexpressionsOuniqueSecondRound :: (Int)
            _whereIassumptions :: (Assumptions)
            _whereIbetaUnique :: (Int)
            _whereIcollectErrors :: (TypeErrors)
            _whereIcollectInstances :: ([(Name, Instance)])
            _whereIcollectWarnings :: (Warnings)
            _whereIconstraints :: (ConstraintSet)
            _whereIdictionaryEnvironment :: (DictionaryEnvironment)
            _whereIinfoTrees :: (InfoTrees)
            _whereIlocalTypes :: (M.Map NameWithRange TpScheme)
            _whereImatchIO :: (IO ())
            _whereInamesInScope :: (Names)
            _whereIpatternMatchWarnings :: ([Warning])
            _whereIself :: (MaybeDeclarations)
            _whereIunboundNames :: (Names)
            _whereIuniqueChunk :: (Int)
            _whereOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _whereOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _whereOassumptions :: (Assumptions)
            _whereOavailablePredicates :: (Predicates)
            _whereObetaUnique :: (Int)
            _whereOclassEnvironment :: (ClassEnvironment)
            _whereOcollectErrors :: (TypeErrors)
            _whereOcollectWarnings :: (Warnings)
            _whereOconstraints :: (ConstraintSet)
            _whereOcurrentChunk :: (Int)
            _whereOdictionaryEnvironment :: (DictionaryEnvironment)
            _whereOimportEnvironment :: (ImportEnvironment)
            _whereOmatchIO :: (IO ())
            _whereOmonos :: (Monos)
            _whereOnamesInScope :: (Names)
            _whereOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _whereOparentTree :: (InfoTree)
            _whereOpatternMatchWarnings :: ([Warning])
            _whereOsubstitution :: (FixpointSubstitution)
            _whereOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _whereOunboundNames :: (Names)
            _whereOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _guardedexpressionsIassumptions
             ,_guardedexpressionsIbetaUnique
             ,_guardedexpressionsIcollectErrors
             ,_guardedexpressionsIcollectInstances
             ,_guardedexpressionsIcollectWarnings
             ,_guardedexpressionsIconstraintslist
             ,_guardedexpressionsIdictionaryEnvironment
             ,_guardedexpressionsIfallthrough
             ,_guardedexpressionsIinfoTrees
             ,_guardedexpressionsImatchIO
             ,_guardedexpressionsIpatternMatchWarnings
             ,_guardedexpressionsIself
             ,_guardedexpressionsIunboundNames
             ,_guardedexpressionsIuniqueChunk
             ,_guardedexpressionsIuniqueSecondRound
             ) =
                (guardedexpressions_ (_guardedexpressionsOallPatterns)
                                     (_guardedexpressionsOallTypeSchemes)
                                     (_guardedexpressionsOavailablePredicates)
                                     (_guardedexpressionsObetaRight)
                                     (_guardedexpressionsObetaUnique)
                                     (_guardedexpressionsOclassEnvironment)
                                     (_guardedexpressionsOcollectErrors)
                                     (_guardedexpressionsOcollectWarnings)
                                     (_guardedexpressionsOcurrentChunk)
                                     (_guardedexpressionsOdictionaryEnvironment)
                                     (_guardedexpressionsOimportEnvironment)
                                     (_guardedexpressionsOmatchIO)
                                     (_guardedexpressionsOmonos)
                                     (_guardedexpressionsOnamesInScope)
                                     (_guardedexpressionsOnumberOfGuards)
                                     (_guardedexpressionsOopen)
                                     (_guardedexpressionsOorderedTypeSynonyms)
                                     (_guardedexpressionsOparentTree)
                                     (_guardedexpressionsOpatternMatchWarnings)
                                     (_guardedexpressionsOsubstitution)
                                     (_guardedexpressionsOtypeschemeMap)
                                     (_guardedexpressionsOuniqueChunk)
                                     (_guardedexpressionsOuniqueSecondRound))
            ( _whereIassumptions,_whereIbetaUnique,_whereIcollectErrors,_whereIcollectInstances,_whereIcollectWarnings,_whereIconstraints,_whereIdictionaryEnvironment,_whereIinfoTrees,_whereIlocalTypes,_whereImatchIO,_whereInamesInScope,_whereIpatternMatchWarnings,_whereIself,_whereIunboundNames,_whereIuniqueChunk) =
                (where_ (_whereOallPatterns)
                        (_whereOallTypeSchemes)
                        (_whereOassumptions)
                        (_whereOavailablePredicates)
                        (_whereObetaUnique)
                        (_whereOclassEnvironment)
                        (_whereOcollectErrors)
                        (_whereOcollectWarnings)
                        (_whereOconstraints)
                        (_whereOcurrentChunk)
                        (_whereOdictionaryEnvironment)
                        (_whereOimportEnvironment)
                        (_whereOmatchIO)
                        (_whereOmonos)
                        (_whereOnamesInScope)
                        (_whereOorderedTypeSynonyms)
                        (_whereOparentTree)
                        (_whereOpatternMatchWarnings)
                        (_whereOsubstitution)
                        (_whereOtypeschemeMap)
                        (_whereOunboundNames)
                        (_whereOuniqueChunk))
            (_whereOconstraints@_) =
                Node _guardedexpressionsIconstraintslist
            (_whereOassumptions@_) =
                _guardedexpressionsIassumptions
            (_guardedexpressionsOnumberOfGuards@_) =
                length _guardedexpressionsIconstraintslist
            (_lhsOconstraints@_) =
                _whereIconstraints
            (_lhsOassumptions@_) =
                _whereIassumptions
            (_allTypeSchemes@_) =
                _whereIlocalTypes `M.union` _lhsIallTypeSchemes
            (_localInfo@_) =
                LocalInfo { self = UHA_RHS _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo (_guardedexpressionsIinfoTrees ++ _whereIinfoTrees)
            (_whereOunboundNames@_) =
                _guardedexpressionsIunboundNames
            (_guardedexpressionsOnamesInScope@_) =
                _whereInamesInScope
            (_lhsOunboundNames@_) =
                _whereIunboundNames
            (_whereObetaUnique@_) =
                _guardedexpressionsIuniqueSecondRound
            (_guardedexpressionsOuniqueSecondRound@_) =
                _guardedexpressionsIbetaUnique
            (_lhsOpatternMatchWarnings@_) =
                (if _guardedexpressionsIfallthrough then [FallThrough range_] else [])
                ++ _whereIpatternMatchWarnings
            (_guardedexpressionsOopen@_) =
                True
            (_lhsOfallthrough@_) =
                _guardedexpressionsIfallthrough
            (_lhsOcollectInstances@_) =
                _guardedexpressionsIcollectInstances  ++  _whereIcollectInstances
            (_self@_) =
                RightHandSide_Guarded _rangeIself _guardedexpressionsIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _whereIbetaUnique
            (_lhsOcollectErrors@_) =
                _whereIcollectErrors
            (_lhsOcollectWarnings@_) =
                _whereIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _whereIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _whereImatchIO
            (_lhsOuniqueChunk@_) =
                _whereIuniqueChunk
            (_guardedexpressionsOallPatterns@_) =
                _lhsIallPatterns
            (_guardedexpressionsOallTypeSchemes@_) =
                _allTypeSchemes
            (_guardedexpressionsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_guardedexpressionsObetaRight@_) =
                _lhsIbetaRight
            (_guardedexpressionsObetaUnique@_) =
                _lhsIbetaUnique
            (_guardedexpressionsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_guardedexpressionsOcollectErrors@_) =
                _lhsIcollectErrors
            (_guardedexpressionsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_guardedexpressionsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_guardedexpressionsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_guardedexpressionsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_guardedexpressionsOmatchIO@_) =
                _lhsImatchIO
            (_guardedexpressionsOmonos@_) =
                _lhsImonos
            (_guardedexpressionsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_guardedexpressionsOparentTree@_) =
                _parentTree
            (_guardedexpressionsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_guardedexpressionsOsubstitution@_) =
                _lhsIsubstitution
            (_guardedexpressionsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_guardedexpressionsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_whereOallPatterns@_) =
                _lhsIallPatterns
            (_whereOallTypeSchemes@_) =
                _allTypeSchemes
            (_whereOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_whereOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_whereOcollectErrors@_) =
                _guardedexpressionsIcollectErrors
            (_whereOcollectWarnings@_) =
                _guardedexpressionsIcollectWarnings
            (_whereOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_whereOdictionaryEnvironment@_) =
                _guardedexpressionsIdictionaryEnvironment
            (_whereOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_whereOmatchIO@_) =
                _guardedexpressionsImatchIO
            (_whereOmonos@_) =
                _lhsImonos
            (_whereOnamesInScope@_) =
                _lhsInamesInScope
            (_whereOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_whereOparentTree@_) =
                _parentTree
            (_whereOpatternMatchWarnings@_) =
                _guardedexpressionsIpatternMatchWarnings
            (_whereOsubstitution@_) =
                _lhsIsubstitution
            (_whereOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_whereOuniqueChunk@_) =
                _guardedexpressionsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOfallthrough,_lhsOinfoTree,_lhsOmatchIO,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk)
-- SimpleType --------------------------------------------------
-- semantic domain
type T_SimpleType = ( (Name),(SimpleType),(Names))
-- cata
sem_SimpleType :: (SimpleType) ->
                  (T_SimpleType)
sem_SimpleType ((SimpleType_SimpleType (_range) (_name) (_typevariables))) =
    (sem_SimpleType_SimpleType ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Names (_typevariables))))
sem_SimpleType_SimpleType :: (T_Range) ->
                             (T_Name) ->
                             (T_Names) ->
                             (T_SimpleType)
sem_SimpleType_SimpleType (range_) (name_) (typevariables_) =
    let _lhsOname :: (Name)
        _lhsOself :: (SimpleType)
        _lhsOtypevariables :: (Names)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _typevariablesIself :: (Names)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _typevariablesIself) =
            (typevariables_ )
        (_lhsOtypevariables@_) =
            _typevariablesIself
        (_lhsOname@_) =
            _nameIself
        (_self@_) =
            SimpleType_SimpleType _rangeIself _nameIself _typevariablesIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOname,_lhsOself,_lhsOtypevariables)
-- Statement ---------------------------------------------------
-- semantic domain
type T_Statement = ([((Expression, [String]), Core_TypingStrategy)]) ->
                   (M.Map NameWithRange TpScheme) ->
                   (Assumptions) ->
                   (Predicates) ->
                   (Int) ->
                   (ClassEnvironment) ->
                   (TypeErrors) ->
                   (Warnings) ->
                   (ConstraintSet) ->
                   (Int) ->
                   (DictionaryEnvironment) ->
                   (Maybe Tp) ->
                   (ImportEnvironment) ->
                   (IO ()) ->
                   (Monos) ->
                   (Names) ->
                   (OrderedTypeSynonyms) ->
                   (InfoTree) ->
                   ([Warning]) ->
                   (FixpointSubstitution) ->
                   (M.Map Int (Scheme Predicates)) ->
                   (Names) ->
                   (Int) ->
                   (Int) ->
                   ( (Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(DictionaryEnvironment),(Maybe Tp),(InfoTree),(IO ()),(Monos),(Names),([Warning]),(Statement),(Names),(Int),(Int))
-- cata
sem_Statement :: (Statement) ->
                 (T_Statement)
sem_Statement ((Statement_Empty (_range))) =
    (sem_Statement_Empty ((sem_Range (_range))))
sem_Statement ((Statement_Expression (_range) (_expression))) =
    (sem_Statement_Expression ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Statement ((Statement_Generator (_range) (_pattern) (_expression))) =
    (sem_Statement_Generator ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_Expression (_expression))))
sem_Statement ((Statement_Let (_range) (_declarations))) =
    (sem_Statement_Let ((sem_Range (_range))) ((sem_Declarations (_declarations))))
sem_Statement_Empty :: (T_Range) ->
                       (T_Statement)
sem_Statement_Empty (range_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIgeneratorBeta
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOgeneratorBeta :: (Maybe Tp)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmonos :: (Monos)
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Statement)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_localInfo@_) =
                LocalInfo { self = UHA_Stat _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo []
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                Statement_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _lhsIassumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOconstraints@_) =
                _lhsIconstraints
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOgeneratorBeta@_) =
                _lhsIgeneratorBeta
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOmonos@_) =
                _lhsImonos
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOgeneratorBeta,_lhsOinfoTree,_lhsOmatchIO,_lhsOmonos,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Statement_Expression :: (T_Range) ->
                            (T_Expression) ->
                            (T_Statement)
sem_Statement_Expression (range_) (expression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIgeneratorBeta
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOgeneratorBeta :: (Maybe Tp)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmonos :: (Monos)
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Statement)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            (_newcon@_) =
                [ (_expressionIbeta .==. ioType _beta) _cinfo ]
            (_beta@_) =
                TVar _lhsIbetaUnique
            (_locConstraints@_) =
                Node [ _newcon .<. _expressionIconstraints
                     , _lhsIconstraints
                     ]
            (_expressionObetaUnique@_) =
                _lhsIbetaUnique + 1
            (_lhsOconstraints@_) =
                _locConstraints
            (_lhsOassumptions@_) =
                _lhsIassumptions `combine` _expressionIassumptions
            (_lhsOgeneratorBeta@_) =
                Just _beta
            (_cinfo@_) =
                orphanConstraint 0 "generator" _parentTree
                   []
            (_localInfo@_) =
                LocalInfo { self = UHA_Stat _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo [_expressionIinfoTree]
            (_lhsOunboundNames@_) =
                _expressionIunboundNames ++ _lhsIunboundNames
            (_expressionOtryPatterns@_) =
                []
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_self@_) =
                Statement_Expression _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _expressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _expressionImatchIO
            (_lhsOmonos@_) =
                _lhsImonos
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOpatternMatchWarnings@_) =
                _expressionIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _parentTree
            (_expressionOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOgeneratorBeta,_lhsOinfoTree,_lhsOmatchIO,_lhsOmonos,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Statement_Generator :: (T_Range) ->
                           (T_Pattern) ->
                           (T_Expression) ->
                           (T_Statement)
sem_Statement_Generator (range_) (pattern_) (expression_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIgeneratorBeta
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOgeneratorBeta :: (Maybe Tp)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmonos :: (Monos)
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Statement)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _patternIbeta :: (Tp)
            _patternIbetaUnique :: (Int)
            _patternIconstraints :: (ConstraintSet)
            _patternIelements :: (  [PatternElement]        )
            _patternIenvironment :: (PatternAssumptions)
            _patternIinfoTree :: (InfoTree)
            _patternIpatVarNames :: (Names)
            _patternIpatternMatchWarnings :: ([Warning])
            _patternIself :: (Pattern)
            _patternIunboundNames :: (Names)
            _patternObetaUnique :: (Int)
            _patternOimportEnvironment :: (ImportEnvironment)
            _patternOmonos :: (Monos)
            _patternOnamesInScope :: (Names)
            _patternOparentTree :: (InfoTree)
            _patternOpatternMatchWarnings :: ([Warning])
            _expressionIassumptions :: (Assumptions)
            _expressionIbeta :: (Tp)
            _expressionIbetaUnique :: (Int)
            _expressionIcollectErrors :: (TypeErrors)
            _expressionIcollectInstances :: ([(Name, Instance)])
            _expressionIcollectWarnings :: (Warnings)
            _expressionIconstraints :: (ConstraintSet)
            _expressionIdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionIinfoTree :: (InfoTree)
            _expressionImatchIO :: (IO ())
            _expressionImatches :: ([Maybe MetaVariableTable])
            _expressionIpatternMatchWarnings :: ([Warning])
            _expressionIself :: (Expression)
            _expressionIunboundNames :: (Names)
            _expressionIuniqueChunk :: (Int)
            _expressionIuniqueSecondRound :: (Int)
            _expressionOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _expressionOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _expressionOavailablePredicates :: (Predicates)
            _expressionObetaUnique :: (Int)
            _expressionOclassEnvironment :: (ClassEnvironment)
            _expressionOcollectErrors :: (TypeErrors)
            _expressionOcollectWarnings :: (Warnings)
            _expressionOcurrentChunk :: (Int)
            _expressionOdictionaryEnvironment :: (DictionaryEnvironment)
            _expressionOimportEnvironment :: (ImportEnvironment)
            _expressionOmatchIO :: (IO ())
            _expressionOmonos :: (Monos)
            _expressionOnamesInScope :: (Names)
            _expressionOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _expressionOparentTree :: (InfoTree)
            _expressionOpatternMatchWarnings :: ([Warning])
            _expressionOsubstitution :: (FixpointSubstitution)
            _expressionOtryPatterns :: ([(Expression     , [String])])
            _expressionOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _expressionOuniqueChunk :: (Int)
            _expressionOuniqueSecondRound :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _patternIbeta,_patternIbetaUnique,_patternIconstraints,_patternIelements,_patternIenvironment,_patternIinfoTree,_patternIpatVarNames,_patternIpatternMatchWarnings,_patternIself,_patternIunboundNames) =
                (pattern_ (_patternObetaUnique) (_patternOimportEnvironment) (_patternOmonos) (_patternOnamesInScope) (_patternOparentTree) (_patternOpatternMatchWarnings))
            ( _expressionIassumptions,_expressionIbeta,_expressionIbetaUnique,_expressionIcollectErrors,_expressionIcollectInstances,_expressionIcollectWarnings,_expressionIconstraints,_expressionIdictionaryEnvironment,_expressionIinfoTree,_expressionImatchIO,_expressionImatches,_expressionIpatternMatchWarnings,_expressionIself,_expressionIunboundNames,_expressionIuniqueChunk,_expressionIuniqueSecondRound) =
                (expression_ (_expressionOallPatterns)
                             (_expressionOallTypeSchemes)
                             (_expressionOavailablePredicates)
                             (_expressionObetaUnique)
                             (_expressionOclassEnvironment)
                             (_expressionOcollectErrors)
                             (_expressionOcollectWarnings)
                             (_expressionOcurrentChunk)
                             (_expressionOdictionaryEnvironment)
                             (_expressionOimportEnvironment)
                             (_expressionOmatchIO)
                             (_expressionOmonos)
                             (_expressionOnamesInScope)
                             (_expressionOorderedTypeSynonyms)
                             (_expressionOparentTree)
                             (_expressionOpatternMatchWarnings)
                             (_expressionOsubstitution)
                             (_expressionOtryPatterns)
                             (_expressionOtypeschemeMap)
                             (_expressionOuniqueChunk)
                             (_expressionOuniqueSecondRound))
            ((_csetBinds@_,_assumptions'@_)) =
                (_patternIenvironment .===. _lhsIassumptions) _cinfoBind
            (_newcon@_) =
                [ (_expressionIbeta .==. ioType _patternIbeta) _cinfoResult ]
            (_locConstraints@_) =
                _newcon .>. _csetBinds .>>.
                   Node [ _patternIconstraints
                        , _expressionIconstraints
                        , _lhsIconstraints
                        ]
            (_lhsOmonos@_) =
                M.elems _patternIenvironment ++ getMonos _csetBinds ++ _lhsImonos
            (_lhsOassumptions@_) =
                _assumptions' `combine` _expressionIassumptions
            (_lhsOconstraints@_) =
                _locConstraints
            (_lhsOgeneratorBeta@_) =
                Nothing
            (_cinfoResult@_) =
                childConstraint 1 "generator" _parentTree
                   []
            (_cinfoBind@_) =
                \name -> variableConstraint "variable" (nameToUHA_Expr name)
                   [ FolkloreConstraint
                   , makeUnifier name "generator" _patternIenvironment _parentTree
                   ]
            (_localInfo@_) =
                LocalInfo { self = UHA_Stat _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_lhsOinfoTree@_) =
                _parentTree
            (_parentTree@_) =
                node _lhsIparentTree _localInfo [_patternIinfoTree, _expressionIinfoTree]
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _patternIpatVarNames (_expressionIunboundNames ++ _lhsIunboundNames) _lhsInamesInScope
            (_expressionOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOunboundNames@_) =
                _unboundNames
            (_lhsOnamesInScope@_) =
                _namesInScope
            (_expressionOtryPatterns@_) =
                []
            (_lhsOpatternMatchWarnings@_) =
                patternMatchWarnings _lhsIimportEnvironment
                                     _lhsIsubstitution
                                     _patternIbeta
                                     (:[])
                                     [(_patternIelements, False)]
                                     range_
                                     Nothing
                                     False
                                     []
                                     "generator"
                                     "<-"
                ++ _expressionIpatternMatchWarnings
            (_lhsOcollectInstances@_) =
                _expressionIcollectInstances
            (_self@_) =
                Statement_Generator _rangeIself _patternIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _expressionIbetaUnique
            (_lhsOcollectErrors@_) =
                _expressionIcollectErrors
            (_lhsOcollectWarnings@_) =
                _expressionIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _expressionIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _expressionImatchIO
            (_lhsOuniqueChunk@_) =
                _expressionIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _expressionIuniqueSecondRound
            (_patternObetaUnique@_) =
                _lhsIbetaUnique
            (_patternOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_patternOmonos@_) =
                _lhsImonos
            (_patternOnamesInScope@_) =
                _namesInScope
            (_patternOparentTree@_) =
                _parentTree
            (_patternOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_expressionOallPatterns@_) =
                _lhsIallPatterns
            (_expressionOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_expressionOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_expressionObetaUnique@_) =
                _patternIbetaUnique
            (_expressionOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_expressionOcollectErrors@_) =
                _lhsIcollectErrors
            (_expressionOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_expressionOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_expressionOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_expressionOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_expressionOmatchIO@_) =
                _lhsImatchIO
            (_expressionOmonos@_) =
                _lhsImonos
            (_expressionOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_expressionOparentTree@_) =
                _parentTree
            (_expressionOpatternMatchWarnings@_) =
                _patternIpatternMatchWarnings
            (_expressionOsubstitution@_) =
                _lhsIsubstitution
            (_expressionOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_expressionOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_expressionOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOgeneratorBeta,_lhsOinfoTree,_lhsOmatchIO,_lhsOmonos,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Statement_Let :: (T_Range) ->
                     (T_Declarations) ->
                     (T_Statement)
sem_Statement_Let (range_) (declarations_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIgeneratorBeta
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOgeneratorBeta :: (Maybe Tp)
            _lhsOinfoTree :: (InfoTree)
            _lhsOmatchIO :: (IO ())
            _lhsOmonos :: (Monos)
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Statement)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _rangeIself :: (Range)
            _declarationsIbetaUnique :: (Int)
            _declarationsIbindingGroups :: (BindingGroups)
            _declarationsIcollectErrors :: (TypeErrors)
            _declarationsIcollectInstances :: ([(Name, Instance)])
            _declarationsIcollectWarnings :: (Warnings)
            _declarationsIdeclVarNames :: (Names)
            _declarationsIdictionaryEnvironment :: (DictionaryEnvironment)
            _declarationsIinfoTrees :: (InfoTrees)
            _declarationsImatchIO :: (IO ())
            _declarationsIpatternMatchWarnings :: ([Warning])
            _declarationsIrestrictedNames :: (Names)
            _declarationsIself :: (Declarations)
            _declarationsIsimplePatNames :: (Names)
            _declarationsItypeSignatures :: (TypeEnvironment)
            _declarationsIunboundNames :: (Names)
            _declarationsIuniqueChunk :: (Int)
            _declarationsOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _declarationsOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _declarationsOavailablePredicates :: (Predicates)
            _declarationsObetaUnique :: (Int)
            _declarationsObindingGroups :: (BindingGroups)
            _declarationsOclassEnvironment :: (ClassEnvironment)
            _declarationsOcollectErrors :: (TypeErrors)
            _declarationsOcollectWarnings :: (Warnings)
            _declarationsOcurrentChunk :: (Int)
            _declarationsOdictionaryEnvironment :: (DictionaryEnvironment)
            _declarationsOimportEnvironment :: (ImportEnvironment)
            _declarationsOinheritedBDG :: (InheritedBDG)
            _declarationsOmatchIO :: (IO ())
            _declarationsOmonos :: (Monos)
            _declarationsOnamesInScope :: (Names)
            _declarationsOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _declarationsOparentTree :: (InfoTree)
            _declarationsOpatternMatchWarnings :: ([Warning])
            _declarationsOsubstitution :: (FixpointSubstitution)
            _declarationsOtypeSignatures :: (TypeEnvironment)
            _declarationsOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _declarationsOuniqueChunk :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _declarationsIbetaUnique
             ,_declarationsIbindingGroups
             ,_declarationsIcollectErrors
             ,_declarationsIcollectInstances
             ,_declarationsIcollectWarnings
             ,_declarationsIdeclVarNames
             ,_declarationsIdictionaryEnvironment
             ,_declarationsIinfoTrees
             ,_declarationsImatchIO
             ,_declarationsIpatternMatchWarnings
             ,_declarationsIrestrictedNames
             ,_declarationsIself
             ,_declarationsIsimplePatNames
             ,_declarationsItypeSignatures
             ,_declarationsIunboundNames
             ,_declarationsIuniqueChunk
             ) =
                (declarations_ (_declarationsOallPatterns)
                               (_declarationsOallTypeSchemes)
                               (_declarationsOavailablePredicates)
                               (_declarationsObetaUnique)
                               (_declarationsObindingGroups)
                               (_declarationsOclassEnvironment)
                               (_declarationsOcollectErrors)
                               (_declarationsOcollectWarnings)
                               (_declarationsOcurrentChunk)
                               (_declarationsOdictionaryEnvironment)
                               (_declarationsOimportEnvironment)
                               (_declarationsOinheritedBDG)
                               (_declarationsOmatchIO)
                               (_declarationsOmonos)
                               (_declarationsOnamesInScope)
                               (_declarationsOorderedTypeSynonyms)
                               (_declarationsOparentTree)
                               (_declarationsOpatternMatchWarnings)
                               (_declarationsOsubstitution)
                               (_declarationsOtypeSignatures)
                               (_declarationsOtypeschemeMap)
                               (_declarationsOuniqueChunk))
            ((_lhsOassumptions@_,_lhsOconstraints@_,_inheritedBDG@_,_chunkNr@_,_lhsObetaUnique@_,_implicitsFM@_)) =
                let inputBDG    = (False, _lhsIcurrentChunk, _declarationsIuniqueChunk, _lhsImonos, _declarationsItypeSignatures, mybdggroup, _declarationsIbetaUnique)
                    mybdggroup = Just (_lhsIassumptions, [_lhsIconstraints])
                in performBindingGroup inputBDG _declarationsIbindingGroups
            (_declarationsObindingGroups@_) =
                []
            (_lhsOgeneratorBeta@_) =
                Nothing
            (_lhsOcollectErrors@_) =
                restrictedNameErrors _inferredTypes _declarationsIrestrictedNames
                ++ _declarationsIcollectErrors
            (_lhsOcollectWarnings@_) =
                missingTypeSignature False _declarationsIsimplePatNames _inferredTypes
                ++ _declarationsIcollectWarnings
            (_inferredTypes@_) =
                findInferredTypes _lhsItypeschemeMap _implicitsFM
            (_localTypes@_) =
                makeLocalTypeEnv (_declarationsItypeSignatures `M.union` _inferredTypes) _declarationsIbindingGroups
            (_allTypeSchemes@_) =
                _localTypes `M.union` _lhsIallTypeSchemes
            (_declarationsOtypeSignatures@_) =
                M.empty
            (_lhsOuniqueChunk@_) =
                _chunkNr
            (_localInfo@_) =
                LocalInfo { self = UHA_Stat _self
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_declInfo@_) =
                LocalInfo { self = UHA_Decls _declarationsIself
                          , assignedType = Nothing
                          , monos = _lhsImonos
                          }
            (_declarationsOparentTree@_) =
                _declTree
            (_lhsOinfoTree@_) =
                _thisTree
            (_declTree@_) =
                node _thisTree _declInfo _declarationsIinfoTrees
            (_thisTree@_) =
                node _lhsIparentTree _localInfo [_declTree]
            ((_collectTypeConstructors@_,_collectValueConstructors@_,_collectTypeSynonyms@_,_collectConstructorEnv@_,_derivedFunctions@_,_operatorFixities@_)) =
                internalError "PartialSyntax.ag" "n/a" "toplevel Statement"
            ((_namesInScope@_,_unboundNames@_,_scopeInfo@_)) =
                changeOfScope _declarationsIdeclVarNames (_declarationsIunboundNames ++ _lhsIunboundNames) _lhsInamesInScope
            (_lhsOunboundNames@_) =
                _unboundNames
            (_lhsOcollectInstances@_) =
                _declarationsIcollectInstances
            (_self@_) =
                Statement_Let _rangeIself _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsOdictionaryEnvironment@_) =
                _declarationsIdictionaryEnvironment
            (_lhsOmatchIO@_) =
                _declarationsImatchIO
            (_lhsOmonos@_) =
                _lhsImonos
            (_lhsOnamesInScope@_) =
                _namesInScope
            (_lhsOpatternMatchWarnings@_) =
                _declarationsIpatternMatchWarnings
            (_lhsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_declarationsOallPatterns@_) =
                _lhsIallPatterns
            (_declarationsOallTypeSchemes@_) =
                _allTypeSchemes
            (_declarationsOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_declarationsObetaUnique@_) =
                _lhsIbetaUnique
            (_declarationsOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_declarationsOcollectErrors@_) =
                _lhsIcollectErrors
            (_declarationsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_declarationsOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_declarationsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_declarationsOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_declarationsOinheritedBDG@_) =
                _inheritedBDG
            (_declarationsOmatchIO@_) =
                _lhsImatchIO
            (_declarationsOmonos@_) =
                _lhsImonos
            (_declarationsOnamesInScope@_) =
                _namesInScope
            (_declarationsOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_declarationsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_declarationsOsubstitution@_) =
                _lhsIsubstitution
            (_declarationsOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_declarationsOuniqueChunk@_) =
                _lhsIuniqueChunk
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOgeneratorBeta,_lhsOinfoTree,_lhsOmatchIO,_lhsOmonos,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
-- Statements --------------------------------------------------
-- semantic domain
type T_Statements = ([((Expression, [String]), Core_TypingStrategy)]) ->
                    (M.Map NameWithRange TpScheme) ->
                    (Assumptions) ->
                    (Predicates) ->
                    (Int) ->
                    (ClassEnvironment) ->
                    (TypeErrors) ->
                    (Warnings) ->
                    (ConstraintSet) ->
                    (Int) ->
                    (DictionaryEnvironment) ->
                    (Maybe Tp) ->
                    (ImportEnvironment) ->
                    (IO ()) ->
                    (Monos) ->
                    (Names) ->
                    (OrderedTypeSynonyms) ->
                    (InfoTree) ->
                    ([Warning]) ->
                    (FixpointSubstitution) ->
                    (M.Map Int (Scheme Predicates)) ->
                    (Names) ->
                    (Int) ->
                    (Int) ->
                    ( (Assumptions),(Int),(TypeErrors),([(Name, Instance)]),(Warnings),(ConstraintSet),(DictionaryEnvironment),(Maybe Tp),(InfoTrees),(IO ()),(Names),([Warning]),(Statements),(Names),(Int),(Int))
-- cata
sem_Statements :: (Statements) ->
                  (T_Statements)
sem_Statements (list) =
    (Prelude.foldr (sem_Statements_Cons) (sem_Statements_Nil) ((Prelude.map sem_Statement list)))
sem_Statements_Cons :: (T_Statement) ->
                       (T_Statements) ->
                       (T_Statements)
sem_Statements_Cons (hd_) (tl_) =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIgeneratorBeta
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOgeneratorBeta :: (Maybe Tp)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Statements)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            _hdIassumptions :: (Assumptions)
            _hdIbetaUnique :: (Int)
            _hdIcollectErrors :: (TypeErrors)
            _hdIcollectInstances :: ([(Name, Instance)])
            _hdIcollectWarnings :: (Warnings)
            _hdIconstraints :: (ConstraintSet)
            _hdIdictionaryEnvironment :: (DictionaryEnvironment)
            _hdIgeneratorBeta :: (Maybe Tp)
            _hdIinfoTree :: (InfoTree)
            _hdImatchIO :: (IO ())
            _hdImonos :: (Monos)
            _hdInamesInScope :: (Names)
            _hdIpatternMatchWarnings :: ([Warning])
            _hdIself :: (Statement)
            _hdIunboundNames :: (Names)
            _hdIuniqueChunk :: (Int)
            _hdIuniqueSecondRound :: (Int)
            _hdOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _hdOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _hdOassumptions :: (Assumptions)
            _hdOavailablePredicates :: (Predicates)
            _hdObetaUnique :: (Int)
            _hdOclassEnvironment :: (ClassEnvironment)
            _hdOcollectErrors :: (TypeErrors)
            _hdOcollectWarnings :: (Warnings)
            _hdOconstraints :: (ConstraintSet)
            _hdOcurrentChunk :: (Int)
            _hdOdictionaryEnvironment :: (DictionaryEnvironment)
            _hdOgeneratorBeta :: (Maybe Tp)
            _hdOimportEnvironment :: (ImportEnvironment)
            _hdOmatchIO :: (IO ())
            _hdOmonos :: (Monos)
            _hdOnamesInScope :: (Names)
            _hdOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _hdOparentTree :: (InfoTree)
            _hdOpatternMatchWarnings :: ([Warning])
            _hdOsubstitution :: (FixpointSubstitution)
            _hdOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _hdOunboundNames :: (Names)
            _hdOuniqueChunk :: (Int)
            _hdOuniqueSecondRound :: (Int)
            _tlIassumptions :: (Assumptions)
            _tlIbetaUnique :: (Int)
            _tlIcollectErrors :: (TypeErrors)
            _tlIcollectInstances :: ([(Name, Instance)])
            _tlIcollectWarnings :: (Warnings)
            _tlIconstraints :: (ConstraintSet)
            _tlIdictionaryEnvironment :: (DictionaryEnvironment)
            _tlIgeneratorBeta :: (Maybe Tp)
            _tlIinfoTrees :: (InfoTrees)
            _tlImatchIO :: (IO ())
            _tlInamesInScope :: (Names)
            _tlIpatternMatchWarnings :: ([Warning])
            _tlIself :: (Statements)
            _tlIunboundNames :: (Names)
            _tlIuniqueChunk :: (Int)
            _tlIuniqueSecondRound :: (Int)
            _tlOallPatterns :: ([((Expression, [String]), Core_TypingStrategy)])
            _tlOallTypeSchemes :: (M.Map NameWithRange TpScheme)
            _tlOassumptions :: (Assumptions)
            _tlOavailablePredicates :: (Predicates)
            _tlObetaUnique :: (Int)
            _tlOclassEnvironment :: (ClassEnvironment)
            _tlOcollectErrors :: (TypeErrors)
            _tlOcollectWarnings :: (Warnings)
            _tlOconstraints :: (ConstraintSet)
            _tlOcurrentChunk :: (Int)
            _tlOdictionaryEnvironment :: (DictionaryEnvironment)
            _tlOgeneratorBeta :: (Maybe Tp)
            _tlOimportEnvironment :: (ImportEnvironment)
            _tlOmatchIO :: (IO ())
            _tlOmonos :: (Monos)
            _tlOnamesInScope :: (Names)
            _tlOorderedTypeSynonyms :: (OrderedTypeSynonyms)
            _tlOparentTree :: (InfoTree)
            _tlOpatternMatchWarnings :: ([Warning])
            _tlOsubstitution :: (FixpointSubstitution)
            _tlOtypeschemeMap :: (M.Map Int (Scheme Predicates))
            _tlOunboundNames :: (Names)
            _tlOuniqueChunk :: (Int)
            _tlOuniqueSecondRound :: (Int)
            ( _hdIassumptions,_hdIbetaUnique,_hdIcollectErrors,_hdIcollectInstances,_hdIcollectWarnings,_hdIconstraints,_hdIdictionaryEnvironment,_hdIgeneratorBeta,_hdIinfoTree,_hdImatchIO,_hdImonos,_hdInamesInScope,_hdIpatternMatchWarnings,_hdIself,_hdIunboundNames,_hdIuniqueChunk,_hdIuniqueSecondRound) =
                (hd_ (_hdOallPatterns)
                     (_hdOallTypeSchemes)
                     (_hdOassumptions)
                     (_hdOavailablePredicates)
                     (_hdObetaUnique)
                     (_hdOclassEnvironment)
                     (_hdOcollectErrors)
                     (_hdOcollectWarnings)
                     (_hdOconstraints)
                     (_hdOcurrentChunk)
                     (_hdOdictionaryEnvironment)
                     (_hdOgeneratorBeta)
                     (_hdOimportEnvironment)
                     (_hdOmatchIO)
                     (_hdOmonos)
                     (_hdOnamesInScope)
                     (_hdOorderedTypeSynonyms)
                     (_hdOparentTree)
                     (_hdOpatternMatchWarnings)
                     (_hdOsubstitution)
                     (_hdOtypeschemeMap)
                     (_hdOunboundNames)
                     (_hdOuniqueChunk)
                     (_hdOuniqueSecondRound))
            ( _tlIassumptions,_tlIbetaUnique,_tlIcollectErrors,_tlIcollectInstances,_tlIcollectWarnings,_tlIconstraints,_tlIdictionaryEnvironment,_tlIgeneratorBeta,_tlIinfoTrees,_tlImatchIO,_tlInamesInScope,_tlIpatternMatchWarnings,_tlIself,_tlIunboundNames,_tlIuniqueChunk,_tlIuniqueSecondRound) =
                (tl_ (_tlOallPatterns)
                     (_tlOallTypeSchemes)
                     (_tlOassumptions)
                     (_tlOavailablePredicates)
                     (_tlObetaUnique)
                     (_tlOclassEnvironment)
                     (_tlOcollectErrors)
                     (_tlOcollectWarnings)
                     (_tlOconstraints)
                     (_tlOcurrentChunk)
                     (_tlOdictionaryEnvironment)
                     (_tlOgeneratorBeta)
                     (_tlOimportEnvironment)
                     (_tlOmatchIO)
                     (_tlOmonos)
                     (_tlOnamesInScope)
                     (_tlOorderedTypeSynonyms)
                     (_tlOparentTree)
                     (_tlOpatternMatchWarnings)
                     (_tlOsubstitution)
                     (_tlOtypeschemeMap)
                     (_tlOunboundNames)
                     (_tlOuniqueChunk)
                     (_tlOuniqueSecondRound))
            (_tlOconstraints@_) =
                _lhsIconstraints
            (_tlOassumptions@_) =
                _lhsIassumptions
            (_hdOconstraints@_) =
                _tlIconstraints
            (_hdOassumptions@_) =
                _tlIassumptions
            (_lhsOconstraints@_) =
                _hdIconstraints
            (_lhsOassumptions@_) =
                _hdIassumptions
            (_lhsOinfoTrees@_) =
                _hdIinfoTree : _tlIinfoTrees
            (_hdOunboundNames@_) =
                _tlIunboundNames
            (_tlOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOunboundNames@_) =
                _hdIunboundNames
            (_lhsOcollectInstances@_) =
                _hdIcollectInstances  ++  _tlIcollectInstances
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObetaUnique@_) =
                _tlIbetaUnique
            (_lhsOcollectErrors@_) =
                _tlIcollectErrors
            (_lhsOcollectWarnings@_) =
                _tlIcollectWarnings
            (_lhsOdictionaryEnvironment@_) =
                _tlIdictionaryEnvironment
            (_lhsOgeneratorBeta@_) =
                _tlIgeneratorBeta
            (_lhsOmatchIO@_) =
                _tlImatchIO
            (_lhsOnamesInScope@_) =
                _tlInamesInScope
            (_lhsOpatternMatchWarnings@_) =
                _tlIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _tlIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _tlIuniqueSecondRound
            (_hdOallPatterns@_) =
                _lhsIallPatterns
            (_hdOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_hdOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_hdObetaUnique@_) =
                _lhsIbetaUnique
            (_hdOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_hdOcollectErrors@_) =
                _lhsIcollectErrors
            (_hdOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_hdOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_hdOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_hdOgeneratorBeta@_) =
                _lhsIgeneratorBeta
            (_hdOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_hdOmatchIO@_) =
                _lhsImatchIO
            (_hdOmonos@_) =
                _lhsImonos
            (_hdOnamesInScope@_) =
                _lhsInamesInScope
            (_hdOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_hdOparentTree@_) =
                _lhsIparentTree
            (_hdOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_hdOsubstitution@_) =
                _lhsIsubstitution
            (_hdOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_hdOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_hdOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
            (_tlOallPatterns@_) =
                _lhsIallPatterns
            (_tlOallTypeSchemes@_) =
                _lhsIallTypeSchemes
            (_tlOavailablePredicates@_) =
                _lhsIavailablePredicates
            (_tlObetaUnique@_) =
                _hdIbetaUnique
            (_tlOclassEnvironment@_) =
                _lhsIclassEnvironment
            (_tlOcollectErrors@_) =
                _hdIcollectErrors
            (_tlOcollectWarnings@_) =
                _hdIcollectWarnings
            (_tlOcurrentChunk@_) =
                _lhsIcurrentChunk
            (_tlOdictionaryEnvironment@_) =
                _hdIdictionaryEnvironment
            (_tlOgeneratorBeta@_) =
                _hdIgeneratorBeta
            (_tlOimportEnvironment@_) =
                _lhsIimportEnvironment
            (_tlOmatchIO@_) =
                _hdImatchIO
            (_tlOmonos@_) =
                _hdImonos
            (_tlOnamesInScope@_) =
                _hdInamesInScope
            (_tlOorderedTypeSynonyms@_) =
                _lhsIorderedTypeSynonyms
            (_tlOparentTree@_) =
                _lhsIparentTree
            (_tlOpatternMatchWarnings@_) =
                _hdIpatternMatchWarnings
            (_tlOsubstitution@_) =
                _lhsIsubstitution
            (_tlOtypeschemeMap@_) =
                _lhsItypeschemeMap
            (_tlOuniqueChunk@_) =
                _hdIuniqueChunk
            (_tlOuniqueSecondRound@_) =
                _hdIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOgeneratorBeta,_lhsOinfoTrees,_lhsOmatchIO,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
sem_Statements_Nil :: (T_Statements)
sem_Statements_Nil  =
    \ _lhsIallPatterns
      _lhsIallTypeSchemes
      _lhsIassumptions
      _lhsIavailablePredicates
      _lhsIbetaUnique
      _lhsIclassEnvironment
      _lhsIcollectErrors
      _lhsIcollectWarnings
      _lhsIconstraints
      _lhsIcurrentChunk
      _lhsIdictionaryEnvironment
      _lhsIgeneratorBeta
      _lhsIimportEnvironment
      _lhsImatchIO
      _lhsImonos
      _lhsInamesInScope
      _lhsIorderedTypeSynonyms
      _lhsIparentTree
      _lhsIpatternMatchWarnings
      _lhsIsubstitution
      _lhsItypeschemeMap
      _lhsIunboundNames
      _lhsIuniqueChunk
      _lhsIuniqueSecondRound ->
        let _lhsOassumptions :: (Assumptions)
            _lhsObetaUnique :: (Int)
            _lhsOcollectErrors :: (TypeErrors)
            _lhsOcollectInstances :: ([(Name, Instance)])
            _lhsOcollectWarnings :: (Warnings)
            _lhsOconstraints :: (ConstraintSet)
            _lhsOdictionaryEnvironment :: (DictionaryEnvironment)
            _lhsOgeneratorBeta :: (Maybe Tp)
            _lhsOinfoTrees :: (InfoTrees)
            _lhsOmatchIO :: (IO ())
            _lhsOnamesInScope :: (Names)
            _lhsOpatternMatchWarnings :: ([Warning])
            _lhsOself :: (Statements)
            _lhsOunboundNames :: (Names)
            _lhsOuniqueChunk :: (Int)
            _lhsOuniqueSecondRound :: (Int)
            (_lhsOinfoTrees@_) =
                []
            (_lhsOunboundNames@_) =
                _lhsIunboundNames
            (_lhsOcollectInstances@_) =
                []
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _lhsIassumptions
            (_lhsObetaUnique@_) =
                _lhsIbetaUnique
            (_lhsOcollectErrors@_) =
                _lhsIcollectErrors
            (_lhsOcollectWarnings@_) =
                _lhsIcollectWarnings
            (_lhsOconstraints@_) =
                _lhsIconstraints
            (_lhsOdictionaryEnvironment@_) =
                _lhsIdictionaryEnvironment
            (_lhsOgeneratorBeta@_) =
                _lhsIgeneratorBeta
            (_lhsOmatchIO@_) =
                _lhsImatchIO
            (_lhsOnamesInScope@_) =
                _lhsInamesInScope
            (_lhsOpatternMatchWarnings@_) =
                _lhsIpatternMatchWarnings
            (_lhsOuniqueChunk@_) =
                _lhsIuniqueChunk
            (_lhsOuniqueSecondRound@_) =
                _lhsIuniqueSecondRound
        in  ( _lhsOassumptions,_lhsObetaUnique,_lhsOcollectErrors,_lhsOcollectInstances,_lhsOcollectWarnings,_lhsOconstraints,_lhsOdictionaryEnvironment,_lhsOgeneratorBeta,_lhsOinfoTrees,_lhsOmatchIO,_lhsOnamesInScope,_lhsOpatternMatchWarnings,_lhsOself,_lhsOunboundNames,_lhsOuniqueChunk,_lhsOuniqueSecondRound)
-- Strings -----------------------------------------------------
-- semantic domain
type T_Strings = ( (Strings))
-- cata
sem_Strings :: (Strings) ->
               (T_Strings)
sem_Strings (list) =
    (Prelude.foldr (sem_Strings_Cons) (sem_Strings_Nil) (list))
sem_Strings_Cons :: (String) ->
                    (T_Strings) ->
                    (T_Strings)
sem_Strings_Cons (hd_) (tl_) =
    let _lhsOself :: (Strings)
        _tlIself :: (Strings)
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) hd_ _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Strings_Nil :: (T_Strings)
sem_Strings_Nil  =
    let _lhsOself :: (Strings)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Type --------------------------------------------------------
-- semantic domain
type T_Type = ( (Type))
-- cata
sem_Type :: (Type) ->
            (T_Type)
sem_Type ((Type_Application (_range) (_prefix) (_function) (_arguments))) =
    (sem_Type_Application ((sem_Range (_range))) (_prefix) ((sem_Type (_function))) ((sem_Types (_arguments))))
sem_Type ((Type_Constructor (_range) (_name))) =
    (sem_Type_Constructor ((sem_Range (_range))) ((sem_Name (_name))))
sem_Type ((Type_Exists (_range) (_typevariables) (_type))) =
    (sem_Type_Exists ((sem_Range (_range))) ((sem_Names (_typevariables))) ((sem_Type (_type))))
sem_Type ((Type_Forall (_range) (_typevariables) (_type))) =
    (sem_Type_Forall ((sem_Range (_range))) ((sem_Names (_typevariables))) ((sem_Type (_type))))
sem_Type ((Type_Parenthesized (_range) (_type))) =
    (sem_Type_Parenthesized ((sem_Range (_range))) ((sem_Type (_type))))
sem_Type ((Type_Qualified (_range) (_context) (_type))) =
    (sem_Type_Qualified ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_Type (_type))))
sem_Type ((Type_Variable (_range) (_name))) =
    (sem_Type_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Type_Application :: (T_Range) ->
                        (Bool) ->
                        (T_Type) ->
                        (T_Types) ->
                        (T_Type)
sem_Type_Application (range_) (prefix_) (function_) (arguments_) =
    let _lhsOself :: (Type)
        _rangeIself :: (Range)
        _functionIself :: (Type)
        _argumentsIself :: (Types)
        ( _rangeIself) =
            (range_ )
        ( _functionIself) =
            (function_ )
        ( _argumentsIself) =
            (arguments_ )
        (_self@_) =
            Type_Application _rangeIself prefix_ _functionIself _argumentsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Type_Constructor :: (T_Range) ->
                        (T_Name) ->
                        (T_Type)
sem_Type_Constructor (range_) (name_) =
    let _lhsOself :: (Type)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Type_Constructor _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Type_Exists :: (T_Range) ->
                   (T_Names) ->
                   (T_Type) ->
                   (T_Type)
sem_Type_Exists (range_) (typevariables_) (type_) =
    let _lhsOself :: (Type)
        _rangeIself :: (Range)
        _typevariablesIself :: (Names)
        _typeIself :: (Type)
        ( _rangeIself) =
            (range_ )
        ( _typevariablesIself) =
            (typevariables_ )
        ( _typeIself) =
            (type_ )
        (_self@_) =
            Type_Exists _rangeIself _typevariablesIself _typeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Type_Forall :: (T_Range) ->
                   (T_Names) ->
                   (T_Type) ->
                   (T_Type)
sem_Type_Forall (range_) (typevariables_) (type_) =
    let _lhsOself :: (Type)
        _rangeIself :: (Range)
        _typevariablesIself :: (Names)
        _typeIself :: (Type)
        ( _rangeIself) =
            (range_ )
        ( _typevariablesIself) =
            (typevariables_ )
        ( _typeIself) =
            (type_ )
        (_self@_) =
            Type_Forall _rangeIself _typevariablesIself _typeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Type_Parenthesized :: (T_Range) ->
                          (T_Type) ->
                          (T_Type)
sem_Type_Parenthesized (range_) (type_) =
    let _lhsOself :: (Type)
        _rangeIself :: (Range)
        _typeIself :: (Type)
        ( _rangeIself) =
            (range_ )
        ( _typeIself) =
            (type_ )
        (_self@_) =
            Type_Parenthesized _rangeIself _typeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Type_Qualified :: (T_Range) ->
                      (T_ContextItems) ->
                      (T_Type) ->
                      (T_Type)
sem_Type_Qualified (range_) (context_) (type_) =
    let _lhsOself :: (Type)
        _rangeIself :: (Range)
        _contextIself :: (ContextItems)
        _typeIself :: (Type)
        ( _rangeIself) =
            (range_ )
        ( _contextIself) =
            (context_ )
        ( _typeIself) =
            (type_ )
        (_self@_) =
            Type_Qualified _rangeIself _contextIself _typeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Type_Variable :: (T_Range) ->
                     (T_Name) ->
                     (T_Type)
sem_Type_Variable (range_) (name_) =
    let _lhsOself :: (Type)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Type_Variable _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Types -------------------------------------------------------
-- semantic domain
type T_Types = ( (Types))
-- cata
sem_Types :: (Types) ->
             (T_Types)
sem_Types (list) =
    (Prelude.foldr (sem_Types_Cons) (sem_Types_Nil) ((Prelude.map sem_Type list)))
sem_Types_Cons :: (T_Type) ->
                  (T_Types) ->
                  (T_Types)
sem_Types_Cons (hd_) (tl_) =
    let _lhsOself :: (Types)
        _hdIself :: (Type)
        _tlIself :: (Types)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Types_Nil :: (T_Types)
sem_Types_Nil  =
    let _lhsOself :: (Types)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)


