/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: audsymbian.h,v 1.7.4.2 2004/07/09 02:01:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _AUDSYMBIAN
#define _AUDSYMBIAN
#include <stdio.h>
#include <e32base.h>
#include "hxengin.h"
#include "hxcom.h"
#include "hxausvc.h"
#include "auderrs.h"
#include "hxaudply.h"
#include "chxmapptrtoptr.h"

struct IHXAudioDeviceResponse;
class CHXSimpleList;
class HXSymbianAudioClient;
class HXSymbianAudioServerContext;

class CHXAudioDevice : public IHXAudioDevice, public CActive
{
  public:
    CHXAudioDevice();

    static const int MAX_VOLUME;
    
    //IUnkown methods.
    STDMETHOD(QueryInterface) (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)  (THIS);
    STDMETHOD_(ULONG32,Release) (THIS);

    //IHXAudioDevice methods
    HX_RESULT Open( const HXAudioFormat* pFormat,
                    IHXAudioDeviceResponse* );
    HX_RESULT Close( const BOOL bFlush);
    HX_RESULT Write( const HXAudioData* pAudioOutHdr );
    HX_RESULT Reset( void );
    HX_RESULT Drain( void ); 
    HX_RESULT SetVolume( const UINT16 uVolume );
    HX_RESULT GetCurrentAudioTime( ULONG32& ulCurrentTime);
    BOOL      SupportsVolume( void );
    UINT16    GetVolume( void );
    short     GetAudioFd( void ); 
    HX_RESULT Seek(ULONG32 ulSeekTime);
    HX_RESULT Resume( void );
    HX_RESULT Pause( void );
    HX_RESULT CheckFormat( const HXAudioFormat* pFormat);
    UINT16    NumberOfBlocksRemainingToPlay(void);
    BOOL      InitVolume( const UINT16 uMinVolume, const UINT16 uMaxVolume);

    //XXXgfw These is not part of any interface but it is called from
    //the audio stream anyway. Need to fix that. We don't need a
    //context anyway. 
    inline void Init(IUnknown* pContext){}
    inline BOOL IsWaveOutDevice() { return TRUE; }
    inline void SetGranularity(ULONG32 ulGranularity,
			       ULONG32 ulBytesPerGran) {}
    inline static CHXAudioDevice* Create(IHXPreferences* pPrefs) 
	{ return new CHXAudioDevice; }

    // CActive
    virtual void RunL();
    virtual void DoCancel();
    
  protected:
    
    //--------------------------------------------------
    // DEVICE SPECIFIC METHODS
    //--------------------------------------------------
    virtual ~CHXAudioDevice();
    HX_RESULT OpenDevice();
    HX_RESULT InitDevice(const HXAudioFormat* pFormat);

  private:

    //protect the un-intentional copy ctor and assignment.
    CHXAudioDevice( const CHXAudioDevice& );
    CHXAudioDevice& operator=(const CHXAudioDevice& it );

    LONG32                    m_lRefCount;
    bool		      m_deviceOpen;
    IHXAudioDeviceResponse*   m_pDeviceResponse;
    HXSymbianAudioClient*     m_pAudioStream;
    HXSymbianAudioServerContext* m_pAudioServerContext;
    bool		      m_paused;
    UINT16		      m_uMinPlayerVolume;
    UINT16		      m_uMaxPlayerVolume;
    UINT32		      m_uMinDevVolume;
    UINT32		      m_uMaxDevVolume;
    RTimer                    m_iTimer;
};

#endif  //_AudioOutSYMBIAN
