/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxcookie.cpp,v 1.2.24.1 2004/07/09 01:54:51 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxcom.h"
#include "hxcomm.h"
#include "ihxpckts.h"

// hxmisc
#include "chxpckts.h"
#include "hxurl.h"

// pxcomlib
#include "pxcookie.h"

// hxdebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

char* reverse_string(const char* pszStr)
{
    char* pszRev = NULL;
    if (pszStr)
    {
        INT32 lLen = strlen(pszStr);
        pszRev = new char [lLen + 1];
        if (pszRev)
        {
            const char* pszStrCopy = pszStr + lLen - 1;
            char*       pszRevCopy = pszRev;
            while (pszStrCopy >= pszStr)
            {
                *pszRevCopy++ = *pszStrCopy--;
            }
            *pszRevCopy = '\0';
        }
    }
    return pszRev;
}

HX_RESULT MakeDomainFromHost(IHXBuffer*             pHostStr,
                             IHXCommonClassFactory* pFactory,
                             REF(IHXBuffer*)        rpDomainStr)
{
    HX_RESULT retVal = HXR_OK;

    if (pHostStr && pFactory)
    {
        // We will attempt to construct a domain from the host
        //
        const char* pszHost   = (const char*) pHostStr->GetBuffer();
        INT32       lHostLen  = strlen(pszHost);
        char*       pszDomain = NULL;
        // First, create a string which is a reversed copy of the pHostStr
        char* pszHostRev = reverse_string(pszHost);
        if (pszHostRev)
        {
            // Now search the reversed string for two dots
            char* pszRightMostDot = strchr(pszHostRev, '.');
            if (pszRightMostDot)
            {
                char* pszSecondRightMostDot = strchr(pszRightMostDot + 1, '.');
                if (pszSecondRightMostDot)
                {
                    // We found two dots from the right in the host,
                    // so we will use that as the domain. End the reversed
                    // string right after the second dot.
                    *(pszSecondRightMostDot + 1) = '\0';
                    // Re-reverse the string
                    pszDomain = reverse_string((const char*) pszHostRev);
                }
                else
                {
                    // We only found one dot from the right in the host,
                    // so we prepend a dot
                    pszDomain = new char [lHostLen + 2];
                    if (pszDomain)
                    {
                        strcpy(pszDomain, "."); /* Flawfinder: ignore */
                        strcat(pszDomain, pszHost); /* Flawfinder: ignore */
                    }
                }
            }
            else
            {
                // There are no dots in the host at all,
                // so we will pass the host straight through
                pszDomain = new char [lHostLen + 1];
                if (pszDomain)
                {
                    strcpy(pszDomain, pszHost); /* Flawfinder: ignore */
                }
            }
        }
        HX_VECTOR_DELETE(pszHostRev);

        if (pszDomain)
        {
            // Create an IHXBuffer
            IHXBuffer* pBuffer = NULL;
            retVal              = pFactory->CreateInstance(CLSID_IHXBuffer,
                                                           (void**) &pBuffer);
            if (SUCCEEDED(retVal))
            {
                // Copy the domain to the IHXBuffer
                retVal = pBuffer->Set((const unsigned char*) pszDomain, strlen(pszDomain) + 1);
                if (SUCCEEDED(retVal))
                {
                    // Copy the out parameter
                    HX_RELEASE(rpDomainStr);
                    rpDomainStr = pBuffer;
                    rpDomainStr->AddRef();
                }
            }
            HX_RELEASE(pBuffer);
        }
        else
        {
            retVal = HXR_FAIL;
        }
        HX_VECTOR_DELETE(pszDomain);
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

HX_RESULT GetHostAndPathFromURL(const char*             pszURL,
                                IHXCommonClassFactory* pFactory,
                                REF(IHXBuffer*)        rpHostStr,
                                REF(IHXBuffer*)        rpPathStr)
{
    HX_RESULT retVal = HXR_OK;

    if (pszURL && pFactory)
    {
        // Create a CHXURL from the url
        CHXURL* pURL = new CHXURL(pszURL);
        if (pURL)
        {
            retVal = pURL->GetLastError();
            if (SUCCEEDED(retVal))
            {
                // Get the properties from the CHXURL
                IHXValues* pHeader = pURL->GetProperties();
                if (pHeader)
                {
                    // Get the host from CHXURL
                    IHXBuffer* pHostStr = NULL;
                    retVal               = pHeader->GetPropertyBuffer(PROPERTY_HOST, pHostStr);
                    if (SUCCEEDED(retVal))
                    {
                        // Make a domain from the host
                        IHXBuffer* pDomainStr = NULL;
                        retVal                 = MakeDomainFromHost(pHostStr, pFactory, pDomainStr);
                        if (SUCCEEDED(retVal))
                        {
                            // Always use "/" for the path
                            IHXBuffer* pPathStr = NULL;
                            retVal               = pFactory->CreateInstance(CLSID_IHXBuffer,
                                                                            (void**) &pPathStr);
                            if (SUCCEEDED(retVal))
                            {
                                const char* pszPath = "/";
                                retVal = pPathStr->Set((const unsigned char*) pszPath, strlen(pszPath) + 1);
                                if (SUCCEEDED(retVal))
                                {
                                    HX_RELEASE(rpHostStr);
                                    rpHostStr = pDomainStr;
                                    rpHostStr->AddRef();
                                    HX_RELEASE(rpPathStr);
                                    rpPathStr = pPathStr;
                                    rpPathStr->AddRef();
                                }
                            }
                            HX_RELEASE(pPathStr);
                        }
                        HX_RELEASE(pDomainStr);
                    }
                    HX_RELEASE(pHostStr);
                }
                else
                {
                    retVal = HXR_FAIL;
                }
                HX_RELEASE(pHeader);
            }
        }
        else
        {
            retVal = HXR_OUTOFMEMORY;
        }
        HX_DELETE(pURL);
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

