/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: image.cpp,v 1.2.24.1 2004/07/09 01:52:03 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxtypes.h"
#include "hxcom.h"
#include "hxcomm.h"
#include "hxstring.h"
#include "baseobj.h"
#include "image.h"
#include "rpfilobj.h"
#include "pixres.h"

#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

char CIMFImage::m_pszImageTag[]   = "image";
char CIMFImage::m_pszHandleAttr[] = "handle";
char CIMFImage::m_pszNameAttr[]   = "name";
char CIMFImage::m_pszSizeAttr[]   = "size";
char CIMFImage::m_pszMimeAttr[]   = "mime";

CIMFImage::CIMFImage() : 
    	m_bScheduled(0)
    ,	m_ulHandle(0) 
    ,	m_cName() 
    ,	m_ulImageSize(0)
    ,   m_bSizeSet(FALSE)
    ,   m_cFileMimeType()
{
};

CIMFImage::CIMFImage(const CIMFImage &rImage)
{
    m_ulHandle      = rImage.m_ulHandle;
    m_cName         = rImage.m_cName;
    m_ulImageSize   = rImage.m_ulImageSize;
    m_bSizeSet      = rImage.m_bSizeSet;
    m_cFileMimeType = rImage.m_cFileMimeType;
};

CIMFImage::~CIMFImage() 
{
};


void CIMFImage::RenderText(GString &rStr)
{
    rStr += CIMFFileObject::m_pszTagStart;
    rStr += m_pszImageTag;
    rStr += " ";
    CIMFFileObject::RenderAttribute(m_pszHandleAttr, m_ulHandle, rStr);
    CIMFFileObject::RenderAttribute(m_pszNameAttr,   m_cName,    rStr);
    rStr += CIMFFileObject::m_pszTagEnd;
    rStr += " ";
}

BOOL CIMFImage::InitFromText(GString &rStr, UINT32& rulErrorID, CHXString& rErrText)
{
    BOOL bRet;
    
    bRet = CIMFFileObject::SetAttributeValue(rStr, m_pszHandleAttr, m_ulHandle);
    if (bRet == FALSE)
    {
        rulErrorID = IDS_ERR_PIX_NOHANDLE;
        rErrText   = rStr.c_str();
        return FALSE;
    }
    else
    {
        // The handle attribute was present. Was it > 0?
        if (m_ulHandle == 0)
        {
            rulErrorID = IDS_ERR_PIX_BADHANDLE;
            rErrText   = rStr.c_str();
            return FALSE;
        }
    }

    bRet = CIMFFileObject::SetAttributeValue(rStr, m_pszNameAttr,   m_cName);
    if (bRet == FALSE)
    {
        rulErrorID = IDS_ERR_PIX_NONAME;
        rErrText   = rStr.c_str();
        return FALSE;
    }
    else
    {
        // Name attribute was present. Is the string NULL?
        if (m_cName.length() == 0)
        {
            rulErrorID = IDS_ERR_PIX_NULLNAME;
            rErrText   = rStr.c_str();
            return FALSE;
        }
    }

    UINT32 ulTmp = 0;
    if (CIMFFileObject::SetAttributeValue(rStr, m_pszSizeAttr, ulTmp))
    {
        if (ulTmp)
        {
            m_ulImageSize = ulTmp;
            m_bSizeSet    = TRUE;
        }
        else
        {
            rulErrorID = IDS_ERR_PIX_ZEROSIZE;
            rErrText   = rStr.c_str();
            return FALSE;
        }
    }

    CIMFFileObject::SetAttributeValue(rStr, m_pszMimeAttr,  m_cFileMimeType);

    return TRUE;
}

// Here we ignore packet overhead
ULONG32 CIMFImage::ComputeTransmissionDuration(ULONG32 ulBitRate)
{
    if (ulBitRate)
    {
        return (GetImageSize() * 8000 / ulBitRate) + 1;
    }
    else
    {
        return (ULONG32) 0xFFFFFFFF;
    }
}
