/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxgvalue.cpp,v 1.1.10.3 2004/07/09 01:48:35 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxgprefs.h"

#include <string.h>

HXValue*
hx_value_new(HXValueType type)
{
    HXValue* val;

    val = g_new0(HXValue, 1);
    val->type = type;

    return val;
}

HXValue*
hx_value_copy(const HXValue* val)
{
    HXValue* val_copy = hx_value_new(val->type);
    
    if(val->type == HX_VALUE_STRING)
    {
        val_copy->type = val->type;
        val_copy->d.string_data = NULL;
        
        hx_value_set_string(val_copy, val->d.string_data);
    }
    else
    {
        memcpy(val_copy, val, sizeof(*val));
    }

    return val_copy;
}

void
hx_value_free(HXValue *value)
{
    g_return_if_fail(value != NULL);

    if(value->type == HX_VALUE_STRING)
    {
        if(value->d.string_data)
        {
            g_free(value->d.string_data);
        }
    }

    g_free(value);
}

G_CONST_RETURN gchar*
hx_value_get_string(const HXValue* value)
{
    g_return_val_if_fail(value->type == HX_VALUE_STRING, NULL);

    return value->d.string_data;    
}

void
hx_value_set_string(HXValue*     value,
                    const gchar* s)
{
    if(s)
    {
        hx_value_set_string_nocopy(value, g_strdup(s));
    }
    else
    {
        hx_value_set_string_nocopy(value, NULL);
    }
}

void
hx_value_set_string_nocopy(HXValue* value,
                           gchar*   s)
{
    g_return_if_fail(value != NULL);
    g_return_if_fail(value->type == HX_VALUE_STRING);
    
    if(value->d.string_data)
    {
        g_free(value->d.string_data);
    }

    if(s)
    {
        value->d.string_data = s;
    }
    else
    {
        value->d.string_data = NULL;
    }
}

gint
hx_value_get_int(const HXValue* value)
{
    g_return_val_if_fail(value->type == HX_VALUE_INT, 0);

    return value->d.int_data;
}

void
hx_value_set_int(HXValue* value,
                 gint     i)
{
  g_return_if_fail(value != NULL);
  g_return_if_fail(value->type == HX_VALUE_INT);
 
  value->d.int_data = i;
}

gdouble
hx_value_get_float(const HXValue* value)
{
    g_return_val_if_fail(value->type == HX_VALUE_FLOAT, 0.0);
    
    return value->d.float_data;
}

void
hx_value_set_float(HXValue* value,
                   gdouble  f)
{
    g_return_if_fail(value != NULL);
    g_return_if_fail(value->type == HX_VALUE_FLOAT);
 
    value->d.float_data = f;
}

gboolean
hx_value_get_bool(const HXValue* value)
{
    g_return_val_if_fail(value->type == HX_VALUE_BOOL, FALSE);

    return value->d.bool_data;
}

void
hx_value_set_bool(HXValue* value,
                  gboolean b)
{
  g_return_if_fail(value != NULL);
  g_return_if_fail(value->type == HX_VALUE_BOOL);
 
  value->d.bool_data = b;
}


G_CONST_RETURN gchar*
hx_entry_get_key(const HXEntry* entry)
{
    return entry->key;
}

HXValue*
hx_entry_get_value(const HXEntry* entry)
{
    return entry->value;
}

HXEntry*
hx_entry_new(const gchar* key,
             HXValue*     val)
{
    HXValue* val_copy;
    gchar* key_copy;
    g_return_val_if_fail(key != NULL, NULL);
    g_return_val_if_fail(val != NULL, NULL);

    key_copy = g_strdup(key);
    val_copy = hx_value_copy(val);
    
    return hx_entry_new_nocopy(key_copy, val_copy);
}

HXEntry*
hx_entry_new_from_string_nocopy(const gchar* key,
                                const gchar* val)
{
    HXEntry* entry;
    HXValue* value;

    value = hx_value_new(HX_VALUE_STRING);
    hx_value_set_string(value, val);
    entry = hx_entry_new_nocopy(key, value);

    return entry;
}

HXEntry*
hx_entry_new_nocopy(const gchar* key,
                    HXValue*     val)
{
    HXEntry* entry;

    g_return_val_if_fail(key != NULL, NULL);
    g_return_val_if_fail(val != NULL, NULL);

    entry = g_new0(HXEntry, 1);

    entry->key = key;
    entry->value = val;
    
    return entry;
}

HXEntry*
hx_entry_copy(const HXEntry* entry)
{
    g_return_val_if_fail(entry != NULL, NULL);

    return hx_entry_new(entry->key, entry->value);
}

void
hx_entry_free(HXEntry* entry)
{
    g_return_if_fail(entry != NULL);

    hx_value_free(entry->value);
    g_free(entry);    
}
 
void
hx_entry_set_value(HXEntry* entry,
                   HXValue* val)
{
    HXValue* val_copy;
    
    g_return_if_fail(entry != NULL);
    g_return_if_fail(val != NULL);

    val_copy = hx_value_copy (val);
    
    hx_entry_set_value_nocopy (entry, val_copy);
}

void
hx_entry_set_value_nocopy(HXEntry* entry,
                          HXValue* val)
{
    g_return_if_fail(entry != NULL);
    g_return_if_fail(val != NULL);

    if (entry->value)
        hx_value_free(entry->value);
 
    entry->value = val; 
}
