/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxplayer.h,v 1.11.2.7 2004/10/18 18:55:18 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef __HX_PLAYER_H__
#define __HX_PLAYER_H__

#include <gtk/gtkversion.h>
#include <gtk/gtkenums.h>
#include <gtk/gtktypeutils.h>
#include <gtk/gtkdebug.h>
#include <gtk/gtkwidget.h>

#include <glib.h>

/* For GdkDisplay */
#if defined(G_OS_UNIX)
#include <gdk/gdkx.h>
#elif defined(G_OS_WIN32)
#include <gdk/gdkwin32.h>
#endif

G_BEGIN_DECLS

#define HX_TYPE_PLAYER            (hx_player_get_type ())
#define HX_PLAYER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), HX_TYPE_PLAYER, HXPlayer))
#define HX_PLAYER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), HX_TYPE_PLAYER, HXPlayerClass))
#define HX_IS_PLAYER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HX_TYPE_PLAYER))
#define HX_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), HX_TYPE_PLAYER))
#define HX_PLAYER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), HX_TYPE_PLAYER, HXPlayerClass))

typedef struct _HXPlayer       HXPlayer;
typedef struct _HXPlayerClass  HXPlayerClass;

/* Declarations from the HXClientKit */
typedef void* HXClientPlayerToken;
struct _SHXClientWindow;
typedef struct _SHXClientWindow SHXClientWindow;

/* These enumeration values correspond to the values in HXClientConstants.
   Don't change them! */
typedef enum 
{
    HX_CONTENT_STATE_NOT_LOADED = 0,
    HX_CONTENT_STATE_CONTACTING,
    HX_CONTENT_STATE_BUFFERING,
    HX_CONTENT_STATE_STOPPED,
    HX_CONTENT_STATE_PLAYING,
    HX_CONTENT_STATE_PAUSED
} HXContentStateType;


typedef enum
{
    HX_BUFFERING_START_UP  = 0,
    HX_BUFFERING_SEEK,
    HX_BUFFERING_CONGESTION,
    HX_BUFFERING_LIVE_PAUSE
} HXBufferingReason;

/* memfsys related types */
typedef void* HXDataStream;

struct _HXPlayer
{
    GtkWidget widget;

    HXClientPlayerToken player;
    SHXClientWindow *window;

    HXContentStateType state;

    GdkPixmap* logo_pixmap;
    gint logo_width, logo_height;

    gboolean shuffle;
    gboolean loop;
    guint loop_count;
    guint cur_loop;

    gchar* title_buf;
    gchar* group_title_buf;
    
    gchar* last_opened_url_buf;
};

struct _HXPlayerClass
{
    GtkWidgetClass parent_class;
    
    void     (* play)                  (GtkWidget*   widget);
    void     (* stop)                  (GtkWidget*   widget);
    void     (* pause)                 (GtkWidget*   widget);
    void     (* contacting)            (GtkWidget*   widget,
                                        gchar*       text);
    void     (* buffering)             (GtkWidget*   widget,
                                        guint        reason,
                                        guint        percent);
    void     (* length_changed)        (GtkWidget*   widget,
                                        guint        length);
    void     (* seek)                  (GtkWidget*   widget,
                                        guint        position);
    void     (* error)                 (GtkWidget*   widget,
                                        gpointer     error);
    void     (* hxerror)               (GtkWidget*   widget,
                                        guint        hx_code,
                                        guint        user_code,
                                        gchar*       error_string,
                                        gchar*       user_string,
                                        gchar*       more_info_url);
    void     (* ideal_size_changed)    (GtkWidget*   widget,
                                        guint        width,
                                        guint        height);
    void     (* volume_changed)        (GtkWidget*   widget,
                                        guint        volume);
    void     (* mute_changed)          (GtkWidget*   widget,
                                        gboolean     mute);
    void     (* goto_url)              (GtkWidget*   widget,
                                        gchar*       url,
                                        gchar*       target);
    void     (* open_window)           (GtkWidget*   widget,
                                        gchar*       url,
                                        gchar*       target);
    void     (* clip_bandwidth_changed)(GtkWidget*   widget,
                                        gint         bandwidth);
    void     (* request_upgrade)       (GtkWidget*   widget,
                                        const gchar* url,
                                        GList*       components_list,
                                        gboolean     is_blocking);
    void     (* groups_changed)        (GtkWidget*   widget);    
    void     (* group_started)         (GtkWidget*   widget,
                                        guint        index);    
    void     (* title_changed)         (GtkWidget*   widget,
                                        gchar*       title);
    void     (* status_changed)        (GtkWidget*   widget,
                                        gchar*       status);
    void     (* request_authentication)(GtkWidget*   widget,
                                        gchar*       server,
                                        gchar*       realm,
                                        gchar*       is_proxy_server);
    void     (* content_concluded)     (GtkWidget*   widget,
                                        guint        old_content_state,
                                        guint        new_content_state);
    void     (* content_state_changed) (GtkWidget*   widget);
    gboolean (* has_feature)           (GtkWidget*   widget,
                                        gchar*       feature);
    void     (* start_seeking)         (GtkWidget*   widget);
    void     (* stop_seeking)          (GtkWidget*   widget);
    void     (* visual_state_changed)  (GtkWidget*   widget,
                                        gboolean     is_visible);
};

GType      hx_player_get_type                   (void) G_GNUC_CONST;    
GtkWidget* hx_player_new                        (void);
gboolean   hx_player_open_url                   (HXPlayer*    player,
                                                 const gchar* str);
gboolean   hx_player_open_url_with_mime_type    (HXPlayer*    player,
                                                 const gchar* str,
                                                 const gchar* mime_type);
gboolean   hx_player_open_file                  (HXPlayer*    player,
                                                 const gchar* str);

G_CONST_RETURN gchar* hx_player_get_url         (HXPlayer* player);

HXContentStateType
           hx_player_get_content_state          (HXPlayer* player);

void     hx_player_play                         (HXPlayer* player);
void     hx_player_pause                        (HXPlayer* player);
void     hx_player_stop                         (HXPlayer* player);

void     hx_player_start_seeking                (HXPlayer* player);
void     hx_player_set_position                 (HXPlayer* player,
                                                 guint     position);
void     hx_player_stop_seeking                 (HXPlayer* player);
guint    hx_player_get_position                 (HXPlayer* player);
guint    hx_player_get_length                   (HXPlayer* player);
gboolean hx_player_is_live                      (HXPlayer* player);
gboolean hx_player_is_indefinite_duration       (HXPlayer* player);
gboolean hx_player_has_visual_content           (HXPlayer* player);
void     hx_player_get_ideal_size               (HXPlayer* player,
                                                 gint*     width,
                                                 gint*     height);
void     hx_player_get_logo_size                (HXPlayer* player,
                                                 gint*     width,
                                                 gint*     height);
guint    hx_player_get_clip_bandwidth           (HXPlayer* player);
guint    hx_player_get_source_count             (HXPlayer* player);
guint    hx_player_get_group_count              (HXPlayer* player);
guint    hx_player_get_current_group            (HXPlayer* player);
void     hx_player_set_current_group            (HXPlayer* player,
                                                 guint     index);
void     hx_player_set_volume                   (HXPlayer* player,
                                                 guint     volume);
guint    hx_player_get_volume                   (HXPlayer* player);
void     hx_player_set_mute                     (HXPlayer* player,
                                                 gboolean  mute);
gboolean hx_player_is_muted                     (HXPlayer* player);
void     hx_player_enable_eq                    (HXPlayer* player,
                                                 gboolean  enable);
gboolean hx_player_is_eq_enabled                (HXPlayer* player);
void     hx_player_set_eq_gain_at               (HXPlayer* player,
                                                 guint     band,
                                                 gint      gain);
gint     hx_player_get_eq_gain_at               (HXPlayer* player,
                                                 guint     band);
void     hx_player_set_eq_pregain               (HXPlayer* player,
                                                 gint      pregain);
gint     hx_player_get_eq_pregain               (HXPlayer* player);

void     hx_player_enable_eq_auto_pregain       (HXPlayer* player,
                                                 gboolean  enable);
gboolean hx_player_is_eq_auto_pregain_enabled   (HXPlayer* player);
void     hx_player_set_eq_reverb                (HXPlayer* player,
                                                 gint      room_size,
                                                 gint      reverb);
void     hx_player_get_eq_reverb                (HXPlayer* player,
                                                 gint*     room_size,
                                                 gint*     reverb);

G_CONST_RETURN gchar* hx_player_get_group_title (HXPlayer* player,
                                                 guint     group);
G_CONST_RETURN gchar* hx_player_get_title       (HXPlayer* player);

void     hx_player_set_logo_pixmap              (HXPlayer* player,
                                                 GdkPixmap *pixmap);

gboolean hx_player_authenticate                 (HXPlayer*    player,
                                                 gboolean     validate,
                                                 const gchar* username,
                                                 const gchar* password);

gboolean hx_player_get_statistic                (HXPlayer*    player,
                                                 const gchar* key,
                                                 GValue*      value);
                       
gboolean hx_player_get_unknown                  (HXPlayer*    player,
                                                 void**       unknown);

gboolean hx_player_get_engine_unknown           (HXPlayer*    player,
                                                 void**       unknown);

HXDataStream* hx_player_open_data_stream        (HXPlayer*    player,
                                                 const gchar* url,
                                                 const gchar* mime_type,
                                                 guint        stream_length,
                                                 gboolean     autostart);

gboolean hx_player_write_data_stream            (HXPlayer*      player,
                                                 HXDataStream*  stream,
                                                 const gpointer data,
                                                 guint          len);

void     hx_player_close_data_stream            (HXPlayer*      player,
                                                 HXDataStream*  stream);

gboolean hx_player_set_brightness               (HXPlayer*      player,
                                                 gdouble        brightness);
gboolean hx_player_set_contrast                 (HXPlayer*      player,
                                                 gdouble        contrast);
gboolean hx_player_set_saturation               (HXPlayer*      player,
                                                 gdouble        saturation);
gboolean hx_player_set_hue                      (HXPlayer*      player,
                                                 gdouble        hue);
gboolean hx_player_set_sharpness                (HXPlayer*      player,
                                                 gdouble        sharpness);

gdouble  hx_player_get_brightness               (HXPlayer*      player);
gdouble  hx_player_get_contrast                 (HXPlayer*      player);
gdouble  hx_player_get_saturation               (HXPlayer*      player);
gdouble  hx_player_get_hue                      (HXPlayer*      player);
gdouble  hx_player_get_sharpness                (HXPlayer*      player);

void     hx_player_set_status_text              (HXPlayer*      player,
                                                 const gchar*   text);

G_END_DECLS

#endif
