/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: mmacsurf.cpp,v 1.2.34.1 2004/07/09 01:59:02 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "minisite.h"
#include "macblt.h"
#include "coloracc.h"

#if defined (HELIX_FEATURE_OPTIMIZED_VIDEO)
#include "macyuvblt.h"
#endif //HELIX_FEATURE_OPTIMIZED_VIDEO

#if defined (HELIX_FEATURE_GDI_VIDEO)
#include "macrgbblt.h"
#endif //HELIX_FEATURE_GDI_VIDEO

#include "minisurf.h"
#include "mmacsurf.h"

#define GET_OS_WINDOW() (HWND)(m_pSite->GetWindow()->window)

CMiniMacSurface::CMiniMacSurface(IUnknown* pContext, CMiniBaseSite* pSite)
 :  CMiniBaseSurface(pContext, pSite)
 ,  m_pBlt(NULL)
 ,  m_pRGBBlt(NULL)
 ,  m_pYUVBlt(NULL)
{
}

CMiniMacSurface::~CMiniMacSurface()
{
    _DestroyDestBuffer(0);
}

HX_RESULT CMiniMacSurface::_CreateDestBuffer(int cidIn,
                                             int nWidth, int nHeight,
                                             int& nCount)
{

    HX_RESULT hr = HXR_FAIL;
    int cidOut;
    int nCountIn = nCount;

    // Try to create optimized surfaces and if it fails,
    // try gdi.
    for (int i=0; i<2; i++)
    {

#if defined (HELIX_FEATURE_OPTIMIZED_VIDEO)
        // Only try optimized yuv the first time
        if (i == 0 &&
            !m_pBlt && 
            !m_pYUVBlt)
        {
            m_pYUVBlt = new CMacYUVBlt();
            m_pBlt = m_pYUVBlt;
        }
#endif //HELIX_FEATURE_OPTIMIZED_VIDEO

#if defined (HELIX_FEATURE_GDI_VIDEO)
        if (!m_pBlt && !m_pRGBBlt)
        {
            m_pRGBBlt = new CMacRGBBlt();
            m_pBlt = m_pRGBBlt;
        }
#endif //HELIX_FEATURE_GDI_VIDEO

    
        if (m_pBlt)
        {
            hr =  m_pBlt->CreateSurface(cidIn, cidOut,
                                        nWidth,nHeight,
                                        0, GET_OS_WINDOW(),
                                        nCountIn, nCount);
        }

        if (SUCCEEDED(hr))
        {
            break;
        }
        else
        {
            _DestroyDestBuffer(cidIn);
        }
    }

    return hr;

}
  
HX_RESULT CMiniMacSurface::_LockDestBuffer(UCHAR** ppDestPtr,
                                           LONG32* pnDestPitch,
                                           int& cid,
                                           REF(HXxSize) dstSize,
                                           int nIndex)
{
    return m_pBlt->LockSurface(ppDestPtr, pnDestPitch,
                               cid, dstSize, nIndex);
}

HX_RESULT CMiniMacSurface::_TransferToDestBuffer(UCHAR* pSrcBuffer,
                                                 HXBitmapInfoHeader* pBitmapInfo,
                                                 HXxRect* prSrcRect,
                                                 HXxRect* prDstRect,
                                                 UCHAR* pDstBuffer,
                                                 LONG32 nDstPitch)
{
    HXxSize rSrcSize = {pBitmapInfo->biWidth, pBitmapInfo->biHeight};

    HX_RESULT hr = 
    m_pBlt->FillSurface(m_nSrcCID,
                        pSrcBuffer, &rSrcSize,
                        prSrcRect,                                                                          
                        pDstBuffer, nDstPitch,
                        prDstRect);

    if (FAILED(hr))
    {
    return CMiniBaseSurface::_TransferToDestBuffer(pSrcBuffer,
                                                   pBitmapInfo,
                                                   prSrcRect,
                                                   prDstRect,
                                                   pDstBuffer,
                                                   nDstPitch);
    }
    return hr;

}

HX_RESULT CMiniMacSurface::_UnlockDestBuffer(UCHAR* pSurfPtr, int nIndex)
{
    return m_pBlt->UnlockSurface(pSurfPtr, nIndex);
}

HX_RESULT CMiniMacSurface::_RenderDestBuffer(HXxRect* prSrcRect,
                                             HXxRect* prDstRect,
                                             int nIndex)
{
    HX_RESULT hr = m_pBlt->RenderSurface(&m_dstBufSize,
                                         prSrcRect,
                                         prDstRect,
                                         nIndex);
    return hr;
}

HX_RESULT CMiniMacSurface::_DestroyDestBuffer(int cid, int nCount)
{
    HX_RESULT hr = HXR_OK;
    
    if (m_pBlt)
    {
        m_pBlt->DestroySurface(cid);

        HX_DELETE(m_pRGBBlt);
        HX_DELETE(m_pYUVBlt);
        m_pBlt = NULL;
    }

    return hr;
}

int CMiniMacSurface::GetDstCID(int nIndex)
{
    return (m_pBlt ? m_pBlt->GetCID(nIndex) : CID_UNKNOWN);
}

