#include "hex.h"

/*******************************************************\
 * Description: prints out a line of text to the screen*
 *		the current address line and both the  *
 *		hex and decimal values for the current *
 *		lines. It doesn't return anything      *
\*******************************************************/
void outline(FILE *fp, WINS *win, hexList *head, int linenum, bool printHex)
{
    unsigned int i, c, tmp[BASE];			/* holds char values  */
    hexList *tmpHead = head;				/* tmp linklist head  */

    for (i = 0; i < BASE; i++)				/* set vals to EOF    */
	tmp[i] = -1;

    while (tmpHead != NULL && tmpHead->loc < (linenum * BASE))
	tmpHead = tmpHead->next;			/* advance temp head  */

    for (i = 0; i < BASE; i++) {
	while (tmpHead != NULL && (tmpHead->loc < ((linenum * BASE) + i)))
	    tmpHead = tmpHead->next;
	if (tmpHead != NULL && (tmpHead->loc == ((linenum * BASE) + i)))
	{						/*store val from llist*/
	    tmp[i] = tmpHead->val;
	    tmpHead = tmpHead->next;
	}
    }

    wclrtoeol(win->hex);				/* clear lines        */
    wclrtoeol(win->ascii);

							/*print line's address*/
    wprintw(win->address, (printHex) ? "%08X ":"%08d ", (linenum * BASE));

    rewind(fp);						/* reset the file ptr */
    fseek(fp, (linenum * BASE), 0);			/* set new pos for fp */

    for (i = 0; i < BASE && (c = getc(fp)) != EOF; i++)
    {
	if (tmp[i] != -1) {				/* while not EOF      */
	    c = tmp[i];					/* store val in c     */
	    wattron(win->ascii, A_BOLD);
	    wattron(win->hex, A_BOLD);
	}
	wprintw(win->hex, "%02X ", c);			/* print out hex char */
	wprintw(win->ascii, (isprint(c)) ? "%c":".", c);/* print ascii char   */
	wattroff(win->ascii, A_BOLD);
	wattroff(win->hex, A_BOLD);
    }
}

/*******************************************************\
 * Description: determines the maximum size of the     *
 *		flie.  It returns the number of chars  *
 *		in the file                            *
\*******************************************************/
int maxLoc(FILE *fp)
{
    fseek(fp, 0, SEEK_END);				/* seek to end of file*/
    return((int)ftell(fp));				/* return val at EOF  */
}

/******************************************************\
 * Description: prints out the command line help info *
 *		this function does not return anything*
\******************************************************/
void print_usage()
{
    char *ver = HVERSION; 

    printf("hexcurse, version %s by FishMoth (jewfish and armoth)\n",ver);
    printf("\nusage: hexcurse [-?|help] [-a] [-r rnum] [-o outputfile] "); 
    printf("[[-i] infile]\n\n");
    printf("    -a\t\tOutput addresses in decimal format initially\n");
    printf("    -r rnum\tResize the display to \"rnum\" bytes wide\n");
    printf("    -o outfile\tWrite output to outfile by default\n"); 
    printf("    -? | -help\tDisplay usage and version of hexcurse program\n");
    printf("    [-i] infile\tRead from data from infile (-i required if not last argument)\n\n");
}

/*******************************************************\
 * Description: Determines the maximum lines that will *
 *		be displayed in the hexeditor.  The    *
 *		values is returned as an integer       *
\******************************************************/
int maxLines(int len)
{   if ((len % BASE) !=0)				/* mod len by BASE    */
        return(len/BASE);				
    else						/* so extra line wont */
        return(len/BASE - 1);				/* be printed out     */
    return(len/BASE);
}

/********************************************************\
 * Description: opens file specified at input returning *
 *		non-zero if the file opened correctly   *
\********************************************************/
int openfile(WINS *win, char *fpINfilename)
{
    char *ch;
    FILE *tmpfp;                                        /* temp pointer       */

    ch = (char *) malloc(81);

    wmove(win->hex_outline, LINES-1, 21);               /* output prompt      */
    wclrtoeol(win->hex_outline);
    mvwaddstr(win->hex_outline, LINES - 1, 1, "Enter file to open: ");

    if (!fpINfilename)
        fpINfilename = (char *) malloc(81);             /* allocate if NULL   */

    ch = inputLine(win->hex_outline, LINES - 1, 21);	/* get filename       */

    if (ch[0] != '\0')
        strncpy(fpINfilename, ch, 80);

    if (!(tmpfp = fopen(fpINfilename, "r")))            /* if cannot open...  */
    {
        wmove(win->hex_outline, LINES-1, 1);
        wclrtoeol(win->hex_outline);
							 /* output message    */
        /*mvwaddstr(win->hex_outline, LINES - 1, 1, "Could not open file");*/
        popupWin("Could not open file!", -1);
        restoreBorder(win);
        wnoutrefresh(win->hex_outline);			/* refresh window     */

        return FALSE;                                   /* return bad         */
    }

    restoreBorder(win);					/* restore border     */

    wrefresh(win->hex_outline);                         /* refresh window     */
    fclose(tmpfp);                                      /* close temp pointer */

    fpIN = fopen(fpINfilename, "r");                    /* open file: read    */

    wclear(win->hex);                                   /* clear windows      */
    wclear(win->ascii);
    wclear(win->address);

    refreshall(win);                                    /* refresh everything */
    doupdate();                                         /* update screen      */
    return TRUE;                                        /* return good        */
}

/********************************************************\
 * Description: saves file specified from input, and    *
 *		doesn't return anything                 *
\********************************************************/
void savefile(WINS *win, hexList *head, char *fpINfilename, char *fpOUTfilename)
{
    char *ch;                                           /* temp string        */
    ch = (char *) malloc(81);                           /* malloc temp string */

    if (!fpINfilename)
        fpINfilename = (char *) malloc(81);             /* allocate if NULL   */

    wmove(win->hex_outline, LINES-1, 20);               /* clear line and     */
    wclrtoeol(win->hex_outline);                        /* output prompt      */
    mvwprintw(win->hex_outline, LINES-1, 1, "Enter file to save: %s",
             (strcmp(fpOUTfilename, "")) ? fpOUTfilename:fpINfilename);

    wrefresh(win->hex_outline);                         /* refresh window     */

    ch = inputLine(win->hex_outline, LINES - 1, 21);	/* get filename       */

    if (ch[0] != '\0')                                  /* if string exist... */
        strncpy(fpOUTfilename, ch, 80);                 /* copy into fileout  */

    if (!strcmp(fpOUTfilename, fpINfilename))           /* if infile...       */
        strcpy(fpOUTfilename, "");			/* clear string       */

                                                        /*write to file       */
    if (!writeChanges(win, fpIN, fpOUT, head, fpINfilename, fpOUTfilename))
        popupWin("The file has been saved.", -1);

    restoreBorder(win);
    wnoutrefresh(win->hex_outline);
}

/********************************************************\
 * Description: searches for a series of either hex or  *
 *		ascii values of upto 16 bytes long.  The*
 *		function returns the next location of   *
 *		the specified string or -1 if not found *
\********************************************************/
int hexSearch(FILE *fp, int ch[], int startfp, int length, hexList *head)
{
    int loop, tmp, c;
    long int currLoc, startLoc;				/* init vars          */

    fseek(fp, startfp, SEEK_SET);			/* begin from loc     */

    c = getc(fp);					/* get char from file */
    currLoc = ftell(fp);				/* get location       */
    if ((tmp = searchList(head, currLoc-1)) != -1)	/* check for val in ll*/
	c = tmp;

    while (currLoc != startfp) {			/* while not back to
							   beginning...       */
	if (c == ch[0]) {				/* if char we want... */
	    startLoc = ftell(fp);			/* get location       */

							/* loop to find rest  */
	    for (loop = 1; (loop < length) && (c != EOF); loop++)
	    {
		c = fgetc(fp); 
    		currLoc = ftell(fp);
    		if ((tmp = searchList(head, currLoc-1)) != -1)
		    c = tmp;
		if (c != ch[loop])
		    break;
		    
	    }

	    if (loop == length)				/* if found it        */
		return startLoc - 1;			/* return location    */
	}

	if (c == EOF)					/* if EOF rewind      */
	    rewind(fp);

        currLoc = ftell(fp);				/* current location   */

	if (currLoc != startfp) 			/* if not at start... */
	{
	    c = fgetc(fp);				/* get another char   */
    	    currLoc = ftell(fp);
    	    if ((tmp = searchList(head, currLoc-1)) != -1)
	        c = tmp;
	}

    }

    return -1;						/* return not found   */
}

/********************************************************\
 * Description: goes to a certain location in the file  *
 * Returns:     currentLine (in file)                   *
\********************************************************/
int gotoLine(WINS *win, FILE *fp, int currLoc, int gotoLoc, int maxlines,
             hexList *head, int printHex, int editHex, WINDOW *windows)
{
    int count, currentLine, row, col, tmp, linediff;

    getyx(windows, row, col);

    restoreBorder(win);					/* restore border     */

    wrefresh(win->hex_outline);
    currentLine = maxLines(gotoLoc);

    if ((gotoLoc % BASE) == 0)
        currentLine++;

    /* we must calculate the lines between the currloc and gotoLoc.       *\
     * we do this by calculating the line number for the value of currloc *
     * if it was on the first row and substract it from the line number   *
     * of gotoLoc.  If it's less then MAXY then it's on the the that      *
     * means the destination is visible on the screen and that the cursor *
    \* should move to the spot rather then scroll to the position         */

    if (gotoLoc >= currLoc) /* the destination is below the current loc   */
    {
        tmp = currLoc - (row * BASE);
        linediff=currentLine-((tmp%BASE) ? maxLines(tmp) : maxLines(++tmp));
    }
    else /*the dest is above the current location, must handle differently*/
    {
        tmp = currLoc + ((MAXY - row) * BASE);
        linediff = currentLine
                 - ((tmp%BASE) ? maxLines(tmp) : maxLines(++tmp));
        if (linediff >= (MAXY*-1) && linediff < 1) linediff += MAXY;
    }

    if (linediff < 1) linediff *= -1;                   /* take abs value     */

    if (linediff <= MAXY) /* if the dest on the same screen as currloc   */
    {
        /* now move position w/o scrolling dest line to the top of screen */
        wmove((editHex) ? win->hex : win->ascii, linediff , (editHex) ?
             ((gotoLoc % BASE) * 3) : (gotoLoc % BASE));
    }
    else
    {

        wclear(win->hex);                               /* clear windows      */
        wclear(win->ascii);
        wclear(win->address);

        wmove(win->hex, 0, 0);                          /*position cursors    */
        wmove(win->ascii, 0, 0);
        wmove(win->address, 0, 0);
                                                        /* output lines       */
        for (count = 0; count <= MAXY && (count + currentLine)<=maxlines;
            count++)
            outline(fp, win, head, count+currentLine, printHex);

        wmove((editHex) ? win->hex : win->ascii, 0, (editHex) ?
             ((gotoLoc % BASE) * 3) : (gotoLoc % BASE));
                                                        /* restore cursor     */
    }
#ifdef DEBUG_GOTO
        mvwprintw(win->hex_outline,0,20,"                      ");
        mvwprintw(win->hex_outline,0,10,"value:%d    location:%d %d %d %d",
        maxLines(tmp), maxLines(gotoLoc), linediff, gotoLoc, MAXY);
#endif

    wnoutrefresh(win->scrollbar);                       /* refresh screen     */
    wnoutrefresh(win->ascii);
    wnoutrefresh(win->address);
    wnoutrefresh(win->hex);
    doupdate();                                         /* update screen      */

    return currentLine;
}
