;;; hnf-yotei.el --- major mode for HyperNikkiSystem yotei file

;; Copyright (C) 1999-2000 by Akihiro Arisawa <ari@nijino.com>

;; Author: Akihiro Arisawa <ari@nijino.com>
;; Version: $Id: hnf-yotei.el,v 3.4 2000/08/15 08:04:04 ari Exp $
;; Keywords: hns nikki yotei

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; $B!ZFCD'![(B
;; HNS$B$N(BN$B%u7nJ,$NM=Dj$NF~NO$r0l$D$N%P%C%U%!$G9T$($^$9!#(B(N$B$O%G%U%)%k%H(B3)
;;
;; $B!Z@_Dj![(B
;; 1. hnf-mode.el, hnf-yotei.el $B$r(Bload-path$B$NDL$C$?$H$3$m$KCV$-$^$9!#(B
;; 2. ~/.emacs $B$K0J2<$N5-=R$r$7$^$9!#(B
;;    (autoload 'yotei "hnf-yotei" nil t)
;;
;; $B!Z;H$$J}![(B
;; 1. M-x yotei $B$G(B*yotei*$B%P%C%U%!$r3+$-$^$9!#(B
;; 2. $BE,59JT=8$7$^$9!#(B
;; 3. C-xC-s$B$GJ]B8$7$^$9!#(B
;;
;; $B!Z%P%0(B or $B;EMM![(B
;; 1. hnf-yotei-diary-year-directoryp$B$r(Bt$B$K$7$F$$$k>l9g!"B8:_$7$J$$%G%#%l%/%H%j(B
;;    $B$K=q$-9~$_$K$$$C$F%(%i!<$K$J$k2DG=@-$,$"$j$^$9!#(B
;;
;; $B!Z(BEmacsen$B![(B
;; $B3+H/$O(Bemacs-20$B$G9T$C$F$$$^$9!#(B
;; XEmacs-20/21$B$d(Bmule-2.3@emacs-19.34$B$G$bF0$/$H$O;W$$$^$9!#(B
;;
;; $B!Z<U<-![(B
;; all.el$B$r$+$J$j;29M$K$5$;$F$$$?$@$-$^$7$?!#:n<T$G$"$k!"(BPer Abrahamsen$B$5$s$K(B
;; $BB?Bg$K46<U$7$^$9!#(B

;;; Code:
(require 'hnf-mode)

(defvar hnf-yotei-range 3)
(defvar hnf-yotei-diary-year-directory-flag hnf-diary-year-directory-flag)

(defvar hnf-yotei-buffer nil)
(defvar hnf-yotei-mode-map nil)
(defvar hnf-yotei-hook nil)

(if hnf-yotei-mode-map nil
  (setq hnf-yotei-mode-map (make-sparse-keymap))
  (define-key hnf-yotei-mode-map "\C-x\C-s" 'hnf-yotei-save))

(defun hnf-yotei (&optional arg)
  "HNS$B$NM=Dj$r5-=R$9$k%b!<%I(B"
  (interactive "P")
  (let* ((this-year (nth 5 (decode-time)))
	 (this-month (nth 4 (decode-time)))
	 (year this-year)
	 (month this-month)
	 (range (cond ((null arg)
		       hnf-yotei-range)
		      ((listp arg)
		       (string-to-number (read-from-minibuffer
					  "$B2?%v7nJ,JT=8$7$^$9$+(B?: "
					  (number-to-string hnf-yotei-range))))
		      ((integerp arg)
		       arg)))
	 (r 0))
    (if (<= range 0) (setq range hnf-yotei-range))
    
    (switch-to-buffer (setq hnf-yotei-buffer (get-buffer-create "*yotei*")))

    (if (buffer-modified-p) nil
      ; $B=`Hw(B
      (let ((inhibit-read-only t))
	(erase-buffer)
	(mapcar (function delete-overlay)
		(overlays-in (point-min) (point-max))))
      ; $B%U%!%$%k$NFI9~$_(B
      (while (< r range)
	(hnf-yotei-open-and-insert year month)
	(setq month (1+ month))
	(if (= month 13)
	    (setq year (1+ year)
		  month 1))
	(setq r (1+ r)))
      ; $B;E3]$$$m$$$m(B
      (hnf-yotei-set-insert-behind-hooks)
      (setq buffer-undo-list nil)
      (set-buffer-modified-p nil))
    (use-local-map hnf-yotei-mode-map)
    (setq mode-name "YOTEI")
    (setq major-mode 'hnf-yotei)
    (run-hooks 'hnf-yotei-hook)
    ))

(defalias 'yotei 'hnf-yotei)

(defun hnf-yotei-open-and-insert (year month)
  (let ((file (concat hnf-diary-dir "/"
		      (and hnf-yotei-diary-year-directory-flag
			   (concat (number-to-string year) "/"))
		      (format "y%4d%02d" year month)))
	(beg (point))
	(marker (make-marker))
	overlay)
    ;; $BG/7n$NI=<((B
    (insert (format "%4d$BG/(B%02d$B7n(B\n" year month))
    (put-text-property beg (point) 'rear-nonsticky t)
    (put-text-property beg (point) 'face 'highlight)
    (put-text-property beg (point) 'intangible t)
    (put-text-property beg (1- (point)) 'read-only t)
    ;; *yotei*$B$KA^F~(B
    (setq beg (point))
    (if (file-exists-p file) (insert-file-contents file) (insert "\n"))
    (goto-char (point-max))
    (overlay-put (setq overlay (make-overlay beg (point))) 'file file)
    ))

(defun hnf-yotei-set-insert-behind-hooks ()
  (let ((overlays (overlays-in (point-min) (point-max)))
	overlay)
    (while (setq overlay (car overlays))
      (overlay-put overlay 'insert-behind-hooks '(hnf-yotei-extent-overlay))
      (setq overlays (cdr overlays)))))

(defun hnf-yotei-extent-overlay (overlay &rest junk)
  "overlay$B$r%+!<%=%k0LCV$^$G?-$P$7$^$9!#(B"
  (move-overlay overlay (overlay-start overlay) (point)))

(defun hnf-yotei-save ()
  (interactive)
  (let ((require-final-newline t)
	(overlays (overlays-in (point-min) (point-max)))
	overlay file content)
    (while (setq overlay (car overlays))
      (if (setq file (overlay-get overlay 'file))
	  (write-region (overlay-start overlay) (overlay-end overlay) file))
      (setq overlays (cdr overlays)))
    (set-buffer-modified-p nil)))

(provide 'hnf-yotei)
;;; hnf-yotei.el ends here
