/* $Id: init.cc 1134 2006-02-18 18:52:39Z holger $
 *
 * HoiChess/init.cc
 *
 * Copyright (C) 2004, 2005 Holger Ruckdeschel <holger@hoicher.de>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 */

#include "common.h"
#include "bitboard.h"
#include "board.h"

#include <time.h>

const char piece_char[] = { 'P', 'N', 'B', 'R', 'Q', 'K' };
const char file_char[] = { 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h' };
const char rank_char[] = { '1', '2', '3', '4', '5', '6', '7', '8' };
const char square_str[][3] = {
	"a1", "b1", "c1", "d1", "e1", "f1", "g1", "h1",
	"a2", "b2", "c2", "d2", "e2", "f2", "g2", "h2",
	"a3", "b3", "c3", "d3", "e3", "f3", "g3", "h3",
	"a4", "b4", "c4", "d4", "e4", "f4", "g4", "h4",
	"a5", "b5", "c5", "d5", "e5", "f5", "g5", "h5",
	"a6", "b6", "c6", "d6", "e6", "f6", "g6", "h6",
	"a7", "b7", "c7", "d7", "e7", "f7", "g7", "h7",
	"a8", "b8", "c8", "d8", "e8", "f8", "g8", "h8"
};

const int mat_values[] = {
	100,
	300,
	325,
	500,
	900,
	0
};

int sq_distance[64][64];

void init_sq_distance()
{
	for (unsigned int f=0; f<64; f++) {
		for (unsigned int t=0; t<64; t++) {
			int rd = abs(RNK(t)-RNK(f));
			int fd = abs(FIL(t)-FIL(f));
			sq_distance[f][t] = MAX(rd, fd); 
		}
	}

}

/*****************************************************************************
 * 
 * This is the main initialization function.
 * Make sure it is called before doing anything else.
 *
 *****************************************************************************/

void init()
{
	init_sq_distance();
	Bitboard::init();
	Board::init();

	srand(time(NULL));

	
#ifdef WIN32
	/* Completely disable I/O buffering on WIN32 platforms. */
	setbuf(stdin, NULL);
	setbuf(stdout, NULL);
	setbuf(stderr, NULL);
	setvbuf(stdin, NULL, _IONBF, 0);
	setvbuf(stdout, NULL, _IONBF, 0);
	setvbuf(stderr, NULL, _IONBF, 0);
#endif
}

void fini()
{
#ifdef STATS_MOVELIST
	Movelist::print_stats();
#endif
}	

