/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_BUTTON_H
#define _HRN_BUTTON_H

#include <clutter/clutter.h>
#include <nbtk/nbtk.h>

G_BEGIN_DECLS

#define HRN_TYPE_BUTTON    hrn_button_get_type ()

#define HRN_BUTTON(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_BUTTON, HrnButton))

#define HRN_BUTTON_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass),  HRN_TYPE_BUTTON, HrnButtonClass))

#define HRN_IS_BUTTON(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_BUTTON))

#define HRN_IS_BUTTON_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),  HRN_TYPE_BUTTON))

#define HRN_BUTTON_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),  HRN_TYPE_BUTTON, HrnButtonClass))

typedef struct _HrnButton HrnButton;
typedef struct _HrnButtonClass HrnButtonClass;
typedef struct _HrnButtonPrivate HrnButtonPrivate;

struct _HrnButton
{
  NbtkButton        parent_instance;
  HrnButtonPrivate *priv;
};

struct _HrnButtonClass
{
  /*< private >*/
  NbtkButtonClass parent_class;
};

GType       hrn_button_get_type (void) G_GNUC_CONST;

NbtkWidget *hrn_button_new (void);

G_END_DECLS

#endif
