/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_ITEM_VIDEO_H
#define _HRN_ITEM_VIDEO_H

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_ITEM_VIDEO    hrn_item_video_get_type ()

#define HRN_ITEM_VIDEO(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_ITEM_VIDEO, HrnItemVideo))

#define HRN_ITEM_VIDEO_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_ITEM_VIDEO, HrnItemVideoClass))

#define HRN_IS_ITEM_VIDEO(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_ITEM_VIDEO))

#define HRN_IS_ITEM_VIDEO_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_ITEM_VIDEO))

#define HRN_ITEM_VIDEO_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_ITEM_VIDEO, HrnItemVideoClass))

typedef struct _HrnItemVideo HrnItemVideo;
typedef struct _HrnItemVideoClass HrnItemVideoClass;
typedef struct _HrnItemVideoPrivate HrnItemVideoPrivate;

struct _HrnItemVideo
{
  HrnItem              parent_instance;
  HrnItemVideoPrivate *priv;
};

struct _HrnItemVideoClass
{
  /*< private >*/
  HrnItemClass parent_class;
};

GType         hrn_item_video_get_type (void) G_GNUC_CONST;
HrnItemVideo *hrn_item_video_create  (BklItem *item,
                                      gboolean square);

G_END_DECLS

#endif
