/* 
 *	HT Editor
 *	dataanaly.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Sebastian Biallas (sb@web-productions.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *	this module was designed to regonize common data structures by
 *	analysing the way of accessing the data as well as analysing the
 *	data itself.
 */

#include <stdio.h>
#include <stdlib.h>
#include "analy.h"
#include "analy_register.h"
#include "dataanaly.h"
#include "global.h"

//#undef dprintf
//#define dprintf(msg...) printf(##msg)

void analyser_put_addrtype(ht_object_stream *f, const taddrtype *at)
{
	byte t = (taddrtypetype)at->type;
	f->put_int_dec(t, 1, "type");
	switch (t) {
		case dtunknown:
			break;
		case dtcode:
			f->put_int_dec(at->codesubtype, 1, "type");
			break;
		case dtunknowndata:
			break;
		case dtint:
			f->put_int_dec(at->intsubtype, 1, "type");
			f->put_int_dec(at->length, 1, "length");
			break;
		case dtfloat:
			f->put_int_dec(at->floatsubtype, 1, "type");
			f->put_int_dec(at->length, 1, "length");
			break;
		case dtarray:
			f->put_int_dec(at->arraysubtype, 1, "type");
			f->put_int_dec(at->length, 1, "length");
			break;
	}     
}

int analyser_get_addrtype(ht_object_stream *f, taddrtype *at)
{
	at->type = (taddrtypetype)f->get_int_dec(1, "type");
	switch (at->type) {
		case dtunknown:
			break;
		case dtcode:
			at->codesubtype = (taddrcodesubtype)f->get_int_dec(1, "type");
			break;
		case dtunknowndata:
			break;
		case dtint:
			at->intsubtype = (taddrintsubtype)f->get_int_dec(1, "type");
			at->length = f->get_int_dec(1, "length");
			break;
		case dtfloat:
			at->floatsubtype = (taddrfloatsubtype)f->get_int_dec(1, "type");
			at->length = f->get_int_dec(1, "length");
			break;
		case dtarray:
			at->arraysubtype = (taddrarraysubtype)f->get_int_dec(1, "type");
			f->put_int_dec(at->length, 1, "length");
			break;
	}
	return f->get_error();
}

/*
 *
 *	types to recognize:
 *		- bytes/words/dwords (by access)
 *		- strings (by examinating)
 *			- pascal
 *			- c
 *             - unicode
 *		- arrays (by access)
 *        - records (partially)
 */
void	dataanalyser::init(analyser *Analy)
{
	analy = Analy;
}

int 	dataanalyser::load(ht_object_stream *f)
{
	return 0;
}

void	dataanalyser::done()
{
}

OBJECT_ID	dataanalyser::object_id()
{
	return ATOM_DATA_ANALYSER;
}

void	dataanalyser::access(ADDR Addr, OP op, int size)
{
}

void	dataanalyser::setaddrtype(ADDR Addr, taddrtypetype type, int subtype, int length)
{
	setaddrtype(analy->new_addr(Addr), type, subtype, length);
}

void	dataanalyser::setaddrtype(taddr *Addr, taddrtypetype type, int subtype, int length)
{
	dprintf("Addr %08lx set to %d (%d) length %d\n", Addr->addr, type, subtype, length);
	Addr->type.type = type;
	Addr->type.subtype = subtype;
	Addr->type.length = length;
}

void	dataanalyser::setcodeaddrtype(ADDR Addr, taddrcodesubtype subtype)
{
	setaddrtype(analy->new_addr(Addr), dtcode, subtype, 0);
}

void	dataanalyser::setcodeaddrtype(taddr *Addr, taddrcodesubtype subtype)
{
	setaddrtype(Addr, dtcode, subtype, 0);
}

void	dataanalyser::setintaddrtype(ADDR Addr, taddrintsubtype subtype, int length)
{
	setaddrtype(analy->new_addr(Addr), dtint, subtype, length);
}

void	dataanalyser::setintaddrtype(taddr *Addr, taddrintsubtype subtype, int length)
{
	setaddrtype(Addr, dtint, subtype, length);
}

void	dataanalyser::setfloataddrtype(ADDR Addr, taddrfloatsubtype subtype, int length)
{
	setaddrtype(analy->new_addr(Addr), dtfloat, subtype, length);
}

void	dataanalyser::setfloataddrtype(taddr *Addr, taddrfloatsubtype subtype, int length)
{
	setaddrtype(Addr, dtfloat, subtype, length);
}

void	dataanalyser::setarrayaddrtype(ADDR Addr, taddrarraysubtype subtype, int length)
{
	setaddrtype(analy->new_addr(Addr), dtarray, subtype, length);
}

void	dataanalyser::setarrayaddrtype(taddr *Addr, taddrarraysubtype subtype, int length)
{
	setaddrtype(Addr, dtarray, subtype, length);
}

void	dataanalyser::store(ht_object_stream *f)
{
}

