/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
//
// misc-proc.c
//
// specialized markup processors
//
// Copyright (c) 1995-96 Jim Nelson.  Permission to distribute
// granted by the author.  No warranties are made on the fitness of this
// source code.
//
*/

#include "misc-proc.h"

#include "defs.h"
#include "option.h"

uint CommentProcessor(TASK *task, HTML_MARKUP *htmlMarkup, char **newPlaintext)
{
    UNREF_PARAM(htmlMarkup);
    UNREF_PARAM(newPlaintext);

    /* authors ego-gratifying easter egg */
    /* put a final comment at the end of the output file */
    StreamPrintF(task->outfile, "\n\n<!-- HTML pre-processed by %s %s -->\n\n",
                 PROGRAM_NAME, VER_STRING);

    return MARKUP_OKAY;
}


uint HtpCommentProcessor(TASK *task, HTML_MARKUP *htmlMarkup, char **newPlaintext)
{
    UNREF_PARAM(task);
    UNREF_PARAM(htmlMarkup);
    UNREF_PARAM(newPlaintext);

    return DISCARD_MARKUP;
}

uint QuoteProcessor(TASK *task, HTML_MARKUP *htmlMarkup, char **newPlaintext)
{
    int i;
    UNREF_PARAM(task);
    UNREF_PARAM(newPlaintext);

    if (htmlMarkup->attribCount == 0) {
        HtpMsg(MSG_ERROR, task->infile, "improper QUOTE syntax");
        return MARKUP_ERROR;
    }
    htmlMarkup->tag = htmlMarkup->attrib[0].name;
    for (i = 1; i < htmlMarkup->attribCount; i++)
	htmlMarkup->attrib[i - 1] = htmlMarkup->attrib[i];
    htmlMarkup->attribCount--;

    return MARKUP_OKAY;
}



uint ConditionalWarning(TASK *task, HTML_MARKUP *htmlMarkup, char **newPlaintext)
{
    UNREF_PARAM(htmlMarkup);
    UNREF_PARAM(newPlaintext);

    HtpMsg(MSG_ERROR, task->infile, "IFNOT tag no longer recognized; use IF NOT instead");
    return MARKUP_ERROR;
}



uint PreProcessor(TASK *task, HTML_MARKUP *htmlMarkup, char **newPlaintext)
{
    UNREF_PARAM(htmlMarkup);
    UNREF_PARAM(newPlaintext);

    /* the CONDENSE option cannot be utilized inside a <PRE>...</PRE> */
    /* block, because there HTML DOES interpret CR's */
    if(CONDENSE || SEMICONDENSE)
    {
        if(IsMarkupTag(htmlMarkup, "PRE"))
        {
            AllowLinefeeds(task->outfile);
        }
        else if(IsMarkupTag(htmlMarkup, "/PRE"))
        {
            if (CONDENSE) 
            {
                SuppressLinefeeds(task->outfile);
            }
            else
            {
                SingleLinefeeds(task->outfile);
            }
        }
    }

    return MARKUP_OKAY;
}


