/*
 * FILE : swig_wrap.c
 *
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 5)
 *
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 *
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : TCL 8.0 */

#define INCLUDE_TCL    <tcl.h>
#define INCLUDE_TK     <tk.h>
#include INCLUDE_TCL
#include <string.h>
#include <stdlib.h>
#define SWIGTCL
#define SWIGTCL8
/*
 * $Header: /b2/dmb/SWIG/SWIG1.0b3/swig_lib/tcl/RCS/swigtcl.cfg,v 1.1 1996/05/22 19:47:45 beazley Exp $
 *
 * swigtcl.cfg
 *
 * This file is modified from a platform independent file provided
 * by Sun.   With any luck this will allow SWIG generated wrapper
 * files to work on Unix, Windows, and Macintosh.
 *
 * Revision History
 * $Log: swigtcl.cfg,v $
 * Revision 1.1  1996/05/22 19:47:45  beazley
 * Initial revision
 *
 *
 * -- Dave Beazley, May 2, 1996.
 *
 *	This file is an example of a Tcl dynamically loadable extension.
 *
 * Copyright (c) 1996 by Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */

#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#	define DllEntryPoint DllMain
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#ifdef __WIN32__
BOOL APIENTRY
DllEntryPoint(HINSTANCE hInst, DWORD reason, LPVOID reserved)
{
    return TRUE;
}
#endif

/**************************************************************************
 * $Header:$
 *
 * tcl8ptr.swg
 *
 * This file provides type-checked pointer support to Tcl 8.0.
 * Pointers are installed as new kinds of Tcl 8.0 objects consisting
 * of the following structure
 *
 * typedef struct {
 *         char     *name;            Name of the datatype
 *         void     *value;           Value of the pointer
 * } Tcl_SwigPtr;
 *
 * While we still need to perform string comparisons on the
 * type-name, this function no longer needs to convert pointer
 * values to hex so it should be a little faster.
 *
 * New Tcl datatypes are defined by the following data structure.
 *
 * typedef struct Tcl_ObjType {
 *              char *name;
 *              Tcl_FreeInternalRepProc *freeIntRepProc;
 *              Tcl_DupInternalRepProc *dupIntRepProc;
 *              Tcl_UpdateStringProc *updateStringProc;
 *              Tcl_SetFromAnyProc *setFromAnyProc;
 *             } Tcl_ObjType;
 *
 * Functions for manipulating SWIG pointers in wrapper code are:
 *
 *     void *SWIG_SetPointerObj(objPtr, ptr, type)
 *     char *SWIG_GetPointerFromObj(objPtr, *ptr, type)
 *
 **********************************************************************/

#ifdef SWIG_GLOBAL
#include <tcl.h>
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

/* These are internal variables.   Should be static */

typedef struct SwigPtrType {
  char               *name;
  int                 len;
  void               *(*cast)(void *);
  struct SwigPtrType *next;
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Array containing start locations (for searching) */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}


/*---------------------------------------------------------------------
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *))
 *
 * Register a new type-mapping with the type-checking system.
 *---------------------------------------------------------------------*/

SWIGSTATIC
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0, *t1;

  if (!SwigPtrTable) {
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc(SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(origtype);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }
  while (t->next) {
    if (strcmp(t->name,newtype) == 0) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(newtype);
  t1->cast = cast;
  t1->next = 0;
  t->next = t1;
  SwigPtrSort = 0;
}


/*---------------------------------------------------------------------
 * void SWIG_SetPointerObj(Tcl_Obj *objPtr, void *ptr, char *type)
 *
 * Sets a Tcl object to a pointer value.
 *           ptr = void pointer value
 *           type = string representing type
 *
 *---------------------------------------------------------------------*/



/* This is for backwards compatibility */



/*---------------------------------------------------------------------
 * char *SWIG_GetPointerObj(Tcl_Interp *interp, Tcl_Obj *objPtr, void **ptr, char *type)
 *
 * Attempts to extract a pointer value from our pointer type.
 * Upon failure, returns a string corresponding to the actual datatype.
 * Upon success, returns NULL and sets the pointer value in ptr.
 *---------------------------------------------------------------------*/



/*---------------------------------------------------------------------
 * void SWIG_RegisterType()
 *
 * Registers our new datatype with an interpreter.
 *---------------------------------------------------------------------*/

SWIGSTATIC
void SWIG_RegisterType() {
  /* Does nothing at the moment */
}
#define SWIG_init    Ibdm_Init
#define SWIG_name    "ibdm"
#define SWIG_prefix  ""
#define SWIG_namespace ""

#ifdef __cplusplus
extern "C" {
#endif
#ifdef MAC_TCL
#pragma export on
#endif
SWIGEXPORT(int,Ibdm_Init)(Tcl_Interp *);
#ifdef MAC_TCL
#pragma export off
#endif
#ifdef __cplusplus
}
#endif

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <inttypes.h>
#include <sstream>
#include "Fabric.h"
#include "SubnMgt.h"
#include "CredLoops.h"
#include "TraceRoute.h"
#include "TopoMatch.h"
#include "Congestion.h"

# if __WORDSIZE == 64
#  define __PRI64_PREFIX   "l"
#  define __PRIPTR_PREFIX  "l"
# else
#  define __PRI64_PREFIX   "ll"
#  define __PRIPTR_PREFIX
# endif
#ifndef PRIx64
# define PRIx64         __PRI64_PREFIX "x"
#endif

  /* GLOBALS */
  static char ibdm_tcl_error_msg[1024];
  static int  ibdm_tcl_error;
  static vector< IBFabric *> ibdm_fabrics;
  static IBLinkWidth UnknownLinkWidth = IB_UNKNOWN_LINK_WIDTH;
  static IBLinkSpeed UnknownLinkSpeed = IB_UNKNOWN_LINK_SPEED;
  static IBLinkWidth DefaultLinkWidth = IB_LINK_WIDTH_4X;
  static IBLinkSpeed DefaultLinkSpeed = IB_LINK_SPEED_2_5;

  /*
	  MAPPING IBDM OBJECTS TO TCL and BACK:
	  The idea is that we have specifc rules for naming
	  Node, Port, System and SystemPort for a specific Fabric.

	  All Fabrics are stored by id in a global vector.

	  So the object names will follow:
	  <type>:<fabricIdx>/<name>

  */

  /* Given a fabric pointer return its idx (starting w 1) or 0 */
  int ibdmGetFabricIdxByPtr(IBFabric *p_fabric) {
	 /* go over all fabrics and find it's index: */
	 for (unsigned int i = 0; i < ibdm_fabrics.size(); i++) {
		if (ibdm_fabrics[i] == p_fabric) {
		  return(i+1);
		}
	 }
	 return(0);
  }

  /* Given a fabric idx return it's pointer */
  /* Note the index is 1-N and thus we need to -1 it before access */
  IBFabric *ibdmGetFabricPtrByIdx(unsigned int idx) {
	 if ((idx > ibdm_fabrics.size()) || (idx < 1)) {
		return NULL;
	 }
	 return ibdm_fabrics[idx - 1];
  }

  /*
	 we provide our own constructor such that all IBFabrics are
	 registered in the global vector;
  */
  IBFabric *new_IBFabric(void) {
	 IBFabric *p_fabric = new IBFabric();
    unsigned int i;
	 if (p_fabric) {
      /* look for an open index in the vector of fabrics */
      for (i = 0; i < ibdm_fabrics.size(); i++)
      {
        if (ibdm_fabrics[i] == NULL)
        {
          ibdm_fabrics[i] = p_fabric;
          return p_fabric;
        }
      }
      ibdm_fabrics.push_back(p_fabric);
	 }
	 return p_fabric;
  }

  /*
	 we provide our own destructor such that the deleted fabric is
    de-registered from the global fabrics vector
  */
  void delete_IBFabric(IBFabric *p_fabric) {
    int idx = ibdmGetFabricIdxByPtr(p_fabric);
    if (! idx) {
      printf("ERROR: Fabric idx:%p does not exist in the global vector!\n",
             p_fabric);
    } else {
      ibdm_fabrics[idx-1] = NULL;
    }
    delete p_fabric;
  }

  /* Given the Object Pointer and Type provide it's TCL name */
  int ibdmGetObjTclNameByPtr(Tcl_Obj *objPtr, void *ptr, char *type) {
	 char tclName[128];
	 char name[128];
	 IBFabric *p_fabric;
	 string uiType;

	 if (!strcmp(type, "IBNode *")) {
		IBNode *p_node = (IBNode *)ptr;
		p_fabric = p_node->p_fabric;
		sprintf(name, ":%s", p_node->name.c_str());
		uiType = "node";
	 } else if (!strcmp(type, "IBPort *")) {
		IBPort *p_port = (IBPort *)ptr;
		sprintf(name,":%s/%u", p_port->p_node->name.c_str(), p_port->num);
		p_fabric = p_port->p_node->p_fabric;
		uiType = "port";
	 } else if (!strcmp(type, "IBSystem *")) {
		IBSystem *p_system = (IBSystem *)ptr;
		sprintf(name, ":%s", p_system->name.c_str());
		uiType = "system";
		p_fabric = p_system->p_fabric;
	 } else if (!strcmp(type, "IBSysPort *")) {
		IBSysPort *p_sysPort = (IBSysPort *)ptr;
		sprintf(name, ":%s:%s",  p_sysPort->p_system->name.c_str(),
				  p_sysPort->name.c_str());
		uiType = "sysport";
		p_fabric = p_sysPort->p_system->p_fabric;
	 } else if (!strcmp(type, "IBFabric *")) {
		p_fabric = (IBFabric *)ptr;
		uiType = "fabric";
		name[0] = '\0';
	 } else {
		sprintf(tclName, "-E- Unrecognized Object Type:%s", type);
		Tcl_SetStringObj(objPtr, tclName, -1);
		return TCL_ERROR;
	 }

	 /* get the fabric index */
	 int idx = ibdmGetFabricIdxByPtr(p_fabric);
	 if (idx == 0) {
		Tcl_SetStringObj(objPtr, "-E- Fail to find fabric by ptr", -1);
		return TCL_ERROR;
	 }

	 sprintf(tclName, "%s:%u%s", uiType.c_str(), idx, name);
	 Tcl_SetStringObj(objPtr, tclName, -1);
	 return TCL_OK;
  }

  /* Given the Object TCL Name Get it's pointer */
  int ibdmGetObjPtrByTclName(Tcl_Obj *objPtr, void **ptr) {
	 /* we need to parse the name and get the type etc. */
	 char buf[256];
	 char *type, *name=0, *fabIdxStr;
	 char *colonIdx, *slashIdx;
	 int fabricIdx;
	 *ptr = NULL;

	 strcpy(buf, Tcl_GetStringFromObj(objPtr,0));

	 /* the format is always: <type>:<idx>[:<name>] */

	 /* first separate the type */
	 colonIdx = index(buf,':');
	 if (!colonIdx) {
		printf("-E- Bad formatted (no :) ibdm object:%s\n", buf);
		return TCL_ERROR;
	 }
	 *colonIdx = '\0';

	 type = buf;
	 fabIdxStr = ++colonIdx;

	 /* now separate the fabric section if tyep is not fabric */
	 if (strcmp(type, "fabric")) {
		slashIdx = index(fabIdxStr,':');
		if (!slashIdx) {
		  printf( "-E- Bad formatted ibdm fabric object:%s\n",
					 Tcl_GetStringFromObj(objPtr,0));
		  return TCL_ERROR;
		}
		*slashIdx = '\0';
		name = ++slashIdx;
	 }

	 /* Ok so now get the fabic pointer */
	 fabricIdx = atoi(fabIdxStr);

	 IBFabric *p_fabric = ibdmGetFabricPtrByIdx(fabricIdx);
	 if (! p_fabric) {
		*ptr = NULL;
		return TCL_ERROR;
	 }

	 if (!strcmp(type, "fabric")) {
		*ptr = p_fabric;
	 } else if (!strcmp(type, "node")) {
		IBNode *p_node = p_fabric->getNode(string(name));
		if (! p_node) {
		  printf("-E- Fail to get node:%s\n", name);
		  return TCL_ERROR;
		}
		*ptr = p_node;
	 } else if (!strcmp(type, "port")) {
		slashIdx = rindex(name,'/');
		if (!slashIdx) {
		  printf("-E- Bad formatted ibdm node object:%s\n",
					Tcl_GetStringFromObj(objPtr,0));
		  return TCL_ERROR;
		}
		*slashIdx = '\0';
		int portNum = atoi(++slashIdx);
		IBNode *p_node = p_fabric->getNode(string(name));
		if (! p_node) {
		  printf("-E- Fail to get node:%s\n", name);
		  return TCL_ERROR;
		}
		IBPort *p_port = p_node->getPort(portNum);
		if (! p_port) {
		  printf("-E- Fail to get node:%s port:%u\n",
					 name, portNum);
		  return TCL_ERROR;
		}
		*ptr = p_port;
	 } else if (!strcmp(type, "system")) {
		IBSystem *p_system = p_fabric->getSystem(string(name));
		if (! p_system) {
		  printf("-E- Fail to get system:%s\n", name);
		  return TCL_ERROR;
		}
		*ptr = p_system;
	 } else if (!strcmp(type, "sysport")) {
		/* the format of system port is:  <type>:<idx>:<sys>:<port> */
		colonIdx = index(name,':');
		if (!colonIdx) {
		  printf("-E- Bad formatted ibdm sysport object:%s\n",
					Tcl_GetStringFromObj(objPtr,0) );
		  return TCL_ERROR;
		}
		*colonIdx = '\0';
		IBSystem *p_system = p_fabric->getSystem(string(name));
		if (! p_system) {
		  printf("-E- Fail to get system:%s\n", name);
		  return TCL_ERROR;
		}
		IBSysPort *p_sysPort = p_system->getSysPort(string(++colonIdx));
		if (! p_sysPort) {
		  printf("-E- Fail to get system:%s port:%s\n", name, colonIdx);
		  return TCL_ERROR;
		}
		*ptr = p_sysPort;
	 } else {
		printf("-E- Unrecognized Object Type:%s\n", type);
		return TCL_ERROR;
	 }
	 return TCL_OK;
  }

  int ibdmReportNonUpDownCa2CaPaths(IBFabric *p_fabric, list_pnode rootNodes) {
    map_pnode_int nodesRank;
    if (SubnRankFabricNodesByRootNodes(p_fabric, rootNodes, nodesRank))
    {
      printf("-E- fail to rank the fabric by the given root nodes.\n");
      return(1);
    }
    return( SubnReportNonUpDownCa2CaPaths(p_fabric, nodesRank));
  }

  int ibdmFatTreeRoute(IBFabric *p_fabric, list_pnode rootNodes) {
    map_pnode_int nodesRank;
    if (SubnRankFabricNodesByRootNodes(p_fabric, rootNodes, nodesRank))
    {
      printf("-E- fail to rank the fabric by the given root nodes.\n");
      return(1);
    }
    return( SubnMgtFatTreeRoute(p_fabric));
  }

  int ibdmCheckFabricMCGrpsForCreditLoopPotential(IBFabric *p_fabric, list_pnode rootNodes) {
    map_pnode_int nodesRank;
    if (SubnRankFabricNodesByRootNodes(p_fabric, rootNodes, nodesRank))
    {
      printf("-E- fail to rank the fabric by the given root nodes.\n");
      return(1);
    }
    return( SubnMgtCheckFabricMCGrpsForCreditLoopPotential(p_fabric, nodesRank));
  }

  int ibdmRankFabricByRoots(IBFabric *p_fabric, list_pnode rootNodes) {
    map_pnode_int nodesRank;
    if (SubnRankFabricNodesByRootNodes(p_fabric, rootNodes, nodesRank))
    {
      printf("-E- fail to rank the fabric by the given root nodes.\n");
      return(1);
    }
    return(0);
  }


#define new_string string

#define new_uint64_t uint64_t
static int  _wrap_const_IB_UNKNOWN_NODE_TYPE = IB_UNKNOWN_NODE_TYPE;
static int  _wrap_const_IB_SW_NODE = IB_SW_NODE;
static int  _wrap_const_IB_CA_NODE = IB_CA_NODE;
static int  _wrap_const_FABU_LOG_NONE = 0x0;
static int  _wrap_const_FABU_LOG_ERROR = 0x1;
static int  _wrap_const_FABU_LOG_INFO = 0x2;
static int  _wrap_const_FABU_LOG_VERBOSE = 0x4;

#define list_pnode_arg_name list_pnode

#define unsigned_int_arg_name unsigned int

#include "swig_alternate_mangling.cpp"
extern char * ibdmSourceVersion;
static int _wrap_ibdmUseInternalLog(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmUseInternalLog ",-1);
        return TCL_ERROR;
    }
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmUseInternalLog();
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmUseCoutLog(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmUseCoutLog ",-1);
        return TCL_ERROR;
    }
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmUseCoutLog();
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmGetAndClearInternalLog(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmGetAndClearInternalLog ",-1);
        return TCL_ERROR;
    }
{
  ibdm_tcl_error = 0;
      _result = (char *)ibdmGetAndClearInternalLog();
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
delete [] _result;

    return TCL_OK;
}
static int _wrap_new_IBFabric(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. new_IBFabric ",-1);
        return TCL_ERROR;
    }
{
  ibdm_tcl_error = 0;
      _result = (IBFabric *)new_IBFabric();
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBFabric *");
}
    return TCL_OK;
}
static int _wrap_delete_IBFabric(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. delete_IBFabric p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      delete_IBFabric(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
static int _wrap_ibdmAssignLids(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBPort * _arg0;
    unsigned int  _arg1 = 0;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmAssignLids p_smNodePort ?lmc? ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (objc >2) {
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
    }
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtAssignLids(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCalcMinHopTables(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCalcMinHopTables p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtCalcMinHopTables(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCalcUpDnMinHopTbls(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCalcUpDnMinHopTbls p_fabric rootNodesNameRex ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtCalcUpDnMinHopTblsByRootNodesRex(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmOsmRoute(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmOsmRoute p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtOsmRoute(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmEnhancedRoute(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmEnhancedRoute p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtOsmEnhancedRoute(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmFatTreeRoute(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    list_pnode * _arg1;
    Tcl_Obj * tcl_result;
    list_pnode  tmpNodeList;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmFatTreeRoute p_fabric rootNodes ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
#if TCL_MINOR_VERSION > 3
  const char **sub_lists;
#else
  char **sub_lists;
#endif
  int num_sub_lists;
  int idx;

  /* we will use the TCL split list to split into elements */
  if (Tcl_SplitList(interp,
                    Tcl_GetStringFromObj(objv[2],0),
                    &num_sub_lists, &sub_lists) != TCL_OK) {
    printf("-E- Bad formatted list :%s\n",
           Tcl_GetStringFromObj(objv[2],0));
    return TCL_ERROR;
  }

  for (idx = 0; (idx < num_sub_lists); idx++)
  {
    /* we need to double copy since TCL 8.4 requires split res to be const */
    Tcl_Obj *p_tclObj;
    void *ptr;
    char buf[128];
    strcpy(buf, sub_lists[idx]);

    if (strncmp("node:", buf, 5)) {
      printf("-E- Bad formatted node (%u) object:%s\n", idx, buf);
      return TCL_ERROR;
    }

	 p_tclObj = Tcl_NewObj();
    Tcl_SetStringObj(p_tclObj, buf, -1);
    if (ibdmGetObjPtrByTclName(p_tclObj, &ptr) != TCL_OK) {
      printf("-E- fail to find ibdm obj by id:%s", buf );
      Tcl_DecrRefCount(p_tclObj);
      return TCL_ERROR;
    }
    Tcl_DecrRefCount(p_tclObj);
    tmpNodeList.push_back((IBNode *)ptr);
  }

  _arg1 = &tmpNodeList;
}
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmFatTreeRoute(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmFatTreeAnalysis(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmFatTreeAnalysis p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )FatTreeAnalysis(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmFatTreeRouteByPermutation(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    char * _arg1;
    char * _arg2;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmFatTreeRouteByPermutation p_fabric srcs dsts ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    if ((_arg2 = Tcl_GetStringFromObj(objv[3], &templength)) == NULL) return TCL_ERROR;
{
  ibdm_tcl_error = 0;
      _result = (int )FatTreeRouteByPermutation(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmVerifyCAtoCARoutes(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmVerifyCAtoCARoutes p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtVerifyAllCaToCaRoutes(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmVerifyAllPaths(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmVerifyAllPaths p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtVerifyAllRoutes(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmAnalyzeLoops(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmAnalyzeLoops p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CrdLoopAnalyze(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmFindSymmetricalTreeRoots(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    list_pnode * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmFindSymmetricalTreeRoots p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new list_pnode (SubnMgtFindTreeRootNodes(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  list_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I), "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s", Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
static int _wrap_ibdmFindRootNodesByMinHop(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    list_pnode * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmFindRootNodesByMinHop p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new list_pnode (SubnMgtFindRootNodesByMinHop(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  list_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I), "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s", Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
static int _wrap_ibdmRankFabricByRoots(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    list_pnode * _arg1;
    Tcl_Obj * tcl_result;
    list_pnode  tmpNodeList;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmRankFabricByRoots p_fabric rootNodes ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
#if TCL_MINOR_VERSION > 3
  const char **sub_lists;
#else
  char **sub_lists;
#endif
  int num_sub_lists;
  int idx;

  /* we will use the TCL split list to split into elements */
  if (Tcl_SplitList(interp,
                    Tcl_GetStringFromObj(objv[2],0),
                    &num_sub_lists, &sub_lists) != TCL_OK) {
    printf("-E- Bad formatted list :%s\n",
           Tcl_GetStringFromObj(objv[2],0));
    return TCL_ERROR;
  }

  for (idx = 0; (idx < num_sub_lists); idx++)
  {
    /* we need to double copy since TCL 8.4 requires split res to be const */
    Tcl_Obj *p_tclObj;
    void *ptr;
    char buf[128];
    strcpy(buf, sub_lists[idx]);

    if (strncmp("node:", buf, 5)) {
      printf("-E- Bad formatted node (%u) object:%s\n", idx, buf);
      return TCL_ERROR;
    }

	 p_tclObj = Tcl_NewObj();
    Tcl_SetStringObj(p_tclObj, buf, -1);
    if (ibdmGetObjPtrByTclName(p_tclObj, &ptr) != TCL_OK) {
      printf("-E- fail to find ibdm obj by id:%s", buf );
      Tcl_DecrRefCount(p_tclObj);
      return TCL_ERROR;
    }
    Tcl_DecrRefCount(p_tclObj);
    tmpNodeList.push_back((IBNode *)ptr);
  }

  _arg1 = &tmpNodeList;
}
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmRankFabricByRoots(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmReportNonUpDownCa2CaPaths(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    list_pnode * _arg1;
    Tcl_Obj * tcl_result;
    list_pnode  tmpNodeList;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmReportNonUpDownCa2CaPaths p_fabric rootNodes ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
#if TCL_MINOR_VERSION > 3
  const char **sub_lists;
#else
  char **sub_lists;
#endif
  int num_sub_lists;
  int idx;

  /* we will use the TCL split list to split into elements */
  if (Tcl_SplitList(interp,
                    Tcl_GetStringFromObj(objv[2],0),
                    &num_sub_lists, &sub_lists) != TCL_OK) {
    printf("-E- Bad formatted list :%s\n",
           Tcl_GetStringFromObj(objv[2],0));
    return TCL_ERROR;
  }

  for (idx = 0; (idx < num_sub_lists); idx++)
  {
    /* we need to double copy since TCL 8.4 requires split res to be const */
    Tcl_Obj *p_tclObj;
    void *ptr;
    char buf[128];
    strcpy(buf, sub_lists[idx]);

    if (strncmp("node:", buf, 5)) {
      printf("-E- Bad formatted node (%u) object:%s\n", idx, buf);
      return TCL_ERROR;
    }

	 p_tclObj = Tcl_NewObj();
    Tcl_SetStringObj(p_tclObj, buf, -1);
    if (ibdmGetObjPtrByTclName(p_tclObj, &ptr) != TCL_OK) {
      printf("-E- fail to find ibdm obj by id:%s", buf );
      Tcl_DecrRefCount(p_tclObj);
      return TCL_ERROR;
    }
    Tcl_DecrRefCount(p_tclObj);
    tmpNodeList.push_back((IBNode *)ptr);
  }

  _arg1 = &tmpNodeList;
}
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmReportNonUpDownCa2CaPaths(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCheckMulticastGroups(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCheckMulticastGroups p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtCheckFabricMCGrps(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCheckFabricMCGrpsForCreditLoopPotential(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    list_pnode * _arg1;
    Tcl_Obj * tcl_result;
    list_pnode  tmpNodeList;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCheckFabricMCGrpsForCreditLoopPotential p_fabric rootNodes ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
#if TCL_MINOR_VERSION > 3
  const char **sub_lists;
#else
  char **sub_lists;
#endif
  int num_sub_lists;
  int idx;

  /* we will use the TCL split list to split into elements */
  if (Tcl_SplitList(interp,
                    Tcl_GetStringFromObj(objv[2],0),
                    &num_sub_lists, &sub_lists) != TCL_OK) {
    printf("-E- Bad formatted list :%s\n",
           Tcl_GetStringFromObj(objv[2],0));
    return TCL_ERROR;
  }

  for (idx = 0; (idx < num_sub_lists); idx++)
  {
    /* we need to double copy since TCL 8.4 requires split res to be const */
    Tcl_Obj *p_tclObj;
    void *ptr;
    char buf[128];
    strcpy(buf, sub_lists[idx]);

    if (strncmp("node:", buf, 5)) {
      printf("-E- Bad formatted node (%u) object:%s\n", idx, buf);
      return TCL_ERROR;
    }

	 p_tclObj = Tcl_NewObj();
    Tcl_SetStringObj(p_tclObj, buf, -1);
    if (ibdmGetObjPtrByTclName(p_tclObj, &ptr) != TCL_OK) {
      printf("-E- fail to find ibdm obj by id:%s", buf );
      Tcl_DecrRefCount(p_tclObj);
      return TCL_ERROR;
    }
    Tcl_DecrRefCount(p_tclObj);
    tmpNodeList.push_back((IBNode *)ptr);
  }

  _arg1 = &tmpNodeList;
}
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmCheckFabricMCGrpsForCreditLoopPotential(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmLinkCoverageAnalysis(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    list_pnode * _arg1;
    Tcl_Obj * tcl_result;
    list_pnode  tmpNodeList;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmLinkCoverageAnalysis p_fabric rootNodes ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
#if TCL_MINOR_VERSION > 3
  const char **sub_lists;
#else
  char **sub_lists;
#endif
  int num_sub_lists;
  int idx;

  /* we will use the TCL split list to split into elements */
  if (Tcl_SplitList(interp,
                    Tcl_GetStringFromObj(objv[2],0),
                    &num_sub_lists, &sub_lists) != TCL_OK) {
    printf("-E- Bad formatted list :%s\n",
           Tcl_GetStringFromObj(objv[2],0));
    return TCL_ERROR;
  }

  for (idx = 0; (idx < num_sub_lists); idx++)
  {
    /* we need to double copy since TCL 8.4 requires split res to be const */
    Tcl_Obj *p_tclObj;
    void *ptr;
    char buf[128];
    strcpy(buf, sub_lists[idx]);

    if (strncmp("node:", buf, 5)) {
      printf("-E- Bad formatted node (%u) object:%s\n", idx, buf);
      return TCL_ERROR;
    }

	 p_tclObj = Tcl_NewObj();
    Tcl_SetStringObj(p_tclObj, buf, -1);
    if (ibdmGetObjPtrByTclName(p_tclObj, &ptr) != TCL_OK) {
      printf("-E- fail to find ibdm obj by id:%s", buf );
      Tcl_DecrRefCount(p_tclObj);
      return TCL_ERROR;
    }
    Tcl_DecrRefCount(p_tclObj);
    tmpNodeList.push_back((IBNode *)ptr);
  }

  _arg1 = &tmpNodeList;
}
{
  ibdm_tcl_error = 0;
      _result = (int )LinkCoverageAnalysis(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmTraceDRPathRoute(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBPort * _arg0;
    list_int * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmTraceDRPathRoute p_smNodePort drPathPortNums ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_list_int_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of ibdmTraceDRPathRoute. Expected _list_int_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibdm_tcl_error = 0;
      _result = (int )TraceDRPathRoute(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmTraceRouteByMinHops(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    unsigned int  _arg2;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmTraceRouteByMinHops p_fabric slid dlid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (int )TraceRouteByMinHops(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmTraceRouteByLFT(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    unsigned int  _arg2;
    unsigned_int_arg_name * _arg3;
    list_pnode_arg_name * _arg4;
    Tcl_Obj * tcl_result;
    int tempint;
    unsigned int  tmp;
    list_pnode  tmp0;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmTraceRouteByLFT p_fabric slid dlid hops p_nodesList ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (unsigned int ) tempint;
{
	_arg3 = &tmp;
}
{
	_arg4 = &tmp0;
}
{
  ibdm_tcl_error = 0;
      _result = (int )TraceRouteByLFT(_arg0,_arg1,_arg2,_arg3,_arg4);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
   char buf[16];
	sprintf(buf, "%u", tmp);
   Tcl_SetVar(interp, Tcl_GetString(objv[4]), buf, 0);
}
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  list_pnode::const_iterator I = _arg4->begin();
  Tcl_Obj *p_tclObj;
  Tcl_SetVar(interp, Tcl_GetString(objv[5]),"",0);
  while (I != _arg4->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I), "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s", Tcl_GetString(p_tclObj));
		Tcl_SetVar(interp, Tcl_GetString(objv[5]), buf,
					  TCL_LIST_ELEMENT|TCL_APPEND_VALUE);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
static int _wrap_ibdmMatchFabrics(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    IBFabric * _arg1;
    char * _arg2;
    int  _arg3;
    uint64_t * _arg4;
    char ** _arg5;
    char * p_c;
    Tcl_Obj * tcl_result;
    int templength;
    int tempint;
    uint64_t  temp;

    clientData = clientData; objv = objv;
{
  _arg5 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmMatchFabrics p_spec_fabric p_discovered_fabric anchorNodeName anchorPortNum anchorPortGuid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((_arg2 = Tcl_GetStringFromObj(objv[3], &templength)) == NULL) return TCL_ERROR;
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
{
  temp = strtoull(Tcl_GetStringFromObj(objv[5],NULL), NULL,16);
  _arg4 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )TopoMatchFabrics(_arg0,_arg1,_arg2,_arg3,*_arg4,_arg5);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  if (*_arg5) {
     Tcl_SetStringObj(tcl_result,*_arg5,strlen(*_arg5));
      free(*_arg5);
  } else {
     Tcl_SetStringObj(tcl_result,"",-1);
  }
}
    return TCL_OK;
}
static int _wrap_ibdmBuildMergedFabric(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    IBFabric * _arg1;
    IBFabric * _arg2;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmBuildMergedFabric p_spec_fabric p_discovered_fabric p_merged_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[3], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[3]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg2 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[3],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )TopoMergeDiscAndSpecFabrics(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCongInit(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongInit p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongInit(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCongCleanup(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongCleanup p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongCleanup(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCongClear(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongClear p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongZero(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCongTrace(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    uint16_t * _arg1;
    uint16_t * _arg2;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint16_t  temp0;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongTrace p_fabric srcLid dstLid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongTrackPath(_arg0,*_arg1,*_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCongReport(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    ostringstream * _arg1;
    ostringstream  tempStream;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
{
  _arg1 = &tempStream;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongReport p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongReport(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result, (char*)_arg1->str().c_str(),
                   _arg1->str().size() + 1);
}
    return TCL_OK;
}
static int _wrap_ibdmCongDump(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    ostringstream * _arg1;
    ostringstream  tempStream;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
{
  _arg1 = &tempStream;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongDump p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongDump(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result, (char*)_arg1->str().c_str(),
                   _arg1->str().size() + 1);
}
    return TCL_OK;
}
#define IBPort_p_remotePort_set(_swigobj,_swigval) (_swigobj->p_remotePort = _swigval,_swigval)
static int _wrap_IBPort_p_remotePort_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBPort * _arg0;
    IBPort * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_remotePort_set { IBPort * } { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBPort_p_remotePort_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBPort_p_remotePort_get(_swigobj) ((IBPort *) _swigobj->p_remotePort)
static int _wrap_IBPort_p_remotePort_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_remotePort_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBPort_p_remotePort_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBPort_p_sysPort_set(_swigobj,_swigval) (_swigobj->p_sysPort = _swigval,_swigval)
static int _wrap_IBPort_p_sysPort_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBPort * _arg0;
    IBSysPort * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_sysPort_set { IBPort * } { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBPort_p_sysPort_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define IBPort_p_sysPort_get(_swigobj) ((IBSysPort *) _swigobj->p_sysPort)
static int _wrap_IBPort_p_sysPort_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_sysPort_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBPort_p_sysPort_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define IBPort_p_node_set(_swigobj,_swigval) (_swigobj->p_node = _swigval,_swigval)
static int _wrap_IBPort_p_node_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    IBPort * _arg0;
    IBNode * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_node_set { IBPort * } { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)IBPort_p_node_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define IBPort_p_node_get(_swigobj) ((IBNode *) _swigobj->p_node)
static int _wrap_IBPort_p_node_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_node_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)IBPort_p_node_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define IBPort_num_set(_swigobj,_swigval) (_swigobj->num = _swigval,_swigval)
static int _wrap_IBPort_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBPort * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_num_set { IBPort * } { int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (int )IBPort_num_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBPort_num_get(_swigobj) ((int ) _swigobj->num)
static int _wrap_IBPort_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_num_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBPort_num_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBPort_base_lid_set(_swigobj,_swigval) (_swigobj->base_lid = _swigval,_swigval)
static int _wrap_IBPort_base_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBPort * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_base_lid_set { IBPort * } { unsigned int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBPort_base_lid_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBPort_base_lid_get(_swigobj) ((unsigned int ) _swigobj->base_lid)
static int _wrap_IBPort_base_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_base_lid_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBPort_base_lid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBPort_width_set(_swigobj,_swigval) (_swigobj->width = *(_swigval),_swigval)
static int _wrap_IBPort_width_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBLinkWidth * _result;
    IBPort * _arg0;
    IBLinkWidth * _arg1;
    Tcl_Obj * tcl_result;
    IBLinkWidth  temp1;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_width_set { IBPort * } { IBLinkWidth * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp1 = char2width(Tcl_GetStringFromObj(objv[2],NULL));
  _arg1 = &temp1;
}
{
  ibdm_tcl_error = 0;
      _result = (IBLinkWidth *)IBPort_width_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_SetStringObj(tcl_result,width2char(*_result), -1);
}
    return TCL_OK;
}
#define IBPort_width_get(_swigobj) (&_swigobj->width)
static int _wrap_IBPort_width_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBLinkWidth * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_width_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBLinkWidth *)IBPort_width_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_SetStringObj(tcl_result,width2char(*_result), -1);
}
    return TCL_OK;
}
#define IBPort_speed_set(_swigobj,_swigval) (_swigobj->speed = *(_swigval),_swigval)
static int _wrap_IBPort_speed_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBLinkSpeed * _result;
    IBPort * _arg0;
    IBLinkSpeed * _arg1;
    Tcl_Obj * tcl_result;
    IBLinkSpeed  temp2;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_speed_set { IBPort * } { IBLinkSpeed * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp2 = char2speed(Tcl_GetStringFromObj(objv[2],NULL));
  _arg1 = &temp2;
}
{
  ibdm_tcl_error = 0;
      _result = (IBLinkSpeed *)IBPort_speed_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_SetStringObj(tcl_result,speed2char(*_result), -1);
}
    return TCL_OK;
}
#define IBPort_speed_get(_swigobj) (&_swigobj->speed)
static int _wrap_IBPort_speed_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBLinkSpeed * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_speed_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBLinkSpeed *)IBPort_speed_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_SetStringObj(tcl_result,speed2char(*_result), -1);
}
    return TCL_OK;
}
#define IBPort_counter1_set(_swigobj,_swigval) (_swigobj->counter1 = _swigval,_swigval)
static int _wrap_IBPort_counter1_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBPort * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_counter1_set { IBPort * } { unsigned int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBPort_counter1_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBPort_counter1_get(_swigobj) ((unsigned int ) _swigobj->counter1)
static int _wrap_IBPort_counter1_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_counter1_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBPort_counter1_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define new_IBPort(_swigarg0,_swigarg1) (new IBPort(_swigarg0,_swigarg1))
static int _wrap_new_IBPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBNode * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. new_IBPort p_nodePtr number ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)new_IBPort(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBPort_guid_get(_swigobj)  (_swigobj->guid_get())
static int _wrap_IBPort_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    new_uint64_t * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_guid_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new new_uint64_t (IBPort_guid_get(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  /* new_uint64_t tcl8 out */
  sprintf(buff, "0x%016" PRIx64, *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
  delete _result;
}
    return TCL_OK;
}
#define IBPort_guid_set(_swigobj,_swigarg0)  (_swigobj->guid_set(_swigarg0))
static int _wrap_IBPort_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_guid_set { IBPort * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      IBPort_guid_set(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBPort_getName(_swigobj)  (_swigobj->getName())
static int _wrap_IBPort_getName(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    new_string * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_getName { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new new_string (IBPort_getName(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
   delete _result;
}
    return TCL_OK;
}
#define IBPort_connect(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->connect(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBPort_connect(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _arg0;
    IBPort * _arg1;
    IBLinkWidth * _arg2 = &DefaultLinkWidth;
    IBLinkSpeed * _arg3 = &DefaultLinkSpeed;
    Tcl_Obj * tcl_result;
    IBLinkWidth  temp1;
    IBLinkSpeed  temp2;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_connect { IBPort * } p_otherPort ?w? ?s? ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (objc >3) {
{
  temp1 = char2width(Tcl_GetStringFromObj(objv[3],NULL));
  _arg2 = &temp1;
}
    }
    if (objc >4) {
{
  temp2 = char2speed(Tcl_GetStringFromObj(objv[4],NULL));
  _arg3 = &temp2;
}
    }
{
  ibdm_tcl_error = 0;
      IBPort_connect(_arg0,_arg1,*_arg2,*_arg3);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBPort_disconnect(_swigobj)  (_swigobj->disconnect())
static int _wrap_IBPort_disconnect(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_disconnect { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBPort_disconnect(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBPortMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBPort methods : { dump cget configure guid_get guid_set getName connect disconnect  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBPort_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"guid_get") == 0) {
        cmd = _wrap_IBPort_guid_get;
    }    else if (strcmp(_str,"guid_set") == 0) {
        cmd = _wrap_IBPort_guid_set;
    }    else if (strcmp(_str,"getName") == 0) {
        cmd = _wrap_IBPort_getName;
    }    else if (strcmp(_str,"connect") == 0) {
        cmd = _wrap_IBPort_connect;
    }    else if (strcmp(_str,"disconnect") == 0) {
        cmd = _wrap_IBPort_disconnect;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-p_remotePort") == 0) {
                    cmd = _wrap_IBPort_p_remotePort_set;
                }  else if (strcmp(_str,"-p_sysPort") == 0) {
                    cmd = _wrap_IBPort_p_sysPort_set;
                }  else if (strcmp(_str,"-p_node") == 0) {
                    cmd = _wrap_IBPort_p_node_set;
                }  else if (strcmp(_str,"-num") == 0) {
                    cmd = _wrap_IBPort_num_set;
                }  else if (strcmp(_str,"-base_lid") == 0) {
                    cmd = _wrap_IBPort_base_lid_set;
                }  else if (strcmp(_str,"-width") == 0) {
                    cmd = _wrap_IBPort_width_set;
                }  else if (strcmp(_str,"-speed") == 0) {
                    cmd = _wrap_IBPort_speed_set;
                }  else if (strcmp(_str,"-counter1") == 0) {
                    cmd = _wrap_IBPort_counter1_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -p_remotePort -p_sysPort -p_node -num -base_lid -width -speed -counter1  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -p_remotePort -p_sysPort -p_node -num -base_lid -width -speed -counter1  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-p_remotePort") == 0) {
                    cmd = _wrap_IBPort_p_remotePort_get;
                }  else if (strcmp(_str,"-p_sysPort") == 0) {
                    cmd = _wrap_IBPort_p_sysPort_get;
                }  else if (strcmp(_str,"-p_node") == 0) {
                    cmd = _wrap_IBPort_p_node_get;
                }  else if (strcmp(_str,"-num") == 0) {
                    cmd = _wrap_IBPort_num_get;
                }  else if (strcmp(_str,"-base_lid") == 0) {
                    cmd = _wrap_IBPort_base_lid_get;
                }  else if (strcmp(_str,"-width") == 0) {
                    cmd = _wrap_IBPort_width_get;
                }  else if (strcmp(_str,"-speed") == 0) {
                    cmd = _wrap_IBPort_speed_get;
                }  else if (strcmp(_str,"-counter1") == 0) {
                    cmd = _wrap_IBPort_counter1_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBPort_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -p_remotePort -p_sysPort -p_node -num -base_lid -width -speed -counter1  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -p_remotePort -p_sysPort -p_node -num -base_lid -width -speed -counter1  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_IBPort_p_remotePort_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_remotePort ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_p_sysPort_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_sysPort ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_p_node_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_node ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_num_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-num ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_base_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-base_lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_width_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-width ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_speed_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-speed ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_counter1_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-counter1 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure guid_get guid_set getName connect disconnect }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBPortCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBPort * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = _wrap_new_IBPort;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = _wrap_new_IBPort;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = _wrap_new_IBPort;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = _wrap_new_IBPort;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBPort_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBPort_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBPort object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBPortMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define IBNode_name_set(_swigobj,_swigval) (_swigobj->name = *(_swigval),_swigval)
static int _wrap_IBNode_name_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBNode * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_name_set { IBNode * } { string * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBNode_name_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBNode_name_get(_swigobj) (&_swigobj->name)
static int _wrap_IBNode_name_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_name_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBNode_name_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBNode_type_set(_swigobj,_swigval) (_swigobj->type = _swigval,_swigval)
static int _wrap_IBNode_type_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNodeType  _result;
    IBNode * _arg0;
    IBNodeType  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_type_set { IBNode * } { IBNodeType  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (IBNodeType ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBNodeType )IBNode_type_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBNode_type_get(_swigobj) ((IBNodeType ) _swigobj->type)
static int _wrap_IBNode_type_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNodeType  _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_type_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBNodeType )IBNode_type_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBNode_devId_set(_swigobj,_swigval) (_swigobj->devId = *(_swigval),_swigval)
static int _wrap_IBNode_devId_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    uint32_t * _arg1;
    Tcl_Obj * tcl_result;
    uint32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_devId_set { IBNode * } { uint32_t * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_devId_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_devId_get(_swigobj) (&_swigobj->devId)
static int _wrap_IBNode_devId_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_devId_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_devId_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_revId_set(_swigobj,_swigval) (_swigobj->revId = *(_swigval),_swigval)
static int _wrap_IBNode_revId_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    uint32_t * _arg1;
    Tcl_Obj * tcl_result;
    uint32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_revId_set { IBNode * } { uint32_t * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_revId_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_revId_get(_swigobj) (&_swigobj->revId)
static int _wrap_IBNode_revId_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_revId_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_revId_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_vendId_set(_swigobj,_swigval) (_swigobj->vendId = *(_swigval),_swigval)
static int _wrap_IBNode_vendId_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    uint32_t * _arg1;
    Tcl_Obj * tcl_result;
    uint32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_vendId_set { IBNode * } { uint32_t * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_vendId_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_vendId_get(_swigobj) (&_swigobj->vendId)
static int _wrap_IBNode_vendId_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_vendId_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_vendId_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_attributes_set(_swigobj,_swigval) (_swigobj->attributes = *(_swigval),_swigval)
static int _wrap_IBNode_attributes_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBNode * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_attributes_set { IBNode * } { string * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBNode_attributes_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBNode_attributes_get(_swigobj) (&_swigobj->attributes)
static int _wrap_IBNode_attributes_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_attributes_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBNode_attributes_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBNode_rank_set(_swigobj,_swigval) (_swigobj->rank = *(_swigval),_swigval)
static int _wrap_IBNode_rank_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    IBNode * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_rank_set { IBNode * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (uint8_t *)IBNode_rank_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_rank_get(_swigobj) (&_swigobj->rank)
static int _wrap_IBNode_rank_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_rank_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (uint8_t *)IBNode_rank_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_p_system_get(_swigobj) ((IBSystem *) _swigobj->p_system)
static int _wrap_IBNode_p_system_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_p_system_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBNode_p_system_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBNode_p_fabric_get(_swigobj) ((IBFabric *) _swigobj->p_fabric)
static int _wrap_IBNode_p_fabric_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_p_fabric_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBFabric *)IBNode_p_fabric_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBFabric *");
}
    return TCL_OK;
}
#define IBNode_numPorts_get(_swigobj) ((unsigned int ) _swigobj->numPorts)
static int _wrap_IBNode_numPorts_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_numPorts_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBNode_numPorts_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBNode_Ports_get(_swigobj) (&_swigobj->Ports)
static int _wrap_IBNode_Ports_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    vec_pport * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_Ports_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (vec_pport *)IBNode_Ports_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_Obj *p_tclObj;

  for (unsigned int i = 0; i < _result->size(); i++) {
	 IBPort *p_port = (*_result)[i];
	 if (p_port) {
		p_tclObj = Tcl_NewObj();
		if (ibdmGetObjTclNameByPtr(p_tclObj, p_port, "IBPort *")
			 != TCL_OK) {
		  printf("-E- Fail to map Port Object (a Vector element)\n");
		} else {
		  Tcl_AppendElement(interp, Tcl_GetString(p_tclObj));
		}
		Tcl_DecrRefCount(p_tclObj);
	 }
  }
}
    return TCL_OK;
}
#define IBNode_MinHopsTable_get(_swigobj) (&_swigobj->MinHopsTable)
static int _wrap_IBNode_MinHopsTable_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    vec_vec_byte * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_MinHopsTable_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (vec_vec_byte *)IBNode_MinHopsTable_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  for (unsigned int i = 0; i < _result->size(); i++) {
	 Tcl_AppendResult(interp,"{", NULL);
	 for (unsigned int j = 0; j < (*_result)[i].size(); j++) {
		char buf[32];
		sprintf(buf,"%u ", (*_result)[i][j]);
		Tcl_AppendResult(interp, buf, NULL);
	 }
	 Tcl_AppendResult(interp,"} ", NULL);
  }
}
    return TCL_OK;
}
#define IBNode_LFT_get(_swigobj) (&_swigobj->LFT)
static int _wrap_IBNode_LFT_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    vec_byte * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_LFT_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (vec_byte *)IBNode_LFT_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  for (unsigned int i = 0; i < _result->size(); i++) {
	 char buf[32];
	 sprintf(buf,"%u ", (*_result)[i]);
	 Tcl_AppendResult(interp, buf, NULL);
  }
}
    return TCL_OK;
}
#define IBNode_guid_get(_swigobj)  (_swigobj->guid_get())
static int _wrap_IBNode_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    new_uint64_t * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_guid_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new new_uint64_t (IBNode_guid_get(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  /* new_uint64_t tcl8 out */
  sprintf(buff, "0x%016" PRIx64, *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
  delete _result;
}
    return TCL_OK;
}
#define IBNode_guid_set(_swigobj,_swigarg0)  (_swigobj->guid_set(_swigarg0))
static int _wrap_IBNode_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_guid_set { IBNode * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      IBNode_guid_set(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define new_IBNode(_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4) (new IBNode(_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4))
static int _wrap_new_IBNode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    string * _arg0;
    IBFabric * _arg1;
    IBSystem * _arg2;
    IBNodeType  _arg3;
    int  _arg4;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. new_IBNode n p_fab p_sys t np ",-1);
        return TCL_ERROR;
    }
{
  int len;
  static string _arg0_tmp;
  _arg0_tmp = string(Tcl_GetStringFromObj(objv[1],&len));
  _arg0 = &_arg0_tmp;
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[3], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[3]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg2 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[3],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (IBNodeType ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[5],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg4 = (int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)new_IBNode(*_arg0,_arg1,_arg2,_arg3,_arg4);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define delete_IBNode(_swigobj) (delete _swigobj)
static int _wrap_delete_IBNode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. delete_IBNode { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      delete_IBNode(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBNode_makePort(_swigobj,_swigarg0)  (_swigobj->makePort(_swigarg0))
static int _wrap_IBNode_makePort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBNode * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_makePort { IBNode * } num ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBNode_makePort(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBNode_getPort(_swigobj,_swigarg0)  (_swigobj->getPort(_swigarg0))
static int _wrap_IBNode_getPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBNode * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_getPort { IBNode * } num ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBNode_getPort(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBNode_setHops(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->setHops(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBNode_setHops(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _arg0;
    IBPort * _arg1;
    unsigned int  _arg2;
    int  _arg3;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_setHops { IBNode * } p_port lid hops ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (unsigned int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
{
  ibdm_tcl_error = 0;
      IBNode_setHops(_arg0,_arg1,_arg2,_arg3);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBNode_getHops(_swigobj,_swigarg0,_swigarg1)  (_swigobj->getHops(_swigarg0,_swigarg1))
static int _wrap_IBNode_getHops(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBNode * _arg0;
    IBPort * _arg1;
    unsigned int  _arg2;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_getHops { IBNode * } p_port lid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (int )IBNode_getHops(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBNode_getFirstMinHopPort(_swigobj,_swigarg0)  (_swigobj->getFirstMinHopPort(_swigarg0))
static int _wrap_IBNode_getFirstMinHopPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBNode * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_getFirstMinHopPort { IBNode * } lid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBNode_getFirstMinHopPort(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBNode_setLFTPortForLid(_swigobj,_swigarg0,_swigarg1)  (_swigobj->setLFTPortForLid(_swigarg0,_swigarg1))
static int _wrap_IBNode_setLFTPortForLid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _arg0;
    unsigned int  _arg1;
    unsigned int  _arg2;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_setLFTPortForLid { IBNode * } lid portNum ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      IBNode_setLFTPortForLid(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBNode_getLFTPortForLid(_swigobj,_swigarg0)  (_swigobj->getLFTPortForLid(_swigarg0))
static int _wrap_IBNode_getLFTPortForLid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBNode * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_getLFTPortForLid { IBNode * } lid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (int )IBNode_getLFTPortForLid(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBNode_repHopTable(_swigobj)  (_swigobj->repHopTable())
static int _wrap_IBNode_repHopTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_repHopTable { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      IBNode_repHopTable(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* delcmd.swg : Tcl object deletion method */

static void TclDeleteIBNode(ClientData clientData) {
    delete_IBNode((IBNode *) clientData);
}

/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBNodeMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBNode methods : { dump cget configure guid_get guid_set makePort getPort setHops getHops getFirstMinHopPort setLFTPortForLid getLFTPortForLid repHopTable  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBNode_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"guid_get") == 0) {
        cmd = _wrap_IBNode_guid_get;
    }    else if (strcmp(_str,"guid_set") == 0) {
        cmd = _wrap_IBNode_guid_set;
    }    else if (strcmp(_str,"makePort") == 0) {
        cmd = _wrap_IBNode_makePort;
    }    else if (strcmp(_str,"getPort") == 0) {
        cmd = _wrap_IBNode_getPort;
    }    else if (strcmp(_str,"setHops") == 0) {
        cmd = _wrap_IBNode_setHops;
    }    else if (strcmp(_str,"getHops") == 0) {
        cmd = _wrap_IBNode_getHops;
    }    else if (strcmp(_str,"getFirstMinHopPort") == 0) {
        cmd = _wrap_IBNode_getFirstMinHopPort;
    }    else if (strcmp(_str,"setLFTPortForLid") == 0) {
        cmd = _wrap_IBNode_setLFTPortForLid;
    }    else if (strcmp(_str,"getLFTPortForLid") == 0) {
        cmd = _wrap_IBNode_getLFTPortForLid;
    }    else if (strcmp(_str,"repHopTable") == 0) {
        cmd = _wrap_IBNode_repHopTable;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBNode_name_set;
                }  else if (strcmp(_str,"-type") == 0) {
                    cmd = _wrap_IBNode_type_set;
                }  else if (strcmp(_str,"-devId") == 0) {
                    cmd = _wrap_IBNode_devId_set;
                }  else if (strcmp(_str,"-revId") == 0) {
                    cmd = _wrap_IBNode_revId_set;
                }  else if (strcmp(_str,"-vendId") == 0) {
                    cmd = _wrap_IBNode_vendId_set;
                }  else if (strcmp(_str,"-attributes") == 0) {
                    cmd = _wrap_IBNode_attributes_set;
                }  else if (strcmp(_str,"-rank") == 0) {
                    cmd = _wrap_IBNode_rank_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -name -type -devId -revId -vendId -attributes -rank  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -name -type -devId -revId -vendId -attributes -rank  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBNode_name_get;
                }  else if (strcmp(_str,"-type") == 0) {
                    cmd = _wrap_IBNode_type_get;
                }  else if (strcmp(_str,"-devId") == 0) {
                    cmd = _wrap_IBNode_devId_get;
                }  else if (strcmp(_str,"-revId") == 0) {
                    cmd = _wrap_IBNode_revId_get;
                }  else if (strcmp(_str,"-vendId") == 0) {
                    cmd = _wrap_IBNode_vendId_get;
                }  else if (strcmp(_str,"-attributes") == 0) {
                    cmd = _wrap_IBNode_attributes_get;
                }  else if (strcmp(_str,"-rank") == 0) {
                    cmd = _wrap_IBNode_rank_get;
                }  else if (strcmp(_str,"-p_system") == 0) {
                    cmd = _wrap_IBNode_p_system_get;
                }  else if (strcmp(_str,"-p_fabric") == 0) {
                    cmd = _wrap_IBNode_p_fabric_get;
                }  else if (strcmp(_str,"-numPorts") == 0) {
                    cmd = _wrap_IBNode_numPorts_get;
                }  else if (strcmp(_str,"-Ports") == 0) {
                    cmd = _wrap_IBNode_Ports_get;
                }  else if (strcmp(_str,"-MinHopsTable") == 0) {
                    cmd = _wrap_IBNode_MinHopsTable_get;
                }  else if (strcmp(_str,"-LFT") == 0) {
                    cmd = _wrap_IBNode_LFT_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBNode_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -name -type -devId -revId -vendId -attributes -rank -p_system -p_fabric -numPorts -Ports -MinHopsTable -LFT  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -name -type -devId -revId -vendId -attributes -rank -p_system -p_fabric -numPorts -Ports -MinHopsTable -LFT  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_IBNode_name_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-name ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_type_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-type ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_devId_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-devId ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_revId_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-revId ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_vendId_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vendId ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_attributes_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-attributes ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_rank_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-rank ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_p_system_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_system ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_p_fabric_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_fabric ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_numPorts_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-numPorts ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_Ports_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-Ports ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_MinHopsTable_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-MinHopsTable ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_LFT_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-LFT ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure guid_get guid_set makePort getPort setHops getHops getFirstMinHopPort setLFTPortForLid getLFTPortForLid repHopTable }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBNodeCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBNode * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = _wrap_new_IBNode;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = _wrap_new_IBNode;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = _wrap_new_IBNode;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = _wrap_new_IBNode;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBNode_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = TclDeleteIBNode;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBNode_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBNode object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBNodeMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define IBSysPort_name_set(_swigobj,_swigval) (_swigobj->name = *(_swigval),_swigval)
static int _wrap_IBSysPort_name_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSysPort * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_name_set { IBSysPort * } { string * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSysPort_name_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSysPort_name_get(_swigobj) (&_swigobj->name)
static int _wrap_IBSysPort_name_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_name_get { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSysPort_name_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSysPort_p_remoteSysPort_set(_swigobj,_swigval) (_swigobj->p_remoteSysPort = _swigval,_swigval)
static int _wrap_IBSysPort_p_remoteSysPort_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBSysPort * _arg0;
    IBSysPort * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_remoteSysPort_set { IBSysPort * } { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBSysPort_p_remoteSysPort_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define IBSysPort_p_remoteSysPort_get(_swigobj) ((IBSysPort *) _swigobj->p_remoteSysPort)
static int _wrap_IBSysPort_p_remoteSysPort_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_remoteSysPort_get { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBSysPort_p_remoteSysPort_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define IBSysPort_p_system_set(_swigobj,_swigval) (_swigobj->p_system = _swigval,_swigval)
static int _wrap_IBSysPort_p_system_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBSysPort * _arg0;
    IBSystem * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_system_set { IBSysPort * } { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBSysPort_p_system_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBSysPort_p_system_get(_swigobj) ((IBSystem *) _swigobj->p_system)
static int _wrap_IBSysPort_p_system_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_system_get { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBSysPort_p_system_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBSysPort_p_nodePort_set(_swigobj,_swigval) (_swigobj->p_nodePort = _swigval,_swigval)
static int _wrap_IBSysPort_p_nodePort_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBSysPort * _arg0;
    IBPort * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_nodePort_set { IBSysPort * } { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBSysPort_p_nodePort_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBSysPort_p_nodePort_get(_swigobj) ((IBPort *) _swigobj->p_nodePort)
static int _wrap_IBSysPort_p_nodePort_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_nodePort_get { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBSysPort_p_nodePort_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define new_IBSysPort(_swigarg0,_swigarg1) (new IBSysPort(_swigarg0,_swigarg1))
static int _wrap_new_IBSysPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    string * _arg0;
    IBSystem * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. new_IBSysPort n p_sys ",-1);
        return TCL_ERROR;
    }
{
  int len;
  static string _arg0_tmp;
  _arg0_tmp = string(Tcl_GetStringFromObj(objv[1],&len));
  _arg0 = &_arg0_tmp;
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)new_IBSysPort(*_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define delete_IBSysPort(_swigobj) (delete _swigobj)
static int _wrap_delete_IBSysPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. delete_IBSysPort { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      delete_IBSysPort(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBSysPort_connect(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->connect(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBSysPort_connect(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _arg0;
    IBSysPort * _arg1;
    IBLinkWidth * _arg2 = &UnknownLinkWidth;
    IBLinkSpeed * _arg3 = &UnknownLinkSpeed;
    Tcl_Obj * tcl_result;
    IBLinkWidth  temp1;
    IBLinkSpeed  temp2;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_connect { IBSysPort * } p_otherSysPort ?width? ?speed? ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (objc >3) {
{
  temp1 = char2width(Tcl_GetStringFromObj(objv[3],NULL));
  _arg2 = &temp1;
}
    }
    if (objc >4) {
{
  temp2 = char2speed(Tcl_GetStringFromObj(objv[4],NULL));
  _arg3 = &temp2;
}
    }
{
  ibdm_tcl_error = 0;
      IBSysPort_connect(_arg0,_arg1,*_arg2,*_arg3);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBSysPort_disconnect(_swigobj)  (_swigobj->disconnect())
static int _wrap_IBSysPort_disconnect(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_disconnect { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBSysPort_disconnect(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
/* delcmd.swg : Tcl object deletion method */

static void TclDeleteIBSysPort(ClientData clientData) {
    delete_IBSysPort((IBSysPort *) clientData);
}

/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBSysPortMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBSysPort methods : { dump cget configure connect disconnect  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBSysPort_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"connect") == 0) {
        cmd = _wrap_IBSysPort_connect;
    }    else if (strcmp(_str,"disconnect") == 0) {
        cmd = _wrap_IBSysPort_disconnect;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBSysPort_name_set;
                }  else if (strcmp(_str,"-p_remoteSysPort") == 0) {
                    cmd = _wrap_IBSysPort_p_remoteSysPort_set;
                }  else if (strcmp(_str,"-p_system") == 0) {
                    cmd = _wrap_IBSysPort_p_system_set;
                }  else if (strcmp(_str,"-p_nodePort") == 0) {
                    cmd = _wrap_IBSysPort_p_nodePort_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -name -p_remoteSysPort -p_system -p_nodePort  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -name -p_remoteSysPort -p_system -p_nodePort  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBSysPort_name_get;
                }  else if (strcmp(_str,"-p_remoteSysPort") == 0) {
                    cmd = _wrap_IBSysPort_p_remoteSysPort_get;
                }  else if (strcmp(_str,"-p_system") == 0) {
                    cmd = _wrap_IBSysPort_p_system_get;
                }  else if (strcmp(_str,"-p_nodePort") == 0) {
                    cmd = _wrap_IBSysPort_p_nodePort_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBSysPort_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -name -p_remoteSysPort -p_system -p_nodePort  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -name -p_remoteSysPort -p_system -p_nodePort  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_IBSysPort_name_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-name ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSysPort_p_remoteSysPort_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_remoteSysPort ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSysPort_p_system_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_system ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSysPort_p_nodePort_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_nodePort ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure connect disconnect }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBSysPortCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBSysPort * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = _wrap_new_IBSysPort;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = _wrap_new_IBSysPort;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = _wrap_new_IBSysPort;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = _wrap_new_IBSysPort;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBSysPort_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = TclDeleteIBSysPort;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBSysPort_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBSysPort object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBSysPortMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define IBSystem_name_set(_swigobj,_swigval) (_swigobj->name = *(_swigval),_swigval)
static int _wrap_IBSystem_name_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSystem * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_name_set { IBSystem * } { string * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSystem_name_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSystem_name_get(_swigobj) (&_swigobj->name)
static int _wrap_IBSystem_name_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_name_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSystem_name_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSystem_type_set(_swigobj,_swigval) (_swigobj->type = *(_swigval),_swigval)
static int _wrap_IBSystem_type_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSystem * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_type_set { IBSystem * } { string * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSystem_type_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSystem_type_get(_swigobj) (&_swigobj->type)
static int _wrap_IBSystem_type_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_type_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSystem_type_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSystem_p_fabric_set(_swigobj,_swigval) (_swigobj->p_fabric = _swigval,_swigval)
static int _wrap_IBSystem_p_fabric_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _result;
    IBSystem * _arg0;
    IBFabric * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_p_fabric_set { IBSystem * } { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBFabric *)IBSystem_p_fabric_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBFabric *");
}
    return TCL_OK;
}
#define IBSystem_p_fabric_get(_swigobj) ((IBFabric *) _swigobj->p_fabric)
static int _wrap_IBSystem_p_fabric_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_p_fabric_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBFabric *)IBSystem_p_fabric_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBFabric *");
}
    return TCL_OK;
}
#define IBSystem_NodeByName_get(_swigobj) (&_swigobj->NodeByName)
static int _wrap_IBSystem_NodeByName_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_str_pnode * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_NodeByName_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_str_pnode *)IBSystem_NodeByName_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_str_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a Vector element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s %s", (*I).first.c_str(), Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBSystem_PortByName_get(_swigobj) (&_swigobj->PortByName)
static int _wrap_IBSystem_PortByName_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_str_psysport * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_PortByName_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_str_psysport *)IBSystem_PortByName_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_str_psysport::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBSysPort *") != TCL_OK) {
		printf("-E- Fail to map SysPort Object (a Vector element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s %s", (*I).first.c_str(), Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define new_IBSystem(_swigarg0,_swigarg1,_swigarg2) (new IBSystem(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_new_IBSystem(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    string * _arg0;
    IBFabric * _arg1;
    string * _arg2;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. new_IBSystem n p_fab t ",-1);
        return TCL_ERROR;
    }
{
  int len;
  static string _arg0_tmp;
  _arg0_tmp = string(Tcl_GetStringFromObj(objv[1],&len));
  _arg0 = &_arg0_tmp;
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg2_tmp;
  _arg2_tmp = string(Tcl_GetStringFromObj(objv[3],&len));
  _arg2 = &_arg2_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)new_IBSystem(*_arg0,_arg1,*_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define delete_IBSystem(_swigobj) (delete _swigobj)
static int _wrap_delete_IBSystem(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. delete_IBSystem { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      delete_IBSystem(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBSystem_guid_get(_swigobj)  (_swigobj->guid_get())
static int _wrap_IBSystem_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    new_uint64_t * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_guid_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new new_uint64_t (IBSystem_guid_get(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  /* new_uint64_t tcl8 out */
  sprintf(buff, "0x%016" PRIx64, *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
  delete _result;
}
    return TCL_OK;
}
#define IBSystem_guid_set(_swigobj,_swigarg0)  (_swigobj->guid_set(_swigarg0))
static int _wrap_IBSystem_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_guid_set { IBSystem * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      IBSystem_guid_set(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBSystem_makeSysPort(_swigobj,_swigarg0)  (_swigobj->makeSysPort(_swigarg0))
static int _wrap_IBSystem_makeSysPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBSystem * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_makeSysPort { IBSystem * } pName ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBSystem_makeSysPort(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define IBSystem_getSysPortNodePortByName(_swigobj,_swigarg0)  (_swigobj->getSysPortNodePortByName(_swigarg0))
static int _wrap_IBSystem_getSysPortNodePortByName(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBSystem * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_getSysPortNodePortByName { IBSystem * } sysPortName ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBSystem_getSysPortNodePortByName(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBSystem_getSysPort(_swigobj,_swigarg0)  (_swigobj->getSysPort(_swigarg0))
static int _wrap_IBSystem_getSysPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBSystem * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_getSysPort { IBSystem * } name ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBSystem_getSysPort(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
/* delcmd.swg : Tcl object deletion method */

static void TclDeleteIBSystem(ClientData clientData) {
    delete_IBSystem((IBSystem *) clientData);
}

/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBSystemMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBSystem methods : { dump cget configure guid_get guid_set makeSysPort getSysPortNodePortByName getSysPort  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBSystem_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"guid_get") == 0) {
        cmd = _wrap_IBSystem_guid_get;
    }    else if (strcmp(_str,"guid_set") == 0) {
        cmd = _wrap_IBSystem_guid_set;
    }    else if (strcmp(_str,"makeSysPort") == 0) {
        cmd = _wrap_IBSystem_makeSysPort;
    }    else if (strcmp(_str,"getSysPortNodePortByName") == 0) {
        cmd = _wrap_IBSystem_getSysPortNodePortByName;
    }    else if (strcmp(_str,"getSysPort") == 0) {
        cmd = _wrap_IBSystem_getSysPort;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBSystem_name_set;
                }  else if (strcmp(_str,"-type") == 0) {
                    cmd = _wrap_IBSystem_type_set;
                }  else if (strcmp(_str,"-p_fabric") == 0) {
                    cmd = _wrap_IBSystem_p_fabric_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -name -type -p_fabric  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -name -type -p_fabric  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBSystem_name_get;
                }  else if (strcmp(_str,"-type") == 0) {
                    cmd = _wrap_IBSystem_type_get;
                }  else if (strcmp(_str,"-p_fabric") == 0) {
                    cmd = _wrap_IBSystem_p_fabric_get;
                }  else if (strcmp(_str,"-NodeByName") == 0) {
                    cmd = _wrap_IBSystem_NodeByName_get;
                }  else if (strcmp(_str,"-PortByName") == 0) {
                    cmd = _wrap_IBSystem_PortByName_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBSystem_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -name -type -p_fabric -NodeByName -PortByName  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -name -type -p_fabric -NodeByName -PortByName  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_IBSystem_name_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-name ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSystem_type_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-type ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSystem_p_fabric_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_fabric ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSystem_NodeByName_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-NodeByName ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSystem_PortByName_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-PortByName ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure guid_get guid_set makeSysPort getSysPortNodePortByName getSysPort }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBSystemCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBSystem * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = _wrap_new_IBSystem;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = _wrap_new_IBSystem;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = _wrap_new_IBSystem;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = _wrap_new_IBSystem;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBSystem_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = TclDeleteIBSystem;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBSystem_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBSystem object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBSystemMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define IBFabric_NodeByName_get(_swigobj) (&_swigobj->NodeByName)
static int _wrap_IBFabric_NodeByName_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_str_pnode * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_NodeByName_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_str_pnode *)IBFabric_NodeByName_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_str_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a Vector element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s %s", (*I).first.c_str(), Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_SystemByName_get(_swigobj) (&_swigobj->SystemByName)
static int _wrap_IBFabric_SystemByName_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_str_psys * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_SystemByName_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_str_psys *)IBFabric_SystemByName_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_str_psys::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBSystem *") != TCL_OK) {
		printf("-E- Fail to map System Object (a Vector element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s %s", (*I).first.c_str(), Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_PortByLid_get(_swigobj) (&_swigobj->PortByLid)
static int _wrap_IBFabric_PortByLid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    vec_pport * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_PortByLid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (vec_pport *)IBFabric_PortByLid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_Obj *p_tclObj;

  for (unsigned int i = 0; i < _result->size(); i++) {
	 IBPort *p_port = (*_result)[i];
	 if (p_port) {
		p_tclObj = Tcl_NewObj();
		if (ibdmGetObjTclNameByPtr(p_tclObj, p_port, "IBPort *")
			 != TCL_OK) {
		  printf("-E- Fail to map Port Object (a Vector element)\n");
		} else {
		  Tcl_AppendElement(interp, Tcl_GetString(p_tclObj));
		}
		Tcl_DecrRefCount(p_tclObj);
	 }
  }
}
    return TCL_OK;
}
#define IBFabric_NodeByGuid_get(_swigobj) (&_swigobj->NodeByGuid)
static int _wrap_IBFabric_NodeByGuid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_guid_pnode * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_NodeByGuid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_guid_pnode *)IBFabric_NodeByGuid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_guid_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "0x%016" PRIx64 " %s",
              (*I).first, Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_SystemByGuid_get(_swigobj) (&_swigobj->SystemByGuid)
static int _wrap_IBFabric_SystemByGuid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_guid_psys * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_SystemByGuid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_guid_psys *)IBFabric_SystemByGuid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_guid_psys::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBSystem *") != TCL_OK) {
		printf("-E- Fail to map System Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "0x%016" PRIx64 " %s",
              (*I).first, Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_PortByGuid_get(_swigobj) (&_swigobj->PortByGuid)
static int _wrap_IBFabric_PortByGuid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_guid_pport * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_PortByGuid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_guid_pport *)IBFabric_PortByGuid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_guid_pport::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBPort *") != TCL_OK) {
		printf("-E- Fail to map Port Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "0x%016" PRIx64 " %s",
              (*I).first, Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_minLid_set(_swigobj,_swigval) (_swigobj->minLid = _swigval,_swigval)
static int _wrap_IBFabric_minLid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_minLid_set { IBFabric * } { unsigned int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_minLid_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_minLid_get(_swigobj) ((unsigned int ) _swigobj->minLid)
static int _wrap_IBFabric_minLid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_minLid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_minLid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_maxLid_set(_swigobj,_swigval) (_swigobj->maxLid = _swigval,_swigval)
static int _wrap_IBFabric_maxLid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_maxLid_set { IBFabric * } { unsigned int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_maxLid_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_maxLid_get(_swigobj) ((unsigned int ) _swigobj->maxLid)
static int _wrap_IBFabric_maxLid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_maxLid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_maxLid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_lmc_set(_swigobj,_swigval) (_swigobj->lmc = _swigval,_swigval)
static int _wrap_IBFabric_lmc_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_lmc_set { IBFabric * } { unsigned int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_lmc_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_lmc_get(_swigobj) ((unsigned int ) _swigobj->lmc)
static int _wrap_IBFabric_lmc_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_lmc_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_lmc_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_makeNode(_swigobj,_swigarg0,_swigarg1,_swigarg2,_swigarg3)  (_swigobj->makeNode(_swigarg0,_swigarg1,_swigarg2,_swigarg3))
static int _wrap_IBFabric_makeNode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    IBFabric * _arg0;
    string * _arg1;
    IBSystem * _arg2;
    IBNodeType  _arg3;
    unsigned int  _arg4;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_makeNode { IBFabric * } n p_sys type numPorts ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[3], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[3]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg2 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[3],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (IBNodeType ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[5],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg4 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)IBFabric_makeNode(_arg0,*_arg1,_arg2,_arg3,_arg4);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define IBFabric_getNode(_swigobj,_swigarg0)  (_swigobj->getNode(_swigarg0))
static int _wrap_IBFabric_getNode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getNode { IBFabric * } name ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)IBFabric_getNode(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define IBFabric_getNodesByType(_swigobj,_swigarg0)  (_swigobj->getNodesByType(_swigarg0))
static int _wrap_IBFabric_getNodesByType(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    list_pnode * _result;
    IBFabric * _arg0;
    IBNodeType  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getNodesByType { IBFabric * } type ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (IBNodeType ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (list_pnode *)IBFabric_getNodesByType(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  list_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I), "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s", Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_makeGenericSystem(_swigobj,_swigarg0)  (_swigobj->makeGenericSystem(_swigarg0))
static int _wrap_IBFabric_makeGenericSystem(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_makeGenericSystem { IBFabric * } name ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBFabric_makeGenericSystem(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBFabric_makeSystem(_swigobj,_swigarg0,_swigarg1)  (_swigobj->makeSystem(_swigarg0,_swigarg1))
static int _wrap_IBFabric_makeSystem(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBFabric * _arg0;
    string * _arg1;
    string * _arg2;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_makeSystem { IBFabric * } name type ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  int len;
  static string _arg2_tmp;
  _arg2_tmp = string(Tcl_GetStringFromObj(objv[3],&len));
  _arg2 = &_arg2_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBFabric_makeSystem(_arg0,*_arg1,*_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBFabric_getSystem(_swigobj,_swigarg0)  (_swigobj->getSystem(_swigarg0))
static int _wrap_IBFabric_getSystem(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getSystem { IBFabric * } name ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBFabric_getSystem(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBFabric_getSystemByGuid(_swigobj,_swigarg0)  (_swigobj->getSystemByGuid(_swigarg0))
static int _wrap_IBFabric_getSystemByGuid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBFabric * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getSystemByGuid { IBFabric * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBFabric_getSystemByGuid(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBFabric_getNodeByGuid(_swigobj,_swigarg0)  (_swigobj->getNodeByGuid(_swigarg0))
static int _wrap_IBFabric_getNodeByGuid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    IBFabric * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getNodeByGuid { IBFabric * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)IBFabric_getNodeByGuid(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define IBFabric_getPortByGuid(_swigobj,_swigarg0)  (_swigobj->getPortByGuid(_swigarg0))
static int _wrap_IBFabric_getPortByGuid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBFabric * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getPortByGuid { IBFabric * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBFabric_getPortByGuid(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBFabric_addCable(_swigobj,_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4,_swigarg5,_swigarg6,_swigarg7)  (_swigobj->addCable(_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4,_swigarg5,_swigarg6,_swigarg7))
static int _wrap_IBFabric_addCable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _arg0;
    string * _arg1;
    string * _arg2;
    string * _arg3;
    string * _arg4;
    string * _arg5;
    string * _arg6;
    IBLinkWidth * _arg7 = &DefaultLinkWidth;
    IBLinkSpeed * _arg8 = &DefaultLinkSpeed;
    Tcl_Obj * tcl_result;
    IBLinkWidth  temp1;
    IBLinkSpeed  temp2;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 8) || (objc > 10)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_addCable { IBFabric * } t1 n1 p1 t2 n2 p2 ?width? ?speed? ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  int len;
  static string _arg2_tmp;
  _arg2_tmp = string(Tcl_GetStringFromObj(objv[3],&len));
  _arg2 = &_arg2_tmp;
}
{
  int len;
  static string _arg3_tmp;
  _arg3_tmp = string(Tcl_GetStringFromObj(objv[4],&len));
  _arg3 = &_arg3_tmp;
}
{
  int len;
  static string _arg4_tmp;
  _arg4_tmp = string(Tcl_GetStringFromObj(objv[5],&len));
  _arg4 = &_arg4_tmp;
}
{
  int len;
  static string _arg5_tmp;
  _arg5_tmp = string(Tcl_GetStringFromObj(objv[6],&len));
  _arg5 = &_arg5_tmp;
}
{
  int len;
  static string _arg6_tmp;
  _arg6_tmp = string(Tcl_GetStringFromObj(objv[7],&len));
  _arg6 = &_arg6_tmp;
}
    if (objc >8) {
{
  temp1 = char2width(Tcl_GetStringFromObj(objv[8],NULL));
  _arg7 = &temp1;
}
    }
    if (objc >9) {
{
  temp2 = char2speed(Tcl_GetStringFromObj(objv[9],NULL));
  _arg8 = &temp2;
}
    }
{
  ibdm_tcl_error = 0;
      IBFabric_addCable(_arg0,*_arg1,*_arg2,*_arg3,*_arg4,*_arg5,*_arg6,*_arg7,*_arg8);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBFabric_parseCables(_swigobj,_swigarg0)  (_swigobj->parseCables(_swigarg0))
static int _wrap_IBFabric_parseCables(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parseCables { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parseCables(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_parseTopology(_swigobj,_swigarg0)  (_swigobj->parseTopology(_swigarg0))
static int _wrap_IBFabric_parseTopology(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parseTopology { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parseTopology(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_addLink(_swigobj,_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4,_swigarg5,_swigarg6,_swigarg7,_swigarg8,_swigarg9,_swigarg10,_swigarg11,_swigarg12,_swigarg13,_swigarg14,_swigarg15,_swigarg16,_swigarg17,_swigarg18,_swigarg19,_swigarg20,_swigarg21,_swigarg22,_swigarg23,_swigarg24,_swigarg25)  (_swigobj->addLink(_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4,_swigarg5,_swigarg6,_swigarg7,_swigarg8,_swigarg9,_swigarg10,_swigarg11,_swigarg12,_swigarg13,_swigarg14,_swigarg15,_swigarg16,_swigarg17,_swigarg18,_swigarg19,_swigarg20,_swigarg21,_swigarg22,_swigarg23,_swigarg24,_swigarg25))
static int _wrap_IBFabric_addLink(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    int  _arg2;
    uint64_t * _arg3;
    uint64_t * _arg4;
    uint64_t * _arg5;
    int  _arg6;
    int  _arg7;
    int  _arg8;
    string * _arg9;
    int  _arg10;
    int  _arg11;
    int  _arg12;
    string * _arg13;
    int  _arg14;
    uint64_t * _arg15;
    uint64_t * _arg16;
    uint64_t * _arg17;
    int  _arg18;
    int  _arg19;
    int  _arg20;
    string * _arg21;
    int  _arg22;
    int  _arg23;
    int  _arg24;
    IBLinkWidth * _arg25 = &DefaultLinkWidth;
    IBLinkSpeed * _arg26 = &DefaultLinkSpeed;
    Tcl_Obj * tcl_result;
    int tempint;
    uint64_t  temp;
    uint64_t  temp0;
    uint64_t  temp1;
    uint64_t  temp2;
    uint64_t  temp3;
    uint64_t  temp4;
    IBLinkWidth  temp10;
    IBLinkSpeed  temp20;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 26) || (objc > 28)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_addLink { IBFabric * } type1 numPorts1 sysGuid1 nodeGuid1 portGuid1 vend1 devId1 rev1 desc1 hcaIdx1 lid1 portNum1 type2 numPorts2 sysGuid2 nodeGuid2 portGuid2 vend2 devId2 rev2 desc2 hcaIdx2 lid2 portNum2 ?width? ?speed? ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
{
  temp = strtoull(Tcl_GetStringFromObj(objv[4],NULL), NULL,16);
  _arg3 = &temp;
}
{
  temp0 = strtoull(Tcl_GetStringFromObj(objv[5],NULL), NULL,16);
  _arg4 = &temp0;
}
{
  temp1 = strtoull(Tcl_GetStringFromObj(objv[6],NULL), NULL,16);
  _arg5 = &temp1;
}
    if (Tcl_GetIntFromObj(interp,objv[7],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg6 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[8],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg7 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[9],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg8 = (int ) tempint;
{
  int len;
  static string _arg9_tmp;
  _arg9_tmp = string(Tcl_GetStringFromObj(objv[10],&len));
  _arg9 = &_arg9_tmp;
}
    if (Tcl_GetIntFromObj(interp,objv[11],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg10 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[12],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg11 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[13],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg12 = (int ) tempint;
{
  int len;
  static string _arg13_tmp;
  _arg13_tmp = string(Tcl_GetStringFromObj(objv[14],&len));
  _arg13 = &_arg13_tmp;
}
    if (Tcl_GetIntFromObj(interp,objv[15],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg14 = (int ) tempint;
{
  temp2 = strtoull(Tcl_GetStringFromObj(objv[16],NULL), NULL,16);
  _arg15 = &temp2;
}
{
  temp3 = strtoull(Tcl_GetStringFromObj(objv[17],NULL), NULL,16);
  _arg16 = &temp3;
}
{
  temp4 = strtoull(Tcl_GetStringFromObj(objv[18],NULL), NULL,16);
  _arg17 = &temp4;
}
    if (Tcl_GetIntFromObj(interp,objv[19],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg18 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[20],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg19 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[21],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg20 = (int ) tempint;
{
  int len;
  static string _arg21_tmp;
  _arg21_tmp = string(Tcl_GetStringFromObj(objv[22],&len));
  _arg21 = &_arg21_tmp;
}
    if (Tcl_GetIntFromObj(interp,objv[23],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg22 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[24],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg23 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[25],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg24 = (int ) tempint;
    if (objc >26) {
{
  temp10 = char2width(Tcl_GetStringFromObj(objv[26],NULL));
  _arg25 = &temp10;
}
    }
    if (objc >27) {
{
  temp20 = char2speed(Tcl_GetStringFromObj(objv[27],NULL));
  _arg26 = &temp20;
}
    }
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_addLink(_arg0,*_arg1,_arg2,*_arg3,*_arg4,*_arg5,_arg6,_arg7,_arg8,*_arg9,_arg10,_arg11,_arg12,*_arg13,_arg14,*_arg15,*_arg16,*_arg17,_arg18,_arg19,_arg20,*_arg21,_arg22,_arg23,_arg24,*_arg25,*_arg26);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_parseSubnetLinks(_swigobj,_swigarg0)  (_swigobj->parseSubnetLinks(_swigarg0))
static int _wrap_IBFabric_parseSubnetLinks(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parseSubnetLinks { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parseSubnetLinks(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_parseFdbFile(_swigobj,_swigarg0)  (_swigobj->parseFdbFile(_swigarg0))
static int _wrap_IBFabric_parseFdbFile(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parseFdbFile { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parseFdbFile(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_parseMCFdbFile(_swigobj,_swigarg0)  (_swigobj->parseMCFdbFile(_swigarg0))
static int _wrap_IBFabric_parseMCFdbFile(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parseMCFdbFile { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parseMCFdbFile(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_setLidPort(_swigobj,_swigarg0,_swigarg1)  (_swigobj->setLidPort(_swigarg0,_swigarg1))
static int _wrap_IBFabric_setLidPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _arg0;
    unsigned int  _arg1;
    IBPort * _arg2;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_setLidPort { IBFabric * } lid p_port ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[3], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[3]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg2 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[3],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      IBFabric_setLidPort(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBFabric_getPortByLid(_swigobj,_swigarg0)  (_swigobj->getPortByLid(_swigarg0))
static int _wrap_IBFabric_getPortByLid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getPortByLid { IBFabric * } lid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBFabric_getPortByLid(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBFabric_dumpTopology(_swigobj,_swigarg0,_swigarg1)  (_swigobj->dumpTopology(_swigarg0,_swigarg1))
static int _wrap_IBFabric_dumpTopology(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    char * _arg1;
    char * _arg2;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_dumpTopology { IBFabric * } fileName ibnlDir ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    if ((_arg2 = Tcl_GetStringFromObj(objv[3], &templength)) == NULL) return TCL_ERROR;
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_dumpTopology(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBFabricMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBFabric methods : { dump cget configure makeNode getNode getNodesByType makeGenericSystem makeSystem getSystem getSystemByGuid getNodeByGuid getPortByGuid addCable parseCables parseTopology addLink parseSubnetLinks parseFdbFile parseMCFdbFile setLidPort getPortByLid dumpTopology  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBFabric_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"makeNode") == 0) {
        cmd = _wrap_IBFabric_makeNode;
    }    else if (strcmp(_str,"getNode") == 0) {
        cmd = _wrap_IBFabric_getNode;
    }    else if (strcmp(_str,"getNodesByType") == 0) {
        cmd = _wrap_IBFabric_getNodesByType;
    }    else if (strcmp(_str,"makeGenericSystem") == 0) {
        cmd = _wrap_IBFabric_makeGenericSystem;
    }    else if (strcmp(_str,"makeSystem") == 0) {
        cmd = _wrap_IBFabric_makeSystem;
    }    else if (strcmp(_str,"getSystem") == 0) {
        cmd = _wrap_IBFabric_getSystem;
    }    else if (strcmp(_str,"getSystemByGuid") == 0) {
        cmd = _wrap_IBFabric_getSystemByGuid;
    }    else if (strcmp(_str,"getNodeByGuid") == 0) {
        cmd = _wrap_IBFabric_getNodeByGuid;
    }    else if (strcmp(_str,"getPortByGuid") == 0) {
        cmd = _wrap_IBFabric_getPortByGuid;
    }    else if (strcmp(_str,"addCable") == 0) {
        cmd = _wrap_IBFabric_addCable;
    }    else if (strcmp(_str,"parseCables") == 0) {
        cmd = _wrap_IBFabric_parseCables;
    }    else if (strcmp(_str,"parseTopology") == 0) {
        cmd = _wrap_IBFabric_parseTopology;
    }    else if (strcmp(_str,"addLink") == 0) {
        cmd = _wrap_IBFabric_addLink;
    }    else if (strcmp(_str,"parseSubnetLinks") == 0) {
        cmd = _wrap_IBFabric_parseSubnetLinks;
    }    else if (strcmp(_str,"parseFdbFile") == 0) {
        cmd = _wrap_IBFabric_parseFdbFile;
    }    else if (strcmp(_str,"parseMCFdbFile") == 0) {
        cmd = _wrap_IBFabric_parseMCFdbFile;
    }    else if (strcmp(_str,"setLidPort") == 0) {
        cmd = _wrap_IBFabric_setLidPort;
    }    else if (strcmp(_str,"getPortByLid") == 0) {
        cmd = _wrap_IBFabric_getPortByLid;
    }    else if (strcmp(_str,"dumpTopology") == 0) {
        cmd = _wrap_IBFabric_dumpTopology;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-minLid") == 0) {
                    cmd = _wrap_IBFabric_minLid_set;
                }  else if (strcmp(_str,"-maxLid") == 0) {
                    cmd = _wrap_IBFabric_maxLid_set;
                }  else if (strcmp(_str,"-lmc") == 0) {
                    cmd = _wrap_IBFabric_lmc_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -minLid -maxLid -lmc  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -minLid -maxLid -lmc  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-NodeByName") == 0) {
                    cmd = _wrap_IBFabric_NodeByName_get;
                }  else if (strcmp(_str,"-SystemByName") == 0) {
                    cmd = _wrap_IBFabric_SystemByName_get;
                }  else if (strcmp(_str,"-PortByLid") == 0) {
                    cmd = _wrap_IBFabric_PortByLid_get;
                }  else if (strcmp(_str,"-NodeByGuid") == 0) {
                    cmd = _wrap_IBFabric_NodeByGuid_get;
                }  else if (strcmp(_str,"-SystemByGuid") == 0) {
                    cmd = _wrap_IBFabric_SystemByGuid_get;
                }  else if (strcmp(_str,"-PortByGuid") == 0) {
                    cmd = _wrap_IBFabric_PortByGuid_get;
                }  else if (strcmp(_str,"-minLid") == 0) {
                    cmd = _wrap_IBFabric_minLid_get;
                }  else if (strcmp(_str,"-maxLid") == 0) {
                    cmd = _wrap_IBFabric_maxLid_get;
                }  else if (strcmp(_str,"-lmc") == 0) {
                    cmd = _wrap_IBFabric_lmc_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBFabric_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -NodeByName -SystemByName -PortByLid -NodeByGuid -SystemByGuid -PortByGuid -minLid -maxLid -lmc  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -NodeByName -SystemByName -PortByLid -NodeByGuid -SystemByGuid -PortByGuid -minLid -maxLid -lmc  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_IBFabric_NodeByName_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-NodeByName ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_SystemByName_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-SystemByName ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_PortByLid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-PortByLid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_NodeByGuid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-NodeByGuid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_SystemByGuid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-SystemByGuid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_PortByGuid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-PortByGuid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_minLid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-minLid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_maxLid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-maxLid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_lmc_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lmc ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure makeNode getNode getNodesByType makeGenericSystem makeSystem getSystem getSystemByGuid getNodeByGuid getPortByGuid addCable parseCables parseTopology addLink parseSubnetLinks parseFdbFile parseMCFdbFile setLidPort getPortByLid dumpTopology }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBFabricCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBFabric * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBFabric_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBFabric_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBFabric object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBFabricMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


SWIGEXPORT(int,Ibdm_Init)(Tcl_Interp *interp) {
	 if (interp == 0)
		 return TCL_ERROR;
	 SWIG_RegisterType();
	 Tcl_LinkVar(interp, SWIG_prefix "IB_UNKNOWN_NODE_TYPE", (char *) &_wrap_const_IB_UNKNOWN_NODE_TYPE, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "IB_SW_NODE", (char *) &_wrap_const_IB_SW_NODE, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "IB_CA_NODE", (char *) &_wrap_const_IB_CA_NODE, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "FABU_LOG_NONE", (char *) &_wrap_const_FABU_LOG_NONE, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "FABU_LOG_ERROR", (char *) &_wrap_const_FABU_LOG_ERROR, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "FABU_LOG_INFO", (char *) &_wrap_const_FABU_LOG_INFO, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "FABU_LOG_VERBOSE", (char *) &_wrap_const_FABU_LOG_VERBOSE, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "FabricUtilsVerboseLevel", (char *) &FabricUtilsVerboseLevel, TCL_LINK_INT);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmUseInternalLog", _wrap_ibdmUseInternalLog, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmUseCoutLog", _wrap_ibdmUseCoutLog, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmGetAndClearInternalLog", _wrap_ibdmGetAndClearInternalLog, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "new_IBFabric", _wrap_new_IBFabric, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "delete_IBFabric", _wrap_delete_IBFabric, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmAssignLids", _wrap_ibdmAssignLids, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmCalcMinHopTables", _wrap_ibdmCalcMinHopTables, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmCalcUpDnMinHopTbls", _wrap_ibdmCalcUpDnMinHopTbls, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmOsmRoute", _wrap_ibdmOsmRoute, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmEnhancedRoute", _wrap_ibdmEnhancedRoute, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmFatTreeRoute", _wrap_ibdmFatTreeRoute, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmFatTreeAnalysis", _wrap_ibdmFatTreeAnalysis, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmFatTreeRouteByPermutation", _wrap_ibdmFatTreeRouteByPermutation, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmVerifyCAtoCARoutes", _wrap_ibdmVerifyCAtoCARoutes, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmVerifyAllPaths", _wrap_ibdmVerifyAllPaths, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmAnalyzeLoops", _wrap_ibdmAnalyzeLoops, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmFindSymmetricalTreeRoots", _wrap_ibdmFindSymmetricalTreeRoots, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmFindRootNodesByMinHop", _wrap_ibdmFindRootNodesByMinHop, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmRankFabricByRoots", _wrap_ibdmRankFabricByRoots, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmReportNonUpDownCa2CaPaths", _wrap_ibdmReportNonUpDownCa2CaPaths, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmCheckMulticastGroups", _wrap_ibdmCheckMulticastGroups, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmCheckFabricMCGrpsForCreditLoopPotential", _wrap_ibdmCheckFabricMCGrpsForCreditLoopPotential, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmLinkCoverageAnalysis", _wrap_ibdmLinkCoverageAnalysis, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmTraceDRPathRoute", _wrap_ibdmTraceDRPathRoute, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmTraceRouteByMinHops", _wrap_ibdmTraceRouteByMinHops, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmTraceRouteByLFT", _wrap_ibdmTraceRouteByLFT, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmMatchFabrics", _wrap_ibdmMatchFabrics, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmBuildMergedFabric", _wrap_ibdmBuildMergedFabric, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmCongInit", _wrap_ibdmCongInit, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmCongCleanup", _wrap_ibdmCongCleanup, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmCongClear", _wrap_ibdmCongClear, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmCongTrace", _wrap_ibdmCongTrace, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmCongReport", _wrap_ibdmCongReport, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "ibdmCongDump", _wrap_ibdmCongDump, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_LinkVar(interp, SWIG_prefix "ibdmSourceVersion", (char *) &ibdmSourceVersion, TCL_LINK_STRING);


  /* mixing declarations .... */
  {
	 // Register the objects for alternate mangling
    SWIG_AlternateObjMangling["_IBFabric_p"] = &ibdmGetObjTclNameByPtr;
    SWIG_AlternateNameToObj  ["_IBFabric_p"] = &ibdmGetObjPtrByTclName;

    SWIG_AlternateObjMangling["_IBSystem_p"] = &ibdmGetObjTclNameByPtr;
    SWIG_AlternateNameToObj  ["_IBSystem_p"] = &ibdmGetObjPtrByTclName;

    SWIG_AlternateObjMangling["_IBSysPort_p"] = &ibdmGetObjTclNameByPtr;
    SWIG_AlternateNameToObj  ["_IBSysPort_p"] = &ibdmGetObjPtrByTclName;

    SWIG_AlternateObjMangling["_IBNode_p"] = &ibdmGetObjTclNameByPtr;
    SWIG_AlternateNameToObj  ["_IBNode_p"] = &ibdmGetObjPtrByTclName;

    SWIG_AlternateObjMangling["_IBPort_p"] = &ibdmGetObjTclNameByPtr;
    SWIG_AlternateNameToObj  ["_IBPort_p"] = &ibdmGetObjPtrByTclName;
  }

	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_p_remotePort_set", _wrap_IBPort_p_remotePort_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_p_remotePort_get", _wrap_IBPort_p_remotePort_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_p_sysPort_set", _wrap_IBPort_p_sysPort_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_p_sysPort_get", _wrap_IBPort_p_sysPort_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_p_node_set", _wrap_IBPort_p_node_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_p_node_get", _wrap_IBPort_p_node_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_num_set", _wrap_IBPort_num_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_num_get", _wrap_IBPort_num_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_base_lid_set", _wrap_IBPort_base_lid_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_base_lid_get", _wrap_IBPort_base_lid_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_width_set", _wrap_IBPort_width_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_width_get", _wrap_IBPort_width_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_speed_set", _wrap_IBPort_speed_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_speed_get", _wrap_IBPort_speed_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_counter1_set", _wrap_IBPort_counter1_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_counter1_get", _wrap_IBPort_counter1_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "new_IBPort", _wrap_new_IBPort, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_guid_get", _wrap_IBPort_guid_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_guid_set", _wrap_IBPort_guid_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_getName", _wrap_IBPort_getName, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_connect", _wrap_IBPort_connect, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBPort_disconnect", _wrap_IBPort_disconnect, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp,SWIG_prefix "IBPort",TclIBPortCmd, (ClientData) NULL, NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_name_set", _wrap_IBNode_name_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_name_get", _wrap_IBNode_name_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_type_set", _wrap_IBNode_type_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_type_get", _wrap_IBNode_type_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_devId_set", _wrap_IBNode_devId_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_devId_get", _wrap_IBNode_devId_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_revId_set", _wrap_IBNode_revId_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_revId_get", _wrap_IBNode_revId_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_vendId_set", _wrap_IBNode_vendId_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_vendId_get", _wrap_IBNode_vendId_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_attributes_set", _wrap_IBNode_attributes_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_attributes_get", _wrap_IBNode_attributes_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_rank_set", _wrap_IBNode_rank_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_rank_get", _wrap_IBNode_rank_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_p_system_get", _wrap_IBNode_p_system_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_p_fabric_get", _wrap_IBNode_p_fabric_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_numPorts_get", _wrap_IBNode_numPorts_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_Ports_get", _wrap_IBNode_Ports_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_MinHopsTable_get", _wrap_IBNode_MinHopsTable_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_LFT_get", _wrap_IBNode_LFT_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_guid_get", _wrap_IBNode_guid_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_guid_set", _wrap_IBNode_guid_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "new_IBNode", _wrap_new_IBNode, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "delete_IBNode", _wrap_delete_IBNode, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_makePort", _wrap_IBNode_makePort, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_getPort", _wrap_IBNode_getPort, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_setHops", _wrap_IBNode_setHops, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_getHops", _wrap_IBNode_getHops, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_getFirstMinHopPort", _wrap_IBNode_getFirstMinHopPort, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_setLFTPortForLid", _wrap_IBNode_setLFTPortForLid, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_getLFTPortForLid", _wrap_IBNode_getLFTPortForLid, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBNode_repHopTable", _wrap_IBNode_repHopTable, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp,SWIG_prefix "IBNode",TclIBNodeCmd, (ClientData) NULL, NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSysPort_name_set", _wrap_IBSysPort_name_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSysPort_name_get", _wrap_IBSysPort_name_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSysPort_p_remoteSysPort_set", _wrap_IBSysPort_p_remoteSysPort_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSysPort_p_remoteSysPort_get", _wrap_IBSysPort_p_remoteSysPort_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSysPort_p_system_set", _wrap_IBSysPort_p_system_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSysPort_p_system_get", _wrap_IBSysPort_p_system_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSysPort_p_nodePort_set", _wrap_IBSysPort_p_nodePort_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSysPort_p_nodePort_get", _wrap_IBSysPort_p_nodePort_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "new_IBSysPort", _wrap_new_IBSysPort, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "delete_IBSysPort", _wrap_delete_IBSysPort, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSysPort_connect", _wrap_IBSysPort_connect, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSysPort_disconnect", _wrap_IBSysPort_disconnect, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp,SWIG_prefix "IBSysPort",TclIBSysPortCmd, (ClientData) NULL, NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_name_set", _wrap_IBSystem_name_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_name_get", _wrap_IBSystem_name_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_type_set", _wrap_IBSystem_type_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_type_get", _wrap_IBSystem_type_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_p_fabric_set", _wrap_IBSystem_p_fabric_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_p_fabric_get", _wrap_IBSystem_p_fabric_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_NodeByName_get", _wrap_IBSystem_NodeByName_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_PortByName_get", _wrap_IBSystem_PortByName_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "new_IBSystem", _wrap_new_IBSystem, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "delete_IBSystem", _wrap_delete_IBSystem, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_guid_get", _wrap_IBSystem_guid_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_guid_set", _wrap_IBSystem_guid_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_makeSysPort", _wrap_IBSystem_makeSysPort, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_getSysPortNodePortByName", _wrap_IBSystem_getSysPortNodePortByName, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBSystem_getSysPort", _wrap_IBSystem_getSysPort, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp,SWIG_prefix "IBSystem",TclIBSystemCmd, (ClientData) NULL, NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_NodeByName_get", _wrap_IBFabric_NodeByName_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_SystemByName_get", _wrap_IBFabric_SystemByName_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_PortByLid_get", _wrap_IBFabric_PortByLid_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_NodeByGuid_get", _wrap_IBFabric_NodeByGuid_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_SystemByGuid_get", _wrap_IBFabric_SystemByGuid_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_PortByGuid_get", _wrap_IBFabric_PortByGuid_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_minLid_set", _wrap_IBFabric_minLid_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_minLid_get", _wrap_IBFabric_minLid_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_maxLid_set", _wrap_IBFabric_maxLid_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_maxLid_get", _wrap_IBFabric_maxLid_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_lmc_set", _wrap_IBFabric_lmc_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_lmc_get", _wrap_IBFabric_lmc_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_makeNode", _wrap_IBFabric_makeNode, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_getNode", _wrap_IBFabric_getNode, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_getNodesByType", _wrap_IBFabric_getNodesByType, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_makeGenericSystem", _wrap_IBFabric_makeGenericSystem, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_makeSystem", _wrap_IBFabric_makeSystem, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_getSystem", _wrap_IBFabric_getSystem, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_getSystemByGuid", _wrap_IBFabric_getSystemByGuid, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_getNodeByGuid", _wrap_IBFabric_getNodeByGuid, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_getPortByGuid", _wrap_IBFabric_getPortByGuid, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_addCable", _wrap_IBFabric_addCable, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_parseCables", _wrap_IBFabric_parseCables, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_parseTopology", _wrap_IBFabric_parseTopology, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_addLink", _wrap_IBFabric_addLink, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_parseSubnetLinks", _wrap_IBFabric_parseSubnetLinks, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_parseFdbFile", _wrap_IBFabric_parseFdbFile, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_parseMCFdbFile", _wrap_IBFabric_parseMCFdbFile, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_setLidPort", _wrap_IBFabric_setLidPort, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_getPortByLid", _wrap_IBFabric_getPortByLid, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "IBFabric_dumpTopology", _wrap_IBFabric_dumpTopology, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp,SWIG_prefix "IBFabric",TclIBFabricCmd, (ClientData) NULL, NULL);
/*
 * These are the pointer type-equivalency mappings.
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_IBPort","_class_IBPort",0);
	 SWIG_RegisterMapping("_IBSystem","_class_IBSystem",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_class_IBPort","_IBPort",0);
	 SWIG_RegisterMapping("_class_IBFabric","_IBFabric",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_IBSysPort","_class_IBSysPort",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_IBNode","_class_IBNode",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_class_IBSysPort","_IBSysPort",0);
	 SWIG_RegisterMapping("_class_IBSystem","_IBSystem",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
	 SWIG_RegisterMapping("_class_IBNode","_IBNode",0);
	 SWIG_RegisterMapping("_IBFabric","_class_IBFabric",0);
	 return TCL_OK;
}
