
#include <stdlib.h>
#include <stdio.h>

#ifndef __USE_BSD
#define __USE_BSD
#endif

#include <string.h>

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN
/* #include <winsock2.h> */
#include <winsock.h>
#include <mmsystem.h>
#include <fcntl.h>
#include <io.h>
#include <direct.h>
#include <process.h>
#include <winbase.h>
#else /*  *NIX  */
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <stdarg.h>
#include <signal.h>
#include <ctype.h>
#include <stdarg.h>
#include <time.h>
#include <errno.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <unistd.h>
#endif /* !win32 */

#ifndef _WIN32
struct timeval lastint, shoutstart;
#endif /* !win32 */

#include "util.h"
#include "shout.h"

/* 
 * Returns milliseconds no matter what. screw microseconds, 
 * really don't need it that bad.
 */
my_long_t
my_get_time ()
{
#ifdef _WIN32
	return (timeGetTime ());
#else /* *nix */
	my_long_t seconds, usec_thing, ret = 0;
	struct timeval mtv;

	gettimeofday (&mtv, NULL);
	seconds = (my_long_t) mtv.tv_sec
		- (my_long_t) shoutstart.tv_sec;
	usec_thing = ((my_long_t) mtv.tv_usec -
		      (my_long_t) shoutstart.tv_usec) / 1000;

	return ((my_long_t) (seconds * (my_long_t) 1000)+ usec_thing);

#endif /* _win32 */
}

void
my_sleep (my_long_t thislong)
{
#if defined(HAVE_NANOSLEEP) || defined(USE_NANOSLEEP)
	struct timespec req, rem;
	long nanoseconds = thislong * 1000;


	if (nanoseconds > 999999999)
	{
		req.tv_sec  = nanoseconds/1000000000;
		req.tv_nsec = nanoseconds%1000000000;
	} else {
		req.tv_sec  = 0;
		req.tv_nsec = nanoseconds;
	}
	nanosleep (&req, &rem);
#elif HAVE_SELECT 
	struct timeval sleeper;
	sleeper.tv_sec = 0;
	sleeper.tv_usec = thislong;
	select (1, NULL, NULL, NULL, &sleeper);
#elif _WIN32
    Sleep (thislong/1000);
#else
	usleep (thislong);
#endif
}


char *
get_file (const char *filename, int type, int flags) {
	char *path_and_file;
	extern set_t set;

	path_and_file = malloc( sizeof(char) * BUFSIZE);

	if(!filename) {
		scream(TOERROR, "Error: get_file() called with null pointer\n");
		return NULL;
	}

	switch(type) {
		case conf_file_e:
			sprintf(path_and_file, "%s%c%s", set.etcdir, DELIMITER, filename);
			break;
		case log_file_e:
			sprintf(path_and_file, "%s%c%s", set.logdir, DELIMITER, filename);
			break;
		default: 
			sprintf(path_and_file, "%s", filename);
	}

	if (access (path_and_file, flags) == 0) {
		return strdup (path_and_file);
	}

	switch(type) {
		case conf_file_e:
			sprintf(path_and_file, ".%c%s%c%s", DELIMITER, "etc", DELIMITER, filename);
			break;
		case log_file_e:
			sprintf(path_and_file, ".%c%s%c%s", DELIMITER, "log", DELIMITER, filename);
			break;
		default:
			sprintf(path_and_file, "%s", filename);
	}

	if (access (path_and_file, flags) == 0) {
		return strdup (path_and_file);
	}

	return NULL;
}

void *
n_malloc (int size, int line)
{
	void *m;

	if (size <= 0) {
		fprintf (stderr, "Invalid malloc size!\n");
		return NULL;
	}
	m = malloc (size);

	if (!m) {
		fprintf (stderr, "Could not allocate %d bytes\n", size);
		return NULL;
	}
#ifdef DEBUG_ALLOC
	scream (VERBOSE, "Allocating %d bytes [%p] on line %d\n", size, m, line);
#endif

	return m;
}

void
n_free (void *ptr, int line)
{
#ifdef DEBUG_ALLOC
	SCREAM (VERBOSE, "Freeing [%p] on line %d\n", ptr, line);
#endif
	free (ptr);
}



#ifdef _WIN32
const char *
desc_priorityclass (DWORD class)
{
	switch (class) {
		case NORMAL_PRIORITY_CLASS:
			return "NORMAL_PRIORITY";
		case IDLE_PRIORITY_CLASS:
			return "IDLE_PRIORITY";
		case HIGH_PRIORITY_CLASS:
			return "HIGH_PRIORITY";
		case REALTIME_PRIORITY_CLASS:
			return "REALTIME_PRIORITY";
		default:
			return "UNKNOWN_PRIORITY";
	}
}
#endif /* win32 */

#include "util.h"


char *
splitc (char *first, char *rest, const char divider)
{
	char *p;

	p = strchr (rest, divider);
	if (p == NULL) {
		if ((first != rest) && (first != NULL))
			first[0] = 0;
		return NULL;
	}
	*p = 0;
	if (first != NULL)
		strcpy (first, rest);
	if (first != rest)
		strcpy (rest, p + 1);
	return rest;
}
