/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _IFPGUIVIEW_H_
#define _IFPGUIVIEW_H_

#include <qwidget.h>
#include <qsplitter.h>

#include "fileviewer.h"
#include "settings.h"
#include "ifptoolbar.h"


class QPainter;

/**
 * This is the main view class for ifpGUI.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * @short Main view
 * @author Jim Campbell <ifpgui@gmail.com>
 * @version 0.1
 */
class ifpGUIView : public QWidget
{
    Q_OBJECT
public:
   ifpGUIView(QMainWindow *parent);
   ~ifpGUIView();

   int updateStatus(void);
   void showToolbar();
   void hideToolbar();
   void showToolbarText();
   void hideToolbarText();
   bool isProcessing();
   Settings *guiSettings;

public slots:
   void uploadPlaylist(void);
   void uploadSelectedFile(void);
   void downloadSelectedFile(void);
   void deleteSelectedFile(void);
   int  getBatteryStatus();
   QString getFirmwareRev();
   QString getifpType();
   int  getCapacity();
   int  getFreeSpace();
   void formatIfpDevice();
   void UpdateFirware();
   void setRadioFrequency();
   void create_directory();
   void rename_file();
   void delete_file();
   void file_properties();
   void align_horizontal();
   void align_vertical();

signals:
    void signalChangeStatusbar(const QString& text);
    void signalChangeCaption(const QString& text);

private slots:
    void slotSetTitle(const QString& title);


private:
   QMainWindow *parent_window;
   QBoxLayout  *top_layout;
   QSplitter *split;
   int msgflag;
   bool yesAll;
   fileManagerView *dirview;
   fileManagerView *ifpview;
   //DirectoryView *dirview;
   //DirectoryView *ifpview;
   ifpToolsWidget *ifptoolbar;
   bool processingFiles;

   void refreshFileItem(void);
   void unselectAllChildren(QListViewItem *parentItem);
};

#endif // _IFPGUIVIEW_H_
