/***************************************
  $Header: /cvsroot/petscgraphics/illuminator.h,v 1.2 2002/01/15 23:13:05 hazelsct Exp $

  This is the interface for the Illuminator library.
***************************************/

#ifndef ILLUMINATOR_H
#define ILLUMINATOR_H    /*+ To stop multiple inclusions. +*/
#include <petscda.h>

/* Core stuff */
int IllDrawTet (PetscScalar *coords, PetscScalar *vals, PetscScalar isoquant, PetscScalar *color);
int IllDrawHex (PetscScalar *coords, PetscScalar *vals, PetscScalar isoquant, PetscScalar *color);
int IllDraw3DBlock (int xd, int yd, int zd, int xs, int ys, int zs, int xm,
		    int ym, int zm, PetscScalar *minmax, PetscScalar *vals, int skip,
		    int n_quants, PetscScalar *isoquants, PetscScalar *colors);

/* PETSc stuff */
int DATriangulate (DA theda, Vec X, int this, PetscScalar *minmax, int n_quants,
		   PetscScalar *isoquants, PetscScalar *colors);
int IllErrorHandler (int id, char *message);

/* Geomview stuff */
int GeomviewBegin (MPI_Comm comm);
int GeomviewEnd (MPI_Comm comm);
int GeomviewDisplayTriangulation (MPI_Comm comm, PetscScalar *minmax, char *name);

#endif /* ILLUMINATOR_H */
