.TH "cm2hmm" 1 "October 2009" "Infernal 1.0.2" "Infernal Manual"

.SH NAME
.TP 
cm2hmm - build a rigorous HMM-based filter from an existing covariance model (CM)

.SH SYNOPSIS
.B cm2hmm
.I cmfile
.I hmmfile
.I background [background parameters]
.I HMMtype
.I optimizer [optimizer parameters]

.SH DESCRIPTION

.B cm2hmm
reads a covariance model (CM) from
.I cmfile,
constructs a hidden-Markov model (HMM) that preserves some
information of the CM
and saves the HMM to
.I hmmfile.
The HMM can be used as a rigorous pre-filtering step to
searching with the CM.

.PP
The CM file must be in the standard format output used by Infernal.


.SH OPTIONS

.TP
.B --help
Print brief help; includes summary of command-line parameters.

.TP
.BI background " [background parameters]"
Select the model of background sequence.
.B uniform
gives all bases equal probability (25%).
.BI gc " <fraction>"
specifies the G+C content.
.I <fraction>
should be a number between 0 and 1.
.BI file " <filename>"
loads the base distribution from a file in a specific format.

.TP
.B HMMtype
Specify the type of HMM to be used; options are
.B compact
and
.B expanded.
Compact-type models are generally faster, but expanded-type
models may provide better filtering.

.TP
.BI optimizer " [optimizer parameters]"
Specify which mathematical optimizer is to be used to create 
the final model.  Currently the only option is
.B cfsqp
which takes two paramters:
.I <B> <C>.
B=0, C=1 are reasonable choices.  (See the CFSQP manual for
further details.)



.SH SEE ALSO

For complete documentation, see the User's Guide (Userguide.pdf) that
came with the distribution; or see the Infernal web page,
http://infernal.janelia.org/.

.SH COPYRIGHT

.nf
Copyright (C) 2009 HHMI Janelia Farm Research Campus.
Freely distributed under the GNU General Public License (GPLv3).
.fi
See the file COPYING that came with the source
for details on redistribution conditions.

.SH AUTHOR

.nf
Eric Nawrocki, Diana Kolbe, and Sean Eddy
HHMI Janelia Farm Research Campus
19700 Helix Drive
Ashburn VA 20147
http://selab.janelia.org/

