// --------------------------------------------------------------------
// Icons used in Ipe
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "images.h"
#include <qpixmap.h>
#include <qbitmap.h>
#include <cstdio>

QPixmap ipeIcon(const char* name)
{
  QPixmap pixmap;
  const QImage &img = qembed_findImage(name);
  QImage imgmask(img.size(), 1, 2, QImage::LittleEndian);
  imgmask.setColor(1, qRgb(0, 0, 0));
  imgmask.setColor(0, qRgb(255, 255, 255));
  QRgb maskColor = img.pixel(0,0);
  for (int y = 0; y < img.height(); ++y) {
    for (int x = 0; x < img.width(); ++x) {
      if (img.pixel(x, y) == maskColor)
	imgmask.setPixel(x, y, 0);
      else
	imgmask.setPixel(x, y, 1);
    }
  }
  QBitmap mask;
  mask.convertFromImage(imgmask, 0);
  pixmap.convertFromImage(img, 0);
  pixmap.setMask(mask);
  return pixmap;
}

QPixmap penguinIcon(int width)
{
  const QImage &img = qembed_findImage("penguins");
  double factor = double(width)/double(img.width());
  int height = int(factor * img.height() + 0.5);
  QPixmap pixmap;
  pixmap.convertFromImage(img.smoothScale(width, height), 0);
  return pixmap;
}

