// -*- C++ -*-
// --------------------------------------------------------------------
// Creating Postscript output
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2005  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPEPSWRITER_H
#define IPEPSWRITER_H

#include "ipebase.h"
#include "ipepage.h"
#include "ipedoc.h"
#include "ipeimage.h"
#include "ipepdfwriter.h"

class IpeDocument;
class IpeFont;

// --------------------------------------------------------------------

class IpePsPainter : public IpePdfPainter {
public:
  IpePsPainter(const IpeStyleSheet *style, IpeStream &stream);
  ~IpePsPainter();

protected:
  virtual void DoDrawPath();
  virtual void DoDrawBitmap(IpeBitmap bitmap);

private:
  void StrokePath();
  void FillPath(bool eoFill, bool preservePath);

private:
  int iImageNumber;
};

// --------------------------------------------------------------------

class IpePsWriter {
public:
  IpePsWriter(IpeTellStream &stream, const IpeDocument *doc, bool noColor);
  ~IpePsWriter();
  bool CreateHeader(IpeString creator, int pno = 0, int vno = 0);
  void CreatePageView(int pno = 0, int vno = 0);
  void CreateXml(IpeString creator, int compressLevel);
  void CreateTrailer();

private:
  void EmbedFont(const IpeFont &font);

private:
  IpeTellStream &iStream;
  const IpeDocument *iDoc;
  bool iNoColor;
};

// --------------------------------------------------------------------
#endif
