// -*- C++ -*-
// --------------------------------------------------------------------
// The reference object
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2007  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPEREF_H
#define IPEREF_H

#include "ipeobj.h"

// --------------------------------------------------------------------

class IpeStyleSheet;

class IPE_EXPORT IpeReference : public IpeObject {
public:
  explicit IpeReference(IpeRepository *rep, const IpeXmlAttributes &attr,
			IpeString data);
  explicit IpeReference(const IpeStyleSheet *sheet, IpeAttribute name);

  IpeReference(const IpeReference &rhs);
  virtual IpeObject *Clone() const;

  virtual IpeReference *AsReference();

  virtual void Accept(IpeVisitor &visitor) const;
  virtual void SaveAsXml(IpePainter &painter, IpeStream &stream,
			 IpeString layer) const;
  virtual void Draw(IpePainter &painter) const;
  virtual void AddToBBox(IpeRect &box, const IpeMatrix &m) const;
  virtual double Distance(const IpeVector &v, const IpeMatrix &m,
			  double bound) const;
  virtual void SnapVtx(const IpeVector &mouse, const IpeMatrix &m,
		       IpeVector &pos, double &bound) const;
  virtual void SnapBnd(const IpeVector &mouse, const IpeMatrix &m,
		       IpeVector &pos, double &bound) const;

  virtual void CheckStyle(const IpeStyleSheet *sheet,
			   IpeAttributeSeq &seq) const;

  //! Return symbolic name.
  inline IpeAttribute Name() const { return iName; }

  //! Return pointer to cached object.
  inline const IpeObject *Object() const { return iObject; }

 private:
  IpeAttribute iName;
  mutable const IpeObject *iObject; // iObject is owned by the style sheet
};

// --------------------------------------------------------------------
#endif
