<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("tech");
commonHeader(_("Computers") ." - " . _("Select Template"));
__("Select from one of the templates below to ease in adding a computer. If you wish to create/modify templates, please go to the setup area.");

PRINT "<br><br>";
$query = "SELECT * FROM templates";

$DB = Config::Database();
$data = $DB->getAll($query);
foreach ($data as $result)
{
  	$ID = $result["ID"];
  	$name = $result["templname"];
  	PRINT '<a href="'
  		.Config::AbsLoc("users/computers-add-form.php?withtemplate=1&ID=$ID")
		."\">$name</a><br>";
}	
commonFooter();

