# Irssi DCC status bar extension
# (C) Ge0rG@ircnet
#
#
# WARNING: This script heavily relies on themes, so you have to add the
# following theme (or a modified version) to the abstracts part of your
# theme file:
#
#  # sep   - Separator between different DCC connections
#  sb_dcc_sep = "%c;%n ";
#  # to    - the main field; gets 4 args, of which you should use two: 
#  #          $0 nick always
#  #          $1 filename always
#  #          $2 nick if you GET, filename if you SEND
#  #          $3 file if you GET, nick if you SEND
#  sb_dcc_to = "$2%c->%n$3%c:%n ";
#  # offer - what you see on a not yet open dcc. $0 is the formatted file size
#  sb_dcc_offer = "$0 offered";
#  # trans - the transmit counter, $0 is transferred, $1 is complete file size
#  sb_dcc_trans = "$0%c/%n$1";
#  # fsize - how to format file sizes, $0 is number, $1 is unit (MB, kB, ...)
#  sb_dcc_fsize = "$0%c$1%n";
#
# Also add somethink like this to your window items in the config file:
#
#  dccstatus = { alignment = "right"; };
#
#
# Changelog
#
# 0.4	first version (cool, eh? ;))
# 0.5	fixed 0.8234523623674373kB formatting bug
# 0.6 (2002-02-05)
#	quickhacked spaces in filenames bug
#	added Changelog
#	listening to 'dcc transfer update' again (why did I remove it?)
# 0.7 (2002-02-20)
#	changed sprintf display to show two digits after the decimal point

$VERSION = "0.7";
%IRSSI = (
    authors     => "Georg Lukas",
    contact     => "georg\@op-co.de",
    name        => "dcc-status",
    description => "adds short dcc send & get report to statusbar",
    license     => "Public Domain",
);

use Irssi;

sub dcc_fsize {
	my ($s) = @_;
	my $a, $b;

	if ($s >= 1024*1024*1024) { $a = $s/1024/1024/1024; $b = "GB"; }
	elsif ($s >= 1024*1024)   { $a = $s/1024/1024; $b = "MB"; }
	elsif ($s >= 1024)        { $a = $s/1024; $b = "kB"; }
	else                      { $a = $s; $b = "B"; }
	$a = sprintf("%.2f", $a);
	return "$a $b";
}

sub dccstatus {
	my ($item, $get_size_only) = @_;
	my @status_list;
	my $dcc_status;
	my $theme = Irssi::current_theme;
	my $exp_flags = Irssi::EXPAND_FLAG_IGNORE_EMPTY | Irssi::EXPAND_FLAG_IGNORE_REPLACES;
	my $sb_dcc_sep, $sb_dcc_to, $sb_dcc_offer, $sb_dcc_trans;

	$sb_dcc_sep = ", " unless ($sb_dcc_sep = $theme->format_expand("{sb_dcc_sep}", $exp_flags));

	foreach my $dcc (Irssi::Irc::dccs()) {
		my $src, $dst, $to, $trans, $size;
		my $stat1, $stat2 = "";
		my $nick = $dcc->{nick};
		my $file = $dcc->{arg};
		$file =~ s/ /\240/g;

		if ($dcc->{type} eq "SEND") {
			$src = $file;
			$dst = $nick;
		} elsif ($dcc->{type} eq "GET") {
			$dst = $file;
			$src = $nick;
		} else { next; }

		$to = $theme->format_expand("{sb_dcc_to ${nick} {${file}} ${src} ${dst}}", $exp_flags);
		$trans = $theme->format_expand("{sb_dcc_fsize "
			. dcc_fsize($dcc->{skipped}+$dcc->{transfd}) . "}", $exp_flags);
		$size = $theme->format_expand("{sb_dcc_fsize "
			. dcc_fsize($dcc->{size}) . "}", $exp_flags);

		$status .= $to;
		if ($dcc->{starttime} > 0) {
			$stat2 = $theme->format_expand("{sb_dcc_trans ${trans} ${size}}", $exp_flags);
		} else {
			$stat2 = $theme->format_expand("{sb_dcc_offer ${size}}", $exp_flags);
			$status .= $dcc->{size};
		}
		push @status_list, $to . $stat2;
	}

	$dcc_status = join($sb_dcc_sep, @status_list);
	$item->default_handler($get_size_only, "{sb ${dcc_status}}", undef, 1);
	#$item->default_handler($get_size_only, "{sb bla}", undef, 1);
}



sub dcc_status_refresh {
	Irssi::statusbar_items_redraw('dccstatus');
}

Irssi::statusbar_item_register('dccstatus', undef, 'dccstatus');
Irssi::statusbars_recreate_items();

Irssi::signal_add('dcc created', 'dcc_status_refresh');
Irssi::signal_add('dcc destroyed', 'dcc_status_refresh');
Irssi::signal_add('dcc connected', 'dcc_status_refresh');
Irssi::signal_add('dcc rejecting', 'dcc_status_refresh');
Irssi::signal_add('dcc closed', 'dcc_status_refresh');
Irssi::signal_add('dcc request', 'dcc_status_refresh');
Irssi::signal_add('dcc transfer update', 'dcc_status_refresh');

