# Operview - reformats some server notices, which may come i.e. from &clients
# or &servers at IRCnet. You can turn the script on/off by toggling variable
# mangle_server_notices.
#
# $Id: operview.pl,v 1.6 2002/03/12 17:55:49 pasky Exp pasky $
#


use strict;

use vars qw ($VERSION %IRSSI $rcsid);

$rcsid = '$Id: operview.pl,v 1.6 2002/03/12 17:55:49 pasky Exp pasky $';
($VERSION) = '$Revision: 1.6 $' =~ / (\d+\.\d+) /;
%IRSSI = (
          name        => 'operview',
          authors     => 'Petr Baudis',
          contact     => 'pasky@ji.cz',
          url         => 'http://pasky.ji.cz/~pasky/dev/irssi/',
          license     => 'GPLv2, not later',
          description => 'Reformats some server notices, which may come i.e. from &clients or &servers at IRCnet. You can turn the script on/off bytoggling variable mangle_server_notices.'
         );

my $mangle_server_notices;


use Irssi;
use Irssi::Irc;


Irssi::theme_register([
  client_connect => '{servernotice $0}Connect    : {nick $[9]1} :: {nickhost $2%R@%n$3} {comment $4} :: $5-',
  client_exit    => '{servernotice $0}Disconnect : {nick $[9]1} :: {nickhost $2%R@%n$3} :: $4-',
  client_nick    => '{servernotice $0}{nick $[9]1} -> {nick $[9]2} :: {nickhost $3%R@%n$4}',
  kills_kill     => '{servernotice $0}Received %gKILL%n {nick $[9]1} ({server $2}) :: $3', # TODO: parse the path? subject to change
  kills_operkill => '{servernotice $0}Received %gKILL%n {nick $[9]1} (%R$2%n) :: $3',
  servers_server => '{servernotice $0}Received %gSERVER%n {server $1} from {server $2} :: %G$3%w {comment $5} $6-',
  servers_squit  => '{servernotice $0}Received %gSQUIT %n {server $1} from {server $2} :: %R$3-%w',
  servers_sserver=> '{servernotice $0}Sending  %gSERVER%n {server $1} :: %G$2%w {comment $4} $5-',
  servers_ssquit => '{servernotice $0}Sending  %gSQUIT %n {server $1} :: %R$2-%w',
]);


sub event_server_notice {
  my ($server, $data, $nick, $address) = @_;
  my ($target, $text) = $data =~ /^(\S*)\s+:(.*)$/;
  my (@text) = split(/ /, $text);

  $mangle_server_notices = Irssi::settings_get_bool("mangle_server_notices");
  return unless ($mangle_server_notices);

  return if ($address or $nick !~ /\./);

  if ($target eq '&CLIENTS') {
    
    if ($text =~ /^Client connecting/) {
      my (@fa) = ($text[2], $text[4], $text[6], $text[7], join(" ", splice(@text, 9)));

      $fa[3] =~ s/^\[(.*)\]$/$1/;
      
      $server->printformat($target, MSGLEVEL_SNOTES, "client_connect",
	$nick, @fa);
      Irssi::signal_stop();

    } elsif ($text =~ /^Client exiting/) {
      my (@fa) = ($text[2], $text[4], $text[6], join(" ", splice(@text, 8)));

      $server->printformat($target, MSGLEVEL_SNOTES, "client_exit",
	$nick, @fa);
      Irssi::signal_stop();

    } elsif ($text =~ /^Nick change/) {
      my (@fa) = ($text[2], $text[4], $text[6], $text[8]);

      $server->printformat($target, MSGLEVEL_SNOTES, "client_nick",
	$nick, @fa);
      Irssi::signal_stop();
    }

  } elsif ($target eq '&KILLS') {

    if ($text =~ /^Received KILL/) {
      my (@fa) = ($text[4], $text[6], join(" ", splice(@text, 8)));

      $fa[0] =~ s/\.$//;
      
      if ($fa[1] =~ /\./) {
        $server->printformat($target, MSGLEVEL_SNOTES, "kills_kill",
                             $nick, @fa);
      } else {
        $server->printformat($target, MSGLEVEL_SNOTES, "kills_operkill",
                             $nick, @fa);
      }
      Irssi::signal_stop();
    }

  } elsif ($target eq '&SERVERS') {

    if ($text =~ /^Received SERVER/) {
      my ($sname) = join(" ", splice(@text, 5));
      my (@fa) = ($text[2], $text[4],
                  $sname =~ /^\((\d+)\s+(\[(.+?)\])?\s*(.*)\)$/);

      $server->printformat($target, MSGLEVEL_SNOTES, "servers_server",
	$nick, @fa);
      Irssi::signal_stop();

    } elsif ($text =~ /^Received SQUIT/) {
      my (@fa) = ($text[2], $text[4], join(" ", splice(@text, 5)));
     
      $fa[2] =~ s/^\((.*)\)$/$1/;
      
      $server->printformat($target, MSGLEVEL_SNOTES, "servers_squit",
	$nick, @fa);
      Irssi::signal_stop();

    } elsif ($text =~ /^Sending SERVER/) {
      my ($sname) = join(" ", splice(@text, 3));
      my (@fa) = ($text[2], $sname =~ /^\((\d+)\s+(\[(.+?)\])?\s*(.*)\)$/);

      $server->printformat($target, MSGLEVEL_SNOTES, "servers_sserver",
	$nick, @fa);
      Irssi::signal_stop();

    } elsif ($text =~ /^Sending SQUIT/) {
      my (@fa) = ($text[2], join(" ", splice(@text, 3)));
     
      $fa[1] =~ s/^\((.*)\)$/$1/;
      
      $server->printformat($target, MSGLEVEL_SNOTES, "servers_ssquit",
	$nick, @fa);
      Irssi::signal_stop();
    }

  }
}


Irssi::signal_add("event notice", "event_server_notice");
Irssi::settings_add_bool("lookandfeel", "mangle_server_notices", 1);


Irssi::print("OperView $VERSION loaded...");
