/* 
    * $id:cal.c - Jalali Calendar
    * Tools for converting Jalali to Gregorian dates and vice-versa.
    * Copyright (C) 2006, 2007 Ashkan Ghassemi 
    * 
    * This program is free software; you can redistribute it and/or modify
    * it under the terms of the GNU General Public License as published by
    * the Free Software Foundation; either version 2 of the License, or
    * (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License along
    * with this program; if not, write to the Free Software Foundation, Inc.,
    * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/ 

#include <time.h>
#include <stdlib.h>
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "../libjalali/jalali.h"
#include "../libjalali/config.h"
#include "macros.h"

#define __W_DEBUG

extern char* jalali_months[] ;
extern char* jalali_days[] ;
extern int  jalali_month_len[] ;

char *week_days_pa_2reductionals[] = { "Sh", "Ys", "Ds", "Ss",
					  "Cs", "Ps", "Ad" } ;
char *week_days_pa_3reductionals[] = { "Shn", "Yks", "Dos", "Ses",
					  "Crs", "Pjs", "Adn" } ;					  
char *week_days_2reductionals[] = { "Sa", "Su", "Mo", "Tu", 
				      "We", "Th", "Fr" } ;
char *week_days_3reductionals[] = { "Sat", "Sun", "Mon", "Tue",
				       "Wed", "Thu", "Fri" } ;

int 
show_month(int dyear, int dmonth, int cday, int x_d, int jf, int pf)
{
    /* checking whether dmonth is illegal or not */
    if ((dmonth > 12 || dmonth < 1))
	return -1 ;
    
    register int i,
	status ;
    
    int el_counter=0,
	flag = 0 ;
    
    int	cyear,
	month_len ;

    j_date jd ;

    /* 
     * It's important to keep bottom steps separated,
     * do not think of ideas like, ow aw, n_days could be
     * added with GRE_JAL_DCONV + 1 instead of being _plus_plused_
     * after applying GRE_JAL_DCONV. Don't think of saving assembly
     * instructions.
     */
    
    long n_days = convert_to_days(dyear, dmonth, 1) ;
    for ( ; ; ) {
	convert_to_jalali(n_days, &jd) ;
	if (jd.day == 1)
	    break ;
	if (jd.day > 15)
	    n_days++ ;
	else
	    n_days-- ;
    }

    /*    
    if (jd.day != 1) {
 	if (jd.day > 15) {
	    n_days+= jalali_month_len[(dmonth==1)?11:dmonth-1]-(jd.day)+1 ;
	    if (is_jleap(dyear-1))
		n_days-- ;
	}
	else
	    n_days-= (jd.day-1) ;
    }
    */

#ifndef __W_DEBUG
    printf("y:%d, m:%d, d:%d, w:%d, j:%d\n", jd.year, jd.month, jd.day, 
	   jd.wday, jd.today) ;
#endif

    /* 
     * Moving cursor to column x, current row and then we print month's 
     * name and year.
     */

    FIX_CURSOR_COLUMN(x_d) ;

    cyear = dyear ;

    if (pf)
	cyear+= PAHLAVI_DIFF ;

    if (!jf) {
	if (!pf)
	    fprintf(stdout, "    %s %d\n", jalali_months[dmonth-1], cyear) ;
	else
	    fprintf(stdout, " %s %d(pa)\n", jalali_months[dmonth-1], cyear) ;
    } else {
	if (!pf)
	    fprintf(stdout, "        %s %d\n", jalali_months[dmonth-1], cyear);
	else
	    fprintf(stdout, "    %s %d(pa)\n", jalali_months[dmonth-1], cyear);
    }
    
    /* 
     * Printing week days, Su, Mo, etc 
     */
    FIX_CURSOR_COLUMN(x_d) ;

    if (!jf) {
	for (i=0; i<=5; i++)
	    fprintf(stdout, "%s ", week_days_2reductionals[i]) ;
    } else {
	for (i=0; i<=5; i++)
	    fprintf(stdout, "%s ", week_days_3reductionals[i]) ;
    }

    /* 
     * Friday is highlighted in red 
     */    
    if (!jf)
	fprintf(stdout, "\033[31m%s\033[0m\n", week_days_2reductionals[6]) ;
    else
	fprintf(stdout, "\033[31m%s\033[0m\n", week_days_3reductionals[6]) ;

    FIX_CURSOR_COLUMN(x_d) ;
    
    
    /*
     * Converting all days of current month into Jalali representation.
     * Note that this piece of code needs a lot of optimization, and it is 
     * currently too dirty and crap-coded. Using escape characters this 
     * hard-wired into code is not good at all, hope to replace it by terminfo 
     * later. But since output is not that important, I left them untouched.
     */

    if (dmonth == 12)
	month_len = (is_jleap(dyear)) ? 30 : 29 ;
    else
	month_len = (jalali_month_len[dmonth-1]) ;
    
    convert_to_jalali(n_days, &jd);

    for (i=0; i<month_len; i++) {
#ifndef __W_DEBUG
	printf("(NOTE)ndays+i=%d\n", n_days+i) ;
	printf("y:%d, m:%d, d:%d, w:%d, j:%d\n", jd.year, jd.month, jd.day, 
	       jd.wday, jd.today) ;
#endif
	if (!flag) {
	    for(status = 0; (status<=6) && (!flag); status++) {	
		if (status == jd.wday) {
		    if (!jf) {
			if (cday == jd.day)
			    fprintf(stdout, "\033[7m%d\033[0m  ", jd.day) ;
			else
			    fprintf(stdout, "%d  ", jd.day) ;
		    } else {
			if (cday == jd.day) {
			    if (jd.today<10)
				fprintf(stdout, "\033[7m%d\033[0m   ", 
					jd.today);
			    else if (jd.today<100)
				fprintf(stdout, "\033[7m%d\033[0m  ", 
					jd.today) ;
			    else 
				fprintf(stdout, "\033[7m%d\033[0m ", 
					jd.today) ;
			} else {
			    if (jd.today<10)
				fprintf(stdout, "%d   ", jd.today) ;
			    else if (jd.today<100)
				fprintf(stdout, "%d  ", jd.today) ;
			    else
				fprintf(stdout, "%d ", jd.today) ;
			}
		    }

		    flag = 1 ;
		    if (jd.wday == 6) {
			el_counter++ ;
			fprintf(stdout, "\n") ;
			FIX_CURSOR_COLUMN(x_d) ;
		    }
		} else {
		    if (!jf)
			fprintf(stdout, "   ") ;
		    else
			fprintf(stdout, "    ") ;
		}
	    }	
	}
	else {
	    if (!jf) {
		if (jd.day > 9) {
		    if (cday == jd.day)
			fprintf(stdout, "\033[7m%d\033[0m ", jd.day) ;
		    else 
			fprintf(stdout, "%d ", jd.day) ;    
		} else {
		    if (cday == jd.day) 
			fprintf(stdout, "\033[7m%d\033[0m  ", jd.day) ;	
		    else 
			fprintf(stdout, "%d  ", jd.day) ;
		}
	    } else {
		if (cday == jd.day) {
		    if (jd.today < 10)
			fprintf(stdout, "\033[7m%d\033[0m   ", jd.today) ;
		    else if (jd.today < 100)
			fprintf(stdout, "\033[7m%d\033[0m  ", jd.today) ;
		    else 
			fprintf(stdout, "\033[7m%d\033[0m ", jd.today) ;
		} else {
		    if (jd.today < 10)
			fprintf(stdout, "%d   ", jd.today) ;
		    else if (jd.today < 100)
			fprintf(stdout, "%d  ", jd.today) ;
		    else 
			fprintf(stdout, "%d ", jd.today) ;
		}
	    }
	    if (jd.wday == 6) {
		el_counter++ ;
	    	fprintf(stdout, "\n") ; 
		FIX_CURSOR_COLUMN(x_d) ;
	    }
	}
	jd.wday++ ;
	jd.wday%=7 ;
	jd.today++ ;
	jd.day++ ;
    }

    /* 
     * Fixing output. Looks stupid, I know I know, _BUT_
     * don't blame it on me, I'm as innocent as St. Mary.
     */

    if (jd.wday != 6) {
	el_counter++ ;
	fprintf(stdout, "\n") ; 
    }

    fprintf(stdout, "\n") ;
    return el_counter ;
}
    
void 
show_current(int jf, int pf) {
    j_date jd ;
    calc_current(&jd) ;
    show_month(jd.year, jd.month, jd.day, 1, jf, pf) ;
}

void 
show_three(int jf, int pf) {
    int yr ;
    j_date jd ;
    calc_current(&jd) ;

    if (jd.month == 1) {
	yr = show_month(jd.year-1, 12, 0, 1, jf, pf) ;
	FIX_CURSOR_ROW(yr+3) ;
    } else {
	yr = show_month(jd.year, (jd.month)-1, 0, 1, jf, pf) ;
	FIX_CURSOR_ROW(yr+3) ;
    }
    
    if (!jf)
	yr = show_month(jd.year, jd.month, jd.day, 23, jf, pf) ;
    else
	yr = show_month(jd.year, jd.month, jd.day, 40, jf, pf) ;
 
        if (jf)
	    fprintf(stdout, "\n") ;
	else
	    FIX_CURSOR_ROW(yr+3) ;
    


    if (jd.month == 12) {
	if (!jf)
	    show_month((jd.year)+1, 1, 0, 45, jf, pf) ;
	else
	    show_month((jd.year)+1, 1, 0, 20, jf, pf) ;
    }
    else {
	if (!jf)
	    show_month(jd.year, (jd.month)+1, 0, 45, jf, pf) ;
	else
	    show_month(jd.year, (jd.month)+1, 0, 33, jf, pf) ;
    }
}

void 
show_whole_year(int dyear, int isc, int jf, int pf) {
    int i,
	yr,
	px=1,
	stepper= (jf) ? 2 : 3 ;

    j_date jd ;

    if (isc)
	calc_current(&jd) ;
    else
	jd.year = dyear ;
    
    for (i=1; i<=12; i++) {
	if (i % stepper != 0) {
	    if (jd.month == i) 
		yr = show_month(jd.year, i, jd.day, px, jf, pf) ;
	    else
		yr = show_month(jd.year, i, 0, px, jf, pf) ;
	    if (!jf)
		px+=22 ;
	    else
		px+=29 ;
	    
	    FIX_CURSOR_ROW(yr+3) ;

	} else {
	    if (jd.month == i) 
		show_month(jd.year, i, jd.day, px, jf, pf) ;
	    else
		show_month(jd.year, i, 0, px, jf, pf) ;
	    px=1 ;
	    fprintf(stdout, "\n") ;
	}
    }    
}

int 
main(int argc, char** argv)
{
    int i,
	j, 
	params[2]= {0},
	n_params = 0, 
	err_flag = 0,
	pahlavi_flag = 0,
	julian_flag = 0,
	wholeyear_flag = 0,
	threemonths_flag = 0,
	currentmonth_flag = 1,
	version_flag = 0,
	temp;
    /* 
     * Current month is about to be printed 
     */
    if (argc<2) {
	show_current(0, 0) ;
	currentmonth_flag = 0 ;
    }
    else {
	for(i=1; i<argc;i++) {
	    temp = atoi(argv[i]) ;
	    
	    /* 
	     * Open - Flag
	     */
	    
	    if ((strstr(argv[i], "-") != NULL) && 
		(strstr(argv[i], "--") == NULL)) {
		if (argv[i][0] != '-') {
		    fprintf(stdout, "%s: invalid option %s\n", 
			    argv[0], argv[i]);
		    break ;
		}
		
		for (j=1; j<strlen(argv[i]); j++) {
		    switch (argv[i][j]) {
		    case SHOW_VERSION:
			currentmonth_flag = 0 ;
			threemonths_flag = 0 ;
			wholeyear_flag = 0 ;
			version_flag = 1 ;
	            case PAHLAVI_FLAG:
			pahlavi_flag = 1 ;
			break ;
		    case JULIAN_FLAG:
			julian_flag = 1 ;
			break ;
		    case WHOLEYEAR_FLAG:
			currentmonth_flag = 0 ;
			threemonths_flag = 0 ;
			wholeyear_flag = 1 ;
			break ;
		    case THREE_MONTHS:
			currentmonth_flag = 0 ;
			threemonths_flag = 1 ;
			wholeyear_flag = 0 ;
			break ;
		    case CURRENT_MONTH:
 			currentmonth_flag = 1 ;
			threemonths_flag = 0 ;
			wholeyear_flag = 0 ;
			break ;
		    default:
 			err_flag = 1 ;
			break ;
		    }
		    if (err_flag)
			break ;
		}
	    } else if (strstr(argv[i], "-") != NULL)
		err_flag = 1 ;

	    if (temp != 0 && n_params<2) {
		params[n_params] = temp ;
		n_params++ ;		
	    }	 
	} 
    }  
    
    if (params[1]<=12 && params[1]>=1 && params[0]>12
	&& n_params == 2) {
	/*
	 * Swaping parameters, I like the masochistic way.
	 */
	params[0] += params[1] ;
	params[1] = params[0] - params[1] ;
	params[0] = params[0] - params[1] ;
    }	

    if (n_params < 3 && n_params > 0 && !err_flag
	&& params[0]>=0 && params[1]>=0) {
    	if (n_params == 2)
	    show_month(params[1], params[0], 0, 1, julian_flag, pahlavi_flag);
	else 
	    show_whole_year(params[0], 0, julian_flag, pahlavi_flag) ;
    }
    else if (!err_flag) {
	if (currentmonth_flag)
	    show_current(julian_flag, pahlavi_flag) ;
	else if (threemonths_flag)
	    show_three(julian_flag, pahlavi_flag) ;
	else if (wholeyear_flag)
	    show_whole_year(0, 1, julian_flag, pahlavi_flag) ;
	else if (version_flag)
	    fprintf(stdout, "Jalali-Calendar version: %s\n", CAL_VERSION) ;
    } else if (err_flag) {
	fprintf(stdout, "%s: invalid option -- %s\n", 
		argv[0], argv[1]) ;
	fprintf(stdout, 
		"usage: %s [-13pjyV] [[month] year]\n",
		argv[0]) ; 
    }
    return 0 ;
}
