#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <cls.h>
#include <method.h>
#include <ui.h>
#include <mvector.h>
#include <methodtime.h>
#include <gtkutils.h>
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <jmp-config.h>

#define BLEN 32
static char buf[BLEN];

static char* get_method_class (method* m) {
    return m->owner->name;
}

static char* get_source_file (method* m) {
    return m->owner->source_name;
}

static char* get_start_line (method* m) {
    snprintf (buf, 32, "%d", m->start_lineno);
    return buf;
}

static char* get_end_line (method* m) {
    snprintf (buf, BLEN, "%d", m->end_lineno);
    return buf;
}

static char* get_secs (method* m) {
    jlong jsec, jnsec, rsec, rnsec; 
    methodtime* mt = method_get_time_used (m);
    methodtime* rt = method_get_restore_time (m);
    jsec = mt->tv / 1000000000ll;
    jnsec = mt->tv % 1000000000ll;
    rsec = rt->tv / 1000000000ll;
    rnsec = rt->tv % 1000000000ll;
    snprintf (buf, BLEN, "%lld.%06lld (%lld.%06lld)", 
	      jsec, jnsec, 
	      rsec, rnsec);
    return buf;
}

static char* get_calls (method* m) {
    snprintf (buf, BLEN, "%ld (%ld)", 
	      method_get_calls (m), 
	      method_get_restore_calls (m));
    return buf;    
}

/** methods used to show a window with method info.. */
void show_method_info (method* m) {
    
    GtkWidget* win;
    GtkWidget* table;

    gchar *labels[] = { _("Class"),
			_("JMP Signature"), 
			_("Method name"), 
			_("Method signature"),
			_("Source file"),
			_("Start line"),
			_("End line"),
			_("secs"),
			_("calls"),
			NULL};
    
    char* ((*mp[])(method* m)) = { get_method_class,
				   method_get_method_jmpname, 
				   method_get_method_name,
				   method_get_method_signature, 
				   get_source_file,
				   get_start_line,
				   get_end_line,
				   get_secs,
				   get_calls,
				   NULL};
        
    win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_object_set_data (GTK_OBJECT (win), "win", win);
    gtk_window_set_title (GTK_WINDOW (win), _("Method info"));

    table = get_table (labels, (tablefunc*)mp, m);
    gtk_container_add (GTK_CONTAINER (win), table);
    gtk_widget_show_all (win);
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
