#include <jmp-config.h>

#include <stdio.h>

#include <gtk/gtk.h>

#include <filter.h>

#include <ui_gtk_gtkutils.h>
#include <ui_gtk_filterconfig.h>

/* Dialog for filter options */
static GtkWidget* dialog;
static GtkListStore* filters_list = NULL;
static GtkWidget* add_mode;
static GtkWidget* add_entry;
static GtkWidget* add_type;

enum {
    OF_INC_EXC,
    OF_NAME,
    OF_TYPE,
    OF_FILTER,
    ONF_COLUMNS
};

/* texts are initialized at runtime for L10N */
static char *filter_mode_text[2];
static char *filter_type_text[4];

/* Called when the close button of the options dialog is pressed */
void filter_close_dialog (GtkWidget *widget, gpointer data) {
    gtk_widget_hide (dialog);
}

static void update_filter_list () {
    GtkTreeIter iter;
    filter_list* fl = get_current_filters ();
    gtk_list_store_clear (filters_list);
    while (fl != NULL) {
	class_filter* filter = get_class_filter (fl);
	gtk_list_store_append (filters_list, &iter);
	gtk_list_store_set (filters_list, &iter,
			    OF_INC_EXC, filter_mode_text[get_inc_or_exc (filter)],
			    OF_NAME, get_filter_name (filter),
			    OF_TYPE, filter_type_text[get_filter_type (filter)],
			    OF_FILTER, filter,
			    -1);
	
	fl = get_next_filter (fl);
    }
}

static void do_remove_filter (GtkWidget *widget, gpointer data) {
    GtkTreeIter iter;
    GtkTreeModel* model;
    GtkTreeSelection* selection = (GtkTreeSelection*)data;
    if (gtk_tree_selection_get_selected (selection, 
					 &model, 
					 &iter))
    {
	class_filter* filter;
	gtk_tree_model_get (model, &iter, 
			    OF_FILTER, &filter, 
			    -1);
	remove_filter (filter);
	update_filter_list ();
    }    
}

static void do_add_filter (GtkWidget *widget, gpointer data) {
    int filter_mode = gtk_option_menu_get_history (GTK_OPTION_MENU (add_mode));
    const gchar* filter_text = gtk_entry_get_text (GTK_ENTRY (add_entry));
    int filter_type = gtk_option_menu_get_history (GTK_OPTION_MENU (add_type));
    filter_add_filter (filter_mode, filter_text, filter_type);
    update_filter_list ();
}

/* Opens a dialog to edit filter options */
void filter_edit_options (void) {
    /* Window already initialized? */
    if (dialog == NULL) {
	int i;
	GtkWidget* b2;
	GtkWidget* b3;
	GtkWidget* tree;
	GtkWidget* w;
	GtkWidget* w2;
	GtkWidget* w3;
	GtkWidget* scroller;
	GtkWidget *b = gtk_vbox_new (FALSE, 5);

	/* initialize the texts here for L10N */
	filter_mode_text[0] = _("Exclude");
	filter_mode_text[1] = _("Include");
	filter_type_text[0] = _("match class");
	filter_type_text[1] = _("match package");
	filter_type_text[2] = _("match recursive");
	filter_type_text[3] = _("match all");
	
	dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (dialog),
			      _("Java Memory Profiler - Filter Options"));
	gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
	gtk_container_set_border_width (GTK_CONTAINER (dialog), 10);
	gtk_container_add (GTK_CONTAINER (dialog), b);		
	w = gtk_frame_new (_("Current filters"));
	gtk_box_pack_start (GTK_BOX (b), w, TRUE, TRUE, 0);
	b2 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (w), b2);
	scroller = gtk_scrolled_window_new (NULL, NULL);
	gtk_box_pack_start (GTK_BOX (b2), scroller, TRUE, TRUE, 0);
	
	filters_list = gtk_list_store_new (ONF_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, 
					   G_TYPE_STRING, G_TYPE_POINTER);
	
	tree = gtk_tree_view_new_with_model (GTK_TREE_MODEL (filters_list));
	add_column (tree, _("MODE"), OF_INC_EXC, (gpointer)0, NULL, 80, 0);
	add_column (tree, _("NAME"), OF_NAME, (gpointer)0, NULL, 200, 0);
	add_column (tree, _("TYPE"), OF_TYPE, (gpointer)0, NULL, 80, 0);
	gtk_tree_view_set_headers_clickable (GTK_TREE_VIEW (tree), FALSE);
	gtk_container_add (GTK_CONTAINER (scroller), tree);
	
	b3 = gtk_hbox_new (FALSE, 0);	
	gtk_box_pack_start (GTK_BOX (b2), b3, FALSE, FALSE, 0);
	w = gtk_button_new_with_label (_("Remove"));
	gtk_signal_connect (GTK_OBJECT (w), "clicked",
			    GTK_SIGNAL_FUNC (do_remove_filter),
			    gtk_tree_view_get_selection (GTK_TREE_VIEW (tree)));
	gtk_box_pack_end (GTK_BOX (b3), w, FALSE, FALSE, 0);	
	
	w = gtk_frame_new (_("Add filter"));
	gtk_box_pack_start (GTK_BOX (b), w, FALSE, FALSE, 0);
	b2 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (w), b2);
	b3 = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (b2), b3);
	
	add_mode = gtk_option_menu_new ();
	gtk_box_pack_start (GTK_BOX (b3), add_mode, FALSE, FALSE, 0);	
	w2 = gtk_menu_new ();
	for (i = 0; i < 2; i++) {
	    w3 = gtk_menu_item_new_with_label (filter_mode_text[i]);
	    gtk_menu_shell_append (GTK_MENU_SHELL (w2), w3);
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (add_mode), w2);
	gtk_option_menu_set_history (GTK_OPTION_MENU (add_mode), 1);
	
	add_entry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (b3), add_entry, TRUE, TRUE, 0);	

	add_type = gtk_option_menu_new ();
	gtk_box_pack_start (GTK_BOX (b3), add_type, FALSE, FALSE, 0);	
	w2 = gtk_menu_new ();
	for (i = 0; i < 4; i++) {
	    w3 = gtk_menu_item_new_with_label (filter_type_text[i]);
	    gtk_menu_shell_append (GTK_MENU_SHELL (w2), w3);
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (add_type), w2);
	gtk_option_menu_set_history (GTK_OPTION_MENU (add_type), 2);
	
	w = gtk_button_new_with_label (_("Add"));
	gtk_signal_connect (GTK_OBJECT (w), "clicked",
			    GTK_SIGNAL_FUNC (do_add_filter),
			    NULL); 
	gtk_box_pack_start (GTK_BOX (b3), w, FALSE, FALSE, 0);	
	
	
	b2 = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (b), b2, FALSE, FALSE, 0);
	w = gtk_button_new_with_label (_("Close"));
	gtk_signal_connect (GTK_OBJECT (w), "clicked",
			    GTK_SIGNAL_FUNC (filter_close_dialog),
			    NULL);	
	gtk_box_pack_end (GTK_BOX (b2), w, FALSE, FALSE, 0);	
	
	gtk_window_set_default_size (GTK_WINDOW (dialog), 500, 300);
    }
    update_filter_list ();
    gtk_widget_show_all (dialog);
}

void filter_destroy () {
    if (dialog) {
	gtk_widget_destroy (dialog);
    }
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
