// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements procedures required to export K-3D objects from the openexr module
		\author Anders Dahnielson (anders@dahnielson.com)
*/

#include <k3dsdk/module.h>

/// Namespace reserved for the openexr plugin module, to protect public symbols from name clashes with other modules
namespace libk3dopenexr
{

extern k3d::iplugin_factory& exr_reader_factory();
extern k3d::iplugin_factory& exr_writer_factory();

} // namespace libk3dopenexr

K3D_MODULE_START(k3d::uuid(0x32567543, 0x3ddc4113, 0xaf186fa6, 0xe050f4fc), Registry)
	Registry.register_factory(libk3dopenexr::exr_reader_factory());
	Registry.register_factory(libk3dopenexr::exr_writer_factory());
K3D_MODULE_END


