/*
    mamerommetadata.h - Extract metadata(information) from MAME.

    Copyright (c) 2006      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "mamerommetadata.h"

// Qt includes
#include <qstringlist.h>

// KDE includes
#include <kstandarddirs.h>
#include <kprocess.h>
#include <kprocio.h>
#include <kdebug.h>

// Local includes
#include "mamesystem.h"

MameRomMetaData::MameRomMetaData()
{}

MameRomMetaData::~MameRomMetaData()
{}

bool MameRomMetaData::canHandle(const QString &path)
{
	KProcIO xmameIO;
	xmameIO << KStandardDirs::findExe( QString::fromLatin1("xmame") ) << "-ik" << path;
	xmameIO.start(KProcess::Block, false);
	
	// Reference output:
	// KNOWN     /roms/mame/contra.zip
	// or
	// UNKNOWN   /roms/snes/Chrono Trigger (U).smc
	QString buffer;
	while( xmameIO.readln(buffer) != -1 )
	{
		if(buffer.startsWith("KNOW"))
		{
			return true;
		}
	}
	return false;
}

Kamefu::RomMetaInformation MameRomMetaData::extractMetaInformation(KFileItem* item)
{
	QStringList readLines;
	QString romName = item->url().fileName();
	// Remove extension from the filename.
	romName = romName.left(romName.findRev("."));
	
	KProcIO xmameIO;
	xmameIO << KStandardDirs::findExe( QString::fromLatin1("xmame") ) << "-lg" << romName;
	xmameIO.start(KProcess::Block, false);
	
	// Reference output:
	// year manufacturer                         name
	// ---- ------------------------------------ --------------------------------
	// 1987 Konami                               Contra (US)
	// 
	// 
	// Total Supported: 4953, Matching "contra": 1

	QString buffer;
	while( xmameIO.readln(buffer) != -1 )
	{
		readLines.append( buffer );
	}
	
	if(readLines.count() > 3)
	{
		Kamefu::RomMetaInformation romMetaData;

		QString requiredLine = readLines[2];
		QString year, developer, name;
		year = requiredLine.mid(0, 4).simplifyWhiteSpace();
		developer = requiredLine.mid(5, 37).simplifyWhiteSpace();
		name = requiredLine.mid(42).simplifyWhiteSpace();
		
		kdDebug() << k_funcinfo << "Read information for MAME rom: " << item->url().path() << endl;
		kdDebug() << "Year: " << year << endl;
		kdDebug() << "Developer: " << developer << endl;
		kdDebug() << "Name: " << name << endl;

		romMetaData.setYear(year);
		romMetaData.setEditor(developer);
		romMetaData.setRomName(name);
		romMetaData.setUrl(item->url().path());
		if( MameSystem::system() )
			romMetaData.setSystem( MameSystem::system()->displayName() );
		else
			romMetaData.setSystem( QString::fromUtf8("Multiple Arcade Machine Emulator") );

		return romMetaData;
	}

	return Kamefu::RomMetaInformation();
}
