/***************************************************************************
                          krule.cpp  -  description
                             -------------------
    begin                : Tue Aug 1 2000
    copyright            : (C) 2000 by Terk Zsolt
    email                : tz124@hszk.bme.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "krule.h"
#include "kgrammar.h"
#include "kplace.h"

#include <iostream.h>

extern KGrammar * gr;
extern bool verbose_flag;

KRule::KRule()
{
  type=Conjunctive;
  style=0;
  specType=0;
  thisDefault=false;
  myDefault=1;
  place=0;

  align=Qt::AlignLeft;
  parameters=0;
  transformers=0;
  initValue=0;
  bossRule=0;
}

KRule::~KRule()
{
}

/* warning! deletes parameter! */
void KRule::addAsNewClause(KRule * other)
{
  if (other -> isSpecial()) other->saveOut();
  if (isSpecial()) saveOut();

  /* If this is conjunctive, has it more than 1 nonterminals on the right side? */
  if (!isDisjunctive() && !(right.count()==1 && right.first()<0))
  {
    int tempNum=gr->getNewNonterminal();
    KRule * tempRule=new KRule();
    tempRule->left=tempNum;
    tempRule->right=right;
    right=QValueList<int>();
    right.append(tempNum);
    gr->addRule(tempRule);
    /* the content becomes the first child */
    if (thisDefault) myDefault=1;
  }
  /* Has the other just a nonterminal? */
  if (other->right.count()==1 && (other->right.first()<0))
  {
    right.append(other->right.first());
    if (other->thisDefault) myDefault=right.count();
    delete other;
  } else
  /* the other is disjunuctive */
  if (other->isDisjunctive())
  {
//    if (other->myDefault) myDefault=right.count();
    right+=other->right;
    delete other;
  }
  else
  /* This rule has one child yet, surely. The other has several.
  But the other must be conjunctive */
  {
    int tempNum=gr->getNewNonterminal();
    right.append(tempNum);
    other->left=tempNum;
    gr->addRule(other);
    /* what about default? */
    if (other->thisDefault) myDefault=right.count();
  }
  setDisjunctive();
}
	
void KRule::append(int s)
{
  if (isSpecial()) saveOut();
  right.append(s);
}
	
void KRule::setDefault()
{
  thisDefault=true;
}
	
QValueList<int> KRule::children()
{
  QValueList<int> ch;
  QValueList<int>::Iterator it;
  for (it=right.begin(); it!=right.end(); ++it)
    if ((*it)<0) ch.append(*it);
  return ch;
}

void KRule::print()
{
  if (!verbose_flag) return;
  cout << gr->getNonterminal(left) << " -> ";
  if (isSpecial()) cout << "@special"; else
  if (isEpsilon()) cout << '@';
  else
  {
    QValueList<int>::Iterator i;
    int num;
    for (num=1, i=right.begin(); i!=right.end(); ++i, ++num)
    {
      if (isDisjunctive() && num!=1)
        cout << " | ";
      if (*i<0)
        cout << gr->getNonterminal(*i) << ' ';
      else
        cout << '"' << gr->getTerminal(*i) << "\" ";
      if (myDefault==num && isDisjunctive()) cout << '!';
    }
  }
  /* extra info */
//  cout << ';' << style << ':' << type << endl;
  cout << ';' << endl;
}

QString KRule::getTitle() {
  return title;
}

QString KRule::getToolTip() {
  return toolTip;
}

QString KRule::getWhatsThis() {
  return whatsThis;
}

void KRule::setTitle(QString * s) {
  title=*s;
}

void KRule::setToolTip(QString * s) {
  toolTip=*s;
}

void KRule::setWhatsThis(QString * s) {
  whatsThis=*s;
}

void KRule::setParams(QList<param_type> * p)
{
  parameters=p;
}

void KRule::setTransformers(QList<param_type> * t)
{
  transformers=t;
}

void KRule::setInitValue(param_type * p)
{
  initValue=p;
}

/* returns the index of the selected item in case of disjunctive rules */
int KRule::whichIsSelected()
{
  if (isDisjunctive())
  {
    if (hasBoss())
      return bossRule->whichIsSelected();
    /**************************************/
    /* determine which choice is selected */
    /**************************************/
    QValueList<int>::Iterator ch;
    int n=1;

    /* a check box controls this disjunction */
    if (isCheckBox())
    {
      int hasEpsilonChild=whichEpsilonChild();
      if (hasEpsilonChild==0) return 1;
      KRule * noEpsRule=gr->getRule(right[2-hasEpsilonChild]);//
//            * epsRule=gr->getRule(right[hasEpsilonChild-1]);

      /* if checkbox exists, choose selected; *
       * if not, choose default               */
      if ( noEpsRule->place && noEpsRule->place->isSelected()
          || !(noEpsRule->place) && (myDefault==3-hasEpsilonChild) )
          return 3-hasEpsilonChild;
        else
          return hasEpsilonChild;
    } else
    if (isTristate())
    {
      KRule * tristateChild=gr->getRule(right[0]);
      if (tristateChild && tristateChild->place)
        /* check box exists */
        return tristateChild->place->getState();
      else
        /* choose default value */
        {
          n=myDefault;
        }
    } else

    /* all children are nonterminals, have radio buttons */
    for (ch=right.begin(), n=1; ch!=right.end(); ++ch, n++)
      if (gr->getRule(*ch))
        /* find selected child */
        if (gr->getRule(*ch)->place && gr->getRule(*ch)->place->isSelected())
          return n;
        /* if place doesn't exist, choose default */
        else if (!(gr->getRule(*ch)->place) && n==myDefault)
          return myDefault;
  }
  return 1;
}

/* the rule evaluates, returns the generated text by subwidgets */
QString KRule::evaluate(bool considerNoEval)
{
  QString result;
  /* check if it is marked not to evaluate */
  if (isNoEval() && considerNoEval) return result;
  /* conjunctive : all children */
  if (isConjunctive())
  {
    QValueList<int>::Iterator ch;
    for (ch=right.begin(); ch!=right.end(); ++ch)
    if ((*ch)>=0)
      result+=gr->getTerminal(*ch);
    else
      if (gr->getRule(*ch))
        result+=gr->getRule(*ch)->evaluate(considerNoEval);
  }
  /* disjunctive: the first selected child */
  if (isDisjunctive())
  {
/*    QValueList<int>::Iterator ch;
    int n=1;

     * a check box controls this disjunction
    if (isCheckBox())
    {
      int hasEpsilonChild=whichEpsilonChild();
      KRule * noEpsRule=gr->getRule(right[2-hasEpsilonChild]),
            * epsRule=gr->getRule(right[hasEpsilonChild-1]);

       * if checkbox exists, choose selected; *
       * if not, choose default
      if ( noEpsRule->place && noEpsRule->place->isSelected()
          || !(noEpsRule->place) && (myDefault==2-hasEpsilonChild) )
          result=noEpsRule->evaluate(considerNoEval);
        else
          result=epsRule->evaluate(considerNoEval);
    } else

    * all children are nonterminals, have radio buttons *
    for (ch=right.begin(), n=1; ch!=right.end(); ++ch, n++)
      if (gr->getRule(*ch))
        * find selected child *
        if (gr->getRule(*ch)->place && gr->getRule(*ch)->place->isSelected())
        {
          result=gr->getRule(*ch)->evaluate(considerNoEval);
          break;
        }
        * if place doesn't exist, choose default *
        else if (!(gr->getRule(*ch)->place) && n==myDefault)
        {
          result=gr->getRule(*ch)->evaluate(considerNoEval);
          break;
        } */
    int ruleNum=whichIsSelected()-1;
    if (ruleNum<0) ruleNum=0;
    if (ruleNum>=right.count()) ruleNum=right.count()-1;
    KRule * selectedRule=gr->getRule(right[ruleNum]);
    if (selectedRule)
      result=selectedRule->evaluate(considerNoEval);
  }
  /* a special */
  if (isSpecial())
    if (place) result=place->evaluate();
    else result=evalSpecial(considerNoEval);

  QString result2;
  param_type * t;
  /* now preform all the transformations */
  if (transformers)
  for (t=transformers->last(); t; t=transformers->prev())
  {
    if (t->type==4) /* substitution */
    {
      substitute(*t->strsData[0], result, *t->strsData[1], result2, t->strsData[2]!=NULL);
      result=result2;
    }
    if (t->type==5) /* translation */
    {
      translate(*t->strsData[0], *t->strsData[1], result, result2);
      result=result2;
    }
  }
  return result;
}

/* find the child for discarding if interpreted as a check box  */
int KRule::whichEpsilonChild()
{
  QValueList<int>::Iterator ch;
  int n=1, hasEpsilonChild=0;
  if (isDisjunctive() && right.count()==2)
  {
    for (ch=right.begin(); ch!=right.end(); ++ch, n++)
      if (gr->getRule(*ch)->isEpsilon()) hasEpsilonChild=n;
    /* if there is no epsilon child, but there is at least a child with no nonterminals */
    n=1;
    if (hasEpsilonChild==0)
      for (ch=right.begin(); ch!=right.end(); ++ch, n++)
//        if (gr->getRule(*ch)->children().count()==0 && gr->getRule(*ch)->isConjunctive())
        if (gr->getRule(*ch)->isSimple())
          hasEpsilonChild=n;
  }
  return hasEpsilonChild;
}

bool KRule::isTristate()
{
  if (isDisjunctive() && children().count()==3)
  {
    if (gr->getRule(right[1])->isSimple() && gr->getRule(right[2])->isSimple())
      return true;
  }
  return false;
}

/* detect is a double disjunction shoulb be treated as a check box */
bool KRule::isCheckBox()
{
  return whichEpsilonChild()!=0;
}

/* Labels for checkboxes usually appear one level higher in grammars.
   Detect it if so, and put labels to the logically correct place. */
void KRule::correctCheckBox()
{
  /* specials beside a check box or radio button should be aligned to the right */
  if (isBeside() && children().count()==1)
  {
    KRule * spec=gr->getRule(children()[0]);
    if (spec && spec->isSpecial()) spec->align=Qt::AlignRight;
  }

  if ((isCheckBox() || isTristate()) && !hasBoss())
  {
    int hasEpsilonChild=whichEpsilonChild();
    KRule * only;
    /* find the only child */
    if (hasEpsilonChild || isTristate())
    {
      if (hasEpsilonChild)
        only=gr->getRule(right[2-hasEpsilonChild]); /* checkboxes */
      else
        only=gr->getRule(right[0]); /* tristates */
      if (only)
      {
        if (only->title.isEmpty()) { only->title=title; title=QString(); only->style|=style & Beside; }
        if (only->toolTip.isEmpty()) { only->toolTip=toolTip; toolTip=QString(); }
        if (only->whatsThis.isEmpty()) { only->whatsThis=whatsThis; whatsThis=QString(); }
      }
    }
  }
}

void KRule::saveOut()
{
  if (isSpecial())
  {
    KRule * save=new KRule();
    save->type=type;              type=Conjunctive;
    save->specType=specType;      specType=0;
    save->parameters=parameters;  parameters=0;
    save->initValue=initValue;    initValue=0;
    /* no style at this phase */
    save->left=gr->getNewNonterminal();
    right.append(save->left);
    gr->addRule(save);
  }
}

/* evaluate special to the default value if no place is present for it */
QString KRule::evalSpecial(bool considerNoEval)
{
  param_type * p=getInitValue();
  QList<param_type> * params=getParams();
  QString result("");
  switch (getSpecType())
  {
    // integer initial value
    case 0: /* @integer */
      if (p && p->type==1) result=QString::number(p->intData);
      else result=QString::number(0);
      break;

    // string initial value
    case 1: /* @string */
    case 3: /* @float */
    case 5: /* @regexp */
    case 6:  /* @infile */
    case 7:  /* @outfile */
    case 8:  /* @directory */
    case 13: /* @edit */
    case 24: /* @password */
      if (p && p->type==0) result= *(p->strData);
      break;

    // initial value choosen from the list
    case 2:  /* @list */
    case 9:  /* @combo */
    case 14: /* @combow */
    {
      int n=0;
      /* which item is initially selected? */
      if (p && p->type==1)
        n=p->intData-1;
      /* split parameters the way every line is a different element in the listbox */
      QStringList lines;
      if (params)
      {
        for (p=params->first(); p; p=params->next())
          if (p->type==0)
            lines+=QStringList::split(QChar('\n'),*(p->strData));
        result=lines[n];
      }
      break;
    }

    // initial value is an other nonterminal
    case 4:  /* @button */
    {
      if (params)
      {
        p=params->first();
        if (p && p->type==2)
          result=gr->getRule(p->intData)->evaluate(considerNoEval);
      }
      break;
    }
    case 27: /* @multicol */
    {
      int n=0;
      /* which item is initially selected? */
      if (p && p->type==1)
        n=p->intData-1;
      /* split parameters the way every line is a different element in the listbox */
      QStringList lines;
      if (params)
      {
        for (p=params->first(); p; p=params->next())
          if (p->type==0)
            lines+=QStringList::split(QChar('\n'),*(p->strData));
        result=lines[n+1]; /* +1: assuming header line */
      }
      break;
    }
    // no evaluation
    case 10: /* @container */
    case 11: /* @close */
    case 12: /* @action */
    case 15: /* @exec */
    case 16: /* @echo */
    case 17: /* @icon */
    case 18: /* @text */
    case 19: /* @execclose */
    case 20: /* @execbuffer */
    case 21: /* @dump */
    case 22: /* @preview */
    case 23: /* @size */
    case 25: /* @fork */
    case 26: /* @fill */
    default:
      break;
  }
  return result;
}

void KRule::setConstraint(KRule * boss)
{
  bossRule=boss;
}