#include <string>
#include <vector>
#include <iostream>
using namespace std;

#include "category.h"
#include "utility.h"
#include "globals.h"

#ifdef KASCADE_BROWSER
#include "currents.h"
#include "parser.h"
#include "navigation.h"
#include "expression.h"
#endif

Category::Category( )
{
    initialize();
}

Category::~Category( )
{
  deleteVecs();
}

void Category::initialize( )
{
    parent = NULL;

    invisible = FALSE;
    realsubcat = FALSE;
    transsummation = FALSE;
    forcevisible = FALSE;

    summation = FALSE;
    mask = FALSE;
    generalization = FALSE;
    selection = FALSE;

#ifdef KASCADE_BROWSER
    visited = FALSE;
    visitationfailed = FALSE;
    expanded = FALSE;
    aliasedsubcats = FALSE;
#endif    

    data1v = 0;
    data2v = 0;
    linkv = 0;
    propv = 0;
    chatv = 0;
    basev = 0;
    discussv = 0;
    faqv = 0;
    subCatv = 0;
    mlistv = 0;
}

void Category::deleteVecs()
{
	if( subCatv && !aliasedsubcats )	
        	for( unsigned int n = 0; n < subCatv->size(); n++ )
            		delete (*subCatv)[n];
	
    	delete subCatv;
    	delete data1v;
    	delete data2v;
    	delete linkv;
    	delete propv;
    	delete chatv;
    	delete basev;
    	delete discussv;
    	delete faqv;
    	delete mlistv;
}

void Category::addSubcat( Category *c )
{
    if( subCatv == 0 )
        subCatv = new vector<Category *>;

    subCatv->push_back( c );
}

Category *Category::addNewCat( string name )
{
    Category *newCat = new Category();
    newCat->name = name;
    newCat->parent = this;

    addSubcat( newCat );
    return newCat;
}
		    
void Category::addParagraph( string &text, string s )
{
	int i;
	while( ( i = s.find( "\\n" ) ) != -1 )
		s.replace( i, 2, "\n" );
	while( ( i = s.find( "\\t" ) ) != -1 )
		s.replace( i, 2, "\t" );

     	if( text == "" )
         	text = s;
     	else
         	text += "\n\n" + s;
}

void Category::addLink( string s )
{
    if( linkv == 0 )
    	linkv = new vector<string>;

    linkv->push_back( s );
}

void Category::addBase( string s )
{
    if( basev == 0 )
        basev = new vector<string>;

    basev->push_back( s );
}

void Category::addChat( string s )
{
    if( chatv == 0 )
        chatv = new vector<string>;

    chatv->push_back( s );
}

void Category::addDiscuss( string s )
{
    if( discussv == 0 )
        discussv = new vector<string>;

    discussv->push_back( s );
}

void Category::addFaq( string s )
{
    if( faqv == 0 )
        faqv = new vector<string>;

    faqv->push_back( s );
}

void Category::addMlist( string s )
{
    if( mlistv == 0 )
        mlistv = new vector<string>;

    mlistv->push_back( s );
}

void Category::addProperty( string p1, string p2 )
{
    if( propv == 0 )
        propv = new vector<string>;

    int inverted = FALSE;

    while( p1[p1.find_first_not_of( ' ' )] == '!' )
    {
        inverted = !inverted;
        p1.erase( 0, 1 );
    }

    if( !inverted )
    {
        propv->push_back( p1 );
        propv->push_back( p2 );
    }
}

#ifdef KASCADE_EDITOR
void Category::operator=(const Category& c)
{
  deleteVecs();
  initialize();

  parent = c.parent;
  name = c.name;
  owner = c.owner;
  email = c.email;
  home = c.home;
  title = c.title;
  info = c.info;
  news = c.news;
  warning = c.warning;
  target = c.target;
  invisible = c.invisible;
  realsubcat = c.realsubcat;
  transsummation = c.transsummation;
  forcevisible = c.forcevisible;
  selection = c.selection;
  summation = c.summation;
  mask = c.mask;
  generalization = c.generalization;

  if (c.subCatv != 0)
  {
    vector<Category*> *scv = c.subCatv;
    for (unsigned int i = 0; i < scv->size(); i++)
      addSubcat((*scv)[i]);
  }
  if (c.data1v != 0)
  {
    vector<string> *d1v = c.data1v;
    for (unsigned int i = 0; i < d1v->size(); i++)
      data1v->push_back((*d1v)[i]);
  }
  if (c.data2v != 0)
  {
    vector<string> *d2v = c.data2v;
    for (unsigned int i = 0; i < d2v->size(); i++)
      data2v->push_back((*d2v)[i]);
  }
  if (c.linkv != 0)
  {
    vector<string> *lv = c.linkv;
    for (unsigned int i = 0; i < lv->size(); i++)
      addLink((*lv)[i]);
  }
  if (c.propv != 0)
  {
    vector<string> *pv = c.propv;
    for (unsigned int i = 0; i < pv->size(); i += 2)
      addProperty((*pv)[i], (*pv)[i + 1]);
  }
  if (c.basev != 0)
  {
    vector<string> *bv = c.basev;
    for (unsigned int i = 0; i < bv->size(); i++)
      addBase((*bv)[i]);
  }
  if (c.chatv != 0)
  {
    vector<string> *cv = c.chatv;
    for (unsigned int i = 0; i < cv->size(); i++)
      addChat((*cv)[i]);
  }
  if (c.discussv != 0)
  {
    vector<string> *dv = c.discussv;
    for (unsigned int i = 0; i < dv->size(); i++)
      addDiscuss((*dv)[i]);
  }
  if (c.faqv != 0)
  {
    vector<string> *fv = c.faqv;
    for (unsigned int i = 0; i < fv->size(); i++)
      addFaq((*fv)[i]);
  }
  if (c.mlistv != 0)
  {
    vector<string> *mv = c.mlistv;
    for (unsigned int i = 0; i < mv->size(); i++)
      addMlist((*mv)[i]);
  }
}
#endif

int Category::subCatExists( string name )
{
    if( subCatv != 0 )
        for( unsigned int n = 0; n < subCatv->size(); n++ )
            if( (*subCatv)[n]->name == name )
                return TRUE;

    return FALSE;
}

void Category::inheritProperties()
{
	Category *parent = this->parent;

	while( parent )
	{
		if( parent->propv )
		{
    			if( propv == 0 )
			        propv = new vector<string>;

			for( unsigned int n = 0; n < parent->propv->size(); n++ )
				propv->push_back( (*(parent->propv))[n] );
		}
		
		if( parent->realsubcat )
			break;

		parent = parent->parent;
	}
		
}

#ifdef KASCADE_BROWSER

int Category::unaryProperty( string property )
{
    if( propv == 0 )
        return FALSE;

    for( int n = 0; n < propv->size(); n += 2 )
        if( ( (*propv)[n] == property ) &&
            ( (*propv)[n+1] == "" ) )
            return TRUE;

    return FALSE;
}

int Category::binaryProperty( string property )
{
    if( propv == 0 )
        return FALSE;

    for( int n = 0; n < propv->size(); n += 2 )
        if( ( (*propv)[n] == property ) &&
            ( (*propv)[n+1] != "" ) )
            return TRUE;

    return FALSE;
}

vector<string> Category::getPropertyValues( string property )
{
    vector<string> valuev;

    if( propv == 0 )
        return valuev;

    for( int n = 0; n < propv->size(); n += 2 )
        if( (*propv)[n] == property )
            valuev.push_back( (*propv)[n+1] );

    return valuev;
}

int Category::empty()
{
    if( !subCatv )
	return TRUE;

    for( unsigned int n = 0; n < subCatv->size(); n++ )
    {
        Category *c = (*subCatv)[n];

        if( !c->generalization &&
	    c->isVisible() ) 
            return FALSE;
    }	

    return TRUE; 
}

void Category::printCategory( )
{
    int depth = 0;

    if( info != "" )
        cout << info << endl << endl;

    if( selectionentered )
        cout << "( selection entered )" << endl;

    cout << debugInfo();

    printOption( owner, depth, "o:" );
    printOption( email, depth, "e:" );
    printOption( home, depth, "h:" );

    cout << "t: " << calcTitle() << endl;

    cout << endl;

    if( subCatv )
        for( unsigned int n = 0; n < subCatv->size(); n++ )
            if( (*subCatv)[n]->isVisible() )
            {
                int maskokay = FALSE;

                if( !maskv.empty() &&
                    (*subCatv)[n]->realsubcat )
                {
                    maskokay = TRUE;

                    for( unsigned int m = 0; m < maskv.size(); m++ )
                        if( !exprTrueForCategory( maskv[m], (*subCatv)[n] ) )
                        {
                            maskokay = FALSE;
                            break;
                        }
                }

		char visited, failed, extension; 
		(*subCatv)[n]->setNavigationFlags( visited, failed, extension );
		
                char c = ' ';
		if( visited ) 
			c = '*';
		else if( failed )
			c = '@';

                cout << n << c << ( maskokay ? "# " : "  " ) << showName( (*subCatv)[n]->name ) << endl;
            }

    if( selectionentered )
    {
	    string title = skippedCat->title;
	    if( title == "" )
		    title = skippedCat->name;

        cout << "generalization: " << title << endl; 
    }
    
    /*cout << "PATH " << cPath;
    if( cPath != aPath ) 
	    cout << " ( " + aPath + " )"; */

    cout << endl << endl;
}

void Category::setNavigationFlags( char &visited, char &failed, char &extension )
{
    	loopCatv.clear();
    	checkingstructure = TRUE;

    	Currents c; c.save();

	extensionlaunched = FALSE;
	int entered = enter( this ) &&
		      checkSelection();		
	
    	visited = entered && 
                  cCategory->visited;
	extension = entered &&
		  extensionlaunched; 
	failed = FALSE;

//	failed = loopCatv[ loopCatv.size()-1 ]->visitationfailed; 	 

    	c.load();
    	checkingstructure = FALSE;
}

int Category::isVisible()
{
        if( invisible )
                return FALSE;

        if( generalization )
        {
                Currents c; c.save();
 		int gencount = stringtoi( (*data1v)[0] );

                checkingstructure = TRUE;
		int entered = enter( this );
                checkingstructure = FALSE;

		if( !entered )
		{
			c.load();
			return TRUE;
		}

		int back = gencount;
		if( !back )
		{
	 		Category *cat = c.c_cCategory; 
			int n = 0;
			do
			{
				cat = cat->parent;
				n++;
			}	
			while( cat && 
			       ( cat != cCategory ) );

			back = cat ? n : 1;       
		}
	
		int genvisible = TRUE;
		if ( backptr+1 >= back ) 
                	genvisible = ( backTracev[backptr+1-back].c_cCategory != cCategory ); 
		if( backTracev[backptr].c_cCategory == cCategory )
			genvisible = FALSE; 

                c.load();
                return genvisible;
        }

	if( !( maskv.empty() &&
	       selectionv.empty() ) &&
	    !containsRealSubcats() )
		return FALSE;
	
        return TRUE;
}

int Category::containsRealSubcats( )
{
    if( realsubcat || transsummation || forcevisible || summation || mask || selection )
        return TRUE;

    if( subCatv != 0 )
        for( unsigned int n = 0; n < subCatv->size(); n++ )
            if( (*subCatv)[n]->containsRealSubcats() )
                return TRUE;

    return FALSE;
}

void Category::printOption( string &s, int depth, const string &h )
{
	if( s != "" )
		cout << string( depth, ' ' ) << h << ' ' << s << endl;
}


int Category::hasPropertyWithValue( string property, string op, string value )
{
    if( propv == 0 )
        return FALSE;

    if( op == "!=" )
    {
        for( int n = 0; n < propv->size(); n += 2 )
            if( ( (*propv)[n] == property ) &&
                ( (*propv)[n+1] == value ) )
                return FALSE;
        return TRUE;
    }

    for( int n = 0; n < propv->size(); n += 2 )
        if( (*propv)[n] == property )
        {
            if( ( op == "=" ) &&
                ( (*propv)[n+1] == value ) )
                return TRUE;
            if( ( op == ">" ) &&
                ( stringtoi( (*propv)[n+1] ) > stringtoi( value ) ) )
                return TRUE;
            if( ( op == "<" ) &&
                ( stringtoi( (*propv)[n+1] ) < stringtoi( value ) ) )
                return TRUE;
            if( ( op == "<=" ) &&
                ( stringtoi( (*propv)[n+1] ) <= stringtoi( value ) ) )
                return TRUE;
            if( ( op == ">=" ) &&
                ( stringtoi( (*propv)[n+1] ) >= stringtoi( value ) ) )
                return TRUE;
        }

    return FALSE;
}

string Category::calcTitle()
{
	Category *c = this;
	
	while( ( c->title == "" ) &&
	       c->parent )
		c = c->parent;

	if( c->title == "" )
		return "Untitled";
	return c->title;		
}

string Category::calcOwner()
{
	Category *c = this;
	
	while( ( c->owner == "" ) &&
	       c->parent )
		c = c->parent;

	return c->owner;		
}

string Category::calcHome()
{
	Category *c = this;
	
	while( ( c->home == "" ) &&
	       c->parent )
		c = c->parent;

	return c->home;		
}

string Category::calcEmail()
{
	Category *c = this;
	
	while( ( c->email == "" ) &&
	       c->parent )
		c = c->parent;

	return c->email;		
}

Category *Category::calcChat()
{
	Category *c = this;
	while( ( c->title == "" ) &&
	       !c->chatv &&
	       c->parent )
	       c = c->parent;

	return c;
}
#endif
