#include <string>
#include <vector>
using namespace std;

#include <qwidget.h>
#include <qdialog.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qmultilineedit.h>
#include <qevent.h>
#include <qsocket.h>

class ChatBox : public QDialog
{
	Q_OBJECT

public:
	ChatBox( );
	void join( string, string = "" );
	void disconnect();

	int state;

public slots:
	void textEntered();
	void closeChannel();
	void createPrivateChannel( int );
	void connected();
	void incoming();
	void selected( const QString & );
	void broadcast( string );
	
protected:
	void resizeEvent( QResizeEvent * );

private:
	string user;

	void login( );
	int transmitLine( string );
	void printLine( string, QMultiLineEdit * );
	void processMessage( string, string, string );
	string currentChannel( );
	QMultiLineEdit *currentArea( );
	QWidget *pageForChannel( string );
	QMultiLineEdit *areaForChannel( string );
	string titleForChannel( string );
	string channelForTitle( string );
	string tfc( string );
	int vectorIndex( string );
	int vectorIndex( QWidget * );
	void gotoPage( QWidget * );
	void removePage( QWidget * );
	void removeName( string, string );
	void createChannel( string );
	int tryNickUser();
	void giveOpStatus( string, string, vector<string> & );
	void removeOpStatus( string, string, vector<string> & );

	#define DISCONNECTED 0
	#define CONNECTED 1 
	
	int nicknamenr;
	string autojoin;
	
	QListBox *names;
	QTabWidget *channels;
	QLineEdit *input;
	QPushButton *closeButton;	
	QMultiLineEdit *channel1, *channel2;
	QSocket *socket;
	QMultiLineEdit *sysmsgarea;

	vector<int> joinedv;
	vector<string> channelv;
	vector<QWidget *> pagev;
	vector< vector<string> > namevv;
	vector<string> channelandtitlev; 
};

#define RPL_NAMREPLY "353"
#define ERR_NICKNAMEINUSE "433"
