#include <qdialog.h>
#include <qwidget.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qevent.h>
#include <qlabel.h>

#include "category.h"
#include "mailbox.h"
#include "smtp.h"
#include "globals.h"
#include "preferences.h"

MailBox::MailBox( QWidget *parent ) : QDialog( parent )
{
	setCaption( "Kascade Email Client" );
	resize( 510, 400 );
	setMinimumSize( 350, 200 );

	subjectLabel = new QLabel( this );
	receiverLabel = new QLabel( this );
	receiver = new QLineEdit( this );
	subject = new QLineEdit( this );

	text = new QMultiLineEdit( this );	
	text->setWordWrap( QMultiLineEdit::WidgetWidth );

	receiverLabel->setText( "Receiver(s):" );
	subjectLabel->setText( "Subject(s):" );
	if( cCategory )
		receiver->setText( cCategory->calcEmail().c_str() );

	sendButton = new QPushButton( this );
	sendButton->setText( "Send" );
	QObject::connect( sendButton, SIGNAL( clicked() ), this, SLOT( sendMail() ) );

	setFont( config->emailFont() );
	subject->setFocus();

	show();
}

void MailBox::resizeEvent( QResizeEvent * )
{
	int h = this->height(), w = this->width();

	receiverLabel->setGeometry( 10, 10, 80, 20 );
	subjectLabel->setGeometry( 10, 40, 80, 20 );
	receiver->setGeometry( 90, 10, w-200, 20 );
	subject->setGeometry( 90, 40, w-200, 20 );
	sendButton->setGeometry( w-90, 10, 80, 50 ); 
	text->setGeometry( 10, 70, w-20, h-80 );	
}

void MailBox::sendMail()
{
	close();

	if( receiver->text() == "" )
		return;

	string msg;
	string s;
	
	for( int n = 0; n < text->numLines(); n++ )
	{
		s = (const char *)text->textLine( n );	

		if( s == "" ) 
			s = " ";
	
		if( s == "." )
			s = "..";

		msg += s + "\n";
	}

	msg += "\n\n( This mail was sent using the Kascade Browser )";

	Smtp smtp;
	smtp.sendMail( config->emailAddress(), 
		       (const char *)(receiver->text()),
		       (const char *)(subject->text()),
		       msg );
}

