#include <string>
using namespace std;

#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qevent.h>
#include <qfont.h>

#include "separator.h"
#include "globals.h"
#include "browser.h"

Separator::Separator( QWidget *parent, string text ) : QWidget( parent )
{
	frame = new QFrame( this );
	frame->setFrameStyle( QFrame::HLine | QFrame::Sunken );

	label = new QLabel( this );
	label->setText( text.c_str() );
	label->setAlignment( QLabel::AlignHCenter );
}

void Separator::adjustFont( QFont font )
{
	font.setPointSize( font.pointSize()-1 );
	label->setFont( font );
}

void Separator::resizeEvent( QResizeEvent *event )
{
	frame->setGeometry( 3, 0, event->size().width()-6, 16 );
	label->setGeometry( 13, 0, label->sizeHint().width()+6, 16 );
}
