#include <string>
#include <vector>
using namespace std;

#include <qwidget.h>
#include <qdialog.h>
#include <qmultilineedit.h>
#include <qevent.h>
#include <qfont.h>

#include "sourcebox.h"
#include "parser.h"
#include "globals.h"
#include "utility.h"
#include "preferences.h"
#include "navigation.h"
#include "files.h"

SourceBox::SourceBox() : QDialog()
{
	resize( 500, 400 );
	setMinimumSize( 100, 100 );
	
	source = new QMultiLineEdit( this );
	source->setReadOnly( TRUE );
	source->setWordWrap( QMultiLineEdit::WidgetWidth );
	
	setFont( config->sourceFont() );
}

void SourceBox::update( )
{
	setCaption( fullPath( cPath, cCategory ).c_str() );

	if( ( cPath == path ) && 
	    ( cFile == file ) )
	    	return;
		
	int i;
	cached( cPath, cFile, i );
	
	vector<string> *sourcev = cacheSourcev[i];

	string text;
       	for( unsigned int n = 0; n < sourcev->size(); n++ )
		text += (*sourcev)[n] + "\n";

	source->setText( text.c_str() );	

	path = cPath;
	file = cFile;
}

void SourceBox::renew()
{
	setCaption( fullPath( cPath, cCategory ).c_str() );
	
	source->setText( debugInfo().c_str() );
}

void SourceBox::resizeEvent( QResizeEvent * )
{
	source->setGeometry( 10, 10, this->width()-20, this->height()-20 );
}
